/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportHandler;
import com.openindex.openestate.tool.agency.AgencyExportTable;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportTablePanel.class);
    private static final String TABLE_ID = "AgencyExportTablePanel.Table";
    private final ExportJobListener jobListener;
    private Table table;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private ExportAddAction exportAddAction;
    private ExportAction exportStartAction;

    private AgencyExportTablePanel() {
        this.updateLocalization();
        this.jobListener = new ExportJobListener();
        AgencyExportHandler.addJobListener(this.jobListener);
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.exportStartAction = new ExportAction();
        this.refreshAction = this.createDefaultRefreshAction();
        this.exportAddAction = new ExportAddAction();
        this.showActionsAction = this.createDefaultShowActionsAction(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.exportStartAction)));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.exportAddAction)));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    public static AgencyExportTablePanel createTab() {
        return new AgencyExportTablePanel();
    }

    protected JXTable createTable() {
        this.table = new Table();
        return this.table;
    }

    private void doExportAdd() {
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT)) {
            return;
        }
        new AgencyPlugin.ExportFormAction().actionPerformed(null);
    }

    private void doExportView() {
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.table.convertRowIndexToModel(this.table.getSelectedRow());
        long l = this.table.getExportIdAt(n);
        new AgencyPlugin.ExportFormAction(l).actionPerformed(null);
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"agency.export", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        this.table.editingStopped(new ChangeEvent((Object)this.table));
        this.table.setEnabled(false);
        this.table.clearSelection();
        this.table.clearRows();
        ArrayList<DbAgencyExport> arrayList = new ArrayList<DbAgencyExport>();
        try {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            DbAgencyExport[] dbAgencyExportArray = dbAgencyExportsHandler.getExports(connection);
            dbAgencyExportsHandler.loadExportSettings(connection, dbAgencyExportArray);
            arrayList.addAll(Arrays.asList(dbAgencyExportArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$exportsList;
                {
                    this.val$exportsList = list;
                }

                @Override
                public void run() {
                    try {
                        for (DbAgencyExport dbAgencyExport : this.val$exportsList) {
                            AgencyExportTablePanel.this.table.addRow(new AgencyExportTable.Row(dbAgencyExport));
                        }
                    }
                    finally {
                        AgencyExportTablePanel.this.table.setEnabled(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        int n3;
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n4 : this.table.getSelectedRows()) {
            n3 = this.table.convertRowIndexToModel(n4);
            arrayList.add(this.table.getExportIdAt(n3));
        }
        Object object = new JPopupMenu();
        if (arrayList.size() > 1) {
            long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
            ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportAction(lArray)));
            ((JPopupMenu)object).addSeparator();
            ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportEnableAction(lArray, true)));
            ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportEnableAction(lArray, false)));
            ((JPopupMenu)object).addSeparator();
            ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportSaveAction(lArray)));
        } else {
            int n5 = this.table.convertRowIndexToModel(this.table.getSelectedRow());
            long l = (Long)arrayList.get(0);
            n3 = this.table.isExportEnabledAt(n5) ? 1 : 0;
            Date date = this.table.getLastExportDateAt(n5);
            boolean bl = AgencyExportHandler.isJobRunning(l);
            boolean bl2 = AgencyExportHandler.isJobError(l);
            boolean bl3 = AgencyExportHandler.isJobTransportFailed(l);
            boolean bl4 = AgencyExportHandler.JobState.LOCKED.equals((Object)this.table.getJobStateAt(n5));
            ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportFormAction(l)));
            ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportObjectsAction(l)));
            if (!bl && !bl4) {
                ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportAction(l)));
            }
            if (bl) {
                ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportJobCancelAction(l, true)));
            }
            if (bl3) {
                ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportJobRestartAction(l)));
            }
            if (bl2) {
                ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportJobErrorAction(l)));
            }
            if (!bl) {
                ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportEnableAction(l, n3 == 0)));
            }
            if (bl4) {
                ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportUnlockAction(l)));
            }
            ((JPopupMenu)object).addSeparator();
            if (date != null) {
                ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportViewLogAction(l)));
            }
            ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportSaveAction(l)));
            if (!bl) {
                ((JPopupMenu)object).add((Action)((Object)new AgencyPlugin.ExportRemoveAction(l)));
            }
        }
        ((JPopupMenu)object).show(component, n, n2);
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32);
    }

    protected String getHeaderTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("property exports"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return string;
    }

    public String getTabToolTipText() {
        return I18N.tr("Manage your interfaces for property export.");
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("property exports"));
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
        this.exportAddAction.setEnabled(bl && AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT));
        this.exportStartAction.setEnabled(bl && AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE));
    }

    protected void updateLocalization() {
        super.updateLocalization();
    }

    private class ExportJobListener
    implements AgencyExportHandler.JobListener {
        private ExportJobListener() {
        }

        @Override
        public void jobAdded(AgencyExportHandler.Job job) {
            this.updateJobCell(job.getExportId(), job.getState());
        }

        @Override
        public void jobRemoved(long l) {
            this.updateJobCell(l, null);
        }

        @Override
        public void jobStateChanged(AgencyExportHandler.Job job) {
            AgencyExportTablePanel.this.exportStartAction.updateLocalization();
            this.updateJobCell(job.getExportId(), job.getState());
            if (AgencyExportHandler.JobState.FINISHED.equals((Object)job.getState())) {
                this.updateLastExecutionCell(job.getExportId(), job.getLastExecutionDate());
            }
        }

        @Override
        public void taskMessageChanged(long l, String string) {
            this.updateJobCell(l, null);
        }

        @Override
        public void taskProgressChanged(long l, int n) {
            this.updateJobCell(l, null);
        }

        private void updateJobCell(long l, AgencyExportHandler.JobState jobState) {
            int n = AgencyExportTablePanel.this.table.getRowForExportId(l);
            if (n < 0) {
                return;
            }
            jobState = jobState != null ? jobState : AgencyExportTablePanel.this.table.getJobStateAt(n);
            AgencyExportTablePanel.this.table.setJobStateAt(jobState, n);
            AgencyExportTablePanel.this.table.repaint();
        }

        private void updateLastExecutionCell(long l, Date date) {
            int n = AgencyExportTablePanel.this.table.getRowForExportId(l);
            if (n < 0) {
                return;
            }
            AgencyExportTablePanel.this.table.setLastExportDateAt(date, n);
        }
    }

    private class ExportAction
    extends AgencyPlugin.ExportAction {
        private final Icon defaultIcon;
        private final Icon cancelIcon = ImmoToolEnvironment.getResourceIcon((String)"switch.png", (int)16);

        private ExportAction() {
            this.defaultIcon = ImmoToolEnvironment.getResourceIcon((String)"launch.png", (int)16);
            this.setSmallIcon(this.defaultIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AgencyExportHandler.hasRunningJobs()) {
                super.actionPerformed(actionEvent);
            } else {
                boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to cancel all currently running exports?"), (Component)ImmoToolEnvironment.getFrame());
                if (bl) {
                    AgencyExportHandler.cancelExportJobs(true);
                }
            }
        }

        @Override
        protected void updateLocalization() {
            if (!AgencyExportHandler.hasRunningJobs()) {
                super.updateLocalization();
                this.setSmallIcon(this.defaultIcon);
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("cancel exports")));
                this.setShortDescription(I18N.tr("Cancel all currently running exports."));
                this.setSmallIcon(this.cancelIcon);
            }
        }
    }

    private class Table
    extends AgencyExportTable<AgencyExportTable.Row> {
        public Table() {
            super(AgencyExportTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_REMOVE)) {
                return;
            }
            if (this.getSelectedRowCount() < 1) {
                return;
            }
            int n = this.convertRowIndexToModel(this.getSelectedRow());
            long l = this.getExportIdAt(n);
            new AgencyPlugin.ExportRemoveAction(l).actionPerformed(null);
        }

        protected void doSelect() {
            AgencyExportTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            AgencyExportTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyExportTablePanel.this.doExportView();
        }
    }

    private class ExportAddAction
    extends AbstractI18nAction {
        private ExportAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportTablePanel.this.doExportAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Create a new interface."));
        }
    }
}

