/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.SearchAttribImpl;
import com.openindex.openestate.impl.SearchDateTimeImpl;
import com.openindex.openestate.impl.SearchEqualsImpl;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.SearchMatchesImpl;
import com.openindex.openestate.impl.SearchNumericImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.ComplexLengthAttrib;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.ComplexVolumeAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.utils.EstateTypeMenu;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.CountryObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencySearchCriteriaPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencySearchCriteriaPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencySearchCriteriaPanel.class);
    private final List<TemplateListener> templateListeners = new ArrayList<TemplateListener>();
    private final ArrayList<CriteriaPanel> criteriaPanels = new ArrayList();
    private DbAgencySearch currentSearch = null;
    private JXTitledSeparator formTitle;
    private JComboBox<DbSearch> templateBox;
    private JPanel criteriaContainerPanel;
    private JPopupMenu criteriaMenu;
    private Map<OpenEstateAttrib, JMenuItem> criteriaMenuAttribItems;
    private CriteriaPanel criteriaMenuCallingPanel = null;
    private EstateTypeMenu estateTypeMenu;
    private EstateTypeWidget estateTypeMenuCallingWidget = null;
    private GridBagConstraints constraints;
    private AbstractI18nAction criteriaAddAction;

    public AgencySearchCriteriaPanel() {
        this.build();
    }

    private void addCriteriaPanel(CriteriaPanel criteriaPanel) {
        this.constraints.gridx = 0;
        ++this.constraints.gridy;
        this.criteriaContainerPanel.add((Component)((Object)criteriaPanel), this.constraints);
        this.criteriaPanels.add(criteriaPanel);
        this.updateCriteriaOrderButtons();
    }

    public void addTemplateListener(TemplateListener templateListener) {
        if (templateListener != null) {
            this.templateListeners.add(templateListener);
        }
    }

    private void build() {
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.criteriaAddAction = new CriteriaAddAction();
        this.templateBox = new JComboBox();
        this.templateBox.setRenderer((ListCellRenderer<DbSearch>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<DbSearch>(){

            public void render(DbSearch dbSearch, JLabel jLabel) {
                if (dbSearch != null) {
                    jLabel.setText(StringUtils.abbreviate((String)dbSearch.item.getName(), (int)50));
                } else {
                    jLabel.setText("[ " + I18N.tr("select template") + " ]");
                }
            }
        }));
        this.templateBox.setVisible(false);
        this.templateBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencySearchCriteriaPanel.this.templateBox.isEnabled()) {
                    return;
                }
                DbAgencySearch dbAgencySearch = (DbAgencySearch)((Object)AgencySearchCriteriaPanel.this.templateBox.getSelectedItem());
                if (dbAgencySearch == null) {
                    dbAgencySearch = AgencySearchCriteriaPanel.this.currentSearch;
                }
                try {
                    AgencySearchCriteriaPanel.this.load(dbAgencySearch);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load search form!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                for (TemplateListener templateListener : AgencySearchCriteriaPanel.this.templateListeners) {
                    templateListener.templateSelected(dbAgencySearch);
                }
            }
        });
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (JComponent[])new JComponent[]{this.templateBox, new JButton((Action)this.criteriaAddAction)});
        this.criteriaContainerPanel = new JPanel();
        this.criteriaContainerPanel.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.ipady = 10;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.criteriaContainerPanel, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(Paddings.EMPTY);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setLayout(new BorderLayout(10, 10));
        this.add(jPanel, "North");
        this.add(jScrollPane, "Center");
        this.updateLocalization();
    }

    private void buildCriteriaMenu() {
        String string;
        JMenu jMenu = new JMenu(StringUtils.capitalize((String)I18N.tr("address")));
        jMenu.add(this.createMenuItem(CriteriaType.STREET));
        jMenu.add(this.createMenuItem(CriteriaType.STREET_NR));
        jMenu.add(this.createMenuItem(CriteriaType.POSTAL_CODE));
        jMenu.add(this.createMenuItem(CriteriaType.CITY));
        jMenu.add(this.createMenuItem(CriteriaType.DISTRICT));
        jMenu.add(this.createMenuItem(CriteriaType.REGION));
        jMenu.add(this.createMenuItem(CriteriaType.COUNTRY));
        JMenu jMenu2 = new JMenu(CriteriaType.ESTATE_ATTRIBUTE.getTranslation());
        this.criteriaMenuAttribItems = new EnumMap<OpenEstateAttrib, JMenuItem>(OpenEstateAttrib.class);
        TreeMap<String, OpenEstateAttribGroup> treeMap = new TreeMap<String, OpenEstateAttribGroup>();
        for (OpenEstateAttribGroup object2 : OpenEstateAttribGroup.values()) {
            string = object2.getTranslation();
            treeMap.put(string.toLowerCase().trim(), object2);
        }
        for (OpenEstateAttribGroup openEstateAttribGroup : treeMap.values()) {
            TreeMap<String, OpenEstateAttrib> treeMap2 = new TreeMap<String, OpenEstateAttrib>();
            for (OpenEstateAttrib openEstateAttrib : openEstateAttribGroup.getAttributes()) {
                String string2 = openEstateAttrib.getTranslation();
                treeMap2.put(string2.trim().toLowerCase(), openEstateAttrib);
            }
            JMenu jMenu3 = new JMenu(openEstateAttribGroup.getTranslation());
            jMenu2.add(jMenu3);
            string = null;
            JMenu jMenu4 = null;
            for (String string2 : treeMap2.values()) {
                String string3 = string2.getTranslation().trim().substring(0, 1).toUpperCase();
                if (string == null || !string.equals(string3)) {
                    string = string3;
                    jMenu4 = new JMenu(string3);
                    jMenu3.add(jMenu4);
                }
                JMenuItem jMenuItem = this.createMenuItem(CriteriaType.ESTATE_ATTRIBUTE, (OpenEstateAttrib)string2);
                this.criteriaMenuAttribItems.put((OpenEstateAttrib)string2, jMenuItem);
                jMenu4.add(jMenuItem);
            }
        }
        this.criteriaMenu = new JPopupMenu();
        this.criteriaMenu.add(jMenu);
        this.criteriaMenu.add(jMenu2);
        this.criteriaMenu.add(this.createMenuItem(CriteriaType.ESTATE_ACTION));
        this.criteriaMenu.add(this.createMenuItem(CriteriaType.ESTATE_TYPE));
        this.criteriaMenu.add(this.createMenuItem(CriteriaType.ESTATE_STATUS));
    }

    private void buildTypeMenu() {
        this.estateTypeMenu = new EstateTypeMenu(){

            @Override
            public synchronized void setSelectedType(OpenEstateType openEstateType) {
                super.setSelectedType(openEstateType);
                if (AgencySearchCriteriaPanel.this.estateTypeMenuCallingWidget == null) {
                    return;
                }
                AgencySearchCriteriaPanel.this.estateTypeMenuCallingWidget.setEstateType(openEstateType);
            }
        };
    }

    private CriteriaPanel createCriteriaPanel(List<SearchEqualsImpl> list, SearchImpl.SimpleConditionType simpleConditionType) {
        if (SearchImpl.SimpleConditionType.CITY.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.CITY, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        if (SearchImpl.SimpleConditionType.DISTRICT.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.DISTRICT, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        if (SearchImpl.SimpleConditionType.COUNTRY.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.COUNTRY, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        if (SearchImpl.SimpleConditionType.ESTATE_ACTION.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.ESTATE_ACTION, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        if (SearchImpl.SimpleConditionType.ESTATE_TYPE.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.ESTATE_TYPE, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        if (SearchImpl.SimpleConditionType.POSTAL_CODE.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.POSTAL_CODE, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        if (SearchImpl.SimpleConditionType.REGION.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.REGION, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        if (SearchImpl.SimpleConditionType.STREET.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.STREET, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        if (SearchImpl.SimpleConditionType.STREET_NR.equals((Object)simpleConditionType)) {
            CriteriaPanel criteriaPanel = null;
            for (SearchEqualsImpl searchEqualsImpl : list) {
                if (criteriaPanel == null) {
                    criteriaPanel = new CriteriaPanel();
                    criteriaPanel.setWidget(CriteriaType.STREET_NR, null, searchEqualsImpl);
                    continue;
                }
                criteriaPanel.addAlternative(searchEqualsImpl);
            }
            return criteriaPanel;
        }
        LOGGER.warn("Unsupported type of criteria: " + simpleConditionType + "!");
        return null;
    }

    private CriteriaPanel createCriteriaAttributePanel(List<SearchAttribImpl> list, OpenEstateAttrib openEstateAttrib) {
        CriteriaPanel criteriaPanel = null;
        for (SearchAttribImpl searchAttribImpl : list) {
            if (criteriaPanel == null) {
                criteriaPanel = new CriteriaPanel();
                criteriaPanel.setWidget(CriteriaType.ESTATE_ATTRIBUTE, openEstateAttrib, searchAttribImpl);
                continue;
            }
            criteriaPanel.addAlternative(searchAttribImpl);
        }
        return criteriaPanel;
    }

    private CriteriaPanel createCriteriaStatusPanel(List<DbAgencyObject.Status> list) {
        CriteriaPanel criteriaPanel = null;
        for (DbAgencyObject.Status status : list) {
            if (criteriaPanel == null) {
                criteriaPanel = new CriteriaPanel();
                criteriaPanel.setWidget(CriteriaType.ESTATE_STATUS, null, (Object)status);
                continue;
            }
            criteriaPanel.addAlternative((Object)status);
        }
        return criteriaPanel;
    }

    private CriteriaWidget createCriteriaWidget(CriteriaType criteriaType, OpenEstateAttrib openEstateAttrib, Object object) {
        switch (criteriaType) {
            case CITY: 
            case DISTRICT: 
            case POSTAL_CODE: 
            case REGION: 
            case STREET: 
            case STREET_NR: {
                if (object == null) {
                    return new EqualsWidget();
                }
                EqualsWidget equalsWidget = new EqualsWidget();
                try {
                    equalsWidget.setCondition((SearchEqualsImpl)object);
                }
                catch (ClassCastException classCastException) {
                    LOGGER.warn("Invalid condition for " + criteriaType.name());
                    LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                }
                return equalsWidget;
            }
            case COUNTRY: {
                if (object == null) {
                    return new CountryWidget();
                }
                CountryWidget countryWidget = new CountryWidget();
                try {
                    countryWidget.setCondition((SearchEqualsImpl)object);
                }
                catch (ClassCastException classCastException) {
                    LOGGER.warn("Invalid condition for " + criteriaType.name());
                    LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                }
                return countryWidget;
            }
            case ESTATE_ACTION: {
                if (object == null) {
                    return new EstateActionWidget();
                }
                EstateActionWidget estateActionWidget = new EstateActionWidget();
                try {
                    estateActionWidget.setCondition((SearchEqualsImpl)object);
                }
                catch (ClassCastException classCastException) {
                    LOGGER.warn("Invalid condition for " + criteriaType.name());
                    LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                }
                return estateActionWidget;
            }
            case ESTATE_STATUS: {
                if (object == null) {
                    return new EstateStatusWidget();
                }
                EstateStatusWidget estateStatusWidget = new EstateStatusWidget();
                try {
                    estateStatusWidget.setCondition((DbAgencyObject.Status)((Object)object));
                }
                catch (ClassCastException classCastException) {
                    LOGGER.warn("Invalid condition for " + criteriaType.name());
                    LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                }
                return estateStatusWidget;
            }
            case ESTATE_TYPE: {
                if (object == null) {
                    return new EstateTypeWidget();
                }
                EstateTypeWidget estateTypeWidget = new EstateTypeWidget();
                try {
                    estateTypeWidget.setCondition((SearchEqualsImpl)object);
                }
                catch (ClassCastException classCastException) {
                    LOGGER.warn("Invalid condition for " + criteriaType.name());
                    LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                }
                return estateTypeWidget;
            }
            case ESTATE_ATTRIBUTE: {
                AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
                if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
                    EstateBooleanWidget estateBooleanWidget = new EstateBooleanWidget();
                    try {
                        if (object != null) {
                            estateBooleanWidget.setCondition(((SearchAttribImpl)object).getEqualsCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for boolean attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return estateBooleanWidget;
                }
                if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                    EstateEnumWidget estateEnumWidget = new EstateEnumWidget((SimpleEnumAttrib)abstractAttribImpl);
                    try {
                        if (object != null) {
                            estateEnumWidget.setCondition(((SearchAttribImpl)object).getEqualsCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for simple enum attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return estateEnumWidget;
                }
                if (abstractAttribImpl instanceof SimpleNumericAttrib) {
                    NumericIntervalWidget numericIntervalWidget = new NumericIntervalWidget(((SimpleNumericAttrib)abstractAttribImpl).getPrecision());
                    try {
                        if (object != null) {
                            numericIntervalWidget.setCondition(((SearchAttribImpl)object).getNumericCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for numeric attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return numericIntervalWidget;
                }
                if (abstractAttribImpl instanceof SimpleTimeAttrib) {
                    DateIntervalWidget dateIntervalWidget = new DateIntervalWidget();
                    try {
                        if (object != null) {
                            dateIntervalWidget.setCondition(((SearchAttribImpl)object).getDateTimeCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for time attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return dateIntervalWidget;
                }
                if (abstractAttribImpl instanceof ComplexAreaAttrib) {
                    EstateAreaWidget estateAreaWidget = new EstateAreaWidget();
                    try {
                        if (object != null) {
                            estateAreaWidget.setCondition(((SearchAttribImpl)object).getNumericCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for area attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return estateAreaWidget;
                }
                if (abstractAttribImpl instanceof ComplexCurrencyAttrib) {
                    NumericIntervalWidget numericIntervalWidget = new NumericIntervalWidget(2);
                    try {
                        if (object != null) {
                            numericIntervalWidget.setCondition(((SearchAttribImpl)object).getNumericCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for currency attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return numericIntervalWidget;
                }
                if (abstractAttribImpl instanceof ComplexEnumAttrib) {
                    EstateEnumWidget estateEnumWidget = new EstateEnumWidget((ComplexEnumAttrib)abstractAttribImpl);
                    try {
                        if (object != null) {
                            estateEnumWidget.setCondition(((SearchAttribImpl)object).getEqualsCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for complex enum attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return estateEnumWidget;
                }
                if (abstractAttribImpl instanceof ComplexLengthAttrib) {
                    EstateLengthWidget estateLengthWidget = new EstateLengthWidget();
                    try {
                        if (object != null) {
                            estateLengthWidget.setCondition(((SearchAttribImpl)object).getNumericCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for length attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return estateLengthWidget;
                }
                if (abstractAttribImpl instanceof ComplexStringAttrib) {
                    EqualsWidget equalsWidget = new EqualsWidget();
                    try {
                        if (object != null) {
                            equalsWidget.setCondition(((SearchAttribImpl)object).getEqualsCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for string attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return equalsWidget;
                }
                if (abstractAttribImpl instanceof ComplexVolumeAttrib) {
                    EstateVolumeWidget estateVolumeWidget = new EstateVolumeWidget();
                    try {
                        if (object != null) {
                            estateVolumeWidget.setCondition(((SearchAttribImpl)object).getNumericCondition());
                        }
                    }
                    catch (ClassCastException classCastException) {
                        LOGGER.warn("Invalid condition for volume attribute!");
                        LOGGER.warn("> " + classCastException.getLocalizedMessage(), (Throwable)classCastException);
                    }
                    return estateVolumeWidget;
                }
                LOGGER.warn("Can't create widget for attribute!");
                LOGGER.warn("> attrib : " + openEstateAttrib);
                return null;
            }
        }
        return null;
    }

    private JMenuItem createMenuItem(CriteriaType criteriaType) {
        return this.createMenuItem(criteriaType, null);
    }

    private JMenuItem createMenuItem(final CriteriaType criteriaType, final OpenEstateAttrib openEstateAttrib) {
        JMenuItem jMenuItem = new JMenuItem(openEstateAttrib != null ? openEstateAttrib.getTranslation() : criteriaType.getTranslation());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AgencySearchCriteriaPanel.this.criteriaMenuCallingPanel == null) {
                    return;
                }
                AgencySearchCriteriaPanel.this.criteriaMenuCallingPanel.setWidget(criteriaType, openEstateAttrib, null);
            }
        });
        return jMenuItem;
    }

    public void doCriteriaAdd() {
        this.addCriteriaPanel(new CriteriaPanel());
        this.criteriaContainerPanel.revalidate();
        this.criteriaContainerPanel.repaint();
    }

    private void doCriteriaAddAlternative(CriteriaPanel criteriaPanel) {
        criteriaPanel.addAlternative(null);
    }

    private void doCriteriaMoveDown(CriteriaPanel criteriaPanel) {
        int n = this.criteriaPanels.indexOf((Object)criteriaPanel);
        if (n + 1 < this.criteriaPanels.size()) {
            this.moveCriteriaPanel(n, n + 1);
        }
    }

    private void doCriteriaMoveUp(CriteriaPanel criteriaPanel) {
        int n = this.criteriaPanels.indexOf((Object)criteriaPanel);
        if (n > 0) {
            this.moveCriteriaPanel(n, n - 1);
        }
    }

    private void doCriteriaRemove(CriteriaPanel criteriaPanel) {
        if (criteriaPanel.currentWidgets.size() > 1) {
            criteriaPanel.currentWidgets.remove(criteriaPanel.currentWidgets.size() - 1);
            criteriaPanel.currentWidgets.trimToSize();
            criteriaPanel.selectWidget(null);
        } else {
            try {
                criteriaPanel.setEnabled(false);
                criteriaPanel.setVisible(false);
                this.criteriaPanels.remove((Object)criteriaPanel);
                this.criteriaPanels.trimToSize();
                this.criteriaContainerPanel.remove((Component)((Object)criteriaPanel));
            }
            finally {
                criteriaPanel.setCriteriaEnabled(true);
                this.updateCriteriaOrderButtons();
                ImmoToolUtils.disposeRecursively((Component)((Object)criteriaPanel));
            }
        }
    }

    private void doCriteriaShowEstateTypes(Component component, int n, int n2, EstateTypeWidget estateTypeWidget) {
        this.estateTypeMenuCallingWidget = null;
        this.estateTypeMenu.setSelectedType(estateTypeWidget.estateType);
        this.estateTypeMenuCallingWidget = estateTypeWidget;
        this.estateTypeMenu.show(component, n, n2);
    }

    private void doCriteriaShowTypes(Component component, int n, int n2, CriteriaPanel criteriaPanel) {
        this.criteriaMenuCallingPanel = criteriaPanel;
        this.criteriaMenu.show(component, n, n2);
    }

    private static Object getCriteriaValue(CriteriaType criteriaType, OpenEstateAttrib openEstateAttrib, Object object) {
        switch (criteriaType) {
            case CITY: 
            case DISTRICT: 
            case POSTAL_CODE: 
            case REGION: 
            case STREET: 
            case STREET_NR: 
            case COUNTRY: 
            case ESTATE_ACTION: 
            case ESTATE_STATUS: 
            case ESTATE_TYPE: {
                return object;
            }
            case ESTATE_ATTRIBUTE: {
                SearchAttribImpl searchAttribImpl = new SearchAttribImpl();
                searchAttribImpl.setAttribute(openEstateAttrib);
                if (object instanceof SearchDateTimeImpl) {
                    searchAttribImpl.setDateTimeCondition((SearchDateTimeImpl)object);
                } else if (object instanceof SearchEqualsImpl) {
                    searchAttribImpl.setEqualsCondition((SearchEqualsImpl)object);
                } else if (object instanceof SearchMatchesImpl) {
                    searchAttribImpl.setMatchesCondition((SearchMatchesImpl)object);
                } else if (object instanceof SearchNumericImpl) {
                    searchAttribImpl.setNumericCondition((SearchNumericImpl)object);
                }
                return searchAttribImpl;
            }
        }
        return null;
    }

    public static DbAgencySearch getDefaultSearch(String string, DbAgencySearch.Type type) {
        DbAgencySearch dbAgencySearch = new DbAgencySearch();
        dbAgencySearch.item.setName(string);
        dbAgencySearch.type = type;
        dbAgencySearch.status.add(DbAgencyObject.Status.PUBLISHED);
        SearchEqualsImpl searchEqualsImpl = new SearchEqualsImpl();
        searchEqualsImpl.setOrder(1L);
        dbAgencySearch.item.getSimpleConditions(SearchImpl.SimpleConditionType.ESTATE_ACTION).add(searchEqualsImpl);
        searchEqualsImpl = new SearchEqualsImpl();
        searchEqualsImpl.setOrder(2L);
        dbAgencySearch.item.getSimpleConditions(SearchImpl.SimpleConditionType.ESTATE_TYPE).add(searchEqualsImpl);
        searchEqualsImpl = new SearchEqualsImpl();
        searchEqualsImpl.setOrder(3L);
        searchEqualsImpl.setCaseSensitive(false);
        dbAgencySearch.item.getSimpleConditions(SearchImpl.SimpleConditionType.CITY).add(searchEqualsImpl);
        return dbAgencySearch;
    }

    /*
     * WARNING - void declaration
     */
    public void load(DbAgencySearch dbAgencySearch) {
        Object object3;
        Object object2;
        long l;
        void searchAttribImpl;
        Object object4;
        if (dbAgencySearch == null) {
            dbAgencySearch = new DbAgencySearch();
        }
        this.criteriaPanels.clear();
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.criteriaContainerPanel.removeAll();
        this.setCriteriaMenuEnabled(true);
        if (dbAgencySearch.status != null && !dbAgencySearch.status.isEmpty()) {
            object4 = this.createCriteriaStatusPanel(dbAgencySearch.status);
            if (object4 == null) {
                LOGGER.warn("Can't create criteria panel!");
            } else {
                this.addCriteriaPanel((CriteriaPanel)((Object)object4));
            }
        }
        object4 = new TreeMap();
        Object enumMap = SearchImpl.SimpleConditionType.values();
        int n = ((SearchImpl.SimpleConditionType[])enumMap).length;
        boolean bl = false;
        while (searchAttribImpl < n) {
            SearchImpl.SimpleConditionType simpleConditionType = enumMap[searchAttribImpl];
            l = -1L;
            object2 = dbAgencySearch.item.getSimpleConditions(simpleConditionType);
            if (object2 != null && !object2.isEmpty()) {
                object3 = object2.iterator();
                while (object3.hasNext()) {
                    SearchEqualsImpl searchEqualsImpl = (SearchEqualsImpl)object3.next();
                    if (l >= 0L && l <= searchEqualsImpl.getOrder()) continue;
                    l = searchEqualsImpl.getOrder();
                }
                if (l < 0L) {
                    l = 0L;
                }
                if (!object4.containsKey(l)) {
                    object4.put(l, new ArrayList());
                }
                ((List)object4.get(l)).add(simpleConditionType);
            }
            ++searchAttribImpl;
        }
        enumMap = new EnumMap(OpenEstateAttrib.class);
        for (SearchAttribImpl entry : dbAgencySearch.item.getAttribConditions()) {
            OpenEstateAttrib openEstateAttrib = entry.getAttribute();
            if (!enumMap.containsKey(openEstateAttrib)) {
                enumMap.put(openEstateAttrib, new ArrayList());
            }
            ((List)enumMap.get(openEstateAttrib)).add(entry);
        }
        for (Map.Entry list : enumMap.entrySet()) {
            OpenEstateAttrib openEstateAttrib = (OpenEstateAttrib)list.getKey();
            l = -1L;
            for (Object object3 : (List)list.getValue()) {
                if (l >= 0L && l <= object3.getOrder()) continue;
                l = object3.getOrder();
            }
            if (l < 0L) {
                l = 0L;
            }
            if (!object4.containsKey(l)) {
                object4.put(l, new ArrayList());
            }
            ((List)object4.get(l)).add(openEstateAttrib);
        }
        for (List list : object4.values()) {
            for (Object e : list) {
                SearchImpl.SimpleConditionType simpleConditionType;
                if (e instanceof SearchImpl.SimpleConditionType) {
                    simpleConditionType = (SearchImpl.SimpleConditionType)e;
                    object2 = dbAgencySearch.item.getSimpleConditions(simpleConditionType);
                    if (object2 == null || object2.isEmpty()) continue;
                    object3 = this.createCriteriaPanel((List<SearchEqualsImpl>)object2, simpleConditionType);
                    if (object3 == null) {
                        LOGGER.warn("Can't create criteria panel!");
                        continue;
                    }
                    this.addCriteriaPanel((CriteriaPanel)((Object)object3));
                    continue;
                }
                if (e instanceof OpenEstateAttrib) {
                    simpleConditionType = (OpenEstateAttrib)e;
                    object2 = this.createCriteriaAttributePanel((List)enumMap.get(simpleConditionType), (OpenEstateAttrib)simpleConditionType);
                    if (object2 == null) {
                        LOGGER.warn("Can't create criteria panel!");
                        continue;
                    }
                    this.addCriteriaPanel((CriteriaPanel)((Object)object2));
                    continue;
                }
                LOGGER.warn("Unsupported type of condition: " + e);
                if (e == null) continue;
                LOGGER.warn("> " + e.getClass().getName());
            }
        }
        this.criteriaContainerPanel.revalidate();
        this.criteriaContainerPanel.repaint();
    }

    public void loadTemplates(Connection connection, DbAgencySearchesHandler dbAgencySearchesHandler) throws SQLException {
        DbSearch[] dbSearchArray = dbAgencySearchesHandler.getSearches(connection, (Boolean)true, DbAgencySearch.Type.TEMPLATE);
        dbAgencySearchesHandler.loadAttribConditions(connection, dbSearchArray);
        dbAgencySearchesHandler.loadValueConditions(connection, dbSearchArray);
        this.setTemplates(dbSearchArray);
    }

    private void moveCriteriaPanel(int n, int n2) {
        if (n != n2 && n >= 0 && n2 >= 0 && n < this.criteriaPanels.size() && n2 < this.criteriaPanels.size()) {
            CriteriaPanel criteriaPanel = this.criteriaPanels.get(n);
            CriteriaPanel criteriaPanel2 = this.criteriaPanels.get(n2);
            this.criteriaPanels.set(n2, criteriaPanel);
            this.criteriaPanels.set(n, criteriaPanel2);
            this.criteriaContainerPanel.removeAll();
            this.criteriaContainerPanel.setLayout(new GridBagLayout());
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 2;
            this.constraints.weightx = 1.0;
            this.constraints.gridx = 0;
            this.constraints.gridy = 0;
            this.constraints.ipady = 10;
            for (CriteriaPanel criteriaPanel3 : this.criteriaPanels) {
                this.constraints.gridx = 0;
                ++this.constraints.gridy;
                this.criteriaContainerPanel.add((Component)((Object)criteriaPanel3), this.constraints);
            }
            this.updateCriteriaOrderButtons();
            this.criteriaContainerPanel.revalidate();
            this.criteriaContainerPanel.repaint();
        }
    }

    public void removeCriterias() {
        this.criteriaPanels.clear();
        this.criteriaContainerPanel.removeAll();
    }

    public void removeTemplateListener(TemplateListener templateListener) {
        if (templateListener != null) {
            this.templateListeners.remove(templateListener);
        }
    }

    public void save(DbAgencySearch dbAgencySearch) {
        dbAgencySearch.status = new ArrayList<DbAgencyObject.Status>();
        dbAgencySearch.item.getAttribConditions().clear();
        for (SearchImpl.SimpleConditionType object2 : SearchImpl.SimpleConditionType.values()) {
            dbAgencySearch.item.getSimpleConditions(object2).clear();
        }
        ArrayList arrayList = new ArrayList();
        for (CriteriaPanel criteriaPanel : this.criteriaPanels) {
            if (!criteriaPanel.isVisible() || !criteriaPanel.isEnabled()) continue;
            arrayList.add(criteriaPanel);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        long l = 0L;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object22;
            CriteriaPanel criteriaPanel = (CriteriaPanel)((Object)iterator.next());
            if (CriteriaType.ESTATE_STATUS.equals((Object)criteriaPanel.currentCriteria)) {
                for (Object object22 : criteriaPanel.save()) {
                    object = (DbAgencyObject.Status)((Object)object22);
                    if (dbAgencySearch.status.contains(object)) continue;
                    dbAgencySearch.status.add((DbAgencyObject.Status)((Object)object));
                }
                continue;
            }
            if (CriteriaType.ESTATE_ATTRIBUTE.equals((Object)criteriaPanel.currentCriteria)) {
                for (Object object22 : criteriaPanel.save()) {
                    object = (SearchAttribImpl)object22;
                    object.setOrder(++l);
                    dbAgencySearch.item.getAttribConditions().add(object);
                }
                continue;
            }
            List<Object> list = null;
            object22 = null;
            if (CriteriaType.CITY.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.CITY;
                list = criteriaPanel.save();
            } else if (CriteriaType.DISTRICT.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.DISTRICT;
                list = criteriaPanel.save();
            } else if (CriteriaType.COUNTRY.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.COUNTRY;
                list = criteriaPanel.save();
            } else if (CriteriaType.ESTATE_ACTION.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.ESTATE_ACTION;
                list = criteriaPanel.save();
            } else if (CriteriaType.ESTATE_TYPE.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.ESTATE_TYPE;
                list = criteriaPanel.save();
            } else if (CriteriaType.POSTAL_CODE.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.POSTAL_CODE;
                list = criteriaPanel.save();
            } else if (CriteriaType.REGION.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.REGION;
                list = criteriaPanel.save();
            } else if (CriteriaType.STREET.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.STREET;
                list = criteriaPanel.save();
            } else if (CriteriaType.STREET_NR.equals((Object)criteriaPanel.currentCriteria)) {
                object22 = SearchImpl.SimpleConditionType.STREET_NR;
                list = criteriaPanel.save();
            }
            if (list == null || object22 == null) continue;
            for (Object e : list) {
                SearchEqualsImpl searchEqualsImpl = (SearchEqualsImpl)e;
                searchEqualsImpl.setOrder(++l);
                dbAgencySearch.item.getSimpleConditions((SearchImpl.SimpleConditionType)object22).add(searchEqualsImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setCriteriaAddressItemEnabled(JMenu jMenu, CriteriaType criteriaType, boolean bl) {
        JMenuItem jMenuItem = null;
        try {
            switch (criteriaType) {
                case STREET: {
                    jMenuItem = jMenu.getItem(0);
                    return;
                }
                case STREET_NR: {
                    jMenuItem = jMenu.getItem(1);
                    return;
                }
                case POSTAL_CODE: {
                    jMenuItem = jMenu.getItem(2);
                    return;
                }
                case CITY: {
                    jMenuItem = jMenu.getItem(3);
                    return;
                }
                case DISTRICT: {
                    jMenuItem = jMenu.getItem(4);
                    return;
                }
                case REGION: {
                    jMenuItem = jMenu.getItem(5);
                    return;
                }
                case COUNTRY: {
                    jMenuItem = jMenu.getItem(6);
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't find menu item!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return;
        }
        finally {
            if (jMenuItem != null) {
                jMenuItem.setEnabled(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setCriteriaItemEnabled(CriteriaType criteriaType, boolean bl) {
        JMenuItem jMenuItem = null;
        try {
            switch (criteriaType) {
                case ESTATE_ACTION: {
                    jMenuItem = (JMenuItem)this.criteriaMenu.getComponent(2);
                    return;
                }
                case ESTATE_TYPE: {
                    jMenuItem = (JMenuItem)this.criteriaMenu.getComponent(3);
                    return;
                }
                case ESTATE_STATUS: {
                    jMenuItem = (JMenuItem)this.criteriaMenu.getComponent(4);
                    return;
                }
                case CITY: 
                case DISTRICT: 
                case POSTAL_CODE: 
                case REGION: 
                case STREET: 
                case STREET_NR: 
                case COUNTRY: {
                    JMenu jMenu = (JMenu)this.criteriaMenu.getComponent(0);
                    this.setCriteriaAddressItemEnabled(jMenu, criteriaType, bl);
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't find menu item!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return;
        }
        finally {
            if (jMenuItem != null) {
                jMenuItem.setEnabled(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCriteriaItemEnabled(OpenEstateAttrib openEstateAttrib, boolean bl) {
        JMenuItem jMenuItem = null;
        try {
            jMenuItem = this.criteriaMenuAttribItems.get(openEstateAttrib);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't find menu item!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            if (jMenuItem != null) {
                jMenuItem.setEnabled(bl);
            }
        }
    }

    private void setCriteriaMenuEnabled(boolean bl) {
        for (int i = 0; i < this.criteriaMenu.getComponentCount(); ++i) {
            Component component = this.criteriaMenu.getComponent(i);
            if (component instanceof JMenu) {
                this.setCriteriaMenuEnabled(bl, (JMenu)component);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    private void setCriteriaMenuEnabled(boolean bl, JMenu jMenu) {
        for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (component instanceof JMenu) {
                this.setCriteriaMenuEnabled(bl, (JMenu)component);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public void setCurrentSearch(DbAgencySearch dbAgencySearch) {
        this.currentSearch = dbAgencySearch;
        this.load(dbAgencySearch);
    }

    public void setDefaultSearch() {
        this.setCurrentSearch(AgencySearchCriteriaPanel.getDefaultSearch(null, null));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.criteriaAddAction.setEnabled(bl);
        for (CriteriaPanel criteriaPanel : this.criteriaPanels) {
            criteriaPanel.setEnabled(bl);
        }
    }

    public void setTemplates(DbSearch[] dbSearchArray) {
        if (dbSearchArray == null || dbSearchArray.length < 1) {
            this.templateBox.setEnabled(false);
            this.templateBox.setVisible(false);
        } else {
            this.templateBox.setEnabled(false);
            this.templateBox.removeAllItems();
            this.templateBox.addItem(null);
            for (DbSearch dbSearch : dbSearchArray) {
                this.templateBox.addItem(dbSearch);
            }
            this.templateBox.setSelectedItem(null);
            this.templateBox.setEnabled(true);
            this.templateBox.setVisible(true);
        }
    }

    private void updateCriteriaOrderButtons() {
        for (int i = 0; i < this.criteriaPanels.size(); ++i) {
            CriteriaPanel criteriaPanel = this.criteriaPanels.get(i);
            criteriaPanel.setFirst(i == 0);
            criteriaPanel.setLast(i + 1 == this.criteriaPanels.size());
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("edit search criteria")));
        this.buildCriteriaMenu();
        this.buildTypeMenu();
    }

    public static interface TemplateListener {
        public void templateSelected(DbSearch var1);
    }

    private class CriteriaShowTypesAction
    extends AbstractI18nAction {
        private final CriteriaPanel form;

        private CriteriaShowTypesAction(CriteriaPanel criteriaPanel) {
            this.form = criteriaPanel;
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencySearchCriteriaPanel.this.doCriteriaShowTypes(jButton, 0, jButton.getSize().height, this.form);
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Select the type of search criterion."));
        }
    }

    private class CriteriaShowEstateTypesAction
    extends AbstractI18nAction {
        private final EstateTypeWidget widget;

        private CriteriaShowEstateTypesAction(EstateTypeWidget estateTypeWidget) {
            this.widget = estateTypeWidget;
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencySearchCriteriaPanel.this.doCriteriaShowEstateTypes(jButton, 0, jButton.getSize().height, this.widget);
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Select a property type for the search criterion."));
        }
    }

    private class CriteriaRemoveAction
    extends AbstractI18nAction {
        private final CriteriaPanel form;

        private CriteriaRemoveAction(CriteriaPanel criteriaPanel) {
            this.form = criteriaPanel;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySearchCriteriaPanel.this.doCriteriaRemove(this.form);
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Remove criterion from the search request."));
        }
    }

    private class CriteriaMoveUpAction
    extends AbstractI18nAction {
        private final CriteriaPanel form;

        private CriteriaMoveUpAction(CriteriaPanel criteriaPanel) {
            this.form = criteriaPanel;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_up.png", (int)16));
            this.setName("");
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySearchCriteriaPanel.this.doCriteriaMoveUp(this.form);
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Move up the search criterion."));
        }
    }

    private class CriteriaMoveDownAction
    extends AbstractI18nAction {
        private final CriteriaPanel form;

        private CriteriaMoveDownAction(CriteriaPanel criteriaPanel) {
            this.form = criteriaPanel;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_down.png", (int)16));
            this.setName("");
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySearchCriteriaPanel.this.doCriteriaMoveDown(this.form);
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Move down the search criterion."));
        }
    }

    private class CriteriaAddAlternativeAction
    extends AbstractI18nAction {
        private final CriteriaPanel form;

        private CriteriaAddAlternativeAction(CriteriaPanel criteriaPanel) {
            this.form = criteriaPanel;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setName("");
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySearchCriteriaPanel.this.doCriteriaAddAlternative(this.form);
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Add an alternative value to the criterion."));
        }
    }

    private class CriteriaAddAction
    extends AbstractI18nAction {
        private CriteriaAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySearchCriteriaPanel.this.doCriteriaAdd();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("add criterion")));
            this.setShortDescription(I18N.tr("Add a criterion to the search request."));
        }
    }

    private static class EstateVolumeWidget
    extends CriteriaWidget<SearchNumericImpl> {
        private NumericIntervalWidget numericWidget;
        private JComboBox<VolumeValue.Unit> unitBox;

        private EstateVolumeWidget() {
            this.build();
        }

        private void build() {
            this.numericWidget = new NumericIntervalWidget(2);
            this.unitBox = new JComboBox();
            for (VolumeValue.Unit unit : VolumeValue.Unit.values()) {
                this.unitBox.addItem(unit);
            }
            this.unitBox.setSelectedItem(VolumeValue.Unit.getBaseUnit());
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.numericWidget), "Center");
            this.add(this.unitBox, "East");
            this.updateLocalization();
        }

        @Override
        public SearchNumericImpl getCondition() {
            SearchNumericImpl searchNumericImpl = this.numericWidget.getCondition();
            if (searchNumericImpl != null) {
                searchNumericImpl.unsetUnits();
                searchNumericImpl.setVolumeUnit((VolumeValue.Unit)this.unitBox.getSelectedItem());
            }
            return searchNumericImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return this.numericWidget.getCriteriaClass();
        }

        @Override
        public void setCondition(SearchNumericImpl searchNumericImpl) {
            super.setCondition(searchNumericImpl);
            this.numericWidget.setCondition(searchNumericImpl);
            VolumeValue.Unit unit = searchNumericImpl != null ? searchNumericImpl.getVolumeUnit() : null;
            this.unitBox.setSelectedItem(unit != null ? unit : VolumeValue.Unit.getBaseUnit());
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.unitBox.setEnabled(bl);
            this.numericWidget.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private class EstateTypeWidget
    extends CriteriaWidget<SearchEqualsImpl> {
        private JButton estateTypeButton;
        private OpenEstateType estateType;

        private EstateTypeWidget() {
            this.build();
        }

        private void build() {
            this.estateTypeButton = new JButton((Action)((Object)new CriteriaShowEstateTypesAction(this)));
            this.estateTypeButton.setHorizontalAlignment(2);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"40dlu:grow", (JPanel)((Object)this));
            defaultFormBuilder.add((Component)this.estateTypeButton).xy(1, defaultFormBuilder.nextRow());
            this.setEstateType(null);
        }

        @Override
        public SearchEqualsImpl getCondition() {
            SearchEqualsImpl searchEqualsImpl = new SearchEqualsImpl();
            searchEqualsImpl.setValue(this.estateType != null ? this.estateType.name() : null);
            searchEqualsImpl.setCaseSensitive(false);
            searchEqualsImpl.setLike(false);
            return searchEqualsImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return SearchEqualsImpl.class;
        }

        @Override
        public void setCondition(SearchEqualsImpl searchEqualsImpl) {
            OpenEstateType openEstateType;
            super.setCondition(searchEqualsImpl);
            try {
                String string = searchEqualsImpl != null ? StringUtils.trimToNull((String)searchEqualsImpl.getValue()) : null;
                openEstateType = string != null ? OpenEstateType.valueOf((String)string) : null;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't set condition!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                openEstateType = null;
            }
            this.setEstateType(openEstateType);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.estateTypeButton.setEnabled(bl);
        }

        public final void setEstateType(OpenEstateType openEstateType) {
            this.estateType = openEstateType;
            this.updateLocalization();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.estateTypeButton.setText(this.estateType != null ? this.estateType.getTranslation() : I18N.tr("no property type selected"));
        }
    }

    private static class EstateStatusWidget
    extends CriteriaWidget<DbAgencyObject.Status> {
        private JComboBox<DbAgencyObject.Status> statusBox;

        private EstateStatusWidget() {
            this.build();
        }

        private void build() {
            this.statusBox = new JComboBox();
            this.statusBox.setRenderer((ListCellRenderer<DbAgencyObject.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<DbAgencyObject.Status>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("no selection") + " ]";
                }
            }));
            this.statusBox.addItem(null);
            for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
                this.statusBox.addItem(status);
            }
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"40dlu:grow", (JPanel)((Object)this));
            defaultFormBuilder.add(this.statusBox).xy(1, defaultFormBuilder.nextRow());
            this.updateLocalization();
        }

        @Override
        public DbAgencyObject.Status getCondition() {
            return (DbAgencyObject.Status)((Object)this.statusBox.getSelectedItem());
        }

        @Override
        public Class getCriteriaClass() {
            return DbAgencyObject.Status.class;
        }

        @Override
        public void setCondition(DbAgencyObject.Status status) {
            super.setCondition(status);
            this.statusBox.setSelectedItem((Object)status);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.statusBox.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private static class EstateLengthWidget
    extends CriteriaWidget<SearchNumericImpl> {
        private NumericIntervalWidget numericWidget;
        private JComboBox<LengthValue.Unit> unitBox;

        private EstateLengthWidget() {
            this.build();
        }

        private void build() {
            this.numericWidget = new NumericIntervalWidget(2);
            this.unitBox = new JComboBox();
            for (LengthValue.Unit unit : LengthValue.Unit.values()) {
                this.unitBox.addItem(unit);
            }
            this.unitBox.setSelectedItem(LengthValue.Unit.getBaseUnit());
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.numericWidget), "Center");
            this.add(this.unitBox, "East");
            this.updateLocalization();
        }

        @Override
        public SearchNumericImpl getCondition() {
            SearchNumericImpl searchNumericImpl = this.numericWidget.getCondition();
            if (searchNumericImpl != null) {
                searchNumericImpl.unsetUnits();
                searchNumericImpl.setLengthUnit((LengthValue.Unit)this.unitBox.getSelectedItem());
            }
            return searchNumericImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return this.numericWidget.getCriteriaClass();
        }

        @Override
        public void setCondition(SearchNumericImpl searchNumericImpl) {
            super.setCondition(searchNumericImpl);
            this.numericWidget.setCondition(searchNumericImpl);
            LengthValue.Unit unit = searchNumericImpl != null ? searchNumericImpl.getLengthUnit() : null;
            this.unitBox.setSelectedItem(unit != null ? unit : LengthValue.Unit.getBaseUnit());
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.unitBox.setEnabled(bl);
            this.numericWidget.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private static class EstateEnumWidget
    extends CriteriaWidget<SearchEqualsImpl> {
        private JComboBox<String> enumBox;

        private EstateEnumWidget(SimpleEnumAttrib simpleEnumAttrib) {
            TreeMap<String, Enum> treeMap = new TreeMap<String, Enum>();
            for (Enum enum_ : simpleEnumAttrib.getOptions()) {
                String string = simpleEnumAttrib.getOptionTranslation(enum_);
                int n = 0;
                String string2 = string;
                while (treeMap.containsKey(string2)) {
                    string2 = string + "_" + ++n;
                }
                treeMap.put(string2, enum_);
            }
            this.build(simpleEnumAttrib.getAttrib(), treeMap);
        }

        private EstateEnumWidget(ComplexEnumAttrib complexEnumAttrib) {
            TreeMap<String, Enum> treeMap = new TreeMap<String, Enum>();
            for (Enum enum_ : complexEnumAttrib.getOptions()) {
                String string = complexEnumAttrib.getOptionTranslation(enum_);
                int n = 0;
                String string2 = string;
                while (treeMap.containsKey(string2)) {
                    string2 = string + "_" + ++n;
                }
                treeMap.put(string2, enum_);
            }
            this.build(complexEnumAttrib.getAttrib(), treeMap);
        }

        private void build(final OpenEstateAttrib openEstateAttrib, Map<String, Enum> map) {
            this.enumBox = new JComboBox();
            this.enumBox.setRenderer((ListCellRenderer<String>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<String>(){

                public void render(String string, JLabel jLabel) {
                    if (string != null) {
                        AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
                        if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                            SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)abstractAttribImpl;
                            Enum enum_ = simpleEnumAttrib.getOption(string);
                            jLabel.setText(enum_ != null ? (String)StringUtils.defaultIfBlank((CharSequence)simpleEnumAttrib.getOptionTranslation(enum_), (CharSequence)enum_.name()) : "???");
                        } else if (abstractAttribImpl instanceof ComplexEnumAttrib) {
                            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)abstractAttribImpl;
                            Enum enum_ = complexEnumAttrib.getOption(string);
                            jLabel.setText(enum_ != null ? (String)StringUtils.defaultIfBlank((CharSequence)complexEnumAttrib.getOptionTranslation(enum_), (CharSequence)enum_.name()) : "???");
                        }
                    } else {
                        jLabel.setText("[ " + I18N.tr("no selection") + " ]");
                    }
                }
            }));
            this.enumBox.addItem(null);
            for (Enum enum_ : map.values()) {
                this.enumBox.addItem(enum_.name());
            }
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"40dlu:grow", (JPanel)((Object)this));
            defaultFormBuilder.add(this.enumBox).xy(1, defaultFormBuilder.nextRow());
            this.updateLocalization();
        }

        @Override
        public SearchEqualsImpl getCondition() {
            String string = (String)this.enumBox.getSelectedItem();
            SearchEqualsImpl searchEqualsImpl = new SearchEqualsImpl();
            if (string != null) {
                searchEqualsImpl.setValue(string);
            }
            searchEqualsImpl.setCaseSensitive(false);
            searchEqualsImpl.setLike(false);
            return searchEqualsImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return SearchEqualsImpl.class;
        }

        @Override
        public void setCondition(SearchEqualsImpl searchEqualsImpl) {
            super.setCondition(searchEqualsImpl);
            this.enumBox.setSelectedItem(searchEqualsImpl != null ? StringUtils.trimToNull((String)searchEqualsImpl.getValue()) : null);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.enumBox.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private static class EstateBooleanWidget
    extends CriteriaWidget<SearchEqualsImpl> {
        private JComboBox<Boolean> booleanBox;

        private EstateBooleanWidget() {
            this.build();
        }

        private void build() {
            this.booleanBox = new JComboBox();
            this.booleanBox.setRenderer((ListCellRenderer<Boolean>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<Boolean>(){

                public void render(Boolean bl, JLabel jLabel) {
                    if (Boolean.TRUE.equals(bl)) {
                        jLabel.setText(OpenEstateConstant.YES.getTranslation());
                    } else if (Boolean.FALSE.equals(bl)) {
                        jLabel.setText(OpenEstateConstant.NO.getTranslation());
                    } else {
                        jLabel.setText("[ " + I18N.tr("no selection") + " ]");
                    }
                }
            }));
            this.booleanBox.addItem(null);
            this.booleanBox.addItem(Boolean.FALSE);
            this.booleanBox.addItem(Boolean.TRUE);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"40dlu:grow", (JPanel)((Object)this));
            defaultFormBuilder.add(this.booleanBox).xy(1, defaultFormBuilder.nextRow());
            this.updateLocalization();
        }

        @Override
        public SearchEqualsImpl getCondition() {
            Boolean bl = (Boolean)this.booleanBox.getSelectedItem();
            SearchEqualsImpl searchEqualsImpl = new SearchEqualsImpl();
            if (bl != null) {
                searchEqualsImpl.setValue(bl.toString());
            }
            searchEqualsImpl.setCaseSensitive(false);
            searchEqualsImpl.setLike(false);
            return searchEqualsImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return SearchEqualsImpl.class;
        }

        @Override
        public void setCondition(SearchEqualsImpl searchEqualsImpl) {
            super.setCondition(searchEqualsImpl);
            this.booleanBox.setSelectedItem(searchEqualsImpl != null ? Boolean.valueOf(Boolean.TRUE.toString().equalsIgnoreCase(searchEqualsImpl.getValue())) : null);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.booleanBox.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private static class EstateAreaWidget
    extends CriteriaWidget<SearchNumericImpl> {
        private NumericIntervalWidget numericWidget;
        private JComboBox<AreaValue.Unit> unitBox;

        private EstateAreaWidget() {
            this.build();
        }

        private void build() {
            this.numericWidget = new NumericIntervalWidget(2);
            this.unitBox = new JComboBox();
            for (AreaValue.Unit unit : AreaValue.Unit.values()) {
                this.unitBox.addItem(unit);
            }
            this.unitBox.setSelectedItem(AreaValue.Unit.getBaseUnit());
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.numericWidget), "Center");
            this.add(this.unitBox, "East");
            this.updateLocalization();
        }

        @Override
        public SearchNumericImpl getCondition() {
            SearchNumericImpl searchNumericImpl = this.numericWidget.getCondition();
            if (searchNumericImpl != null) {
                searchNumericImpl.unsetUnits();
                searchNumericImpl.setAreaUnit((AreaValue.Unit)this.unitBox.getSelectedItem());
            }
            return searchNumericImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return this.numericWidget.getCriteriaClass();
        }

        @Override
        public void setCondition(SearchNumericImpl searchNumericImpl) {
            super.setCondition(searchNumericImpl);
            this.numericWidget.setCondition(searchNumericImpl);
            AreaValue.Unit unit = searchNumericImpl != null ? searchNumericImpl.getAreaUnit() : null;
            this.unitBox.setSelectedItem(unit != null ? unit : AreaValue.Unit.getBaseUnit());
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.unitBox.setEnabled(bl);
            this.numericWidget.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private static class EstateActionWidget
    extends CriteriaWidget<SearchEqualsImpl> {
        private JComboBox<OpenEstateAction> actionBox;

        private EstateActionWidget() {
            this.build();
        }

        private void build() {
            this.actionBox = new JComboBox();
            this.actionBox.setRenderer((ListCellRenderer<OpenEstateAction>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<OpenEstateAction>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("no selection") + " ]";
                }
            }));
            this.actionBox.addItem(null);
            TreeMap<String, OpenEstateAction> treeMap = new TreeMap<String, OpenEstateAction>();
            for (OpenEstateAction openEstateAction : OpenEstateAction.values()) {
                String string = openEstateAction.getTranslation();
                treeMap.put(string.trim().toLowerCase(), openEstateAction);
            }
            for (OpenEstateAction openEstateAction : treeMap.values()) {
                this.actionBox.addItem(openEstateAction);
            }
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"40dlu:grow", (JPanel)((Object)this));
            defaultFormBuilder.add(this.actionBox).xy(1, defaultFormBuilder.nextRow());
            this.updateLocalization();
        }

        @Override
        public SearchEqualsImpl getCondition() {
            OpenEstateAction openEstateAction = (OpenEstateAction)this.actionBox.getSelectedItem();
            SearchEqualsImpl searchEqualsImpl = new SearchEqualsImpl();
            searchEqualsImpl.setValue(openEstateAction != null ? openEstateAction.name() : null);
            searchEqualsImpl.setCaseSensitive(false);
            searchEqualsImpl.setLike(false);
            return searchEqualsImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return SearchEqualsImpl.class;
        }

        @Override
        public void setCondition(SearchEqualsImpl searchEqualsImpl) {
            OpenEstateAction openEstateAction;
            super.setCondition(searchEqualsImpl);
            try {
                String string = searchEqualsImpl != null ? StringUtils.trimToNull((String)searchEqualsImpl.getValue()) : null;
                openEstateAction = string != null ? OpenEstateAction.valueOf((String)string) : null;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't set condition!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                openEstateAction = null;
            }
            this.actionBox.setSelectedItem(openEstateAction);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.actionBox.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private static class NumericIntervalWidget
    extends CriteriaWidget<SearchNumericImpl> {
        private NumberFormat intervalFormat;
        private JCheckBox intervalMinBox;
        private JFormattedTextField intervalMinField;
        private JCheckBox intervalMaxBox;
        private JFormattedTextField intervalMaxField;

        private NumericIntervalWidget(int n) {
            this.build(n);
        }

        private void build(int n) {
            this.intervalFormat = NumberFormat.getNumberInstance();
            this.intervalFormat.setMaximumFractionDigits(n);
            this.intervalFormat.setMinimumFractionDigits(0);
            this.intervalMinField = new JFormattedTextField(this.intervalFormat);
            this.intervalMinField.setEnabled(false);
            this.intervalMinBox = new JCheckBox();
            this.intervalMinBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NumericIntervalWidget.this.intervalMinField.setEnabled(NumericIntervalWidget.this.intervalMinBox.isSelected());
                }
            });
            this.intervalMaxField = new JFormattedTextField(this.intervalFormat);
            this.intervalMaxField.setEnabled(false);
            this.intervalMaxBox = new JCheckBox();
            this.intervalMaxBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NumericIntervalWidget.this.intervalMaxField.setEnabled(NumericIntervalWidget.this.intervalMaxBox.isSelected());
                }
            });
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"pref, 3dlu, 20dlu:grow, 3dlu, pref, 3dlu, 20dlu:grow", (JPanel)((Object)this));
            defaultFormBuilder.add((Component)this.intervalMinBox).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.intervalMinField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.intervalMaxBox).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.intervalMaxField).xy(7, defaultFormBuilder.row());
            this.updateLocalization();
        }

        @Override
        public SearchNumericImpl getCondition() {
            SearchNumericImpl searchNumericImpl = new SearchNumericImpl();
            try {
                if (this.intervalMinBox.isSelected() && this.intervalMinField.isEnabled()) {
                    this.intervalMinField.commitEdit();
                }
            }
            catch (ParseException parseException) {
                LOGGER.warn("Can't parse min value!");
                LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            }
            try {
                if (this.intervalMaxBox.isSelected() && this.intervalMaxField.isEnabled()) {
                    this.intervalMaxField.commitEdit();
                }
            }
            catch (ParseException parseException) {
                LOGGER.warn("Can't parse max value!");
                LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            }
            Number number = this.intervalMinBox.isSelected() ? (Number)((Number)this.intervalMinField.getValue()) : (Number)null;
            searchNumericImpl.setMin(number != null ? BigDecimal.valueOf(number.doubleValue()) : null);
            Number number2 = this.intervalMaxBox.isSelected() ? (Number)((Number)this.intervalMaxField.getValue()) : (Number)null;
            searchNumericImpl.setMax(number2 != null ? BigDecimal.valueOf(number2.doubleValue()) : null);
            return searchNumericImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return SearchNumericImpl.class;
        }

        @Override
        public void setCondition(SearchNumericImpl searchNumericImpl) {
            super.setCondition(searchNumericImpl);
            BigDecimal bigDecimal = searchNumericImpl != null ? searchNumericImpl.getMin() : null;
            this.intervalMinBox.setSelected(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0);
            this.intervalMinField.setValue(Float.valueOf(this.intervalMinBox.isSelected() ? bigDecimal.floatValue() : 0.0f));
            this.intervalMinField.setEnabled(this.intervalMinBox.isSelected());
            BigDecimal bigDecimal2 = searchNumericImpl != null ? searchNumericImpl.getMax() : null;
            this.intervalMaxBox.setSelected(bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0);
            this.intervalMaxField.setValue(Float.valueOf(this.intervalMaxBox.isSelected() ? bigDecimal2.floatValue() : 0.0f));
            this.intervalMaxField.setEnabled(this.intervalMaxBox.isSelected());
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.intervalMinBox.setEnabled(bl);
            this.intervalMinField.setEnabled(bl);
            this.intervalMaxBox.setEnabled(bl);
            this.intervalMaxField.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.intervalMinBox.setText(I18N.tr("min") + ":");
            this.intervalMinBox.setToolTipText(I18N.tr("Enable this option, if you want to provide a minimal value."));
            this.intervalMinField.setToolTipText(I18N.tr("Enter a minimal value for your search criterion."));
            this.intervalMaxBox.setText(I18N.tr("max") + ":");
            this.intervalMaxBox.setToolTipText(I18N.tr("Enable this option, if you want to provide a maximal value."));
            this.intervalMaxField.setToolTipText(I18N.tr("Enter a maximal value for your search criterion."));
        }
    }

    private static class DateIntervalWidget
    extends CriteriaWidget<SearchDateTimeImpl> {
        private JCheckBox intervalMinBox;
        private DefaultDatePicker intervalMinField;
        private JCheckBox intervalMaxBox;
        private DefaultDatePicker intervalMaxField;

        private DateIntervalWidget() {
            this((DateFormat)null);
        }

        private DateIntervalWidget(DateFormat dateFormat) {
            this.build(dateFormat);
        }

        private void build(DateFormat dateFormat) {
            this.intervalMinField = new DefaultDatePicker();
            this.intervalMinField.setEnabled(false);
            if (dateFormat != null) {
                this.intervalMinField.setFormats(new DateFormat[]{dateFormat});
            }
            this.intervalMinBox = new JCheckBox();
            this.intervalMinBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DateIntervalWidget.this.intervalMinField.setEnabled(DateIntervalWidget.this.intervalMinBox.isSelected());
                }
            });
            this.intervalMaxField = new DefaultDatePicker();
            this.intervalMaxField.setEnabled(false);
            if (dateFormat != null) {
                this.intervalMaxField.setFormats(new DateFormat[]{dateFormat});
            }
            this.intervalMaxBox = new JCheckBox();
            this.intervalMaxBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DateIntervalWidget.this.intervalMaxField.setEnabled(DateIntervalWidget.this.intervalMaxBox.isSelected());
                }
            });
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"pref, 3dlu, 20dlu:grow, 3dlu, pref, 3dlu, 20dlu:grow", (JPanel)((Object)this));
            defaultFormBuilder.add((Component)this.intervalMinBox).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.intervalMinField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.intervalMaxBox).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.intervalMaxField).xy(7, defaultFormBuilder.row());
            this.updateLocalization();
        }

        @Override
        public SearchDateTimeImpl getCondition() {
            Date date;
            Date date2;
            SearchDateTimeImpl searchDateTimeImpl = new SearchDateTimeImpl();
            try {
                if (this.intervalMinBox.isSelected() && this.intervalMinField.isEnabled()) {
                    this.intervalMinField.commitEdit();
                }
            }
            catch (ParseException parseException) {
                LOGGER.warn("Can't parse min value!");
                LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            }
            try {
                if (this.intervalMaxBox.isSelected() && this.intervalMaxField.isEnabled()) {
                    this.intervalMaxField.commitEdit();
                }
            }
            catch (ParseException parseException) {
                LOGGER.warn("Can't parse max value!");
                LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            }
            Date date3 = date2 = this.intervalMinBox.isSelected() ? this.intervalMinField.getDate() : null;
            if (date2 != null) {
                searchDateTimeImpl.setBegin(date2);
            }
            Date date4 = date = this.intervalMaxBox.isSelected() ? this.intervalMaxField.getDate() : null;
            if (date != null) {
                searchDateTimeImpl.setEnd(date);
            }
            return searchDateTimeImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return SearchDateTimeImpl.class;
        }

        @Override
        public void setCondition(SearchDateTimeImpl searchDateTimeImpl) {
            super.setCondition(searchDateTimeImpl);
            this.intervalMinBox.setSelected(searchDateTimeImpl != null && searchDateTimeImpl.getBegin() != null);
            this.intervalMinField.setEnabled(this.intervalMinBox.isEnabled());
            this.intervalMinField.setDate(this.intervalMinBox.isSelected() ? searchDateTimeImpl.getBegin() : null);
            this.intervalMaxBox.setSelected(searchDateTimeImpl != null && searchDateTimeImpl.getEnd() != null);
            this.intervalMaxField.setEnabled(this.intervalMaxBox.isEnabled());
            this.intervalMaxField.setDate(this.intervalMaxBox.isSelected() ? searchDateTimeImpl.getEnd() : null);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.intervalMinBox.setEnabled(bl);
            this.intervalMinField.setEnabled(bl);
            this.intervalMaxBox.setEnabled(bl);
            this.intervalMaxField.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.intervalMinBox.setText(I18N.tr("from") + ":");
            this.intervalMinBox.setToolTipText(I18N.tr("Enable this option, if you want to provide a begin date."));
            this.intervalMinField.setToolTipText(I18N.tr("Enter the begin date for your search criterion."));
            this.intervalMaxBox.setText(I18N.tr("until") + ":");
            this.intervalMaxBox.setToolTipText(I18N.tr("Enable this option, if you want to provide an end date."));
            this.intervalMaxField.setToolTipText(I18N.tr("Enter the end date for your search criterion."));
        }
    }

    private static class EqualsWidget
    extends CriteriaWidget<SearchEqualsImpl> {
        private JTextField equalsValueField;
        private JCheckBox equalsCaseSensitiveBox;
        private JCheckBox equalsLikeBox;

        private EqualsWidget() {
            this.build();
        }

        private void build() {
            this.equalsValueField = new JTextField();
            this.equalsCaseSensitiveBox = new JCheckBox();
            this.equalsLikeBox = new JCheckBox();
            this.equalsLikeBox.setName("criteriaEqualsLikeBox");
            JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
            jPanel.add(this.equalsCaseSensitiveBox);
            jPanel.add(new JLabel(" "));
            jPanel.add(this.equalsLikeBox);
            this.setLayout(new BorderLayout());
            this.add(this.equalsValueField, "Center");
            this.add(jPanel, "South");
            this.updateLocalization();
        }

        @Override
        public SearchEqualsImpl getCondition() {
            SearchEqualsImpl searchEqualsImpl = new SearchEqualsImpl();
            searchEqualsImpl.setValue(this.equalsValueField.getText());
            searchEqualsImpl.setCaseSensitive(this.equalsCaseSensitiveBox.isSelected());
            searchEqualsImpl.setLike(this.equalsLikeBox.isSelected());
            return searchEqualsImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return SearchEqualsImpl.class;
        }

        @Override
        public void setCondition(SearchEqualsImpl searchEqualsImpl) {
            super.setCondition(searchEqualsImpl);
            this.equalsValueField.setText(searchEqualsImpl != null ? StringUtils.trimToEmpty((String)searchEqualsImpl.getValue()) : "");
            this.equalsCaseSensitiveBox.setSelected(searchEqualsImpl != null && searchEqualsImpl.isCaseSensitive());
            this.equalsLikeBox.setSelected(searchEqualsImpl != null && searchEqualsImpl.isLike());
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.equalsValueField.setEnabled(bl);
            this.equalsCaseSensitiveBox.setEnabled(bl);
            this.equalsLikeBox.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.equalsValueField.setToolTipText(I18N.tr("Enter a text, that you want to search for."));
            this.equalsCaseSensitiveBox.setText(I18N.tr("Search case sensitive."));
            this.equalsCaseSensitiveBox.setToolTipText(I18N.tr("Enable this option, if you want to search for the text case sensitively."));
            this.equalsLikeBox.setText(I18N.tr("Search with placeholders."));
            this.equalsLikeBox.setToolTipText(I18N.tr("Enable this option, if the search text contains placeholders."));
        }
    }

    private static class CountryWidget
    extends CriteriaWidget<SearchEqualsImpl> {
        private JComboBox<CountryObject> countryBox;

        private CountryWidget() {
            this.build();
        }

        private void build() {
            this.countryBox = new JComboBox<CountryObject>(CountryObject.getObjects());
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"40dlu:grow", (JPanel)((Object)this));
            defaultFormBuilder.add(this.countryBox).xy(1, defaultFormBuilder.nextRow());
            this.updateLocalization();
        }

        @Override
        public SearchEqualsImpl getCondition() {
            CountryObject countryObject = (CountryObject)this.countryBox.getSelectedItem();
            SearchEqualsImpl searchEqualsImpl = new SearchEqualsImpl();
            searchEqualsImpl.setValue(countryObject != null ? countryObject.getCode() : null);
            searchEqualsImpl.setCaseSensitive(false);
            searchEqualsImpl.setLike(false);
            return searchEqualsImpl;
        }

        @Override
        public Class getCriteriaClass() {
            return SearchEqualsImpl.class;
        }

        @Override
        public void setCondition(SearchEqualsImpl searchEqualsImpl) {
            super.setCondition(searchEqualsImpl);
            this.selectCountry(searchEqualsImpl != null ? StringUtils.trimToNull((String)searchEqualsImpl.getValue()) : null);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.countryBox.setEnabled(bl);
        }

        private void selectCountry(String string) {
            for (int i = 0; i < this.countryBox.getItemCount(); ++i) {
                CountryObject countryObject = this.countryBox.getItemAt(i);
                if (!countryObject.getCode().equals(string)) continue;
                this.countryBox.setSelectedIndex(i);
                break;
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.countryBox.setToolTipText(I18N.tr("Select a country for your search criterion."));
        }
    }

    private static abstract class CriteriaWidget<T>
    extends AbstractPanel {
        private JLabel label = new JLabel();

        private CriteriaWidget() {
            this.label.setForeground(Color.DARK_GRAY);
            this.label.setVerticalAlignment(1);
            this.label.setHorizontalAlignment(4);
        }

        public abstract T getCondition();

        public abstract Class getCriteriaClass();

        public void setCondition(T t) {
            if (t != null && !this.getCriteriaClass().isInstance(t)) {
                throw new IllegalArgumentException("Condition does not match criteria class!");
            }
        }
    }

    private static enum CriteriaType implements Translatable
    {
        STREET(I18n.marktr((String)"street")),
        STREET_NR(I18n.marktr((String)"street-nr")),
        CITY(I18n.marktr((String)"place")),
        DISTRICT(I18n.marktr((String)"district")),
        POSTAL_CODE(I18n.marktr((String)"postcode")),
        REGION(I18n.marktr((String)"region")),
        COUNTRY(I18n.marktr((String)"country")),
        ESTATE_ATTRIBUTE(I18n.marktr((String)"attribute")),
        ESTATE_ACTION(I18n.marktr((String)"marketing")),
        ESTATE_TYPE(I18n.marktr((String)"property type")),
        ESTATE_STATUS(I18n.marktr((String)"status"));

        private final String i18nKey;

        private CriteriaType(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AgencySearchCriteriaPanel.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AgencySearchCriteriaPanel.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    private class CriteriaPanel
    extends AbstractPanel {
        private CriteriaType currentCriteria = null;
        private OpenEstateAttrib currentAttrib = null;
        private final ArrayList<CriteriaWidget> currentWidgets = new ArrayList();
        private AbstractI18nAction showTypesAction;
        private JButton showTypesButton;
        private AbstractI18nAction addAlternativeAction;
        private AbstractI18nAction removeAction;
        private AbstractI18nAction moveUpAction;
        private AbstractI18nAction moveDownAction;
        private JPanel topPanel;
        private JPanel mainPanel;
        private DefaultFormBuilder mainPanelBuilder;

        private CriteriaPanel() {
            this.build();
        }

        private void addAlternative(Object object) {
            if (this.currentCriteria == null || this.currentWidgets.isEmpty()) {
                this.selectWidget(object);
                return;
            }
            CriteriaWidget criteriaWidget = AgencySearchCriteriaPanel.this.createCriteriaWidget(this.currentCriteria, this.currentAttrib, object);
            criteriaWidget.label.setText(I18N.tr("or") + ":");
            this.currentWidgets.add(criteriaWidget);
            this.mainPanelBuilder.add((Component)criteriaWidget.label).xy(1, this.mainPanelBuilder.nextRow(), CellConstraints.DEFAULT, CellConstraints.TOP);
            this.mainPanelBuilder.add((Component)((Object)criteriaWidget)).xy(3, this.mainPanelBuilder.row());
            this.revalidate();
            this.repaint();
        }

        private void build() {
            this.addAlternativeAction = new CriteriaAddAlternativeAction(this);
            this.moveUpAction = new CriteriaMoveUpAction(this);
            this.moveDownAction = new CriteriaMoveDownAction(this);
            this.removeAction = new CriteriaRemoveAction(this);
            this.showTypesAction = new CriteriaShowTypesAction(this);
            this.showTypesButton = new JButton((Action)this.showTypesAction);
            this.showTypesButton.setFont(this.showTypesButton.getFont().deriveFont(1));
            this.showTypesButton.setContentAreaFilled(false);
            this.showTypesButton.setHorizontalAlignment(2);
            this.mainPanel = new JPanel();
            this.topPanel = new ButtonBarBuilder().addFixed((JComponent)this.showTypesButton).addRelatedGap().addGrowing((JComponent)new JSeparator()).addRelatedGap().addFixed((JComponent)new JButton((Action)this.moveUpAction)).addRelatedGap().addFixed((JComponent)new JButton((Action)this.moveDownAction)).addRelatedGap().addFixed((JComponent)new JButton((Action)this.addAlternativeAction)).addRelatedGap().addFixed((JComponent)new JButton((Action)this.removeAction)).getPanel();
            this.setLayout(new BorderLayout(5, 5));
            this.add(this.topPanel, "North");
            this.add(this.mainPanel, "Center");
            this.updateLocalization();
            this.selectWidget(null);
        }

        public List<Object> save() {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.currentWidgets.isEmpty() || this.currentCriteria == null) {
                return arrayList;
            }
            ArrayList arrayList2 = new ArrayList();
            for (CriteriaWidget criteriaWidget : this.currentWidgets) {
                if (!criteriaWidget.isVisible() || !criteriaWidget.isEnabled() || (object = criteriaWidget.getCondition()) == null) continue;
                arrayList2.add(object);
            }
            for (CriteriaWidget<Object> criteriaWidget : arrayList2) {
                object = AgencySearchCriteriaPanel.getCriteriaValue(this.currentCriteria, this.currentAttrib, criteriaWidget);
                arrayList.add(object);
            }
            return arrayList;
        }

        private void selectWidget(Object object) {
            Object object2;
            this.mainPanel.removeAll();
            this.mainPanelBuilder = DefaultFormBuilder.create((String)"[30dlu,pref], 3dlu, pref:grow", (JPanel)this.mainPanel);
            if (this.currentCriteria == null) {
                this.revalidate();
                this.repaint();
                return;
            }
            if (this.currentWidgets.isEmpty() && (object2 = AgencySearchCriteriaPanel.this.createCriteriaWidget(this.currentCriteria, this.currentAttrib, object)) != null) {
                this.currentWidgets.add((CriteriaWidget)((Object)object2));
            }
            for (CriteriaWidget criteriaWidget : this.currentWidgets) {
                int n = this.mainPanelBuilder.nextRow();
                criteriaWidget.label.setText(n > 1 ? I18N.tr("or") + ":" : "");
                this.mainPanelBuilder.add((Component)criteriaWidget.label).xy(1, n, CellConstraints.DEFAULT, CellConstraints.TOP);
                this.mainPanelBuilder.add((Component)((Object)criteriaWidget)).xy(3, n);
            }
            this.revalidate();
            this.repaint();
        }

        private void setCriteriaEnabled(boolean bl) {
            if (this.currentCriteria != null) {
                if (CriteriaType.ESTATE_ATTRIBUTE.equals((Object)this.currentCriteria)) {
                    if (this.currentAttrib != null) {
                        AgencySearchCriteriaPanel.this.setCriteriaItemEnabled(this.currentAttrib, bl);
                    }
                } else {
                    AgencySearchCriteriaPanel.this.setCriteriaItemEnabled(this.currentCriteria, bl);
                }
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.showTypesAction.setEnabled(bl);
            this.addAlternativeAction.setEnabled(bl);
            this.removeAction.setEnabled(bl);
            for (CriteriaWidget criteriaWidget : this.currentWidgets) {
                criteriaWidget.setEnabled(bl);
            }
        }

        public void setFirst(boolean bl) {
            this.moveUpAction.setEnabled(!bl);
        }

        public void setLast(boolean bl) {
            this.moveDownAction.setEnabled(!bl);
        }

        private void setWidget(CriteriaType criteriaType, OpenEstateAttrib openEstateAttrib, Object object) {
            this.setCriteriaEnabled(true);
            this.currentCriteria = criteriaType;
            this.currentAttrib = openEstateAttrib;
            this.currentWidgets.clear();
            this.selectWidget(object);
            this.addAlternativeAction.setEnabled(this.currentCriteria != null);
            this.updateLocalization();
            this.setCriteriaEnabled(false);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            int n = 0;
            for (CriteriaWidget criteriaWidget : this.currentWidgets) {
                criteriaWidget.label.setText(n > 0 ? I18N.tr("or") + ":" : "");
                ++n;
            }
            if (this.currentCriteria == null) {
                this.showTypesButton.setFont(this.showTypesButton.getFont().deriveFont(0));
                this.showTypesButton.setText(StringUtils.capitalize((String)I18N.tr("select criterion")));
            } else {
                switch (this.currentCriteria) {
                    case ESTATE_ATTRIBUTE: {
                        this.showTypesButton.setFont(this.showTypesButton.getFont().deriveFont(1));
                        this.showTypesButton.setText(this.currentAttrib.getGroup().getTranslation() + " / " + this.currentAttrib.getTranslation());
                        break;
                    }
                    default: {
                        this.showTypesButton.setFont(this.showTypesButton.getFont().deriveFont(1));
                        this.showTypesButton.setText(this.currentCriteria.getTranslation());
                    }
                }
            }
        }
    }
}

