/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.CustomValueImpl;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexLengthAttrib;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.DbGeoCountry;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogEntry;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogMessage;
import com.openindex.openestate.tool.agency.db.DbAgencyExportPublishing;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyExposeFile;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.HttpTransport;
import com.openindex.openestate.tool.agency.export.IdxCsvFormat;
import com.openindex.openestate.tool.agency.export.ImmoXmlFormat;
import com.openindex.openestate.tool.agency.export.ImmobiliareXmlFormat;
import com.openindex.openestate.tool.agency.export.ImmobilienNetFormat;
import com.openindex.openestate.tool.agency.export.ImmonetDeFormat;
import com.openindex.openestate.tool.agency.export.ImmopoolDeFormat;
import com.openindex.openestate.tool.agency.export.ImmowebItFormat;
import com.openindex.openestate.tool.agency.export.Is24CsvFormat;
import com.openindex.openestate.tool.agency.export.Is24XmlFormat;
import com.openindex.openestate.tool.agency.export.KyeroXmlFormat;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.agency.export.OpenEstateXmlFormat;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlFormat;
import com.openindex.openestate.tool.agency.export.WebsiteExportFilter;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlFormat;
import com.openindex.openestate.tool.agency.export.WebsitePhp1Format;
import com.openindex.openestate.tool.agency.export.WohnenInSuedtirolItFormat;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractPdfExpose;
import com.openindex.openestate.tool.agency.expose.PdfDetailedExpose;
import com.openindex.openestate.tool.agency.expose.PdfShortExpose;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpgradeHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.UpgradeAdapter;
import com.openindex.openestate.tool.utils.ImageUtils;
import com.openindex.openestate.tool.utils.Relation;
import com.openindex.openestate.tool.utils.RelationObject;
import eu.medsea.mimeutil.MimeType;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyUpgradeExtension
extends UpgradeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyUpgradeExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyUpgradeExtension.class);
    public static final String UPGRADE_CONTACTS = "OpenEstate-Tool-Agency.contacts";
    public static final String UPGRADE_ESTATES = "OpenEstate-Tool-Agency.estates";
    public static final String UPGRADE_EXPORTS = "OpenEstate-Tool-Agency.exports";
    public static final String UPGRADE_EXPORTS_LOGS = "OpenEstate-Tool-Agency.exports_logs";
    public static final String UPGRADE_EXPOSES = "OpenEstate-Tool-Agency.exposes";
    public static final String UPGRADE_GEODB = "OpenEstate-Tool-Agency.geodb";
    public static final String UPGRADE_GEODB_AREA = "OpenEstate-Tool-Agency.geodb_area";
    public static final String UPGRADE_SEARCHES = "OpenEstate-Tool-Agency.searches";

    private static DbAgencyContact createContact(Reader reader) throws DocumentException {
        DbAgencyContact dbAgencyContact = new DbAgencyContact();
        dbAgencyContact.item = new AgentContactImpl(OpenEstateUtils.loadDocument((Reader)reader));
        if (dbAgencyContact.item.getCustomValues().hasCustomValue("notes")) {
            String string = dbAgencyContact.item.getCustomValues().getCustomValue("notes").getText();
            dbAgencyContact.item.getCustomValues().getValueMap().remove("notes");
            if (string != null && string.trim().length() > 0) {
                dbAgencyContact.notes = string.trim();
            }
        }
        dbAgencyContact.enabled = false;
        return dbAgencyContact;
    }

    private static DbAgencyObject createEstate(Reader reader, Map<Long, Long> map, Map<Long, Long> map2) throws DocumentException {
        Object object;
        Object object2;
        DbAgencyObject dbAgencyObject = new DbAgencyObject();
        dbAgencyObject.item = new EstateImpl();
        dbAgencyObject.item.readFromXml(OpenEstateUtils.loadDocument((Reader)reader));
        AbstractTypeImpl abstractTypeImpl = dbAgencyObject.item.getTypeSpec();
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        for (Map.Entry object32 : dbAgencyObject.item.getAttributes().entrySet()) {
            object2 = (OpenEstateAttrib)object32.getKey();
            object = (AbstractAttribImpl)object32.getValue();
            if (object == null || object.hasEmptyValue()) {
                LOGGER.info("Ignoring empty attribute (" + dbAgencyObject.item.getId() + ")!");
                LOGGER.info("> attrib : " + object2);
                arrayList.add((OpenEstateAttrib)object2);
                continue;
            }
            if (abstractTypeImpl.hasAttrib((OpenEstateAttrib)object2)) continue;
            LOGGER.info("Ignoring unsupported attribute (" + dbAgencyObject.item.getId() + ")!");
            LOGGER.info("> type   : " + dbAgencyObject.item.getType());
            LOGGER.info("> attrib : " + object2);
            arrayList.add((OpenEstateAttrib)object2);
        }
        for (OpenEstateAttrib openEstateAttrib : arrayList) {
            dbAgencyObject.item.removeAttribute(openEstateAttrib);
        }
        Object object4 = dbAgencyObject.item.getAttributes().values().iterator();
        while (object4.hasNext()) {
            AbstractAttribImpl abstractAttribImpl = (AbstractAttribImpl)object4.next();
            if (abstractAttribImpl.hasEmptyValue() || !(abstractAttribImpl instanceof ComplexLengthAttrib)) continue;
            object2 = (ComplexLengthAttrib)abstractAttribImpl;
            object2.getValue().setUnit(LengthValue.Unit.KM);
        }
        if (dbAgencyObject.item.getCustomValues().hasCustomValue("status")) {
            object4 = dbAgencyObject.item.getCustomValues().getCustomValue("status").getString();
            dbAgencyObject.status = "ENTWURF".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.DRAFT : ("PRUEFUNG".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.REVIEW : ("VERMITTLUNG".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.PUBLISHED : ("VERMITTELT".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.BROKERED : ("NICHT_VERMITTELT".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.NOT_BROKERED : ("ABLAGE".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.TRAY : DbAgencyObject.Status.DRAFT)))));
        } else if (dbAgencyObject.item.getCustomValues().hasCustomValue("estate.status")) {
            object4 = dbAgencyObject.item.getCustomValues().getCustomValue("estate.status").getString();
            dbAgencyObject.status = "DRAFT".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.DRAFT : ("REVIEW".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.REVIEW : ("PUBLISHED".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.PUBLISHED : ("BROKERED".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.BROKERED : ("NOT_BROKERED".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.NOT_BROKERED : ("TRAY".equalsIgnoreCase((String)object4) ? DbAgencyObject.Status.TRAY : DbAgencyObject.Status.DRAFT)))));
        }
        if (dbAgencyObject.item.getCustomValues().hasCustomValue("notes")) {
            object4 = dbAgencyObject.item.getCustomValues().getCustomValue("notes").getText();
            if (object4 != null && ((String)object4).trim().length() > 0) {
                dbAgencyObject.notes = ((String)object4).trim();
            }
        } else if (dbAgencyObject.item.getCustomValues().hasCustomValue("estate.notes") && (object4 = dbAgencyObject.item.getCustomValues().getCustomValue("estate.notes").getText()) != null && ((String)object4).trim().length() > 0) {
            dbAgencyObject.notes = ((String)object4).trim();
        }
        if (dbAgencyObject.item.getCustomValues().hasCustomValue("group")) {
            object4 = dbAgencyObject.item.getCustomValues().getCustomValue("group").getInteger();
            if (object4 != null && ((BigInteger)object4).intValue() > 0) {
                dbAgencyObject.item.setGroupId(((BigInteger)object4).toString());
            }
        } else if (dbAgencyObject.item.getCustomValues().hasCustomValue("estate.group") && (object4 = dbAgencyObject.item.getCustomValues().getCustomValue("estate.group").getInteger()) != null && ((BigInteger)object4).intValue() > 0) {
            dbAgencyObject.item.setGroupId(((BigInteger)object4).toString());
        }
        if (dbAgencyObject.item.getCustomValues().hasCustomValue("nr_intern")) {
            object4 = dbAgencyObject.item.getCustomValues().getCustomValue("nr_intern").getString();
            if (object4 != null && ((String)object4).trim().length() > 0) {
                dbAgencyObject.importId = object4;
            }
        } else if (dbAgencyObject.item.getCustomValues().hasCustomValue("import.id") && (object4 = dbAgencyObject.item.getCustomValues().getCustomValue("import.id").getString()) != null && ((String)object4).trim().length() > 0) {
            dbAgencyObject.importId = object4;
        }
        if (dbAgencyObject.item.getCustomValues().hasCustomValue("import.hash") && (object4 = dbAgencyObject.item.getCustomValues().getCustomValue("import.hash").getString()) != null && ((String)object4).trim().length() > 0) {
            dbAgencyObject.importHash = object4;
        }
        if (dbAgencyObject.item.getCustomValues().hasCustomValue("export.enabled")) {
            object4 = dbAgencyObject.item.getCustomValues().getCustomValue("export.enabled").getBoolean();
            dbAgencyObject.exportMode = Boolean.TRUE.equals(object4) ? DbAgencyObject.ExportMode.SELECTED_EXPORTS : DbAgencyObject.ExportMode.NEVER;
        }
        if (dbAgencyObject.item.getCustomValues().hasCustomValue("export.always") && Boolean.TRUE.equals(object4 = dbAgencyObject.item.getCustomValues().getCustomValue("export.always").getBoolean())) {
            dbAgencyObject.exportMode = DbAgencyObject.ExportMode.ALL;
        }
        dbAgencyObject.exportIds = new ArrayList<Long>();
        for (Map.Entry entry : dbAgencyObject.item.getCustomValues().getValueMap().entrySet()) {
            object2 = (String)entry.getKey();
            if (!((String)object2).startsWith("export.interface.")) continue;
            object = ((CustomValueImpl)entry.getValue()).getInteger().longValue();
            if (map2.containsKey(object)) {
                dbAgencyObject.exportIds.add(map2.get(object));
                continue;
            }
            LOGGER.warn("Unknown export-id #" + object + " (" + dbAgencyObject.item.getId() + ")");
        }
        object4 = dbAgencyObject.item.getContactId();
        if (object4 != null && ((String)object4).trim().length() < 1) {
            dbAgencyObject.item.setContactId(null);
        } else if (object4 != null) {
            try {
                Long l = Long.valueOf((String)(((String)object4).contains(".") ? ((String)object4).split("\\.")[1] : object4));
                if (!map.containsKey(l)) {
                    dbAgencyObject.item.setContactId(null);
                } else {
                    dbAgencyObject.contactId = map.get(l);
                }
            }
            catch (Exception exception) {
                dbAgencyObject.item.setContactId(null);
            }
        }
        return dbAgencyObject;
    }

    private static DbFile createEstateFile(EstateAttachmentImpl estateAttachmentImpl, File file) {
        DbFile dbFile = new DbFile();
        dbFile.name = estateAttachmentImpl.getFileAsName();
        dbFile.mimeType = estateAttachmentImpl.getMimeType();
        dbFile.published = estateAttachmentImpl.isPublished();
        dbFile.type = estateAttachmentImpl.getType();
        dbFile.size = file.length();
        dbFile.url = null;
        dbFile.translations = new HashMap();
        for (String string : estateAttachmentImpl.getTitleLanguages()) {
            DbFile.Translation translation = new DbFile.Translation();
            translation.title = estateAttachmentImpl.getTitle(string);
            dbFile.translations.put(string, translation);
        }
        if (dbFile.mimeType == null || !dbFile.mimeType.contains("/")) {
            MimeType mimeType = ImmoToolUtils.getMimeType((File)file);
            dbFile.mimeType = mimeType != null ? mimeType.toString() : "application/octet-stream";
        }
        return dbFile;
    }

    private static Map<Long, String> createEstateNrMap(Properties properties) {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("nr.")) continue;
            Long l = Long.valueOf(string.substring(3));
            hashMap.put(l, properties.getProperty(string));
        }
        return hashMap;
    }

    private static Map<Long, String> createEstateValueMap(Properties properties) {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Long l;
            String string = (String)enumeration.nextElement();
            if (string.startsWith("nr.")) continue;
            if (string.startsWith("id.")) {
                l = Long.valueOf(string.substring(3));
                hashMap.put(l, properties.getProperty(string));
                continue;
            }
            l = Long.valueOf(string);
            hashMap.put(l, properties.getProperty(string));
        }
        return hashMap;
    }

    private static DbAgencyExport createExport(Properties properties, Map<Long, Long> map) {
        Object object;
        String string;
        Object object2;
        DbAgencyExport dbAgencyExport = new DbAgencyExport();
        dbAgencyExport.id = ImmoToolUtils.getPropertyAsLong((String)"id", (Long)0L, (Properties)properties);
        dbAgencyExport.enabled = ImmoToolUtils.getPropertyAsBoolean((String)"active", (Boolean)true, (Properties)properties);
        dbAgencyExport.limit = ImmoToolUtils.getPropertyAsInteger((String)"limit", (Integer)0, (Properties)properties);
        dbAgencyExport.name = properties.getProperty("title", "");
        dbAgencyExport.lastExecution = null;
        dbAgencyExport.transferMode = Boolean.TRUE.equals(ImmoToolUtils.getPropertyAsBoolean((String)"export.incremental", (Boolean)false, (Properties)properties)) ? AbstractFormat.TransferMode.INCREMENTAL : AbstractFormat.TransferMode.FULL;
        Object object3 = properties.getProperty("transport", "").trim();
        if ("http".equalsIgnoreCase((String)object3)) {
            object2 = new HttpTransport();
            ((HttpTransport)object2).setHttpLogin(ImmoToolUtils.getPropertyAsBoolean((String)"transport.http.anonymous", (Boolean)false, (Properties)properties).equals(false));
            ((HttpTransport)object2).setHttpLoginPass(properties.getProperty("transport.http.pass"));
            ((HttpTransport)object2).setHttpLoginUser(properties.getProperty("transport.http.user"));
            string = properties.getProperty("transport.http.url");
            try {
                if (StringUtils.isNotBlank((CharSequence)string)) {
                    ((HttpTransport)object2).setHttpUrl(new URI(string));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read URL from export #" + dbAgencyExport.id + "!");
                LOGGER.warn("> " + string);
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
            }
            object = properties.getProperty("transport.http");
            if ("put".equalsIgnoreCase((String)object)) {
                ((HttpTransport)object2).setHttpMode(HttpTransport.TransportMode.PUT);
            } else if ("post".equalsIgnoreCase((String)object)) {
                ((HttpTransport)object2).setHttpMode(HttpTransport.TransportMode.POST);
                ((HttpTransport)object2).setHttpPostMultipart(ImmoToolUtils.getPropertyAsBoolean((String)"transport.http.post.multipart", (Boolean)false, (Properties)properties));
                ((HttpTransport)object2).setHttpPostMultipartKey(properties.getProperty("transport.http.post.multipart.key"));
            }
            dbAgencyExport.setTransport((AbstractTransport)object2);
        } else if ("ftp".equalsIgnoreCase((String)object3)) {
            object2 = new FtpTransport();
            ((FtpTransport)object2).setFtpHost(properties.getProperty("transport.ftp.host", "localhost"));
            ((FtpTransport)object2).setFtpPort(ImmoToolUtils.getPropertyAsInteger((String)"transport.ftp.port", (Integer)21, (Properties)properties));
            ((FtpTransport)object2).setFtpPath(properties.getProperty("transport.ftp.path", "/"));
            ((FtpTransport)object2).setFtpPassive(ImmoToolUtils.getPropertyAsBoolean((String)"transport.ftp.passive", (Boolean)true, (Properties)properties));
            ((FtpTransport)object2).setFtpLogin(ImmoToolUtils.getPropertyAsBoolean((String)"transport.ftp.anonymous", (Boolean)false, (Properties)properties).equals(false));
            ((FtpTransport)object2).setFtpLoginPass(properties.getProperty("transport.ftp.pass"));
            ((FtpTransport)object2).setFtpLoginUser(properties.getProperty("transport.ftp.user"));
            dbAgencyExport.setTransport((AbstractTransport)object2);
        } else if ("local".equalsIgnoreCase((String)object3)) {
            object2 = new LocalTransport();
            ((LocalTransport)object2).setLocalDirectory(new File(properties.getProperty("transport.local.directory", SystemUtils.JAVA_IO_TMPDIR)));
            dbAgencyExport.setTransport((AbstractTransport)object2);
        } else {
            LOGGER.warn("Can't find transport for '" + (String)object3 + "'");
        }
        object3 = null;
        object2 = properties.getProperty("export", "").trim();
        if ("idx_csv".equalsIgnoreCase((String)object2)) {
            object3 = new IdxCsvFormat();
        } else if ("is24_csv".equalsIgnoreCase((String)object2)) {
            object3 = new Is24CsvFormat();
        } else if ("is24_xml".equalsIgnoreCase((String)object2)) {
            object3 = new Is24XmlFormat();
        } else if ("immonet".equalsIgnoreCase((String)object2)) {
            object3 = new ImmonetDeFormat();
        } else if ("immopool".equalsIgnoreCase((String)object2)) {
            object3 = new ImmopoolDeFormat();
        } else if ("immoxml_xml".equalsIgnoreCase((String)object2)) {
            object3 = new ImmoXmlFormat();
        } else if ("immobiliare_xml".equalsIgnoreCase((String)object2)) {
            object3 = new ImmobiliareXmlFormat();
        } else if ("immobilien.net".equalsIgnoreCase((String)object2)) {
            object3 = new ImmobilienNetFormat();
        } else if ("immoweb.it".equalsIgnoreCase((String)object2)) {
            object3 = new ImmowebItFormat();
        } else if ("immowelt".equalsIgnoreCase((String)object2)) {
            object3 = new OpenImmoXmlFormat();
        } else if ("kyero_xml".equalsIgnoreCase((String)object2)) {
            object3 = new KyeroXmlFormat();
        } else if ("openestate_xml".equalsIgnoreCase((String)object2)) {
            object3 = new OpenEstateXmlFormat();
        } else if ("openimmo_xml".equalsIgnoreCase((String)object2)) {
            object3 = new OpenImmoXmlFormat();
        } else if ("openimmo_xml/at".equalsIgnoreCase((String)object2)) {
            object3 = new OpenImmoXmlFormat();
        } else if ("website_html".equalsIgnoreCase((String)object2)) {
            object3 = new WebsiteHtmlFormat();
        } else if ("website_php".equalsIgnoreCase((String)object2)) {
            object3 = new WebsitePhp1Format();
        } else if ("wohnen-in-suedtirol.it".equalsIgnoreCase((String)object2)) {
            object3 = new WohnenInSuedtirolItFormat();
        } else {
            LOGGER.warn("Can't find format for '" + (String)object2 + "'");
        }
        if (object3 != null) {
            Object object4;
            Object object5;
            AbstractFormat abstractFormat;
            ((AbstractFormat)object3).setAttachmentMimeTypes(properties.getProperty("export.mimetypes", "").split(","));
            ((AbstractFormat)object3).setAttachmentMode(AbstractFormat.AttachmentMode.FILE);
            ((AbstractFormat)object3).setPropertyAddressHiddenIfUnpublished(ImmoToolUtils.getPropertyAsBoolean((String)"export.unpublishedAddressHidden", (Boolean)true, (Properties)properties));
            ((AbstractFormat)object3).setPropertyPrefix(properties.getProperty("export.id_prefix"));
            ((AbstractFormat)object3).setPropertyImageLimit(ImmoToolUtils.getPropertyAsInteger((String)"export.image.count", (Integer)-1, (Properties)properties));
            ((AbstractFormat)object3).setAttachmentImageScale(ImmoToolUtils.getPropertyAsBoolean((String)"export.image.scale", (Boolean)false, (Properties)properties));
            ((AbstractFormat)object3).setAttachmentImageScaleHeight(ImmoToolUtils.getPropertyAsInteger((String)"export.image.scale.height", (Integer)0, (Properties)properties));
            ((AbstractFormat)object3).setAttachmentImageScaleWidth(ImmoToolUtils.getPropertyAsInteger((String)"export.image.scale.width", (Integer)0, (Properties)properties));
            ((AbstractFormat)object3).setPropertyDescriptionWithEnergyCertificate(ImmoToolUtils.getPropertyAsBoolean((String)"export.energyCertificateAppendedToDescription", (Boolean)false, (Properties)properties));
            ((AbstractFormat)object3).setPropertyImageWatermark(ImmoToolUtils.getPropertyAsBoolean((String)"export.image.watermark", (Boolean)false, (Properties)properties));
            ((AbstractFormat)object3).setPropertyImageWatermarkAlpha(ImmoToolUtils.getPropertyAsInteger((String)"export.image.watermark.alpha", (Integer)0, (Properties)properties));
            ((AbstractFormat)object3).setPropertyImageWatermarkHeight(ImmoToolUtils.getPropertyAsInteger((String)"export.image.watermark.height", (Integer)0, (Properties)properties));
            ((AbstractFormat)object3).setPropertyImageWatermarkWidth(ImmoToolUtils.getPropertyAsInteger((String)"export.image.watermark.width", (Integer)0, (Properties)properties));
            ((AbstractFormat)object3).setPropertyVideoLimit(ImmoToolUtils.getPropertyAsInteger((String)"export.video.count", (Integer)-1, (Properties)properties));
            string = properties.getProperty("addressPublishing");
            if ("never".equalsIgnoreCase(string)) {
                ((AbstractFormat)object3).setPropertyAddressPublication(PublishingMode.NEVER);
            } else if ("always".equalsIgnoreCase(string)) {
                ((AbstractFormat)object3).setPropertyAddressPublication(PublishingMode.ALWAYS);
            } else {
                ((AbstractFormat)object3).setPropertyAddressPublication(PublishingMode.DEFAULT);
            }
            object = ImmoToolUtils.getPropertyAsBoolean((String)"export.image.all", (Boolean)false, (Properties)properties);
            if (Boolean.TRUE.equals(object)) {
                ((AbstractFormat)object3).setPropertyFilePublication(PublishingMode.ALWAYS);
            } else {
                ((AbstractFormat)object3).setPropertyFilePublication(PublishingMode.DEFAULT);
            }
            Boolean bl = ImmoToolUtils.getPropertyAsBoolean((String)"export.zipped", (Boolean)true, (Properties)properties);
            if (Boolean.TRUE.equals(bl)) {
                ((AbstractFormat)object3).setCompression(AbstractFormat.Compression.ZIP);
            } else {
                ((AbstractFormat)object3).setCompression(AbstractFormat.Compression.UNCOMPRESSED);
            }
            String string2 = properties.getProperty("export.image.watermark.position");
            if ("top.left".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.TOP_LEFT);
            } else if ("top.center".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.TOP_CENTER);
            } else if ("top.right".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.TOP_RIGHT);
            } else if ("center.left".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.CENTER_LEFT);
            } else if ("center.center".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.CENTER_CENTER);
            } else if ("center.right".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.CENTER_RIGHT);
            } else if ("bottom.left".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.BOTTOM_LEFT);
            } else if ("bottom.center".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.BOTTOM_CENTER);
            } else if ("bottom.right".equalsIgnoreCase(string2)) {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(AbstractFormat.ImageWatermarkPosition.BOTTOM_RIGHT);
            } else {
                ((AbstractFormat)object3).setPropertyImageWatermarkPosition(null);
            }
            String string3 = properties.getProperty("export.language");
            if (string3 != null) {
                ((AbstractFormat)object3).setLanguage(OpenEstateUtils.buildLocale((String)string3));
            }
            if (object3 instanceof AbstractXmlFormat) {
                abstractFormat = (AbstractXmlFormat)object3;
                object5 = properties.getProperty("export.linebreak");
                if ("html".equalsIgnoreCase((String)object5)) {
                    ((AbstractXmlFormat)abstractFormat).setXmlLineBreak(AbstractXmlFormat.LineBreakMode.HTML);
                } else if ("xhtml".equalsIgnoreCase((String)object5)) {
                    ((AbstractXmlFormat)abstractFormat).setXmlLineBreak(AbstractXmlFormat.LineBreakMode.XHTML);
                } else if ("native".equalsIgnoreCase((String)object5)) {
                    ((AbstractXmlFormat)abstractFormat).setXmlLineBreak(AbstractXmlFormat.LineBreakMode.NATIVE);
                } else {
                    ((AbstractXmlFormat)abstractFormat).setXmlLineBreak(AbstractXmlFormat.LineBreakMode.XHTML);
                }
            }
            if (object3 instanceof IdxCsvFormat) {
                abstractFormat = (IdxCsvFormat)object3;
                abstractFormat.setAgentId(properties.getProperty("export.idx_csv.agent_id"));
                abstractFormat.setPropertyPublicId(ImmoToolUtils.getPropertyAsBoolean((String)"export.idx_csv.public_id_used", (Boolean)false, (Properties)properties));
            }
            if (object3 instanceof Is24CsvFormat) {
                abstractFormat = (Is24CsvFormat)object3;
                abstractFormat.setAgentId(properties.getProperty("export.is24_csv.agent_id"));
                abstractFormat.setPropertyPublicId(ImmoToolUtils.getPropertyAsBoolean((String)"export.is24_csv.public_id_used", (Boolean)false, (Properties)properties));
            }
            if (object3 instanceof Is24XmlFormat) {
                abstractFormat = (Is24XmlFormat)object3;
                abstractFormat.setAgentId(properties.getProperty("export.is24_xml.agent_id"));
                abstractFormat.setAgentMail(properties.getProperty("export.is24_xml.techn_mail"));
                abstractFormat.setPropertyPublicId(ImmoToolUtils.getPropertyAsBoolean((String)"export.is24_xml.public_id_used", (Boolean)false, (Properties)properties));
            }
            if (object3 instanceof ImmonetDeFormat) {
                abstractFormat = (ImmonetDeFormat)object3;
                object5 = properties.getProperty("export.openimmo.immonet.recipient");
                if ("ivd".equalsIgnoreCase((String)object5)) {
                    ((ImmonetDeFormat)abstractFormat).setImmonetRecipient(ImmonetDeFormat.Recipient.IVD);
                } else {
                    ((ImmonetDeFormat)abstractFormat).setImmonetRecipient(ImmonetDeFormat.Recipient.ALL);
                }
            }
            if (object3 instanceof ImmoXmlFormat) {
                abstractFormat = (ImmoXmlFormat)object3;
                abstractFormat.setAgentId(properties.getProperty("export.immoxml.agent_id"));
                abstractFormat.setAgentMail(properties.getProperty("export.immoxml.techn_mail"));
                ((ImmoXmlFormat)abstractFormat).setImmoXmlAgentId(properties.getProperty("export.immoxml.immoxml_agent_id"));
                ((ImmoXmlFormat)abstractFormat).setImmoXmlPropertyPublicIdExported(ImmoToolUtils.getPropertyAsBoolean((String)"export.immoxml.submit_public_id", (Boolean)false, (Properties)properties));
                object5 = properties.getProperty("export.immoxml.attachment_location");
                if ("extern".equalsIgnoreCase((String)object5)) {
                    ((ImmoXmlFormat)abstractFormat).setImmoXmlAttachmentLocation(AbstractFormat.AttachmentMarker.EXTERN);
                } else if ("intern".equalsIgnoreCase((String)object5)) {
                    ((ImmoXmlFormat)abstractFormat).setImmoXmlAttachmentLocation(AbstractFormat.AttachmentMarker.INTERN);
                }
                object4 = properties.getProperty("export.immoxml.publish_prices");
                if ("always".equals(object4)) {
                    abstractFormat.setPropertyPricePublication(PublishingMode.ALWAYS);
                } else if ("never".equals(object4)) {
                    abstractFormat.setPropertyPricePublication(PublishingMode.NEVER);
                } else {
                    abstractFormat.setPropertyPricePublication(PublishingMode.DEFAULT);
                }
            }
            if (object3 instanceof ImmobiliareXmlFormat) {
                abstractFormat = (ImmobiliareXmlFormat)object3;
                abstractFormat.setAgentMail(properties.getProperty("export.immobiliare.agent_mail"));
                ((ImmobiliareXmlFormat)abstractFormat).setImmobiliarePublisherMail(properties.getProperty("export.immobiliare.publisher_mail"));
                abstractFormat.setPropertyPublicId(ImmoToolUtils.getPropertyAsBoolean((String)"export.immobiliare.public_id_used", (Boolean)false, (Properties)properties));
                object5 = properties.getProperty("export.base.url");
                try {
                    if (!StringUtils.isBlank((CharSequence)object5)) {
                        ((ImmobiliareXmlFormat)abstractFormat).setImmobiliareBaseUrl(new URI((String)object5));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.warn("Can't read URL from export #" + dbAgencyExport.id + "!");
                    LOGGER.warn("> " + (String)object5);
                    LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                }
            }
            if (object3 instanceof KyeroXmlFormat) {
                abstractFormat = (KyeroXmlFormat)object3;
                object5 = properties.getProperty("export.base.url");
                try {
                    if (!StringUtils.isBlank((CharSequence)object5)) {
                        ((KyeroXmlFormat)abstractFormat).setKyeroBaseUrl(new URI((String)object5));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.warn("Can't read URL from export #" + dbAgencyExport.id + "!");
                    LOGGER.warn("> " + (String)object5);
                    LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                }
            }
            if (object3 instanceof OpenImmoXmlFormat) {
                abstractFormat = (OpenImmoXmlFormat)object3;
                abstractFormat.setAgentId(properties.getProperty("export.openimmo.agent_id"));
                abstractFormat.setAgentMail(properties.getProperty("export.openimmo.techn_mail"));
                ((OpenImmoXmlFormat)abstractFormat).setOpenImmoAgentId(properties.getProperty("export.openimmo.openimmo_agent_id"));
                ((OpenImmoXmlFormat)abstractFormat).setOpenImmoPropertyPublicIdExported(ImmoToolUtils.getPropertyAsBoolean((String)"export.openimmo.submit_public_id", (Boolean)false, (Properties)properties));
                object5 = properties.getProperty("export.openimmo.attachment_location");
                if ("extern".equalsIgnoreCase((String)object5)) {
                    ((OpenImmoXmlFormat)abstractFormat).setOpenImmoAttachmentLocation(AbstractFormat.AttachmentMarker.EXTERN);
                } else if ("intern".equalsIgnoreCase((String)object5)) {
                    ((OpenImmoXmlFormat)abstractFormat).setOpenImmoAttachmentLocation(AbstractFormat.AttachmentMarker.INTERN);
                }
                object4 = properties.getProperty("export.openimmo.publish_prices");
                if ("always".equals(object4)) {
                    abstractFormat.setPropertyPricePublication(PublishingMode.ALWAYS);
                } else if ("never".equals(object4)) {
                    abstractFormat.setPropertyPricePublication(PublishingMode.NEVER);
                } else {
                    abstractFormat.setPropertyPricePublication(PublishingMode.DEFAULT);
                }
                if ("openimmo_xml/at".equalsIgnoreCase((String)object2)) {
                    ((OpenImmoXmlFormat)abstractFormat).setOpenImmoExtensionAt10Enabled(true);
                }
                if ("immowelt".equalsIgnoreCase((String)object2)) {
                    ((OpenImmoXmlFormat)abstractFormat).setOpenImmoVersion(OpenImmoVersion.V1_2_6);
                }
            }
            if (object3 instanceof WebsiteHtmlFormat) {
                String string4;
                abstractFormat = (WebsiteHtmlFormat)object3;
                ((WebsiteHtmlFormat)abstractFormat).setHtmlShowAgent(ImmoToolUtils.getPropertyAsBoolean((String)"export.expose.agent", (Boolean)true, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlShowContact(ImmoToolUtils.getPropertyAsBoolean((String)"export.expose.contact", (Boolean)true, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlShowTerms(ImmoToolUtils.getPropertyAsBoolean((String)"export.expose.terms", (Boolean)true, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlFeedAtom(ImmoToolUtils.getPropertyAsBoolean((String)"export.feed.atom", (Boolean)false, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlFeedImmobiliare(ImmoToolUtils.getPropertyAsBoolean((String)"export.feed.immobiliare", (Boolean)false, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlFeedKyero(ImmoToolUtils.getPropertyAsBoolean((String)"export.feed.kyero", (Boolean)false, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlFeedRss(ImmoToolUtils.getPropertyAsBoolean((String)"export.feed.rss", (Boolean)false, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlFeedTrovit(ImmoToolUtils.getPropertyAsBoolean((String)"export.feed.trovit", (Boolean)false, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlImageColorbox(ImmoToolUtils.getPropertyAsBoolean((String)"export.images.colorbox", (Boolean)false, (Properties)properties));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlTitle(properties.getProperty("export.company"));
                ((WebsiteHtmlFormat)abstractFormat).setHtmlStylesheet(properties.getProperty("export.style.src"));
                object5 = properties.getProperty("export.base.url");
                try {
                    if (!StringUtils.isBlank((CharSequence)object5)) {
                        ((WebsiteHtmlFormat)abstractFormat).setHtmlBaseUrl(new URI((String)object5));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.warn("Can't read URL from export #" + dbAgencyExport.id + "!");
                    LOGGER.warn("> " + (String)object5);
                    LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                }
                object4 = ImmoToolUtils.getPropertyAsLong((String)"export.expose.pdf.setup", null, (Properties)properties);
                if (object4 != null && map.containsKey(object4)) {
                    dbAgencyExport.exposeId = map.get(object4);
                }
                if ("osm".equalsIgnoreCase(string4 = properties.getProperty("export.map"))) {
                    ((WebsiteHtmlFormat)abstractFormat).setHtmlMapType(WebsiteHtmlFormat.MapType.OSM);
                } else if ("google".equalsIgnoreCase(string4)) {
                    ((WebsiteHtmlFormat)abstractFormat).setHtmlMapType(WebsiteHtmlFormat.MapType.GOOGLE);
                }
                ArrayList<WebsiteExportFilter> arrayList = new ArrayList<WebsiteExportFilter>();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string5 = enumeration.nextElement().toString();
                    if (!string5.startsWith("export.filter.")) continue;
                    String[] stringArray = properties.get(string5).toString().split(",");
                    String string6 = stringArray[0].trim().length() > 0 ? stringArray[0].trim() : null;
                    String string7 = stringArray.length > 1 && stringArray[1].trim().length() > 0 ? stringArray[1].trim() : null;
                    arrayList.add(new WebsiteExportFilter(OpenEstateUtils.lookupAction((String)string6), OpenEstateUtils.lookupEstate(string7)));
                }
                if (!arrayList.isEmpty()) {
                    ((WebsiteHtmlFormat)abstractFormat).setHtmlFilters(arrayList.toArray(new WebsiteExportFilter[0]));
                }
            }
            if (object3 instanceof WebsitePhp1Format) {
                abstractFormat = (WebsitePhp1Format)object3;
                ((WebsitePhp1Format)abstractFormat).setPhpShowContactForm(ImmoToolUtils.getPropertyAsBoolean((String)"export.expose.contact.form", (Boolean)true, (Properties)properties));
                ((WebsitePhp1Format)abstractFormat).setPhpShowContactPerson(ImmoToolUtils.getPropertyAsBoolean((String)"export.expose.contact.person", (Boolean)true, (Properties)properties));
                ((WebsitePhp1Format)abstractFormat).setPhpShowTerms(ImmoToolUtils.getPropertyAsBoolean((String)"export.expose.terms", (Boolean)true, (Properties)properties));
                ((WebsitePhp1Format)abstractFormat).setPhpFeedAtom(ImmoToolUtils.getPropertyAsBoolean((String)"export.feed.atom", (Boolean)false, (Properties)properties));
                ((WebsitePhp1Format)abstractFormat).setPhpFeedRss(ImmoToolUtils.getPropertyAsBoolean((String)"export.feed.rss", (Boolean)false, (Properties)properties));
                ((WebsitePhp1Format)abstractFormat).setPhpFeedTrovit(ImmoToolUtils.getPropertyAsBoolean((String)"export.feed.trovit", (Boolean)false, (Properties)properties));
                ((WebsitePhp1Format)abstractFormat).setPhpTitle(properties.getProperty("export.pageTitle"));
                ((WebsitePhp1Format)abstractFormat).setPhpSaveScripts(ImmoToolUtils.getPropertyAsBoolean((String)"export.send.scripts", (Boolean)true, (Properties)properties));
                ((WebsitePhp1Format)abstractFormat).setPhpStylesheet(properties.getProperty("export.style.src"));
                object5 = ImmoToolUtils.getPropertyAsLong((String)"export.expose.pdf.setup", null, (Properties)properties);
                if (object5 != null && map.containsKey(object5)) {
                    dbAgencyExport.exposeId = map.get(object5);
                }
            }
            if (object3 instanceof WohnenInSuedtirolItFormat) {
                abstractFormat = (WohnenInSuedtirolItFormat)object3;
                abstractFormat.setAgentId(properties.getProperty("wis.agent_id"));
                abstractFormat.setPropertyPublicId(ImmoToolUtils.getPropertyAsBoolean((String)"export.wis_it.public_id_used", (Boolean)false, (Properties)properties));
            }
            dbAgencyExport.setFormat((AbstractFormat)object3);
        }
        return dbAgencyExport;
    }

    private static DbAgencyExportLog createExportLog(Properties properties, Map<Long, Long> map) {
        DbAgencyExportLog dbAgencyExportLog = new DbAgencyExportLog();
        dbAgencyExportLog.limit = ImmoToolUtils.getPropertyAsInteger((String)"interface.limit", (Integer)0, (Properties)properties);
        dbAgencyExportLog.time = new Date(ImmoToolUtils.getPropertyAsLong((String)"time", (Long)0L, (Properties)properties));
        dbAgencyExportLog.transport = properties.getProperty("transport");
        dbAgencyExportLog.format = properties.getProperty("format");
        dbAgencyExportLog.transferMode = Boolean.TRUE.equals(ImmoToolUtils.getPropertyAsBoolean((String)"fulltransfer", (Boolean)false, (Properties)properties)) ? AbstractFormat.TransferMode.FULL : AbstractFormat.TransferMode.INCREMENTAL;
        dbAgencyExportLog.countUpdates = 0;
        dbAgencyExportLog.countDeletes = 0;
        dbAgencyExportLog.countErrors = 0;
        dbAgencyExportLog.entries = new HashMap<Long, DbAgencyExportLogEntry>();
        dbAgencyExportLog.messages = new ArrayList<DbAgencyExportLogMessage>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            try {
                Serializable serializable;
                Long l;
                Object object;
                String string = (String)enumeration.nextElement();
                if (string.startsWith("estate.id.") || string.startsWith("estate.updated.")) {
                    object = Long.valueOf(properties.getProperty(string));
                    if (!map.containsKey(object)) continue;
                    l = map.get(object);
                    serializable = new DbAgencyExportLogEntry();
                    ((DbAgencyExportLogEntry)serializable).action = DbAgencyExportAction.UPDATE;
                    ((DbAgencyExportLogEntry)serializable).objectId = l;
                    ((DbAgencyExportLogEntry)serializable).exported = true;
                    dbAgencyExportLog.entries.put(l, (DbAgencyExportLogEntry)serializable);
                    ++dbAgencyExportLog.countUpdates;
                    continue;
                }
                if (string.startsWith("estate.removed.")) {
                    object = Long.valueOf(properties.getProperty(string));
                    if (!map.containsKey(object)) continue;
                    l = map.get(object);
                    serializable = new DbAgencyExportLogEntry();
                    ((DbAgencyExportLogEntry)serializable).action = DbAgencyExportAction.DELETE;
                    ((DbAgencyExportLogEntry)serializable).objectId = l;
                    ((DbAgencyExportLogEntry)serializable).exported = true;
                    dbAgencyExportLog.entries.put(l, (DbAgencyExportLogEntry)serializable);
                    ++dbAgencyExportLog.countDeletes;
                    continue;
                }
                if (!string.startsWith("estate.error.") || !map.containsKey(l = Long.valueOf((object = string.split("\\."))[((String[])object).length - 1]))) continue;
                serializable = map.get(l);
                DbAgencyExportLogEntry dbAgencyExportLogEntry = new DbAgencyExportLogEntry();
                dbAgencyExportLogEntry.action = DbAgencyExportAction.UPDATE;
                dbAgencyExportLogEntry.objectId = (Long)serializable;
                dbAgencyExportLogEntry.exported = false;
                dbAgencyExportLog.entries.put((Long)serializable, dbAgencyExportLogEntry);
                ++dbAgencyExportLog.countErrors;
                String string2 = StringUtils.trimToNull((String)properties.getProperty(string));
                if (string2 == null) continue;
                DbAgencyExportLogMessage dbAgencyExportLogMessage = new DbAgencyExportLogMessage();
                dbAgencyExportLogMessage.objectId = (Long)serializable;
                dbAgencyExportLogMessage.level = DbAgencyExportLogMessage.Level.ERROR;
                dbAgencyExportLogMessage.text = string2;
                dbAgencyExportLog.messages.add(dbAgencyExportLogMessage);
            }
            catch (Exception exception) {
                LOGGER.warn("problem while parsing summary!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return dbAgencyExportLog;
    }

    private static DbAgencyExpose createExpose(Properties properties) {
        DbAgencyExpose dbAgencyExpose = new DbAgencyExpose();
        dbAgencyExpose.id = ImmoToolUtils.getPropertyAsLong((String)"Id", (Long)0L, (Properties)properties);
        dbAgencyExpose.name = properties.getProperty("Name");
        dbAgencyExpose.settings = new HashMap<String, String>();
        AbstractPdfExpose abstractPdfExpose = null;
        String string = properties.getProperty("Builder");
        if ("expose.detailed".equalsIgnoreCase(string)) {
            dbAgencyExpose.type = "detailedPdf";
            abstractPdfExpose = new PdfDetailedExpose();
        } else if ("expose.short".equalsIgnoreCase(string)) {
            dbAgencyExpose.type = "shortPdf";
            abstractPdfExpose = new PdfShortExpose();
        } else {
            LOGGER.warn("Can't find expose for '" + string + "'");
        }
        if (abstractPdfExpose != null) {
            ArrayList<Enum> arrayList;
            AbstractPdfExpose abstractPdfExpose2;
            abstractPdfExpose.setLocale(OpenEstateUtils.buildLocale((String)properties.getProperty("Locale", Locale.GERMAN.getLanguage())));
            abstractPdfExpose.setResolution(ImmoToolUtils.getPropertyAsInteger((String)"Image.Resolution", (Integer)0, (Properties)properties));
            abstractPdfExpose.setShowContact(ImmoToolUtils.getPropertyAsBoolean((String)"PublishContact", (Boolean)true, (Properties)properties));
            Boolean bl = ImmoToolUtils.getPropertyAsBoolean((String)"Landscape", null, (Properties)properties);
            if (Boolean.TRUE.equals(bl)) {
                abstractPdfExpose.setOrientation(AbstractExpose.Orientation.LANDSCAPE);
            } else if (Boolean.FALSE.equals(bl)) {
                abstractPdfExpose.setOrientation(AbstractExpose.Orientation.PORTRAIT);
            }
            int n = ImmoToolUtils.getPropertyAsInteger((String)"PublishAdress", (Integer)0, (Properties)properties);
            switch (n) {
                case 1: {
                    abstractPdfExpose.setPublishAddress(PublishingMode.NEVER);
                    break;
                }
                case 2: {
                    abstractPdfExpose.setPublishAddress(PublishingMode.ALWAYS);
                    break;
                }
                default: {
                    abstractPdfExpose.setPublishAddress(PublishingMode.DEFAULT);
                }
            }
            AbstractPdfExpose abstractPdfExpose3 = abstractPdfExpose;
            abstractPdfExpose3.setBodyHeadBgColor(ImmoToolUtils.getPropertyAsColor((String)"Body.Head.BgColor", null, (Properties)properties));
            abstractPdfExpose3.setBodyHeadFgColor(ImmoToolUtils.getPropertyAsColor((String)"Body.Head.FgColor", null, (Properties)properties));
            abstractPdfExpose3.setBodyHeadNumbered(ImmoToolUtils.getPropertyAsBoolean((String)"NumberedHeadlines", (Boolean)true, (Properties)properties));
            abstractPdfExpose3.setBodyTextBgColor(ImmoToolUtils.getPropertyAsColor((String)"Body.Text.BgColor", null, (Properties)properties));
            abstractPdfExpose3.setBodyTextFgColor(ImmoToolUtils.getPropertyAsColor((String)"Body.Text.FgColor", null, (Properties)properties));
            abstractPdfExpose3.setBorderColor(ImmoToolUtils.getPropertyAsColor((String)"Border.Color", null, (Properties)properties));
            abstractPdfExpose3.setEncryption(ImmoToolUtils.getPropertyAsBoolean((String)"Encryption.Enabled", (Boolean)false, (Properties)properties));
            abstractPdfExpose3.setEncryptionAccessibilityAllowed(ImmoToolUtils.getPropertyAsBoolean((String)"Encryption.Allow.Accessibility", (Boolean)true, (Properties)properties));
            abstractPdfExpose3.setEncryptionCopyingAllowed(ImmoToolUtils.getPropertyAsBoolean((String)"Encryption.Allow.Copying", (Boolean)true, (Properties)properties));
            abstractPdfExpose3.setEncryptionPassword(properties.getProperty("Encryption.Password"));
            abstractPdfExpose3.setEncryptionPrintingAllowed(ImmoToolUtils.getPropertyAsBoolean((String)"Encryption.Allow.Printing", (Boolean)true, (Properties)properties));
            abstractPdfExpose3.setFooter(ImmoToolUtils.getPropertyAsBoolean((String)"Footer.Visible", (Boolean)true, (Properties)properties));
            abstractPdfExpose3.setFooterTextFgColor(ImmoToolUtils.getPropertyAsColor((String)"Footer.Text.FgColor", null, (Properties)properties));
            abstractPdfExpose3.setHeader(ImmoToolUtils.getPropertyAsBoolean((String)"Header.Visible", (Boolean)true, (Properties)properties));
            abstractPdfExpose3.setHeaderLogo(ImmoToolUtils.getPropertyAsBoolean((String)"Header.Logo.Visible", (Boolean)true, (Properties)properties));
            abstractPdfExpose3.setHeaderTextCustom(ImmoToolUtils.getPropertyAsBoolean((String)"Header.Text.Custom", (Boolean)true, (Properties)properties));
            abstractPdfExpose3.setHeaderTextCustomLine1(properties.getProperty("Header.Text.Line1"));
            abstractPdfExpose3.setHeaderTextCustomLine2(properties.getProperty("Header.Text.Line2"));
            abstractPdfExpose3.setHeaderTextCustomLine3(properties.getProperty("Header.Text.Line3"));
            abstractPdfExpose3.setHeaderTextFgColor(ImmoToolUtils.getPropertyAsColor((String)"Header.Text.FgColor", null, (Properties)properties));
            int n2 = ImmoToolUtils.getPropertyAsInteger((String)"Body.Text.Align", (Integer)0, (Properties)properties);
            switch (n2) {
                case 1: {
                    abstractPdfExpose3.setBodyTextAlignment(AbstractExpose.HorizontalAlign.CENTER);
                    break;
                }
                case 2: {
                    abstractPdfExpose3.setBodyTextAlignment(AbstractExpose.HorizontalAlign.RIGHT);
                    break;
                }
                case 3: {
                    abstractPdfExpose3.setBodyTextAlignment(AbstractExpose.HorizontalAlign.JUSTIFY);
                    break;
                }
                default: {
                    abstractPdfExpose3.setBodyTextAlignment(AbstractExpose.HorizontalAlign.LEFT);
                }
            }
            n2 = ImmoToolUtils.getPropertyAsInteger((String)"Footer.Alignment", (Integer)0, (Properties)properties);
            switch (n2) {
                case 1: {
                    abstractPdfExpose3.setFooterTextAlignment(AbstractExpose.HorizontalAlign.CENTER);
                    break;
                }
                case 2: {
                    abstractPdfExpose3.setFooterTextAlignment(AbstractExpose.HorizontalAlign.RIGHT);
                    break;
                }
                case 3: {
                    abstractPdfExpose3.setFooterTextAlignment(AbstractExpose.HorizontalAlign.JUSTIFY);
                    break;
                }
                default: {
                    abstractPdfExpose3.setFooterTextAlignment(AbstractExpose.HorizontalAlign.LEFT);
                }
            }
            if (abstractPdfExpose instanceof PdfDetailedExpose) {
                abstractPdfExpose2 = (PdfDetailedExpose)abstractPdfExpose;
                ((PdfDetailedExpose)abstractPdfExpose2).setGallerySeparatePanoramas(ImmoToolUtils.getPropertyAsBoolean((String)"Image.SeparatedPlans", (Boolean)false, (Properties)properties));
                ((PdfDetailedExpose)abstractPdfExpose2).setGallerySeparatePlans(ImmoToolUtils.getPropertyAsBoolean((String)"Image.SeparatedPanoramas", (Boolean)false, (Properties)properties));
                ((PdfDetailedExpose)abstractPdfExpose2).setTermsTextSize(ImmoToolUtils.getPropertyAsInteger((String)"Terms.Text.Size", (Integer)0, (Properties)properties));
                arrayList = new ArrayList();
                for (String string2 : properties.getProperty("Areas", "GENERAL,IMAGES,AGENCY,TERMS").split(",")) {
                    if ("GENERAL".equalsIgnoreCase(string2)) {
                        arrayList.add(PdfDetailedExpose.Area.GENERAL);
                        continue;
                    }
                    if ("IMAGES".equalsIgnoreCase(string2)) {
                        arrayList.add(PdfDetailedExpose.Area.IMAGES);
                        continue;
                    }
                    if ("AGENCY".equalsIgnoreCase(string2)) {
                        arrayList.add(PdfDetailedExpose.Area.AGENCY);
                        continue;
                    }
                    if (!"TERMS".equalsIgnoreCase(string2)) continue;
                    arrayList.add(PdfDetailedExpose.Area.TERMS);
                }
                ((PdfDetailedExpose)abstractPdfExpose2).setAreas(arrayList.toArray(new PdfDetailedExpose.Area[0]));
                int n3 = ImmoToolUtils.getPropertyAsInteger((String)"Image.Gallery", (Integer)0, (Properties)properties);
                switch (n3) {
                    case -1: {
                        ((PdfDetailedExpose)abstractPdfExpose2).setGalleryMode(PdfDetailedExpose.GalleryMode.NO_GALLERY);
                        break;
                    }
                    case 1: {
                        ((PdfDetailedExpose)abstractPdfExpose2).setGalleryMode(PdfDetailedExpose.GalleryMode.ONE_PER_ROW);
                        break;
                    }
                    case 2: {
                        ((PdfDetailedExpose)abstractPdfExpose2).setGalleryMode(PdfDetailedExpose.GalleryMode.TWO_PER_ROW);
                        break;
                    }
                    case 3: {
                        ((PdfDetailedExpose)abstractPdfExpose2).setGalleryMode(PdfDetailedExpose.GalleryMode.THREE_PER_ROW);
                        break;
                    }
                    case 4: {
                        ((PdfDetailedExpose)abstractPdfExpose2).setGalleryMode(PdfDetailedExpose.GalleryMode.FOUR_PER_ROW);
                        break;
                    }
                    case 5: {
                        ((PdfDetailedExpose)abstractPdfExpose2).setGalleryMode(PdfDetailedExpose.GalleryMode.ONE_PER_SITE);
                        break;
                    }
                    case 6: {
                        ((PdfDetailedExpose)abstractPdfExpose2).setGalleryMode(PdfDetailedExpose.GalleryMode.TWO_PER_SITE);
                        break;
                    }
                    default: {
                        ((PdfDetailedExpose)abstractPdfExpose2).setGalleryMode(PdfDetailedExpose.GalleryMode.TWO_PER_ROW);
                    }
                }
            }
            if (abstractPdfExpose instanceof PdfShortExpose) {
                abstractPdfExpose2 = (PdfShortExpose)abstractPdfExpose;
                arrayList = new ArrayList<Enum>();
                for (String string2 : properties.getProperty("PublishContact", "").split(",")) {
                    if ("0".equals(string2.trim())) {
                        arrayList.add(PdfShortExpose.ContactPublishing.NAME);
                        continue;
                    }
                    if ("1".equals(string2.trim())) {
                        arrayList.add(PdfShortExpose.ContactPublishing.PHONE);
                        continue;
                    }
                    if ("2".equals(string2.trim())) {
                        arrayList.add(PdfShortExpose.ContactPublishing.FAX);
                        continue;
                    }
                    if (!"3".equals(string2.trim())) continue;
                    arrayList.add(PdfShortExpose.ContactPublishing.MAIL);
                }
                ((PdfShortExpose)abstractPdfExpose2).setContactPublishings(arrayList.toArray(new PdfShortExpose.ContactPublishing[0]));
                int n4 = ImmoToolUtils.getPropertyAsInteger((String)"Image.Gallery", (Integer)0, (Properties)properties);
                switch (n4) {
                    case -1: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.NO_GALLERY);
                        break;
                    }
                    case 1: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.IMAGE_1x1);
                        break;
                    }
                    case 2: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.PLAN_1x1);
                        break;
                    }
                    case 3: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.IMAGE_PLAN_2x1);
                        break;
                    }
                    case 4: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.PLAN_IMAGE_2x1);
                        break;
                    }
                    case 5: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.IMAGES_2x1);
                        break;
                    }
                    case 6: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.IMAGES_3x1);
                        break;
                    }
                    case 7: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.IMAGES_2x2);
                        break;
                    }
                    case 8: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.IMAGES_3x2);
                        break;
                    }
                    default: {
                        ((PdfShortExpose)abstractPdfExpose2).setGalleryMode(PdfShortExpose.GalleryMode.IMAGES_2x1);
                    }
                }
            }
            dbAgencyExpose.settings.putAll(abstractPdfExpose);
        }
        return dbAgencyExpose;
    }

    private static DbAgencyExposeFile createExposeFile(String string, File file) {
        DbAgencyExposeFile dbAgencyExposeFile = new DbAgencyExposeFile();
        dbAgencyExposeFile.name = string;
        dbAgencyExposeFile.tempContent = file;
        MimeType mimeType = ImmoToolUtils.getMimeType((File)file);
        dbAgencyExposeFile.mimeType = mimeType != null ? mimeType.toString() : "application/octet-stream";
        return dbAgencyExposeFile;
    }

    private static GeoImpl createGeoDb(Reader reader) throws DocumentException {
        Document document = OpenEstateUtils.loadDocument((Reader)reader);
        GeoImpl geoImpl = new GeoImpl();
        geoImpl.readFromXml(document);
        return geoImpl;
    }

    private static DbAgencySearch createSearch(Reader reader) throws DocumentException {
        DbAgencySearch dbAgencySearch = new DbAgencySearch();
        dbAgencySearch.item = new SearchImpl();
        dbAgencySearch.item.readFromXml(OpenEstateUtils.loadDocument((Reader)reader));
        dbAgencySearch.status = new ArrayList<DbAgencyObject.Status>();
        if (dbAgencySearch.item.getParams().containsKey("status")) {
            String[] stringArray;
            for (String string : stringArray = ((String)dbAgencySearch.item.getParams().get("status")).split(",")) {
                if ("DRAFT".equalsIgnoreCase(string)) {
                    dbAgencySearch.status.add(DbAgencyObject.Status.DRAFT);
                    continue;
                }
                if ("REVIEW".equalsIgnoreCase(string)) {
                    dbAgencySearch.status.add(DbAgencyObject.Status.REVIEW);
                    continue;
                }
                if ("PUBLISHED".equalsIgnoreCase(string)) {
                    dbAgencySearch.status.add(DbAgencyObject.Status.PUBLISHED);
                    continue;
                }
                if ("BROKERED".equalsIgnoreCase(string)) {
                    dbAgencySearch.status.add(DbAgencyObject.Status.BROKERED);
                    continue;
                }
                if ("NOT_BROKERED".equalsIgnoreCase(string)) {
                    dbAgencySearch.status.add(DbAgencyObject.Status.NOT_BROKERED);
                    continue;
                }
                if (!"TRAY".equalsIgnoreCase(string)) continue;
                dbAgencySearch.status.add(DbAgencyObject.Status.TRAY);
            }
            dbAgencySearch.item.getParams().remove("status");
        }
        return dbAgencySearch;
    }

    private static List<Relation> getAgencyCalendarRelations(long l, DbAgencyObject dbAgencyObject) {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        CustomValuesImpl customValuesImpl = dbAgencyObject.item.getCustomValues();
        for (Map.Entry entry : customValuesImpl.getValueMap().entrySet()) {
            String string = (String)entry.getKey();
            if (!string.startsWith("calendar.id.")) continue;
            String string2 = "calendar.uid." + string.substring("calendar.id.".length());
            String string3 = "calendar.text." + string.substring("calendar.id.".length());
            Long l2 = ((CustomValueImpl)entry.getValue()).getInteger().longValue();
            String string4 = customValuesImpl.getCustomValue(string2).getString();
            String string5 = customValuesImpl.hasCustomValue(string3) ? (customValuesImpl.getCustomValue(string3).isText() ? customValuesImpl.getCustomValue(string3).getText() : customValuesImpl.getCustomValue(string3).getString()) : "";
            Relation relation = new Relation();
            relation.setNotes(string5);
            relation.getObjects().add(new RelationObject(relation, String.valueOf(l), "com.openindex.openestate.tool.agency.AgencyEstate"));
            relation.getObjects().add(new RelationObject(relation, l2 + "/" + string4, "com.openindex.openestate.tool.calendar.CalendarEntry"));
            arrayList.add(relation);
        }
        return arrayList;
    }

    private static String[] getGeoDbIds(EstateImpl estateImpl, String string) {
        String[] stringArray = new String[]{"geodb." + string, "estate.geodb." + string};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            int n = 0;
            while (estateImpl.getCustomValues().hasCustomValue(string2 + "." + n)) {
                arrayList.add(estateImpl.getCustomValues().getCustomValue(string2 + "." + n).getString());
                ++n;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Agency"};
    }

    private static void saveGeoDbAreaIds(Connection connection, DbUpgradeHandler dbUpgradeHandler, GeoAreaImpl geoAreaImpl, DbGeoArea dbGeoArea) throws SQLException {
        try {
            dbUpgradeHandler.save(connection, UPGRADE_GEODB_AREA, dbGeoArea.geo.name + "." + geoAreaImpl.getId(), dbGeoArea.id);
        }
        catch (SQLException sQLException) {
            LOGGER.warn("Can't save id for geodb-area!");
            LOGGER.warn("> geo-db       : " + dbGeoArea.geo.name);
            LOGGER.warn("> country-id   : " + geoAreaImpl.getId());
            LOGGER.warn("> country-name : " + geoAreaImpl.getName());
            LOGGER.warn("> " + sQLException.getLocalizedMessage());
            throw sQLException;
        }
        if (dbGeoArea.childAreas != null) {
            block2: for (DbGeoArea dbGeoArea2 : dbGeoArea.childAreas) {
                String string = dbGeoArea2.name;
                for (GeoAreaImpl geoAreaImpl2 : geoAreaImpl.getAreas()) {
                    if (!string.equalsIgnoreCase(geoAreaImpl2.getName())) continue;
                    AgencyUpgradeExtension.saveGeoDbAreaIds(connection, dbUpgradeHandler, geoAreaImpl2, dbGeoArea2);
                    continue block2;
                }
            }
        }
    }

    private static void saveGeoDbCountryIds(Connection connection, DbUpgradeHandler dbUpgradeHandler, GeoCountryImpl geoCountryImpl, DbGeoCountry dbGeoCountry) throws SQLException {
        try {
            dbUpgradeHandler.save(connection, UPGRADE_GEODB_AREA, dbGeoCountry.geo.name + "." + geoCountryImpl.getId(), dbGeoCountry.id);
        }
        catch (SQLException sQLException) {
            LOGGER.warn("Can't save id for geodb-country!");
            LOGGER.warn("> geo-db       : " + dbGeoCountry.geo.name);
            LOGGER.warn("> country-id   : " + geoCountryImpl.getId());
            LOGGER.warn("> country-code : " + geoCountryImpl.getIsoCode());
            LOGGER.warn("> country-name : " + geoCountryImpl.getName());
            LOGGER.warn("> " + sQLException.getLocalizedMessage());
            throw sQLException;
        }
        if (dbGeoCountry.areas != null) {
            block2: for (DbGeoArea dbGeoArea : dbGeoCountry.areas) {
                String string = dbGeoArea.name;
                for (GeoAreaImpl geoAreaImpl : geoCountryImpl.getAreas()) {
                    if (!string.equalsIgnoreCase(geoAreaImpl.getName())) continue;
                    AgencyUpgradeExtension.saveGeoDbAreaIds(connection, dbUpgradeHandler, geoAreaImpl, dbGeoArea);
                    continue block2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void upgrade(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, DbUser dbUser, File file, Properties properties, ImmoToolTask.Callback callback) throws SQLException {
        File file2;
        Object object7;
        Relation relation3;
        Object object2;
        Object object32;
        File file3;
        Object object4;
        Object object5;
        AbstractMap abstractMap;
        this.setMessage("Upgrade agency...", callback);
        DbAgencyExtension dbAgencyExtension = AgencyPluginUtils.getDbAgencyExtension(abstractDbDriver);
        DbFilesHandler dbFilesHandler = dbAgencyExtension.getFilesHandler();
        DbGeoHandler dbGeoHandler = dbAgencyExtension.getGeoHandler();
        DbLanguagesHandler dbLanguagesHandler = dbAgencyExtension.getLanguagesHandler();
        DbAgencyContactsHandler dbAgencyContactsHandler = dbAgencyExtension.getContactsHandler();
        DbAgencyExportsHandler dbAgencyExportsHandler = dbAgencyExtension.getExportsHandler();
        DbAgencyExposesHandler dbAgencyExposesHandler = dbAgencyExtension.getExposeHandler();
        DbAgencyObjectsHandler dbAgencyObjectsHandler = dbAgencyExtension.getObjectsHandler();
        DbAgencySearchesHandler dbAgencySearchesHandler = dbAgencyExtension.getSearchesHandler();
        DbUpgradeHandler dbUpgradeHandler = dbExtension.getUpgradeHandler();
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
        this.setMessage("> Load languages...", callback);
        Map map = dbLanguagesHandler.getLanguageMap(connection, null);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        File file4 = new File(file.getAbsolutePath() + File.separator + "contacts");
        if (file4.isDirectory()) {
            abstractMap = new TreeMap();
            for (File file5 : file4.listFiles((FileFilter)suffixFileFilter)) {
                try {
                    abstractMap.put(Long.valueOf(file5.getName().split("\\.")[0]), file5);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read contact-id!");
                    LOGGER.warn("> from " + file5.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read contact-id!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
            for (Map.Entry entry : abstractMap.entrySet()) {
                Long l = (Long)entry.getKey();
                this.setMessage("> Import contact #" + l, callback);
                File entry2 = (File)entry.getValue();
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(entry2), "UTF-8");
                    Throwable throwable = null;
                    try {
                        DbAgencyContact dbAgencyContact = AgencyUpgradeExtension.createContact(inputStreamReader);
                        dbAgencyContact.id = 0L;
                        dbAgencyContactsHandler.saveContact(connection, dbAgencyContact);
                        hashMap.put(l, dbAgencyContact.id);
                        dbUpgradeHandler.save(connection, UPGRADE_CONTACTS, String.valueOf(l), dbAgencyContact.id);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStreamReader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)inputStreamReader).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((Reader)inputStreamReader).close();
                    }
                }
                catch (Exception entry22) {
                    LOGGER.warn("Can't import contact!");
                    LOGGER.warn("> from " + entry2.getAbsolutePath());
                    LOGGER.warn("> " + entry22.getLocalizedMessage(), (Throwable)entry22);
                    this.setMessage("WARNING: Can't import contact!", callback);
                    this.setMessage("> " + entry22.getLocalizedMessage(), callback);
                }
            }
        }
        abstractMap = new HashMap();
        File file6 = new File(file.getAbsolutePath() + File.separator + "exposes");
        if (file6.isDirectory()) {
            void var29_49;
            TreeMap<Long, File> treeMap = new TreeMap<Long, File>();
            File[] fileArray = file6.listFiles((FileFilter)suffixFileFilter);
            int n = fileArray.length;
            boolean hashMap3 = false;
            while (var29_49 < n) {
                File file5 = fileArray[var29_49];
                try {
                    treeMap.put(Long.valueOf(file5.getName().split("\\.")[0]), file5);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read expose-id!");
                    LOGGER.warn("> from " + file5.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read expose-id!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
                ++var29_49;
            }
            for (Map.Entry file7 : treeMap.entrySet()) {
                Long l = (Long)file7.getKey();
                this.setMessage("> Import expose #" + l, callback);
                File file8 = (File)file7.getValue();
                try {
                    FileInputStream fileInputStream = new FileInputStream(file8);
                    object5 = null;
                    try {
                        Properties properties2 = new Properties();
                        properties2.loadFromXML(fileInputStream);
                        object4 = AgencyUpgradeExtension.createExpose(properties2);
                        ((DbAgencyExpose)object4).id = 0L;
                        dbAgencyExposesHandler.saveExpose(connection, (DbAgencyExpose)object4);
                        abstractMap.put(l, ((DbAgencyExpose)object4).id);
                        dbUpgradeHandler.save(connection, UPGRADE_EXPOSES, String.valueOf(l), ((DbAgencyExpose)object4).id);
                        File file9 = new File(file6.getAbsolutePath() + File.separator + l + ".pdf");
                        if (!file9.isFile()) continue;
                        DbAgencyExposeFile dbAgencyExposeFile = AgencyUpgradeExtension.createExposeFile("template.pdf", file9);
                        dbAgencyExposeFile.id = 0L;
                        dbAgencyExposeFile.exposeId = ((DbAgencyExpose)object4).id;
                        dbAgencyExposesHandler.saveExposeFile(connection, dbAgencyExposeFile);
                        AbstractExpose abstractExpose = ((DbAgencyExpose)object4).createExposeBuilder();
                        abstractExpose.setTemplate(true);
                        abstractExpose.setTemplateId(dbAgencyExposeFile.id);
                        ((DbAgencyExpose)object4).setExposeBuilder(abstractExpose);
                        dbAgencyExposesHandler.saveExpose(connection, (DbAgencyExpose)object4);
                    }
                    catch (Throwable throwable) {
                        object5 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (object5 != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object5).addSuppressed(throwable);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't import expose!");
                    LOGGER.warn("> from " + file8.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't import expose!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
        if ((file3 = new File(file.getAbsolutePath() + File.separator + "searches")).isDirectory()) {
            void var30_62;
            TreeMap<Long, File> treeMap = new TreeMap<Long, File>();
            File[] fileArray = file3.listFiles((FileFilter)suffixFileFilter);
            int n = fileArray.length;
            boolean bl = false;
            while (var30_62 < n) {
                File file10 = fileArray[var30_62];
                try {
                    treeMap.put(Long.valueOf(file10.getName().split("\\.")[0]), file10);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read search-id!");
                    LOGGER.warn("> from " + file10.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read search-id!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
                ++var30_62;
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                Long l = (Long)entry.getKey();
                this.setMessage("> Import search #" + l, callback);
                File file11 = (File)entry.getValue();
                try {
                    object5 = new InputStreamReader((InputStream)new FileInputStream(file11), "UTF-8");
                    Throwable throwable = null;
                    try {
                        object4 = AgencyUpgradeExtension.createSearch((Reader)object5);
                        ((DbAgencySearch)((Object)object4)).id = 0L;
                        dbAgencySearchesHandler.saveSearch(connection, (DbSearch)object4);
                        dbUpgradeHandler.save(connection, UPGRADE_SEARCHES, String.valueOf(l), ((DbAgencySearch)((Object)object4)).id);
                    }
                    catch (Throwable throwable5) {
                        Throwable throwable6 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (object5 == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)object5).close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        ((Reader)object5).close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't import search!");
                    LOGGER.warn("> from " + file11.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't import search!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
        HashMap<Long, Long> hashMap2 = new HashMap<Long, Long>();
        File file12 = new File(file.getAbsolutePath() + File.separator + "exports");
        if (file12.isDirectory()) {
            TreeMap<Long, File> treeMap = new TreeMap<Long, File>();
            for (File file13 : file12.listFiles((FileFilter)suffixFileFilter)) {
                try {
                    treeMap.put(Long.valueOf(file13.getName().split("\\.")[0]), file13);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read export-id!");
                    LOGGER.warn("> from " + file13.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read export-id!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                Long l = (Long)entry.getKey();
                this.setMessage("> Import export-interface #" + l, callback);
                File file14 = (File)entry.getValue();
                try {
                    object4 = new FileInputStream(file14);
                    Throwable throwable = null;
                    try {
                        Properties properties3 = new Properties();
                        properties3.loadFromXML((InputStream)object4);
                        DbAgencyExport dbAgencyExport = AgencyUpgradeExtension.createExport(properties3, abstractMap);
                        dbAgencyExport.id = 0L;
                        dbAgencyExportsHandler.saveExport(connection, dbAgencyExport, true, false);
                        hashMap2.put(l, dbAgencyExport.id);
                        dbUpgradeHandler.save(connection, UPGRADE_EXPORTS, String.valueOf(l), dbAgencyExport.id);
                    }
                    catch (Throwable throwable8) {
                        Throwable throwable9 = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (object4 == null) continue;
                        if (throwable != null) {
                            try {
                                ((FileInputStream)object4).close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        ((FileInputStream)object4).close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't import export-interface!");
                    LOGGER.warn("> from " + file14.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't import export-interface!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
        HashMap<String, Long> hashMap3 = new HashMap<String, Long>();
        File file15 = new File(file.getAbsolutePath() + File.separator + "geodata");
        if (file15.isDirectory()) {
            TreeMap<String, File> treeMap = new TreeMap<String, File>();
            for (File file16 : file15.listFiles((FileFilter)suffixFileFilter)) {
                try {
                    treeMap.put(file16.getName().split("\\.")[0], file16);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read geodb-name!");
                    LOGGER.warn("> from " + file16.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read geodb-name!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                String string = (String)entry.getKey();
                this.setMessage("> Import geo-db: " + string, callback);
                File file17 = (File)entry.getValue();
                try {
                    DbGeo dbGeo;
                    GeoImpl geoImpl;
                    Throwable throwable = null;
                    try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file17), "UTF-8");){
                        geoImpl = AgencyUpgradeExtension.createGeoDb(inputStreamReader);
                        dbGeo = DbGeo.createFromXml((GeoImpl)geoImpl);
                    }
                    catch (Throwable throwable11) {
                        Throwable throwable12 = throwable11;
                        throw throwable11;
                    }
                    dbGeoHandler.saveGeoDb(connection, dbGeo, true);
                    hashMap3.put(string, dbGeo.id);
                    dbUpgradeHandler.save(connection, UPGRADE_GEODB, string, dbGeo.id);
                    block138: for (DbGeoCountry dbGeoCountry : dbGeo.countries) {
                        String string2 = dbGeoCountry.locale.getCountry();
                        for (Object object32 : geoImpl.getCountries()) {
                            if (!string2.equalsIgnoreCase(object32.getIsoCode())) continue;
                            AgencyUpgradeExtension.saveGeoDbCountryIds(connection, dbUpgradeHandler, (GeoCountryImpl)object32, dbGeoCountry);
                            continue block138;
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't import geo-db!");
                    LOGGER.warn("> from " + file17.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't import geo-db!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
        HashMap<Long, Long> hashMap4 = new HashMap<Long, Long>();
        File file18 = new File(file.getAbsolutePath() + File.separator + "estates");
        File file19 = new File(file.getAbsolutePath() + File.separator + "estate_calendars");
        if (file18.isDirectory()) {
            void var37_157;
            TreeMap<Long, File> treeMap = new TreeMap<Long, File>();
            File[] fileArray = file18.listFiles((FileFilter)suffixFileFilter);
            int n = fileArray.length;
            boolean bl = false;
            while (var37_157 < n) {
                File file20 = fileArray[var37_157];
                try {
                    treeMap.put(Long.valueOf(file20.getName().split("\\.")[0]), file20);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read estate-id!");
                    LOGGER.warn("> from " + file20.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read estate-id!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
                ++var37_157;
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                Long l = (Long)entry.getKey();
                this.setMessage("> Import estate #" + l, callback);
                File file21 = (File)entry.getValue();
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file21), "UTF-8");
                    Throwable throwable = null;
                    try {
                        Object object6;
                        String string;
                        object2 = AgencyUpgradeExtension.createEstate(inputStreamReader, hashMap, hashMap2);
                        ((DbAgencyObject)((Object)object2)).geoDbAreas = new HashMap();
                        block142: for (Map.Entry entry3 : hashMap3.entrySet()) {
                            relation3 = (String)entry3.getKey();
                            Long l2 = (Long)entry3.getValue();
                            String[] stringArray = AgencyUpgradeExtension.getGeoDbIds(((DbAgencyObject)((Object)object2)).item, (String)relation3);
                            if (stringArray == null) continue;
                            for (int i = stringArray.length; i > 0; --i) {
                                string = stringArray[i - 1];
                                long l3 = dbUpgradeHandler.getNewId(connection, UPGRADE_GEODB_AREA, relation3 + "." + string);
                                if (l3 <= 0L) continue;
                                object6 = dbGeoHandler.getGeoArea(connection, l3);
                                if (object6 == null) {
                                    LOGGER.warn("Can't find geodb-area #" + l3 + "!");
                                    this.setMessage("WARNING: Can't find geodb-area #" + l3 + "!", callback);
                                    continue block142;
                                }
                                ((DbAgencyObject)((Object)object2)).geoDbAreas.put(l2, object6);
                                continue block142;
                            }
                        }
                        ((DbAgencyObject)((Object)object2)).id = 0L;
                        dbAgencyObjectsHandler.saveObject(connection, (DbObject)object2, map, true, true);
                        hashMap4.put(l, ((DbAgencyObject)((Object)object2)).id);
                        dbUpgradeHandler.save(connection, UPGRADE_ESTATES, String.valueOf(l), ((DbAgencyObject)((Object)object2)).id);
                        object32 = new File(file.getAbsolutePath() + File.separator + "estate_files" + File.separator + l);
                        if (((File)object32).isDirectory()) {
                            boolean bl2 = false;
                            for (Relation relation2 : ((File)object32).listFiles()) {
                                File file22;
                                block191: {
                                    if (!relation2.isFile()) continue;
                                    this.setMessage("  " + relation2.getName() + " (" + ImmoToolUtils.getHumanReadableByteCount((long)relation2.length()) + ")", callback);
                                    string = null;
                                    for (Object object7 : ((DbAgencyObject)((Object)object2)).item.getAttachments()) {
                                        if (!object7.isName() || !object7.getFileAsName().equalsIgnoreCase(relation2.getName())) continue;
                                        string = object7;
                                        break;
                                    }
                                    if (string == null) {
                                        LOGGER.warn("Unknown attachment!");
                                        LOGGER.warn("> file " + relation2.getAbsolutePath());
                                        continue;
                                    }
                                    DbFile dbFile = AgencyUpgradeExtension.createEstateFile((EstateAttachmentImpl)string, (File)relation2);
                                    object7 = null;
                                    object6 = null;
                                    file22 = null;
                                    try {
                                        void var43_235;
                                        try {
                                            object7 = ImageUtils.readAsRgb((File)relation2);
                                        }
                                        catch (Exception exception) {
                                            this.setMessage("  IMAGE IS NOT READABLE (" + exception.getLocalizedMessage() + ")", callback);
                                            LOGGER.warn("Can't read file '" + relation2.getAbsolutePath() + "' as image!");
                                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                                            dbFile.mimeType = "application/octet-stream";
                                        }
                                        if (object7 != null) {
                                            dbFile.imageHeight = ((BufferedImage)object7).getHeight();
                                            dbFile.imageWidth = ((BufferedImage)object7).getWidth();
                                            object6 = ImageUtils.scaleToFit((BufferedImage)object7, (int)300, (int)300);
                                            file22 = File.createTempFile("estate.", ".preview");
                                            file22.deleteOnExit();
                                            ImageUtils.writeJpg((BufferedImage)object6, (File)file22);
                                        }
                                        dbFile.objectId = ((DbAgencyObject)((Object)object2)).id;
                                        dbFile.position = ++var43_235;
                                        dbFilesHandler.saveFile(connection, dbFile, (File)relation2, file22, map);
                                        if (object7 == null) break block191;
                                    }
                                    catch (Exception exception) {
                                        block192: {
                                            try {
                                                this.setMessage("  CAN'T PROCESS IMAGE (" + exception.getLocalizedMessage() + ")", callback);
                                                LOGGER.warn("Can't process image '" + relation2.getAbsolutePath() + "'!");
                                                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                                                if (object7 == null) break block192;
                                            }
                                            catch (Throwable throwable13) {
                                                if (object7 != null) {
                                                    ((Image)object7).flush();
                                                }
                                                if (object6 != null) {
                                                    ((Image)object6).flush();
                                                }
                                                FileUtils.deleteQuietly(file22);
                                                throw throwable13;
                                            }
                                            ((Image)object7).flush();
                                        }
                                        if (object6 != null) {
                                            ((Image)object6).flush();
                                        }
                                        FileUtils.deleteQuietly((File)file22);
                                        continue;
                                    }
                                    ((Image)object7).flush();
                                }
                                if (object6 != null) {
                                    ((Image)object6).flush();
                                }
                                FileUtils.deleteQuietly((File)file22);
                            }
                        }
                        for (Relation relation3 : AgencyUpgradeExtension.getAgencyCalendarRelations(l, (DbAgencyObject)((Object)object2))) {
                            if (!file19.isDirectory() && !file19.mkdir()) {
                                LOGGER.warn("Can't create directory: " + file19.getAbsolutePath());
                            }
                            File file23 = new File(file19 + File.separator + System.currentTimeMillis() + ".xml");
                            while (file23.isFile()) {
                                Thread.sleep(100L);
                                file23 = new File(file19 + File.separator + System.currentTimeMillis() + ".xml");
                            }
                            FileWriterWithEncoding fileWriterWithEncoding = new FileWriterWithEncoding(file23, "UTF-8");
                            Throwable throwable14 = null;
                            try {
                                relation3.write((Writer)fileWriterWithEncoding);
                                fileWriterWithEncoding.flush();
                            }
                            catch (Throwable throwable15) {
                                throwable14 = throwable15;
                                throw throwable15;
                            }
                            finally {
                                if (fileWriterWithEncoding == null) continue;
                                if (throwable14 != null) {
                                    try {
                                        fileWriterWithEncoding.close();
                                    }
                                    catch (Throwable throwable16) {
                                        throwable14.addSuppressed(throwable16);
                                    }
                                    continue;
                                }
                                fileWriterWithEncoding.close();
                            }
                        }
                    }
                    catch (Throwable throwable17) {
                        Throwable throwable18 = throwable17;
                        throw throwable17;
                    }
                    finally {
                        if (inputStreamReader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)inputStreamReader).close();
                            }
                            catch (Throwable throwable19) {
                                throwable.addSuppressed(throwable19);
                            }
                            continue;
                        }
                        ((Reader)inputStreamReader).close();
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Can't import estate!");
                    LOGGER.warn("> from " + file21.getAbsolutePath());
                    LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                    this.setMessage("WARNING: Can't import estate!", callback);
                    this.setMessage("> " + throwable.getLocalizedMessage(), callback);
                }
            }
        }
        if ((file2 = new File(file.getAbsolutePath() + File.separator + "export_history")).isDirectory()) {
            void var38_173;
            TreeMap<Long, File> treeMap = new TreeMap<Long, File>();
            File[] fileArray = file2.listFiles((FileFilter)suffixFileFilter);
            int n = fileArray.length;
            boolean bl = false;
            while (var38_173 < n) {
                File file24 = fileArray[var38_173];
                try {
                    treeMap.put(Long.valueOf(file24.getName().split("\\.")[0]), file24);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read export-log!");
                    LOGGER.warn("> from " + file24.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read export-log!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
                ++var38_173;
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                Long l = (Long)entry.getKey();
                this.setMessage("> Import export-log #" + l, callback);
                File file25 = (File)entry.getValue();
                try {
                    FileInputStream fileInputStream = new FileInputStream(file25);
                    object2 = null;
                    try {
                        object32 = new Properties();
                        ((Properties)object32).loadFromXML(fileInputStream);
                        DbAgencyExportLog dbAgencyExportLog = AgencyUpgradeExtension.createExportLog((Properties)object32, hashMap4);
                        relation3 = ImmoToolUtils.getPropertyAsLong((String)"interface.id", (Long)0L, (Properties)object32);
                        if (!hashMap2.containsKey(relation3)) continue;
                        dbAgencyExportLog.id = 0L;
                        dbAgencyExportLog.exportId = (Long)hashMap2.get(relation3);
                        dbAgencyExportsHandler.saveExportLog(connection, dbAgencyExportLog);
                        dbUpgradeHandler.save(connection, UPGRADE_EXPORTS_LOGS, String.valueOf(l), dbAgencyExportLog.id);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (object2 != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't import export-log!");
                    LOGGER.warn("> from " + file25.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't import export-log!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            Long l = (Long)entry.getKey();
            this.setMessage("> Import protocols for export-interface #" + l, callback);
            Long l4 = (Long)entry.getValue();
            boolean bl = false;
            DbAgencyExport dbAgencyExport = dbAgencyExportsHandler.getExport(connection, l4);
            try {
                object2 = new File(file.getAbsolutePath() + File.separator + "export_publishings" + File.separator + l + ".xml");
                if (((File)object2).isFile()) {
                    Map<Long, String> map2;
                    Serializable serializable;
                    relation3 = new FileInputStream((File)object2);
                    Map.Entry<Long, String> entry42 = null;
                    try {
                        serializable = new Properties();
                        serializable.loadFromXML((InputStream)relation3);
                        object32 = AgencyUpgradeExtension.createEstateNrMap(serializable);
                        map2 = AgencyUpgradeExtension.createEstateValueMap(serializable);
                    }
                    catch (Throwable throwable) {
                        entry42 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (relation3 != null) {
                            if (entry42 != null) {
                                try {
                                    relation3.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)((Object)entry42)).addSuppressed(throwable);
                                }
                            } else {
                                relation3.close();
                            }
                        }
                    }
                    dbAgencyExport.publishings = new HashMap<Long, DbAgencyExportPublishing>();
                    for (Map.Entry<Long, String> entry42 : map2.entrySet()) {
                        serializable = (Long)entry42.getKey();
                        if (!hashMap4.containsKey(serializable)) continue;
                        long l5 = (Long)hashMap4.get(serializable);
                        DbAgencyExportPublishing dbAgencyExportPublishing = new DbAgencyExportPublishing();
                        dbAgencyExportPublishing.exportId = l4;
                        dbAgencyExportPublishing.objectId = l5;
                        dbAgencyExportPublishing.objectNr = object32.containsKey(serializable) ? (String)object32.get(serializable) : null;
                        object7 = (String)entry42.getValue();
                        try {
                            dbAgencyExportPublishing.time = new Date(Long.parseLong((String)object7));
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                dbAgencyExportPublishing.time = simpleDateFormat2.parse((String)object7);
                            }
                            catch (ParseException parseException) {
                                try {
                                    dbAgencyExportPublishing.time = simpleDateFormat.parse((String)object7);
                                }
                                catch (ParseException parseException2) {
                                    LOGGER.warn("Can't parse time for exported estate!");
                                    LOGGER.warn("> value: " + (String)object7);
                                    LOGGER.warn("> " + parseException2.getLocalizedMessage(), (Throwable)parseException2);
                                    this.setMessage("WARNING: Can't parse time for exported estate!", callback);
                                    this.setMessage("> " + parseException2.getLocalizedMessage(), callback);
                                    continue;
                                }
                            }
                        }
                        dbAgencyExport.publishings.put(l5, dbAgencyExportPublishing);
                        bl = true;
                    }
                }
                if (!bl) continue;
                dbAgencyExportsHandler.saveExport(connection, dbAgencyExport, false, true);
            }
            catch (Throwable throwable) {
                LOGGER.warn("Can't import export-protocols!");
                LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                this.setMessage("WARNING: Can't import export-protocols!", callback);
                this.setMessage("> " + throwable.getLocalizedMessage(), callback);
            }
        }
        try {
            this.setMessage("> Save agency-settings...", callback);
            AgencyPlugin.setImageMaxHeight(ImmoToolUtils.getPropertyAsInteger((String)"Agency.Img.MaxHeight", (Integer)1000, (Properties)properties));
            AgencyPlugin.setImageMaxWidth(ImmoToolUtils.getPropertyAsInteger((String)"Agency.Img.MaxWidth", (Integer)1000, (Properties)properties));
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            String string = properties.getProperty("Agency.Locales");
            if (string != null && string.trim().length() > 0) {
                void var39_196;
                String[] stringArray = string.split(",");
                int n = stringArray.length;
                boolean bl = false;
                while (var39_196 < n) {
                    String string3 = stringArray[var39_196];
                    if (string3.trim().length() != 0) {
                        arrayList.add(OpenEstateUtils.buildLocale((String)string3.trim()));
                    }
                    ++var39_196;
                }
            }
            if (arrayList.isEmpty()) {
                String string4 = Locale.getDefault().getLanguage();
                for (Map.Entry entry : map.entrySet()) {
                    String string5 = ((String)entry.getValue()).trim();
                    if (!string5.equalsIgnoreCase(string4)) continue;
                    arrayList.add(OpenEstateUtils.buildLocale((String)string5));
                    break;
                }
                if (arrayList.isEmpty()) {
                    String string6 = Locale.ENGLISH.getLanguage();
                    for (Map.Entry entry : map.entrySet()) {
                        String string7 = ((String)entry.getValue()).trim();
                        if (!string7.equalsIgnoreCase(string6)) continue;
                        arrayList.add(OpenEstateUtils.buildLocale((String)string7));
                        break;
                    }
                }
            }
            if (!arrayList.isEmpty()) {
                AgencyPlugin.setLocales(arrayList.toArray(new Locale[0]));
            }
            AgencyPlugin.saveSettings(connection, dbUser, dbExtension, dbAgencyExtension);
        }
        catch (Throwable throwable) {
            LOGGER.warn("Can't save agency-settings!");
            LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
            this.setMessage("WARNING: Can't save agency-settings!", callback);
            this.setMessage("> " + throwable.getLocalizedMessage(), callback);
        }
    }
}

