/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db;

import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.db.DbLog;
import com.openindex.openestate.tool.db.DbUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbAgencyObjectLog
extends DbLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAgencyObjectLog.class);
    private static final I18n I18N = I18nFactory.getI18n(DbAgencyObjectLog.class);
    public static final String TYPE = "Agency.Object";
    private static final String CHANGE_ESTATE_ACTION = "action";
    private static final String CHANGE_ESTATE_PUBLIC_ID = "publicId";
    private static final String CHANGE_ESTATE_GROUP_NR = "groupNr";
    private static final String CHANGE_ESTATE_TYPE = "type";
    private static final String CHANGE_ESTATE_CURRENCY = "currency";
    private static final String CHANGE_ESTATE_PUBLISH_BEGIN = "publishBegin";
    private static final String CHANGE_ESTATE_PUBLISH_END = "publishEnd";
    private static final String CHANGE_ESTATE_NOTES = "notes";
    private static final String CHANGE_ESTATE_LANGUAGES = "languages";
    private static final String CHANGE_ESTATE_TITLE = "title";
    private static final String CHANGE_ESTATE_EXPORT_MODE = "exportMode";
    private static final String CHANGE_ESTATE_HIDDEN_PRICES = "isHiddenPrices";
    private static final String CHANGE_ESTATE_STATUS = "status";
    private static final String CHANGE_ESTATE_ATTRIBUTE = "attribute";
    @Deprecated
    private static final String CHANGE_ESTATE_VALUE = "value";
    private static final String CHANGE_CONTACT_ID = "contactId";
    private static final String CHANGE_ADDRESS_CITY = "address.city";
    private static final String CHANGE_ADDRESS_COUNTRY = "address.country";
    private static final String CHANGE_ADDRESS_DISTRICT = "address.district";
    private static final String CHANGE_ADDRESS_LATITUDE = "address.latitude";
    private static final String CHANGE_ADDRESS_LONGITUDE = "address.longitude";
    private static final String CHANGE_ADDRESS_PUBLISHED = "address.published";
    private static final String CHANGE_ADDRESS_POSTALCODE = "address.postalcode";
    private static final String CHANGE_ADDRESS_REGION = "address.region";
    private static final String CHANGE_ADDRESS_STREET = "address.street";
    private static final String CHANGE_ADDRESS_STREET2 = "address.street2";
    private static final String CHANGE_ADDRESS_STREETNR = "address.streetNr";
    public long objectId = 0L;

    public DbAgencyObjectLog() {
        this.entryType = TYPE;
    }

    public static DbAgencyObjectLog create(long l, String string, DbUser dbUser) {
        DbAgencyObjectLog dbAgencyObjectLog = new DbAgencyObjectLog();
        dbAgencyObjectLog.objectId = l;
        dbAgencyObjectLog.entryAction = string;
        dbAgencyObjectLog.createdBy = dbUser != null ? dbUser.writeName() : null;
        dbAgencyObjectLog.modifiedBy = dbUser != null ? dbUser.writeName() : null;
        return dbAgencyObjectLog;
    }

    public final String getPluginName() {
        return "OpenEstate-Tool-Agency";
    }

    public void initChanges(DbAgencyObject dbAgencyObject, DbAgencyObject dbAgencyObject2) {
        AbstractAttribImpl abstractAttribImpl;
        AbstractAttribImpl abstractAttribImpl2;
        OpenEstateAttrib openEstateAttrib;
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        this.changes = new HashMap();
        this.putChangedStatus(dbAgencyObject != null ? dbAgencyObject.status : null, dbAgencyObject2 != null ? dbAgencyObject2.status : null);
        this.putChangedAddress(dbAgencyObject != null && dbAgencyObject.item != null ? dbAgencyObject.item.getAddress() : null, dbAgencyObject2 != null && dbAgencyObject2.item != null ? dbAgencyObject2.item.getAddress() : null);
        this.putChangedHiddenPrices(dbAgencyObject != null && dbAgencyObject.item != null ? Boolean.valueOf(dbAgencyObject.item.isHiddenPrices()) : null, dbAgencyObject2 != null && dbAgencyObject2.item != null ? Boolean.valueOf(dbAgencyObject2.item.isHiddenPrices()) : null);
        this.putChangedExportMode(dbAgencyObject != null ? dbAgencyObject.exportMode : null, dbAgencyObject2 != null ? dbAgencyObject2.exportMode : null);
        this.putChangedContact(dbAgencyObject != null ? Long.valueOf(dbAgencyObject.contactId) : null, dbAgencyObject2 != null ? Long.valueOf(dbAgencyObject2.contactId) : null);
        String string = dbAgencyObject != null && dbAgencyObject.item != null ? dbAgencyObject.item.getPublicId() : null;
        String string2 = dbAgencyObject2 != null && dbAgencyObject2.item != null ? dbAgencyObject2.item.getPublicId() : null;
        this.addChange(CHANGE_ESTATE_PUBLIC_ID, string, string2);
        string = dbAgencyObject != null ? String.valueOf(dbAgencyObject.item.getGroupId()) : null;
        string2 = dbAgencyObject2 != null ? String.valueOf(dbAgencyObject2.item.getGroupId()) : null;
        this.addChange(CHANGE_ESTATE_GROUP_NR, string, string2);
        string = dbAgencyObject != null && dbAgencyObject.item != null && dbAgencyObject.item.getType() != null ? dbAgencyObject.item.getType().name() : null;
        string2 = dbAgencyObject2 != null && dbAgencyObject2.item != null && dbAgencyObject2.item.getType() != null ? dbAgencyObject2.item.getType().name() : null;
        this.addChange(CHANGE_ESTATE_TYPE, string, string2);
        string = dbAgencyObject != null && dbAgencyObject.item != null ? dbAgencyObject.item.getAction().name() : null;
        string2 = dbAgencyObject2 != null && dbAgencyObject2.item != null ? dbAgencyObject2.item.getAction().name() : null;
        this.addChange(CHANGE_ESTATE_ACTION, string, string2);
        string = dbAgencyObject != null && dbAgencyObject.item != null && dbAgencyObject.item.getCurrency() != null ? dbAgencyObject.item.getCurrency().getCurrencyCode() : null;
        string2 = dbAgencyObject2 != null && dbAgencyObject2.item != null && dbAgencyObject2.item.getCurrency() != null ? dbAgencyObject2.item.getCurrency().getCurrencyCode() : null;
        this.addChange(CHANGE_ESTATE_CURRENCY, string, string2);
        string = dbAgencyObject != null && dbAgencyObject.item != null && dbAgencyObject.item.getPublishBegin() != null ? dateFormat.format(dbAgencyObject.item.getPublishBegin()) : null;
        string2 = dbAgencyObject2 != null && dbAgencyObject2.item != null && dbAgencyObject2.item.getPublishBegin() != null ? dateFormat.format(dbAgencyObject2.item.getPublishBegin()) : null;
        this.addChange(CHANGE_ESTATE_PUBLISH_BEGIN, string, string2);
        string = dbAgencyObject != null && dbAgencyObject.item != null && dbAgencyObject.item.getPublishEnd() != null ? dateFormat.format(dbAgencyObject.item.getPublishEnd()) : null;
        string2 = dbAgencyObject2 != null && dbAgencyObject2.item != null && dbAgencyObject2.item.getPublishEnd() != null ? dateFormat.format(dbAgencyObject2.item.getPublishEnd()) : null;
        this.addChange(CHANGE_ESTATE_PUBLISH_END, string, string2);
        string = dbAgencyObject != null ? dbAgencyObject.notes : null;
        string2 = dbAgencyObject2 != null ? dbAgencyObject2.notes : null;
        this.addChange(CHANGE_ESTATE_NOTES, string, string2);
        string = dbAgencyObject != null && dbAgencyObject.item != null ? StringUtils.join((Iterable)dbAgencyObject.item.getLanguages(), (String)",") : null;
        string2 = dbAgencyObject2 != null && dbAgencyObject2.item != null ? StringUtils.join((Iterable)dbAgencyObject2.item.getLanguages(), (String)",") : null;
        this.addChange(CHANGE_ESTATE_LANGUAGES, string, string2);
        if (dbAgencyObject != null && dbAgencyObject.item != null) {
            for (Iterator iterator : dbAgencyObject.item.getLanguages()) {
                string = dbAgencyObject.item.getTitle((String)((Object)iterator));
                String string3 = string2 = dbAgencyObject2 != null && dbAgencyObject2.item != null ? dbAgencyObject2.item.getTitle(iterator) : null;
                String object2 = "title." + iterator;
                if (this.changes.containsKey(object2)) continue;
                this.addChange(object2, string, string2);
            }
        }
        if (dbAgencyObject2 != null && dbAgencyObject2.item != null) {
            for (Iterator iterator : dbAgencyObject2.item.getLanguages()) {
                string2 = dbAgencyObject2.item.getTitle(iterator);
                String string4 = string = dbAgencyObject != null && dbAgencyObject.item != null ? dbAgencyObject.item.getTitle(iterator) : null;
                String string5 = "title." + iterator;
                if (this.changes.containsKey(string5)) continue;
                this.addChange(string5, string, string2);
            }
        }
        Iterator<OpenEstateAttrib> iterator = new ArrayList();
        if (dbAgencyObject != null && dbAgencyObject.item != null) {
            for (Map.Entry entry : dbAgencyObject.item.getAttributes().entrySet()) {
                openEstateAttrib = (OpenEstateAttrib)entry.getKey();
                abstractAttribImpl2 = (AbstractAttribImpl)entry.getValue();
                if (iterator.contains(openEstateAttrib)) continue;
                abstractAttribImpl = dbAgencyObject2 != null && dbAgencyObject2.item != null ? dbAgencyObject2.item.getAttribute(openEstateAttrib) : null;
                this.putChangedValue(abstractAttribImpl2, abstractAttribImpl);
                iterator.add(openEstateAttrib);
            }
        }
        if (dbAgencyObject2 != null && dbAgencyObject2.item != null) {
            for (Map.Entry entry : dbAgencyObject2.item.getAttributes().entrySet()) {
                openEstateAttrib = (OpenEstateAttrib)entry.getKey();
                abstractAttribImpl2 = (AbstractAttribImpl)entry.getValue();
                if (iterator.contains(openEstateAttrib)) continue;
                abstractAttribImpl = dbAgencyObject != null && dbAgencyObject.item != null ? dbAgencyObject.item.getAttribute(openEstateAttrib) : null;
                this.putChangedValue(abstractAttribImpl, abstractAttribImpl2);
                iterator.add(openEstateAttrib);
            }
        }
    }

    public void putChangedAddress(EstateAddressImpl estateAddressImpl, EstateAddressImpl estateAddressImpl2) {
        HashMap hashMap = new HashMap();
        if (estateAddressImpl != null) {
            estateAddressImpl.serializeToMap(hashMap, "");
        }
        HashMap hashMap2 = new HashMap();
        if (estateAddressImpl2 != null) {
            estateAddressImpl2.serializeToMap(hashMap2, "");
        }
        List list = ImmoToolUtils.compareMaps(hashMap, hashMap2);
        for (String string : list) {
            String string2 = hashMap.containsKey(string) ? (String)hashMap.get(string) : null;
            String string3 = hashMap2.containsKey(string) ? (String)hashMap2.get(string) : null;
            this.addChange(string, string2, string3);
        }
    }

    public void putChangedContact(Long l, Long l2) {
        String string = l != null && l > 0L ? l.toString() : null;
        String string2 = l2 != null && l2 > 0L ? l2.toString() : null;
        this.addChange(CHANGE_CONTACT_ID, string, string2);
    }

    public void putChangedExportMode(DbAgencyObject.ExportMode exportMode, DbAgencyObject.ExportMode exportMode2) {
        String string = exportMode != null ? exportMode.name() : null;
        String string2 = exportMode2 != null ? exportMode2.name() : null;
        this.addChange(CHANGE_ESTATE_EXPORT_MODE, string, string2);
    }

    public void putChangedHiddenPrices(Boolean bl, Boolean bl2) {
        String string;
        String string2 = bl != null ? (Boolean.TRUE.equals(bl) ? "1" : "0") : (string = null);
        String string3 = bl2 != null ? (Boolean.TRUE.equals(bl2) ? "1" : "0") : null;
        this.addChange(CHANGE_ESTATE_HIDDEN_PRICES, string, string3);
    }

    public void putChangedStatus(DbAgencyObject.Status status, DbAgencyObject.Status status2) {
        String string = status != null ? status.name() : null;
        String string2 = status2 != null ? status2.name() : null;
        this.addChange(CHANGE_ESTATE_STATUS, string, string2);
    }

    public void putChangedValue(AbstractAttribImpl abstractAttribImpl, AbstractAttribImpl abstractAttribImpl2) {
        OpenEstateAttrib openEstateAttrib;
        if (abstractAttribImpl != null) {
            openEstateAttrib = abstractAttribImpl.getAttrib();
        } else if (abstractAttribImpl2 != null) {
            openEstateAttrib = abstractAttribImpl2.getAttrib();
        } else {
            return;
        }
        if (openEstateAttrib == null) {
            LOGGER.warn("Can't find attribute!");
            return;
        }
        String string = "attribute." + openEstateAttrib.name();
        if (abstractAttribImpl instanceof SimpleBooleanAttrib || abstractAttribImpl2 instanceof SimpleBooleanAttrib) {
            Boolean bl;
            SimpleBooleanAttrib simpleBooleanAttrib = (SimpleBooleanAttrib)abstractAttribImpl;
            SimpleBooleanAttrib simpleBooleanAttrib2 = (SimpleBooleanAttrib)abstractAttribImpl2;
            Boolean bl2 = simpleBooleanAttrib != null ? simpleBooleanAttrib.getValue() : null;
            Boolean bl3 = bl = simpleBooleanAttrib2 != null ? simpleBooleanAttrib2.getValue() : null;
            this.addChange(string, bl2 != null ? (Boolean.TRUE.equals(bl2) ? "1" : "0") : null, bl != null ? (Boolean.TRUE.equals(bl) ? "1" : "0") : null);
        } else if (abstractAttribImpl instanceof SimpleEnumAttrib || abstractAttribImpl2 instanceof SimpleEnumAttrib) {
            SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)abstractAttribImpl;
            SimpleEnumAttrib simpleEnumAttrib2 = (SimpleEnumAttrib)abstractAttribImpl2;
            Enum enum_ = simpleEnumAttrib != null ? simpleEnumAttrib.getValue() : null;
            Enum enum_2 = simpleEnumAttrib2 != null ? simpleEnumAttrib2.getValue() : null;
            this.addChange(string, enum_ != null ? enum_.name() : null, enum_2 != null ? enum_2.name() : null);
        } else if (abstractAttribImpl instanceof SimpleNumericAttrib || abstractAttribImpl2 instanceof SimpleNumericAttrib) {
            SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)abstractAttribImpl;
            SimpleNumericAttrib simpleNumericAttrib2 = (SimpleNumericAttrib)abstractAttribImpl2;
            Number number = simpleNumericAttrib != null ? (Number)simpleNumericAttrib.getValue() : (Number)null;
            Number number2 = simpleNumericAttrib2 != null ? (Number)simpleNumericAttrib2.getValue() : (Number)null;
            this.addChange(string, number != null ? number.toString() : null, number2 != null ? number2.toString() : null);
        } else if (abstractAttribImpl instanceof ComplexEnumAttrib || abstractAttribImpl2 instanceof ComplexEnumAttrib) {
            ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)abstractAttribImpl;
            ComplexEnumAttrib complexEnumAttrib2 = (ComplexEnumAttrib)abstractAttribImpl2;
            Object[] objectArray = complexEnumAttrib != null ? complexEnumAttrib.getValue() : null;
            Object[] objectArray2 = complexEnumAttrib2 != null ? complexEnumAttrib2.getValue() : null;
            this.addChange(string, StringUtils.join((Object[])objectArray, (String)", "), StringUtils.join((Object[])objectArray2, (String)", "));
        } else if (abstractAttribImpl instanceof ComplexStringAttrib || abstractAttribImpl2 instanceof ComplexStringAttrib) {
            String string2;
            String string3;
            ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)abstractAttribImpl;
            ComplexStringAttrib complexStringAttrib2 = (ComplexStringAttrib)abstractAttribImpl2;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (complexStringAttrib != null) {
                for (String string4 : complexStringAttrib.getValueLanguages()) {
                    if (arrayList.contains(string4)) continue;
                    string3 = StringUtils.trimToNull((String)complexStringAttrib.getValue(string4));
                    string2 = StringUtils.trimToNull(complexStringAttrib2 != null ? complexStringAttrib2.getValue(string4) : null);
                    this.addChange(string + "." + string4, string3, string2);
                    arrayList.add(string4);
                }
            }
            if (complexStringAttrib2 != null) {
                for (String string4 : complexStringAttrib2.getValueLanguages()) {
                    if (arrayList.contains(string4)) continue;
                    string3 = StringUtils.trimToNull(complexStringAttrib != null ? complexStringAttrib.getValue(string4) : null);
                    string2 = StringUtils.trimToNull((String)complexStringAttrib2.getValue(string4));
                    this.addChange(string + "." + string4, string3, string2);
                    arrayList.add(string4);
                }
            }
        } else {
            this.addChange(string, abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue() : null, abstractAttribImpl2 != null ? abstractAttribImpl2.getFormattedValue() : null);
        }
    }

    public String writeAction() {
        return DbAgencyObjectLog.writeAction(this.entryAction);
    }

    public static String writeAction(String string) {
        if ("ADD".equalsIgnoreCase(string)) {
            return I18N.tr("Property was added.");
        }
        if ("EDIT".equalsIgnoreCase(string)) {
            return I18N.tr("Property was modified.");
        }
        return null;
    }

    public String writeChangeKey(String string) {
        if (CHANGE_ESTATE_ACTION.equalsIgnoreCase(string)) {
            return I18N.tr("marketing type");
        }
        if (CHANGE_ESTATE_PUBLIC_ID.equalsIgnoreCase(string)) {
            return I18N.tr("property-nr");
        }
        if (CHANGE_ESTATE_GROUP_NR.equalsIgnoreCase(string)) {
            return I18N.tr("group-nr");
        }
        if (CHANGE_ESTATE_TYPE.equalsIgnoreCase(string)) {
            return I18N.tr("property type");
        }
        if (CHANGE_ESTATE_CURRENCY.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ESTATE_CURRENCY);
        }
        if (CHANGE_ESTATE_PUBLISH_BEGIN.equalsIgnoreCase(string)) {
            return I18N.tr("valid from");
        }
        if (CHANGE_ESTATE_PUBLISH_END.equalsIgnoreCase(string)) {
            return I18N.tr("valid until");
        }
        if (CHANGE_ESTATE_NOTES.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ESTATE_NOTES);
        }
        if (CHANGE_ESTATE_LANGUAGES.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ESTATE_LANGUAGES);
        }
        if (CHANGE_ESTATE_EXPORT_MODE.equalsIgnoreCase(string)) {
            return I18N.tr("export mode");
        }
        if (CHANGE_ESTATE_HIDDEN_PRICES.equalsIgnoreCase(string)) {
            return I18N.tr("hidden prices");
        }
        if (CHANGE_ESTATE_STATUS.equalsIgnoreCase(string)) {
            return I18N.tr(CHANGE_ESTATE_STATUS);
        }
        if (CHANGE_CONTACT_ID.equalsIgnoreCase(string)) {
            return I18N.tr("contact person");
        }
        if (CHANGE_ADDRESS_CITY.equalsIgnoreCase(string)) {
            return I18N.tr("place");
        }
        if (CHANGE_ADDRESS_COUNTRY.equalsIgnoreCase(string)) {
            return I18N.tr("country");
        }
        if (CHANGE_ADDRESS_DISTRICT.equalsIgnoreCase(string)) {
            return StringUtils.capitalize((String)I18N.tr("district"));
        }
        if (CHANGE_ADDRESS_LATITUDE.equalsIgnoreCase(string)) {
            return I18N.tr("latitude");
        }
        if (CHANGE_ADDRESS_LONGITUDE.equalsIgnoreCase(string)) {
            return I18N.tr("longitude");
        }
        if (CHANGE_ADDRESS_PUBLISHED.equalsIgnoreCase(string)) {
            return I18N.tr("address published");
        }
        if (CHANGE_ADDRESS_POSTALCODE.equalsIgnoreCase(string)) {
            return StringUtils.capitalize((String)I18N.tr("postcode"));
        }
        if (CHANGE_ADDRESS_REGION.equalsIgnoreCase(string)) {
            return I18N.tr("region");
        }
        if (CHANGE_ADDRESS_STREET.equalsIgnoreCase(string)) {
            return I18N.tr("street");
        }
        if (CHANGE_ADDRESS_STREET2.equalsIgnoreCase(string)) {
            return I18N.tr("street (addition)");
        }
        if (CHANGE_ADDRESS_STREETNR.equalsIgnoreCase(string)) {
            return I18N.tr("street-nr");
        }
        if (string != null && string.startsWith("title.")) {
            String string2 = string.substring("title.".length());
            return I18N.tr(CHANGE_ESTATE_TITLE) + "(" + string2 + ")";
        }
        if (string != null && (string.startsWith("value.") || string.startsWith("attribute."))) {
            OpenEstateAttrib openEstateAttrib = null;
            if (string.startsWith("value.")) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length > 2) {
                    openEstateAttrib = OpenEstateUtils.lookupAttrib((String)stringArray[1], (String)stringArray[2]);
                }
                if (openEstateAttrib == null) {
                    LOGGER.warn("Can't find attribute: \"" + stringArray[1] + " / " + stringArray[2] + "\"!");
                }
            } else if (string.startsWith("attribute.")) {
                String[] stringArray = string.split("\\.");
                try {
                    openEstateAttrib = OpenEstateAttrib.valueOf((String)stringArray[1]);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't find attribute: \"" + stringArray[1] + "\"!");
                }
            }
            if (openEstateAttrib != null) {
                return I18N.tr(CHANGE_ESTATE_ATTRIBUTE) + ", " + openEstateAttrib.getGroup().getTranslation() + ", " + openEstateAttrib.getTranslation();
            }
        }
        return super.writeChangeKey(string);
    }

    public String writeChangeValue(String string, String string2) {
        if (CHANGE_ESTATE_HIDDEN_PRICES.equals(string)) {
            if ("1".equals(string2)) {
                return OpenEstateConstant.YES.getTranslation();
            }
            if ("0".equals(string2)) {
                return OpenEstateConstant.NO.getTranslation();
            }
        } else if (CHANGE_ESTATE_ACTION.equals(string)) {
            OpenEstateAction openEstateAction = OpenEstateUtils.lookupAction((String)string2);
            if (openEstateAction != null) {
                return openEstateAction.getTranslation();
            }
        } else if (CHANGE_ESTATE_TYPE.equals(string)) {
            OpenEstateType openEstateType = OpenEstateUtils.lookupEstate((String)string2);
            if (openEstateType != null) {
                return openEstateType.getTranslation();
            }
        } else if (CHANGE_ESTATE_EXPORT_MODE.equals(string)) {
            if (!StringUtils.isBlank((CharSequence)string2)) {
                try {
                    DbAgencyObject.ExportMode exportMode = DbAgencyObject.ExportMode.valueOf(string2);
                    return exportMode.getTranslation();
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read export mode!");
                    LOGGER.warn("> " + exception.getLocalizedMessage());
                }
            }
        } else if (CHANGE_ESTATE_STATUS.equals(string)) {
            if (!StringUtils.isBlank((CharSequence)string2)) {
                try {
                    DbAgencyObject.Status status = DbAgencyObject.Status.valueOf(string2);
                    return status.getTranslation();
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read status!");
                    LOGGER.warn("> " + exception.getLocalizedMessage());
                }
            }
        } else if (string != null && (string.startsWith("value.") || string.startsWith("attribute."))) {
            AbstractAttribImpl abstractAttribImpl;
            OpenEstateAttrib openEstateAttrib = null;
            if (string.startsWith("value.")) {
                abstractAttribImpl = string.split("\\.");
                if (((String[])abstractAttribImpl).length > 2) {
                    openEstateAttrib = OpenEstateUtils.lookupAttrib((String)abstractAttribImpl[1], (String)abstractAttribImpl[2]);
                }
                if (openEstateAttrib == null) {
                    LOGGER.warn("Can't find attribute: \"" + (String)abstractAttribImpl[1] + " / " + (String)abstractAttribImpl[2] + "\"!");
                }
            } else if (string.startsWith("attribute.")) {
                abstractAttribImpl = string.split("\\.");
                try {
                    openEstateAttrib = OpenEstateAttrib.valueOf((String)abstractAttribImpl[1]);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't find attribute: \"" + (String)abstractAttribImpl[1] + "\"!");
                }
            }
            if (openEstateAttrib != null) {
                abstractAttribImpl = openEstateAttrib.createImpl();
                if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
                    if ("1".equals(string2)) {
                        return OpenEstateConstant.YES.getTranslation();
                    }
                    if ("0".equals(string2)) {
                        return OpenEstateConstant.NO.getTranslation();
                    }
                } else if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                    SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)abstractAttribImpl;
                    Enum enum_ = simpleEnumAttrib.getOption(string2);
                    if (enum_ != null) {
                        return simpleEnumAttrib.getOptionTranslation(enum_);
                    }
                } else if (abstractAttribImpl instanceof ComplexEnumAttrib) {
                    ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)abstractAttribImpl;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (string2 != null) {
                        for (String string3 : string2.split(",")) {
                            if ((string3 = StringUtils.trimToNull((String)string3)) == null) continue;
                            Enum enum_ = complexEnumAttrib.getOption(string3);
                            String string4 = StringUtils.trimToNull((String)complexEnumAttrib.getOptionTranslation(enum_));
                            arrayList.add(string4 != null ? string4 : string3);
                        }
                    }
                    return StringUtils.join(arrayList, (String)", ");
                }
            }
        }
        return super.writeChangeValue(string, string2);
    }
}

