/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db.hsql;

import com.openindex.openestate.impl.db.DbContact;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.impl.db.hsql.HSqlDbContactsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.utils.Permission;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyContactsHandler
extends HSqlDbContactsHandler
implements DbAgencyContactsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyContactsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyContactsHandler.class);
    public static final String PROC_SAVE_CONTACTS_ADDON = "save_immotool_agency_contacts";
    public static final String TABLE_AGENCY_CONTACTS = "immotool_agency_contacts";
    public static final String FIELD_CONTACT_ENABLED = "contact_enabled";
    public static final String FIELD_CONTACT_NOTES = "contact_notes";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    protected DbContact buildContact(ResultSet resultSet) throws SQLException {
        DbAgencyContact dbAgencyContact = (DbAgencyContact)super.buildContact(resultSet);
        dbAgencyContact.enabled = resultSet.getBoolean(FIELD_CONTACT_ENABLED);
        dbAgencyContact.notes = resultSet.getString(FIELD_CONTACT_NOTES);
        dbAgencyContact.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbAgencyContact.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbAgencyContact.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        return dbAgencyContact;
    }

    protected DbContact createContact() {
        return new DbAgencyContact();
    }

    protected void saveContactAdditionally(Connection connection, DbContact dbContact, long l, List<Statement> list) throws SQLException {
        if (!(dbContact instanceof DbAgencyContact)) {
            LOGGER.warn("DbContact is not an instance of DbAgencyContact!");
            LOGGER.warn("> " + dbContact.getClass().getName());
            return;
        }
        DbAgencyContact dbAgencyContact = (DbAgencyContact)dbContact;
        NamedCallableStatement namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_contacts(:contact_id, :contact_enabled, :contact_notes, :access_owner_id, :access_group_id, :access_permissions);");
        namedCallableStatement.setLong("contact_id", l);
        namedCallableStatement.setBoolean(FIELD_CONTACT_ENABLED, dbAgencyContact.enabled);
        namedCallableStatement.setString(FIELD_CONTACT_NOTES, dbAgencyContact.notes);
        namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbAgencyContact.ownerUserId);
        namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbAgencyContact.ownerGroupId);
        namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbAgencyContact.permission != null ? dbAgencyContact.permission.getValue() : -1);
        namedCallableStatement.execute();
        list.add(namedCallableStatement.getStatement());
    }
}

