/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db.hsql;

import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.impl.db.hsql.HSqlDbObjectsHandler;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.utils.Permission;
import com.openindex.openestate.tool.utils.StatusNotification;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyObjectsHandler
extends HSqlDbObjectsHandler
implements DbAgencyObjectsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyObjectsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyObjectsHandler.class);
    public static final String PROC_REMOVE_OBJECTS_EXPORTS = "remove_immotool_agency_objects_exports";
    public static final String PROC_SAVE_OBJECTS_ADDON = "save_immotool_agency_objects";
    public static final String PROC_SAVE_OBJECTS_EXPORTS = "save_immotool_agency_objects_exports";
    public static final String PROC_SET_OBJECTS_STATUS = "set_immotool_agency_objects_status";
    public static final String VIEW_OBJECTS_EXPORTS = "view_immotool_agency_objects_exports";
    public static final String TABLE_OBJECTS = "immotool_agency_objects";
    public static final String FIELD_OBJECT_STATUS = "object_status";
    public static final String FIELD_OBJECT_EXPORT_MODE = "object_export_mode";
    public static final String FIELD_OBJECT_IMPORT_ID = "object_import_id";
    public static final String FIELD_OBJECT_IMPORT_HASH = "object_import_hash";
    public static final String FIELD_OBJECT_NOTES = "object_notes";
    public static final String TABLE_OBJECTS_EXPORTS = "immotool_agency_objects_exports";
    private static final String FIELD_EXPORT_ID = "export_id";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    protected DbObject buildObject(ResultSet resultSet) throws SQLException {
        DbAgencyObject dbAgencyObject = (DbAgencyObject)super.buildObject(resultSet);
        dbAgencyObject.importId = resultSet.getString(FIELD_OBJECT_IMPORT_ID);
        dbAgencyObject.importHash = resultSet.getString(FIELD_OBJECT_IMPORT_HASH);
        dbAgencyObject.notes = resultSet.getString(FIELD_OBJECT_NOTES);
        dbAgencyObject.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbAgencyObject.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbAgencyObject.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        try {
            dbAgencyObject.exportMode = DbAgencyObject.ExportMode.valueOf(resultSet.getString(FIELD_OBJECT_EXPORT_MODE));
        }
        catch (Exception exception) {
            dbAgencyObject.exportMode = null;
            LOGGER.warn("Can't load export-mode for object #" + dbAgencyObject.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            dbAgencyObject.status = DbAgencyObject.Status.valueOf(resultSet.getString(FIELD_OBJECT_STATUS));
        }
        catch (Exception exception) {
            dbAgencyObject.status = null;
            LOGGER.warn("Can't load status for object #" + dbAgencyObject.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbAgencyObject;
    }

    protected DbObject createObject() {
        return new DbAgencyObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public DbAgencyObject getObjectByImportHash(Connection connection, String string) throws SQLException {
        DbAgencyObject dbAgencyObject;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block6: {
            if (string == null) {
                return null;
            }
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement("SELECT * FROM view_openestate_objects WHERE object_import_hash = ? LIMIT 1;");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block6;
            DbAgencyObject dbAgencyObject2 = null;
            {
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(resultSet);
                    JdbcUtils.closeQuietly((Statement)preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtils.closeQuietly((ResultSet)resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            return dbAgencyObject2;
        }
        try {
            dbAgencyObject = (DbAgencyObject)this.buildObject(resultSet);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create estate object!");
            LOGGER.error("> with import-hash: " + string);
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            DbAgencyObject dbAgencyObject3 = null;
            JdbcUtils.closeQuietly((ResultSet)resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            return dbAgencyObject3;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public DbAgencyObject getObjectByImportId(Connection connection, String string) throws SQLException {
        DbAgencyObject dbAgencyObject;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block6: {
            if (string == null) {
                return null;
            }
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement("SELECT * FROM view_openestate_objects WHERE object_import_id = ? LIMIT 1;");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block6;
            DbAgencyObject dbAgencyObject2 = null;
            {
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(resultSet);
                    JdbcUtils.closeQuietly((Statement)preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtils.closeQuietly((ResultSet)resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            return dbAgencyObject2;
        }
        try {
            dbAgencyObject = (DbAgencyObject)this.buildObject(resultSet);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create estate object!");
            LOGGER.error("> with import-id: " + string);
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            DbAgencyObject dbAgencyObject3 = null;
            JdbcUtils.closeQuietly((ResultSet)resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            return dbAgencyObject3;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getObjectIdsForExport(Connection connection, long l, DbAgencySearch dbAgencySearch) throws SQLException {
        long[] lArray;
        if (l < 1L) {
            return new long[0];
        }
        long[] lArray2 = this.getObjectIds(connection, dbAgencySearch);
        if (ArrayUtils.isEmpty((long[])lArray2)) {
            return lArray2;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT object_id FROM view_immotool_agency_objects_exports WHERE export_id = ?";
            preparedStatement = connection.prepareStatement("SELECT object_id FROM view_openestate_objects WHERE object_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray2.length) + ") AND ( (" + FIELD_OBJECT_EXPORT_MODE + " = ?) OR (" + FIELD_OBJECT_EXPORT_MODE + " = ? AND " + "object_id" + " IN (" + string + ")) OR (" + FIELD_OBJECT_EXPORT_MODE + " = ? AND " + "object_id" + " NOT IN (" + string + ")) ) ORDER BY " + "object_id" + " ASC;");
            int n = 0;
            for (long l2 : lArray2) {
                preparedStatement.setLong(++n, l2);
            }
            preparedStatement.setString(++n, DbAgencyObject.ExportMode.ALL.name());
            preparedStatement.setString(++n, DbAgencyObject.ExportMode.SELECTED_EXPORTS.name());
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.name());
            preparedStatement.setLong(++n, l);
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(resultSet.getLong("object_id"));
            }
            lArray = ArrayUtils.toPrimitive((Long[])object.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbObject[] getObjects(Connection connection, DbAgencyObject.Status status, DbAgencyObject.ExportMode exportMode) throws SQLException {
        DbObject[] dbObjectArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (status != null) {
                arrayList.add("object_status = ?");
            }
            if (exportMode != null) {
                arrayList.add("object_export_mode = ?");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_openestate_objects " + string + " ORDER BY " + "object_id" + " ASC;");
            int n = 0;
            if (status != null) {
                preparedStatement.setString(++n, status.name());
            }
            if (exportMode != null) {
                preparedStatement.setString(++n, exportMode.name());
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbObject> arrayList2 = new ArrayList<DbObject>();
            while (resultSet.next()) {
                try {
                    arrayList2.add(this.buildObject(resultSet));
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't create object #" + resultSet.getLong("object_id") + "!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            dbObjectArray = arrayList2.toArray(new DbObject[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DbObject[] getObjectsForExport(Connection connection, long l) throws SQLException {
        DbObject[] dbObjectArray;
        if (l < 1L) {
            return new DbObject[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT object_id FROM view_immotool_agency_objects_exports WHERE export_id = ?";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_openestate_objects WHERE object_status = ? AND ( (object_export_mode = ?) OR (object_export_mode = ? AND object_id IN (" + string + ")) OR (" + FIELD_OBJECT_EXPORT_MODE + " = ? AND " + "object_id" + " NOT IN (" + string + ")) ) ORDER BY " + "object_id" + " ASC;");
            int n = 0;
            preparedStatement.setString(++n, DbAgencyObject.Status.PUBLISHED.name());
            preparedStatement.setString(++n, DbAgencyObject.ExportMode.ALL.name());
            preparedStatement.setString(++n, DbAgencyObject.ExportMode.SELECTED_EXPORTS.name());
            preparedStatement.setLong(++n, l);
            preparedStatement.setString(++n, DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.name());
            preparedStatement.setLong(++n, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
            while (resultSet.next()) {
                try {
                    arrayList.add(this.buildObject(resultSet));
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't create object #" + resultSet.getLong("object_id") + "!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            dbObjectArray = arrayList.toArray(new DbObject[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbObjectArray;
    }

    @Override
    public void loadObjectExportIds(Connection connection, DbAgencyObject dbAgencyObject) throws SQLException {
        this.loadObjectExportIds(connection, new DbAgencyObject[]{dbAgencyObject});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadObjectExportIds(Connection connection, DbAgencyObject[] dbAgencyObjectArray) throws SQLException {
        HashMap<Long, DbAgencyObject> hashMap = new HashMap<Long, DbAgencyObject>();
        for (DbAgencyObject dbAgencyObject : dbAgencyObjectArray) {
            if (dbAgencyObject.id <= 0L || hashMap.containsKey(dbAgencyObject.id)) continue;
            hashMap.put(dbAgencyObject.id, dbAgencyObject);
            if (dbAgencyObject.exportIds == null) {
                dbAgencyObject.exportIds = new ArrayList<Long>();
                continue;
            }
            dbAgencyObject.exportIds.clear();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_objects_exports WHERE object_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + "object_id" + " ASC, " + FIELD_EXPORT_ID + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Long l;
                Long l2 = resultSet.getLong("object_id");
                if (!hashMap.containsKey(l2)) continue;
                l = resultSet.getLong(FIELD_EXPORT_ID);
                ((DbAgencyObject)((Object)hashMap.get((Object)l2))).exportIds.add(l);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    protected void loadSearchConditions(DbSearch dbSearch, List<String> list, Map<String, Object> map) {
        super.loadSearchConditions(dbSearch, list, map);
        if (dbSearch instanceof DbAgencySearch) {
            DbAgencySearch dbAgencySearch = (DbAgencySearch)dbSearch;
            if (dbAgencySearch.status != null && !dbAgencySearch.status.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (DbAgencyObject.Status status : dbAgencySearch.status) {
                    String string = "value" + map.size();
                    map.put(string, status.name());
                    arrayList.add(":" + string);
                }
                String string = "SELECT object_id FROM view_openestate_objects WHERE object_status IN (" + StringUtils.join(arrayList, (String)", ") + ") ";
                list.add("object_id IN (" + (String)string + ")");
            }
        }
    }

    public void saveObject(Connection connection, DbObject dbObject, Map<Long, String> map, boolean bl, boolean bl2) throws SQLException {
        long l;
        String string = StringUtils.trimToNull((String)dbObject.item.getPublicId());
        if (string != null && (l = this.getObjectId(connection, string)) > 0L && dbObject.id != l) {
            LOGGER.warn("The public id '" + string + "' is already used by object #" + l + "!");
            ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning("<html><b>" + StringEscapeUtils.escapeXml11((String)I18N.tr("The property nr {0} is already in use!", (Object)('\"' + string + '\"'))) + "</b><br>" + StringEscapeUtils.escapeXml11((String)I18N.tr("Therefore the property was saved without a number.")) + "</html>"));
            dbObject.item.setPublicId(null);
        }
        super.saveObject(connection, dbObject, map, bl, bl2);
    }

    protected void saveObjectAdditionally(Connection connection, DbObject dbObject, long l, List<Statement> list) throws SQLException {
        if (!(dbObject instanceof DbAgencyObject)) {
            LOGGER.warn("The object is not an instance of DbAgencyObject!");
            LOGGER.warn("> " + dbObject.getClass().getName());
            return;
        }
        DbAgencyObject dbAgencyObject = (DbAgencyObject)dbObject;
        NamedCallableStatement namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_objects(:object_id, :object_status, :object_export_mode, :object_import_id, :object_import_hash, :object_notes, :access_owner_id, :access_group_id, :access_permissions);");
        namedCallableStatement.setLong("object_id", l);
        namedCallableStatement.setString(FIELD_OBJECT_NOTES, dbAgencyObject.notes);
        namedCallableStatement.setString(FIELD_OBJECT_STATUS, dbAgencyObject.status != null ? StringUtils.abbreviate((String)dbAgencyObject.status.name(), (int)25) : DbAgencyObject.Status.DRAFT.name());
        namedCallableStatement.setString(FIELD_OBJECT_EXPORT_MODE, dbAgencyObject.exportMode != null ? StringUtils.abbreviate((String)dbAgencyObject.exportMode.name(), (int)25) : DbAgencyObject.ExportMode.ALL.name());
        namedCallableStatement.setString(FIELD_OBJECT_IMPORT_ID, StringUtils.abbreviate((String)dbAgencyObject.importId, (int)255));
        namedCallableStatement.setString(FIELD_OBJECT_IMPORT_HASH, StringUtils.abbreviate((String)dbAgencyObject.importHash, (int)255));
        namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbAgencyObject.ownerUserId);
        namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbAgencyObject.ownerGroupId);
        namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbAgencyObject.permission != null ? dbAgencyObject.permission.getValue() : -1);
        namedCallableStatement.execute();
        list.add(namedCallableStatement.getStatement());
        if (dbAgencyObject.exportIds != null) {
            DbAgencyObject dbAgencyObject2;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (dbObject.id > 0L) {
                dbAgencyObject2 = new DbAgencyObject();
                dbAgencyObject2.id = dbObject.id;
                this.loadObjectExportIds(connection, dbAgencyObject2);
                if (dbAgencyObject2.exportIds != null && !dbAgencyObject2.exportIds.isEmpty()) {
                    arrayList.addAll(dbAgencyObject2.exportIds);
                }
                NamedCallableStatement namedCallableStatement2 = new NamedCallableStatement(connection, "CALL remove_immotool_agency_objects_exports(:object_id, :export_id);");
                for (Long l2 : arrayList) {
                    if (dbAgencyObject.exportIds.contains(l2)) continue;
                    namedCallableStatement2.clearParameters();
                    namedCallableStatement2.setLong("object_id", dbObject.id);
                    namedCallableStatement2.setLong(FIELD_EXPORT_ID, l2.longValue());
                    namedCallableStatement2.execute();
                    list.add(namedCallableStatement2.getStatement());
                }
            }
            dbAgencyObject2 = new NamedCallableStatement(connection, "CALL save_immotool_agency_objects_exports(:object_id, :export_id);");
            for (Long l3 : dbAgencyObject.exportIds) {
                if (arrayList.contains(l3)) continue;
                dbAgencyObject2.clearParameters();
                dbAgencyObject2.setLong("object_id", l);
                dbAgencyObject2.setLong(FIELD_EXPORT_ID, l3);
                dbAgencyObject2.execute();
                list.add(dbAgencyObject2.getStatement());
            }
        }
    }

    @Override
    public void setObjectStatus(Connection connection, long l, DbAgencyObject.Status status) throws SQLException {
        this.setObjectStatus(connection, new long[]{l}, status);
    }

    @Override
    public void setObjectStatus(Connection connection, long[] lArray, DbAgencyObject.Status status) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_agency_objects_status(:object_id, :object_status);");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong("object_id", l);
                namedCallableStatement.setString(FIELD_OBJECT_STATUS, status != null ? StringUtils.abbreviate((String)status.name(), (int)25) : DbAgencyObject.Status.DRAFT.name());
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

