/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.HttpTransport;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.agency.export.SftpTransport;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractXmlFormat<XMLType>
extends AbstractFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractXmlFormat.class);
    private static final String XML_LINEBREAK = "xml.linebreak";

    protected abstract XMLType convertXml(TransferImpl var1, ExportContext var2);

    @Override
    public AbstractTransport[] getSupportedTransports() {
        return new AbstractTransport[]{new FtpTransport(), new SftpTransport(), new HttpTransport(), new LocalTransport()};
    }

    protected String getXmlFileName(ExportContext exportContext) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
        return "transfer-" + simpleDateFormat.format(exportContext.stamp) + ".xml";
    }

    public LineBreakMode getXmlLineBreak() {
        String string = StringUtils.trimToNull((String)((String)this.get(XML_LINEBREAK)));
        return string != null ? LineBreakMode.valueOf(string.toUpperCase()) : LineBreakMode.NATIVE;
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setXmlLineBreak(LineBreakMode.NATIVE);
    }

    public void setXmlLineBreak(LineBreakMode lineBreakMode) {
        if (lineBreakMode == null) {
            this.remove(XML_LINEBREAK);
        } else {
            this.put(XML_LINEBREAK, lineBreakMode.name());
        }
    }

    @Override
    public final File writeToDisk(File file, TransferImpl transferImpl, ExportContext exportContext) throws IOException {
        try {
            XMLType XMLType = this.convertXml(transferImpl, exportContext);
            if (XMLType == null) {
                throw new IOException("XML conversion failed!");
            }
            File file2 = new File(file, this.getXmlFileName(exportContext));
            try (FileWriterWithEncoding fileWriterWithEncoding = new FileWriterWithEncoding(file2, "UTF-8");){
                this.writeXmlObject(XMLType, (Writer)fileWriterWithEncoding);
                fileWriterWithEncoding.flush();
            }
            return exportContext.getWorkDir();
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't write XML!", jAXBException);
        }
    }

    protected abstract void writeXmlObject(XMLType var1, Writer var2) throws IOException, JAXBException;

    public static enum LineBreakMode implements Translatable
    {
        HTML("<br>", I18n.marktr((String)"HTML line breaks")),
        XHTML("<br/>", I18n.marktr((String)"XHTML line breaks")),
        NATIVE(System.lineSeparator(), I18n.marktr((String)"native line breaks"));

        private final String separator;
        private final String i18nKey;

        private LineBreakMode(String string2, String string3) {
            this.separator = string2;
            this.i18nKey = string3;
        }

        public String getSeparator() {
            return this.separator;
        }

        private String getSuffix() {
            switch (this) {
                case HTML: 
                case XHTML: {
                    return this.getSeparator();
                }
                case NATIVE: {
                    return "\\n / \\r / \\r\\n";
                }
            }
            return "";
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AbstractXmlFormat.class, (String)this.i18nKey) + " (" + this.getSuffix() + ")";
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AbstractXmlFormat.class, (String)this.i18nKey, (Locale)locale) + " (" + this.getSuffix() + ")";
        }
    }
}

