/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.PortNrField;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.FtpUtils;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.IDN;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class FtpTransportPanel
extends AbstractTransportPanel<FtpTransport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpTransportPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(FtpTransportPanel.class);
    private ValidationHandler validationHandler;
    private JLabel hostLabel;
    private JTextField hostField;
    private JLabel portLabel;
    private PortNrField portField;
    private JLabel userLabel;
    private JTextField userField;
    private JLabel passLabel;
    private JPasswordField passField;
    private JLabel pathLabel;
    private JTextField pathField;
    private JLabel cryptMethodLabel;
    private JComboBox<FtpUtils.CryptMethod> cryptMethodField;
    private JCheckBox anonymousField;
    private JCheckBox passiveField;
    private JCheckBox cryptSslSessionReusedField;
    private JXTitledSeparator testTitle;
    private TestAction testAction;
    private JXBusyLabel testBusyLabel;
    private TestTask testTask = null;

    public FtpTransportPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.hostLabel = new JLabel();
        this.hostField = new JTextField();
        this.portLabel = new JLabel();
        this.portField = new PortNrField();
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.passLabel = new JLabel();
        this.passField = new JPasswordField();
        this.pathLabel = new JLabel();
        this.pathField = new JTextField();
        this.cryptMethodLabel = new JLabel();
        this.cryptMethodField = new JComboBox();
        this.cryptMethodField.setRenderer((ListCellRenderer<FtpUtils.CryptMethod>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        this.cryptMethodField.addItem(null);
        for (FtpUtils.CryptMethod cryptMethod : FtpUtils.CryptMethod.values()) {
            this.cryptMethodField.addItem(cryptMethod);
        }
        this.cryptMethodField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!FtpTransportPanel.this.cryptMethodField.isEnabled()) {
                    return;
                }
                FtpTransportPanel.this.updateCryptMethod((FtpUtils.CryptMethod)FtpTransportPanel.this.cryptMethodField.getSelectedItem());
            }
        });
        this.cryptSslSessionReusedField = new JCheckBox();
        this.passiveField = new JCheckBox();
        this.anonymousField = new JCheckBox();
        this.anonymousField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FtpTransportPanel.this.userField.setEnabled(!FtpTransportPanel.this.anonymousField.isSelected());
                FtpTransportPanel.this.passField.setEnabled(!FtpTransportPanel.this.anonymousField.isSelected());
                FtpTransportPanel.this.validationHandler.validate((JComponent)FtpTransportPanel.this.userField);
                FtpTransportPanel.this.validationHandler.validate((JComponent)FtpTransportPanel.this.passField);
            }
        });
        this.testTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.testAction = new TestAction();
        this.testBusyLabel = new JXBusyLabel();
        this.testBusyLabel.setVisible(false);
        this.validationHandler.putRule((JComponent)this.hostField, ValidationHandler.HOSTNAME);
        this.validationHandler.putRule((JComponent)this.userField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.passField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.cryptMethodField, ValidationHandler.NOT_NULL);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu:grow, 3dlu,right:pref, 3dlu, 30dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.hostLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.hostField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.portLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.portField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.cryptMethodLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.cryptMethodField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.anonymousField).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.userLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.userField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.passLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.passField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.pathLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.pathField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.passiveField).xy(3, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.cryptSslSessionReusedField).xy(3, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.testTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)new JButton((Action)((Object)this.testAction))).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.testBusyLabel).xyw(3, defaultFormBuilder.row(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (FtpTransport)null);
    }

    private void doTest() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided transport settings are incomplete!"), (Component)((Object)this));
            return;
        }
        this.testAction.setEnabled(false);
        this.testBusyLabel.setBusy(true);
        this.testBusyLabel.setText("<html><b>" + I18N.tr("Testing connection.") + "</b><br>" + I18N.tr("Please wait for a moment.") + "</html>");
        this.testBusyLabel.setVisible(true);
        this.testTask = new TestTask();
        ImmoToolUtils.executeTask((ImmoToolTask)this.testTask);
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, FtpTransport ftpTransport) {
        if (this.testTask != null && !this.testTask.isDone()) {
            this.testTask.cancel(true);
        }
        if (ftpTransport == null) {
            this.anonymousField.setSelected(false);
            this.hostField.setText("");
            this.passField.setText("");
            this.passiveField.setSelected(false);
            this.pathField.setText("");
            this.portField.setPortNr(21);
            this.userField.setText("");
            this.cryptMethodField.setSelectedItem(null);
            this.cryptSslSessionReusedField.setSelected(false);
        } else {
            this.anonymousField.setSelected(!ftpTransport.isFtpLogin());
            this.hostField.setText(ftpTransport.getFtpHost());
            this.passField.setText(ftpTransport.getFtpLoginPass());
            this.passiveField.setSelected(ftpTransport.isFtpPassive());
            this.pathField.setText(ftpTransport.getFtpPath());
            this.portField.setValue((Object)ftpTransport.getFtpPort());
            this.userField.setText(ftpTransport.getFtpLoginUser());
            this.cryptSslSessionReusedField.setSelected(ftpTransport.isFtpCryptSslSessionReused());
            FtpUtils.CryptMethod cryptMethod = ftpTransport.getFtpCryptMethod();
            this.cryptMethodField.setSelectedItem(cryptMethod != null ? cryptMethod : FtpUtils.CryptMethod.NO_ENCRYPTION);
        }
        this.updateCryptMethod((FtpUtils.CryptMethod)this.cryptMethodField.getSelectedItem());
        this.testTask = null;
        this.testBusyLabel.setBusy(false);
        this.testBusyLabel.setVisible(false);
        this.testAction.setEnabled(true);
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, FtpTransport ftpTransport) {
        if (ftpTransport == null) {
            throw new NullPointerException("empty transport-class!");
        }
        if (this.testTask != null && !this.testTask.isDone()) {
            this.testTask.cancel(true);
        }
        ftpTransport.setFtpHost(this.hostField.getText().trim());
        ftpTransport.setFtpLogin(!this.anonymousField.isSelected());
        ftpTransport.setFtpLoginUser(!this.anonymousField.isSelected() ? this.userField.getText().trim() : "");
        ftpTransport.setFtpLoginPass(!this.anonymousField.isSelected() ? String.valueOf(this.passField.getPassword()).trim() : "");
        ftpTransport.setFtpPassive(this.passiveField.isSelected());
        ftpTransport.setFtpPath(this.pathField.getText().trim());
        ftpTransport.setFtpPort(this.portField.getPortNr());
        ftpTransport.setFtpCryptMethod((FtpUtils.CryptMethod)this.cryptMethodField.getSelectedItem());
        ftpTransport.setFtpCryptSslSessionReused(this.cryptSslSessionReusedField.isSelected());
    }

    private void updateCryptMethod(FtpUtils.CryptMethod cryptMethod) {
        if (cryptMethod == null || FtpUtils.CryptMethod.NO_ENCRYPTION.equals((Object)cryptMethod)) {
            this.cryptSslSessionReusedField.setEnabled(false);
            this.cryptSslSessionReusedField.setSelected(false);
        } else {
            this.cryptSslSessionReusedField.setEnabled(true);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.hostLabel.setText(StringUtils.capitalize((String)I18N.tr("hostname")) + ":");
        this.hostField.setToolTipText(I18N.tr("Enter the hostname / IP address of the server."));
        this.portLabel.setText(StringUtils.capitalize((String)"port-nr") + ":");
        this.portField.setToolTipText(I18N.tr("Enter the port-nr of the server. The default port-nr is {0}.", (Object)"21"));
        this.userLabel.setText(StringUtils.capitalize((String)"user") + ":");
        this.userField.setToolTipText(I18N.tr("Enter the user name for authentication at the server."));
        this.passLabel.setText(StringUtils.capitalize((String)"password") + ":");
        this.passField.setToolTipText(I18N.tr("Enter the password for authentication at the server."));
        this.pathLabel.setText(StringUtils.capitalize((String)I18N.tr("server path")) + ":");
        this.pathField.setToolTipText(I18N.tr("Enter the path at the FTP-server, where uploaded files will be saved to."));
        this.anonymousField.setText(I18N.tr("Don't login at the server (anonymous connection)."));
        this.anonymousField.setToolTipText(I18N.tr("Enable this option, if the server does not require an authentication."));
        this.passiveField.setText(I18N.tr("Use passive FTP transfer."));
        this.passiveField.setToolTipText(I18N.tr("Enable this option, to use a passive FTP connection for data transfer."));
        this.cryptMethodLabel.setText(StringUtils.capitalize((String)I18N.tr("encryption")) + ":");
        this.cryptMethodField.setToolTipText(I18N.tr("Use this field to specify, how encryption is handled by the server."));
        this.cryptSslSessionReusedField.setText(I18N.tr("Reuse SSL session for data connections."));
        this.cryptSslSessionReusedField.setToolTipText(I18N.tr("Enable this option, to reuse the SSL control session for data connections."));
        this.testTitle.setTitle(StringUtils.capitalize((String)I18N.tr("test connection")));
    }

    private class TestTask
    extends ImmoToolTask<Boolean, Void> {
        private TestTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            FTPClient fTPClient = null;
            try {
                Object object;
                boolean bl;
                String string = null;
                int n = 0;
                try {
                    string = IDN.toASCII(FtpTransportPanel.this.hostField.getText().trim());
                    n = FtpTransportPanel.this.portField.getPortNr();
                    bl = FtpTransportPanel.this.passiveField.isSelected();
                    object = (FtpUtils.CryptMethod)FtpTransportPanel.this.cryptMethodField.getSelectedItem();
                    boolean bl2 = FtpTransportPanel.this.cryptSslSessionReusedField.isSelected();
                    fTPClient = FtpUtils.openClient((String)string, (int)n, (boolean)bl, (FtpUtils.CryptMethod)object, (boolean)bl2);
                }
                catch (Exception exception) {
                    throw new Exception(I18N.tr("Connection denied! Please check hostname and port-nr!"), exception);
                }
                bl = false;
                if (!FtpTransportPanel.this.anonymousField.isSelected()) {
                    try {
                        object = FtpTransportPanel.this.userField.getText().trim();
                        String string2 = String.valueOf(FtpTransportPanel.this.passField.getPassword()).trim();
                        bl = fTPClient.login((String)object, string2);
                        if (!bl) {
                            LOGGER.warn("FTP-access-denied for " + (String)object + "@" + string + ":" + n);
                        } else {
                            fTPClient.sendNoOp();
                        }
                    }
                    catch (Exception exception) {
                        throw new Exception("internal login-error: " + exception.getLocalizedMessage(), exception);
                    }
                    if (!bl) {
                        throw new Exception(I18N.tr("Login denied! Please check username and password!"));
                    }
                }
                if (!fTPClient.setFileType(2)) {
                    LOGGER.warn("Can't change file-type!");
                }
                boolean bl3 = false;
                String string3 = StringUtils.trimToNull((String)FtpTransportPanel.this.pathField.getText());
                if (StringUtils.isBlank((CharSequence)string3)) {
                    string3 = "/";
                }
                try {
                    bl3 = fTPClient.changeWorkingDirectory(string3);
                    fTPClient.sendNoOp();
                }
                catch (Exception exception) {
                    throw new Exception("internal path-error: " + exception.getLocalizedMessage(), exception);
                }
                if (!bl3) {
                    throw new Exception(I18N.tr("The provided path was not found on the server!"));
                }
                Boolean bl4 = true;
                return bl4;
            }
            finally {
                try {
                    if (fTPClient != null && fTPClient.isConnected()) {
                        fTPClient.disconnect();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error on FTP-disconnection!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        protected void cancelled() {
            super.cancelled();
            FtpTransportPanel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test was cancelled!") + "</b></html>");
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            FtpTransportPanel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test failed!") + "</b><br>" + StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage()) + "</html>");
        }

        protected void finished() {
            super.finished();
            FtpTransportPanel.this.testTask = null;
            FtpTransportPanel.this.testBusyLabel.setBusy(false);
            FtpTransportPanel.this.testAction.setEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            FtpTransportPanel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test was successful!") + "</b></html>");
        }
    }

    private class TestAction
    extends AbstractI18nAction {
        public TestAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FtpTransportPanel.this.doTest();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("test")));
            this.setShortDescription(I18N.tr("Let the program try to connect to the configured server."));
        }
    }
}

