/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.Keywords;
import com.openindex.openestate.impl.attribs.descriptions.ShortDescription;
import com.openindex.openestate.impl.trovit.TrovitWriter;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.tool.ImmoToolAgent;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.ImmobiliareXmlFormat;
import com.openindex.openestate.tool.agency.export.KyeroXmlFormat;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlFormat;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.utils.ImageUtils;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.SyndFeedOutput;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openestate.io.immobiliare_it.ImmobiliareItDocument;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.xml.Feed;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.xml.Root;
import org.openestate.io.trovit.TrovitDocument;
import org.openestate.io.trovit.TrovitUtils;
import org.openestate.io.trovit.xml.Trovit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebsiteHtmlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteHtmlBuilder.class);
    private static final I18n I18N = I18nFactory.getI18n(WebsiteHtmlBuilder.class);
    private static final String LS = System.lineSeparator();
    private static final String HTML_RESOURCE_PATH = "/com/openindex/openestate/tool/agency/export/resources/html/";
    private static final String ENCODING = "UTF-8";
    private static final int ELEMENTS_PER_PAGE = 10;
    public static final String EXPOSE_DIR = "expose";
    public static final String INDEX_HTML = "index.html";
    public static final String PREVIEW_JPG = "preview.jpg";
    public static final String RSS_XML = "rss.xml";
    public static final String ATOM_XML = "atom.xml";
    public static final String KYERO_XML = "kyero.xml";
    public static final String TROVIT_XML = "trovit.xml";
    public static final String IMMOBILIARE_XML = "immobiliare.xml";
    public static final String COLORBOX_CSS = "colorbox/colorbox.css";
    public static final String COLORBOX_JS = "colorbox/jquery.colorbox-min.js";
    public static final String COLORBOX_JQUERY_JS = "colorbox/jquery.min.js";
    public static final String WEBSITE_CSS = "website.css";
    private final WebsiteHtmlFormat format;
    private final Locale language;
    private final I18n i18n;

    public WebsiteHtmlBuilder(WebsiteHtmlFormat websiteHtmlFormat) {
        this.format = websiteHtmlFormat;
        this.language = websiteHtmlFormat.getLanguage();
        this.i18n = I18nFactory.getI18n(WebsiteHtmlBuilder.class, (Locale)this.language);
    }

    /*
     * WARNING - void declaration
     */
    protected String buildExposePage(ExportEntry exportEntry, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, File file, String string, Date date) {
        void estateLinkImpl;
        Object object;
        StringBuilder stringBuilder;
        void string14;
        String string2;
        Object object3;
        Object object422;
        Object object5;
        Object object622;
        Object object7;
        OpenEstateAttrib[] openEstateAttribArray;
        String string3 = ((String)StringUtils.defaultIfBlank((CharSequence)exportEntry.objectNr, (CharSequence)("#" + exportEntry.objectId))).trim();
        String string4 = estateImpl.getType() != null ? estateImpl.getType().getTranslation(this.language) : this.i18n.tr("unknown type of property");
        String string5 = estateImpl.getAction() != null ? estateImpl.getAction().getTranslation(this.language) : this.i18n.tr("unknown type of marketing");
        String string6 = StringUtils.trimToNull((String)estateImpl.getTitle(this.language));
        if (string6 == null) {
            string6 = string4 + ", " + string5 + ", " + estateImpl.getAddress().getPostalCode() + " " + estateImpl.getAddress().getCity() + ", " + estateImpl.getAddress().writeCountry(this.language);
        }
        String string7 = null;
        Object object8 = openEstateAttribArray = new OpenEstateAttrib[]{OpenEstateAttrib.DESCRIPTIONS_SHORT_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_DETAILLED_DESCRIPTION};
        int n = ((OpenEstateAttrib[])object8).length;
        for (int i = 0; !(i >= n || estateImpl.hasAttribute((OpenEstateAttrib)(object7 = object8[i])) && (string7 = StringUtils.trimToNull((String)AgencyPluginUtils.writeValueForPublic(estateImpl, (OpenEstateAttrib)object7, this.language))) != null); ++i) {
        }
        if (StringUtils.isBlank(string7)) {
            string7 = string6;
        }
        string7 = string7.replaceAll("\\n", " ").replaceAll("\\r", " ").replaceAll("\\s\\s", " ");
        string7 = StringUtils.abbreviate((String)string7, (int)150);
        object8 = StringUtils.trimToNull((String)Keywords.get((EstateImpl)estateImpl, (Locale)this.language));
        if (object8 == null) {
            String string8;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string9 = string8 = estateImpl.getType() != null ? estateImpl.getType().getTranslation(this.language) : null;
            if (string8 != null) {
                arrayList.add(string8);
            }
            String string10 = string8 = estateImpl.getAction() != null ? estateImpl.getAction().getTranslation(this.language) : null;
            if (string8 != null) {
                arrayList.add(string8);
            }
            if ((string8 = estateImpl.getAddress().getPostalCode()) != null) {
                arrayList.add(string8);
            }
            if ((string8 = estateImpl.getAddress().getCity()) != null) {
                arrayList.add(string8);
            }
            if ((string8 = estateImpl.getAddress().getDistrict()) != null) {
                arrayList.add(string8);
            }
            if ((string8 = estateImpl.getAddress().writeCountry(this.language)) != null) {
                arrayList.add(string8);
            }
            object8 = StringUtils.trimToEmpty((String)StringUtils.join(arrayList, (String)","));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object622 : estateImpl.getAttachments()) {
            if (!object622.isName()) continue;
            object5 = new File(file, object622.getFileAsName());
            if (!((File)object5).isFile()) {
                LOGGER.warn("Can't find attached file: " + ((File)object5).getAbsolutePath());
                continue;
            }
            object422 = StringUtils.trimToEmpty((String)object622.getMimeType()).toLowerCase();
            if (((String)object422).startsWith("image/")) {
                arrayList.add(object622);
                continue;
            }
            arrayList2.add(object622);
        }
        object7 = new ArrayList();
        object622 = new ArrayList();
        for (Object object422 : estateImpl.getLinks()) {
            if (object422.isProviderLink()) {
                object3 = object422.getProviderLink();
                if (!object3.isVideo()) continue;
                object7.add(object422);
                continue;
            }
            if (!object422.isWebLink()) continue;
            object622.add(object422);
        }
        object5 = "<div class=\"expose-nav\">";
        object5 = (String)object5 + "[ <a href=\"../../index.html\" title=\"" + this.i18n.tr("all properties") + "\">" + this.i18n.tr("all properties") + "</a> ]";
        if (string != null) {
            object5 = (String)object5 + "[ <a href=\"" + string + "\" target=\"_blank\" title=\"" + this.i18n.tr("download expos\u00e9") + "\">" + this.i18n.tr("download expos\u00e9") + "</a> ]";
        }
        object5 = (String)object5 + "[ <a href=\"#\" onclick=\"window.print();return false;\" title=\"" + this.i18n.tr("print expos\u00e9") + "\">" + this.i18n.tr("print expos\u00e9") + "</a> ]";
        object5 = (String)object5 + "</div>";
        object422 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">" + LS + "<html xmlns=\"http://www.w3.org/1999/xhtml\">" + LS + "<head>" + LS + "<title>" + WebsiteHtmlBuilder.escapeText(string6) + " | " + StringUtils.capitalize((String)this.i18n.tr("expos\u00e9")) + " " + string3 + "</title>" + LS + "<meta http-equiv=\"content-type\" content=\"text/html; charset=" + ENCODING + "\"/>" + LS + "<meta name=\"description\" content=\"" + WebsiteHtmlBuilder.escapeText(string7) + "\"/>" + LS + "<meta name=\"keywords\" content=\"" + WebsiteHtmlBuilder.escapeText((String)object8) + "\"/>" + LS + "<meta name=\"author\" content=\"" + WebsiteHtmlBuilder.escapeText(agentImpl.getCompany().getCompanyName()) + "\"/>" + LS + "<meta name=\"generator\" content=\"" + WebsiteHtmlBuilder.escapeText(ImmoToolEnvironment.getApplicationTitle()) + " " + WebsiteHtmlBuilder.escapeText(ImmoToolEnvironment.getApplicationVersion()) + "\"/>" + LS + "<meta name=\"robots\" content=\"index,follow\"/>";
        object3 = StringUtils.trimToNull((String)WEBSITE_CSS);
        if (object3 != null) {
            object422 = (String)object422 + LS + "<link rel=\"stylesheet\" type=\"text/css\" href=\"../../" + (String)object3 + "\"/>";
        }
        if ((string2 = StringUtils.trimToNull((String)this.format.getHtmlStylesheet())) != null) {
            object422 = (String)object422 + LS + "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + string2 + "\"/>";
        }
        if (this.format.isHtmlFeedRss()) {
            object422 = (String)object422 + LS + "<link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS-Feed\" href=\"../../" + RSS_XML + "\" />";
        }
        if (this.format.isHtmlFeedAtom()) {
            object422 = (String)object422 + LS + "<link rel=\"alternate\" type=\"application/atom+xml\" title=\"Atom-Feed\" href=\"../../" + ATOM_XML + "\" />";
        }
        if (!arrayList.isEmpty() && this.format.isHtmlImageColorbox()) {
            object422 = (String)object422 + LS + "<link type=\"text/css\" media=\"screen\" rel=\"stylesheet\" href=\"../../" + COLORBOX_CSS + "\" />";
            object422 = (String)object422 + LS + "<script type=\"text/javascript\" src=\"../../" + COLORBOX_JQUERY_JS + "\"></script>";
            object422 = (String)object422 + LS + "<script type=\"text/javascript\" src=\"../../" + COLORBOX_JS + "\"></script>";
            object422 = (String)object422 + LS + "<script type=\"text/javascript\">";
            object422 = (String)object422 + LS + "//<!--";
            object422 = (String)object422 + LS + "$(document).ready(function(){";
            object422 = (String)object422 + LS + "  $(\"a[rel='gallery']\").colorbox({transition:\"none\", width:\"75%\", height:\"75%\"});";
            object422 = (String)object422 + LS + "});";
            object422 = (String)object422 + LS + "//-->";
            object422 = (String)object422 + LS + "</script>";
        }
        object422 = (String)object422 + LS + "</head>";
        object422 = (String)object422 + LS + "<body>";
        object422 = (String)object422 + LS + "<div id=\"page\" class=\"expose\">";
        object422 = (String)object422 + LS + (String)object5;
        String string11 = StringUtils.trimToNull((String)estateImpl.getTitle(this.language));
        if (string11 == null) {
            string11 = estateImpl.getFallbackTitle(this.language);
        }
        object422 = (String)object422 + LS + "<div id=\"expose-header\"><h1>" + StringUtils.capitalize((String)this.i18n.tr("expos\u00e9")) + " " + string3 + " &bull; " + string11 + "</h1><h2>" + string4 + " / " + string5 + "</h2></div>";
        object422 = (String)object422 + LS + "<div id=\"expose-estate\"" + (this.format.isHtmlShowAgent() || this.format.isHtmlShowContact() ? " class=\"col_left\"" : "") + ">";
        object422 = (String)object422 + LS + "<div id=\"expose-estate-adress\"><h3>" + StringUtils.capitalize((String)this.i18n.tr("address")) + "</h3><p>" + estateImpl.getAddress().writeFullAddress("<br/>", this.language) + "</p></div>";
        object422 = (String)object422 + LS + "<div id=\"expose-estate-attribs\">";
        Object object9 = OpenEstateAttribGroup.values();
        int n3 = ((OpenEstateAttribGroup[])object9).length;
        boolean i = false;
        while (string14 < n3) {
            OpenEstateAttribGroup openEstateAttribGroup = object9[string14];
            if (!OpenEstateAttribGroup.DESCRIPTIONS.equals((Object)openEstateAttribGroup)) {
                stringBuilder = new StringBuilder();
                object = openEstateAttribGroup.getAttributes();
                int n2 = ((OpenEstateAttrib[])object).length;
                for (int j = 0; j < n2; ++j) {
                    String string12;
                    AbstractAttribImpl abstractAttribImpl;
                    OpenEstateAttrib openEstateAttrib = object[j];
                    if (OpenEstateAttrib.PRICES_SPECIAL_OFFER.equals((Object)openEstateAttrib) || (abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib)) == null || (string12 = StringUtils.trimToNull((String)AgencyPluginUtils.writeValueForPublic(estateImpl, abstractAttribImpl, this.language))) == null) continue;
                    stringBuilder.append("<li>").append(openEstateAttrib.getTranslation(this.language)).append(":").append("<b>").append(WebsiteHtmlBuilder.escapeText(string12)).append("</b>").append("</li>");
                }
                if (stringBuilder.length() > 0) {
                    object422 = (String)object422 + "<h3>" + openEstateAttribGroup.getTranslation(this.language) + "</h3><ul>" + stringBuilder.toString() + "</ul>";
                }
            }
            ++string14;
        }
        object422 = (String)object422 + "</div>";
        stringBuilder = new StringBuilder();
        object9 = OpenEstateAttribGroup.DESCRIPTIONS.getAttributes();
        n3 = ((OpenEstateAttribGroup[])object9).length;
        boolean bigDecimal2 = false;
        while (estateLinkImpl < n3) {
            String string13;
            OpenEstateAttribGroup openEstateAttribGroup = object9[estateLinkImpl];
            if (!(estateImpl.isHiddenPrices() && openEstateAttribGroup.equals((Object)OpenEstateAttrib.DESCRIPTIONS_PRICE_DESCRIPTION) || openEstateAttribGroup.equals((Object)OpenEstateAttrib.DESCRIPTIONS_SHORT_DESCRIPTION) || openEstateAttribGroup.equals((Object)OpenEstateAttrib.DESCRIPTIONS_KEYWORDS) || (object = estateImpl.getAttribute((OpenEstateAttrib)openEstateAttribGroup)) == null || (string13 = StringUtils.trimToNull((String)AgencyPluginUtils.writeValueForPublic(estateImpl, (AbstractAttribImpl)object, this.language))) == null)) {
                stringBuilder.append(LS).append("<div class=\"expose-estate-text\">").append("<h3>").append(openEstateAttribGroup.getTranslation(this.language)).append("</h3>").append("<p>").append(WebsiteHtmlBuilder.writeText(WebsiteHtmlBuilder.escapeText(string13.trim()))).append("</p>").append("</div>");
            }
            ++estateLinkImpl;
        }
        object422 = (String)object422 + stringBuilder.toString();
        if (!arrayList.isEmpty()) {
            object422 = (String)object422 + LS + "<div id=\"expose-estate-gallery\"><h3>" + StringUtils.capitalize((String)this.i18n.tr("image gallery")) + "</h3>";
            stringBuilder = new StringBuilder();
            object9 = arrayList.iterator();
            while (object9.hasNext()) {
                EstateAttachmentImpl estateAttachmentImpl = (EstateAttachmentImpl)object9.next();
                stringBuilder.append("<div class=\"image\">");
                String estateAttachmentImpl2 = StringUtils.trimToNull((String)estateAttachmentImpl.getTitle(this.language));
                if (estateAttachmentImpl2 != null) {
                    stringBuilder.append("<h4>").append(StringEscapeUtils.escapeXml11((String)estateAttachmentImpl2)).append("</h4>");
                }
                String estateLinkImpl2 = StringUtils.trimToEmpty((String)estateAttachmentImpl2);
                String string15 = FilenameUtils.getName((String)estateAttachmentImpl.getFileAsName());
                if (this.format.isHtmlImageColorbox()) {
                    stringBuilder.append(LS).append("<script type=\"text/javascript\">");
                    stringBuilder.append(LS).append("//<!--");
                    stringBuilder.append(LS).append("document.write( '<a href=\"").append(string15).append("\" ").append("title=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\" rel=\"gallery\">").append("<img src=\"").append(string15).append("\" ").append("title=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\" ").append("alt=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\" border=\"0\" width=\"50%\" height=\"50%\" /></a>' );");
                    stringBuilder.append(LS).append("//-->");
                    stringBuilder.append(LS).append("</script>");
                    stringBuilder.append("<noscript><a href=\"").append(string15).append("\" target=\"_blank\" ").append("title=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\">").append("<img src=\"").append(string15).append("\" ").append("title=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\" ").append("alt=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\" border=\"0\" width=\"50%\" height=\"50%\"/>").append("</a></noscript>");
                } else {
                    stringBuilder.append("<a href=\"").append(string15).append("\" ").append("title=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\" target=\"_blank\">").append("<img src=\"").append(string15).append("\" ").append("title=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\" ").append("alt=\"").append(StringEscapeUtils.escapeXml11((String)estateLinkImpl2)).append("\" border=\"0\" width=\"50%\" height=\"50%\" />").append("</a>");
                }
                stringBuilder.append("</div>");
            }
            object422 = (String)object422 + stringBuilder.toString();
            object422 = (String)object422 + "</div>";
        }
        if ((object9 = this.format.getHtmlMapType()) != null) {
            BigDecimal bigDecimal = estateImpl.getAddress().getLatitude();
            BigDecimal string17 = estateImpl.getAddress().getLongitude();
            if (bigDecimal != null && string17 != null) {
                void var28_61;
                Object var28_58 = null;
                object = null;
                if (WebsiteHtmlFormat.MapType.GOOGLE.equals(object9)) {
                    object = "https://maps.google.com/?ie=UTF8&amp;t=m&amp;ll=" + bigDecimal + "," + string17 + "&amp;z=12";
                    String string16 = "https://maps.google.com/?ie=UTF8&amp;t=m&amp;ll=" + bigDecimal + "," + string17 + "&amp;z=12&amp;output=embed";
                } else if (WebsiteHtmlFormat.MapType.OSM.equals(object9)) {
                    object = "https://www.openstreetmap.org/?lat=" + bigDecimal + "&amp;lon=" + string17 + "&amp;zoom=12&amp;layers=M";
                    double d = 0.05;
                    double d2 = (double)Math.round(bigDecimal.doubleValue() * 100.0) / 100.0;
                    double d3 = (double)Math.round(string17.doubleValue() * 100.0) / 100.0;
                    String string18 = d3 - d + "," + (d2 - d) + "," + (d3 + d) + "," + (d2 + d);
                    String string19 = "https://www.openstreetmap.org/export/embed.html?bbox=" + string18 + "&amp;layer=mapnik";
                }
                object422 = (String)object422 + LS + "<div id=\"expose-estate-map\"><h3>" + StringUtils.capitalize((String)this.i18n.tr("map")) + "</h3>";
                if (var28_61 != null) {
                    object422 = (String)object422 + "<iframe src=\"" + (String)var28_61 + "\" width=\"640\" height=\"480\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\"></iframe>";
                    if (object != null) {
                        object422 = (String)object422 + "<br/>";
                    }
                }
                if (object != null) {
                    object422 = (String)object422 + "<small><a href=\"" + (String)object + "\" target=\"_blank\">" + this.i18n.tr("enlarge map") + "</a></small>";
                }
                object422 = (String)object422 + "</div>";
            }
        }
        if (!object7.isEmpty()) {
            object422 = (String)object422 + LS + "<div id=\"expose-estate-videos\"><h3>" + StringUtils.capitalize((String)this.i18n.tr("videos")) + "</h3>";
            stringBuilder = new StringBuilder();
            Iterator iterator = object7.iterator();
            while (iterator.hasNext()) {
                EstateLinkImpl string18 = (EstateLinkImpl)iterator.next();
                EstateLinkImpl.ProviderLink providerLink = string18.getProviderLink();
                if (providerLink == null) continue;
                object = string18.getTitle(this.language);
                if (StringUtils.isBlank((CharSequence)object)) {
                    object = providerLink.getLinkId();
                }
                stringBuilder.append(providerLink.getProvider().getEmbedHtml(providerLink.getLinkId(), (String)object, 560, 315));
            }
            object422 = (String)object422 + stringBuilder.toString();
            object422 = (String)object422 + "</div>";
        }
        if (!arrayList2.isEmpty()) {
            object422 = (String)object422 + LS + "<div id=\"expose-estate-media\"><h3>" + StringUtils.capitalize((String)this.i18n.tr("additional files")) + "</h3><ul>";
            stringBuilder = new StringBuilder();
            for (EstateAttachmentImpl string20 : arrayList2) {
                String string21 = FilenameUtils.getName((String)string20.getFileAsName());
                object = string20.getTitle(this.language);
                if (StringUtils.isBlank((CharSequence)object)) {
                    object = string21;
                }
                object = StringUtils.trimToEmpty((String)object);
                stringBuilder.append("<li><a href=\"").append(string21).append("\" target=\"_blank\" ").append("title=\"").append(StringEscapeUtils.escapeXml11((String)object)).append("\">").append(StringEscapeUtils.escapeXml11((String)object)).append("</a></li>");
            }
            object422 = (String)object422 + stringBuilder.toString();
            object422 = (String)object422 + "</ul></div>";
        }
        if (!object622.isEmpty()) {
            object422 = (String)object422 + LS + "<div id=\"expose-estate-links\"><h3>" + StringUtils.capitalize((String)this.i18n.tr("links")) + "</h3><ul>";
            stringBuilder = new StringBuilder();
            Iterator iterator = object622.iterator();
            while (iterator.hasNext()) {
                EstateLinkImpl estateLinkImpl3 = (EstateLinkImpl)iterator.next();
                URI uRI = estateLinkImpl3.getWebLink();
                if (uRI == null) continue;
                object = estateLinkImpl3.getTitle(this.language);
                if (StringUtils.isBlank((CharSequence)object)) {
                    object = uRI.toString();
                }
                object = StringUtils.trimToEmpty((String)object);
                stringBuilder.append("<li><a href=\"").append(uRI.toString()).append("\" target=\"_blank\" ").append("title=\"").append(StringEscapeUtils.escapeXml11((String)object)).append("\">").append(StringEscapeUtils.escapeXml11((String)object)).append("</a></li>");
            }
            object422 = (String)object422 + stringBuilder.toString();
            object422 = (String)object422 + "</ul></div>";
        }
        String string16 = StringUtils.trimToNull((String)agentImpl.getTerms(this.language));
        if (this.format.isHtmlShowTerms() && string16 != null) {
            String string22 = WebsiteHtmlBuilder.escapeText(string16).replaceAll(Pattern.quote(LS), "<br/>");
            object422 = (String)object422 + LS + "<div id=\"expose-estate-terms\"><h3>" + StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)this.i18n.tr("terms & conditions"))) + "</h3><p>" + WebsiteHtmlBuilder.writeText(string22) + "</p></div>";
        }
        object422 = (String)object422 + "</div>";
        if (this.format.isHtmlShowAgent() || this.format.isHtmlShowContact()) {
            object422 = (String)object422 + LS + "<div id=\"expose-agent\" class=\"col_right\">";
            if (this.format.isHtmlShowContact() && agentContactImpl != null) {
                String string23;
                String string24;
                String string25;
                object422 = (String)object422 + LS + "<div id=\"expose-agent-contact\"><h3>" + StringUtils.capitalize((String)this.i18n.tr("your contact person")) + "</h3><ul>";
                object422 = (String)object422 + "<li>" + agentContactImpl.writePersonFullName() + "<br/>" + agentContactImpl.writeFullAddress("<br/>", this.language) + "</li>";
                String string26 = StringUtils.trimToNull((String)agentContactImpl.getPersonPhone());
                if (string26 != null) {
                    object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("phone")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string26) + "</li>";
                }
                if ((string25 = StringUtils.trimToNull((String)agentContactImpl.getPersonMobilePhone())) != null) {
                    object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("mobile")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string25) + "</li>";
                }
                if ((string24 = StringUtils.trimToNull((String)agentContactImpl.getPersonFax())) != null) {
                    object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("fax")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string24) + "</li>";
                }
                if ((string23 = StringUtils.trimToNull((String)agentContactImpl.getPersonMail())) != null) {
                    object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("e-mail")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string23).replace("@", " [a] ").replaceAll("\\.", " [.] ") + "</li>";
                }
                object422 = (String)object422 + "</ul></div>";
            }
            if (this.format.isHtmlShowAgent()) {
                String string27;
                String string28 = " (" + this.i18n.tr("head office") + ")";
                CompanyAddressImpl companyAddressImpl = agentImpl.getCompany();
                object422 = (String)object422 + LS + "<div id=\"expose-agent-company\"><h3>" + StringUtils.capitalize((String)this.i18n.tr("agency")) + "</h3><ul>";
                object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("company")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(companyAddressImpl.getCompanyName()).trim() + "</li>";
                object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("address")) + "</b><br/>" + companyAddressImpl.writeFullAddress("<br/>", this.language).trim() + "</li>";
                object = companyAddressImpl.getCompanyWebsite();
                if (object != null && !StringUtils.isBlank((CharSequence)((URI)object).getHost())) {
                    object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("website")) + "</b><br/><a href=\"" + ((URI)object).toString() + "\" target=\"_blank\">" + ((URI)object).toString() + "</a></li>";
                }
                if ((string27 = StringUtils.trimToNull((String)companyAddressImpl.getCompanyPhone())) != null) {
                    object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("phone")) + string28 + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string27) + "</li>";
                }
                if ((string27 = StringUtils.trimToNull((String)companyAddressImpl.getCompanyFax())) != null) {
                    object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("fax")) + string28 + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string27) + "</li>";
                }
                if ((string27 = StringUtils.trimToNull((String)companyAddressImpl.getCompanyMail())) != null) {
                    object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("e-mail")) + string28 + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string27).replace("@", " [a] ").replaceAll("\\.", " [.] ") + "</li>";
                }
                if (agentImpl instanceof ImmoToolAgent) {
                    ImmoToolAgent immoToolAgent = (ImmoToolAgent)agentImpl;
                    string27 = StringUtils.trimToNull((String)immoToolAgent.getAufsichtsBehoerde());
                    if (string27 != null) {
                        object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("controlling authority")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string27) + "</li>";
                    }
                    if ((string27 = StringUtils.trimToNull((String)immoToolAgent.getGewerbeErlaubnis())) != null) {
                        object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("concession")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string27).replaceAll(Pattern.quote(LS), "<br/>") + "</li>";
                    }
                    if ((string27 = StringUtils.trimToNull((String)immoToolAgent.getHandelsRegister())) != null) {
                        object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("company registry")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string27) + "</li>";
                    }
                    if ((string27 = StringUtils.trimToNull((String)immoToolAgent.getUstId())) != null) {
                        object422 = (String)object422 + "<li><b>" + this.i18n.tr("VAT ID") + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string27) + "</li>";
                    }
                    if ((string27 = StringUtils.trimToNull((String)immoToolAgent.getVertretung())) != null) {
                        object422 = (String)object422 + "<li><b>" + StringUtils.capitalize((String)this.i18n.tr("authorized representative")) + "</b><br/>" + WebsiteHtmlBuilder.escapeText(string27) + "</li>";
                    }
                }
                object422 = (String)object422 + "</ul></div>";
            }
            object422 = (String)object422 + "</div>";
        }
        object422 = (String)object422 + LS + "<div class=\"clear\"></div>";
        object422 = (String)object422 + LS + (String)object5;
        object422 = (String)object422 + LS + "<div id=\"index-footer\"><div style=\"float:right;\">" + DateFormat.getDateTimeInstance(2, 3, this.language).format(date) + "</div>";
        object422 = (String)object422 + "<div style=\"float:left;\">powered by <a href=\"https://openestate.org/\" target=\"_blank\" title=\"powered by OpenEstate.org\">OpenEstate</a></div>";
        object422 = (String)object422 + "<div class=\"clear\"></div>";
        object422 = (String)object422 + "</div>";
        object422 = (String)object422 + LS + "</div>";
        object422 = (String)object422 + LS + "</body>";
        object422 = (String)object422 + LS + "</html>";
        return object422;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String buildIndexItem(ExportEntry exportEntry, EstateImpl estateImpl, File file, String string) {
        Object object;
        Object object2;
        BufferedImage bufferedImage;
        String string2 = "expose/" + exportEntry.objectId;
        String string3 = string2 + "/" + INDEX_HTML;
        String string4 = string2 + "/" + PREVIEW_JPG;
        String string5 = ((String)StringUtils.defaultIfBlank((CharSequence)exportEntry.objectNr, (CharSequence)("#" + exportEntry.objectId))).trim();
        String string6 = estateImpl.getType() != null ? estateImpl.getType().getTranslation(this.language) : this.i18n.tr("unknown type of property");
        String string7 = estateImpl.getAction() != null ? estateImpl.getAction().getTranslation(this.language) : this.i18n.tr("unknown type of marketing");
        AbstractTypeImpl abstractTypeImpl = estateImpl.getTypeSpec();
        String string8 = StringUtils.trimToNull((String)estateImpl.getTitle(this.language));
        if (string8 == null) {
            string8 = estateImpl.getFallbackTitle(this.language);
        }
        String string9 = "<div class=\"item\">";
        string9 = string9 + LS + "<h3><a href=\"" + string3 + "\" title=\"" + this.i18n.tr("Show details about the property.") + "\">" + string5 + " | " + WebsiteHtmlBuilder.escapeText(string8) + "</a></h3>";
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            if (!estateAttachmentImpl.isName()) continue;
            File file2 = new File(file, estateAttachmentImpl.getFileAsName());
            if (!file2.isFile()) {
                LOGGER.warn("Can't find attached file: " + file2.getAbsolutePath());
                continue;
            }
            String string10 = StringUtils.trimToEmpty((String)estateAttachmentImpl.getMimeType()).toLowerCase();
            if (!string10.startsWith("image/")) continue;
            bufferedImage = null;
            object2 = null;
            object = null;
            File file3 = new File(file2.getAbsoluteFile().getParentFile(), PREVIEW_JPG);
            try {
                bufferedImage = ImageUtils.readAsRgb((File)file2);
                object2 = ImageUtils.cropToRatio((BufferedImage)bufferedImage, (int)100, (int)75);
                object = ImageUtils.scaleToFit((BufferedImage)object2, (int)100, (int)75);
                try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
                    ImageUtils.writeJpg((BufferedImage)object, (OutputStream)fileOutputStream);
                }
                string9 = string9 + LS + "<div class=\"img\"><a href=\"" + string3 + "\" title=\"" + this.i18n.tr("Show details about the property.") + "\"><img src=\"" + string4 + "\" alt=\"\" border=\"0\"/></a></div>";
                break;
            }
            catch (Exception exception) {
                FileUtils.deleteQuietly((File)file3);
                LOGGER.error("Can't create preview image!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                if (bufferedImage != null) {
                    bufferedImage.flush();
                }
                if (object2 != null) {
                    ((Image)object2).flush();
                }
                if (object == null) continue;
                ((Image)object).flush();
            }
        }
        string9 = string9 + LS + "<div class=\"block\"><ul><li>" + WebsiteHtmlBuilder.escapeText(string6) + "</li><li>" + WebsiteHtmlBuilder.escapeText(string7) + "</li><li>" + WebsiteHtmlBuilder.escapeText(estateImpl.getAddress().writePostal()) + "</li><li>" + WebsiteHtmlBuilder.escapeText(estateImpl.getAddress().writeCountry(this.language)) + "</li></ul></div>";
        if (abstractTypeImpl != null && estateImpl.getAction() != null) {
            string9 = string9 + LS + "<div class=\"block\"><ul>";
            StringBuilder stringBuilder = new StringBuilder();
            for (OpenEstateAttrib openEstateAttrib : abstractTypeImpl.getAttribs(estateImpl.getAction())) {
                if (!abstractTypeImpl.isAttribRequired(openEstateAttrib)) continue;
                bufferedImage = openEstateAttrib;
                if ("it".equalsIgnoreCase(estateImpl.getAddress().getCountry()) && OpenEstateAttrib.MEASURES_RESIDENTIAL_AREA.equals((Object)openEstateAttrib) && estateImpl.hasAttribute(OpenEstateAttrib.MEASURES_GROSS_AREA)) {
                    bufferedImage = OpenEstateAttrib.MEASURES_GROSS_AREA;
                }
                object2 = bufferedImage.getTranslation(this.language);
                object = StringUtils.trimToNull((String)AgencyPluginUtils.writeValueForPublic(estateImpl, (OpenEstateAttrib)bufferedImage, this.language));
                if (object == null) continue;
                stringBuilder.append("<li>").append(WebsiteHtmlBuilder.escapeText((String)object2)).append(":").append("<b>").append(WebsiteHtmlBuilder.escapeText((String)object)).append("</b>").append("</li>");
            }
            string9 = string9 + stringBuilder.toString();
            string9 = string9 + "</ul></div>";
        }
        string9 = string9 + LS + "<div class=\"nav\">";
        string9 = string9 + "&raquo; <a href=\"" + string2 + "/" + INDEX_HTML + "\" title=\"" + this.i18n.tr("show details") + "\">" + StringUtils.capitalize((String)this.i18n.tr("show details")) + "</a>";
        if (string != null) {
            string9 = string9 + "<br/>&raquo; <a href=\"" + string + "\" target=\"_blank\" title=\"" + this.i18n.tr("download expos\u00e9") + "\">" + StringUtils.capitalize((String)this.i18n.tr("download expos\u00e9")) + "</a>";
        }
        string9 = string9 + "</div>";
        string9 = string9 + LS + "<div class=\"clear\"></div>";
        string9 = string9 + LS + "</div>";
        return string9;
    }

    protected String buildIndexPage(Map<Long, String> map, AgentImpl agentImpl, int n, int n2, int n3, Date date) {
        String string;
        String string2;
        String string3;
        if (n < 0) {
            throw new IllegalArgumentException("invalid page #" + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid page-count!");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("invalid element-count!");
        }
        String string4 = "";
        if (n2 > 0 && n > 0) {
            string3 = FilenameUtils.getBaseName((String)INDEX_HTML);
            string2 = FilenameUtils.getExtension((String)INDEX_HTML);
            string4 = string4 + "<div class=\"index-nav\">";
            if (n > 1) {
                string = n == 2 ? INDEX_HTML : string3 + "_" + (n - 1) + "." + string2;
                string4 = string4 + "[ <a href=\"" + string + "\" title=\"" + this.i18n.tr("previous page") + "\">" + this.i18n.tr("previous page") + "</a> ]";
            }
            if (n < n2) {
                string = string3 + "_" + (n + 1) + "." + string2;
                string4 = string4 + "[ <a href=\"" + string + "\" title=\"" + this.i18n.tr("next page") + "\">" + this.i18n.tr("next page") + "</a> ]";
            }
            string4 = string4 + "</div>";
        }
        string3 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">" + LS + "<html xmlns=\"http://www.w3.org/1999/xhtml\">" + LS + "<head>" + LS + "<title>" + StringUtils.capitalize((String)this.i18n.tr("all properties")) + " | " + WebsiteHtmlBuilder.escapeText(this.format.getHtmlTitle()) + "</title>" + LS + "<meta http-equiv=\"content-type\" content=\"text/html; charset=" + ENCODING + "\"/>" + LS + "<meta name=\"author\" content=\"" + WebsiteHtmlBuilder.escapeText(agentImpl.getCompany().getCompanyName()) + "\"/>" + LS + "<meta name=\"generator\" content=\"" + WebsiteHtmlBuilder.escapeText(ImmoToolEnvironment.getApplicationTitle()) + " " + WebsiteHtmlBuilder.escapeText(ImmoToolEnvironment.getApplicationVersion()) + "\"/>" + LS + "<meta name=\"robots\" content=\"noindex,follow\"/>";
        string2 = StringUtils.trimToNull((String)WEBSITE_CSS);
        if (string2 != null) {
            string3 = string3 + LS + "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + string2 + "\"/>";
        }
        if ((string = StringUtils.trimToNull((String)this.format.getHtmlStylesheet())) != null) {
            string3 = string3 + LS + "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + string + "\"/>";
        }
        if (this.format.isHtmlFeedRss()) {
            string3 = string3 + LS + "<link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS-Feed\" href=\"" + RSS_XML + "\" />";
        }
        if (this.format.isHtmlFeedAtom()) {
            string3 = string3 + LS + "<link rel=\"alternate\" type=\"application/atom+xml\" title=\"Atom-Feed\" href=\"" + ATOM_XML + "\" />";
        }
        string3 = string3 + LS + "</head>";
        string3 = string3 + LS + "<body>";
        string3 = string3 + LS + "<div id=\"page\" class=\"index\">";
        if (n2 > 0 && n > 0) {
            string3 = string3 + LS + string4;
        }
        string3 = string3 + LS + "<div id=\"index-header\"><h1>" + StringUtils.capitalize((String)this.i18n.tr("all properties")) + "</h1><h2>" + WebsiteHtmlBuilder.escapeText(this.format.getHtmlTitle()) + "</h2>";
        string3 = n2 > 0 && n > 0 ? string3 + this.i18n.tr("page {0} of {1}", (Object)n, (Object)n2) : string3 + "<i>" + this.i18n.tr("There are no published properties at the moment.") + "</i>";
        string3 = string3 + "</div>";
        if (n2 > 0 && n > 0) {
            string3 = string3 + LS + "<div id=\"index-result\">";
            int n4 = (n - 1) * n3;
            int n5 = n4 + n3;
            Long[] longArray = map.keySet().toArray(new Long[0]);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n4; i < n5 && longArray.length > i; ++i) {
                stringBuilder.append(LS).append(map.get(longArray[i]));
            }
            string3 = string3 + stringBuilder.toString();
            string3 = string3 + "</div>";
            string3 = string3 + LS + "<div class=\"clear\"></div>";
            string3 = string3 + LS + string4;
        }
        string3 = string3 + LS + "<div id=\"index-footer\"><div style=\"float:right;\">" + DateFormat.getDateTimeInstance(2, 3, this.language).format(date) + "</div>";
        string3 = string3 + "<div style=\"float:left;\">powered by <a href=\"https://openestate.org/\" target=\"_blank\" title=\"powered by OpenEstate.org\">OpenEstate</a></div>";
        string3 = string3 + "<div class=\"clear\"></div>";
        string3 = string3 + "</div>";
        string3 = string3 + LS + "</div>";
        string3 = string3 + LS + "</body>";
        string3 = string3 + LS + "</html>";
        return string3;
    }

    protected SyndEntry buildSyndEntry(ExportEntry exportEntry, EstateImpl estateImpl, AgentImpl agentImpl, String string, Date date) {
        String string2;
        String string3;
        Date date2;
        SyndEntryImpl syndEntryImpl = new SyndEntryImpl();
        syndEntryImpl.setAuthor(agentImpl.getCompany().getCompanyName());
        syndEntryImpl.setUpdatedDate(date);
        if (string != null) {
            syndEntryImpl.setLink(string);
            syndEntryImpl.setUri(string);
        }
        if ((date2 = estateImpl.getPublishBegin()) != null) {
            syndEntryImpl.setPublishedDate(date2);
        }
        if ((string3 = StringUtils.trimToNull((String)estateImpl.getTitle(this.language))) == null) {
            string3 = estateImpl.getFallbackTitle(this.language);
        }
        string3 = (string2 = StringUtils.trimToNull((String)exportEntry.objectNr)) != null ? string2 + " \u00bb " + string3 : "#" + exportEntry.objectId + " \u00bb " + string3;
        syndEntryImpl.setTitle(string3);
        SyndContentImpl syndContentImpl = new SyndContentImpl();
        syndContentImpl.setType("text/plain");
        String string4 = StringUtils.trimToNull((String)ShortDescription.get((EstateImpl)estateImpl, (Locale)this.language));
        if (string4 == null) {
            string4 = StringUtils.trimToNull((String)DetailledDescription.get((EstateImpl)estateImpl, (Locale)this.language));
        }
        if (string4 == null) {
            string4 = string3;
        }
        syndContentImpl.setValue(string4);
        syndEntryImpl.setDescription((SyndContent)syndContentImpl);
        return syndEntryImpl;
    }

    private static String escapeText(String string) {
        return string != null ? StringEscapeUtils.escapeXml11((String)StringEscapeUtils.unescapeHtml4((String)string)) : null;
    }

    private static AgentContactImpl lookupContact(String string, TransferAgencyImpl transferAgencyImpl) {
        return (AgentContactImpl)transferAgencyImpl.getContacts().get(string);
    }

    private static EstateImpl lookupEstate(String string, TransferAgencyImpl transferAgencyImpl) {
        for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
            if (!estateImpl.getId().equals(string)) continue;
            return estateImpl;
        }
        return null;
    }

    private static void saveResource(String string, File file) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(WebsiteHtmlBuilder.class.getResourceAsStream(HTML_RESOURCE_PATH + string));){
            ImmoToolUtils.writeStreamToFile((InputStream)bufferedInputStream, (File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(TransferImpl transferImpl, ExportContext exportContext, DbAgencyExpose dbAgencyExpose) throws IOException {
        Serializable l;
        Object object;
        File throwable15;
        Object object2;
        EstateImpl i;
        File file2;
        AbstractExpose abstractExpose;
        TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
        LinkedHashMap<Long, String> linkedHashMap = new LinkedHashMap<Long, String>();
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        URI uRI = this.format.getHtmlBaseUrl();
        String string = StringUtils.trimToNull((String)(uRI != null ? uRI.toString() : null));
        if (string == null) {
            string = "";
        } else if (!string.endsWith("/")) {
            string = string + "/";
        }
        AbstractExpose abstractExpose2 = abstractExpose = dbAgencyExpose != null ? dbAgencyExpose.createExposeBuilder() : null;
        if (abstractExpose != null) {
            abstractExpose.setLocale(this.language);
            abstractExpose.setPublishAddress(this.format.getPropertyAddressPublication());
            abstractExpose.setPublishFiles(this.format.getPropertyFilePublication());
            abstractExpose.setPublishPrices(this.format.getPropertyPricePublication());
        }
        WebsiteHtmlBuilder.saveResource(WEBSITE_CSS, new File(exportContext.getWorkDir(), WEBSITE_CSS));
        if (this.format.isHtmlImageColorbox()) {
            file2 = new File(exportContext.getWorkDir(), "colorbox.zip");
            try {
                WebsiteHtmlBuilder.saveResource("colorbox.zip", file2);
                ImmoToolUtils.unzip((File)file2, (File)exportContext.getWorkDir());
            }
            finally {
                FileUtils.deleteQuietly((File)file2);
            }
        }
        file2 = null;
        if (this.format.isHtmlFeedAtom()) {
            file2 = new SyndFeedImpl();
            file2.setAuthor(exportContext.agent.getCompany().getCompanyName());
            file2.setCopyright(exportContext.agent.getCompany().getCompanyName());
            file2.setDescription(exportContext.agent.getCompany().getCompanyName());
            file2.setEncoding(ENCODING);
            file2.setFeedType("atom_1.0");
            file2.setPublishedDate(exportContext.stamp);
            file2.setTitle(this.format.getHtmlTitle());
            file2.setUri(string);
            file2.setLink(string + ATOM_XML);
            if (this.language != null) {
                file2.setLanguage(this.language.getLanguage());
            }
        }
        SyndFeedImpl syndFeedImpl = null;
        if (this.format.isHtmlFeedRss()) {
            syndFeedImpl = new SyndFeedImpl();
            syndFeedImpl.setAuthor(exportContext.agent.getCompany().getCompanyName());
            syndFeedImpl.setCopyright(exportContext.agent.getCompany().getCompanyName());
            syndFeedImpl.setDescription(exportContext.agent.getCompany().getCompanyName());
            syndFeedImpl.setEncoding(ENCODING);
            syndFeedImpl.setFeedType("rss_2.0");
            syndFeedImpl.setPublishedDate(exportContext.stamp);
            syndFeedImpl.setTitle(this.format.getHtmlTitle());
            syndFeedImpl.setUri(string);
            syndFeedImpl.setLink(string + ATOM_XML);
            if (this.language != null) {
                syndFeedImpl.setLanguage(this.language.getLanguage());
            }
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (ExportEntry serializable2 : exportContext.entries) {
            File throwable2;
            Object exception;
            Object object3;
            if (!DbAgencyExportAction.INSERT.equals((Object)serializable2.action) && !DbAgencyExportAction.UPDATE.equals((Object)serializable2.action)) continue;
            i = WebsiteHtmlBuilder.lookupEstate(serializable2.objectKey, transferAgencyImpl);
            if (i == null) {
                LOGGER.warn("Can't find estate '" + serializable2.objectKey + "' in transfer container!");
                continue;
            }
            hashMap.put(serializable2.objectKey, serializable2.objectId);
            object2 = StringUtils.trimToNull((String)i.getContactId());
            throwable15 = object2 != null ? WebsiteHtmlBuilder.lookupContact((String)object2, transferAgencyImpl) : null;
            object = new File(exportContext.getWorkDir(), EXPOSE_DIR);
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                throw new IOException("Can't create directory: " + ((File)object).getAbsolutePath());
            }
            l = new File((File)object, String.valueOf(serializable2.objectId));
            if (!((File)l).exists() && !((File)l).mkdirs()) {
                throw new IOException("Can't create directory: " + ((File)l).getAbsolutePath());
            }
            throwable2 = new File((File)l, INDEX_HTML);
            if (throwable2.exists() && !throwable2.delete()) {
                throw new IOException("Can't remove existing file: " + throwable2.getAbsolutePath());
            }
            String string2 = string + EXPOSE_DIR + "/" + serializable2.objectId + "/" + INDEX_HTML;
            String string3 = null;
            String string4 = null;
            if (abstractExpose != null) {
                object3 = new File((File)l, serializable2.objectId + ".pdf");
                try {
                    exception = new FileOutputStream((File)object3);
                    Throwable throwable3 = null;
                    try {
                        abstractExpose.generate(serializable2.objectId, immoToolProject, (OutputStream)exception);
                        string3 = "expose/" + serializable2.objectId + "/" + ((File)object3).getName();
                        string4 = ((File)object3).getName();
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (exception != null) {
                            if (throwable3 != null) {
                                try {
                                    ((FileOutputStream)exception).close();
                                }
                                catch (Throwable throwable22) {
                                    throwable3.addSuppressed(throwable22);
                                }
                            } else {
                                ((FileOutputStream)exception).close();
                            }
                        }
                    }
                }
                catch (Exception exception2) {
                    LOGGER.warn("Can't store expos\u00e9 for estate #" + serializable2.objectId + "!");
                    LOGGER.warn("> " + exception2.getLocalizedMessage(), (Throwable)exception2);
                }
            }
            object3 = new FileWriterWithEncoding(throwable2, ENCODING);
            exception = null;
            try {
                ((Writer)object3).write(this.buildExposePage(serializable2, i, exportContext.agent, (AgentContactImpl)throwable15, exportContext.getWorkDir(), string4, exportContext.stamp));
                ((Writer)object3).flush();
            }
            catch (Throwable throwable5) {
                exception = throwable5;
                throw throwable5;
            }
            finally {
                if (object3 != null) {
                    if (exception != null) {
                        try {
                            ((Writer)object3).close();
                        }
                        catch (Throwable throwable6) {
                            ((Throwable)exception).addSuppressed(throwable6);
                        }
                    } else {
                        ((Writer)object3).close();
                    }
                }
            }
            linkedHashMap.put(serializable2.objectId, this.buildIndexItem(serializable2, i, exportContext.getWorkDir(), string3));
            if (file2 == null && syndFeedImpl == null || (object3 = this.buildSyndEntry(serializable2, i, exportContext.agent, string2, exportContext.stamp)) == null) continue;
            if (file2 != null) {
                file2.getEntries().add(object3);
            }
            if (syndFeedImpl == null) continue;
            syndFeedImpl.getEntries().add(object3);
        }
        int n = linkedHashMap.size();
        if (n < 1) {
            File n2 = new File(exportContext.getWorkDir(), INDEX_HTML);
            if (n2.exists() && !n2.delete()) {
                throw new IOException("Can't remove existing file: " + n2.getAbsolutePath());
            }
            i = new FileWriterWithEncoding(n2, ENCODING);
            object2 = null;
            try {
                i.write(this.buildIndexPage(linkedHashMap, exportContext.agent, 0, 0, 10, exportContext.stamp));
                i.flush();
            }
            catch (Throwable throwable7) {
                object2 = throwable7;
                throw throwable7;
            }
            finally {
                if (i != null) {
                    if (object2 != null) {
                        try {
                            i.close();
                        }
                        catch (Throwable throwable8) {
                            ((Throwable)object2).addSuppressed(throwable8);
                        }
                    } else {
                        i.close();
                    }
                }
            }
        } else {
            int file4 = (int)Math.ceil((double)n / 10.0);
            for (int fileWriterWithEncoding = 0; fileWriterWithEncoding < file4; ++fileWriterWithEncoding) {
                object2 = fileWriterWithEncoding == 0 ? INDEX_HTML : FilenameUtils.getBaseName((String)INDEX_HTML) + "_" + (fileWriterWithEncoding + 1) + "." + FilenameUtils.getExtension((String)INDEX_HTML);
                throwable15 = new File(exportContext.getWorkDir(), (String)object2);
                if (throwable15.exists() && !throwable15.delete()) {
                    throw new IOException("Can't remove existing file: " + throwable15.getAbsolutePath());
                }
                object = new FileWriterWithEncoding(throwable15, ENCODING);
                l = null;
                try {
                    ((Writer)object).write(this.buildIndexPage(linkedHashMap, exportContext.agent, fileWriterWithEncoding + 1, file4, 10, exportContext.stamp));
                    ((Writer)object).flush();
                    continue;
                }
                catch (Throwable throwable9) {
                    l = throwable9;
                    throw throwable9;
                }
                finally {
                    if (object != null) {
                        if (l != null) {
                            try {
                                ((Writer)object).close();
                            }
                            catch (Throwable throwable10) {
                                ((Throwable)l).addSuppressed(throwable10);
                            }
                        } else {
                            ((Writer)object).close();
                        }
                    }
                }
            }
        }
        if (file2 != null) {
            File file5 = new File(exportContext.getWorkDir(), ATOM_XML);
            try {
                FileWriterWithEncoding exception = new FileWriterWithEncoding(file5, ENCODING);
                object2 = null;
                try {
                    throwable15 = new SyndFeedOutput();
                    throwable15.output((SyndFeed)file2, (Writer)exception);
                }
                catch (Throwable throwable11) {
                    object2 = throwable11;
                    throw throwable11;
                }
                finally {
                    if (exception != null) {
                        if (object2 != null) {
                            try {
                                exception.close();
                            }
                            catch (Throwable throwable12) {
                                ((Throwable)object2).addSuppressed(throwable12);
                            }
                        } else {
                            exception.close();
                        }
                    }
                }
            }
            catch (Exception fileWriterWithEncoding) {
                throw new IOException("Can't save atom feed!", fileWriterWithEncoding);
            }
        }
        if (syndFeedImpl != null) {
            File trovitWriter = new File(exportContext.getWorkDir(), RSS_XML);
            try {
                FileWriterWithEncoding exception = new FileWriterWithEncoding(trovitWriter, ENCODING);
                object2 = null;
                try {
                    throwable15 = new SyndFeedOutput();
                    throwable15.output((SyndFeed)syndFeedImpl, (Writer)exception);
                }
                catch (Throwable throwable13) {
                    object2 = throwable13;
                    throw throwable13;
                }
                finally {
                    if (exception != null) {
                        if (object2 != null) {
                            try {
                                exception.close();
                            }
                            catch (Throwable throwable14) {
                                ((Throwable)object2).addSuppressed(throwable14);
                            }
                        } else {
                            exception.close();
                        }
                    }
                }
            }
            catch (Exception trovit) {
                throw new IOException("Can't save rss feed!", trovit);
            }
        }
        if (this.format.isHtmlFeedTrovit()) {
            try {
                TrovitUtils.initContext((ClassLoader)WebsiteHtmlBuilder.class.getClassLoader());
                TrovitWriter exception = new TrovitWriter(this.language);
                exception.setBaseUrl(string);
                Trovit root = (Trovit)exception.writeToObject(transferImpl);
                for (File throwable15 : root.getAd()) {
                    object = throwable15.getId();
                    if (!hashMap.containsKey(object)) continue;
                    long l2 = (Long)hashMap.get(object);
                    throwable15.setUrl(new URI(string + EXPOSE_DIR + "/" + l2 + "/" + INDEX_HTML));
                }
                object2 = new File(exportContext.getWorkDir(), TROVIT_XML);
                TrovitDocument.newDocument((Trovit)root).toXml((File)object2);
            }
            catch (Exception writer) {
                throw new IOException("Can't save trovit feed!", writer);
            }
        }
        if (this.format.isHtmlFeedKyero()) {
            try {
                KyeroUtils.initContext((ClassLoader)WebsiteHtmlBuilder.class.getClassLoader());
                KyeroXmlFormat.Writer exception = new KyeroXmlFormat.Writer(this.language);
                exception.setBaseUrl(string);
                Root feed = (Root)exception.writeToObject(transferImpl);
                for (File throwable15 : feed.getProperty()) {
                    object = throwable15.getId();
                    if (!hashMap.containsKey(object)) continue;
                    long l3 = (Long)hashMap.get(object);
                    throwable15.setUrl(KyeroUtils.getFactory().createUrlType());
                    throwable15.getUrl().setDe(new URI(string + EXPOSE_DIR + "/" + l3 + "/" + INDEX_HTML));
                    throwable15.getUrl().setEn(new URI(string + EXPOSE_DIR + "/" + l3 + "/" + INDEX_HTML));
                }
                object2 = new File(exportContext.getWorkDir(), KYERO_XML);
                KyeroDocument.newDocument((Root)feed).toXml((File)object2);
            }
            catch (Exception writer) {
                throw new IOException("Can't save kyero feed!", writer);
            }
        }
        if (this.format.isHtmlFeedImmobiliare()) {
            try {
                ImmobiliareItUtils.initContext((ClassLoader)WebsiteHtmlBuilder.class.getClassLoader());
                ImmobiliareXmlFormat.Writer exception = new ImmobiliareXmlFormat.Writer(this.language, exportContext.dbDriver, exportContext.dbExtension);
                exception.setBaseUrl(string);
                Feed feed = exception.writeToObject(transferImpl);
                object2 = new File(exportContext.getWorkDir(), IMMOBILIARE_XML);
                ImmobiliareItDocument.newDocument((Feed)feed).toXml((File)object2);
            }
            catch (Exception exception) {
                throw new IOException("Can't save kyero feed!", exception);
            }
        }
    }

    private static String writeText(String string) {
        String string2 = "https?://(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,4})?((/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)?";
        Pattern pattern = Pattern.compile(string2, 2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string3 = string.substring(matcher.start(), matcher.end());
            matcher.appendReplacement(stringBuffer, "<a href=\"" + string3 + "\" target=\"_blank\">" + string3 + "</a>");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().replaceAll("\\n", "<br/>");
    }
}

