/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.agency.export.SftpTransport;
import com.openindex.openestate.tool.agency.export.WebsiteExportFilter;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlBuilder;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlFormatPanel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebsiteHtmlFormat
extends AbstractFormat {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteHtmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(WebsiteHtmlFormat.class);
    private static final String NAME = "website_html";
    private static final String STAMP = "immotool.stamp";
    private static final String HTML_BASE_URL = "website_html.baseUrl";
    private static final String HTML_FEED_ATOM = "website_html.feed.atom";
    private static final String HTML_FEED_IMMOBILIARE = "website_html.feed.immobiliare";
    private static final String HTML_FEED_KYERO = "website_html.feed.kyero";
    private static final String HTML_FEED_RSS = "website_html.feed.rss";
    private static final String HTML_FEED_TROVIT = "website_html.feed.trovit";
    private static final String HTML_IMAGE_COLORBOX = "website_html.image.colorbox";
    private static final String HTML_MAP_TYPE = "website_html.map";
    private static final String HTML_SHOW_AGENT = "website_html.show.agent";
    private static final String HTML_SHOW_CONTACT = "website_html.show.contact";
    private static final String HTML_SHOW_TERMS = "website_html.show.terms";
    private static final String HTML_STYLESHEET = "website_html.stylesheet";
    private static final String HTML_TITLE = "website_html.title";
    @Deprecated
    private static final String HTML_FILTER = "website_html.filter";

    @Override
    public AbstractTransportRequest[] createExportRequests(AbstractTransport abstractTransport, File file, AbstractFormat.TransferMode transferMode) {
        if (abstractTransport instanceof FtpTransport) {
            return new AbstractTransportRequest[]{new FtpTransport.Request((FtpTransport)abstractTransport, file, STAMP)};
        }
        if (abstractTransport instanceof SftpTransport) {
            return new AbstractTransportRequest[]{new SftpTransport.Request((SftpTransport)abstractTransport, file, STAMP)};
        }
        return super.createExportRequests(abstractTransport, file, transferMode);
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new WebsiteHtmlFormatPanel();
    }

    @Override
    protected File getAttachmentDirectory(long l, EstateAttachmentImpl estateAttachmentImpl, File file) {
        return new File(file, "expose" + File.separator + l);
    }

    public URI getHtmlBaseUrl() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_BASE_URL)));
        try {
            return string != null ? new URI(string) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read url: " + string);
            return null;
        }
    }

    @Deprecated
    public WebsiteExportFilter[] getHtmlFilters() {
        ArrayList<WebsiteExportFilter> arrayList = new ArrayList<WebsiteExportFilter>();
        for (Map.Entry entry : this.entrySet()) {
            String string = (String)entry.getKey();
            if (!string.startsWith("website_html.filter.")) continue;
            String[] stringArray = ((String)entry.getValue()).split(",");
            String string2 = !StringUtils.isBlank((CharSequence)stringArray[0]) ? stringArray[0].trim() : null;
            String string3 = stringArray.length > 1 && !StringUtils.isBlank((CharSequence)stringArray[1]) ? stringArray[1].trim() : null;
            arrayList.add(new WebsiteExportFilter(OpenEstateUtils.lookupAction((String)string2), OpenEstateUtils.lookupEstate((String)string3)));
        }
        return arrayList.toArray(new WebsiteExportFilter[0]);
    }

    public MapType getHtmlMapType() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_MAP_TYPE)));
        try {
            return string != null ? MapType.valueOf(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read map type: " + string);
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public String getHtmlStylesheet() {
        return StringUtils.trimToNull((String)((String)this.get(HTML_STYLESHEET)));
    }

    public String getHtmlTitle() {
        return StringUtils.trimToNull((String)((String)this.get(HTML_TITLE)));
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static Locale[] getSupportedLocales() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>(Arrays.asList(AgencyPlugin.getLocalesWithLanguagePack()));
        for (String string : new String[]{"bg", "es", "it", "ru"}) {
            boolean bl = false;
            for (Locale locale : arrayList) {
                if (!string.equalsIgnoreCase(locale.getLanguage())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(new Locale(string));
        }
        return arrayList.toArray(new Locale[0]);
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL};
    }

    @Override
    public AbstractTransport[] getSupportedTransports() {
        return new AbstractTransport[]{new FtpTransport(), new SftpTransport(), new LocalTransport()};
    }

    @Override
    public String getTitle() {
        return "Website: HTML-Export";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setHtmlShowAgent(true);
        this.setHtmlShowContact(true);
        this.setHtmlShowTerms(true);
        this.setHtmlFeedAtom(false);
        this.setHtmlFeedImmobiliare(false);
        this.setHtmlFeedKyero(false);
        this.setHtmlFeedRss(false);
        this.setHtmlFeedTrovit(false);
        this.setHtmlImageColorbox(true);
        this.setLanguages(new Locale[]{Locale.getDefault()});
    }

    @Override
    public boolean isFullTransportWarningShown() {
        return false;
    }

    public boolean isHtmlFeedAtom() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_FEED_ATOM)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHtmlFeedImmobiliare() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_FEED_IMMOBILIARE)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHtmlFeedKyero() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_FEED_KYERO)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHtmlFeedRss() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_FEED_RSS)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHtmlFeedTrovit() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_FEED_TROVIT)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHtmlImageColorbox() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_IMAGE_COLORBOX)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHtmlShowAgent() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_SHOW_AGENT)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHtmlShowContact() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_SHOW_CONTACT)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHtmlShowTerms() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTML_SHOW_TERMS)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public void setHtmlBaseUrl(URI uRI) {
        if (uRI == null) {
            this.remove(HTML_BASE_URL);
        } else {
            this.put(HTML_BASE_URL, uRI.toString());
        }
    }

    public void setHtmlFeedAtom(boolean bl) {
        this.put(HTML_FEED_ATOM, String.valueOf(bl));
    }

    public void setHtmlFeedImmobiliare(boolean bl) {
        this.put(HTML_FEED_IMMOBILIARE, String.valueOf(bl));
    }

    public void setHtmlFeedKyero(boolean bl) {
        this.put(HTML_FEED_KYERO, String.valueOf(bl));
    }

    public void setHtmlFeedRss(boolean bl) {
        this.put(HTML_FEED_RSS, String.valueOf(bl));
    }

    public void setHtmlFeedTrovit(boolean bl) {
        this.put(HTML_FEED_TROVIT, String.valueOf(bl));
    }

    @Deprecated
    public void setHtmlFilters(WebsiteExportFilter[] websiteExportFilterArray) {
        String string = "website_html.filter.";
        for (String string2 : this.keySet().toArray(new String[0])) {
            if (!string2.startsWith(string)) continue;
            this.remove(string2);
        }
        for (int i = 0; i < websiteExportFilterArray.length; ++i) {
            String string3 = "";
            if (websiteExportFilterArray[i].getAction() != null) {
                string3 = string3 + websiteExportFilterArray[i].getAction().name();
            }
            string3 = string3 + ",";
            if (websiteExportFilterArray[i].getType() != null) {
                string3 = string3 + websiteExportFilterArray[i].getType().name();
            }
            this.put(string + i, string3);
        }
    }

    public void setHtmlImageColorbox(boolean bl) {
        this.put(HTML_IMAGE_COLORBOX, String.valueOf(bl));
    }

    public void setHtmlMapType(MapType mapType) {
        if (mapType == null) {
            this.remove(HTML_MAP_TYPE);
        } else {
            this.put(HTML_MAP_TYPE, mapType.name());
        }
    }

    public void setHtmlShowAgent(boolean bl) {
        this.put(HTML_SHOW_AGENT, String.valueOf(bl));
    }

    public void setHtmlShowContact(boolean bl) {
        this.put(HTML_SHOW_CONTACT, String.valueOf(bl));
    }

    public void setHtmlShowTerms(boolean bl) {
        this.put(HTML_SHOW_TERMS, String.valueOf(bl));
    }

    public void setHtmlStylesheet(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(HTML_STYLESHEET);
        } else {
            this.put(HTML_STYLESHEET, string);
        }
    }

    public void setHtmlTitle(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(HTML_TITLE);
        } else {
            this.put(HTML_TITLE, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File writeToDisk(File file, TransferImpl transferImpl, ExportContext exportContext) throws IOException, SQLException {
        Object object;
        DbAgencyExpose dbAgencyExpose = null;
        long l = exportContext.export.exposeId;
        if (l > 0L) {
            object = exportContext.dbExtension.getExposeHandler();
            Connection connection = null;
            try {
                connection = exportContext.dbDriver.getConnection();
                dbAgencyExpose = object.getExpose(connection, l);
                object.loadExposeSettings(connection, dbAgencyExpose);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
        object = new WebsiteHtmlBuilder(this);
        ((WebsiteHtmlBuilder)object).write(transferImpl, exportContext, dbAgencyExpose);
        return exportContext.getWorkDir();
    }

    public static enum MapType {
        OSM("openstreetmap.org", "OpenStreetMap"),
        GOOGLE("maps.google.com", "Google Maps");

        private final String name;
        private final String title;

        private MapType(String string2, String string3) {
            this.name = string2;
            this.title = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

