/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.condition.Age;
import com.openindex.openestate.impl.attribs.features.Equipment;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.export.AbstractPhpBuilder;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.WebsitePhp1Format;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebsitePhp1Builder
extends AbstractPhpBuilder<WebsitePhp1Format> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitePhp1Builder.class);
    private static final I18n I18N = I18nFactory.getI18n(WebsitePhp1Builder.class);
    private static final String PHP_RESOURCE_PATH = "/com/openindex/openestate/tool/agency/export/resources/php1/";
    private static final String ENCODING = "UTF-8";
    public static final String CACHE_DIR = "cache";
    public static final String SESSIONS_DIR = "sessions";
    public static final String DATA_DIR = "data";
    public static final String IMG_DIR = "img";
    public static final String TEMPLATES_DIR = "templates";
    public static final String CONFIG_PHP = "config.php";
    public static final String CONFIG_DEFAULT_PHP = "config_default.php";
    public static final String MYCONFIG_PHP = "myconfig.php";
    public static final String MYCONFIG_DEFAULT_PHP = "myconfig_default.php";
    public static final String PRIVATE_PHP = "private.php";
    public static final String LANGUAGE_PHP = "language.php";
    public static final String TERMS_PHP = "terms.php";
    public static final String OBJECT_PHP = "object.php";
    public static final String TEXTS_PHP = "texts.php";

    public WebsitePhp1Builder(WebsitePhp1Format websitePhp1Format) {
        super(websitePhp1Format, ENCODING, PHP_RESOURCE_PATH);
    }

    protected String buildConfigPhp(AgentImpl agentImpl, File file) throws IOException {
        WebsitePhp1Format websitePhp1Format = (WebsitePhp1Format)this.getFormat();
        String string = websitePhp1Format.getPhpStylesheet();
        Locale locale = (Locale)ObjectUtils.defaultIfNull((Object)websitePhp1Format.getLanguage(), (Object)Locale.getDefault());
        String string2 = FileUtils.readFileToString((File)file, (String)ENCODING);
        string2 = this.replaceVariable(string2, "$DefaultLanguage", locale.getLanguage());
        string2 = this.replaceVariable(string2, "$AdditionalStylesheet", StringUtils.trimToEmpty((String)string));
        string2 = this.replaceVariable(string2, "$Timezone", TimeZone.getDefault().getID());
        string2 = this.replaceVariable(string2, "$MailFrom", agentImpl.getCompany().getCompanyMail());
        string2 = this.replaceVariable(string2, "$MailFromName", agentImpl.getCompany().getCompanyName());
        string2 = this.replaceVariable(string2, "$ShowTerms", websitePhp1Format.isPhpShowTerms());
        string2 = this.replaceVariable(string2, "$ShowContactPerson", websitePhp1Format.isPhpShowContactPerson());
        string2 = this.replaceVariable(string2, "$ShowContactForm", websitePhp1Format.isPhpShowContactForm());
        string2 = this.replaceVariable(string2, "$PublishAtomFeed", websitePhp1Format.isPhpFeedAtom());
        string2 = this.replaceVariable(string2, "$PublishRssFeed", websitePhp1Format.isPhpFeedRss());
        string2 = this.replaceVariable(string2, "$PublishTrovitFeed", websitePhp1Format.isPhpFeedTrovit());
        return string2;
    }

    protected String buildPrivatePhp() throws IOException {
        String string = ImmoToolUtils.getRandomAlphaNumericString((int)100);
        return this.readResource("private.php.txt").replace("//define('IMMOTOOL_CRYPT_KEY', '');", "define('IMMOTOOL_CRYPT_KEY', '" + string + "');");
    }

    @Override
    protected void initTranslationPhpValues(Map<String, String> map, Locale locale) {
        super.initTranslationPhpValues(map, locale);
        I18n i18n = I18nFactory.getI18n(AbstractPhpBuilder.class, (Locale)locale);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.writeArrayLine("title", ((WebsitePhp1Format)this.getFormat()).getPhpTitle(), 4));
        stringBuilder.append(this.writeArrayLine("title.index", StringUtils.capitalize((String)i18n.tr("summary")), 4));
        stringBuilder.append(this.writeArrayLine("title.fav", StringUtils.capitalize((String)i18n.tr("favorites")), 4));
        stringBuilder.append(this.writeArrayLine("tab.index", StringUtils.capitalize((String)i18n.tr("summary")), 4));
        stringBuilder.append(this.writeArrayLine("tab.fav", StringUtils.capitalize((String)i18n.tr("favorites")), 4));
        stringBuilder.append(this.writeArrayLine("estate", StringUtils.capitalize((String)i18n.tr("expos\u00e9")), 4));
        stringBuilder.append(this.writeArrayLine("estate.id", StringUtils.capitalize((String)i18n.tr("property ID")), 4));
        stringBuilder.append(this.writeArrayLine("estate.nr", StringUtils.capitalize((String)i18n.tr("property nr")), 4));
        stringBuilder.append(this.writeArrayLine("estate.type", StringUtils.capitalize((String)i18n.tr("property type")), 4));
        stringBuilder.append(this.writeArrayLine("estate.action", StringUtils.capitalize((String)i18n.tr("marketing type")), 4));
        stringBuilder.append(this.writeArrayLine("estate.group", StringUtils.capitalize((String)i18n.tr("group nr")), 4));
        stringBuilder.append(this.writeArrayLine("estate.area", StringUtils.capitalize((String)i18n.tr("area")), 4));
        stringBuilder.append(this.writeArrayLine("estate.country", StringUtils.capitalize((String)i18n.tr("country")), 4));
        stringBuilder.append(this.writeArrayLine("estate.city", StringUtils.capitalize((String)i18n.tr("place")), 4));
        stringBuilder.append(this.writeArrayLine("estate.postal", StringUtils.capitalize((String)i18n.tr("postcode")), 4));
        stringBuilder.append(this.writeArrayLine("estate.price", StringUtils.capitalize((String)i18n.tr("price")), 4));
        stringBuilder.append(this.writeArrayLine("estate.rooms", StringUtils.capitalize((String)OpenEstateAttrib.MEASURES_COUNT_ROOMS.getTranslation()), 4));
        stringBuilder.append(this.writeArrayLine("estate.title", StringUtils.capitalize((String)i18n.tr("title")), 4));
        stringBuilder.append(this.writeArrayLine("estate.address", StringUtils.capitalize((String)i18n.tr("address")), 4));
        stringBuilder.append(this.writeArrayLine("estate.region", StringUtils.capitalize((String)i18n.tr("region")), 4));
        stringBuilder.append(this.writeArrayLine("estate.details", StringUtils.capitalize((String)i18n.tr("details")), 4));
        stringBuilder.append(this.writeArrayLine("estate.details.title", StringUtils.capitalize((String)i18n.tr("details about the property")), 4));
        stringBuilder.append(this.writeArrayLine("estate.texts", StringUtils.capitalize((String)i18n.tr("description")), 4));
        stringBuilder.append(this.writeArrayLine("estate.texts.title", StringUtils.capitalize((String)i18n.tr("descriptions about the property")), 4));
        stringBuilder.append(this.writeArrayLine("estate.texts.empty", i18n.tr("No descriptions are available for the selected language."), 4));
        stringBuilder.append(this.writeArrayLine("estate.gallery", StringUtils.capitalize((String)i18n.tr("gallery")), 4));
        stringBuilder.append(this.writeArrayLine("estate.gallery.title", StringUtils.capitalize((String)i18n.tr("pictures of the property")), 4));
        stringBuilder.append(this.writeArrayLine("estate.map", StringUtils.capitalize((String)i18n.tr("map")), 4));
        stringBuilder.append(this.writeArrayLine("estate.map.title", StringUtils.capitalize((String)i18n.tr("map")), 4));
        stringBuilder.append(this.writeArrayLine("estate.map.directLink", i18n.tr("enlarge map"), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact", StringUtils.capitalize((String)i18n.tr("contact")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.title", StringUtils.capitalize((String)i18n.tr("contact")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.person", StringUtils.capitalize((String)i18n.tr("your contact person")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.person.name", StringUtils.capitalize((String)i18n.tr("name")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.person.address", StringUtils.capitalize((String)i18n.tr("address")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.person.phone", StringUtils.capitalize((String)i18n.tr("phone")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.person.mobile", StringUtils.capitalize((String)i18n.tr("mobile")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.person.fax", StringUtils.capitalize((String)i18n.tr("fax")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form", StringUtils.capitalize((String)i18n.tr("send message via e-mail")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.name", StringUtils.capitalize((String)i18n.tr("name")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.firstname", StringUtils.capitalize((String)i18n.tr("first name")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.email", StringUtils.capitalize((String)i18n.tr("e-mail")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.phone", StringUtils.capitalize((String)i18n.tr("phone")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.street", StringUtils.capitalize((String)i18n.tr("street")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.streetnr", StringUtils.capitalize((String)i18n.tr("nr")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.postal", StringUtils.capitalize((String)i18n.tr("postcode")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.city", StringUtils.capitalize((String)i18n.tr("place")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.message", StringUtils.capitalize((String)i18n.tr("message")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.captcha", StringUtils.capitalize((String)i18n.tr("confirmation")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.captcha.refresh", StringUtils.capitalize((String)i18n.tr("refresh")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.terms", i18n.tr("Yes, I accept the following disclaimer."), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.submit", StringUtils.capitalize((String)i18n.tr("send message")), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.submitted", i18n.tr("The message was sent successfully!"), 4));
        stringBuilder.append(this.writeArrayLine("estate.contact.form.submitted.message", i18n.tr("Thank you for your request. We will be in touch shortly."), 4));
        stringBuilder.append(this.writeArrayLine("estate.terms", StringUtils.capitalize((String)i18n.tr("terms")), 4));
        stringBuilder.append(this.writeArrayLine("estate.terms.title", StringUtils.capitalize((String)i18n.tr("terms & conditions")), 4));
        stringBuilder.append(this.writeArrayLine("estate.terms.empty", i18n.tr("No terms are available. Please contact the agent for further information."), 4));
        stringBuilder.append(this.writeArrayLine("estate.media", StringUtils.capitalize((String)i18n.tr("media")), 4));
        stringBuilder.append(this.writeArrayLine("estate.media.title", StringUtils.capitalize((String)i18n.tr("media of the property")), 4));
        stringBuilder.append(this.writeArrayLine("estate.media.downloads", StringUtils.capitalize((String)i18n.tr("downloads")), 4));
        stringBuilder.append(this.writeArrayLine("estate.media.links", StringUtils.capitalize((String)i18n.tr("links")), 4));
        stringBuilder.append(this.writeArrayLine("estate.media.videos", StringUtils.capitalize((String)i18n.tr("videos")), 4));
        stringBuilder.append(this.writeArrayLine("estate.media.empty", i18n.tr("No medias are available for the property."), 4));
        stringBuilder.append(this.writeArrayLine("lastModification", i18n.tr("last modification"), 4));
        stringBuilder.append(this.writeArrayLine("order.asc", i18n.tr("ascending"), 4));
        stringBuilder.append(this.writeArrayLine("order.desc", i18n.tr("descending"), 4));
        stringBuilder.append(this.writeArrayLine("link.expose.view", StringUtils.capitalize((String)i18n.tr("details")), 4));
        stringBuilder.append(this.writeArrayLine("link.expose.pdf", StringUtils.capitalize((String)i18n.tr("download")), 4));
        stringBuilder.append(this.writeArrayLine("link.expose.fav", StringUtils.capitalize((String)i18n.tr("add to favorites")), 4));
        stringBuilder.append(this.writeArrayLine("link.expose.unfav", StringUtils.capitalize((String)i18n.tr("remove favorite")), 4));
        stringBuilder.append(this.writeArrayLine("link.expose.contact", StringUtils.capitalize((String)i18n.tr("contact us")), 4));
        stringBuilder.append(this.writeArrayLine("link.expose.videos", StringUtils.capitalize((String)i18n.tr("videos")), 4));
        stringBuilder.append(this.writeArrayLine("view.gallery", i18n.tr("gallery view"), 4));
        stringBuilder.append(this.writeArrayLine("view.table", i18n.tr("table view"), 4));
        stringBuilder.append(this.writeArrayLine("action.search", i18n.tr("execute search"), 4));
        stringBuilder.append(this.writeArrayLine("action.reset", i18n.tr("reset input"), 4));
        stringBuilder.append(this.writeArrayLine("action.clearFavs", i18n.tr("delete favorites"), 4));
        stringBuilder.append(this.writeArrayLine("action.clearFavs.question", i18n.tr("Do you really want to delete all of your favorites?"), 4));
        stringBuilder.append(this.writeArrayLine("fromNowOn", OpenEstateConstant.FROM_NOW_ON.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.equipment", OpenEstateAttrib.FEATURES_EQUIPMENT.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.equipment.basic", Equipment.Option.BASIC.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.equipment.exclusive", Equipment.Option.EXCLUSIVE.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.equipment.luxury", Equipment.Option.LUXURY.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.equipment.standard", Equipment.Option.STANDARD.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.furnished", OpenEstateAttrib.FEATURES_FURNISHED.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.count_rooms", OpenEstateAttrib.MEASURES_COUNT_ROOMS.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.age", OpenEstateAttrib.CONDITION_AGE.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.age.new_building", Age.Option.NEW_BUILDING.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.age.old_building", Age.Option.OLD_BUILDING.getTranslation(locale), 4));
        stringBuilder.append(this.writeArrayLine("openestate.special_offer", OpenEstateAttrib.PRICES_SPECIAL_OFFER.getTranslation(locale), 4));
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(this.writeArrayLine("warning", i18n.tr("Warning!"), 4));
        stringBuilder2.append(this.writeArrayLine("anErrorOccured", i18n.tr("An error occurred!"), 4));
        stringBuilder2.append(this.writeArrayLine("noEstatesFound", i18n.tr("No properties were found!"), 4));
        stringBuilder2.append(this.writeArrayLine("cantLoadEstate", i18n.tr("The requested property was not found!"), 4));
        stringBuilder2.append(this.writeArrayLine("cantSendMail", i18n.tr("An error occurred during e-mail transmission!"), 4));
        stringBuilder2.append(this.writeArrayLine("cantSendMail.invalidInput", i18n.tr("The provided information is incomplete. Please correct the highlighted fields."), 4));
        stringBuilder2.append(this.writeArrayLine("cantSendMail.invalidRequest", i18n.tr("The contact request is invalid. Please try to submit the contact form again."), 4));
        stringBuilder2.append(this.writeArrayLine("cantSendMail.templateNotFound", i18n.tr("Can't find an e-mail template!"), 4));
        stringBuilder2.append(this.writeArrayLine("cantSendMail.mailWasNotSend", i18n.tr("Can't send e-mail. Please try again later. If the problem occurs again, please use a different way of contact (e.g. phone)."), 4));
        map.put("I18N_LABELS", ImmoToolUtils.trimRight((String)stringBuilder.toString()));
        map.put("I18N_ERRORS", ImmoToolUtils.trimRight((String)stringBuilder2.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TransferImpl transferImpl, ExportContext exportContext, DbAgencyExpose dbAgencyExpose) throws IOException, SQLException {
        Object object;
        Object object2;
        ImageIcon imageIcon;
        WebsitePhp1Format websitePhp1Format = (WebsitePhp1Format)this.getFormat();
        TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
        File file = new File(exportContext.getWorkDir(), CACHE_DIR);
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Can't create directory: " + file.getAbsolutePath());
        }
        this.writeIndexHtml(file);
        this.writeHtaccess(file);
        File file2 = new File(exportContext.getWorkDir(), SESSIONS_DIR);
        if (!file2.exists() && !file2.mkdir()) {
            throw new IOException("Can't create directory: " + file2.getAbsolutePath());
        }
        this.writeIndexHtml(file2);
        this.writeHtaccess(file2);
        File file3 = new File(exportContext.getWorkDir(), DATA_DIR);
        if (!file3.exists() && !file3.mkdir()) {
            throw new IOException("Can't create directory: " + file3.getAbsolutePath());
        }
        this.writeIndexHtml(file3);
        File file4 = new File(exportContext.getWorkDir(), IMG_DIR);
        if (!file4.exists() && !file4.mkdir()) {
            throw new IOException("Can't create directory: " + file4.getAbsolutePath());
        }
        this.writeIndexHtml(file4);
        String string = StringUtils.trimToNull((String)websitePhp1Format.getPropertyPrefix());
        String string2 = string != null ? string + "-" : "";
        this.saveText(this.buildLanguagePhp(), new File(file3, LANGUAGE_PHP));
        this.saveText(this.buildTermsPhp(exportContext.agent), new File(file3, TERMS_PHP));
        for (Locale serializable : websitePhp1Format.getLanguages()) {
            imageIcon = ImmoToolUtils.getCountryFlagIcon((Locale)serializable);
            if (imageIcon == null || imageIcon.getImage() == null) continue;
            object2 = ImageUtils.toBufferedImage((Image)imageIcon.getImage(), (int)2);
            ImageUtils.writePng((BufferedImage)object2, (File)new File(file4, serializable.getLanguage() + ".png"));
            object2.flush();
        }
        if (websitePhp1Format.isPhpSaveScripts()) {
            File file5;
            this.extractScripts(exportContext.getWorkDir());
            FileUtils.moveFile((File)new File(exportContext.getWorkDir(), CONFIG_PHP), (File)new File(exportContext.getWorkDir(), CONFIG_DEFAULT_PHP));
            FileUtils.copyFile((File)new File(exportContext.getWorkDir(), MYCONFIG_PHP), (File)new File(exportContext.getWorkDir(), MYCONFIG_DEFAULT_PHP));
            this.saveText(this.buildConfigPhp(exportContext.agent, new File(exportContext.getWorkDir(), CONFIG_DEFAULT_PHP)), new File(exportContext.getWorkDir(), CONFIG_PHP));
            object = new File(exportContext.getWorkDir(), "include");
            if (((File)object).isDirectory()) {
                this.writeIndexHtml((File)object);
            }
            if ((file5 = new File(exportContext.getWorkDir(), TEMPLATES_DIR)).isDirectory()) {
                this.writeIndexHtml(file5);
                this.writeHtaccess(file5);
            }
        }
        this.saveText(this.buildPrivatePhp(), new File(exportContext.getWorkDir(), PRIVATE_PHP));
        this.saveResource("LICENSE.txt", new File(exportContext.getWorkDir(), "LICENSE.txt"));
        object = websitePhp1Format.getLanguages();
        int n = ((Locale[])object).length;
        for (int i = 0; i < n; ++i) {
            Locale locale = object[i];
            this.saveText(this.buildTranslationPhp(locale), new File(file3, "i18n_" + locale.getLanguage() + ".php"));
        }
        Object object3 = object = dbAgencyExpose != null ? dbAgencyExpose.createExposeBuilder() : null;
        if (object != null) {
            ((AbstractExpose)object).setPublishAddress(websitePhp1Format.getPropertyAddressPublication());
            ((AbstractExpose)object).setPublishFiles(websitePhp1Format.getPropertyFilePublication());
            ((AbstractExpose)object).setPublishPrices(websitePhp1Format.getPropertyPricePublication());
        }
        Connection connection = null;
        try {
            for (ExportEntry exportEntry : exportContext.entries) {
                if (!DbAgencyExportAction.INSERT.equals((Object)exportEntry.action) && !DbAgencyExportAction.UPDATE.equals((Object)exportEntry.action)) continue;
                imageIcon = this.lookupEstate(exportEntry.objectKey, transferAgencyImpl);
                if (imageIcon == null) {
                    LOGGER.warn("Can't find estate '" + exportEntry.objectKey + "' in transfer container!");
                    continue;
                }
                if (connection == null) {
                    connection = exportContext.dbDriver.getConnection();
                }
                object2 = (DbAgencyObject)exportContext.dbExtension.getObjectsHandler().getObject(connection, exportEntry.objectId);
                String string3 = string2 + exportEntry.objectId;
                File file5 = new File(file3, string3);
                if (!file5.exists() && !file5.mkdir()) {
                    throw new IOException("Can't create directory: " + file5.getAbsolutePath());
                }
                this.writeIndexHtml(file5);
                String string4 = StringUtils.trimToNull((String)imageIcon.getContactId());
                AgentContactImpl agentContactImpl = string4 != null ? this.lookupContact(string4, transferAgencyImpl) : null;
                this.saveText(this.buildObjectPhp((EstateImpl)imageIcon, string3, ((DbAgencyObject)((Object)object2)).status, exportContext.agent, agentContactImpl, ((DbAgencyObject)((Object)object2)).createdAt, ((DbAgencyObject)((Object)object2)).modifiedAt), new File(file5, OBJECT_PHP));
                this.saveText(this.buildObjectTextsPhp((EstateImpl)imageIcon, string3), new File(file5, TEXTS_PHP));
                if (object == null) continue;
                try {
                    this.buildObjectPdf((AbstractExpose)object, exportEntry, string3, file5, connection);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't store expos\u00e9 for estate #" + exportEntry.objectId + "!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }
}

