/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.export.AbstractPhpBuilder;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.WebsitePhp2Format;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebsitePhp2Builder
extends AbstractPhpBuilder<WebsitePhp2Format> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitePhp2Builder.class);
    private static final I18n I18N = I18nFactory.getI18n(WebsitePhp2Builder.class);
    private static final String PHP_RESOURCE_PATH = "/com/openindex/openestate/tool/agency/export/resources/php2/";
    private static final String ENCODING = "UTF-8";
    public static final String CACHE_DIR = "cache";
    public static final String DATA_DIR = "data";
    public static final String INCLUDE_DIR = "include";
    public static final String ASSETS_DIR = "assets";
    public static final String THEMES_DIR = "themes";
    public static final String LOCALE_DIR = "locale";
    public static final String LANGUAGE_PHP = "language.php";
    public static final String TERMS_PHP = "terms.php";
    public static final String OBJECT_PHP = "object.php";
    public static final String TEXTS_PHP = "texts.php";
    public static final String CONFIG_PHP = "config.php";
    public static final String CUSTOM_CSS = "custom.css";

    public WebsitePhp2Builder(WebsitePhp2Format websitePhp2Format) {
        super(websitePhp2Format, ENCODING, PHP_RESOURCE_PATH);
    }

    protected String buildConfigPhp(AgentImpl agentImpl, File file) throws IOException {
        WebsitePhp2Format websitePhp2Format = (WebsitePhp2Format)this.getFormat();
        Locale locale = (Locale)ObjectUtils.defaultIfNull((Object)websitePhp2Format.getLanguage(), (Object)Locale.getDefault());
        String string = (String)StringUtils.defaultIfBlank((CharSequence)websitePhp2Format.getPhpCompany(), (CharSequence)agentImpl.getCompany().getCompanyName());
        String string2 = FileUtils.readFileToString((File)file, (String)ENCODING);
        string2 = this.replaceVariable(string2, "$companyName", StringUtils.trimToEmpty((String)string));
        string2 = this.replaceVariable(string2, "$defaultLanguage", locale.getLanguage());
        string2 = this.replaceVariable(string2, "$atomFeed", websitePhp2Format.isPhpFeedAtom());
        string2 = this.replaceVariable(string2, "$rssFeed", websitePhp2Format.isPhpFeedRss());
        string2 = this.replaceVariable(string2, "$trovitFeed", websitePhp2Format.isPhpFeedTrovit());
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TransferImpl transferImpl, ExportContext exportContext, DbAgencyExpose dbAgencyExpose) throws IOException, SQLException {
        Object object;
        Object object2;
        WebsitePhp2Format websitePhp2Format = (WebsitePhp2Format)this.getFormat();
        TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
        File file = new File(exportContext.getWorkDir(), CACHE_DIR);
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Can't create directory: " + file.getAbsolutePath());
        }
        this.writeIndexHtml(file);
        this.writeHtaccess(file);
        File file2 = new File(exportContext.getWorkDir(), DATA_DIR);
        if (!file2.exists() && !file2.mkdir()) {
            throw new IOException("Can't create directory: " + file2.getAbsolutePath());
        }
        this.writeIndexHtml(file2);
        String string = StringUtils.trimToNull((String)websitePhp2Format.getPropertyPrefix());
        String string2 = string != null ? string + "-" : "";
        this.saveText(this.buildLanguagePhp(), new File(file2, LANGUAGE_PHP));
        this.saveText(this.buildTermsPhp(exportContext.agent), new File(file2, TERMS_PHP));
        if (websitePhp2Format.isPhpSaveScripts()) {
            File serializable2;
            this.extractScripts(exportContext.getWorkDir());
            object2 = new File(exportContext.getWorkDir(), INCLUDE_DIR);
            if (((File)object2).isDirectory()) {
                this.writeIndexHtml((File)object2);
                this.writeHtaccess((File)object2);
            }
            File file3 = new File(new File(new File((File)object2, "OpenEstate"), "PhpExport"), "Config.php");
            this.saveText(this.buildConfigPhp(exportContext.agent, file3), file3);
            File file4 = new File(exportContext.getWorkDir(), THEMES_DIR);
            if (file4.isDirectory()) {
                this.writeIndexHtml(file4);
            }
            if ((serializable2 = new File(exportContext.getWorkDir(), ASSETS_DIR)).isDirectory()) {
                this.writeIndexHtml(serializable2);
            }
            if (((File)(object = new File(exportContext.getWorkDir(), LOCALE_DIR))).isDirectory()) {
                this.writeIndexHtml((File)object);
            }
        }
        this.saveResource("LICENSE.txt", new File(exportContext.getWorkDir(), "LICENSE.txt"));
        object2 = websitePhp2Format.getLanguages();
        int n = ((Locale[])object2).length;
        for (int i = 0; i < n; ++i) {
            Locale locale = object2[i];
            this.saveText(this.buildTranslationPhp(locale), new File(file2, "i18n_" + locale.getLanguage() + ".php"));
        }
        Object object3 = object2 = dbAgencyExpose != null ? dbAgencyExpose.createExposeBuilder() : null;
        if (object2 != null) {
            ((AbstractExpose)object2).setPublishAddress(websitePhp2Format.getPropertyAddressPublication());
            ((AbstractExpose)object2).setPublishFiles(websitePhp2Format.getPropertyFilePublication());
            ((AbstractExpose)object2).setPublishPrices(websitePhp2Format.getPropertyPricePublication());
        }
        Connection connection = null;
        try {
            for (ExportEntry exportEntry : exportContext.entries) {
                if (!DbAgencyExportAction.INSERT.equals((Object)exportEntry.action) && !DbAgencyExportAction.UPDATE.equals((Object)exportEntry.action)) continue;
                object = this.lookupEstate(exportEntry.objectKey, transferAgencyImpl);
                if (object == null) {
                    LOGGER.warn("Can't find estate '" + exportEntry.objectKey + "' in transfer container!");
                    continue;
                }
                if (connection == null) {
                    connection = exportContext.dbDriver.getConnection();
                }
                DbAgencyObject dbAgencyObject = (DbAgencyObject)exportContext.dbExtension.getObjectsHandler().getObject(connection, exportEntry.objectId);
                String string3 = string2 + exportEntry.objectId;
                File file3 = new File(file2, string3);
                if (!file3.exists() && !file3.mkdir()) {
                    throw new IOException("Can't create directory: " + file3.getAbsolutePath());
                }
                this.writeIndexHtml(file3);
                String string4 = StringUtils.trimToNull((String)object.getContactId());
                AgentContactImpl agentContactImpl = string4 != null ? this.lookupContact(string4, transferAgencyImpl) : null;
                this.saveText(this.buildObjectPhp((EstateImpl)object, string3, dbAgencyObject.status, exportContext.agent, agentContactImpl, dbAgencyObject.createdAt, dbAgencyObject.modifiedAt), new File(file3, OBJECT_PHP));
                this.saveText(this.buildObjectTextsPhp((EstateImpl)object, string3), new File(file3, TEXTS_PHP));
                if (object2 == null) continue;
                try {
                    this.buildObjectPdf((AbstractExpose)object2, exportEntry, string3, file3, connection);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't store expos\u00e9 for estate #" + exportEntry.objectId + "!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }
}

