/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.openindex.openestate.tool.ImmoToolAgent;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractPdfExpose
extends AbstractExpose {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPdfExpose.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractPdfExpose.class);
    private static final String BODY_HEAD_BG_COLOR = "pdf.body.head.bgColor";
    private static final String BODY_HEAD_FG_COLOR = "pdf.body.head.fgColor";
    private static final String BODY_HEAD_NUMBERED = "pdf.body.head.numbered";
    private static final String BODY_TEXT_BG_COLOR = "pdf.body.text.bgColor";
    private static final String BODY_TEXT_FG_COLOR = "pdf.body.text.fgColor";
    private static final String BODY_TEXT_ALIGN = "pdf.body.text.align";
    private static final String BORDER_COLOR = "pdf.border.color";
    private static final String FOOTER = "pdf.footer";
    private static final String FOOTER_TEXT_ALIGN = "pdf.footer.text.align";
    private static final String FOOTER_TEXT_FG_COLOR = "pdf.footer.text.fgColor";
    private static final String FOOTER_TIMESTAMP = "pdf.footer.timestamp";
    private static final String FOOTER_PAGE_NUMBER = "pdf.footer.pageNumber";
    private static final String FOOTER_WEBSITE = "pdf.footer.website";
    private static final String HEADER = "pdf.header";
    private static final String HEADER_LOGO = "pdf.header.logo";
    private static final String HEADER_TEXT_CUSTOM = "pdf.header.text.custom";
    private static final String HEADER_TEXT_CUSTOM_LINE1 = "pdf.header.text.custom.line1";
    private static final String HEADER_TEXT_CUSTOM_LINE2 = "pdf.header.text.custom.line2";
    private static final String HEADER_TEXT_CUSTOM_LINE3 = "pdf.header.text.custom.line3";
    private static final String HEADER_TEXT_FG_COLOR = "pdf.header.text.fgColor";
    private static final String ENCRYPTION = "pdf.encryption";
    private static final String ENCRYPTION_PASSWORD = "pdf.encryption.password";
    private static final String ENCRYPTION_ALLOW_COPYING = "pdf.encryption.allow.copying";
    private static final String ENCRYPTION_ALLOW_PRINTING = "pdf.encryption.allow.printing";
    private static final String ENCRYPTION_ALLOW_ACCESSIBILITY = "pdf.encryption.allow.accessibility";
    protected static final String BASE_FONT = "BaseFont";
    protected static final float DEFAULT_MARGIN_TOP = 110.0f;
    protected static final float DEFAULT_MARGIN_BOTTOM = 90.0f;
    protected static final float DEFAULT_MARGIN_LEFT = 60.0f;
    protected static final float DEFAULT_MARGIN_RIGHT = 60.0f;
    private Map<Integer, Integer> rowPages = null;
    protected DateFormat dateFormat = null;
    private I18n i18n = null;
    protected BaseFont baseFont = null;
    protected Font bodyFontH1 = null;
    protected Font bodyFontH2 = null;
    protected Font bodyFontH3 = null;
    protected Font bodyFontBold = null;
    protected Font bodyFontNormal = null;
    protected Font bodyFontSmall = null;
    protected Color borderColor = null;
    protected Color bodyHeadBgColor = null;
    protected Color bodyHeadFgColor = null;
    protected Color bodyTextBgColor = null;
    protected Color bodyTextFgColor = null;
    protected Color headerTextFgColor = null;
    protected Color footerTextFgColor = null;
    protected List<Integer> pageBreakBeforeRow = null;
    protected List<Integer> pageBreakIfNextRowNotFits = null;
    private Image headerAgentLogo = null;

    protected void buildDocument(Document document, PdfPTable pdfPTable, PdfReader pdfReader, Rectangle rectangle, OutputStream outputStream) throws IOException, DocumentException {
        int n;
        int n2;
        this.rowPages.clear();
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        float f3 = 0.0f;
        int n3 = 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 0; n2 < pdfPTable.getRows().size(); ++n2) {
            float f4 = pdfPTable.getRowHeight(n2);
            int n4 = n = n2 == 0 ? 1 : 0;
            if (n == 0 && this.pageBreakBeforeRow.contains(n2)) {
                n = 1;
            }
            if (n == 0) {
                int n5 = n = f3 - f4 <= this.getMarginBottom(n3) ? 1 : 0;
            }
            if (n == 0 && this.pageBreakIfNextRowNotFits.contains(n2) && n2 < pdfPTable.getRows().size()) {
                float f5 = pdfPTable.getRowHeight(n2 + 1);
                int n6 = n = f3 - f4 - f5 <= this.getMarginBottom(n3) ? 1 : 0;
            }
            if (n != 0) {
                f3 = f2 - this.getMarginTop(n3);
                arrayList.add(n2);
                this.rowPages.put(n2, n3);
                ++n3;
            }
            f3 -= f4;
        }
        n2 = arrayList.size();
        PdfWriter pdfWriter = this.createWriter(document, outputStream);
        if (!document.isOpen()) {
            document.open();
        }
        f3 = 0.0f;
        n3 = 0;
        for (n = 0; n < pdfPTable.getRows().size(); ++n) {
            boolean bl = arrayList.contains(n);
            if (bl) {
                document.newPage();
                PdfTemplate pdfTemplate = pdfWriter.getDirectContent().createTemplate(f, f2);
                this.buildTemplate(pdfTemplate, f, f2, ++n3, n2, n);
                pdfWriter.getDirectContent().addTemplate(pdfTemplate, 0.0f, 0.0f);
                f3 = f2 - this.getMarginTop(n3);
                if (pdfReader != null) {
                    int n7 = n3;
                    if (n7 > pdfReader.getNumberOfPages()) {
                        n7 = pdfReader.getNumberOfPages();
                    }
                    PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, n7);
                    pdfWriter.getDirectContentUnder().addTemplate((PdfTemplate)pdfImportedPage, 0.0f, 0.0f);
                }
            }
            f3 = pdfPTable.writeSelectedRows(n, n + 1, this.getMarginLeft(n3), f3, pdfWriter.getDirectContent());
        }
        pdfWriter.flush();
    }

    protected void buildTableHead(PdfPTable pdfPTable, int n, String string) {
        PdfPTable pdfPTable2 = new PdfPTable(1);
        pdfPTable2.setWidthPercentage(100.0f);
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setPaddingTop(10.0f);
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable2.addCell(pdfPCell);
        pdfPCell = new PdfPCell();
        pdfPCell.setPaddingBottom(5.0f);
        pdfPCell.setPaddingLeft(5.0f);
        pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setBorderWidthBottom(1.0f);
        pdfPCell.setBorderColorBottom(this.borderColor);
        if (this.isBodyHeadNumbered()) {
            pdfPCell.addElement((Element)new Paragraph(String.valueOf(n) + ". " + string, this.bodyFontH2));
        } else {
            pdfPCell.addElement((Element)new Paragraph(string, this.bodyFontH2));
        }
        pdfPTable2.addCell(pdfPCell);
        pdfPCell = new PdfPCell(pdfPTable2);
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable.addCell(pdfPCell);
    }

    protected void buildTableHead2(PdfPTable pdfPTable, int n, int n2, String string) {
        PdfPCell pdfPCell = null;
        Font font = new Font(this.bodyFontH3);
        font.setColor(this.bodyTextFgColor);
        PdfPTable pdfPTable2 = new PdfPTable(1);
        pdfPTable2.setWidthPercentage(100.0f);
        pdfPCell = new PdfPCell();
        pdfPCell.setPaddingTop(10.0f);
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable2.addCell(pdfPCell);
        pdfPCell = this.isBodyHeadNumbered() ? new PdfPCell((Phrase)new Paragraph(String.valueOf(n) + "." + String.valueOf(n2) + ". " + string, font)) : new PdfPCell((Phrase)new Paragraph(string, font));
        pdfPCell.setPaddingTop(3.0f);
        pdfPCell.setPaddingBottom(3.0f);
        pdfPCell.setPaddingLeft(5.0f);
        pdfPCell.setPaddingRight(5.0f);
        pdfPCell.setBackgroundColor(this.bodyTextBgColor);
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable2.addCell(pdfPCell);
        pdfPCell = new PdfPCell(pdfPTable2);
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable.addCell(pdfPCell);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string) {
        this.buildTableRow(pdfPTable, string, 0);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, int n) {
        this.buildTableRow(pdfPTable, string, n, 0.0f, 3);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, int n, int n2) {
        this.buildTableRow(pdfPTable, string, n, 0.0f, n2);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, float f) {
        this.buildTableRow(pdfPTable, string, 0, f, 3);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, float f, int n) {
        this.buildTableRow(pdfPTable, string, 0, f, n);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, int n, float f) {
        this.buildTableRow(pdfPTable, string, 0, f, 3);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, int n, float f, int n2) {
        String string2 = string != null ? ImmoToolUtils.stripTags((String)string).trim() : "";
        Font font = new Font(this.bodyFontNormal);
        font.setStyle(n);
        if (f > 0.0f) {
            font.setSize(f);
        }
        for (String string3 : ImmoToolUtils.splitLines((String)string2)) {
            Paragraph paragraph = new Paragraph(string3, font);
            paragraph.setAlignment(n2);
            paragraph.setSpacingAfter(font.getSize() / 2.0f);
            this.buildTableRow(pdfPTable, paragraph);
        }
    }

    protected void buildTableRow(PdfPTable pdfPTable, Paragraph paragraph) {
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPaddingTop(0.0f);
        pdfPCell.setPaddingBottom(0.0f);
        pdfPCell.setPaddingLeft(20.0f);
        pdfPCell.setPaddingRight(20.0f);
        pdfPCell.addElement((Element)paragraph);
        pdfPCell.setBackgroundColor(this.bodyTextBgColor);
        pdfPTable.addCell(pdfPCell);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, String string2) {
        Paragraph paragraph = new Paragraph(StringEscapeUtils.unescapeHtml4((String)string2), this.bodyFontNormal);
        paragraph.setAlignment(0);
        this.buildTableRow(pdfPTable, string, paragraph);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, Phrase phrase) {
        Paragraph paragraph = new Paragraph(phrase);
        paragraph.setAlignment(0);
        this.buildTableRow(pdfPTable, string, paragraph);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, Paragraph paragraph) {
        PdfPCell pdfPCell = new PdfPCell((Phrase)paragraph);
        pdfPCell.setPadding(0.0f);
        pdfPCell.setPaddingTop(1.5f);
        pdfPCell.setPaddingBottom(3.5f);
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setBackgroundColor(this.bodyTextBgColor);
        this.buildTableRow(pdfPTable, string, pdfPCell);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, PdfPCell pdfPCell) {
        Paragraph paragraph = new Paragraph(string + ":", this.bodyFontBold);
        paragraph.setAlignment(0);
        PdfPCell pdfPCell2 = new PdfPCell((Phrase)paragraph);
        pdfPCell2.setBorderWidth(0.0f);
        pdfPCell2.setPadding(0.0f);
        pdfPCell2.setPaddingLeft(30.0f);
        pdfPCell2.setPaddingTop(1.5f);
        pdfPCell2.setPaddingBottom(3.5f);
        pdfPCell2.setBackgroundColor(this.bodyTextBgColor);
        pdfPCell2.setVerticalAlignment(4);
        pdfPTable.addCell(pdfPCell2);
        pdfPTable.addCell(pdfPCell);
    }

    protected void buildTemplate(PdfTemplate pdfTemplate, float f, float f2, int n, int n2, int n3) throws IOException, DocumentException {
        Object object;
        float f3;
        ImmoToolAgent immoToolAgent = this.getAgent();
        float f4 = this.getMarginLeft(n);
        float f5 = this.getMarginRight(n);
        float f6 = this.getMarginTop(n);
        float f7 = this.getMarginTop(n);
        pdfTemplate.setBoundingBox(new Rectangle(f4, f2 - 25.0f, f - f5, 0.0f));
        if (this.isHeader()) {
            String string;
            String string2;
            f3 = f2 - f6 + 10.0f;
            pdfTemplate.setColorStroke(this.borderColor);
            pdfTemplate.setColorFill(this.borderColor);
            pdfTemplate.moveTo(f4, f3);
            pdfTemplate.lineTo(f - f5, f3);
            pdfTemplate.stroke();
            float f8 = f4;
            float f9 = f2 - f6 / 3.0f;
            if (this.isHeaderLogo()) {
                BufferedImage bufferedImage;
                if (this.headerAgentLogo == null && (bufferedImage = this.getAgentLogoImage()) != null) {
                    bufferedImage = ImageUtils.convertToRgb((BufferedImage)bufferedImage);
                    this.headerAgentLogo = Image.getInstance((java.awt.Image)bufferedImage, null);
                }
                if (this.headerAgentLogo != null) {
                    float f10 = f - f4 - f5;
                    float f11 = f6 - 40.0f;
                    float f12 = f4;
                    float f13 = f2 - f6 + 15.0f;
                    this.headerAgentLogo.scaleToFit(f10, f11);
                    this.headerAgentLogo.setAbsolutePosition(f12, f13);
                    pdfTemplate.addImage(this.headerAgentLogo);
                    f8 = f12 + this.headerAgentLogo.getScaledWidth() + 10.0f;
                }
            }
            if (this.isHeaderTextCustom()) {
                string2 = this.getHeaderTextCustomLine1();
                string = this.getHeaderTextCustomLine2();
                object = this.getHeaderTextCustomLine3();
            } else {
                string2 = immoToolAgent.getCompany().getCompanyName();
                string = immoToolAgent.getCompany().writePersonFullName();
                object = immoToolAgent.getCompany().writeFullAddress(", ", this.getLocale());
            }
            pdfTemplate.beginText();
            pdfTemplate.setColorStroke(this.headerTextFgColor);
            pdfTemplate.setColorFill(this.headerTextFgColor);
            pdfTemplate.setFontAndSize(this.baseFont, 12.0f);
            pdfTemplate.showTextAligned(0, string2 != null ? string2.trim() : "", f8, f9, 0.0f);
            pdfTemplate.setFontAndSize(this.baseFont, 10.0f);
            pdfTemplate.showTextAligned(0, string != null ? string.trim() : "", f8, f9 - 12.0f, 0.0f);
            pdfTemplate.setFontAndSize(this.baseFont, 10.0f);
            pdfTemplate.showTextAligned(0, object != null ? ((String)object).trim() : "", f8, f9 - 24.0f, 0.0f);
            pdfTemplate.endText();
        }
        if (this.isFooter()) {
            f3 = f7 - 10.0f;
            pdfTemplate.setColorStroke(this.borderColor);
            pdfTemplate.setColorFill(this.borderColor);
            pdfTemplate.moveTo(f4, f3);
            pdfTemplate.lineTo(f - f5, f3);
            pdfTemplate.stroke();
            pdfTemplate.beginText();
            pdfTemplate.setColorStroke(this.footerTextFgColor);
            pdfTemplate.setColorFill(this.footerTextFgColor);
            pdfTemplate.setFontAndSize(this.baseFont, 10.0f);
            AbstractExpose.HorizontalAlign horizontalAlign = this.getFooterTextAlignment();
            int n4 = horizontalAlign == null ? 0 : (AbstractExpose.HorizontalAlign.LEFT.equals((Object)horizontalAlign) ? 0 : (AbstractExpose.HorizontalAlign.CENTER.equals((Object)horizontalAlign) ? 1 : (AbstractExpose.HorizontalAlign.RIGHT.equals((Object)horizontalAlign) ? 2 : 0)));
            float f14 = f7 - 30.0f;
            float f15 = f4;
            if (n4 == 2) {
                f15 = f - f5;
            } else if (n4 == 1) {
                f15 = f / 2.0f;
            }
            if (this.isFooterTimestamp()) {
                pdfTemplate.showTextAligned(n4, this.i18n.tr("created at") + ": " + this.dateFormat.format(this.now), f15, f14, 0.0f);
                f14 -= 12.0f;
            }
            if (this.isFooterWebsite() && immoToolAgent != null && immoToolAgent.getCompany().getCompanyWebsite() != null && StringUtils.isNotBlank((CharSequence)((URI)(object = immoToolAgent.getCompany().getCompanyWebsite())).getHost())) {
                String string = StringUtils.substringAfter((String)((URI)object).toString(), (String)(((URI)object).getScheme() + "://"));
                pdfTemplate.showTextAligned(n4, string, f15, f14, 0.0f);
                f14 -= 12.0f;
            }
            if (this.isFooterPageNumber()) {
                pdfTemplate.showTextAligned(n4, this.i18n.tr("page {0} of {1}", (Object)n, (Object)n2), f15, f14, 0.0f);
                f14 -= 12.0f;
            }
            pdfTemplate.endText();
        }
    }

    protected PdfWriter createWriter(Document document, OutputStream outputStream) throws DocumentException {
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        if (this.isEncryption()) {
            int n = 0;
            if (this.isEncryptionAccessibilityAllowed()) {
                n |= 0x200;
            }
            if (this.isEncryptionCopyingAllowed()) {
                n |= 0x10;
            }
            if (this.isEncryptionPrintingAllowed()) {
                n |= 0x804;
            }
            pdfWriter.setEncryption(Charset.defaultCharset().encode(this.getEncryptionPassword()).array(), null, n, 1);
            pdfWriter.createXmpMetadata();
        }
        return pdfWriter;
    }

    public Color getBodyHeadBgColor() {
        String string = (String)this.get(BODY_HEAD_BG_COLOR);
        return !StringUtils.isBlank((CharSequence)string) ? ImmoToolUtils.getHexColor((String)string) : null;
    }

    public Color getBodyHeadFgColor() {
        String string = (String)this.get(BODY_HEAD_FG_COLOR);
        return !StringUtils.isBlank((CharSequence)string) ? ImmoToolUtils.getHexColor((String)string) : null;
    }

    public AbstractExpose.HorizontalAlign getBodyTextAlignment() {
        String string = (String)this.get(BODY_TEXT_ALIGN);
        return !StringUtils.isBlank((CharSequence)string) ? AbstractExpose.HorizontalAlign.valueOf(string) : null;
    }

    public Color getBodyTextBgColor() {
        String string = (String)this.get(BODY_TEXT_BG_COLOR);
        return !StringUtils.isBlank((CharSequence)string) ? ImmoToolUtils.getHexColor((String)string) : null;
    }

    public Color getBodyTextFgColor() {
        String string = (String)this.get(BODY_TEXT_FG_COLOR);
        return !StringUtils.isBlank((CharSequence)string) ? ImmoToolUtils.getHexColor((String)string) : null;
    }

    public Color getBorderColor() {
        String string = (String)this.get(BORDER_COLOR);
        return !StringUtils.isBlank((CharSequence)string) ? ImmoToolUtils.getHexColor((String)string) : null;
    }

    public String getEncryptionPassword() {
        return (String)this.get(ENCRYPTION_PASSWORD);
    }

    public AbstractExpose.HorizontalAlign getFooterTextAlignment() {
        String string = (String)this.get(FOOTER_TEXT_ALIGN);
        return !StringUtils.isBlank((CharSequence)string) ? AbstractExpose.HorizontalAlign.valueOf(string) : null;
    }

    public Color getFooterTextFgColor() {
        String string = (String)this.get(FOOTER_TEXT_FG_COLOR);
        return !StringUtils.isBlank((CharSequence)string) ? ImmoToolUtils.getHexColor((String)string) : null;
    }

    public String getHeaderTextCustomLine1() {
        return (String)this.get(HEADER_TEXT_CUSTOM_LINE1);
    }

    public String getHeaderTextCustomLine2() {
        return (String)this.get(HEADER_TEXT_CUSTOM_LINE2);
    }

    public String getHeaderTextCustomLine3() {
        return (String)this.get(HEADER_TEXT_CUSTOM_LINE3);
    }

    public Color getHeaderTextFgColor() {
        String string = (String)this.get(HEADER_TEXT_FG_COLOR);
        return !StringUtils.isBlank((CharSequence)string) ? ImmoToolUtils.getHexColor((String)string) : null;
    }

    protected float getMarginBottom(int n) {
        return 90.0f;
    }

    protected float getMarginLeft(int n) {
        return 60.0f;
    }

    protected float getMarginRight(int n) {
        return 60.0f;
    }

    protected float getMarginTop(int n) {
        return 110.0f;
    }

    public static Font getMatchingFont(String string, float f, Font font) {
        Font font2 = new Font(font);
        while (true) {
            Chunk chunk = new Chunk(string, font2);
            if (!(chunk.getWidthPoint() > f)) break;
            font2.setSize(font2.getSize() - 0.2f);
        }
        return font2;
    }

    public static Font getMatchingFont(String string, float f, float f2, Font font, float f3) {
        return AbstractPdfExpose.getMatchingFont(string, f, f2, font, f3, new char[]{'-'});
    }

    public static Font getMatchingFont(String string, float f, float f2, Font font, float f3, char[] cArray) {
        if (f2 < font.getSize()) {
            return null;
        }
        int n = (int)Math.floor(f2 / font.getCalculatedLeading(f3));
        float f4 = f * (float)n;
        float f5 = new Chunk(" ", font).getWidthPoint();
        String[] stringArray = StringUtils.split((String)StringUtils.trimToEmpty((String)string), (String)" ");
        int n2 = 1;
        float f6 = 0.0f;
        for (int i = 0; i < stringArray.length; ++i) {
            float f7;
            String string2 = stringArray[i];
            float f8 = 0.0f;
            boolean bl = false;
            if (cArray != null && cArray.length > 0) {
                for (char c : cArray) {
                    if (!StringUtils.contains((CharSequence)string2, (int)c) || StringUtils.containsOnly((CharSequence)string2, (char[])new char[]{c})) continue;
                    String[] stringArray2 = StringUtils.split((String)string2, (char)c);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string3 = j + 1 < stringArray2.length ? stringArray2[j] + c : stringArray2[j];
                        f8 += new Chunk(string3, font).getWidthPoint();
                    }
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                f8 += new Chunk(string2, font).getWidthPoint();
            }
            if ((f7 = f6 + f8) > f * (float)n2) {
                float f9 = f * (float)n2 - f6;
                f7 += f9;
                ++n2;
            } else if (i + 1 < stringArray.length) {
                f7 += f5;
            }
            f6 = f7;
        }
        if (f6 <= f4) {
            return font;
        }
        Font font2 = new Font(font);
        font2.setSize(font2.getSize() - 0.1f);
        return AbstractPdfExpose.getMatchingFont(string, f, f2, font2, f3, cArray);
    }

    protected int getPageNumber(int n) {
        Map.Entry<Integer, Integer> entry;
        Integer n2;
        if (this.rowPages == null) {
            return 0;
        }
        int n3 = -1;
        Iterator<Map.Entry<Integer, Integer>> iterator = this.rowPages.entrySet().iterator();
        while (iterator.hasNext() && (n2 = (entry = iterator.next()).getKey()) <= n) {
            n3 = entry.getValue();
        }
        return n3;
    }

    protected static Font getRegisteredFont() {
        return AbstractPdfExpose.getRegisteredFont(BASE_FONT);
    }

    protected static Font getRegisteredFont(String string) {
        return FontFactory.getFont((String)string, (String)"Identity-H", (boolean)true);
    }

    protected static Font getRegisteredFont(float f, int n) {
        return AbstractPdfExpose.getRegisteredFont(BASE_FONT, f, n);
    }

    protected static Font getRegisteredFont(String string, float f, int n) {
        return FontFactory.getFont((String)string, (String)"Identity-H", (boolean)true, (float)f, (int)n);
    }

    protected static Font getRegisteredFont(float f, int n, Color color) {
        return AbstractPdfExpose.getRegisteredFont(BASE_FONT, f, n, color);
    }

    protected static Font getRegisteredFont(String string, float f, int n, Color color) {
        return FontFactory.getFont((String)string, (String)"Identity-H", (boolean)true, (float)f, (int)n, (Color)color);
    }

    @Override
    protected void init(ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        super.init(immoToolProject, connection);
        this.i18n = I18nFactory.getI18n(AbstractPdfExpose.class, (Locale)this.locale);
        this.dateFormat = DateFormat.getDateTimeInstance(2, 3, this.locale);
        this.pageBreakIfNextRowNotFits = new ArrayList<Integer>();
        this.pageBreakBeforeRow = new ArrayList<Integer>();
        this.rowPages = new TreeMap<Integer, Integer>();
        this.headerAgentLogo = null;
        this.bodyHeadBgColor = this.getBodyHeadBgColor();
        this.bodyHeadFgColor = this.getBodyHeadFgColor();
        this.bodyTextBgColor = this.getBodyTextBgColor();
        this.bodyTextFgColor = this.getBodyTextFgColor();
        this.borderColor = this.getBorderColor();
        this.footerTextFgColor = this.getFooterTextFgColor();
        this.headerTextFgColor = this.getHeaderTextFgColor();
        if (this.bodyHeadBgColor == null) {
            this.bodyHeadBgColor = Color.WHITE;
        }
        if (this.bodyHeadFgColor == null) {
            this.bodyHeadFgColor = Color.BLACK;
        }
        if (this.bodyTextBgColor == null) {
            this.bodyTextBgColor = Color.WHITE;
        }
        if (this.bodyTextFgColor == null) {
            this.bodyTextFgColor = Color.BLACK;
        }
        if (this.borderColor == null) {
            this.borderColor = Color.GRAY;
        }
        if (this.footerTextFgColor == null) {
            this.footerTextFgColor = Color.BLACK;
        }
        if (this.headerTextFgColor == null) {
            this.headerTextFgColor = Color.BLACK;
        }
        this.registerFonts();
        Font font = AbstractPdfExpose.getRegisteredFont();
        this.baseFont = font.getBaseFont();
        this.bodyFontH1 = new Font(font);
        this.bodyFontH1.setSize(16.0f);
        this.bodyFontH1.setStyle(1);
        this.bodyFontH1.setColor(this.bodyHeadFgColor);
        this.bodyFontH2 = new Font(font);
        this.bodyFontH2.setSize(14.0f);
        this.bodyFontH2.setStyle(1);
        this.bodyFontH2.setColor(this.bodyHeadFgColor);
        this.bodyFontH3 = new Font(font);
        this.bodyFontH3.setSize(12.0f);
        this.bodyFontH3.setStyle(1);
        this.bodyFontH3.setColor(this.bodyHeadFgColor);
        this.bodyFontBold = new Font(font);
        this.bodyFontBold.setSize(11.0f);
        this.bodyFontBold.setStyle(1);
        this.bodyFontBold.setColor(this.bodyTextFgColor);
        this.bodyFontNormal = new Font(font);
        this.bodyFontNormal.setSize(11.0f);
        this.bodyFontNormal.setStyle(0);
        this.bodyFontNormal.setColor(this.bodyTextFgColor);
        this.bodyFontSmall = new Font(font);
        this.bodyFontSmall.setSize(9.0f);
        this.bodyFontSmall.setStyle(0);
        this.bodyFontSmall.setColor(this.bodyTextFgColor);
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setBodyHeadBgColor(ImmoToolUtils.TABLE_HIGHLIGHT_COLOR);
        this.setBodyHeadFgColor(Color.BLACK);
        this.setBodyHeadNumbered(true);
        this.setBodyTextAlignment(AbstractExpose.HorizontalAlign.JUSTIFY);
        this.setBodyTextBgColor(Color.WHITE);
        this.setBodyTextFgColor(Color.BLACK);
        this.setBorderColor(Color.GRAY);
        this.setFooter(true);
        this.setFooterPageNumber(true);
        this.setFooterTextAlignment(AbstractExpose.HorizontalAlign.LEFT);
        this.setFooterTextFgColor(Color.GRAY);
        this.setFooterTimestamp(true);
        this.setFooterWebsite(true);
        this.setHeader(true);
        this.setHeaderLogo(true);
        this.setHeaderTextCustom(false);
        this.setHeaderTextFgColor(Color.BLACK);
    }

    public boolean isBodyHeadNumbered() {
        String string = (String)this.get(BODY_HEAD_NUMBERED);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isEncryption() {
        String string = (String)this.get(ENCRYPTION);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isEncryptionAccessibilityAllowed() {
        String string = (String)this.get(ENCRYPTION_ALLOW_ACCESSIBILITY);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isEncryptionCopyingAllowed() {
        String string = (String)this.get(ENCRYPTION_ALLOW_COPYING);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isEncryptionPrintingAllowed() {
        String string = (String)this.get(ENCRYPTION_ALLOW_PRINTING);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isFooter() {
        String string = (String)this.get(FOOTER);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isFooterPageNumber() {
        String string = (String)this.get(FOOTER_PAGE_NUMBER);
        return StringUtils.isBlank((CharSequence)string) || Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isFooterTimestamp() {
        String string = (String)this.get(FOOTER_TIMESTAMP);
        return StringUtils.isBlank((CharSequence)string) || Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isFooterWebsite() {
        String string = (String)this.get(FOOTER_WEBSITE);
        return StringUtils.isBlank((CharSequence)string) || Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHeader() {
        String string = (String)this.get(HEADER);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHeaderLogo() {
        String string = (String)this.get(HEADER_LOGO);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isHeaderTextCustom() {
        String string = (String)this.get(HEADER_TEXT_CUSTOM);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    protected final boolean registerFont(String string, File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            boolean bl = this.registerFont(string, fileInputStream);
            return bl;
        }
    }

    protected final boolean registerFont(String string, InputStream inputStream) throws IOException {
        File file = new File(ImmoToolEnvironment.getTempDir(), DigestUtils.md5Hex((String)(System.currentTimeMillis() + ImmoToolUtils.getRandomAlphaNumericString((int)3))) + ".ttf");
        while (file.exists()) {
            file = new File(ImmoToolEnvironment.getTempDir(), DigestUtils.md5Hex((String)(System.currentTimeMillis() + ImmoToolUtils.getRandomAlphaNumericString((int)3))) + ".ttf");
        }
        file.deleteOnExit();
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
        if (!file.isFile()) {
            LOGGER.warn("Can't find font file: " + file.getAbsolutePath());
            return false;
        }
        FontFactory.register((String)file.getAbsolutePath(), (String)string);
        return true;
    }

    protected synchronized void registerFonts() {
        if (!FontFactory.isRegistered((String)BASE_FONT)) {
            String string = "/com/openindex/openestate/tool/resources/DejaVuSans.ttf";
            try (InputStream inputStream = AbstractPdfExpose.class.getResourceAsStream(string);){
                if (inputStream == null) {
                    throw new IOException("Can't find font at: " + string);
                }
                if (!this.registerFont(BASE_FONT, inputStream)) {
                    LOGGER.error("Can't register 'BaseFont' font from '" + string + "'!");
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't register 'BaseFont' font from '" + string + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void setBodyHeadBgColor(Color color) {
        if (color == null) {
            this.remove(BODY_HEAD_BG_COLOR);
        } else {
            this.put(BODY_HEAD_BG_COLOR, ImmoToolUtils.writeHexColor((Color)color));
        }
    }

    public void setBodyHeadFgColor(Color color) {
        if (color == null) {
            this.remove(BODY_HEAD_FG_COLOR);
        } else {
            this.put(BODY_HEAD_FG_COLOR, ImmoToolUtils.writeHexColor((Color)color));
        }
    }

    public void setBodyHeadNumbered(boolean bl) {
        this.put(BODY_HEAD_NUMBERED, String.valueOf(bl));
    }

    public void setBodyTextAlignment(AbstractExpose.HorizontalAlign horizontalAlign) {
        if (horizontalAlign == null) {
            this.remove(BODY_TEXT_ALIGN);
        } else {
            this.put(BODY_TEXT_ALIGN, horizontalAlign.name());
        }
    }

    public void setBodyTextBgColor(Color color) {
        if (color == null) {
            this.remove(BODY_TEXT_BG_COLOR);
        } else {
            this.put(BODY_TEXT_BG_COLOR, ImmoToolUtils.writeHexColor((Color)color));
        }
    }

    public void setBodyTextFgColor(Color color) {
        if (color == null) {
            this.remove(BODY_TEXT_FG_COLOR);
        } else {
            this.put(BODY_TEXT_FG_COLOR, ImmoToolUtils.writeHexColor((Color)color));
        }
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            this.remove(BORDER_COLOR);
        } else {
            this.put(BORDER_COLOR, ImmoToolUtils.writeHexColor((Color)color));
        }
    }

    public void setEncryption(boolean bl) {
        this.put(ENCRYPTION, String.valueOf(bl));
    }

    public void setEncryptionAccessibilityAllowed(boolean bl) {
        this.put(ENCRYPTION_ALLOW_ACCESSIBILITY, String.valueOf(bl));
    }

    public void setEncryptionCopyingAllowed(boolean bl) {
        this.put(ENCRYPTION_ALLOW_COPYING, String.valueOf(bl));
    }

    public void setEncryptionPassword(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            this.remove(ENCRYPTION_PASSWORD);
        } else {
            this.put(ENCRYPTION_PASSWORD, string);
        }
    }

    public void setEncryptionPrintingAllowed(boolean bl) {
        this.put(ENCRYPTION_ALLOW_PRINTING, String.valueOf(bl));
    }

    public void setFooter(boolean bl) {
        this.put(FOOTER, String.valueOf(bl));
    }

    public void setFooterPageNumber(boolean bl) {
        this.put(FOOTER_PAGE_NUMBER, String.valueOf(bl));
    }

    public void setFooterTextAlignment(AbstractExpose.HorizontalAlign horizontalAlign) {
        if (horizontalAlign == null) {
            this.remove(FOOTER_TEXT_ALIGN);
        } else {
            this.put(FOOTER_TEXT_ALIGN, horizontalAlign.name());
        }
    }

    public void setFooterTextFgColor(Color color) {
        if (color == null) {
            this.remove(FOOTER_TEXT_FG_COLOR);
        } else {
            this.put(FOOTER_TEXT_FG_COLOR, ImmoToolUtils.writeHexColor((Color)color));
        }
    }

    public void setFooterTimestamp(boolean bl) {
        this.put(FOOTER_TIMESTAMP, String.valueOf(bl));
    }

    public void setFooterWebsite(boolean bl) {
        this.put(FOOTER_WEBSITE, String.valueOf(bl));
    }

    public void setHeader(boolean bl) {
        this.put(HEADER, String.valueOf(bl));
    }

    public void setHeaderLogo(boolean bl) {
        this.put(HEADER_LOGO, String.valueOf(bl));
    }

    public void setHeaderTextCustom(boolean bl) {
        this.put(HEADER_TEXT_CUSTOM, String.valueOf(bl));
    }

    public void setHeaderTextCustomLine1(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            this.remove(HEADER_TEXT_CUSTOM_LINE1);
        } else {
            this.put(HEADER_TEXT_CUSTOM_LINE1, string);
        }
    }

    public void setHeaderTextCustomLine2(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            this.remove(HEADER_TEXT_CUSTOM_LINE2);
        } else {
            this.put(HEADER_TEXT_CUSTOM_LINE2, string);
        }
    }

    public void setHeaderTextCustomLine3(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            this.remove(HEADER_TEXT_CUSTOM_LINE3);
        } else {
            this.put(HEADER_TEXT_CUSTOM_LINE3, string);
        }
    }

    public void setHeaderTextFgColor(Color color) {
        if (color == null) {
            this.remove(HEADER_TEXT_FG_COLOR);
        } else {
            this.put(HEADER_TEXT_FG_COLOR, ImmoToolUtils.writeHexColor((Color)color));
        }
    }
}

