/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.gui;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyContacListCellRenderer
extends DefaultListCellRenderer<DbAgencyContact> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContacListCellRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContacListCellRenderer.class);
    private final String emptyText;

    public AgencyContacListCellRenderer() {
        this(null);
    }

    public AgencyContacListCellRenderer(String string) {
        this.emptyText = string;
    }

    public String getEmptyText() {
        return StringUtils.trimToEmpty((String)this.emptyText);
    }

    public Component getRenderedComponent(JList<? extends DbAgencyContact> jList, DbAgencyContact dbAgencyContact, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getRenderedComponent(jList, (Object)dbAgencyContact, n, bl, bl2);
        jLabel.setBackground(bl ? jList.getSelectionBackground() : (n % 2 == 0 ? Color.WHITE : ImmoToolUtils.TABLE_HIGHLIGHT_COLOR));
        jLabel.setForeground(bl ? jList.getSelectionForeground() : Color.BLACK);
        if (dbAgencyContact == null) {
            jLabel.setText("<html><div style=\"margin:3px;\">[ " + StringEscapeUtils.escapeXml11((String)this.getEmptyText()) + " ]</div></html>");
        } else {
            jLabel.setText("<html><div style=\"margin:3px;\"><b>#" + dbAgencyContact.id + "</b> | " + StringEscapeUtils.escapeXml11((String)dbAgencyContact.item.writePersonFullName()) + "<br><font size=\"-1\"><i>" + StringEscapeUtils.escapeXml11((String)dbAgencyContact.item.writeFullAddress(", ")) + "</i></font></div></html>");
        }
        return jLabel;
    }

    protected void init() {
        super.init();
        this.setOpaque(true);
    }
}

