/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.gui;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ExposeHorizontalAlignRenderer
extends AbstractRenderer<AbstractExpose.HorizontalAlign> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExposeHorizontalAlignRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(ExposeHorizontalAlignRenderer.class);
    private final Icon leftIcon = ImmoToolEnvironment.getResourceIcon((String)"text_left.png", (int)16);
    private final Icon centerIcon = ImmoToolEnvironment.getResourceIcon((String)"text_center.png", (int)16);
    private final Icon rightIcon = ImmoToolEnvironment.getResourceIcon((String)"text_right.png", (int)16);
    private final Icon blockIcon = ImmoToolEnvironment.getResourceIcon((String)"text_block.png", (int)16);

    public ExposeHorizontalAlignRenderer() {
        this(null);
    }

    public ExposeHorizontalAlignRenderer(String string) {
        super(string);
    }

    public void render(AbstractExpose.HorizontalAlign horizontalAlign, JLabel jLabel) {
        jLabel.setIconTextGap(5);
        if (horizontalAlign != null) {
            jLabel.setText(horizontalAlign.getTranslation());
            switch (horizontalAlign) {
                case CENTER: {
                    jLabel.setIcon(this.centerIcon);
                    break;
                }
                case JUSTIFY: {
                    jLabel.setIcon(this.blockIcon);
                    break;
                }
                case LEFT: {
                    jLabel.setIcon(this.leftIcon);
                    break;
                }
                case RIGHT: {
                    jLabel.setIcon(this.rightIcon);
                    break;
                }
                default: {
                    jLabel.setIcon(null);
                    break;
                }
            }
        } else {
            jLabel.setIcon(null);
            jLabel.setText(this.getEmptyText());
        }
    }
}

