/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class EstateTypeMenu
extends JPopupMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstateTypeMenu.class);
    private static final I18n I18N = I18nFactory.getI18n(EstateTypeMenu.class);
    private final Icon selectIcon = ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16);
    private OpenEstateType selectedType = null;

    public EstateTypeMenu() {
        TreeMap<String, OpenEstateType> treeMap = new TreeMap<String, OpenEstateType>();
        for (OpenEstateType openEstateType : OpenEstateType.getRootTypes()) {
            treeMap.put(openEstateType.getTranslation().toLowerCase(), openEstateType);
        }
        for (OpenEstateType openEstateType : treeMap.values()) {
            this.add(new TypeMenu(openEstateType));
        }
    }

    public OpenEstateType getSelectedType() {
        return this.selectedType;
    }

    public void setSelectedType(OpenEstateType openEstateType) {
        this.selectedType = openEstateType;
        EstateTypeMenu.updateSelection(this, this.selectedType != null ? this.selectedType.getParentPath() : new OpenEstateType[]{});
    }

    private static void updateSelection(EstateTypeMenu estateTypeMenu, OpenEstateType[] openEstateTypeArray) {
        for (int i = 0; i < estateTypeMenu.getComponentCount(); ++i) {
            Component component = estateTypeMenu.getComponent(i);
            if (!(component instanceof TypeMenu)) continue;
            EstateTypeMenu.updateSelection((TypeMenu)component, openEstateTypeArray);
        }
    }

    private static void updateSelection(TypeMenu typeMenu, OpenEstateType[] openEstateTypeArray) {
        OpenEstateType openEstateType = typeMenu.getType();
        int n = ArrayUtils.indexOf((Object[])openEstateTypeArray, (Object)openEstateType);
        if (n > -1) {
            if (n == openEstateTypeArray.length - 1) {
                typeMenu.setMenuSelectedExplicitly();
            } else {
                typeMenu.setMenuSelected(true);
            }
        } else {
            typeMenu.setMenuSelected(false);
        }
        for (int i = 0; i < typeMenu.getMenuComponentCount(); ++i) {
            Component component = typeMenu.getMenuComponent(i);
            if (component instanceof TypeMenu) {
                EstateTypeMenu.updateSelection((TypeMenu)component, openEstateTypeArray);
                continue;
            }
            if (!(component instanceof TypeItem)) continue;
            TypeItem typeItem = (TypeItem)component;
            OpenEstateType openEstateType2 = typeItem.getType();
            n = ArrayUtils.indexOf((Object[])openEstateTypeArray, (Object)openEstateType2);
            if (n > -1) {
                typeItem.setItemSelected(true);
                continue;
            }
            typeItem.setItemSelected(false);
        }
    }

    private class TypeItem
    extends JMenuItem
    implements ActionListener {
        private final OpenEstateType type;

        public TypeItem(OpenEstateType openEstateType) {
            this.type = openEstateType;
            this.build(openEstateType);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EstateTypeMenu.this.setSelectedType(this.type);
            EstateTypeMenu.this.setVisible(false);
        }

        private void build(OpenEstateType openEstateType) {
            this.setItemSelected(false);
            this.setText((String)StringUtils.defaultIfBlank((CharSequence)openEstateType.getTranslation(), (CharSequence)openEstateType.name()));
            this.addActionListener(this);
        }

        private OpenEstateType getType() {
            return this.type;
        }

        private void setItemSelected(boolean bl) {
            if (bl) {
                this.setFont(this.getFont().deriveFont(1));
                this.setIcon(EstateTypeMenu.this.selectIcon);
            } else {
                this.setFont(this.getFont().deriveFont(0));
                this.setIcon(null);
            }
        }
    }

    private class TypeMenu
    extends JMenu {
        private OpenEstateType type;

        public TypeMenu(OpenEstateType openEstateType) {
            this.build(openEstateType);
        }

        private void build(OpenEstateType openEstateType) {
            this.type = openEstateType;
            this.setText((String)StringUtils.defaultIfBlank((CharSequence)openEstateType.getTranslation(), (CharSequence)openEstateType.name()));
            this.setMenuSelected(false);
            TreeMap<String, OpenEstateType> treeMap = new TreeMap<String, OpenEstateType>();
            for (OpenEstateType openEstateType2 : openEstateType.getChildTypes(false)) {
                String string = openEstateType2.getTranslation();
                treeMap.put(string.toLowerCase(), openEstateType2);
            }
            for (OpenEstateType openEstateType3 : treeMap.values()) {
                if (openEstateType3.hasChildTypes()) {
                    this.add(new TypeMenu(openEstateType3));
                    continue;
                }
                this.add(new TypeItem(openEstateType3));
            }
            this.addMenuKeyListener(new MenuKeyListener(){

                @Override
                public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
                }

                @Override
                public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
                }

                @Override
                public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
                    if (!TypeMenu.this.isSelected()) {
                        return;
                    }
                    if (10 == menuKeyEvent.getKeyCode() || 32 == menuKeyEvent.getKeyCode()) {
                        EstateTypeMenu.this.setSelectedType(TypeMenu.this.type);
                        EstateTypeMenu.this.setVisible(false);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                        EstateTypeMenu.this.setSelectedType(TypeMenu.this.type);
                        EstateTypeMenu.this.setVisible(false);
                    }
                }
            });
        }

        private OpenEstateType getType() {
            return this.type;
        }

        private void setMenuSelected(boolean bl) {
            if (bl) {
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            this.setIcon(null);
        }

        private void setMenuSelectedExplicitly() {
            this.setMenuSelected(true);
            this.setIcon(EstateTypeMenu.this.selectIcon);
        }
    }
}

