/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.energy_certificate.AustriaThermalHeatDemand;
import com.openindex.openestate.impl.attribs.energy_certificate.AustriaTotalEnergyEfficiencyFactor;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.CreationDate;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.ExpirationDate;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateValueTable;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.utils.EstateTypeMenu;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.FlowPanel;
import com.openindex.openestate.tool.gui.NullableFormattedTextField;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewValuesPanel
extends AgencyEstateViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewValuesPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewValuesPanel.class);
    private OpenEstateAction selectedEstateAction = null;
    private OpenEstateType selectedEstateType = null;
    private AbstractTypeImpl selectedEstateTypeImpl = null;
    private String selectedEstateCountry = null;
    private ImageIcon selectedEstateCountryIcon = null;
    private boolean isModified = false;
    private ValidationHandler validationHandler;
    private ModificationHandler modifications;
    private Icon minIcon;
    private Icon maxIcon;
    private JXTitledSeparator formTitle;
    private JLabel typeLabel;
    private JButton typeField;
    private EstateTypeMenu typeMenu;
    private JLabel actionLabel;
    private JComboBox<OpenEstateAction> actionField;
    private JCheckBox hiddenPricesField;
    private JTabbedPane tabbedPane;
    private AttributeTab attributeTab;
    private EnergyTab energyTab;
    private List<TextTab> textTabs;

    public AgencyEstateViewValuesPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.minIcon = ImmoToolEnvironment.getResourceIcon((String)"arrow_1_up.png", (int)16);
        this.maxIcon = ImmoToolEnvironment.getResourceIcon((String)"arrow_1_down.png", (int)16);
        this.typeLabel = new JLabel();
        this.typeMenu = new EstateTypeMenu(){

            @Override
            public synchronized void setSelectedType(OpenEstateType openEstateType) {
                super.setSelectedType(openEstateType);
                AgencyEstateViewValuesPanel.this.setEstateType(openEstateType, AgencyEstateViewValuesPanel.this.selectedEstateAction);
                AgencyEstateViewValuesPanel.this.isModified = true;
                AgencyEstateViewValuesPanel.this.updateTabSelection();
            }
        };
        this.typeField = new JButton();
        this.typeField.setOpaque(true);
        this.typeField.setHorizontalAlignment(2);
        this.typeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewValuesPanel.this.typeField.isEnabled()) {
                    return;
                }
                AgencyEstateViewValuesPanel.this.typeMenu.show(AgencyEstateViewValuesPanel.this.typeField, 0, ((AgencyEstateViewValuesPanel)AgencyEstateViewValuesPanel.this).typeField.getSize().height);
            }
        });
        this.actionLabel = new JLabel();
        this.actionField = new JComboBox(new DefaultComboBoxModel());
        this.actionField.setRenderer((ListCellRenderer<OpenEstateAction>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<OpenEstateAction>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("please select") + " ]";
            }
        }));
        this.actionField.setEnabled(false);
        this.actionField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewValuesPanel.this.actionField.isEnabled()) {
                    return;
                }
                AgencyEstateViewValuesPanel.this.setEstateType(AgencyEstateViewValuesPanel.this.selectedEstateType, (OpenEstateAction)AgencyEstateViewValuesPanel.this.actionField.getSelectedItem());
                AgencyEstateViewValuesPanel.this.updateTabSelection();
            }
        });
        this.hiddenPricesField = new JCheckBox();
        this.hiddenPricesField.setEnabled(false);
        this.validationHandler.putRule(this.actionField, (ValidationRule)new NonEmptyComboBoxRule(this.actionField));
        this.tabbedPane = new JTabbedPane();
        this.attributeTab = (AttributeTab)ImmoToolUtils.addTab((AbstractTab)new AttributeTab(), (JTabbedPane)this.tabbedPane);
        this.energyTab = (EnergyTab)ImmoToolUtils.addTab((AbstractTab)new EnergyTab(), (JTabbedPane)this.tabbedPane);
        this.textTabs = new ArrayList<TextTab>();
        TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
        for (Locale locale : AgencyPlugin.getLocales()) {
            treeMap.put(locale.getDisplayLanguage(), locale);
        }
        for (Locale locale : treeMap.values()) {
            this.textTabs.add((TextTab)ImmoToolUtils.addTab((AbstractTab)new TextTab(locale), (JTabbedPane)this.tabbedPane));
        }
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu,right:[40dlu,pref], 3dlu, pref");
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.typeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.typeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.actionLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add(this.actionField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)FlowPanel.create((JComponent[])new JComponent[]{this.hiddenPricesField})).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        this.setLayout(new BorderLayout(5, 5));
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(this.tabbedPane, "Center");
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("property"));
    }

    public boolean isTabModified() {
        for (TextTab textTab : this.textTabs) {
            if (!textTab.modifications.isModified()) continue;
            return true;
        }
        return this.isModified || this.modifications.isModified() || this.attributeTab.table.hasModifications();
    }

    public boolean isTabValid() {
        this.validationHandler.validate();
        return this.validationHandler.isValid() && this.selectedEstateAction != null && this.selectedEstateType != null && this.attributeTab.table.hasRequiredInputs();
    }

    @Override
    public void load(DbAgencyObject dbAgencyObject) {
        String string = dbAgencyObject.item.getAddress().getCountry();
        this.selectedEstateCountry = string != null && string.trim().length() > 0 ? string : SystemUtils.USER_COUNTRY;
        this.selectedEstateCountryIcon = this.selectedEstateCountry != null && this.selectedEstateCountry.trim().length() > 0 ? OpenEstateUtils.getFlagIcon((String)this.selectedEstateCountry) : null;
        this.setEstateType(dbAgencyObject.item.getType(), dbAgencyObject.item.getAction());
        this.hiddenPricesField.setEnabled(true);
        this.hiddenPricesField.setSelected(dbAgencyObject.item.isHiddenPrices());
        this.attributeTab.table.loadEstate(dbAgencyObject.item, this.selectedEstateCountry);
        this.energyTab.load(dbAgencyObject);
        for (int i = 0; i < this.textTabs.size(); ++i) {
            TextTab textTab = this.textTabs.get(i);
            textTab.load(dbAgencyObject.item, this.selectedEstateCountry);
            this.tabbedPane.setEnabledAt(i + 2, dbAgencyObject.id < 1L || dbAgencyObject.item.getLanguages().isEmpty() || dbAgencyObject.item.getLanguages().contains(textTab.locale.getLanguage()));
        }
        if (dbAgencyObject.id > 0L) {
            this.validationHandler.validate();
        } else {
            this.validationHandler.init();
        }
        this.modifications.clear();
        this.modifications.putValue(this.actionField);
        this.modifications.putValue((JComponent)this.hiddenPricesField);
        this.isModified = false;
        this.updateTabSelection();
    }

    @Override
    public void save(DbAgencyObject dbAgencyObject) throws ImmoToolException {
        try {
            dbAgencyObject.item.setType(this.selectedEstateType, this.selectedEstateAction);
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't set estate-type & estate-action!", (Throwable)exception);
        }
        dbAgencyObject.item.getAttributes().clear();
        dbAgencyObject.item.setHiddenPrices(Boolean.valueOf(this.hiddenPricesField.isSelected()));
        this.attributeTab.table.saveEstate(dbAgencyObject.item);
        this.energyTab.save(dbAgencyObject);
        for (TextTab textTab : this.textTabs) {
            textTab.save(dbAgencyObject.item);
        }
    }

    @Override
    public void selectEstateCountry(String string) {
        this.selectedEstateCountry = string;
        this.selectedEstateCountryIcon = string != null && string.trim().length() > 0 ? OpenEstateUtils.getFlagIcon((String)string) : null;
        this.setEstateType(this.selectedEstateType, this.selectedEstateAction);
        this.energyTab.setCountry(string);
        this.updateTabSelection();
    }

    @Override
    public void selectLanguage(Locale locale, boolean bl) {
        int n = -1;
        for (int i = 0; i < this.textTabs.size(); ++i) {
            TextTab textTab = this.textTabs.get(i);
            if (!textTab.locale.getLanguage().equals(locale.getLanguage())) continue;
            n = i + 2;
            textTab.setEnabled(this.selectedEstateType != null && this.selectedEstateAction != null && bl);
            break;
        }
        if (n > -1) {
            this.tabbedPane.setEnabledAt(n, this.selectedEstateType != null && this.selectedEstateAction != null && bl);
        }
        this.updateTabSelection();
    }

    private void setEstateType(OpenEstateType openEstateType, OpenEstateAction openEstateAction) {
        AbstractTypeImpl abstractTypeImpl;
        AbstractTypeImpl abstractTypeImpl2 = abstractTypeImpl = openEstateType != null ? openEstateType.createImpl() : null;
        if (abstractTypeImpl != null && openEstateAction != null && !abstractTypeImpl.hasAction(openEstateAction)) {
            openEstateAction = null;
        }
        boolean bl = this.selectedEstateType == null && openEstateType != null || this.selectedEstateType != null && openEstateType == null || this.selectedEstateType != null && openEstateType != null && !this.selectedEstateType.equals((Object)openEstateType);
        boolean bl2 = this.selectedEstateAction == null && openEstateAction != null || this.selectedEstateAction != null && openEstateAction == null || this.selectedEstateAction != null && openEstateAction != null && !this.selectedEstateAction.equals((Object)openEstateAction);
        this.selectedEstateType = openEstateType;
        this.selectedEstateTypeImpl = abstractTypeImpl;
        this.selectedEstateAction = openEstateAction;
        if (this.selectedEstateType == null) {
            this.typeField.setBackground(this.validationHandler.getRequirdedInputColor());
        } else {
            this.typeField.setBackground(this.validationHandler.getValidInputColor());
        }
        if (bl) {
            this.typeMenu.setSelectedType(this.selectedEstateType);
        }
        if (bl) {
            this.actionField.setEnabled(false);
            this.actionField.removeAllItems();
            if (this.selectedEstateTypeImpl != null) {
                this.actionField.addItem(null);
                for (OpenEstateAction openEstateAction2 : this.selectedEstateTypeImpl.getActions()) {
                    this.actionField.addItem(openEstateAction2);
                }
                if (this.selectedEstateAction != null) {
                    this.actionField.setSelectedItem(this.selectedEstateAction);
                }
                this.actionField.setEnabled(true);
            }
            this.validationHandler.validate(this.actionField);
        }
        if (this.selectedEstateType != null && this.selectedEstateAction != null) {
            if (bl || bl2) {
                this.attributeTab.init(this.selectedEstateType, this.selectedEstateAction, this.selectedEstateCountry, true);
                this.tabbedPane.setEnabledAt(0, true);
                this.tabbedPane.setEnabledAt(1, this.selectedEstateTypeImpl.hasAttrib(OpenEstateAttrib.ENERGY_CERTIFICATE_AVAILABLE));
                for (int i = 0; i < this.textTabs.size(); ++i) {
                    TextTab textTab = this.textTabs.get(i);
                    textTab.init(this.selectedEstateType, this.selectedEstateAction, this.selectedEstateCountry, true);
                    this.tabbedPane.setEnabledAt(i + 2, textTab.isEnabled());
                }
            }
            this.attributeTab.showTable();
        } else {
            this.tabbedPane.setSelectedIndex(0);
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                this.tabbedPane.setEnabledAt(i, false);
            }
            this.attributeTab.hideTable();
        }
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("details about the property")));
        this.typeLabel.setText(StringUtils.capitalize((String)I18N.tr("property type")) + ":");
        this.typeField.setText(this.selectedEstateType != null ? this.selectedEstateType.getTranslation() : "[ " + I18N.tr("please select") + " ]");
        this.typeField.setToolTipText(I18N.tr("Select the type of property as precise as possible."));
        this.actionLabel.setText(StringUtils.capitalize((String)I18N.tr("marketing type")) + ":");
        this.actionField.setToolTipText(I18N.tr("Select the type of marketing of the property."));
        this.hiddenPricesField.setText(I18N.tr("Don't publish prices."));
        this.hiddenPricesField.setToolTipText("<html>" + I18N.tr("Enable this option, if you don't want to publish the prices of this property.") + "<br><b>" + StringUtils.capitalize((String)I18N.tr("warning")) + ":</b>" + I18N.tr("Most real estate portals don't support this feature!") + "</html>");
    }

    private void updateTabSelection() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n > 0 && !this.tabbedPane.isEnabledAt(n)) {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    private class PanelMaximizer
    implements ActionListener {
        private final JButton button;
        private final JPanel panel;
        private final int defaultHeight;
        private boolean maximized;

        private PanelMaximizer(JButton jButton, JPanel jPanel) {
            this.button = jButton;
            this.panel = jPanel;
            this.maximized = true;
            this.defaultHeight = jPanel.getPreferredSize().height;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.maximized) {
                this.maximized = true;
                if (AgencyEstateViewValuesPanel.this.minIcon != null) {
                    this.button.setIcon(AgencyEstateViewValuesPanel.this.minIcon);
                } else {
                    this.button.setText("-");
                }
                this.panel.setPreferredSize(new Dimension(100, this.defaultHeight));
                this.panel.setSize(new Dimension(this.panel.getSize().width, this.defaultHeight));
            } else {
                this.maximized = false;
                if (AgencyEstateViewValuesPanel.this.maxIcon != null) {
                    this.button.setIcon(AgencyEstateViewValuesPanel.this.maxIcon);
                } else {
                    this.button.setText("+");
                }
                this.panel.setPreferredSize(new Dimension(100, 0));
                this.panel.setSize(new Dimension(this.panel.getSize().width, 0));
            }
            this.panel.getParent().revalidate();
            this.panel.getParent().repaint();
        }
    }

    private class TextMaximizer
    implements ActionListener {
        private final JButton button;
        private final JScrollPane scroller;
        private final int defaultHeight;
        private boolean maximized;

        private TextMaximizer(JButton jButton, JScrollPane jScrollPane) {
            this.button = jButton;
            this.scroller = jScrollPane;
            this.maximized = false;
            this.defaultHeight = jScrollPane.getPreferredSize().height;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.maximized) {
                this.maximized = true;
                if (AgencyEstateViewValuesPanel.this.minIcon != null) {
                    this.button.setIcon(AgencyEstateViewValuesPanel.this.minIcon);
                } else {
                    this.button.setText("-");
                }
                this.scroller.setPreferredSize(new Dimension(100, 300));
                this.scroller.setSize(new Dimension(this.scroller.getSize().width, 300));
            } else {
                this.maximized = false;
                if (AgencyEstateViewValuesPanel.this.maxIcon != null) {
                    this.button.setIcon(AgencyEstateViewValuesPanel.this.maxIcon);
                } else {
                    this.button.setText("+");
                }
                this.scroller.setPreferredSize(new Dimension(100, 75));
                this.scroller.setSize(new Dimension(this.scroller.getSize().width, this.defaultHeight));
            }
            this.scroller.getParent().revalidate();
            this.scroller.getParent().repaint();
        }
    }

    private class TextTabField {
        private final OpenEstateAttrib attribute;
        private final Locale locale;
        private JLabel label;
        private JTextField field;

        private TextTabField(OpenEstateAttrib openEstateAttrib, Locale locale) {
            this.attribute = openEstateAttrib;
            this.locale = locale;
            AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
            this.label = new JLabel();
            this.label.setHorizontalTextPosition(10);
            if (abstractAttribImpl.isCountrySpecific()) {
                this.label.setIcon(AgencyEstateViewValuesPanel.this.selectedEstateCountryIcon);
            }
            this.field = new JTextField();
            this.updateLocalization();
        }

        public String getText() {
            return this.field.getText().trim();
        }

        public void setText(String string) {
            this.field.setText(StringUtils.trimToEmpty((String)string));
            this.field.setCaretPosition(0);
        }

        public void updateLocalization() {
            this.label.setText(this.attribute.getTranslation() + ":");
        }
    }

    private class TextTabArea {
        private final OpenEstateAttrib attribute;
        private final Locale locale;
        private DefaultTextArea field;
        private JXTitledSeparator label;

        private TextTabArea(OpenEstateAttrib openEstateAttrib, Locale locale) {
            this.attribute = openEstateAttrib;
            this.locale = locale;
            ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)openEstateAttrib.createImpl();
            this.label = ImmoToolUtils.createHead2Separator((String)"");
            this.label.setHorizontalTextPosition(10);
            if (complexStringAttrib.isCountrySpecific()) {
                this.label.setIcon((Icon)AgencyEstateViewValuesPanel.this.selectedEstateCountryIcon);
            }
            this.field = new DefaultTextArea(complexStringAttrib.getMaxLength());
            this.field.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    String string = TextTabArea.this.getTitle();
                    if (!TextTabArea.this.label.getTitle().equalsIgnoreCase(string)) {
                        TextTabArea.this.label.setTitle(string);
                    }
                }
            });
            this.updateLocalization();
        }

        private String getTitle() {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)this.attribute.createImpl();
            int n = complexStringAttrib.getMaxLength() - this.field.getText().length();
            if (n < 0) {
                n = 0;
            }
            String string = n > 0 ? "font-weight:normal;" : "font-weight:bold;color:red;";
            return "<html>" + this.attribute.getTranslation() + " <span style=\"" + string + "\">(" + this.locale.getDisplayLanguage() + ", " + I18N.tr("{0} characters left", (Object)numberFormat.format(n)) + ")</span></html>";
        }

        public String getText() {
            return this.field.getText().trim();
        }

        public void setText(String string) {
            this.field.setText(StringUtils.trimToEmpty((String)string));
            this.field.setCaretPosition(0);
        }

        public void updateLocalization() {
            this.label.setTitle(this.getTitle());
        }
    }

    private class TextTab
    extends AbstractTab {
        private final Map<OpenEstateAttribGroup, JXTitledSeparator> groupTitles = new EnumMap<OpenEstateAttribGroup, JXTitledSeparator>(OpenEstateAttribGroup.class);
        private final Map<OpenEstateAttrib, TextTabArea> textAreas = new EnumMap<OpenEstateAttrib, TextTabArea>(OpenEstateAttrib.class);
        private final Map<OpenEstateAttrib, TextTabField> textFields = new EnumMap<OpenEstateAttrib, TextTabField>(OpenEstateAttrib.class);
        private final Locale locale;
        private ModificationHandler modifications = ImmoToolUtils.createModificationHandler();
        private OpenEstateType lastType = null;
        private OpenEstateAction lastAction = null;
        private String lastCountry = null;

        private TextTab(Locale locale) {
            this.locale = locale;
        }

        private void buildPanel(List<OpenEstateAttrib> list, List<OpenEstateAttrib> list2) {
            Object object;
            Object object2;
            Object object3;
            this.removeAll();
            this.textFields.clear();
            this.textAreas.clear();
            this.groupTitles.clear();
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            TreeMap treeMap = new TreeMap();
            for (OpenEstateAttrib object62 : list) {
                String string = object62.getGroup().getTranslation();
                object3 = object62.getTranslation();
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, new TreeMap());
                }
                ((Map)treeMap.get(string)).put(object3, object62);
                this.textFields.put(object62, new TextTabField(object62, this.locale));
            }
            for (Map map : treeMap.values()) {
                if (map.isEmpty()) continue;
                DefaultFormBuilder defaultFormBuilder2 = DefaultFormBuilder.create((String)"right:[150dlu,pref], 3dlu, 30dlu:grow");
                for (Map.Entry entry : map.entrySet()) {
                    object2 = (OpenEstateAttrib)entry.getValue();
                    object = this.textFields.get(object2);
                    defaultFormBuilder2.add((Component)((TextTabField)object).label).xy(1, defaultFormBuilder2.nextRow());
                    defaultFormBuilder2.add((Component)((TextTabField)object).field).xy(3, defaultFormBuilder2.row());
                }
                object3 = ((OpenEstateAttrib)map.values().iterator().next()).getGroup();
                JXTitledSeparator jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)this.getGroupTitle((OpenEstateAttribGroup)object3));
                this.groupTitles.put((OpenEstateAttribGroup)object3, jXTitledSeparator);
                object2 = defaultFormBuilder2.getPanel();
                object = new JButton(AgencyEstateViewValuesPanel.this.minIcon);
                ((AbstractButton)object).addActionListener(new PanelMaximizer((JButton)object, (JPanel)object2));
                defaultFormBuilder.add((Component)jXTitledSeparator).xyw(1, defaultFormBuilder.nextRow(), 3);
                defaultFormBuilder.add((Component)object).xy(5, defaultFormBuilder.row());
                defaultFormBuilder.add((Component)object2).xyw(1, defaultFormBuilder.nextRow(), 5);
            }
            TreeMap treeMap2 = new TreeMap();
            for (OpenEstateAttrib openEstateAttrib : list2) {
                object3 = openEstateAttrib.getTranslation();
                treeMap2.put(object3, openEstateAttrib);
                this.textAreas.put(openEstateAttrib, new TextTabArea(openEstateAttrib, this.locale));
            }
            for (Map.Entry entry : treeMap2.entrySet()) {
                object3 = (OpenEstateAttrib)entry.getValue();
                TextTabArea textTabArea = this.textAreas.get(object3);
                object2 = textTabArea.field.createScrollPane();
                object2.setPreferredSize(new Dimension(100, 65));
                object = new JButton(AgencyEstateViewValuesPanel.this.maxIcon);
                ((AbstractButton)object).addActionListener(new TextMaximizer((JButton)object, (JScrollPane)object2));
                defaultFormBuilder.add((Component)textTabArea.label).xyw(1, defaultFormBuilder.nextRow(), 3);
                defaultFormBuilder.add((Component)object).xy(5, defaultFormBuilder.row());
                defaultFormBuilder.addRaw((Component)object2).xyw(1, defaultFormBuilder.nextRow(), 5);
            }
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane, "Center");
            this.revalidate();
            this.repaint();
        }

        private String getGroupTitle(OpenEstateAttribGroup openEstateAttribGroup) {
            return "<html>" + openEstateAttribGroup.getTranslation() + " <span style=\"font-weight:normal;\">(" + this.locale.getDisplayLanguage() + ")</span></html>";
        }

        public Icon getTabIcon() {
            return ImmoToolUtils.getCountryFlagIcon((Locale)this.locale);
        }

        public String getTabTitle() {
            return this.locale.getDisplayLanguage();
        }

        public String getTabToolTipText() {
            return I18N.tr("This tab contains text attributes for the {0} language.", (Object)this.locale.getDisplayLanguage());
        }

        public void init(OpenEstateType openEstateType, OpenEstateAction openEstateAction, String string, boolean bl) {
            if (openEstateType == null || openEstateAction == null) {
                return;
            }
            if (this.lastType != null && this.lastAction != null && this.lastCountry != null && this.lastType.equals((Object)openEstateType) && this.lastAction.equals((Object)openEstateAction) && this.lastCountry.equals(string)) {
                return;
            }
            this.lastAction = openEstateAction;
            this.lastCountry = string;
            this.lastType = openEstateType;
            AbstractTypeImpl abstractTypeImpl = openEstateType.createImpl();
            EnumMap<OpenEstateAttrib, String> enumMap = new EnumMap<OpenEstateAttrib, String>(OpenEstateAttrib.class);
            if (bl) {
                for (Map.Entry entry2 : this.textAreas.entrySet()) {
                    enumMap.put((OpenEstateAttrib)entry2.getKey(), ((TextTabArea)entry2.getValue()).getText());
                }
                for (Map.Entry<OpenEstateAttrib, TextTabField> entry : this.textFields.entrySet()) {
                    enumMap.put(entry.getKey(), entry.getValue().getText());
                }
            }
            Iterator<Map.Entry<OpenEstateAttrib, TextTabField>> iterator = new ArrayList();
            ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
            for (OpenEstateAttrib openEstateAttrib : abstractTypeImpl.getAttribs(openEstateAction)) {
                AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
                if (string != null && !abstractAttribImpl.isCountrySupported(string) || !(abstractAttribImpl instanceof ComplexStringAttrib)) continue;
                if (OpenEstateAttribGroup.DESCRIPTIONS.equals((Object)openEstateAttrib.getGroup())) {
                    iterator.add((Map.Entry<OpenEstateAttrib, TextTabField>)openEstateAttrib);
                    continue;
                }
                arrayList.add(openEstateAttrib);
            }
            this.buildPanel((List<OpenEstateAttrib>)arrayList, (List<OpenEstateAttrib>)((Object)iterator));
            if (bl) {
                for (Map.Entry entry : this.textAreas.entrySet()) {
                    ((TextTabArea)entry.getValue()).setText((String)enumMap.get(entry.getKey()));
                }
                for (Map.Entry entry : this.textFields.entrySet()) {
                    ((TextTabField)entry.getValue()).setText((String)enumMap.get(entry.getKey()));
                }
            }
        }

        public void load(EstateImpl estateImpl, String string) {
            int n;
            String string2;
            ComplexStringAttrib complexStringAttrib;
            Object object;
            OpenEstateAttrib openEstateAttrib;
            this.init(estateImpl.getType(), estateImpl.getAction(), string, false);
            for (Map.Entry<OpenEstateAttrib, TextTabField> object2 : this.textFields.entrySet()) {
                openEstateAttrib = object2.getKey();
                object = object2.getValue();
                if (!estateImpl.hasAttribute(openEstateAttrib)) {
                    ((TextTabField)object).setText("");
                    continue;
                }
                complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(openEstateAttrib);
                string2 = StringUtils.trimToEmpty((String)complexStringAttrib.getFormattedValue(this.locale));
                n = complexStringAttrib.getMaxLength();
                if (n < 1) {
                    n = 255;
                }
                ((TextTabField)object).setText(StringUtils.abbreviate((String)string2, (int)n));
            }
            for (Map.Entry<OpenEstateAttrib, Object> entry : this.textAreas.entrySet()) {
                openEstateAttrib = entry.getKey();
                object = (TextTabArea)entry.getValue();
                if (!estateImpl.hasAttribute(openEstateAttrib)) {
                    ((TextTabArea)object).setText("");
                    continue;
                }
                complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(openEstateAttrib);
                string2 = StringUtils.trimToEmpty((String)complexStringAttrib.getFormattedValue(this.locale));
                n = complexStringAttrib.getMaxLength();
                if (n > 0) {
                    string2 = StringUtils.abbreviate((String)string2, (int)n);
                }
                ((TextTabArea)object).setText(string2);
            }
            this.modifications.clear();
            for (TextTabArea textTabArea : this.textAreas.values()) {
                this.modifications.putValue((JComponent)textTabArea.field);
            }
            for (TextTabField textTabField : this.textFields.values()) {
                this.modifications.putValue((JComponent)textTabField.field);
            }
        }

        public void save(EstateImpl estateImpl) {
            String string;
            int n;
            ComplexStringAttrib complexStringAttrib;
            Object object;
            OpenEstateAttrib openEstateAttrib;
            for (Map.Entry<OpenEstateAttrib, TextTabField> entry : this.textFields.entrySet()) {
                openEstateAttrib = entry.getKey();
                object = entry.getValue();
                complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(openEstateAttrib);
                if (complexStringAttrib == null) {
                    complexStringAttrib = (ComplexStringAttrib)openEstateAttrib.createImpl();
                }
                if ((n = complexStringAttrib.getMaxLength()) < 1) {
                    n = 255;
                }
                if (!StringUtils.isBlank((CharSequence)(string = StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)((TextTabField)object).getText()), (int)n)))) {
                    complexStringAttrib.putValue(this.locale.getLanguage(), string);
                    estateImpl.putAttribute((AbstractAttribImpl)complexStringAttrib);
                    continue;
                }
                if (!estateImpl.hasAttribute(openEstateAttrib)) continue;
                complexStringAttrib.getValue().remove(this.locale.getLanguage());
                if (complexStringAttrib.hasEmptyValue()) {
                    estateImpl.removeAttribute(openEstateAttrib);
                    continue;
                }
                estateImpl.putAttribute((AbstractAttribImpl)complexStringAttrib);
            }
            for (Map.Entry<OpenEstateAttrib, Object> entry : this.textAreas.entrySet()) {
                openEstateAttrib = entry.getKey();
                object = (TextTabArea)entry.getValue();
                complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(openEstateAttrib);
                if (complexStringAttrib == null) {
                    complexStringAttrib = (ComplexStringAttrib)openEstateAttrib.createImpl();
                }
                n = complexStringAttrib.getMaxLength();
                string = StringUtils.trimToEmpty((String)((TextTabArea)object).getText());
                if (n > 0) {
                    string = StringUtils.abbreviate((String)string, (int)n);
                }
                if (!StringUtils.isBlank((CharSequence)string)) {
                    complexStringAttrib.putValue(this.locale.getLanguage(), string);
                    estateImpl.putAttribute((AbstractAttribImpl)complexStringAttrib);
                    continue;
                }
                if (!estateImpl.hasAttribute(openEstateAttrib)) continue;
                complexStringAttrib.getValue().remove(this.locale.getLanguage());
                if (complexStringAttrib.hasEmptyValue()) {
                    estateImpl.removeAttribute(openEstateAttrib);
                    continue;
                }
                estateImpl.putAttribute((AbstractAttribImpl)complexStringAttrib);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            for (Map.Entry<OpenEstateAttribGroup, JXTitledSeparator> object : this.groupTitles.entrySet()) {
                object.getValue().setTitle(this.getGroupTitle(object.getKey()));
            }
            for (TextTabField textTabField : this.textFields.values()) {
                textTabField.updateLocalization();
            }
            for (TextTabArea textTabArea : this.textAreas.values()) {
                textTabArea.updateLocalization();
            }
        }
    }

    private static class EnergyTab
    extends AbstractTab {
        private final Map<OpenEstateAttrib, Object> values = new EnumMap<OpenEstateAttrib, Object>(OpenEstateAttrib.class);
        private String country = null;
        private JCheckBox certAvailableField;
        private JComboBox<EfficiencyCategory.Option> certClassField;
        private DefaultDatePicker certCreateTimeField;
        private DefaultDatePicker certExpireTimeField;
        private JComboBox<Type.Option> certTypeField;
        private JFormattedTextField certConsumptionTotalField;
        private JFormattedTextField certConsumptionElectricityField;
        private JFormattedTextField certConsumptionHeatingField;
        private JCheckBox certConsumptionIncludesHotWaterField;
        private JFormattedTextField certDemandTotalField;
        private JFormattedTextField certDemandElectricityField;
        private JFormattedTextField certDemandHeatingField;
        private JFormattedTextField austriaHwbField;
        private JFormattedTextField austriaFgeeField;

        private EnergyTab() {
            this.build();
        }

        private void build() {
            boolean bl = Boolean.TRUE.equals(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_AVAILABLE));
            Type.Option option = (Type.Option)this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_TYPE);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setGroupingUsed(false);
            numberFormat.setMaximumFractionDigits(2);
            this.removeAll();
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)new JXTitledSeparator(StringUtils.capitalize((String)I18N.tr("energy certificate for the property")))).xyw(1, defaultFormBuilder.nextRow(), 7);
            this.certAvailableField = new JCheckBox();
            this.certAvailableField.setText(OpenEstateAttrib.ENERGY_CERTIFICATE_AVAILABLE.getTranslation());
            this.certAvailableField.setSelected(bl);
            this.certAvailableField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EnergyTab.this.rebuild();
                }
            });
            defaultFormBuilder.add((Component)this.certAvailableField).xyw(3, defaultFormBuilder.nextRow(), 5);
            this.certTypeField = new JComboBox();
            this.certTypeField.addItem(null);
            for (Type.Option option2 : Type.Option.values()) {
                this.certTypeField.addItem(option2);
            }
            this.certTypeField.setRenderer((ListCellRenderer<Type.Option>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<Type.Option>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("please select") + " ]";
                }
            }));
            this.certTypeField.setSelectedItem(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_TYPE));
            this.certTypeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (EnergyTab.this.certTypeField.isEnabled()) {
                        EnergyTab.this.rebuild();
                    }
                }
            });
            this.certTypeField.setEnabled(bl);
            defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_TYPE.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.certTypeField).xy(3, defaultFormBuilder.row());
            this.certCreateTimeField = new DefaultDatePicker();
            this.certCreateTimeField.setDate((Date)this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_CREATION_DATE));
            this.certCreateTimeField.setEnabled(bl);
            defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_CREATION_DATE.getTranslation() + ":")).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.certCreateTimeField).xy(7, defaultFormBuilder.row());
            this.certClassField = new JComboBox();
            this.certClassField.addItem(null);
            for (Type.Option option2 : EfficiencyCategory.Option.values()) {
                this.certClassField.addItem((EfficiencyCategory.Option)option2);
            }
            this.certClassField.setRenderer((ListCellRenderer<EfficiencyCategory.Option>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<EfficiencyCategory.Option>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("please select") + " ]";
                }
            }));
            this.certClassField.setSelectedItem(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_EFFICIENCY_CATEGORY));
            this.certClassField.setEnabled(bl);
            defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_EFFICIENCY_CATEGORY.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.certClassField).xy(3, defaultFormBuilder.row());
            this.certExpireTimeField = new DefaultDatePicker();
            this.certExpireTimeField.setDate((Date)this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_EXPIRATION_DATE));
            this.certExpireTimeField.setEnabled(bl);
            defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_EXPIRATION_DATE.getTranslation() + ":")).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.certExpireTimeField).xy(7, defaultFormBuilder.row());
            if (Type.Option.CONSUMPTION.equals((Object)option)) {
                defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
                defaultFormBuilder.add((Component)new JXTitledSeparator(StringUtils.capitalize((String)I18N.tr("details about energy consumption")))).xyw(1, defaultFormBuilder.nextRow(), 7);
                this.certConsumptionTotalField = new NullableFormattedTextField((Format)numberFormat);
                this.certConsumptionTotalField.setValue(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_TOTAL));
                this.certConsumptionTotalField.setEnabled(bl);
                defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_TOTAL.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
                defaultFormBuilder.add((Component)this.certConsumptionTotalField).xy(3, defaultFormBuilder.row());
                defaultFormBuilder.add((Component)new JLabel(EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR.write(), 2)).xyw(5, defaultFormBuilder.row(), 3);
                this.certConsumptionElectricityField = new NullableFormattedTextField((Format)numberFormat);
                this.certConsumptionElectricityField.setValue(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_ELECTRICITY));
                this.certConsumptionElectricityField.setEnabled(bl);
                defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_ELECTRICITY.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
                defaultFormBuilder.add((Component)this.certConsumptionElectricityField).xy(3, defaultFormBuilder.row());
                defaultFormBuilder.add((Component)new JLabel(EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR.write(), 2)).xyw(5, defaultFormBuilder.row(), 3);
                this.certConsumptionHeatingField = new NullableFormattedTextField((Format)numberFormat);
                this.certConsumptionHeatingField.setValue(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_HEATING));
                this.certConsumptionHeatingField.setEnabled(bl);
                defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_HEATING.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
                defaultFormBuilder.add((Component)this.certConsumptionHeatingField).xy(3, defaultFormBuilder.row());
                defaultFormBuilder.add((Component)new JLabel(EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR.write(), 2)).xyw(5, defaultFormBuilder.row(), 3);
                this.certConsumptionIncludesHotWaterField = new JCheckBox();
                this.certConsumptionIncludesHotWaterField.setText(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_INCLUDING_HOT_WATER.getTranslation());
                this.certConsumptionIncludesHotWaterField.setSelected(Boolean.TRUE.equals(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_INCLUDING_HOT_WATER)));
                this.certConsumptionIncludesHotWaterField.setEnabled(bl);
                defaultFormBuilder.add((Component)this.certConsumptionIncludesHotWaterField).xyw(3, defaultFormBuilder.nextRow(), 5);
            } else if (Type.Option.DEMAND.equals((Object)option)) {
                defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
                defaultFormBuilder.add((Component)new JXTitledSeparator(StringUtils.capitalize((String)I18N.tr("details about energy demand")))).xyw(1, defaultFormBuilder.nextRow(), 7);
                this.certDemandTotalField = new NullableFormattedTextField((Format)numberFormat);
                this.certDemandTotalField.setValue(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_TOTAL));
                this.certDemandTotalField.setEnabled(bl);
                defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_TOTAL.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
                defaultFormBuilder.add((Component)this.certDemandTotalField).xy(3, defaultFormBuilder.row());
                defaultFormBuilder.add((Component)new JLabel(EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR.write(), 2)).xyw(5, defaultFormBuilder.row(), 3);
                this.certDemandElectricityField = new NullableFormattedTextField((Format)numberFormat);
                this.certDemandElectricityField.setValue(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_ELECTRICITY));
                this.certDemandElectricityField.setEnabled(bl);
                defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_ELECTRICITY.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
                defaultFormBuilder.add((Component)this.certDemandElectricityField).xy(3, defaultFormBuilder.row());
                defaultFormBuilder.add((Component)new JLabel(EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR.write(), 2)).xyw(5, defaultFormBuilder.row(), 3);
                this.certDemandHeatingField = new NullableFormattedTextField((Format)numberFormat);
                this.certDemandHeatingField.setValue(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_HEATING));
                this.certDemandHeatingField.setEnabled(bl);
                defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_HEATING.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
                defaultFormBuilder.add((Component)this.certDemandHeatingField).xy(3, defaultFormBuilder.row());
                defaultFormBuilder.add((Component)new JLabel(EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR.write(), 2)).xyw(5, defaultFormBuilder.row(), 3);
            }
            if ("at".equalsIgnoreCase(this.country)) {
                defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
                defaultFormBuilder.add((Component)new JXTitledSeparator(StringUtils.capitalize((String)I18N.tr("further details for austria")))).xyw(1, defaultFormBuilder.nextRow(), 7);
                this.austriaHwbField = new NullableFormattedTextField((Format)numberFormat);
                this.austriaHwbField.setValue(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_AUSTRIA_THERMAL_HEAT_DEMAND));
                this.austriaHwbField.setEnabled(bl);
                defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_AUSTRIA_THERMAL_HEAT_DEMAND.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
                defaultFormBuilder.add((Component)this.austriaHwbField).xy(3, defaultFormBuilder.row());
                defaultFormBuilder.add((Component)new JLabel(EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR.write(), 2)).xyw(5, defaultFormBuilder.row(), 3);
                this.austriaFgeeField = new NullableFormattedTextField((Format)numberFormat);
                this.austriaFgeeField.setValue(this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_AUSTRIA_TOTAL_ENERGY_EFFICIENCY_FACTOR));
                this.austriaFgeeField.setEnabled(bl);
                defaultFormBuilder.add((Component)new JLabel(OpenEstateAttrib.ENERGY_CERTIFICATE_AUSTRIA_TOTAL_ENERGY_EFFICIENCY_FACTOR.getTranslation() + ":")).xy(1, defaultFormBuilder.nextRow());
                defaultFormBuilder.add((Component)this.austriaFgeeField).xy(3, defaultFormBuilder.row());
            }
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane, "Center");
            this.revalidate();
            this.repaint();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)OpenEstateAttribGroup.ENERGY_CERTIFICATE.getTranslation());
        }

        public void load(DbAgencyObject dbAgencyObject) {
            this.values.clear();
            this.country = null;
            if (dbAgencyObject != null && dbAgencyObject.item != null) {
                this.country = dbAgencyObject.item.getAddress() != null ? StringUtils.trimToNull((String)dbAgencyObject.item.getAddress().getCountry()) : null;
                for (OpenEstateAttrib openEstateAttrib : OpenEstateAttribGroup.ENERGY_CERTIFICATE.getAttributes()) {
                    AbstractAttribImpl abstractAttribImpl = dbAgencyObject.item.getAttribute(openEstateAttrib);
                    if (abstractAttribImpl == null) continue;
                    this.values.put(openEstateAttrib, abstractAttribImpl.getValue());
                }
                Type.Option option = (Type.Option)this.values.get(OpenEstateAttrib.ENERGY_CERTIFICATE_TYPE);
                if (option != null) {
                    this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_AVAILABLE, Boolean.TRUE);
                }
            }
            this.certAvailableField = null;
            this.certClassField = null;
            this.certCreateTimeField = null;
            this.certExpireTimeField = null;
            this.certTypeField = null;
            this.certConsumptionTotalField = null;
            this.certConsumptionElectricityField = null;
            this.certConsumptionHeatingField = null;
            this.certConsumptionIncludesHotWaterField = null;
            this.certDemandTotalField = null;
            this.certDemandElectricityField = null;
            this.certDemandHeatingField = null;
            this.austriaHwbField = null;
            this.austriaFgeeField = null;
            this.removeAll();
            this.build();
        }

        private void rebuild() {
            this.removeAll();
            if (this.certAvailableField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_AVAILABLE, this.certAvailableField.isSelected());
            }
            this.certAvailableField = null;
            if (this.certClassField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_EFFICIENCY_CATEGORY, this.certClassField.getSelectedItem());
            }
            this.certClassField = null;
            if (this.certCreateTimeField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_CREATION_DATE, this.certCreateTimeField.getDate());
            }
            this.certCreateTimeField = null;
            if (this.certExpireTimeField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_EXPIRATION_DATE, this.certExpireTimeField.getDate());
            }
            this.certExpireTimeField = null;
            if (this.certTypeField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_TYPE, this.certTypeField.getSelectedItem());
            }
            this.certTypeField = null;
            if (this.certConsumptionTotalField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_TOTAL, this.certConsumptionTotalField.getValue());
            }
            this.certConsumptionTotalField = null;
            if (this.certConsumptionElectricityField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_ELECTRICITY, this.certConsumptionElectricityField.getValue());
            }
            this.certConsumptionElectricityField = null;
            if (this.certConsumptionHeatingField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_HEATING, this.certConsumptionHeatingField.getValue());
            }
            this.certConsumptionHeatingField = null;
            if (this.certConsumptionIncludesHotWaterField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_CONSUMPTION_INCLUDING_HOT_WATER, this.certConsumptionIncludesHotWaterField.isSelected());
            }
            this.certConsumptionIncludesHotWaterField = null;
            if (this.certDemandTotalField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_TOTAL, this.certDemandTotalField.getValue());
            }
            this.certDemandTotalField = null;
            if (this.certDemandElectricityField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_ELECTRICITY, this.certDemandElectricityField.getValue());
            }
            this.certDemandElectricityField = null;
            if (this.certDemandHeatingField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_DEMAND_HEATING, this.certDemandHeatingField.getValue());
            }
            this.certDemandHeatingField = null;
            if (this.austriaHwbField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_AUSTRIA_THERMAL_HEAT_DEMAND, this.austriaHwbField.getValue());
            }
            this.austriaHwbField = null;
            if (this.austriaFgeeField != null) {
                this.values.put(OpenEstateAttrib.ENERGY_CERTIFICATE_AUSTRIA_TOTAL_ENERGY_EFFICIENCY_FACTOR, this.austriaFgeeField.getValue());
            }
            this.austriaFgeeField = null;
            this.build();
        }

        public void save(DbAgencyObject dbAgencyObject) {
            if (dbAgencyObject == null || dbAgencyObject.item == null) {
                return;
            }
            AbstractTypeImpl abstractTypeImpl = dbAgencyObject.item.getTypeSpec();
            for (OpenEstateAttrib openEstateAttrib : OpenEstateAttribGroup.ENERGY_CERTIFICATE.getAttributes()) {
                if (!dbAgencyObject.item.hasAttribute(openEstateAttrib)) continue;
                dbAgencyObject.item.removeAttribute(openEstateAttrib);
            }
            if (abstractTypeImpl == null || !abstractTypeImpl.hasAttrib(OpenEstateAttrib.ENERGY_CERTIFICATE_AVAILABLE)) {
                return;
            }
            if (this.certAvailableField != null) {
                Available.put((EstateImpl)dbAgencyObject.item, (Boolean)this.certAvailableField.isSelected());
            }
            if (this.certClassField != null && this.certClassField.isEnabled()) {
                EfficiencyCategory.put((EstateImpl)dbAgencyObject.item, (EfficiencyCategory.Option)((EfficiencyCategory.Option)this.certClassField.getSelectedItem()));
            }
            if (this.certCreateTimeField != null && this.certCreateTimeField.isEnabled()) {
                CreationDate.put((EstateImpl)dbAgencyObject.item, (Date)this.certCreateTimeField.getDate());
            }
            if (this.certExpireTimeField != null && this.certExpireTimeField.isEnabled()) {
                ExpirationDate.put((EstateImpl)dbAgencyObject.item, (Date)this.certExpireTimeField.getDate());
            }
            if (this.certTypeField != null && this.certTypeField.isEnabled()) {
                Type.put((EstateImpl)dbAgencyObject.item, (Type.Option)((Type.Option)this.certTypeField.getSelectedItem()));
            }
            if (this.certConsumptionTotalField != null && this.certConsumptionTotalField.isEnabled()) {
                ConsumptionTotal.put((EstateImpl)dbAgencyObject.item, (Number)((Number)this.certConsumptionTotalField.getValue()), (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            }
            if (this.certConsumptionElectricityField != null && this.certConsumptionElectricityField.isEnabled()) {
                ConsumptionElectricity.put((EstateImpl)dbAgencyObject.item, (Number)((Number)this.certConsumptionElectricityField.getValue()), (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            }
            if (this.certConsumptionHeatingField != null && this.certConsumptionHeatingField.isEnabled()) {
                ConsumptionHeating.put((EstateImpl)dbAgencyObject.item, (Number)((Number)this.certConsumptionHeatingField.getValue()), (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            }
            if (this.certConsumptionIncludesHotWaterField != null && this.certConsumptionIncludesHotWaterField.isEnabled()) {
                ConsumptionIncludingHotWater.put((EstateImpl)dbAgencyObject.item, (Boolean)this.certConsumptionIncludesHotWaterField.isSelected());
            }
            if (this.certDemandTotalField != null && this.certDemandTotalField.isEnabled()) {
                DemandTotal.put((EstateImpl)dbAgencyObject.item, (Number)((Number)this.certDemandTotalField.getValue()), (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            }
            if (this.certDemandElectricityField != null && this.certDemandElectricityField.isEnabled()) {
                DemandElectricity.put((EstateImpl)dbAgencyObject.item, (Number)((Number)this.certDemandElectricityField.getValue()), (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            }
            if (this.certDemandHeatingField != null && this.certDemandHeatingField.isEnabled()) {
                DemandHeating.put((EstateImpl)dbAgencyObject.item, (Number)((Number)this.certDemandHeatingField.getValue()), (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            }
            if (this.austriaHwbField != null && this.austriaHwbField.isEnabled()) {
                AustriaThermalHeatDemand.put((EstateImpl)dbAgencyObject.item, (Number)((Number)this.austriaHwbField.getValue()), (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            }
            if (this.austriaFgeeField != null && this.austriaFgeeField.isEnabled()) {
                AustriaTotalEnergyEfficiencyFactor.put((EstateImpl)dbAgencyObject.item, (Number)((Number)this.austriaFgeeField.getValue()));
            }
        }

        public void setCountry(String string) {
            if (this.country == null) {
                if (string != null) {
                    this.country = string;
                    this.rebuild();
                }
            } else if (!this.country.equalsIgnoreCase(string)) {
                this.country = string;
                this.rebuild();
            }
        }

        protected void updateLocalization() {
            EnergyTab.super.updateLocalization();
            this.rebuild();
        }
    }

    private static class AttributeTab
    extends AbstractTab {
        private JScrollPane scrollPane;
        private AgencyEstateValueTable table;

        private AttributeTab() {
            this.build();
            this.hideTable();
        }

        private void build() {
            this.table = new AgencyEstateValueTable();
            ImmoToolUtils.configureTable((JXTable)this.table);
            this.table.setBorder(BorderFactory.createLineBorder(ImmoToolUtils.TABLE_HIGHLIGHT_COLOR));
            this.scrollPane = new JScrollPane((Component)((Object)this.table));
            this.scrollPane.setBorder(Paddings.EMPTY);
            this.scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(this.scrollPane, "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("attributes of the property"));
        }

        public String getTabToolTipText() {
            return I18N.tr("This tab contains a table of language-independent attributes.");
        }

        private void hideTable() {
            this.scrollPane.setVisible(false);
            this.table.setEnabled(false);
        }

        public void init(OpenEstateType openEstateType, OpenEstateAction openEstateAction, String string, boolean bl) {
            this.table.loadEstateType(openEstateType, openEstateAction, string, bl);
            this.table.packAll();
            this.table.expandAll();
        }

        private void showTable() {
            this.scrollPane.setVisible(true);
            this.table.setEnabled(true);
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }
}

