/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolSettings;
import com.openindex.openestate.tool.ImmoToolSetupDialog;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencySetupGeoPanel
extends ImmoToolSetupDialog.AbstractForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencySetupGeoPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencySetupGeoPanel.class);
    private static final String TABLE_ID = "AgencySetupGeoPanel.Table";
    private final Map<String, DbGeo> importedGeoDbs = new HashMap<String, DbGeo>();
    private JXTitledSeparator geoDbTitle;
    private JLabel geoDbInfoLabel;
    private Table geoDbTable;
    private AbstractI18nAction geoDbImportAction;
    private AbstractI18nAction geoDbRemoveAction;

    public AgencySetupGeoPanel() {
        this.build();
        this.updateLocalization();
    }

    private void build() {
        this.geoDbTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.geoDbImportAction = new GeoDbImportAction();
        this.geoDbRemoveAction = new GeoDbRemoveAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.geoDbTitle, (Action[])new Action[]{this.geoDbImportAction, this.geoDbRemoveAction});
        this.geoDbInfoLabel = new JLabel();
        this.geoDbTable = new Table();
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"pref:grow");
        defaultFormBuilder.add((Component)jPanel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.geoDbInfoLabel).xy(1, defaultFormBuilder.nextRow());
        this.setLayout(new BorderLayout(5, 5));
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(this.geoDbTable.createScrollPane(), "Center");
    }

    private void doGeoDbImport() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(StringUtils.capitalize((String)I18N.tr("import geographic database")));
        jFileChooser.setApproveButtonText(StringUtils.capitalize((String)I18N.tr("select geodb file")));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return I18N.tr("geodb files") + " (*.xml)";
            }
        });
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new GeoDbImportTask(jFileChooser.getSelectedFile()));
    }

    private void doGeoDbRemove() {
        int n = this.geoDbTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        DbGeo dbGeo = this.geoDbTable.getGeoAt(n);
        String string = dbGeo.name;
        String string2 = null;
        for (Map.Entry<String, DbGeo> entry : this.importedGeoDbs.entrySet()) {
            String string3 = entry.getKey();
            DbGeo dbGeo2 = entry.getValue();
            if (!dbGeo2.name.equals(string)) continue;
            string2 = string3;
            File file = new File(string3);
            if (!file.isFile() || file.delete()) break;
            LOGGER.warn("Can't delete file: " + file.getAbsolutePath());
            break;
        }
        if (string2 != null) {
            this.importedGeoDbs.remove(string2);
        }
        this.geoDbTable.removeRow(n);
        this.geoDbTable.packAll();
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("geodata"));
    }

    public boolean isProjectRequired() {
        return true;
    }

    public void load(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        DbGeoHandler dbGeoHandler = AgencyPlugin.getDbAgencyExtension().getGeoHandler();
        this.importedGeoDbs.clear();
        this.geoDbTable.clearSelection();
        this.geoDbTable.clearRows();
        for (DbGeo dbGeo : dbGeoHandler.getGeoDbs(connection)) {
            this.geoDbTable.addRow(new TableRow(dbGeo));
        }
        this.geoDbTable.packAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        DbGeoHandler dbGeoHandler = AgencyPlugin.getDbAgencyExtension().getGeoHandler();
        this.setButtonsEnabled(false);
        try {
            for (String string : this.importedGeoDbs.keySet()) {
                DbGeo dbGeo;
                LOGGER.debug("Read Geo-XML");
                File file = new File(string);
                LOGGER.debug("> " + file.getAbsolutePath());
                if (!file.isFile()) continue;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    Document document = OpenEstateUtils.loadDocument((InputStream)fileInputStream);
                    dbGeo = new GeoImpl();
                    dbGeo.readFromXml(document);
                }
                catch (DocumentException documentException) {
                    throw new IOException("Can't parse Geo-XML!", documentException);
                }
                if (dbGeo == null) continue;
                LOGGER.debug("Save Geo-DB");
                LOGGER.debug("> " + dbGeo.getName());
                dbGeoHandler.mergeFromXml(connection, (GeoImpl)dbGeo);
            }
            for (DbGeo dbGeo : dbGeoHandler.getGeoDbs(connection)) {
                int n = this.geoDbTable.getRowForGeo(dbGeo);
                if (n >= 0) continue;
                LOGGER.debug("Remove Geo-DB #" + dbGeo.id + " (" + dbGeo.name + ")");
                dbGeoHandler.removeGeoDb(connection, dbGeo.id);
            }
        }
        finally {
            this.setButtonsEnabled(true);
        }
    }

    public void setButtonsEnabled(boolean bl) {
        this.geoDbImportAction.setEnabled(bl);
        this.geoDbRemoveAction.setEnabled(bl);
        this.geoDbTable.setEnabled(bl);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.geoDbTitle.setTitle(StringUtils.capitalize((String)I18N.tr("manage geographic databases")));
        this.geoDbInfoLabel.setText("<html>" + I18N.tr("Manage geographic databases from external providers.") + "</html>");
    }

    private class GeoDbRemoveAction
    extends AbstractI18nAction {
        private GeoDbRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySetupGeoPanel.this.doGeoDbRemove();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove the selected geographic database."));
        }
    }

    private class GeoDbImportTask
    extends ImmoToolTask<File, Void> {
        private final File geoDbFile;
        private DbGeo geoDb = null;
        private int overwriteTableRow = -1;

        private GeoDbImportTask(File file) {
            this.geoDbFile = file;
        }

        protected File doInBackground() throws Exception {
            Object object;
            GeoImpl geoImpl = new GeoImpl();
            try (Object object2 = new FileInputStream(this.geoDbFile);){
                object = OpenEstateUtils.loadDocument((InputStream)object2);
                geoImpl.readFromXmlNonRecursive((Document)object);
            }
            if (geoImpl.getName() == null || geoImpl.getProvider() == null) {
                throw new Exception("Can't read geo.xml!");
            }
            this.geoDb = DbGeo.createFromXml((GeoImpl)geoImpl);
            this.overwriteTableRow = AgencySetupGeoPanel.this.geoDbTable.getRowForGeo(this.geoDb);
            if (this.overwriteTableRow >= 0 && !ImmoToolUtils.showQuestionDialog((String)(object2 = "<html><b>" + I18N.tr("A geographical database with the name {0} does already exist!", (Object)(StringEscapeUtils.escapeXml11((String)("'" + this.geoDb.name)) + "'")) + "</b><br>" + I18N.tr("Do you want to overwrite the existing geographical database with the selected file?") + "</html>"), (Component)((Object)AgencySetupGeoPanel.this))) {
                return null;
            }
            object2 = new FileInputStream(this.geoDbFile);
            var3_3 = null;
            try {
                object = File.createTempFile("geo", ".xml");
                ((File)object).deleteOnExit();
                ImmoToolUtils.writeStreamToFile((InputStream)object2, (File)object);
                Object object3 = object;
                return object3;
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (var3_3 != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)("<html><b>" + I18N.tr("Can't import geographical data!") + "</b><br>" + StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage()) + "</html>"), (Component)((Object)AgencySetupGeoPanel.this));
        }

        protected void finished() {
            super.finished();
            AgencySetupGeoPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(File file) {
            super.succeeded((Object)file);
            if (file == null) {
                return;
            }
            AgencySetupGeoPanel.this.importedGeoDbs.put(file.getAbsolutePath(), this.geoDb);
            if (this.overwriteTableRow < 0) {
                AgencySetupGeoPanel.this.geoDbTable.addRow(new TableRow(this.geoDb));
            } else {
                AgencySetupGeoPanel.this.geoDbTable.setGeoAt(this.overwriteTableRow, this.geoDb);
            }
            AgencySetupGeoPanel.this.geoDbTable.packAll();
        }
    }

    private class GeoDbImportAction
    extends AbstractI18nAction {
        private GeoDbImportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencySetupGeoPanel.this.doGeoDbImport();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("import")));
            this.setShortDescription(I18N.tr("Import a geographic database from an external XML file."));
        }
    }

    private static class TableRow
    extends AbstractTable.Row {
        private final DbGeo geo;

        private TableRow(DbGeo dbGeo) {
            this.geo = dbGeo;
        }

        public DbGeo getGeo() {
            return this.geo;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof TableColumn) {
                return this.getValueForGeo((TableColumn)column);
            }
            return null;
        }

        private Object getValueForGeo(TableColumn tableColumn) {
            if (this.geo == null) {
                return null;
            }
            switch (tableColumn) {
                case GEODB: {
                    return this.geo.name;
                }
                case PROVIDER: {
                    return StringUtils.trimToEmpty((String)this.geo.provider);
                }
                case BUILDTIME: {
                    return this.geo.buildTime;
                }
            }
            return null;
        }
    }

    private static enum TableColumn implements AbstractTable.Column
    {
        GEODB,
        PROVIDER,
        BUILDTIME;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case BUILDTIME: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer(DateFormat.getDateTimeInstance(2, 3)));
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case BUILDTIME: {
                    return Date.class;
                }
                case GEODB: {
                    return DbGeo.class;
                }
                case PROVIDER: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case BUILDTIME: {
                    return StringUtils.capitalize((String)I18N.tr("created at"));
                }
                case GEODB: {
                    return StringUtils.capitalize((String)I18N.tr("name"));
                }
                case PROVIDER: {
                    return StringUtils.capitalize((String)I18N.tr("provider"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private static class Table
    extends AbstractTable<TableRow, AbstractTable.Model<TableRow>> {
        public Table() {
            super(AgencySetupGeoPanel.TABLE_ID);
        }

        private DbGeo getGeoAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getGeo() : null;
        }

        private int getRowForGeo(DbGeo dbGeo) {
            return dbGeo != null ? this.getRowForGeo(dbGeo.name) : -1;
        }

        private int getRowForGeo(String string) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                DbGeo dbGeo = this.getGeoAt(i);
                if (dbGeo == null || !dbGeo.name.equals(string)) continue;
                return i;
            }
            return -1;
        }

        protected void init() {
            this.setSingleSelection();
            this.setSortable(true);
            this.setColumnControlVisible(false);
            super.init();
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(TableColumn.values()));
        }

        private void setGeoAt(int n, DbGeo dbGeo) {
            this.setRowAt(n, new TableRow(dbGeo));
        }
    }
}

