/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.ImmobiliareXmlFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultWebLinkField;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmobiliareXmlFormatPanel
extends AbstractFormatPanel<ImmobiliareXmlFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareXmlFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmobiliareXmlFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel baseUrlLabel;
    private DefaultWebLinkField baseUrlField;
    private JLabel agentMailLabel;
    private JTextField agentMailField;
    private JLabel technMailLabel;
    private JTextField technMailField;
    private JLabel optionsLabel;
    private JCheckBox publicIdBox;
    private JCheckBox zipExportBox;
    private JCheckBox energyCertificateBox;

    public ImmobiliareXmlFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.baseUrlLabel = new JLabel();
        this.baseUrlField = new DefaultWebLinkField(false);
        this.zipExportBox = new JCheckBox();
        this.publicIdBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.technMailLabel = new JLabel();
        this.technMailField = new JTextField();
        this.agentMailLabel = new JLabel();
        this.agentMailField = new JTextField();
        this.validationHandler.putRule((JComponent)this.baseUrlField, ValidationHandler.URL);
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        this.validationHandler.putRule((JComponent)this.agentMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu");
        defaultFormBuilder.add((Component)this.baseUrlLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.baseUrlField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.technMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.technMailField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.agentMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentMailField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.publicIdBox).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.zipExportBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.energyCertificateBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        this.setLayout(new BorderLayout(5, 5));
        this.add(defaultFormBuilder.getPanel(), "Center");
        this.updateLocalization();
        this.load((DbAgencyExport)null, (ImmobiliareXmlFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        list.add(AgencyPluginUtils.Message.FULL_EXPORT_WARNING.getTranslation());
        if (this.publicIdBox.isSelected()) {
            list.add(AgencyPluginUtils.Message.PROPERTY_NR_IDENTIFICATION_WARNING.getTranslation());
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, ImmobiliareXmlFormat immobiliareXmlFormat) {
        if (immobiliareXmlFormat == null) {
            this.agentMailField.setText("");
            this.baseUrlField.setUrl(null);
            this.energyCertificateBox.setSelected(false);
            this.publicIdBox.setSelected(false);
            this.technMailField.setText("");
            this.zipExportBox.setSelected(false);
        } else {
            this.agentMailField.setText(immobiliareXmlFormat.getAgentMail());
            this.baseUrlField.setUrl(immobiliareXmlFormat.getImmobiliareBaseUrl());
            this.energyCertificateBox.setSelected(immobiliareXmlFormat.isPropertyDescriptionWithEnergyCertificate());
            this.publicIdBox.setSelected(immobiliareXmlFormat.isPropertyPublicId());
            this.technMailField.setText(immobiliareXmlFormat.getImmobiliarePublisherMail());
            this.zipExportBox.setSelected(AbstractFormat.Compression.ZIP.equals((Object)immobiliareXmlFormat.getCompression()));
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, ImmobiliareXmlFormat immobiliareXmlFormat) {
        if (immobiliareXmlFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        immobiliareXmlFormat.setAgentMail(this.agentMailField.getText().trim());
        immobiliareXmlFormat.setImmobiliareBaseUrl(this.baseUrlField.isEnabled() ? this.baseUrlField.getUrl() : null);
        immobiliareXmlFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
        immobiliareXmlFormat.setPropertyPublicId(this.publicIdBox.isSelected());
        immobiliareXmlFormat.setImmobiliarePublisherMail(this.technMailField.getText().trim());
        immobiliareXmlFormat.setCompression(this.zipExportBox.isSelected() ? AbstractFormat.Compression.ZIP : AbstractFormat.Compression.UNCOMPRESSED);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.baseUrlLabel.setText(StringUtils.capitalize((String)I18N.tr("base-URL")) + ":");
        this.baseUrlField.setToolTipText(I18N.tr("This URL points to the location at your webspace, where the exported files are stored."));
        this.technMailLabel.setText(StringUtils.capitalize((String)I18N.tr("support-mail")) + ":");
        this.technMailField.setToolTipText(I18N.tr("Enter your e-mail address for technical feedback. Some recipients are sending their protocols to this address."));
        this.agentMailLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-mail")) + ":");
        this.agentMailField.setToolTipText(I18N.tr("Enter your e-mail address, that identifies your account in the recipients database."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.publicIdBox.setText(I18N.tr("Use property number for identification."));
        this.publicIdBox.setToolTipText(I18N.tr("Enable this option to export the property number instead of the property ID."));
        this.zipExportBox.setText(I18N.tr("Compress exported files into a ZIP-archive."));
        this.zipExportBox.setToolTipText(I18N.tr("Compressing the exported files into a ZIP-archive will reduce the total file size of the export."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

