/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.wis_it.WisItWriter;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.WohnenInSuedtirolItFormatPanel;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.wis_it.WisItDocument;
import org.openestate.io.wis_it.WisItUtils;
import org.openestate.io.wis_it.xml.ObjectType;
import org.openestate.io.wis_it.xml.WIS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WohnenInSuedtirolItFormat
extends AbstractXmlFormat<WIS> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(WohnenInSuedtirolItFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(WohnenInSuedtirolItFormat.class);
    private static final String NAME = "wis_it";
    public static final String GEODB = "wis_it";
    private transient String preparedObjectId = null;
    private transient int preparedObjectImgCount = 0;
    private transient int preparedObjectDocCount = 0;

    protected WisItWriter buildWriter() {
        return this.buildWriter(null, null);
    }

    private Writer buildWriter(ExportContext exportContext) {
        return exportContext != null ? this.buildWriter(exportContext.dbDriver, exportContext.dbExtension) : this.buildWriter(null, null);
    }

    private Writer buildWriter(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
        Writer writer = new Writer(this.getLanguage(), abstractDbDriver, dbAgencyExtension);
        writer.setXmlLineSeparator("<br/>");
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        String string;
        WIS wIS;
        Object object;
        GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea("wis_it");
        if (geoAreaImpl == null) {
            throw new AbstractFormat.NotExportableException("No region selected!");
        }
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            object = this.buildWriter();
            object.setXmlLineSeparator("<br/>");
            wIS = (WIS)object.writeToObject(agencyImpl);
            string = object.getErrorMessages(estateImpl.getId());
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert property #" + l + "!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            throw new AbstractFormat.NotExportableException("Can't convert property #" + l + "! (" + exception.getLocalizedMessage() + ")", exception);
        }
        if (wIS == null) throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        if (string != null) {
            throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        }
        wIS.setBENUTZER(null);
        if (wIS.getOBJEKTE() != null) {
            wIS.getOBJEKTE().setANZAHL(null);
        }
        try {
            object = new StringWriter();
            Throwable throwable = null;
            try {
                WisItUtils.createMarshaller((String)"UTF-8", (boolean)false).marshal((Object)wIS, (java.io.Writer)object);
                String string2 = ((StringWriter)object).toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
                String string3 = DigestUtils.sha1Hex((String)string2);
                return string3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((StringWriter)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((StringWriter)object).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AbstractFormat.HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    protected boolean canPublishAttachment(String string, EstateAttachmentImpl estateAttachmentImpl) {
        if (!super.canPublishAttachment(string, estateAttachmentImpl)) {
            return false;
        }
        if (this.preparedObjectId == null || !this.preparedObjectId.equals(string)) {
            this.preparedObjectId = string;
            this.preparedObjectImgCount = 0;
            this.preparedObjectDocCount = 0;
        }
        if (estateAttachmentImpl.getMimeType().toLowerCase().startsWith("image/")) {
            if (this.preparedObjectImgCount >= 10) {
                return false;
            }
            ++this.preparedObjectImgCount;
            return true;
        }
        if (this.preparedObjectDocCount >= 3) {
            return false;
        }
        ++this.preparedObjectDocCount;
        return true;
    }

    @Override
    protected WIS convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        Writer writer = this.buildWriter(exportContext);
        WIS wIS = writer.writeToObject(transferImpl);
        if (wIS == null) {
            return null;
        }
        if (wIS.getBENUTZER() == null) {
            wIS.setBENUTZER(WisItUtils.getFactory().createWISBENUTZER());
        }
        wIS.getBENUTZER().setKDNR(this.getAgentId());
        exportContext.addErrorMessages(writer.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return wIS;
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new WohnenInSuedtirolItFormatPanel();
    }

    @Override
    public String getName() {
        return "wis_it";
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL};
    }

    @Override
    public String getTitle() {
        return "Portal: Wohnen-in-Suedtirol.it";
    }

    @Override
    protected String getXmlFileName(ExportContext exportContext) {
        return "WIS_IMPORT.XML";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
    }

    @Override
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea("wis_it");
        if (geoAreaImpl == null) {
            return false;
        }
        this.preparedObjectId = null;
        this.preparedObjectImgCount = 0;
        this.preparedObjectDocCount = 0;
        if (!super.prepareObjectForExport(l, estateImpl)) {
            return false;
        }
        estateImpl.removeCustomGeoAreas();
        estateImpl.putCustomGeoArea("wis_it", geoAreaImpl);
        return true;
    }

    @Override
    protected void writeXmlObject(WIS wIS, java.io.Writer writer) throws IOException, JAXBException {
        try {
            WisItDocument wisItDocument = WisItDocument.newDocument((WIS)wIS);
            wisItDocument.toXml(writer, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't create parser!", parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Can't write document!", transformerException);
        }
    }

    public static class Writer
    extends WisItWriter {
        private final Map<Long, DbGeoArea> areas;
        private final AbstractDbDriver dbDriver;
        private final DbAgencyExtension dbExtension;
        private Connection dbConnection = null;

        public Writer(Locale locale) {
            this(locale, null, null);
        }

        public Writer(Locale locale, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
            super(locale);
            this.dbDriver = abstractDbDriver;
            this.dbExtension = dbAgencyExtension;
            this.areas = new HashMap<Long, DbGeoArea>();
            AgencyPluginUtils.initJAXB(WisItUtils.class);
        }

        public ObjectType convertEstate(EstateImpl estateImpl, List<String> list) {
            ObjectType objectType = super.convertEstate(estateImpl, list);
            if (objectType == null || !list.isEmpty()) {
                return null;
            }
            if (this.dbDriver != null) {
                DbGeoArea dbGeoArea = null;
                try {
                    GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea("wis_it");
                    dbGeoArea = geoAreaImpl != null ? this.lookupArea(geoAreaImpl) : null;
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load areas from geodb 'wis_it'!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                if (dbGeoArea != null) {
                    objectType.setORT(dbGeoArea.name);
                }
            }
            return objectType;
        }

        private Connection initConnection() throws SQLException {
            if (this.dbConnection == null) {
                this.dbConnection = this.dbDriver.getConnection();
            }
            return this.dbConnection;
        }

        private DbGeoArea lookupArea(Long l) throws SQLException {
            if (this.areas.containsKey(l)) {
                return this.areas.get(l);
            }
            Connection connection = this.initConnection();
            DbGeoArea dbGeoArea = this.dbExtension.getGeoHandler().getGeoArea(connection, l.longValue());
            this.areas.put(dbGeoArea.id, dbGeoArea);
            return dbGeoArea;
        }

        private DbGeoArea lookupArea(GeoAreaImpl geoAreaImpl) throws SQLException {
            Long l = Long.valueOf(geoAreaImpl.getId());
            return this.lookupArea(l);
        }

        public WIS writeToObject(AgencyImpl agencyImpl) {
            this.areas.clear();
            this.dbConnection = null;
            try {
                WIS wIS = (WIS)super.writeToObject(agencyImpl);
                return wIS;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)this.dbConnection);
                this.dbConnection = null;
                this.areas.clear();
            }
        }

        public WIS writeToObject(TransferImpl transferImpl) {
            this.areas.clear();
            this.dbConnection = null;
            try {
                WIS wIS = (WIS)super.writeToObject(transferImpl);
                return wIS;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)this.dbConnection);
                this.dbConnection = null;
                this.areas.clear();
            }
        }
    }
}

