/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.gui;

import com.openindex.openestate.impl.values.CurrencyValue;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CurrencyValueRenderer
extends AbstractRenderer<CurrencyValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrencyValueRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(CurrencyValueRenderer.class);
    private final NumberFormat format;

    public CurrencyValueRenderer() {
        this(null, null);
    }

    public CurrencyValueRenderer(String string) {
        this(string, null);
    }

    public CurrencyValueRenderer(NumberFormat numberFormat) {
        this(null, numberFormat);
    }

    public CurrencyValueRenderer(String string, NumberFormat numberFormat) {
        super(string);
        if (numberFormat != null) {
            this.format = numberFormat;
        } else {
            this.format = NumberFormat.getNumberInstance(Locale.getDefault());
            this.format.setMaximumFractionDigits(2);
            this.format.setMinimumFractionDigits(2);
        }
    }

    public void render(CurrencyValue currencyValue, JLabel jLabel) {
        jLabel.setHorizontalAlignment(4);
        if (currencyValue != null) {
            jLabel.setText(currencyValue.getUnit() != null ? this.format.format(currencyValue) + " " + currencyValue.getUnit().getSymbol(Locale.getDefault()) : this.format.format(currencyValue));
        } else {
            jLabel.setText(this.getEmptyText());
        }
    }
}

