/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportMessage
implements Serializable {
    private static final long serialVersionUID = -390150486485853025L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportMessage.class);
    private final Code code;
    private final String message;
    private final String objectId;
    private final String contactId;
    private final String errorRequestRefNumber;

    private ExportMessage(Code code, String string, String string2, String string3, String string4) {
        this.code = code;
        this.message = StringUtils.trimToNull((String)string);
        this.objectId = StringUtils.trimToNull((String)string2);
        this.contactId = StringUtils.trimToNull((String)string3);
        this.errorRequestRefNumber = StringUtils.trimToNull((String)string4);
    }

    public Code getCode() {
        return this.code;
    }

    public String getContactId() {
        return this.contactId;
    }

    public String getErrorRequestRefNumber() {
        return this.errorRequestRefNumber;
    }

    public Level getLevel() {
        return this.code.getLevel();
    }

    public String getMessage() {
        return this.message;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isError() {
        return Level.ERROR.equals((Object)this.getLevel());
    }

    public boolean isGeneral() {
        return StringUtils.isBlank((CharSequence)this.objectId) && StringUtils.isBlank((CharSequence)this.contactId);
    }

    public boolean isNotice() {
        return Level.NOTICE.equals((Object)this.getLevel());
    }

    public boolean isWarning() {
        return Level.WARNING.equals((Object)this.getLevel());
    }

    public static ExportMessage newContactMessage(String string, Code code, String string2) {
        return ExportMessage.newContactMessage(string, code, string2, null);
    }

    public static ExportMessage newContactMessage(String string, Code code, String string2, String string3) {
        return new ExportMessage(code, string2, null, string, string3);
    }

    public static ExportMessage newGeneralMessage(String string, Code code) {
        return ExportMessage.newGeneralMessage(string, code, null);
    }

    public static ExportMessage newGeneralMessage(String string, Code code, String string2) {
        return new ExportMessage(code, string, null, null, string2);
    }

    public static ExportMessage newObjectMessage(String string, Code code, String string2) {
        return ExportMessage.newObjectMessage(string, code, string2, null);
    }

    public static ExportMessage newObjectMessage(String string, Code code, String string2, String string3) {
        return new ExportMessage(code, string2, string, null, string3);
    }

    public static enum Level {
        NOTICE,
        WARNING,
        ERROR;

    }

    public static enum Code {
        CONTACT_NOT_FOUND(Level.ERROR),
        CONTACT_NOT_SAVED(Level.ERROR),
        OBJECTS_NOT_FOUND(Level.ERROR),
        OBJECT_NOT_FOUND(Level.ERROR),
        OBJECT_NOT_FOUND_FOR_ARCHIVING(Level.WARNING),
        OBJECT_NOT_FOUND_FOR_REMOVING(Level.WARNING),
        OBJECT_NOT_SAVED(Level.ERROR),
        OBJECT_NOT_REMOVED(Level.ERROR),
        OBJECT_NOT_PUBLISHED(Level.WARNING),
        OBJECT_NOT_UNPUBLISHED(Level.ERROR),
        OBJECT_NOT_DISABLED(Level.WARNING),
        OBJECT_PUBLISHINGS_NOT_FOUND(Level.WARNING),
        OBJECT_WITHOUT_ATTACHMENTS(Level.WARNING),
        OBJECT_WITHOUT_CONTACT(Level.WARNING),
        OBJECT_UNORDERED_ATTACHMENTS(Level.WARNING),
        OBJECT_OLD_ATTACHMENT_NOT_REMOVED(Level.WARNING),
        OBJECT_ATTACHMENT_NOT_SAVED(Level.WARNING),
        PUBLISH_CHANNELS_NOT_FOUND(Level.WARNING),
        XML_NOT_READABLE(Level.ERROR);

        private final Level level;

        private Code(Level level) {
            this.level = level;
        }

        public Level getLevel() {
            return this.level;
        }

        public boolean isError() {
            return Level.ERROR.equals((Object)this.level);
        }

        public boolean isNotice() {
            return Level.NOTICE.equals((Object)this.level);
        }

        public boolean isWarning() {
            return Level.WARNING.equals((Object)this.level);
        }
    }
}

