/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.immoxml;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.immoxml.ImmoXmlUtils;
import org.openestate.io.immoxml.converters.ImmoXML_3_0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ImmoXmlVersion implements XmlVersion
{
    V3_0(ImmoXML_3_0.class, "3.0", "3");

    private static final Logger LOGGER;
    private final Class converterClass;
    private final String readableVersion;
    private final String[] alias;

    private ImmoXmlVersion(Class clazz, String string2, String ... stringArray) {
        this.converterClass = clazz;
        this.readableVersion = string2;
        this.alias = stringArray;
    }

    public static ImmoXmlVersion detectFromString(String string) {
        if (string != null) {
            String[] stringArray = StringUtils.split((String)string, (String)"/");
            for (ImmoXmlVersion immoXmlVersion : ImmoXmlVersion.values()) {
                if (immoXmlVersion.toReadableVersion().equalsIgnoreCase(stringArray[0])) {
                    return immoXmlVersion;
                }
                if (immoXmlVersion.alias == null) continue;
                for (String string2 : immoXmlVersion.alias) {
                    if (!string2.equalsIgnoreCase(stringArray[0])) continue;
                    return immoXmlVersion;
                }
            }
        }
        return null;
    }

    public XmlConverter getConverter() {
        try {
            return (XmlConverter)this.converterClass.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("Can't create converter!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public ImmoXmlVersion getNextVersion() {
        ImmoXmlVersion[] immoXmlVersionArray = ImmoXmlVersion.values();
        int n = ArrayUtils.indexOf((Object[])immoXmlVersionArray, (Object)((Object)this));
        return immoXmlVersionArray.length > ++n ? immoXmlVersionArray[n] : null;
    }

    public ImmoXmlVersion getPreviousVersion() {
        ImmoXmlVersion[] immoXmlVersionArray = ImmoXmlVersion.values();
        int n = ArrayUtils.indexOf((Object[])immoXmlVersionArray, (Object)((Object)this));
        return --n >= 0 ? immoXmlVersionArray[n] : null;
    }

    public boolean isLatestVersion() {
        return ImmoXmlUtils.VERSION.equals((Object)this);
    }

    public boolean isNewerThen(XmlVersion xmlVersion) {
        ImmoXmlVersion[] immoXmlVersionArray = ImmoXmlVersion.values();
        return ArrayUtils.indexOf((Object[])immoXmlVersionArray, (Object)((Object)this)) > ArrayUtils.indexOf((Object[])immoXmlVersionArray, (Object)xmlVersion);
    }

    public boolean isOlderThen(XmlVersion xmlVersion) {
        ImmoXmlVersion[] immoXmlVersionArray = ImmoXmlVersion.values();
        return ArrayUtils.indexOf((Object[])immoXmlVersionArray, (Object)((Object)this)) < ArrayUtils.indexOf((Object[])immoXmlVersionArray, (Object)xmlVersion);
    }

    public String toReadableVersion() {
        return this.readableVersion;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ImmoXmlVersion.class);
    }
}

