/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.openimmo;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.AccessBeginDate;
import com.openindex.openestate.impl.attribs.administration.ApartmentNr;
import com.openindex.openestate.impl.attribs.administration.AuctionCompulsory;
import com.openindex.openestate.impl.attribs.administration.AuctionDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.administration.BuildableAccordingTo;
import com.openindex.openestate.impl.attribs.administration.ChargeBeginDate;
import com.openindex.openestate.impl.attribs.administration.ChargeEndDate;
import com.openindex.openestate.impl.attribs.administration.ChargeTimeUnit;
import com.openindex.openestate.impl.attribs.administration.CommercialIndustries;
import com.openindex.openestate.impl.attribs.administration.CommercialUse;
import com.openindex.openestate.impl.attribs.administration.CommunalCode;
import com.openindex.openestate.impl.attribs.administration.CommunalDistrict;
import com.openindex.openestate.impl.attribs.administration.CountryCourtFileReference;
import com.openindex.openestate.impl.attribs.administration.CountryCourtName;
import com.openindex.openestate.impl.attribs.administration.EffectiveDate;
import com.openindex.openestate.impl.attribs.administration.EmphyteusisDuration;
import com.openindex.openestate.impl.attribs.administration.GenderOfRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.GrannyFlat;
import com.openindex.openestate.impl.attribs.administration.HolidayProperty;
import com.openindex.openestate.impl.attribs.administration.LocationInBuilding;
import com.openindex.openestate.impl.attribs.administration.MonumentalProtection;
import com.openindex.openestate.impl.attribs.administration.NonSmoker;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMaximum;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMinimum;
import com.openindex.openestate.impl.attribs.administration.Parcel;
import com.openindex.openestate.impl.attribs.administration.PeopleMaximumCount;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.administration.RegionalNotes;
import com.openindex.openestate.impl.attribs.administration.Rented;
import com.openindex.openestate.impl.attribs.administration.RoomsModifiable;
import com.openindex.openestate.impl.attribs.administration.Skyscraper;
import com.openindex.openestate.impl.attribs.administration.SubPlot;
import com.openindex.openestate.impl.attribs.administration.Usage;
import com.openindex.openestate.impl.attribs.administration.WbsRequired;
import com.openindex.openestate.impl.attribs.condition.Age;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.condition.ContaminatedSites;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.AdditionalInformation;
import com.openindex.openestate.impl.attribs.descriptions.AgentFeeInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.descriptions.PriceDescription;
import com.openindex.openestate.impl.attribs.descriptions.ShortDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.AustriaThermalHeatDemand;
import com.openindex.openestate.impl.attribs.energy_certificate.AustriaTotalEnergyEfficiencyFactor;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.CreationDate;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.ExpirationDate;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.AttachedGastronomy;
import com.openindex.openestate.impl.attribs.features.BalconyTerraceDirection;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.Basement;
import com.openindex.openestate.impl.attribs.features.Bathroom;
import com.openindex.openestate.impl.attribs.features.BreweryObligation;
import com.openindex.openestate.impl.attribs.features.BroadbandInternet;
import com.openindex.openestate.impl.attribs.features.BroadbandInternetSpeed;
import com.openindex.openestate.impl.attribs.features.BuildingStyle;
import com.openindex.openestate.impl.attribs.features.CanteenCafeteria;
import com.openindex.openestate.impl.attribs.features.ChimneyPort;
import com.openindex.openestate.impl.attribs.features.CommercialRooms;
import com.openindex.openestate.impl.attribs.features.CommercialServices;
import com.openindex.openestate.impl.attribs.features.Conservatory;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.ElectricalConnectionValue;
import com.openindex.openestate.impl.attribs.features.Equipment;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FlooringMaterial;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.ResidentialServices;
import com.openindex.openestate.impl.attribs.features.RoofShape;
import com.openindex.openestate.impl.attribs.features.Sauna;
import com.openindex.openestate.impl.attribs.features.SecurityTechnology;
import com.openindex.openestate.impl.attribs.features.ShuttersInterior;
import com.openindex.openestate.impl.attribs.features.SportsFacilities;
import com.openindex.openestate.impl.attribs.features.SwimmingPool;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TelephoneAvailable;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.UndergroundLevel;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.features.WellnessArea;
import com.openindex.openestate.impl.attribs.measures.AdministrationArea;
import com.openindex.openestate.impl.attribs.measures.AtticArea;
import com.openindex.openestate.impl.attribs.measures.BalconyArea;
import com.openindex.openestate.impl.attribs.measures.BaseAreaIndex;
import com.openindex.openestate.impl.attribs.measures.BasementArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBalconies;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.CountCommercialUnits;
import com.openindex.openestate.impl.attribs.measures.CountConferenceRooms;
import com.openindex.openestate.impl.attribs.measures.CountGuestroomSeats;
import com.openindex.openestate.impl.attribs.measures.CountLivingAndBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountLoggia;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountResidentialUnits;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.CountSeparateToilets;
import com.openindex.openestate.impl.attribs.measures.CountTerraces;
import com.openindex.openestate.impl.attribs.measures.CubatureVolume;
import com.openindex.openestate.impl.attribs.measures.CubicIndex;
import com.openindex.openestate.impl.attribs.measures.DivisibleFromArea;
import com.openindex.openestate.impl.attribs.measures.FloorAreaIndex;
import com.openindex.openestate.impl.attribs.measures.FrontWindowArea;
import com.openindex.openestate.impl.attribs.measures.FrontWindowLength;
import com.openindex.openestate.impl.attribs.measures.GardenArea;
import com.openindex.openestate.impl.attribs.measures.GrossFloorArea;
import com.openindex.openestate.impl.attribs.measures.GuestTerrace;
import com.openindex.openestate.impl.attribs.measures.HeatableArea;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.OfficeAreaPart;
import com.openindex.openestate.impl.attribs.measures.OpenSpace;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.PlotForesideLength;
import com.openindex.openestate.impl.attribs.measures.RemainingAreas;
import com.openindex.openestate.impl.attribs.measures.RentableArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.RetailArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.SeatingArea;
import com.openindex.openestate.impl.attribs.measures.StorageArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.measures.UtilizationNumber;
import com.openindex.openestate.impl.attribs.prices.AdditionalRentalCharges;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.AgentFeeIncludingVat;
import com.openindex.openestate.impl.attribs.prices.AgentFeeRequired;
import com.openindex.openestate.impl.attribs.prices.BasicRent;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpacePrice;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpaceRent;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.Deposit;
import com.openindex.openestate.impl.attribs.prices.DepositAmount;
import com.openindex.openestate.impl.attribs.prices.DevelopmentCosts;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.MarketValue;
import com.openindex.openestate.impl.attribs.prices.NetReturn;
import com.openindex.openestate.impl.attribs.prices.PlusVat;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePriceOnAnnualRentalIncome;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceChargesPerArea;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeActualPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeDebitPerAnnum;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.attribs.prices.SharedCapital;
import com.openindex.openestate.impl.attribs.prices.TakeoverCosts;
import com.openindex.openestate.impl.attribs.prices.VatRate;
import com.openindex.openestate.impl.attribs.prices.VatValue;
import com.openindex.openestate.impl.attribs.surroundings.CommercialZone;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToAirport;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBeach;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToCityCentre;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToComprehensiveSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToDayNursery;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToElementarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToHighSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToJuniorHighSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToLake;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextGastronomy;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextShopping;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextTrainStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToRecreationalArea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSecondarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSkiingArea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSportsFacilities;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToWanderingArea;
import com.openindex.openestate.impl.attribs.surroundings.SupplyPossible;
import com.openindex.openestate.impl.attribs.surroundings.View;
import com.openindex.openestate.impl.attribs.surroundings.Zone;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.utils.AbstractXmlReader;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.xml.Aktion;
import org.openestate.io.openimmo.xml.Alter;
import org.openestate.io.openimmo.xml.Anbieter;
import org.openestate.io.openimmo.xml.Anhaenge;
import org.openestate.io.openimmo.xml.Anhang;
import org.openestate.io.openimmo.xml.Ausblick;
import org.openestate.io.openimmo.xml.AusstattKategorie;
import org.openestate.io.openimmo.xml.Ausstattung;
import org.openestate.io.openimmo.xml.BebaubarNach;
import org.openestate.io.openimmo.xml.Bewertung;
import org.openestate.io.openimmo.xml.Bieterverfahren;
import org.openestate.io.openimmo.xml.BueroPraxen;
import org.openestate.io.openimmo.xml.Distanzen;
import org.openestate.io.openimmo.xml.DistanzenSport;
import org.openestate.io.openimmo.xml.Einzelhandel;
import org.openestate.io.openimmo.xml.EmailSonstige;
import org.openestate.io.openimmo.xml.Energiepass;
import org.openestate.io.openimmo.xml.Erschliessung;
import org.openestate.io.openimmo.xml.Flaechen;
import org.openestate.io.openimmo.xml.Freitexte;
import org.openestate.io.openimmo.xml.FreizeitimmobilieGewerblich;
import org.openestate.io.openimmo.xml.Gastgewerbe;
import org.openestate.io.openimmo.xml.Geo;
import org.openestate.io.openimmo.xml.Geschlecht;
import org.openestate.io.openimmo.xml.Grundstueck;
import org.openestate.io.openimmo.xml.HallenLagerProd;
import org.openestate.io.openimmo.xml.Haus;
import org.openestate.io.openimmo.xml.Immobilie;
import org.openestate.io.openimmo.xml.Infrastruktur;
import org.openestate.io.openimmo.xml.Kontaktperson;
import org.openestate.io.openimmo.xml.LageGebiet;
import org.openestate.io.openimmo.xml.LandUndForstwirtschaft;
import org.openestate.io.openimmo.xml.MaxMietdauer;
import org.openestate.io.openimmo.xml.Moebliert;
import org.openestate.io.openimmo.xml.Nutzungsart;
import org.openestate.io.openimmo.xml.Objektkategorie;
import org.openestate.io.openimmo.xml.Openimmo;
import org.openestate.io.openimmo.xml.Parken;
import org.openestate.io.openimmo.xml.PreisZeiteinheit;
import org.openestate.io.openimmo.xml.Preise;
import org.openestate.io.openimmo.xml.Serviceleistungen;
import org.openestate.io.openimmo.xml.Sonstige;
import org.openestate.io.openimmo.xml.Stellplatzart;
import org.openestate.io.openimmo.xml.StpSonstige;
import org.openestate.io.openimmo.xml.TelSonstige;
import org.openestate.io.openimmo.xml.Uebertragung;
import org.openestate.io.openimmo.xml.Unterkellert;
import org.openestate.io.openimmo.xml.Versteigerung;
import org.openestate.io.openimmo.xml.VerwaltungObjekt;
import org.openestate.io.openimmo.xml.VerwaltungTechn;
import org.openestate.io.openimmo.xml.WeitereAdresse;
import org.openestate.io.openimmo.xml.Wohnung;
import org.openestate.io.openimmo.xml.Zimmer;
import org.openestate.io.openimmo.xml.ZinshausRenditeobjekt;
import org.openestate.io.openimmo.xml.Zustand;
import org.openestate.io.openimmo.xml.ZustandAngaben;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class OpenImmoReader
extends AbstractXmlReader<OpenImmoTransferDocument, Openimmo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoReader.class);

    public OpenImmoReader() {
    }

    public OpenImmoReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(Anbieter anbieter) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.setId(anbieter.getAnbieternr());
        agentImpl.getCompany().setCompanyName(anbieter.getFirma());
        agentImpl.setTerms(anbieter.getImpressum(), this.getOpenEstateLanguage());
        if (anbieter.getImpressumStrukt() != null) {
            if (StringUtils.isBlank((CharSequence)agentImpl.getCompany().getCompanyName())) {
                agentImpl.getCompany().setCompanyName(anbieter.getImpressumStrukt().getFirmenname());
            }
            agentImpl.getCompany().setCompanyPhone(anbieter.getImpressumStrukt().getTelefon());
        }
        return agentImpl;
    }

    protected EstateImpl convertImmobilie(Immobilie immobilie, Map<String, AgentContactImpl> map) {
        try {
            EstateImpl estateImpl = this.createEmptyEstate();
            String string = this.getEstateId(immobilie);
            if (string == null) {
                LOGGER.warn("Can't detect an object ID from <verwaltung_techn>!");
            }
            this.readImmobilieObjektkategorie(immobilie, estateImpl, string);
            ArrayList<OpenEstateType> arrayList = new ArrayList<OpenEstateType>();
            OpenEstateType openEstateType = estateImpl.getType();
            if (openEstateType != null) {
                arrayList.addAll(Arrays.asList(openEstateType.getParentPath()));
            }
            this.readImmobilieGeo(immobilie.getGeo(), estateImpl, arrayList, string);
            this.readImmobilieKontaktperson(immobilie.getKontaktperson(), estateImpl, arrayList, map, string);
            this.readImmobilieWeitereAdressen(immobilie.getWeitereAdresse(), estateImpl, arrayList, string);
            this.readImmobiliePreise(immobilie.getPreise(), immobilie.getAusstattung(), estateImpl, arrayList, string);
            if (OpenEstateAction.AUCTION.equals((Object)estateImpl.getAction())) {
                this.readImmobilieVersteigerung(immobilie.getVersteigerung(), estateImpl, arrayList, string);
            }
            this.readImmobilieBieterverfahren(immobilie.getBieterverfahren(), estateImpl, arrayList, string);
            this.readImmobilieFlaechen(immobilie.getFlaechen(), estateImpl, arrayList, string);
            this.readImmobilieAusstattung(immobilie.getAusstattung(), estateImpl, arrayList, string);
            this.readImmobilieZustandAngaben(immobilie.getZustandAngaben(), estateImpl, arrayList, string);
            this.readImmobilieBewertung(immobilie.getBewertung(), estateImpl, arrayList, string);
            this.readImmobilieInfrastruktur(immobilie.getInfrastruktur(), estateImpl, arrayList, string);
            this.readImmobilieFreitexte(immobilie.getFreitexte(), estateImpl, arrayList, string);
            this.readImmobilieAnhaenge(immobilie.getAnhaenge(), estateImpl, arrayList, string);
            this.readImmobilieVerwaltungObjekt(immobilie.getVerwaltungObjekt(), estateImpl, arrayList, string);
            this.readImmobilieVerwaltungTechn(immobilie.getVerwaltungTechn(), estateImpl, arrayList, string);
            return estateImpl;
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert estate!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected AgencyImpl convertToAgency(Openimmo openimmo) {
        if (openimmo.getAnbieter().isEmpty()) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        AgencyImpl agencyImpl = this.createEmptyAgency();
        Anbieter anbieter = (Anbieter)openimmo.getAnbieter().get(0);
        AgentImpl agentImpl = this.convertAnbieter(anbieter);
        agentImpl.setId("Agent.1");
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (Immobilie object : anbieter.getImmobilie()) {
            EstateImpl estateImpl = this.convertImmobilie(object, hashMap);
            if (estateImpl == null) continue;
            String string = estateImpl.getId();
            if (string == null) {
                string = "Estate." + (agencyImpl.getEstates().size() + 1);
            }
            agencyImpl.getEstates().put(string, estateImpl);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put(entry.getKey(), entry.getValue());
        }
        return agencyImpl;
    }

    protected TransferImpl convertToTransfer(Openimmo openimmo) {
        if (openimmo.getAnbieter().isEmpty()) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        Uebertragung uebertragung = openimmo.getUebertragung();
        TransferImpl transferImpl = this.createEmptyTransfer();
        transferImpl.setSenderSoftwareMail(uebertragung != null ? StringUtils.trimToNull((String)uebertragung.getTechnEmail()) : null);
        transferImpl.setSenderSoftwareName(uebertragung != null ? StringUtils.trimToNull((String)uebertragung.getSendersoftware()) : null);
        transferImpl.setSenderSoftwareVersion(uebertragung != null ? StringUtils.trimToNull((String)uebertragung.getSenderversion()) : null);
        for (Anbieter anbieter : openimmo.getAnbieter()) {
            TransferAgencyImpl transferAgencyImpl = this.createEmptyTransferAgency();
            transferAgencyImpl.setRemoveUnmodifiedEstates(uebertragung != null && Uebertragung.Umfang.VOLL.equals((Object)uebertragung.getUmfang()));
            AgentImpl agentImpl = this.convertAnbieter(anbieter);
            agentImpl.setId("Agent." + (transferImpl.getAgencies().size() + 1));
            transferAgencyImpl.setAgent(agentImpl);
            HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                EstateImpl estateImpl;
                if (immobilie.getVerwaltungTechn() != null) {
                    boolean bl;
                    boolean bl2 = bl = immobilie.getVerwaltungTechn().getAktion() != null && Aktion.AktionArt.DELETE.equals((Object)immobilie.getVerwaltungTechn().getAktion().getAktionart());
                    if (bl) {
                        String string = this.getEstateId(immobilie);
                        if (string == null) {
                            LOGGER.warn("Can't detect an object ID from <verwaltung_techn> for deletion!");
                            continue;
                        }
                        if (transferAgencyImpl.getEstateIdsToRemove().contains(string)) {
                            LOGGER.warn("Object ID '" + string + "' is defined more then once for deletion!");
                            this.putError(string, "Object ID '" + string + "' is defined more then once for deletion!");
                            continue;
                        }
                        transferAgencyImpl.getEstateIdsToRemove().add(string);
                        continue;
                    }
                }
                if ((estateImpl = this.convertImmobilie(immobilie, hashMap)) == null) continue;
                transferAgencyImpl.getEstatesToSave().add(estateImpl);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                transferAgencyImpl.getContacts().put(entry.getKey(), entry.getValue());
            }
            transferImpl.getAgencies().add(transferAgencyImpl);
        }
        return transferImpl;
    }

    protected OpenImmoTransferDocument createXmlDocument(Document document) {
        OpenImmoDocument openImmoDocument = OpenImmoUtils.createDocument((Document)document);
        return openImmoDocument instanceof OpenImmoTransferDocument ? (OpenImmoTransferDocument)openImmoDocument : null;
    }

    protected final String getEstateId(Immobilie immobilie) {
        return immobilie != null ? this.getEstateId(immobilie.getVerwaltungTechn()) : null;
    }

    protected String getEstateId(VerwaltungTechn verwaltungTechn) {
        if (verwaltungTechn == null) {
            return null;
        }
        String string = StringUtils.trimToNull((String)verwaltungTechn.getObjektnrIntern());
        if (string == null) {
            string = StringUtils.trimToNull((String)verwaltungTechn.getOpenimmoObid());
        }
        if (string == null) {
            string = StringUtils.trimToNull((String)verwaltungTechn.getObjektnrExtern());
        }
        return string;
    }

    protected OpenEstateType getEstateType(BueroPraxen.BueroTyp bueroTyp) {
        if (BueroPraxen.BueroTyp.AUSSTELLUNGSFLAECHE.equals((Object)bueroTyp)) {
            return OpenEstateType.EXHIBITION_AREA;
        }
        if (BueroPraxen.BueroTyp.BUEROFLAECHE.equals((Object)bueroTyp)) {
            return OpenEstateType.OFFICE_AREA;
        }
        if (BueroPraxen.BueroTyp.BUEROHAUS.equals((Object)bueroTyp)) {
            return OpenEstateType.OFFICE_BUILDING;
        }
        if (BueroPraxen.BueroTyp.BUEROZENTRUM.equals((Object)bueroTyp)) {
            return OpenEstateType.OFFICE_CENTER;
        }
        if (BueroPraxen.BueroTyp.PRAXIS.equals((Object)bueroTyp)) {
            return OpenEstateType.SURGERY;
        }
        if (BueroPraxen.BueroTyp.PRAXISFLAECHE.equals((Object)bueroTyp)) {
            return OpenEstateType.SURGERY_AREA;
        }
        if (BueroPraxen.BueroTyp.PRAXISHAUS.equals((Object)bueroTyp)) {
            return OpenEstateType.DOCTORS_OFFICE_HOUSE;
        }
        return OpenEstateType.OFFICE_SURGERY;
    }

    protected OpenEstateType getEstateType(Einzelhandel.HandelTyp handelTyp) {
        if (Einzelhandel.HandelTyp.AUSSTELLUNGSFLAECHE.equals((Object)handelTyp)) {
            return OpenEstateType.EXHIBITION_AREA;
        }
        if (Einzelhandel.HandelTyp.EINKAUFSZENTRUM.equals((Object)handelTyp)) {
            return OpenEstateType.SHOPPING_CENTER;
        }
        if (Einzelhandel.HandelTyp.EINZELHANDELSLADEN.equals((Object)handelTyp)) {
            return OpenEstateType.SHOP;
        }
        if (Einzelhandel.HandelTyp.KAUFHAUS.equals((Object)handelTyp)) {
            return OpenEstateType.DEPARTMENT_STORE;
        }
        if (Einzelhandel.HandelTyp.LADENLOKAL.equals((Object)handelTyp)) {
            return OpenEstateType.STORE;
        }
        if (Einzelhandel.HandelTyp.VERBRAUCHERMARKT.equals((Object)handelTyp)) {
            return OpenEstateType.CONSUMER_STORE;
        }
        if (Einzelhandel.HandelTyp.VERKAUFSFLAECHE.equals((Object)handelTyp)) {
            return OpenEstateType.SALES_AREA;
        }
        return OpenEstateType.RETAIL;
    }

    protected OpenEstateType getEstateType(FreizeitimmobilieGewerblich.FreizeitTyp freizeitTyp) {
        if (FreizeitimmobilieGewerblich.FreizeitTyp.FREIZEITANLAGE.equals((Object)freizeitTyp)) {
            return OpenEstateType.LEISURE_FACILITY;
        }
        if (FreizeitimmobilieGewerblich.FreizeitTyp.SPORTANLAGEN.equals((Object)freizeitTyp)) {
            return OpenEstateType.SPORTS_FACILITY;
        }
        if (FreizeitimmobilieGewerblich.FreizeitTyp.VERGNUEGUNGSPARKS_UND_CENTER.equals((Object)freizeitTyp)) {
            return OpenEstateType.THEME_PARK;
        }
        return OpenEstateType.LEISURE_SPORTS_FACILITY;
    }

    protected OpenEstateType getEstateType(Gastgewerbe.GastgewTyp gastgewTyp) {
        if (Gastgewerbe.GastgewTyp.BAR.equals((Object)gastgewTyp)) {
            return OpenEstateType.RESTAURANT_BAR;
        }
        if (Gastgewerbe.GastgewTyp.CAFE.equals((Object)gastgewTyp)) {
            return OpenEstateType.BISTRO_CAFE;
        }
        if (Gastgewerbe.GastgewTyp.DISCOTHEK.equals((Object)gastgewTyp)) {
            return OpenEstateType.DISCOTHEQUE;
        }
        if (Gastgewerbe.GastgewTyp.EINRAUMLOKAL.equals((Object)gastgewTyp)) {
            return OpenEstateType.ONE_ROOM_PREMISE;
        }
        if (Gastgewerbe.GastgewTyp.GASTRONOMIE.equals((Object)gastgewTyp)) {
            return OpenEstateType.GASTRONOMY;
        }
        if (Gastgewerbe.GastgewTyp.GASTRONOMIE_UND_WOHNUNG.equals((Object)gastgewTyp)) {
            return OpenEstateType.GASTRONOMY_WITH_HOUSING;
        }
        if (Gastgewerbe.GastgewTyp.HOTELS.equals((Object)gastgewTyp)) {
            return OpenEstateType.HOTEL;
        }
        if (Gastgewerbe.GastgewTyp.PENSIONEN.equals((Object)gastgewTyp)) {
            return OpenEstateType.GUESTHOUSE;
        }
        if (Gastgewerbe.GastgewTyp.RAUCHERLOKAL.equals((Object)gastgewTyp)) {
            return OpenEstateType.SMOKERS_PREMISE;
        }
        if (Gastgewerbe.GastgewTyp.RESTAURANT.equals((Object)gastgewTyp)) {
            return OpenEstateType.RESTAURANT;
        }
        return OpenEstateType.HOSPITALITY_INDUSTRY;
    }

    protected OpenEstateType getEstateType(Grundstueck.GrundstTyp grundstTyp) {
        if (Grundstueck.GrundstTyp.FREIZEIT.equals((Object)grundstTyp)) {
            return OpenEstateType.LEISURE_GROUND;
        }
        if (Grundstueck.GrundstTyp.GEMISCHT.equals((Object)grundstTyp)) {
            return OpenEstateType.MIXED_USE_GROUND;
        }
        if (Grundstueck.GrundstTyp.GEWERBE.equals((Object)grundstTyp)) {
            return OpenEstateType.COMMERCIAL_GROUND;
        }
        if (Grundstueck.GrundstTyp.GEWERBEPARK.equals((Object)grundstTyp)) {
            return OpenEstateType.COMMERCIAL_GROUND;
        }
        if (Grundstueck.GrundstTyp.INDUSTRIE.equals((Object)grundstTyp)) {
            return OpenEstateType.INDUSTRIAL_GROUND;
        }
        if (Grundstueck.GrundstTyp.LAND_FORSTWIRSCHAFT.equals((Object)grundstTyp)) {
            return OpenEstateType.AGRICULTURAL_FORESTRY_GROUND;
        }
        if (Grundstueck.GrundstTyp.SEELIEGENSCHAFT.equals((Object)grundstTyp)) {
            return OpenEstateType.LAKEFRONT_GROUND;
        }
        if (Grundstueck.GrundstTyp.SONDERNUTZUNG.equals((Object)grundstTyp)) {
            return OpenEstateType.SPECIAL_USE_GROUND;
        }
        if (Grundstueck.GrundstTyp.WOHNEN.equals((Object)grundstTyp)) {
            return OpenEstateType.RESIDENTIAL_GROUND;
        }
        return OpenEstateType.GENERAL_PIECE_OF_LAND;
    }

    protected OpenEstateType getEstateType(HallenLagerProd.HallenTyp hallenTyp) {
        if (HallenLagerProd.HallenTyp.FREIFLAECHEN.equals((Object)hallenTyp)) {
            return OpenEstateType.OPEN_SPACE;
        }
        if (HallenLagerProd.HallenTyp.HALLE.equals((Object)hallenTyp)) {
            return OpenEstateType.HALL_WAREHOUSE;
        }
        if (HallenLagerProd.HallenTyp.HOCHREGALLAGER.equals((Object)hallenTyp)) {
            return OpenEstateType.HIGH_RACK_WAREHOUSE;
        }
        if (HallenLagerProd.HallenTyp.INDUSTRIEHALLE.equals((Object)hallenTyp)) {
            return OpenEstateType.INDUSTRIAL_WAREHOUSE;
        }
        if (HallenLagerProd.HallenTyp.KUEHLHAUS.equals((Object)hallenTyp)) {
            return OpenEstateType.COOLING_HOUSE;
        }
        if (HallenLagerProd.HallenTyp.LAGER.equals((Object)hallenTyp)) {
            return OpenEstateType.WAREHOUSE;
        }
        if (HallenLagerProd.HallenTyp.LAGER_MIT_FREIFLAECHE.equals((Object)hallenTyp)) {
            return OpenEstateType.WAREHOUSE_WITH_OPEN_SPACE;
        }
        if (HallenLagerProd.HallenTyp.LAGERFLAECHEN.equals((Object)hallenTyp)) {
            return OpenEstateType.STORAGE_AREA;
        }
        if (HallenLagerProd.HallenTyp.PRODUKTION.equals((Object)hallenTyp)) {
            return OpenEstateType.PRODUCTION;
        }
        if (HallenLagerProd.HallenTyp.SERVICE.equals((Object)hallenTyp)) {
            return OpenEstateType.SERVICE_AREA;
        }
        if (HallenLagerProd.HallenTyp.SPEDITIONSLAGER.equals((Object)hallenTyp)) {
            return OpenEstateType.FORWARDING_WAREHOUSE;
        }
        if (HallenLagerProd.HallenTyp.WERKSTATT.equals((Object)hallenTyp)) {
            return OpenEstateType.WORKSHOP;
        }
        return OpenEstateType.HALL_WAREHOUSE;
    }

    protected OpenEstateType getEstateType(Haus.Haustyp haustyp) {
        if (Haus.Haustyp.APARTMENTHAUS.equals((Object)haustyp)) {
            return OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING;
        }
        if (Haus.Haustyp.BAUERNHAUS.equals((Object)haustyp)) {
            return OpenEstateType.FARMHOUSE;
        }
        if (Haus.Haustyp.BERGHUETTE.equals((Object)haustyp)) {
            return OpenEstateType.ALPINE_HUT;
        }
        if (Haus.Haustyp.BUNGALOW.equals((Object)haustyp)) {
            return OpenEstateType.BUNGALOW;
        }
        if (Haus.Haustyp.BURG.equals((Object)haustyp)) {
            return OpenEstateType.CASTLE;
        }
        if (Haus.Haustyp.CHALET.equals((Object)haustyp)) {
            return OpenEstateType.CHALET;
        }
        if (Haus.Haustyp.DOPPELHAUSHAELFTE.equals((Object)haustyp)) {
            return OpenEstateType.SEMIDETACHED_HOUSE;
        }
        if (Haus.Haustyp.EINFAMILIENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.SINGLE_FAMILY_HOUSE;
        }
        if (Haus.Haustyp.FERIENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.COTTAGE;
        }
        if (Haus.Haustyp.FINCA.equals((Object)haustyp)) {
            return OpenEstateType.FINCA;
        }
        if (Haus.Haustyp.HERRENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.MANSION;
        }
        if (Haus.Haustyp.KEINE_ANGABE.equals((Object)haustyp)) {
            return OpenEstateType.HOUSE;
        }
        if (Haus.Haustyp.LANDHAUS.equals((Object)haustyp)) {
            return OpenEstateType.COUNTRY_HOUSE;
        }
        if (Haus.Haustyp.LAUBE_DATSCHE_GARTENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.SUMMER_HOUSE;
        }
        if (Haus.Haustyp.MEHRFAMILIENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.MULTI_FAMILY_HOUSE;
        }
        if (Haus.Haustyp.REIHENECK.equals((Object)haustyp)) {
            return OpenEstateType.TERRACED_HOUSE_CORNERSIDE;
        }
        if (Haus.Haustyp.REIHENEND.equals((Object)haustyp)) {
            return OpenEstateType.TERRACED_HOUSE_TAIL;
        }
        if (Haus.Haustyp.REIHENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.TERRACED_HOUSE;
        }
        if (Haus.Haustyp.REIHENMITTEL.equals((Object)haustyp)) {
            return OpenEstateType.TERRACED_HOUSE_MIDDLE;
        }
        if (Haus.Haustyp.RESTHOF.equals((Object)haustyp)) {
            return OpenEstateType.REST_OF_A_FARM;
        }
        if (Haus.Haustyp.RUSTICO.equals((Object)haustyp)) {
            return OpenEstateType.RUSTICO;
        }
        if (Haus.Haustyp.SCHLOSS.equals((Object)haustyp)) {
            return OpenEstateType.PALACE;
        }
        if (Haus.Haustyp.STADTHAUS.equals((Object)haustyp)) {
            return OpenEstateType.TOWN_HOUSE;
        }
        if (Haus.Haustyp.STRANDHAUS.equals((Object)haustyp)) {
            return OpenEstateType.BEACH_HOUSE;
        }
        if (Haus.Haustyp.VILLA.equals((Object)haustyp)) {
            return OpenEstateType.VILLA;
        }
        if (Haus.Haustyp.ZWEIFAMILIENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.TWO_FAMILY_HOUSE;
        }
        return OpenEstateType.HOUSE;
    }

    protected OpenEstateType getEstateType(LandUndForstwirtschaft.LandTyp landTyp) {
        if (LandUndForstwirtschaft.LandTyp.ACKERBAU.equals((Object)landTyp)) {
            return OpenEstateType.CULTIVATION;
        }
        if (LandUndForstwirtschaft.LandTyp.AUSSIEDLERHOF.equals((Object)landTyp)) {
            return OpenEstateType.OUTLYING_FARM;
        }
        if (LandUndForstwirtschaft.LandTyp.BAUERNHOF.equals((Object)landTyp)) {
            return OpenEstateType.FARM;
        }
        if (LandUndForstwirtschaft.LandTyp.GARTENBAU.equals((Object)landTyp)) {
            return OpenEstateType.GARDENING;
        }
        if (LandUndForstwirtschaft.LandTyp.JAGD_UND_FORSTWIRTSCHAFT.equals((Object)landTyp)) {
            return OpenEstateType.FORESTRY_HUNTING;
        }
        if (LandUndForstwirtschaft.LandTyp.JAGDREVIER.equals((Object)landTyp)) {
            return OpenEstateType.HUNTING_GROUND;
        }
        if (LandUndForstwirtschaft.LandTyp.LANDWIRTSCHAFTLICHE_BETRIEBE.equals((Object)landTyp)) {
            return OpenEstateType.GENERAL_AGRICULTURE;
        }
        if (LandUndForstwirtschaft.LandTyp.REITERHOEFE.equals((Object)landTyp)) {
            return OpenEstateType.RIDING_ESTATE;
        }
        if (LandUndForstwirtschaft.LandTyp.SCHEUNEN.equals((Object)landTyp)) {
            return OpenEstateType.BARN;
        }
        if (LandUndForstwirtschaft.LandTyp.SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN.equals((Object)landTyp)) {
            return OpenEstateType.GENERAL_AGRICULTURE;
        }
        if (LandUndForstwirtschaft.LandTyp.TEICH_UND_FISCHWIRTSCHAFT.equals((Object)landTyp)) {
            return OpenEstateType.FISH_FARMING;
        }
        if (LandUndForstwirtschaft.LandTyp.VIEHWIRTSCHAFT.equals((Object)landTyp)) {
            return OpenEstateType.ANIMAL_HUSBANDRY;
        }
        if (LandUndForstwirtschaft.LandTyp.WEINBAU.equals((Object)landTyp)) {
            return OpenEstateType.VINICULTURE;
        }
        return OpenEstateType.GENERAL_AGRICULTURE;
    }

    protected OpenEstateType getEstateType(Parken.ParkenTyp parkenTyp) {
        if (Parken.ParkenTyp.BOOTSLIEGEPLATZ.equals((Object)parkenTyp)) {
            return OpenEstateType.BERTH;
        }
        if (Parken.ParkenTyp.CARPORT.equals((Object)parkenTyp)) {
            return OpenEstateType.CARPORT;
        }
        if (Parken.ParkenTyp.DOPPELGARAGE.equals((Object)parkenTyp)) {
            return OpenEstateType.DOUBLE_GARAGE;
        }
        if (Parken.ParkenTyp.DUPLEX.equals((Object)parkenTyp)) {
            return OpenEstateType.DUPLEX_GARAGE;
        }
        if (Parken.ParkenTyp.EINZELGARAGE.equals((Object)parkenTyp)) {
            return OpenEstateType.GARAGE;
        }
        if (Parken.ParkenTyp.PARKHAUS.equals((Object)parkenTyp)) {
            return OpenEstateType.CAR_PARK;
        }
        if (Parken.ParkenTyp.STELLPLATZ.equals((Object)parkenTyp)) {
            return OpenEstateType.PARKING_SPACE;
        }
        if (Parken.ParkenTyp.TIEFGARAGE.equals((Object)parkenTyp)) {
            return OpenEstateType.UNDERGROUND_CAR_PARK;
        }
        if (Parken.ParkenTyp.TIEFGARAGENSTELLPLATZ.equals((Object)parkenTyp)) {
            return OpenEstateType.UNDERGROUND_CAR_PARK_UNIT;
        }
        return OpenEstateType.GENERAL_PARKING;
    }

    protected OpenEstateType getEstateType(Sonstige.SonstigeTyp sonstigeTyp) {
        if (Sonstige.SonstigeTyp.KRANKENHAUS.equals((Object)sonstigeTyp)) {
            return OpenEstateType.HOSPITAL_CLINIC;
        }
        if (Sonstige.SonstigeTyp.PARKHAUS.equals((Object)sonstigeTyp)) {
            return OpenEstateType.CAR_PARK;
        }
        if (Sonstige.SonstigeTyp.SONSTIGE.equals((Object)sonstigeTyp)) {
            return OpenEstateType.SPECIAL_HOUSE;
        }
        if (Sonstige.SonstigeTyp.TANKSTELLE.equals((Object)sonstigeTyp)) {
            return OpenEstateType.PETROL_STATION;
        }
        return null;
    }

    protected OpenEstateType getEstateType(Wohnung.Wohnungtyp wohnungtyp) {
        if (Wohnung.Wohnungtyp.APARTMENT.equals((Object)wohnungtyp)) {
            return OpenEstateType.APARTMENT;
        }
        if (Wohnung.Wohnungtyp.ATTIKAWOHNUNG.equals((Object)wohnungtyp)) {
            return OpenEstateType.PENTHOUSE_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.DACHGESCHOSS.equals((Object)wohnungtyp)) {
            return OpenEstateType.ATTIC_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.ERDGESCHOSS.equals((Object)wohnungtyp)) {
            return OpenEstateType.GROUND_FLOOR_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.ETAGE.equals((Object)wohnungtyp)) {
            return OpenEstateType.HIGHER_FLOOR_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.KEINE_ANGABE.equals((Object)wohnungtyp)) {
            return OpenEstateType.RESIDENCE;
        }
        if (Wohnung.Wohnungtyp.LOFT_STUDIO_ATELIER.equals((Object)wohnungtyp)) {
            return OpenEstateType.LOFT;
        }
        if (Wohnung.Wohnungtyp.MAISONETTE.equals((Object)wohnungtyp)) {
            return OpenEstateType.MAISONETTE;
        }
        if (Wohnung.Wohnungtyp.PENTHOUSE.equals((Object)wohnungtyp)) {
            return OpenEstateType.PENTHOUSE_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.ROHDACHBODEN.equals((Object)wohnungtyp)) {
            return OpenEstateType.ATTIC_UNDER_CONSTRUCTION;
        }
        if (Wohnung.Wohnungtyp.SOUTERRAIN.equals((Object)wohnungtyp)) {
            return OpenEstateType.SOUTERRAIN_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.TERRASSEN.equals((Object)wohnungtyp)) {
            return OpenEstateType.TERRACE_APARTMENT;
        }
        return OpenEstateType.RESIDENCE;
    }

    protected OpenEstateType getEstateType(Zimmer.Zimmertyp zimmertyp) {
        return OpenEstateType.ROOM;
    }

    protected OpenEstateType getEstateType(ZinshausRenditeobjekt.ZinsTyp zinsTyp) {
        if (ZinshausRenditeobjekt.ZinsTyp.BETREUTES_WOHNEN.equals((Object)zinsTyp)) {
            return OpenEstateType.ASSISTED_LIVING;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.BUEROGEBAEUDE.equals((Object)zinsTyp)) {
            return OpenEstateType.OFFICE_BUILDING;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.EINKAUFSCENTREN.equals((Object)zinsTyp)) {
            return OpenEstateType.SHOPPING_CENTER;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.GESCHAEFTSHAUS.equals((Object)zinsTyp)) {
            return OpenEstateType.COMMERCIAL_BUILDING;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.INDUSTRIEANLAGEN.equals((Object)zinsTyp)) {
            return OpenEstateType.INDUSTRIAL_FACILITY;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.MEHRFAMILIENHAUS.equals((Object)zinsTyp)) {
            return OpenEstateType.MULTI_FAMILY_HOUSE_WITH_COMMERCIAL;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.PFLEGEHEIM.equals((Object)zinsTyp)) {
            return OpenEstateType.CARE_HOME;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.SANATORIUM.equals((Object)zinsTyp)) {
            return OpenEstateType.SANATORIUM;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.SB_MAERKTE.equals((Object)zinsTyp)) {
            return OpenEstateType.SELF_SERVICE_MARKET;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.SENIORENHEIM.equals((Object)zinsTyp)) {
            return OpenEstateType.SENIOR_HOUSING_COMPLEX;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.VERBRAUCHERMAERKTE.equals((Object)zinsTyp)) {
            return OpenEstateType.CONSUMER_STORE;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.WOHNANLAGEN.equals((Object)zinsTyp)) {
            return OpenEstateType.HOUSING_COMPLEX;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.WOHN_UND_GESCHAEFTSHAUS.equals((Object)zinsTyp)) {
            return OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING;
        }
        return OpenEstateType.MULTI_FAMILY_HOUSE_WITH_COMMERCIAL;
    }

    protected OpenEstateType getEstateType(Nutzungsart nutzungsart) {
        if (nutzungsart == null) {
            return null;
        }
        if (Boolean.TRUE.equals(nutzungsart.isGEWERBE())) {
            return OpenEstateType.GENERAL_COMMERCIAL;
        }
        if (Boolean.TRUE.equals(nutzungsart.isWOHNEN())) {
            return OpenEstateType.GENERAL_RESIDENCE;
        }
        if (Boolean.TRUE.equals(nutzungsart.getANLAGE())) {
            return OpenEstateType.GENERAL_COMMERCIAL;
        }
        return null;
    }

    protected void readImmobilieAnhaenge(Anhaenge anhaenge, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        if (anhaenge == null) {
            return;
        }
        for (Anhang anhang : anhaenge.getAnhang()) {
            if (anhang.getDaten() == null) continue;
            try {
                EstateLinkProvider[] estateLinkProviderArray;
                URI uRI;
                String string2 = StringUtils.trimToNull((String)anhang.getDaten().getPfad());
                EstateLinkImpl.ProviderLink providerLink = null;
                if (string2 != null) {
                    URI uRI2 = uRI = string2.toLowerCase().startsWith("http://") || string2.toLowerCase().startsWith("https://") || string2.toLowerCase().startsWith("ftp://") || string2.toLowerCase().startsWith("ftps://") ? new URI(string2) : null;
                    if (uRI != null) {
                        for (EstateLinkProvider estateLinkProvider : EstateLinkProvider.values()) {
                            String string3 = estateLinkProvider.getLinkIdFromUrl(uRI.toString());
                            if (string3 == null) continue;
                            providerLink = new EstateLinkImpl.ProviderLink(string3, estateLinkProvider);
                            break;
                        }
                    }
                } else {
                    uRI = null;
                }
                if (providerLink != null) {
                    estateLinkProviderArray = this.createEmptyLink();
                    estateLinkProviderArray.setTitle(anhang.getAnhangtitel(), this.getOpenEstateLanguage());
                    estateLinkProviderArray.setProviderLink(providerLink);
                    estateImpl.getLinks().add(estateLinkProviderArray);
                    continue;
                }
                if ((Anhang.Gruppe.LINKS.equals((Object)anhang.getGruppe()) || Anhang.Gruppe.FILMLINK.equals((Object)anhang.getGruppe()) || Anhang.Gruppe.ANBOBJURL.equals((Object)anhang.getGruppe())) && uRI != null) {
                    estateLinkProviderArray = this.createEmptyLink();
                    estateLinkProviderArray.setTitle(anhang.getAnhangtitel(), this.getOpenEstateLanguage());
                    estateLinkProviderArray.setWebLink(uRI);
                    estateImpl.getLinks().add(estateLinkProviderArray);
                    continue;
                }
                estateLinkProviderArray = this.createEmptyAttachment();
                estateLinkProviderArray.setTitle(anhang.getAnhangtitel(), this.getOpenEstateLanguage());
                estateLinkProviderArray.setMimeType(StringUtils.trimToNull((String)anhang.getFormat()));
                if (uRI != null) {
                    estateLinkProviderArray.setFile(uRI);
                } else if (!StringUtils.isBlank((CharSequence)string2)) {
                    estateLinkProviderArray.setFile(string2);
                } else {
                    byte[] byArray = anhang.getDaten().getAnhanginhalt();
                    if (byArray != null) {
                        estateLinkProviderArray.setFile(byArray);
                    } else {
                        LOGGER.warn("<daten> element is empty");
                        continue;
                    }
                }
                if (Anhang.Gruppe.AUSSENANSICHTEN.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_OUTER_VIEW);
                } else if (Anhang.Gruppe.BILD.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE);
                } else if (Anhang.Gruppe.GRUNDRISS.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_GROUNDPLAN);
                } else if (Anhang.Gruppe.INNENANSICHTEN.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_INNER_VIEW);
                } else if (Anhang.Gruppe.KARTEN_LAGEPLAN.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_MAP);
                } else if (Anhang.Gruppe.PANORAMA.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_PANORAMA);
                }
                estateImpl.getAttachments().add(estateLinkProviderArray);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read attachment!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.putError(string, "Can't read attachment! " + exception.getLocalizedMessage());
            }
        }
    }

    protected void readImmobilieAusstattung(Ausstattung ausstattung, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        AusstattKategorie ausstattKategorie;
        if (ausstattung == null) {
            return;
        }
        if (ausstattung.getAngeschlGastronomie() != null) {
            AttachedGastronomy.put((EstateImpl)estateImpl, (Boolean)(Boolean.TRUE.equals(ausstattung.getAngeschlGastronomie().getBAR()) || Boolean.TRUE.equals(ausstattung.getAngeschlGastronomie().getHOTELRESTAURANT()) ? 1 : 0));
        }
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)ausstattung.getBarrierefrei());
        BreweryObligation.put((EstateImpl)estateImpl, (Boolean)ausstattung.getBrauereibindung());
        if (ausstattung.getBreitbandZugang() != null) {
            BroadbandInternet.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)ausstattung.getBreitbandZugang().getArt());
            BroadbandInternetSpeed.put((EstateImpl)estateImpl, (Number)ausstattung.getBreitbandZugang().getSpeed());
        }
        GardenUse.put((EstateImpl)estateImpl, (Boolean)ausstattung.getGartennutzung());
        GuestTerrace.put((EstateImpl)estateImpl, (Boolean)ausstattung.getGastterrasse());
        if (ausstattung.getHallenhoehe() != null) {
            WarehouseHeight.put((EstateImpl)estateImpl, (Number)ausstattung.getHallenhoehe(), (LengthValue.Unit)LengthValue.Unit.M);
        }
        LiftingPlatform.put((EstateImpl)estateImpl, (Boolean)ausstattung.getHebebuehne());
        ChimneyPort.put((EstateImpl)estateImpl, (Boolean)ausstattung.getKamin());
        CanteenCafeteria.put((EstateImpl)estateImpl, (Boolean)ausstattung.getKantineCafeteria());
        AirConditioned.put((EstateImpl)estateImpl, (Boolean)ausstattung.getKlimatisiert());
        Crane.put((EstateImpl)estateImpl, (Boolean)ausstattung.getKran());
        Ramp.put((EstateImpl)estateImpl, (Boolean)ausstattung.getRampe());
        ShuttersInterior.put((EstateImpl)estateImpl, (Boolean)ausstattung.getRolladen());
        Sauna.put((EstateImpl)estateImpl, (Boolean)ausstattung.getSauna());
        SportsFacilities.put((EstateImpl)estateImpl, (Boolean)ausstattung.getSporteinrichtungen());
        ElectricalConnectionValue.put((EstateImpl)estateImpl, (String)ausstattung.getStromanschlusswert());
        SwimmingPool.put((EstateImpl)estateImpl, (Boolean)ausstattung.getSwimmingpool());
        TelephoneAvailable.put((EstateImpl)estateImpl, (Boolean)ausstattung.getTelefonFerienimmobilie());
        WellnessArea.put((EstateImpl)estateImpl, (Boolean)ausstattung.getWellnessbereich());
        Conservatory.put((EstateImpl)estateImpl, (Boolean)ausstattung.getWintergarten());
        if (ausstattung.getAusrichtBalkonTerrasse() != null) {
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getNORDOST())) {
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.N);
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.E);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getNORDWEST())) {
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.N);
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.W);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getSUEDOST())) {
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.S);
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.E);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getSUEDWEST())) {
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.S);
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.W);
            }
            if (BalconyTerraceDirection.getAsList((EstateImpl)estateImpl).isEmpty()) {
                if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getNORD())) {
                    BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.N);
                }
                if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getOST())) {
                    BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.E);
                }
                if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getSUED())) {
                    BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.S);
                }
                if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getWEST())) {
                    BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.W);
                }
            }
        }
        if (ausstattung.getAusstattKategorie() != null) {
            ausstattKategorie = ausstattung.getAusstattKategorie();
            if (AusstattKategorie.STANDARD.equals((Object)ausstattKategorie)) {
                Equipment.put((EstateImpl)estateImpl, (Equipment.Option)Equipment.Option.STANDARD);
            } else if (AusstattKategorie.GEHOBEN.equals((Object)ausstattKategorie)) {
                Equipment.put((EstateImpl)estateImpl, (Equipment.Option)Equipment.Option.EXCLUSIVE);
            } else if (AusstattKategorie.LUXUS.equals((Object)ausstattKategorie)) {
                Equipment.put((EstateImpl)estateImpl, (Equipment.Option)Equipment.Option.LUXURY);
            }
        }
        if (Boolean.TRUE.equals(ausstattung.getAbstellraum())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.STORAGE_ROOM);
        }
        if (Boolean.TRUE.equals(ausstattung.getBibliothek())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.LIBRARY);
        }
        if (Boolean.TRUE.equals(ausstattung.getDachboden())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.ATTIC);
        }
        if (Boolean.TRUE.equals(ausstattung.getFahrradraum())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.BICYCLE_ROOM);
        }
        if (Boolean.TRUE.equals(ausstattung.getGaestewc())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        if (Boolean.TRUE.equals(ausstattung.getTeekueche())) {
            CommercialRooms.putOption((EstateImpl)estateImpl, (CommercialRooms.Option)CommercialRooms.Option.TEA_KITCHEN);
        }
        if (Boolean.TRUE.equals(ausstattung.getWaschTrockenraum())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.WASHING_DRYING_ROOM);
        }
        if (Boolean.TRUE.equals(ausstattung.getDvVerkabelung())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING);
        }
        if (Boolean.TRUE.equals(ausstattung.getDvbt())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DVBT_RECEPTION);
        }
        if (Boolean.TRUE.equals(ausstattung.getKabelkanaele())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.WIREWAYS);
        }
        if (Boolean.TRUE.equals(ausstattung.getKabelSatTv())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.CABLE_SAT_TV);
        }
        if (Boolean.TRUE.equals(ausstattung.getUmtsEmpfang())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.UMTS_RECEPTION);
        }
        if (Boolean.TRUE.equals(ausstattung.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        if (Boolean.TRUE.equals(ausstattung.getSeniorengerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.SENIORS);
        }
        if (Boolean.TRUE.equals(ausstattung.getWgGeeignet())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.APARTMENT_SHARE);
        }
        if (ausstattung.getBad() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBad().getBIDET())) {
                Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.BIDET);
            }
            if (Boolean.TRUE.equals(ausstattung.getBad().getDUSCHE())) {
                Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.SHOWER);
            }
            if (Boolean.TRUE.equals(ausstattung.getBad().getFENSTER())) {
                Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.WINDOW);
            }
            if (Boolean.TRUE.equals(ausstattung.getBad().getPISSOIR())) {
                Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.URINAL);
            }
            if (Boolean.TRUE.equals(ausstattung.getBad().getWANNE())) {
                Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.BATHTUB);
            }
        }
        if (ausstattung.getBefeuerung() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getALTERNATIV())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.ALTERNATIVELY);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getBLOCK())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.BLOCK_POWER_PLANT);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getELEKTRO())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.ELECTRICS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getERDWAERME())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.GEOTHERMICS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getFERN())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.DISTRICT_HEATING);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getFLUESSIGGAS())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.LIQUID_GAS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getGAS())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.GAS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getHOLZ())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.WOOD);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getKOHLE())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.COAL);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getLUFTWP())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.AIR_TO_WATER_HEAT_PUMP);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getOEL())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.OIL);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getPELLET())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.PELLETS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getSOLAR())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.SOLAR);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getWASSERELEKTRO())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.WATER_ELECTRICS);
            }
        }
        if (ausstattung.getBoden() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBoden().getDIELEN())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.FLOOR_BOARDS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getDOPPELBODEN())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.ACCESS_FLOOR);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getESTRICH())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.SCREED);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getFERTIGPARKETT())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.PARQUET_FINISHED);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getFLIESEN())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.TILES);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getGRANIT())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.GRANITE);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getKUNSTSTOFF())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.SYNTHETIC_MATERIAL);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getLAMINAT())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.LAMINATE);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getLINOLEUM())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.LINOLEUM);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getMARMOR())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.MARBLE);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getPARKETT())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.PARQUET);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getSTEIN())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.STONE);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getTEPPICH())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.CARPET);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getTERRAKOTTA())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.TERRACOTTA);
            }
        }
        if (ausstattung.getDachform() != null) {
            if (Boolean.TRUE.equals(ausstattung.getDachform().getFLACHDACH())) {
                RoofShape.putOption((EstateImpl)estateImpl, (RoofShape.Option)RoofShape.Option.FLAT);
            }
            if (Boolean.TRUE.equals(ausstattung.getDachform().getKRUEPPELWALMDACH())) {
                RoofShape.putOption((EstateImpl)estateImpl, (RoofShape.Option)RoofShape.Option.HALF_HIP);
            }
            if (Boolean.TRUE.equals(ausstattung.getDachform().getMANSARDDACH())) {
                RoofShape.putOption((EstateImpl)estateImpl, (RoofShape.Option)RoofShape.Option.MANSARD);
            }
            if (Boolean.TRUE.equals(ausstattung.getDachform().getPULTDACH())) {
                RoofShape.putOption((EstateImpl)estateImpl, (RoofShape.Option)RoofShape.Option.MONOPITCH);
            }
            if (Boolean.TRUE.equals(ausstattung.getDachform().getPYRAMIDENDACH())) {
                RoofShape.putOption((EstateImpl)estateImpl, (RoofShape.Option)RoofShape.Option.PYRAMID);
            }
            if (Boolean.TRUE.equals(ausstattung.getDachform().getSATTELDACH())) {
                RoofShape.putOption((EstateImpl)estateImpl, (RoofShape.Option)RoofShape.Option.GABLED);
            }
            if (Boolean.TRUE.equals(ausstattung.getDachform().getWALMDACH())) {
                RoofShape.putOption((EstateImpl)estateImpl, (RoofShape.Option)RoofShape.Option.HIP);
            }
        }
        if (ausstattung.getFahrstuhl() != null) {
            FreightElevator.put((EstateImpl)estateImpl, (Boolean)ausstattung.getFahrstuhl().getLASTEN());
            Lift.put((EstateImpl)estateImpl, (Boolean)ausstattung.getFahrstuhl().getPERSONEN());
        }
        if (ausstattung.getHeizungsart() != null) {
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getETAGE())) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.SELF_CONTAINED_CENTRAL);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getFERN())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.DISTRICT_HEATING);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getFUSSBODEN())) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.UNDERFLOOR);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getOFEN())) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.OVEN);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getZENTRAL())) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.CENTRAL);
            }
        }
        if (ausstattung.getKueche() != null) {
            if (Boolean.TRUE.equals(ausstattung.getKueche().getEBK())) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
            }
            if (Boolean.TRUE.equals(ausstattung.getKueche().getPANTRY())) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.KITCHENETTE);
            }
            if (Boolean.TRUE.equals(ausstattung.getKueche().getOFFEN())) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.OPEN_KITCHEN);
            }
        }
        Moebliert.Moeb moeb = ausstattKategorie = ausstattung.getMoebliert() != null ? ausstattung.getMoebliert().getMoeb() : null;
        if (Moebliert.Moeb.VOLL.equals((Object)ausstattKategorie)) {
            Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.YES);
        } else if (Moebliert.Moeb.TEIL.equals((Object)ausstattKategorie)) {
            Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.PARTIAL);
        }
        if (Boolean.TRUE.equals(ausstattung.getRaeumeVeraenderbar())) {
            RoomsModifiable.put((EstateImpl)estateImpl, (RoomsModifiable.Option)RoomsModifiable.Option.YES);
        } else if (Boolean.FALSE.equals(ausstattung.getRaeumeVeraenderbar())) {
            RoomsModifiable.put((EstateImpl)estateImpl, (RoomsModifiable.Option)RoomsModifiable.Option.PARTIALLY);
        }
        if (ausstattung.getServiceleistungen() != null) {
            for (Serviceleistungen serviceleistungen : ausstattung.getServiceleistungen()) {
                if (Boolean.TRUE.equals(serviceleistungen.getBETREUTESWOHNEN())) {
                    ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getEINKAUF())) {
                    ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.PURCHASING);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getCATERING())) {
                    ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.CATERING);
                    CommercialServices.putOption((EstateImpl)estateImpl, (CommercialServices.Option)CommercialServices.Option.CATERING);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getREINIGUNG())) {
                    ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.CLEANING);
                    CommercialServices.putOption((EstateImpl)estateImpl, (CommercialServices.Option)CommercialServices.Option.CLEANING);
                }
                if (!Boolean.TRUE.equals(serviceleistungen.getWACHDIENST())) continue;
                ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.SECURITY_FIRM);
                CommercialServices.putOption((EstateImpl)estateImpl, (CommercialServices.Option)CommercialServices.Option.SECURITY_FIRM);
            }
        }
        if (ausstattung.getSicherheitstechnik() != null) {
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().getALARMANLAGE())) {
                SecurityTechnology.putOption((EstateImpl)estateImpl, (SecurityTechnology.Option)SecurityTechnology.Option.ALARM_SYSTEM);
            }
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().getKAMERA())) {
                SecurityTechnology.putOption((EstateImpl)estateImpl, (SecurityTechnology.Option)SecurityTechnology.Option.CAMERA);
            }
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().getPOLIZEIRUF())) {
                SecurityTechnology.putOption((EstateImpl)estateImpl, (SecurityTechnology.Option)SecurityTechnology.Option.POLICE_CALL);
            }
        }
        if (ausstattung.getStellplatzart() != null) {
            for (Serviceleistungen serviceleistungen : ausstattung.getStellplatzart()) {
                if (Boolean.TRUE.equals(serviceleistungen.getCARPORT())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.CARPORT);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getDUPLEX())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.DUPLEX_GARAGE);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getFREIPLATZ())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GENERAL);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getGARAGE())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GARAGE);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getPARKHAUS())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK);
                }
                if (!Boolean.TRUE.equals(serviceleistungen.getTIEFGARAGE())) continue;
                CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.AT_UNDERGROUND_CAR_PARK);
            }
        }
        if (ausstattung.getUnterkellert() != null && ausstattung.getUnterkellert().getKeller() != null) {
            Unterkellert.Keller keller = ausstattung.getUnterkellert().getKeller();
            if (Unterkellert.Keller.JA.equals((Object)keller)) {
                UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)UndergroundLevel.Option.YES);
                Basement.put((EstateImpl)estateImpl, (Boolean)Boolean.TRUE);
            } else if (Unterkellert.Keller.TEIL.equals((Object)keller)) {
                UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)UndergroundLevel.Option.PARTIALLY);
                Basement.put((EstateImpl)estateImpl, (Boolean)Boolean.TRUE);
            } else if (Unterkellert.Keller.NEIN.equals((Object)keller)) {
                UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)UndergroundLevel.Option.NO);
                Basement.put((EstateImpl)estateImpl, (Boolean)Boolean.FALSE);
            }
        }
    }

    protected void readImmobilieBewertung(Bewertung bewertung, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
    }

    protected void readImmobilieBieterverfahren(Bieterverfahren bieterverfahren, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
    }

    protected void readImmobilieFlaechen(Flaechen flaechen, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        Object object;
        if (flaechen == null) {
            return;
        }
        CountBathrooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlBadezimmer());
        CountBalconies.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlBalkone());
        CountBeds.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlBetten());
        CountCommercialUnits.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlGewerbeeinheiten());
        CountLoggia.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlLogia());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlSchlafzimmer());
        CountSeparateToilets.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlSepWc());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlStellplaetze());
        CountConferenceRooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlTagungsraeume());
        CountTerraces.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlTerrassen());
        CountLivingAndBedrooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlWohnSchlafzimmer());
        CountResidentialUnits.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlWohneinheiten());
        CountRooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlZimmer());
        UtilizationNumber.put((EstateImpl)estateImpl, (Number)flaechen.getAusnuetzungsziffer());
        BalconyArea.put((EstateImpl)estateImpl, (Number)flaechen.getBalkonTerrasseFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        HeatableArea.put((EstateImpl)estateImpl, (Number)flaechen.getBeheizbareFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        GrossFloorArea.put((EstateImpl)estateImpl, (String)flaechen.getBgf(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CubicIndex.put((EstateImpl)estateImpl, (String)flaechen.getBmz());
        OfficeArea.put((EstateImpl)estateImpl, (Number)flaechen.getBueroflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        OfficeAreaPart.put((EstateImpl)estateImpl, (Number)flaechen.getBueroteilflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AtticArea.put((EstateImpl)estateImpl, (Number)flaechen.getDachbodenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        GrannyFlat.put((EstateImpl)estateImpl, (Boolean)flaechen.getEinliegerwohnung());
        FrontWindowLength.put((EstateImpl)estateImpl, (Number)flaechen.getFensterfront(), (LengthValue.Unit)LengthValue.Unit.M);
        FrontWindowArea.put((EstateImpl)estateImpl, (Number)flaechen.getFensterfrontQm(), (AreaValue.Unit)AreaValue.Unit.SQM);
        OpenSpace.put((EstateImpl)estateImpl, (Number)flaechen.getFreiflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        GardenArea.put((EstateImpl)estateImpl, (Number)flaechen.getGartenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        SeatingArea.put((EstateImpl)estateImpl, (Number)flaechen.getGastroflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TotalArea.put((EstateImpl)estateImpl, (Number)flaechen.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        FloorAreaIndex.put((EstateImpl)estateImpl, (String)flaechen.getGfz());
        PlotArea.put((EstateImpl)estateImpl, (Number)flaechen.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotForesideLength.put((EstateImpl)estateImpl, (Number)flaechen.getGrundstuecksfront(), (LengthValue.Unit)LengthValue.Unit.M);
        BaseAreaIndex.put((EstateImpl)estateImpl, (String)flaechen.getGrz());
        BasementArea.put((EstateImpl)estateImpl, (Number)flaechen.getKellerflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CubatureVolume.put((EstateImpl)estateImpl, (Number)flaechen.getKubatur(), (VolumeValue.Unit)VolumeValue.Unit.CUM);
        RetailArea.put((EstateImpl)estateImpl, (Number)flaechen.getLadenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        StorageArea.put((EstateImpl)estateImpl, (Number)flaechen.getLagerflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        UsableArea.put((EstateImpl)estateImpl, (Number)flaechen.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountGuestroomSeats.put((EstateImpl)estateImpl, (Number)flaechen.getPlaetzeGastraum());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)flaechen.getSonstflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)flaechen.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        SalesArea.put((EstateImpl)estateImpl, (Number)flaechen.getVerkaufsflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RentableArea.put((EstateImpl)estateImpl, (Number)flaechen.getVermietbareFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AdministrationArea.put((EstateImpl)estateImpl, (Number)flaechen.getVerwaltungsflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ResidentialArea.put((EstateImpl)estateImpl, (Number)flaechen.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
            object = UsableArea.get((EstateImpl)estateImpl);
            if (object == null) {
                if (list.contains(OpenEstateType.OFFICE_SURGERY) || list.contains(OpenEstateType.OFFICE_COMMERCIAL_PREMISE)) {
                    object = OfficeArea.get((EstateImpl)estateImpl);
                } else if (list.contains(OpenEstateType.RETAIL)) {
                    object = RetailArea.get((EstateImpl)estateImpl);
                } else if (list.contains(OpenEstateType.HOSPITALITY_INDUSTRY) || list.contains(OpenEstateType.GASTRONOMY)) {
                    object = SeatingArea.get((EstateImpl)estateImpl);
                } else if (list.contains(OpenEstateType.HALL_WAREHOUSE)) {
                    object = StorageArea.get((EstateImpl)estateImpl);
                }
            }
            if (object == null) {
                object = TotalArea.get((EstateImpl)estateImpl);
            }
            if (object != null) {
                CommercialArea.put((EstateImpl)estateImpl, (AreaValue)object);
            }
        }
        if (list.contains(OpenEstateType.GENERAL_PARKING)) {
            object = UsableArea.get((EstateImpl)estateImpl);
            if (object == null) {
                object = TotalArea.get((EstateImpl)estateImpl);
            }
            if (object != null) {
                CarParkingArea.put((EstateImpl)estateImpl, (AreaValue)object);
            }
        }
        if (list.contains(OpenEstateType.OFFICE_COMMERCIAL_BUILDING) && ((object = CountCommercialUnits.getAsBigDecimal((EstateImpl)estateImpl)) == null || ((BigDecimal)object).compareTo(BigDecimal.ZERO) < 1)) {
            CountCommercialUnits.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlZimmer());
        }
    }

    protected void readImmobilieFreitexte(Freitexte freitexte, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        if (freitexte == null) {
            return;
        }
        estateImpl.setTitle(freitexte.getObjekttitel(), this.getOpenEstateLanguage());
        FeatureDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getAusstattBeschr());
        ShortDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getDreizeiler());
        LocationDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getLage());
        DetailledDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getObjektbeschreibung());
        AdditionalInformation.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getSonstigeAngaben());
    }

    protected void readImmobilieGeo(Geo geo, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        BigDecimal bigDecimal;
        if (geo == null) {
            return;
        }
        CountFloors.put((EstateImpl)estateImpl, (Number)geo.getAnzahlEtagen());
        Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), geo.getEtage() != null ? geo.getEtage().toString() : null);
        Parcel.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getFlur());
        SubPlot.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getFlurstueck());
        CommunalDistrict.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getGemarkung());
        CommunalCode.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getGemeindecode());
        RegionalNotes.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getRegionalerZusatz());
        ApartmentNr.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getWohnungsnr());
        estateImpl.getAddress().setRegion(geo.getBundesland());
        estateImpl.getAddress().setStreetNr(geo.getHausnummer());
        estateImpl.getAddress().setCity(geo.getOrt());
        estateImpl.getAddress().setPostalCode(geo.getPlz());
        estateImpl.getAddress().setStreet(geo.getStrasse());
        if (geo.getLand() != null && geo.getLand().getIsoLand() != null) {
            estateImpl.getAddress().setCountry(OpenEstateUtils.convertToIso2Country((String)geo.getLand().getIsoLand()));
        }
        if (geo.getGeokoordinaten() != null) {
            bigDecimal = geo.getGeokoordinaten().getBreitengrad();
            BigDecimal bigDecimal2 = geo.getGeokoordinaten().getLaengengrad();
            if (bigDecimal != null && bigDecimal2 != null) {
                estateImpl.getAddress().setLatitude(bigDecimal);
                estateImpl.getAddress().setLongitude(bigDecimal2);
            }
        }
        if (geo.getLageGebiet() != null && geo.getLageGebiet().getGebiete() != null) {
            bigDecimal = geo.getLageGebiet().getGebiete();
            if (LageGebiet.Gebiete.A_LAGE.equals((Object)bigDecimal)) {
                CommercialZone.put((EstateImpl)estateImpl, (CommercialZone.Option)CommercialZone.Option.LOCATION_A);
            } else if (LageGebiet.Gebiete.B_LAGE.equals((Object)bigDecimal)) {
                CommercialZone.put((EstateImpl)estateImpl, (CommercialZone.Option)CommercialZone.Option.LOCATION_B);
            } else if (LageGebiet.Gebiete.GEWERBE.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.COMMERCIAL);
            } else if (LageGebiet.Gebiete.INDUSTRIE.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.INDUSTRIAL);
            } else if (LageGebiet.Gebiete.MISCH.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.MIXED);
            } else if (LageGebiet.Gebiete.NEBENZENTRUM.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.SUBSIDIARY_CENTER);
            } else if (LageGebiet.Gebiete.NEUBAU.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.DEVELOPMENT);
            } else if (LageGebiet.Gebiete.ORTSLAGE.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.CITY);
            } else if (LageGebiet.Gebiete.SIEDLUNG.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.VILLAGE);
            } else if (LageGebiet.Gebiete.STADTRAND.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.SUBURBS);
            } else if (LageGebiet.Gebiete.STADTTEIL.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.DISTRICT);
            } else if (LageGebiet.Gebiete.STADTZENTRUM.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.CITY_CENTER);
            } else if (LageGebiet.Gebiete.WOHN.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.RESIDENTIAL);
            }
        }
        if (geo.getLageImBau() != null) {
            if (Boolean.TRUE.equals(geo.getLageImBau().getHINTEN())) {
                LocationInBuilding.put((EstateImpl)estateImpl, (LocationInBuilding.Option)LocationInBuilding.Option.BACKYARD_BUILDING);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().getLINKS())) {
                LocationInBuilding.put((EstateImpl)estateImpl, (LocationInBuilding.Option)LocationInBuilding.Option.SIDE_WING_LEFT);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().getRECHTS())) {
                LocationInBuilding.put((EstateImpl)estateImpl, (LocationInBuilding.Option)LocationInBuilding.Option.SIDE_WING_RIGHT);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().getVORNE())) {
                LocationInBuilding.put((EstateImpl)estateImpl, (LocationInBuilding.Option)LocationInBuilding.Option.FRONT_BUILDING);
            }
        }
    }

    protected void readImmobilieInfrastruktur(Infrastruktur infrastruktur, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        Distanzen.DistanzZu distanzZu;
        if (infrastruktur == null) {
            return;
        }
        if (infrastruktur.getAusblick() != null) {
            Ausblick.Blick blick = infrastruktur.getAusblick().getBlick();
            if (Ausblick.Blick.BERGE.equals((Object)blick)) {
                View.putOption((EstateImpl)estateImpl, (View.Option)View.Option.MOUNTAIN_VIEW);
            } else if (Ausblick.Blick.FERNE.equals((Object)blick)) {
                View.putOption((EstateImpl)estateImpl, (View.Option)View.Option.DISTANT_VIEW);
            } else if (Ausblick.Blick.SEE.equals((Object)blick)) {
                View.putOption((EstateImpl)estateImpl, (View.Option)View.Option.LAKE_VIEW);
            } else if (Ausblick.Blick.MEER.equals((Object)blick)) {
                View.putOption((EstateImpl)estateImpl, (View.Option)View.Option.SEA_VIEW);
            }
        }
        if (infrastruktur.getDistanzen() != null) {
            for (Distanzen distanzen : infrastruktur.getDistanzen()) {
                distanzZu = distanzen.getDistanzZu();
                if (Distanzen.DistanzZu.AUTOBAHN.equals((Object)distanzZu)) {
                    DistanceToMotorway.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.BUS.equals((Object)distanzZu)) {
                    DistanceToBusStation.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.EINKAUFSMOEGLICHKEITEN.equals((Object)distanzZu)) {
                    DistanceToNextShopping.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.FERNBAHNHOF.equals((Object)distanzZu)) {
                    DistanceToMainLineStation.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.FLUGHAFEN.equals((Object)distanzZu)) {
                    DistanceToAirport.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.GASTSTAETTEN.equals((Object)distanzZu)) {
                    DistanceToNextGastronomy.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.GESAMTSCHULE.equals((Object)distanzZu)) {
                    DistanceToComprehensiveSchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.GRUNDSCHULE.equals((Object)distanzZu)) {
                    DistanceToElementarySchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.GYMNASIUM.equals((Object)distanzZu)) {
                    DistanceToHighSchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.HAUPTSCHULE.equals((Object)distanzZu)) {
                    DistanceToJuniorHighSchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.KINDERGAERTEN.equals((Object)distanzZu)) {
                    DistanceToDayNursery.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.REALSCHULE.equals((Object)distanzZu)) {
                    DistanceToSecondarySchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.US_BAHN.equals((Object)distanzZu)) {
                    DistanceToNextTrainStation.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (!Distanzen.DistanzZu.ZENTRUM.equals((Object)distanzZu)) continue;
                DistanceToCityCentre.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
            }
        }
        if (infrastruktur.getDistanzenSport() != null) {
            for (Distanzen distanzen : infrastruktur.getDistanzenSport()) {
                distanzZu = distanzen.getDistanzZuSport();
                if (DistanzenSport.DistanzZuSport.MEER.equals((Object)distanzZu)) {
                    DistanceToSea.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.NAHERHOLUNG.equals((Object)distanzZu)) {
                    DistanceToRecreationalArea.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SEE.equals((Object)distanzZu)) {
                    DistanceToLake.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SKIGEBIET.equals((Object)distanzZu)) {
                    DistanceToSkiingArea.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SPORTANLAGEN.equals((Object)distanzZu)) {
                    DistanceToSportsFacilities.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.STRAND.equals((Object)distanzZu)) {
                    DistanceToBeach.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (!DistanzenSport.DistanzZuSport.WANDERGEBIETE.equals((Object)distanzZu)) continue;
                DistanceToWanderingArea.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
            }
        }
        SupplyPossible.put((EstateImpl)estateImpl, (Boolean)infrastruktur.getZulieferung());
    }

    protected void readImmobilieKontaktperson(Kontaktperson kontaktperson, EstateImpl estateImpl, List<OpenEstateType> list, Map<String, AgentContactImpl> map, String string) {
        String string2;
        EmailSonstige emailSonstige;
        Object object;
        if (kontaktperson == null) {
            return;
        }
        String string3 = StringUtils.trimToNull((String)kontaktperson.getPersonennummer());
        if (string3 == null) {
            string3 = "NewContact." + (map.size() + 1);
        }
        if (map.containsKey(string3)) {
            AgentContactImpl agentContactImpl = map.get(string3);
            estateImpl.setContactId(agentContactImpl.getId());
            return;
        }
        AgentContactImpl agentContactImpl = this.createEmptyContact();
        agentContactImpl.setId(string3);
        estateImpl.setContactId(string3);
        map.put(string3, agentContactImpl);
        agentContactImpl.setStreetNr(kontaktperson.getHausnummer());
        agentContactImpl.setPersonLastName(kontaktperson.getName());
        agentContactImpl.setCity(kontaktperson.getOrt());
        agentContactImpl.setPostalCode(kontaktperson.getPlz());
        agentContactImpl.setStreet(kontaktperson.getStrasse());
        agentContactImpl.setPersonFirstName(kontaktperson.getVorname());
        String string4 = kontaktperson.getAnrede();
        if (Gender.FEMALE.name().equalsIgnoreCase(string4) || "frau".equalsIgnoreCase(string4)) {
            agentContactImpl.setPersonGender(Gender.FEMALE);
        } else if (Gender.MALE.name().equalsIgnoreCase(string4) || "herr".equalsIgnoreCase(string4)) {
            agentContactImpl.setPersonGender(Gender.MALE);
        }
        if (kontaktperson.getLand() != null && !StringUtils.isBlank((CharSequence)kontaktperson.getLand().getIsoLand())) {
            agentContactImpl.setCountry(OpenEstateUtils.convertToIso2Country((String)kontaktperson.getLand().getIsoLand().trim()));
        }
        agentContactImpl.setPersonMail(StringUtils.trimToNull((String)kontaktperson.getEmailFeedback()));
        if (agentContactImpl.getPersonMail() == null) {
            agentContactImpl.setPersonMail(StringUtils.trimToNull((String)kontaktperson.getEmailDirekt()));
        }
        if (agentContactImpl.getPersonMail() == null) {
            agentContactImpl.setPersonMail(StringUtils.trimToNull((String)kontaktperson.getEmailZentrale()));
        }
        if (agentContactImpl.getPersonMail() == null) {
            agentContactImpl.setPersonMail(StringUtils.trimToNull((String)kontaktperson.getEmailPrivat()));
        }
        if (agentContactImpl.getPersonMail() == null) {
            object = kontaktperson.getEmailSonstige().iterator();
            while (object.hasNext()) {
                emailSonstige = (EmailSonstige)object.next();
                string2 = StringUtils.trimToNull((String)emailSonstige.getValue());
                if (string2 == null) continue;
                agentContactImpl.setPersonMail(string2);
                break;
            }
        }
        agentContactImpl.setPersonFax(StringUtils.trimToNull((String)kontaktperson.getTelFax()));
        agentContactImpl.setPersonMobilePhone(StringUtils.trimToNull((String)kontaktperson.getTelHandy()));
        agentContactImpl.setPersonPhone(StringUtils.trimToNull((String)kontaktperson.getTelDurchw()));
        if (agentContactImpl.getPersonPhone() == null) {
            agentContactImpl.setPersonPhone(StringUtils.trimToNull((String)kontaktperson.getTelZentrale()));
        }
        if (agentContactImpl.getPersonPhone() == null) {
            agentContactImpl.setPersonPhone(StringUtils.trimToNull((String)kontaktperson.getTelPrivat()));
        }
        if (agentContactImpl.getPersonPhone() == null || agentContactImpl.getPersonMobilePhone() == null || agentContactImpl.getPersonFax() == null) {
            object = kontaktperson.getTelSonstige().iterator();
            while (object.hasNext()) {
                emailSonstige = (TelSonstige)object.next();
                string2 = StringUtils.trimToNull((String)emailSonstige.getValue());
                boolean bl = TelSonstige.Telefonart.TEL_FAX.equals((Object)emailSonstige.getTelefonart());
                boolean bl2 = TelSonstige.Telefonart.TEL_HANDY.equals((Object)emailSonstige.getTelefonart());
                if (string2 == null) continue;
                if (bl && agentContactImpl.getPersonFax() == null) {
                    agentContactImpl.setPersonFax(string2);
                } else if (bl2 && agentContactImpl.getPersonMobilePhone() == null) {
                    agentContactImpl.setPersonMobilePhone(string2);
                } else if (!bl && !bl2 && agentContactImpl.getPersonPhone() == null) {
                    agentContactImpl.setPersonPhone(string2);
                }
                if (agentContactImpl.getPersonPhone() == null || agentContactImpl.getPersonMobilePhone() == null || agentContactImpl.getPersonFax() == null) continue;
                break;
            }
        }
        if ((object = StringUtils.trimToNull((String)kontaktperson.getUrl())) != null) {
            try {
                if (!((String)object).toLowerCase().startsWith("http://") && !((String)object).toLowerCase().startsWith("https://")) {
                    object = "http://" + (String)object;
                }
                agentContactImpl.setContactWebsite(new URI((String)object));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read contact website URL '" + (String)object + "'!!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                agentContactImpl.setContactWebsite(null);
                this.putError(string, "Can't read contact website URL '" + (String)object + "'! " + uRISyntaxException.getLocalizedMessage());
            }
        }
    }

    protected void readImmobilieObjektkategorie(Immobilie immobilie, EstateImpl estateImpl, String string) {
        Object object;
        AbstractTypeImpl abstractTypeImpl;
        Versteigerung versteigerung;
        Objektkategorie objektkategorie = immobilie != null ? immobilie.getObjektkategorie() : null;
        Preise preise = immobilie != null ? immobilie.getPreise() : null;
        Versteigerung versteigerung2 = versteigerung = immobilie != null ? immobilie.getVersteigerung() : null;
        if (objektkategorie == null) {
            return;
        }
        OpenEstateType openEstateType = null;
        if (!objektkategorie.getObjektart().getObjektartZusatz().isEmpty()) {
            openEstateType = OpenEstateUtils.lookupEstate((String)StringUtils.trimToNull((String)((String)objektkategorie.getObjektart().getObjektartZusatz().get(0))));
        }
        if (openEstateType == null && !objektkategorie.getObjektart().getBueroPraxen().isEmpty()) {
            openEstateType = this.getEstateType(((BueroPraxen)objektkategorie.getObjektart().getBueroPraxen().get(0)).getBueroTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getEinzelhandel().isEmpty()) {
            openEstateType = this.getEstateType(((Einzelhandel)objektkategorie.getObjektart().getEinzelhandel().get(0)).getHandelTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getFreizeitimmobilieGewerblich().isEmpty()) {
            openEstateType = this.getEstateType(((FreizeitimmobilieGewerblich)objektkategorie.getObjektart().getFreizeitimmobilieGewerblich().get(0)).getFreizeitTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getGastgewerbe().isEmpty()) {
            openEstateType = this.getEstateType(((Gastgewerbe)objektkategorie.getObjektart().getGastgewerbe().get(0)).getGastgewTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getGrundstueck().isEmpty()) {
            openEstateType = this.getEstateType(((Grundstueck)objektkategorie.getObjektart().getGrundstueck().get(0)).getGrundstTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getHallenLagerProd().isEmpty()) {
            openEstateType = this.getEstateType(((HallenLagerProd)objektkategorie.getObjektart().getHallenLagerProd().get(0)).getHallenTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getHaus().isEmpty()) {
            abstractTypeImpl = ((Haus)objektkategorie.getObjektart().getHaus().get(0)).getHaustyp();
            openEstateType = this.getEstateType((Haus.Haustyp)abstractTypeImpl);
            if (Haus.Haustyp.FERTIGHAUS.equals((Object)abstractTypeImpl)) {
                BuildingStyle.put((EstateImpl)estateImpl, (BuildingStyle.Option)BuildingStyle.Option.PREFABRICATED_HOUSE);
            }
        } else if (openEstateType == null && !objektkategorie.getObjektart().getLandUndForstwirtschaft().isEmpty()) {
            openEstateType = this.getEstateType(((LandUndForstwirtschaft)objektkategorie.getObjektart().getLandUndForstwirtschaft().get(0)).getLandTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getParken().isEmpty()) {
            openEstateType = this.getEstateType(((Parken)objektkategorie.getObjektart().getParken().get(0)).getParkenTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getSonstige().isEmpty()) {
            openEstateType = this.getEstateType(((Sonstige)objektkategorie.getObjektart().getSonstige().get(0)).getSonstigeTyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getWohnung().isEmpty()) {
            abstractTypeImpl = ((Wohnung)objektkategorie.getObjektart().getWohnung().get(0)).getWohnungtyp();
            openEstateType = this.getEstateType((Wohnung.Wohnungtyp)abstractTypeImpl);
            if (Wohnung.Wohnungtyp.FERIENWOHNUNG.equals((Object)abstractTypeImpl)) {
                HolidayProperty.put((EstateImpl)estateImpl, (Boolean)Boolean.TRUE);
            }
        } else if (openEstateType == null && !objektkategorie.getObjektart().getZimmer().isEmpty()) {
            openEstateType = this.getEstateType(((Zimmer)objektkategorie.getObjektart().getZimmer().get(0)).getZimmertyp());
        } else if (openEstateType == null && !objektkategorie.getObjektart().getZinshausRenditeobjekt().isEmpty()) {
            openEstateType = this.getEstateType(((ZinshausRenditeobjekt)objektkategorie.getObjektart().getZinshausRenditeobjekt().get(0)).getZinsTyp());
        }
        if (openEstateType == null) {
            openEstateType = this.getEstateType(objektkategorie.getNutzungsart());
        }
        if (openEstateType == null) {
            throw new IllegalArgumentException("Can't find an estate type!");
        }
        abstractTypeImpl = openEstateType.createImpl();
        if (abstractTypeImpl == null) {
            throw new IllegalArgumentException("unsupported estate type (" + openEstateType + ")");
        }
        OpenEstateAction openEstateAction = null;
        if (versteigerung != null && versteigerung.getVerkehrswert() != null && versteigerung.getVerkehrswert().compareTo(BigDecimal.ZERO) > 0) {
            openEstateAction = OpenEstateAction.AUCTION;
        } else if (objektkategorie.getVermarktungsart() == null) {
            openEstateAction = null;
        } else if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().getERBPACHT())) {
            openEstateAction = OpenEstateAction.EMPHYTEUSIS;
        } else if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().isKAUF())) {
            openEstateAction = OpenEstateAction.PURCHASE;
        } else if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().isMIETEPACHT())) {
            boolean bl;
            object = preise != null ? preise.getPacht() : null;
            boolean bl2 = Boolean.TRUE.equals(objektkategorie.getNutzungsart().getWAZ());
            boolean bl3 = bl = object != null && ((BigDecimal)object).compareTo(BigDecimal.ZERO) > 0;
            openEstateAction = bl2 && abstractTypeImpl.hasAction(OpenEstateAction.SHORT_TERM_RENT) ? OpenEstateAction.SHORT_TERM_RENT : (bl && abstractTypeImpl.hasAction(OpenEstateAction.LEASE) ? OpenEstateAction.LEASE : OpenEstateAction.RENT);
        }
        if (openEstateAction == null && preise != null) {
            object = preise.getKaufpreis();
            BigDecimal bigDecimal = object != null ? object.getValue() : null;
            BigDecimal bigDecimal2 = preise.getPacht();
            BigDecimal bigDecimal3 = preise.getKaltmiete();
            BigDecimal bigDecimal4 = preise.getPauschalmiete();
            if (bigDecimal3 == null || bigDecimal3.compareTo(BigDecimal.ZERO) <= 0) {
                bigDecimal3 = preise.getWarmmiete();
            }
            if (bigDecimal != null && (bigDecimal.compareTo(BigDecimal.ZERO) > 0 || Boolean.TRUE.equals(object.getAufAnfrage()))) {
                openEstateAction = OpenEstateAction.PURCHASE;
            } else if (bigDecimal4 != null && bigDecimal4.compareTo(BigDecimal.ZERO) > 0) {
                openEstateAction = OpenEstateAction.SHORT_TERM_RENT;
            } else if (bigDecimal3 != null && bigDecimal3.compareTo(BigDecimal.ZERO) > 0) {
                openEstateAction = OpenEstateAction.RENT;
            } else if (bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0) {
                openEstateAction = OpenEstateAction.LEASE;
            }
        }
        if (openEstateAction == null) {
            throw new IllegalArgumentException("Can't find an estate-action!");
        }
        if (!abstractTypeImpl.hasAction(openEstateAction)) {
            throw new IllegalArgumentException("The estate-type '" + openEstateType + "' does not suppert estate-action '" + openEstateAction + "'!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        if (objektkategorie.getNutzungsart() != null) {
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().getANLAGE())) {
                Usage.putOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.INVESTMENT);
            }
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().isGEWERBE())) {
                Usage.putOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.COMMERCIAL);
            }
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().isWOHNEN())) {
                Usage.putOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.RESIDENTIAL);
            }
        }
    }

    protected void readImmobiliePreise(Preise preise, Ausstattung ausstattung, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        Object object;
        Object object2;
        BigDecimal bigDecimal;
        if (preise == null) {
            return;
        }
        TakeoverCosts.put((EstateImpl)estateImpl, (Number)preise.getAbstand());
        if (preise.getAussenCourtage() != null) {
            AgentFee.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)preise.getAussenCourtage().getContent());
            AgentFeeIncludingVat.put((EstateImpl)estateImpl, (Boolean)preise.getAussenCourtage().getMitMwst());
        }
        AgentFeeInformation.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)preise.getCourtageHinweis());
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            Lease.put((EstateImpl)estateImpl, (Number)preise.getErbpacht());
        }
        DevelopmentCosts.put((EstateImpl)estateImpl, (Number)preise.getErschliessungskosten());
        PriceDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)preise.getFreitextPreis());
        SharedCapital.put((EstateImpl)estateImpl, (Number)preise.getGeschaeftsguthaben());
        CommonCharge.put((EstateImpl)estateImpl, (Number)preise.getHausgeld());
        HeatingCosts.put((EstateImpl)estateImpl, (Number)preise.getHeizkosten());
        ServiceChargesIncludingHeatingCosts.put((EstateImpl)estateImpl, (Boolean)preise.getHeizkostenEnthalten());
        RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)preise.getKaltmiete());
        if (preise.getKaufpreis() != null) {
            bigDecimal = preise.getKaufpreis().getValue();
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                bigDecimal = BigDecimal.ZERO;
            }
            PurchasePrice.put((EstateImpl)estateImpl, (Number)bigDecimal);
            if (Boolean.TRUE.equals(preise.getKaufpreis().getAufAnfrage())) {
                estateImpl.setHiddenPrices(Boolean.valueOf(true));
            }
        }
        PurchasePricePerArea.put((EstateImpl)estateImpl, (Number)preise.getKaufpreisProQm());
        DepositAmount.put((EstateImpl)estateImpl, (Number)preise.getKaution());
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)preise.getKautionText());
        if (preise.getMieteinnahmenIst() != null) {
            RentalIncomeActualPerAnnum.put((EstateImpl)estateImpl, (Number)preise.getMieteinnahmenIst().getValue());
        }
        if (preise.getMieteinnahmenSoll() != null) {
            RentalIncomeDebitPerAnnum.put((EstateImpl)estateImpl, (Number)preise.getMieteinnahmenSoll().getValue());
        }
        RentExcludingServiceChargesPerArea.put((EstateImpl)estateImpl, (Number)preise.getMietpreisProQm());
        AdditionalRentalCharges.put((EstateImpl)estateImpl, (Number)preise.getMietzuschlaege());
        VatValue.put((EstateImpl)estateImpl, (Number)preise.getMwstGesamt());
        VatRate.put((EstateImpl)estateImpl, (Number)preise.getMwstSatz());
        ServiceCharges.put((EstateImpl)estateImpl, (Number)preise.getNebenkosten());
        BasicRent.put((EstateImpl)estateImpl, (Number)preise.getNettokaltmiete());
        NetReturn.put((EstateImpl)estateImpl, (Number)preise.getNettorendite());
        if (!OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction()) || Lease.get((EstateImpl)estateImpl) == null) {
            Lease.put((EstateImpl)estateImpl, (Number)preise.getPacht());
        }
        if (preise.getPreisZeiteinheit() != null && preise.getPreisZeiteinheit().getZeiteinheit() != null) {
            bigDecimal = preise.getPreisZeiteinheit().getZeiteinheit();
            if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
                if (PreisZeiteinheit.Zeiteinheit.JAHR.equals((Object)bigDecimal)) {
                    RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.YEAR);
                } else if (PreisZeiteinheit.Zeiteinheit.MONAT.equals((Object)bigDecimal)) {
                    RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.MONTH);
                } else if (PreisZeiteinheit.Zeiteinheit.TAG.equals((Object)bigDecimal)) {
                    RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.DAY);
                } else if (PreisZeiteinheit.Zeiteinheit.WOCHE.equals((Object)bigDecimal)) {
                    RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.WEEK);
                }
            } else {
                ChargeTimeUnit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)bigDecimal.name());
            }
        }
        ChargeEndDate.put((EstateImpl)estateImpl, (Calendar)preise.getPreisZeitraumBis());
        ChargeBeginDate.put((EstateImpl)estateImpl, (Calendar)preise.getPreisZeitraumVon());
        bigDecimal = null;
        if (ausstattung != null && ausstattung.getStellplatzart() != null) {
            object2 = ausstattung.getStellplatzart().iterator();
            while (object2.hasNext()) {
                object = (Stellplatzart)object2.next();
                if (Boolean.TRUE.equals(object.getCARPORT())) {
                    bigDecimal = preise.getStpCarport();
                } else if (Boolean.TRUE.equals(object.getDUPLEX())) {
                    bigDecimal = preise.getStpDuplex();
                } else if (Boolean.TRUE.equals(object.getFREIPLATZ())) {
                    bigDecimal = preise.getStpFreiplatz();
                } else if (Boolean.TRUE.equals(object.getGARAGE())) {
                    bigDecimal = preise.getStpGarage();
                } else if (Boolean.TRUE.equals(object.getPARKHAUS())) {
                    bigDecimal = preise.getStpParkhaus();
                } else if (Boolean.TRUE.equals(object.getTIEFGARAGE())) {
                    bigDecimal = preise.getStpTiefgarage();
                }
                if (bigDecimal != null && bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
                    bigDecimal = null;
                }
                if (bigDecimal == null) continue;
                break;
            }
        }
        if (bigDecimal == null || bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
            bigDecimal = preise.getStpCarport();
        }
        if (bigDecimal == null || bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
            bigDecimal = preise.getStpDuplex();
        }
        if (bigDecimal == null || bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
            bigDecimal = preise.getStpFreiplatz();
        }
        if (bigDecimal == null || bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
            bigDecimal = preise.getStpGarage();
        }
        if (bigDecimal == null || bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
            bigDecimal = preise.getStpParkhaus();
        }
        if (bigDecimal == null || bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
            bigDecimal = preise.getStpTiefgarage();
        }
        if (bigDecimal == null || bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
            object2 = preise.getStpSonstige().iterator();
            while (object2.hasNext()) {
                object = (StpSonstige)object2.next();
                bigDecimal = object;
                if (bigDecimal != null && bigDecimal.getStellplatzkaufpreis() == null && bigDecimal.getStellplatzmiete() == null) {
                    bigDecimal = null;
                }
                if (bigDecimal == null) continue;
                break;
            }
        }
        if (bigDecimal != null) {
            if (CountParkingSpaces.get((EstateImpl)estateImpl) == null) {
                CountParkingSpaces.put((EstateImpl)estateImpl, (Number)bigDecimal.getAnzahl());
            }
            if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction()) || OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
                CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)bigDecimal.getStellplatzmiete());
            } else {
                CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)bigDecimal.getStellplatzkaufpreis());
            }
        }
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            RentFlatRate.put((EstateImpl)estateImpl, (Number)preise.getWarmmiete());
        } else {
            RentIncludingServiceCharges.put((EstateImpl)estateImpl, (Number)preise.getWarmmiete());
        }
        PurchasePriceOnAnnualRentalIncome.put((EstateImpl)estateImpl, (String)StringUtils.trimToNull((String)preise.getXFache()));
        AgentFeeRequired.put((EstateImpl)estateImpl, (Boolean)preise.getProvisionspflichtig());
        PlusVat.put((EstateImpl)estateImpl, (Boolean)preise.getZzgMehrwertsteuer());
        if (preise.getWaehrung() != null && (object2 = StringUtils.trimToNull((String)preise.getWaehrung().getIsoWaehrung())) != null) {
            try {
                estateImpl.setCurrency(Currency.getInstance((String)object2));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read currency code '" + (String)object2 + "'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.putError(string, "Can't read currency code '" + (String)object2 + "'! " + exception.getLocalizedMessage());
            }
        }
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction()) && RentFlatRate.get((EstateImpl)estateImpl) == null) {
            object2 = RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            object = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            BigDecimal bigDecimal2 = ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            if (object2 != null) {
                RentFlatRate.put((EstateImpl)estateImpl, (Number)object2);
            } else if (object != null) {
                if (bigDecimal2 != null) {
                    RentFlatRate.put((EstateImpl)estateImpl, (Number)((BigDecimal)object).add(bigDecimal2));
                } else {
                    RentFlatRate.put((EstateImpl)estateImpl, (Number)object);
                }
            }
        }
    }

    protected void readImmobilieVersteigerung(Versteigerung versteigerung, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        if (versteigerung == null) {
            return;
        }
        CountryCourtFileReference.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)versteigerung.getAktenzeichen());
        CountryCourtName.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)versteigerung.getAmtsgericht());
        MarketValue.put((EstateImpl)estateImpl, (Number)versteigerung.getVerkehrswert());
        AuctionDate.put((EstateImpl)estateImpl, (Calendar)versteigerung.getZvtermin());
        AuctionCompulsory.put((EstateImpl)estateImpl, (Boolean)versteigerung.getZwangsversteigerung());
    }

    protected void readImmobilieVerwaltungObjekt(VerwaltungObjekt verwaltungObjekt, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        MaxMietdauer.MaxDauer maxDauer;
        Object object;
        Integer n;
        Object object2;
        String string2;
        if (verwaltungObjekt == null) {
            return;
        }
        estateImpl.setGroupId(StringUtils.trimToNull((String)verwaltungObjekt.getGruppennummer()));
        HolidayProperty.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getAlsFerien());
        AvailabilityEndDate.put((EstateImpl)estateImpl, (Calendar)verwaltungObjekt.getBisdatum());
        CommercialIndustries.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)verwaltungObjekt.getBranchen());
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getDenkmalgeschuetzt());
        Skyscraper.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getHochhaus());
        EmphyteusisDuration.put((EstateImpl)estateImpl, (Number)verwaltungObjekt.getLaufzeit());
        PeopleMaximumCount.put((EstateImpl)estateImpl, (Number)verwaltungObjekt.getMaxPersonen());
        estateImpl.getAddress().setPublished(Boolean.TRUE.equals(verwaltungObjekt.getObjektadresseFreigeben()));
        Rented.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getVermietet());
        AuctionDate.put((EstateImpl)estateImpl, (Calendar)verwaltungObjekt.getVersteigerungstermin());
        WbsRequired.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getWbsSozialwohnung());
        AccessBeginDate.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)verwaltungObjekt.getZugang());
        Calendar calendar = verwaltungObjekt.getAbdatum();
        if (calendar != null) {
            AvailabilityBeginDate.put((EstateImpl)estateImpl, (Calendar)calendar);
        }
        if ((string2 = StringUtils.trimToNull((String)verwaltungObjekt.getVerfuegbarAb())) != null) {
            AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)string2);
        }
        if (calendar == null && string2 != null) {
            try {
                AvailabilityBeginDate.put((EstateImpl)estateImpl, (Date)OpenEstateUtils.parseDate((String)string2));
            }
            catch (Exception exception) {
                LOGGER.debug("Can't read <verfuegbar_ab>" + string2 + "</verfuegbar_ab> as date value!");
                LOGGER.debug("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (verwaltungObjekt.getGeschlecht() != null && verwaltungObjekt.getGeschlecht().getGeschlAttr() != null) {
            object2 = verwaltungObjekt.getGeschlecht().getGeschlAttr();
            if (Geschlecht.GeschlAttr.EGAL.equals(object2)) {
                GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.INDIFFERENT);
            } else if (Geschlecht.GeschlAttr.NUR_FRAU.equals(object2)) {
                GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.FEMALE);
            } else if (Geschlecht.GeschlAttr.NUR_MANN.equals(object2)) {
                GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.MALE);
            }
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.getGewerblicheNutzung())) {
            CommercialUse.put((EstateImpl)estateImpl, (CommercialUse.Option)CommercialUse.Option.YES);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.getGewerblicheNutzung())) {
            CommercialUse.put((EstateImpl)estateImpl, (CommercialUse.Option)CommercialUse.Option.NO);
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.getHaustiere())) {
            Pets.put((EstateImpl)estateImpl, (Pets.Option)Pets.Option.YES);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.getHaustiere())) {
            Pets.put((EstateImpl)estateImpl, (Pets.Option)Pets.Option.NO);
        }
        if (verwaltungObjekt.getMaxMietdauer() != null && !StringUtils.isBlank((CharSequence)verwaltungObjekt.getMaxMietdauer().getContent())) {
            object2 = verwaltungObjekt.getMaxMietdauer().getContent().trim();
            n = null;
            try {
                n = Integer.valueOf((String)object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = n != null ? NumberFormat.getIntegerInstance(this.getOpenEstateLanguage()).format(n) : object2;
            maxDauer = verwaltungObjekt.getMaxMietdauer().getMaxDauer();
            if (maxDauer != null) {
                object = (String)object + " ";
                if ("de".equalsIgnoreCase(this.getOpenEstateLanguage().getLanguage())) {
                    switch (maxDauer) {
                        case JAHR: {
                            object = (String)object + (n != null && n == 1 ? "Jahr" : "Jahre");
                            break;
                        }
                        case MONAT: {
                            object = (String)object + (n != null && n == 1 ? "Monat" : "Monate");
                            break;
                        }
                        case TAG: {
                            object = (String)object + (n != null && n == 1 ? "Tag" : "Tage");
                            break;
                        }
                        case WOCHE: {
                            object = (String)object + (n != null && n == 1 ? "Woche" : "Wochen");
                        }
                    }
                } else if ("en".equalsIgnoreCase(this.getOpenEstateLanguage().getLanguage())) {
                    switch (maxDauer) {
                        case JAHR: {
                            object = (String)object + (n != null && n == 1 ? "year" : "years");
                            break;
                        }
                        case MONAT: {
                            object = (String)object + (n != null && n == 1 ? "month" : "months");
                            break;
                        }
                        case TAG: {
                            object = (String)object + (n != null && n == 1 ? "day" : "days");
                            break;
                        }
                        case WOCHE: {
                            object = (String)object + (n != null && n == 1 ? "week" : "weeks");
                        }
                    }
                } else {
                    object = (String)object + maxDauer.value();
                }
            }
            OccupationPeriodMaximum.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)object);
        }
        if (verwaltungObjekt.getMinMietdauer() != null && !StringUtils.isBlank((CharSequence)verwaltungObjekt.getMinMietdauer().getContent())) {
            object2 = verwaltungObjekt.getMinMietdauer().getContent().trim();
            n = null;
            try {
                n = Integer.valueOf((String)object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = n != null ? NumberFormat.getIntegerInstance(this.getOpenEstateLanguage()).format(n) : object2;
            maxDauer = verwaltungObjekt.getMinMietdauer().getMinDauer();
            if (maxDauer != null) {
                object = (String)object + " ";
                if ("de".equalsIgnoreCase(this.getOpenEstateLanguage().getLanguage())) {
                    switch (1.$SwitchMap$org$openestate$io$openimmo$xml$MinMietdauer$MinDauer[maxDauer.ordinal()]) {
                        case 1: {
                            object = (String)object + (n != null && n == 1 ? "Jahr" : "Jahre");
                            break;
                        }
                        case 2: {
                            object = (String)object + (n != null && n == 1 ? "Monat" : "Monate");
                            break;
                        }
                        case 3: {
                            object = (String)object + (n != null && n == 1 ? "Tag" : "Tage");
                            break;
                        }
                        case 4: {
                            object = (String)object + (n != null && n == 1 ? "Woche" : "Wochen");
                        }
                    }
                } else if ("en".equalsIgnoreCase(this.getOpenEstateLanguage().getLanguage())) {
                    switch (1.$SwitchMap$org$openestate$io$openimmo$xml$MinMietdauer$MinDauer[maxDauer.ordinal()]) {
                        case 1: {
                            object = (String)object + (n != null && n == 1 ? "year" : "years");
                            break;
                        }
                        case 2: {
                            object = (String)object + (n != null && n == 1 ? "month" : "months");
                            break;
                        }
                        case 3: {
                            object = (String)object + (n != null && n == 1 ? "day" : "days");
                            break;
                        }
                        case 4: {
                            object = (String)object + (n != null && n == 1 ? "week" : "weeks");
                        }
                    }
                } else {
                    object = (String)object + maxDauer.value();
                }
            }
            OccupationPeriodMinimum.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)object);
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.getNichtraucher())) {
            NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)NonSmoker.Option.YES);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.getNichtraucher())) {
            NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)NonSmoker.Option.NO);
        }
    }

    protected void readImmobilieVerwaltungTechn(VerwaltungTechn verwaltungTechn, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        if (verwaltungTechn == null) {
            return;
        }
        estateImpl.setPublishEnd(verwaltungTechn.getAktivBis() != null ? verwaltungTechn.getAktivBis().getTime() : null);
        estateImpl.setPublishBegin(verwaltungTechn.getAktivVon() != null ? verwaltungTechn.getAktivVon().getTime() : null);
        estateImpl.setId(string);
        estateImpl.setPublicId(verwaltungTechn.getObjektnrExtern());
        EffectiveDate.put((EstateImpl)estateImpl, (Calendar)verwaltungTechn.getStandVom());
        if (verwaltungTechn.getAktion() != null && verwaltungTechn.getAktion().getAktionart() != null) {
            estateImpl.getCustomValues().putCustomValue("openimmo.aktion", (Object)verwaltungTechn.getAktion().getAktionart().value(), 5);
        } else {
            estateImpl.getCustomValues().putCustomValue("openimmo.aktion", (Object)Aktion.AktionArt.CHANGE.value(), 5);
        }
        if (verwaltungTechn.getKennungUrsprung() != null) {
            estateImpl.getCustomValues().putCustomValue("openimmo.kennung_ursprung", (Object)verwaltungTechn.getKennungUrsprung(), 5);
        }
        if (verwaltungTechn.getOpenimmoObid() != null) {
            estateImpl.getCustomValues().putCustomValue("openimmo.openimmo_obid", (Object)verwaltungTechn.getOpenimmoObid(), 5);
        }
    }

    protected void readImmobilieWeitereAdressen(List<WeitereAdresse> list, EstateImpl estateImpl, List<OpenEstateType> list2, String string) {
    }

    protected void readImmobilieZustandAngaben(ZustandAngaben zustandAngaben, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        Alter.AlterAttr alterAttr;
        if (zustandAngaben == null) {
            return;
        }
        ContaminatedSites.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)zustandAngaben.getAltlasten());
        if (zustandAngaben.getAlter() != null && zustandAngaben.getAlter().getAlterAttr() != null) {
            alterAttr = zustandAngaben.getAlter().getAlterAttr();
            if (Alter.AlterAttr.ALTBAU.equals((Object)alterAttr)) {
                Age.put((EstateImpl)estateImpl, (Age.Option)Age.Option.OLD_BUILDING);
            } else if (Alter.AlterAttr.NEUBAU.equals((Object)alterAttr)) {
                Age.put((EstateImpl)estateImpl, (Age.Option)Age.Option.NEW_BUILDING);
            }
        }
        BuildYear.put((EstateImpl)estateImpl, (String)zustandAngaben.getBaujahr());
        RefurbishmentYear.put((EstateImpl)estateImpl, (String)zustandAngaben.getLetztemodernisierung());
        if (zustandAngaben.getBebaubarNach() != null && zustandAngaben.getBebaubarNach().getBebaubarAttr() != null) {
            alterAttr = zustandAngaben.getBebaubarNach().getBebaubarAttr();
            if (BebaubarNach.BebaubarAttr.NACHBARSCHAFT.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.NEIGHBORING_DEVELOPMENT);
            } else if (BebaubarNach.BebaubarAttr.AUSSENGEBIET.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.PERIPHERY_DEVELOPMENT);
            } else if (BebaubarNach.BebaubarAttr.BAUERWARTUNGSLAND.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.GREENFIELD_DEVELOPMENT);
            } else if (BebaubarNach.BebaubarAttr.BAULAND_OHNE_B_PLAN.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.NO_SITE_PLAN);
            } else if (BebaubarNach.BebaubarAttr.B_PLAN.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.BINDING_SITE_PLAN);
            } else if (BebaubarNach.BebaubarAttr.KEIN_BAULAND.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.NO_DEVELOPMENT_AREA);
            }
        }
        if (!zustandAngaben.getEnergiepass().isEmpty()) {
            Integer n;
            String string2;
            Object object;
            Object object2;
            String string3;
            alterAttr = (Energiepass)zustandAngaben.getEnergiepass().get(0);
            Energiepass.Epart epart = alterAttr.getEpart();
            boolean bl = false;
            Number number = null;
            if (Energiepass.Epart.BEDARF.equals((Object)epart)) {
                number = OpenEstateUtils.parseNumber((String)alterAttr.getEndenergiebedarf());
                if (number != null) {
                    bl = true;
                    Type.put((EstateImpl)estateImpl, (Type.Option)Type.Option.DEMAND);
                    DemandTotal.put((EstateImpl)estateImpl, (Number)number, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                }
            } else if (Energiepass.Epart.VERBRAUCH.equals((Object)epart) && (number = OpenEstateUtils.parseNumber((String)alterAttr.getEnergieverbrauchkennwert())) != null) {
                bl = true;
                Type.put((EstateImpl)estateImpl, (Type.Option)Type.Option.CONSUMPTION);
                ConsumptionTotal.put((EstateImpl)estateImpl, (Number)number, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                ConsumptionIncludingHotWater.put((EstateImpl)estateImpl, (Boolean)alterAttr.getMitwarmwasser());
            }
            Available.put((EstateImpl)estateImpl, (Boolean)bl);
            if (bl) {
                CreationDate.put((EstateImpl)estateImpl, (Calendar)alterAttr.getAusstelldatum());
                string3 = StringUtils.trimToNull((String)alterAttr.getGueltigBis());
                if (string3 != null) {
                    try {
                        object2 = OpenEstateUtils.parseDate((String)string3);
                        ExpirationDate.put((EstateImpl)estateImpl, (Date)object2);
                    }
                    catch (ParseException parseException) {
                        LOGGER.warn("Can't read <gueltigBis>" + string3 + "</gueltigBis> as date value!");
                        LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
                        this.putError(string, "Can't read <gueltigBis>" + string3 + "</gueltigBis> as date value! " + parseException.getLocalizedMessage());
                    }
                }
            }
            string3 = null;
            object2 = StringUtils.trimToNull((String)alterAttr.getWertklasse());
            if (object2 != null) {
                object = EfficiencyCategory.Option.values();
                int n2 = ((EfficiencyCategory.Option[])object).length;
                for (int i = 0; i < n2; ++i) {
                    EfficiencyCategory.Option option = object[i];
                    if (!option.name().equalsIgnoreCase((String)object2) && !option.getTranslation(Locale.ENGLISH).equalsIgnoreCase((String)object2)) continue;
                    string3 = option;
                    break;
                }
            }
            if (string3 == null && estateImpl.getAddress() != null) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)OpenEstateUtils.getEnergyEfficiencyCategory((Number)number, (String)estateImpl.getAddress().getCountry()));
            }
            if (string3 != null) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)string3);
            }
            if ((object = StringUtils.trimToNull((String)alterAttr.getStromwert())) != null) {
                Double d = null;
                try {
                    d = Double.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn("Can't read <epass_stromwert>" + (String)object + "</epass_stromwert> as numeric value!");
                    LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    this.putError(string, "Can't read <epass_stromwert>" + (String)object + "</epass_stromwert> as numeric value! " + numberFormatException.getLocalizedMessage());
                }
                if (d != null && d > 0.0) {
                    if (Energiepass.Epart.BEDARF.equals((Object)epart)) {
                        DemandElectricity.put((EstateImpl)estateImpl, (Number)d, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    } else if (Energiepass.Epart.VERBRAUCH.equals((Object)epart)) {
                        ConsumptionElectricity.put((EstateImpl)estateImpl, (Number)d, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    }
                }
            }
            if ((string2 = StringUtils.trimToNull((String)alterAttr.getWaermewert())) != null) {
                Double d = null;
                try {
                    d = Double.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn("Can't read <epass_waermewert>" + string2 + "</epass_waermewert> as numeric value!");
                    LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    this.putError(string, "Can't read <epass_waermewert>" + string2 + "</epass_waermewert> as numeric value! " + numberFormatException.getLocalizedMessage());
                }
                if (d != null && d > 0.0) {
                    if (Energiepass.Epart.BEDARF.equals((Object)epart)) {
                        DemandHeating.put((EstateImpl)estateImpl, (Number)d, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    } else if (Energiepass.Epart.VERBRAUCH.equals((Object)epart)) {
                        ConsumptionHeating.put((EstateImpl)estateImpl, (Number)d, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    }
                }
            }
            if ((n = BuildYear.getAsInteger((EstateImpl)estateImpl)) == null || n < 1) {
                BuildYear.put((EstateImpl)estateImpl, (String)StringUtils.trimToNull((String)alterAttr.getBaujahr()));
            }
            AustriaThermalHeatDemand.put((EstateImpl)estateImpl, (String)alterAttr.getHwbwert(), (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            AustriaTotalEnergyEfficiencyFactor.put((EstateImpl)estateImpl, (String)alterAttr.getFgeewert());
        }
        if (zustandAngaben.getErschliessung() != null && zustandAngaben.getErschliessung().getErschlAttr() != null) {
            alterAttr = zustandAngaben.getErschliessung().getErschlAttr();
            if (Erschliessung.ErschlAttr.ORTSUEBLICHERSCHLOSSEN.equals((Object)alterAttr)) {
                Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.ACCORDING_LOCAL_PRACTICE);
            } else if (Erschliessung.ErschlAttr.TEILERSCHLOSSEN.equals((Object)alterAttr)) {
                Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.PARTIALLY);
            } else if (Erschliessung.ErschlAttr.UNERSCHLOSSEN.equals((Object)alterAttr)) {
                Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.UNDEVELOPED);
            } else if (Erschliessung.ErschlAttr.VOLLERSCHLOSSEN.equals((Object)alterAttr)) {
                Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.COMPLETELY);
            }
        }
        if (zustandAngaben.getZustand() != null && zustandAngaben.getZustand().getZustandArt() != null) {
            alterAttr = zustandAngaben.getZustand().getZustandArt();
            if (Zustand.ZustandArt.ABRISSOBJEKT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.CONDEMNED);
            } else if (Zustand.ZustandArt.BAUFAELLIG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.DILAPIDATED);
            } else if (Zustand.ZustandArt.ENTKERNT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.GUTTED);
            } else if (Zustand.ZustandArt.ERSTBEZUG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FIRST_OCCUPANCY);
            } else if (Zustand.ZustandArt.GEPFLEGT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.WELL_TENDED);
            } else if (Zustand.ZustandArt.MODERNISIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.MODERNIZED);
            } else if (Zustand.ZustandArt.NACH_VEREINBARUNG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_APPOINTED);
            } else if (Zustand.ZustandArt.NEUWERTIG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_GOOD_AS_NEW);
            } else if (Zustand.ZustandArt.PROJEKTIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.PROJECTED);
            } else if (Zustand.ZustandArt.ROHBAU.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.SHELL_CONSTRUCTION);
            } else if (Zustand.ZustandArt.SANIERUNGSBEDUERFTIG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.COMPLETE_REFURBISHMENT_REQUIRED);
            } else if (Zustand.ZustandArt.TEIL_SANIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.PARTIALLY_REFURBISHED);
            } else if (Zustand.ZustandArt.TEIL_VOLLRENOVIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_RENOVATED);
            } else if (Zustand.ZustandArt.TEIL_VOLLRENOVIERUNGSBED.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.PARTIAL_RENOVATION_REQUIRED);
            } else if (Zustand.ZustandArt.TEIL_VOLLSANIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_REFURBISHED);
            } else if (Zustand.ZustandArt.VOLL_SANIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_REFURBISHED);
            }
        }
    }
}

