/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.layout.CellConstraints;
import com.openindex.openestate.impl.AddressImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.gui.DefaultAddressPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.DefaultWebLinkField;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyContactAddressPanel
extends DefaultAddressPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactAddressPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactAddressPanel.class);
    private final ModificationHandler modifications = ImmoToolUtils.createModificationHandler();
    private JXTitledSeparator additionalTitle;
    private JLabel contactWebsiteLabel;
    protected DefaultWebLinkField contactWebsiteField;
    private JLabel contactOfficeHoursLabel;
    protected DefaultTextArea contactOfficeHoursField;

    public AgencyContactAddressPanel() {
        super((AddressImpl)new AgentContactImpl(), 1);
    }

    public AgencyContactAddressPanel(int n) {
        super((AddressImpl)new AgentContactImpl(), 1, n);
    }

    protected void finishPersonPanel(DefaultFormBuilder defaultFormBuilder) {
        super.finishPersonPanel(defaultFormBuilder);
        defaultFormBuilder.add((Component)new JLabel()).xyw(1, defaultFormBuilder.nextRow(), defaultFormBuilder.getNumberOfColumns());
        this.additionalTitle = ImmoToolUtils.createHead2Separator((String)"");
        defaultFormBuilder.add((Component)this.additionalTitle).xyw(1, defaultFormBuilder.nextRow(), defaultFormBuilder.getNumberOfColumns());
        this.contactWebsiteLabel = new JLabel();
        this.contactWebsiteField = new DefaultWebLinkField(true);
        defaultFormBuilder.add((Component)this.contactWebsiteLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.contactWebsiteField).xyw(3, defaultFormBuilder.row(), defaultFormBuilder.getNumberOfColumns() - 2);
        this.contactOfficeHoursLabel = new JLabel();
        this.contactOfficeHoursField = new DefaultTextArea();
        defaultFormBuilder.add((Component)this.contactOfficeHoursLabel).xy(1, defaultFormBuilder.nextRow(), CellConstraints.DEFAULT, CellConstraints.TOP);
        defaultFormBuilder.addRaw((Component)this.contactOfficeHoursField.createScrollPane()).xyw(3, defaultFormBuilder.row(), defaultFormBuilder.getNumberOfColumns() - 2);
    }

    protected void init() {
        this.registerValidation(this.addressCountryField);
        this.registerValidation(this.personFirstNameField);
        this.registerValidation(this.personLastNameField);
        this.registerValidation(this.personMailField);
        this.registerValidation(this.personPhoneField);
        this.registerValidation((JComponent)this.contactWebsiteField, ValidationHandler.URL_OR_NULL);
    }

    public void initInputs() {
        super.initInputs();
        this.contactWebsiteField.init();
    }

    public boolean isModifiedInput() {
        return super.isModifiedInput() || this.modifications.isModified();
    }

    public void load(DbAgencyContact dbAgencyContact) {
        this.loadAddress((AddressImpl)(dbAgencyContact != null && dbAgencyContact.item != null ? dbAgencyContact.item : new AgentContactImpl()));
        this.contactWebsiteField.setUrl(dbAgencyContact != null && dbAgencyContact.item != null ? dbAgencyContact.item.getContactWebsite() : null);
        String string = dbAgencyContact != null && dbAgencyContact.item != null ? dbAgencyContact.item.getContactOfficeHours() : null;
        this.contactOfficeHoursField.setText(StringUtils.trimToEmpty((String)string));
        this.contactOfficeHoursField.setCaretPosition(0);
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.contactWebsiteField);
        this.modifications.putValue((JComponent)this.contactOfficeHoursField);
    }

    public void save(DbAgencyContact dbAgencyContact) {
        if (dbAgencyContact.item == null) {
            dbAgencyContact.item = new AgentContactImpl();
        }
        this.saveAddress((AddressImpl)dbAgencyContact.item);
        dbAgencyContact.item.setContactWebsite(this.contactWebsiteField.getUrl());
        dbAgencyContact.item.setContactOfficeHours(this.contactOfficeHoursField.getText().trim());
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.contactWebsiteField.setEditable(bl);
        this.contactOfficeHoursField.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.contactWebsiteField.setEnabled(bl);
        this.contactOfficeHoursField.setEnabled(bl);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.additionalTitle.setTitle(StringUtils.capitalize((String)I18N.tr("additional information")));
        this.contactWebsiteLabel.setText(StringUtils.capitalize((String)I18N.tr("website")) + ":");
        this.contactWebsiteField.setToolTipText(I18N.tr("Enter the website of the contact person."));
        this.contactOfficeHoursLabel.setText(StringUtils.capitalize((String)I18N.tr("office hours")) + ":");
        this.contactOfficeHoursField.setToolTipText(I18N.tr("Enter the office hours, when the contact person is available for customers."));
    }
}

