/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContactViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyContactViewTask
extends ImmoToolTask<AgencyContactViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactViewTask.class);
    private final long contactId;
    private final boolean selectCreatedTab;
    private final AgencyContactViewPanel viewTab;
    private final AbstractDbDriver dbDriver;

    public AgencyContactViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public AgencyContactViewTask(AbstractDbDriver abstractDbDriver, long l, AgencyContactViewPanel agencyContactViewPanel) {
        super(I18N.tr("Loading contact person {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.contactId = l;
        this.selectCreatedTab = true;
        this.viewTab = agencyContactViewPanel;
    }

    public AgencyContactViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading contact person {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.contactId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AgencyContactViewPanel doInBackground() throws Exception {
        Connection connection2;
        Object object;
        block8: {
            DbAgencyContactsHandler dbAgencyContactsHandler = AgencyPlugin.getDbAgencyExtension().getContactsHandler();
            if (this.viewTab == null) {
                object = ImmoToolAppUtils.getTabs(AgencyContactViewPanel.class);
                for (AbstractMainTab abstractMainTab : object) {
                    AgencyContactViewPanel agencyContactViewPanel = (AgencyContactViewPanel)abstractMainTab;
                    if (this.contactId < 1L && agencyContactViewPanel.getCurrentContactId() < 1L) {
                        if (!this.selectCreatedTab) return null;
                        ImmoToolAppUtils.selectTab((Component)((Object)agencyContactViewPanel));
                        return null;
                    }
                    if (this.contactId <= 0L || agencyContactViewPanel.getCurrentContactId() != this.contactId) continue;
                    if (!this.selectCreatedTab) return null;
                    ImmoToolAppUtils.selectTab((Component)((Object)agencyContactViewPanel));
                    return null;
                }
            }
            if (this.contactId < 1L) {
                return this.viewTab != null ? this.viewTab : AgencyContactViewPanel.createTab();
            }
            Connection connection = null;
            try {
                connection2 = this.dbDriver.getConnection();
                DbAgencyContact dbAgencyContact = (DbAgencyContact)dbAgencyContactsHandler.getContact(connection2, this.contactId);
                if (dbAgencyContact == null) {
                    throw new SQLException("Can't find contact person #" + this.contactId + "!");
                }
                if (this.viewTab == null) {
                    object = AgencyContactViewPanel.createTab(dbAgencyContact);
                    break block8;
                }
                object = this.viewTab;
                ((AgencyContactViewPanel)((Object)object)).setContact(dbAgencyContact);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Connection)connection2);
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)"Can't load contact person!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(AgencyContactViewPanel agencyContactViewPanel) {
        super.succeeded((Object)agencyContactViewPanel);
        if (agencyContactViewPanel != null) {
            if (this.viewTab == null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyContactViewPanel, (boolean)this.selectCreatedTab);
            }
            agencyContactViewPanel.loadInBackground(this.dbDriver);
        }
    }
}

