/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.db.DbLinksHandler;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewLinksPanel
extends AgencyEstateViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewLinksPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewLinksPanel.class);
    private static final String TABLE_ID = "AgencyEstateViewLinksPanel.Table";
    private WeakReference<DbAgencyObject> currentObject = null;
    private List<Locale> currentLanguages;
    private DbLink currentLink = null;
    private boolean isLoaded = false;
    private boolean isModified = false;
    private JSplitPane splitPane;
    private JXTitledSeparator linksTitle;
    private Table linksTable;
    private JXTitledSeparator linkFormTitle;
    private JCheckBox linkPublishedField;
    private JLabel linkTypeLabel;
    private JComboBox<EstateLinkProvider> linkTypeField;
    private JLabel linkValueLabel;
    private JTextField linkValueField;
    private Map<Locale, JTextField> linkTextFields;
    private Map<Locale, JLabel> linkTextLabels;
    private AbstractI18nAction linkAddAction;
    private AbstractI18nAction linkMoveDownAction;
    private AbstractI18nAction linkMoveUpAction;
    private AbstractI18nAction linkOpenAction;
    private AbstractI18nAction linkRemoveAction;

    public AgencyEstateViewLinksPanel() {
        this.build();
    }

    private void build() {
        this.currentLanguages = new ArrayList<Locale>(Arrays.asList(AgencyPlugin.getLocales()));
        this.splitPane = new JSplitPane(0);
        this.splitPane.setBorder(Paddings.EMPTY);
        this.splitPane.setTopComponent(this.buildTableComponent());
        this.splitPane.setBottomComponent(this.buildFormComponent());
        this.splitPane.getBottomComponent().setVisible(false);
        this.splitPane.setDividerLocation(0.8);
        this.setBorder(Paddings.EMPTY);
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.splitPane, "Center");
        this.updateLocalization();
    }

    private JComponent buildFormComponent() {
        this.linkValueLabel = new JLabel();
        this.linkValueField = new JTextField();
        this.linkValueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!AgencyEstateViewLinksPanel.this.linkValueField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewLinksPanel.this.currentLink == null) {
                    return;
                }
                AgencyEstateViewLinksPanel.this.setLinkTarget();
                AgencyEstateViewLinksPanel.this.isModified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (!AgencyEstateViewLinksPanel.this.linkValueField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewLinksPanel.this.currentLink == null) {
                    return;
                }
                AgencyEstateViewLinksPanel.this.setLinkTarget();
                AgencyEstateViewLinksPanel.this.isModified = true;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (!AgencyEstateViewLinksPanel.this.linkValueField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewLinksPanel.this.currentLink == null) {
                    return;
                }
                AgencyEstateViewLinksPanel.this.setLinkTarget();
                AgencyEstateViewLinksPanel.this.isModified = true;
            }
        });
        this.linkPublishedField = new JCheckBox();
        this.linkPublishedField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewLinksPanel.this.linkPublishedField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewLinksPanel.this.currentLink == null) {
                    return;
                }
                ((AgencyEstateViewLinksPanel)AgencyEstateViewLinksPanel.this).currentLink.published = AgencyEstateViewLinksPanel.this.linkPublishedField.isSelected();
                AgencyEstateViewLinksPanel.this.isModified = true;
                AgencyEstateViewLinksPanel.this.linksTable.updateSelectedRow();
            }
        });
        this.linkTypeLabel = new JLabel();
        this.linkTypeField = new JComboBox();
        this.linkTypeField.setRenderer((ListCellRenderer<EstateLinkProvider>)new DefaultListCellRenderer((Renderer)new ProviderRenderer()));
        this.linkTypeField.addItem(null);
        TreeMap<String, EstateLinkProvider> treeMap = new TreeMap<String, EstateLinkProvider>();
        for (EstateLinkProvider object : EstateLinkProvider.values()) {
            treeMap.put(object.getXmlName(), object);
        }
        for (EstateLinkProvider estateLinkProvider : treeMap.values()) {
            this.linkTypeField.addItem(estateLinkProvider);
        }
        this.linkTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewLinksPanel.this.linkTypeField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewLinksPanel.this.currentLink == null) {
                    return;
                }
                EstateLinkProvider estateLinkProvider = (EstateLinkProvider)AgencyEstateViewLinksPanel.this.linkTypeField.getSelectedItem();
                if (estateLinkProvider == null) {
                    ((AgencyEstateViewLinksPanel)AgencyEstateViewLinksPanel.this).currentLink.provider = null;
                    ((AgencyEstateViewLinksPanel)AgencyEstateViewLinksPanel.this).currentLink.providerLinkId = null;
                    try {
                        ((AgencyEstateViewLinksPanel)AgencyEstateViewLinksPanel.this).currentLink.webLinkUrl = new URI(AgencyEstateViewLinksPanel.this.linkValueField.getText().trim());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOGGER.warn("Can't use modified link!");
                        LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                    }
                } else {
                    ((AgencyEstateViewLinksPanel)AgencyEstateViewLinksPanel.this).currentLink.webLinkUrl = null;
                    ((AgencyEstateViewLinksPanel)AgencyEstateViewLinksPanel.this).currentLink.provider = estateLinkProvider;
                    ((AgencyEstateViewLinksPanel)AgencyEstateViewLinksPanel.this).currentLink.providerLinkId = AgencyEstateViewLinksPanel.this.linkValueField.getText().trim();
                }
                AgencyEstateViewLinksPanel.this.isModified = true;
                AgencyEstateViewLinksPanel.this.updateLocalization();
                AgencyEstateViewLinksPanel.this.linksTable.updateSelectedRow();
            }
        });
        this.linkTextFields = new HashMap<Locale, JTextField>();
        this.linkTextLabels = new HashMap<Locale, JLabel>();
        TreeMap treeMap2 = new TreeMap();
        for (Locale locale : this.currentLanguages) {
            treeMap2.put(locale.getDisplayLanguage(), locale);
        }
        for (final Locale locale : treeMap2.values()) {
            final JTextField jTextField = new JTextField();
            this.linkTextFields.put(locale, jTextField);
            jTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (!jTextField.isEnabled()) {
                        return;
                    }
                    if (AgencyEstateViewLinksPanel.this.currentLink == null) {
                        return;
                    }
                    AgencyEstateViewLinksPanel.this.setLinkTitle(jTextField.getText(), locale);
                    AgencyEstateViewLinksPanel.this.isModified = true;
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (!jTextField.isEnabled()) {
                        return;
                    }
                    if (AgencyEstateViewLinksPanel.this.currentLink == null) {
                        return;
                    }
                    AgencyEstateViewLinksPanel.this.setLinkTitle(jTextField.getText(), locale);
                    AgencyEstateViewLinksPanel.this.isModified = true;
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (!jTextField.isEnabled()) {
                        return;
                    }
                    if (AgencyEstateViewLinksPanel.this.currentLink == null) {
                        return;
                    }
                    AgencyEstateViewLinksPanel.this.setLinkTitle(jTextField.getText(), locale);
                    AgencyEstateViewLinksPanel.this.isModified = true;
                }
            });
            Serializable serializable = new JLabel();
            serializable.setHorizontalTextPosition(10);
            serializable.setIcon(ImmoToolUtils.getCountryFlagIcon((Locale)locale));
            this.linkTextLabels.put(locale, (JLabel)serializable);
        }
        this.linkFormTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.linkOpenAction = new LinkOpenAction();
        this.linkRemoveAction = new LinkRemoveAction();
        this.linkMoveUpAction = new LinkMoveUpAction();
        this.linkMoveDownAction = new LinkMoveDownAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.linkFormTitle, (Action[])new Action[]{this.linkMoveUpAction, this.linkMoveDownAction, this.linkOpenAction, this.linkRemoveAction});
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.border((Border)Paddings.DIALOG);
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.linkTypeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.linkTypeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.linkPublishedField).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.linkValueLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.linkValueField).xyw(3, defaultFormBuilder.row(), 3);
        for (Serializable serializable : treeMap2.values()) {
            defaultFormBuilder.add((Component)this.linkTextLabels.get(serializable)).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.linkTextFields.get(serializable)).xyw(3, defaultFormBuilder.row(), 3);
        }
        return defaultFormBuilder.getPanel();
    }

    private JComponent buildTableComponent() {
        this.linksTable = new Table();
        this.linksTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.linkAddAction = new LinkAddAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.linksTitle, (Action[])new Action[]{this.linkAddAction});
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder((Border)Paddings.DIALOG);
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.linksTable.createScrollPane(), "Center");
        return jPanel2;
    }

    private void doLinkAdd() {
        URI uRI;
        block8: {
            String string = ImmoToolUtils.showInputDialog((String)I18N.tr("Please enter an address, that you want to assign to the property as web-link."), (Component)((Object)this));
            if (StringUtils.isBlank((CharSequence)string)) {
                return;
            }
            uRI = null;
            try {
                uRI = new URI(string.trim());
            }
            catch (URISyntaxException uRISyntaxException) {
                try {
                    if (!string.startsWith("http://") && !string.startsWith("https://")) {
                        uRI = new URI("http://" + string.trim());
                    }
                }
                catch (URISyntaxException uRISyntaxException2) {
                    // empty catch block
                }
                if (uRI != null) break block8;
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided web-link is invalid and can't be assigned to the property!"), (Throwable)uRISyntaxException, (Window)ImmoToolEnvironment.getFrame());
                return;
            }
        }
        DbLink dbLink = new DbLink();
        dbLink.position = this.linksTable.getRowCount();
        dbLink.published = true;
        dbLink.translations = new HashMap();
        for (EstateLinkProvider estateLinkProvider : EstateLinkProvider.values()) {
            String string = estateLinkProvider.getLinkIdFromUrl(uRI.toString());
            if (string == null) continue;
            dbLink.provider = estateLinkProvider;
            dbLink.providerLinkId = string;
            break;
        }
        if (dbLink.provider == null) {
            dbLink.webLinkUrl = uRI;
        }
        this.linksTable.setEnabled(false);
        this.linksTable.addRow(new TableRow(dbLink));
        this.linksTable.getSelectionModel().setSelectionInterval(dbLink.position, dbLink.position);
        this.linksTable.setEnabled(true);
        this.selectLink(dbLink, true);
        this.updateTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLinkMoveDown() {
        if (this.currentLink == null) {
            return;
        }
        int n = this.currentLink.position;
        int n2 = n + 1;
        if (n2 >= this.linksTable.getRowCount()) {
            return;
        }
        this.linksTable.setEnabled(false);
        try {
            DbLink dbLink = this.linksTable.getLinkAt(n2);
            if (dbLink == null) {
                return;
            }
            dbLink.position = n;
            this.currentLink.position = n2;
            this.linksTable.moveRow(n, n2);
            this.linksTable.clearSelection();
            this.linksTable.getSelectionModel().addSelectionInterval(n2, n2);
        }
        finally {
            this.isModified = true;
            this.setFormButtonsEnabled(true);
            this.linksTable.setEnabled(true);
            this.linksTable.updateRow(n);
            this.linksTable.updateRow(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLinkMoveUp() {
        if (this.currentLink == null) {
            return;
        }
        int n = this.currentLink.position;
        if (n < 1) {
            return;
        }
        int n2 = n - 1;
        this.linksTable.setEnabled(false);
        try {
            DbLink dbLink = this.linksTable.getLinkAt(n2);
            if (dbLink == null) {
                return;
            }
            dbLink.position = n;
            this.currentLink.position = n2;
            this.linksTable.moveRow(n, n2);
            this.linksTable.clearSelection();
            this.linksTable.getSelectionModel().addSelectionInterval(n2, n2);
        }
        finally {
            this.isModified = true;
            this.setFormButtonsEnabled(true);
            this.linksTable.setEnabled(true);
            this.linksTable.updateRow(n);
            this.linksTable.updateRow(n2);
        }
    }

    private void doLinkOpen() {
        if (this.currentLink == null) {
            return;
        }
        URI uRI = this.currentLink.provider != null && this.currentLink.providerLinkId != null ? this.currentLink.provider.getUrlFromLinkId(this.currentLink.providerLinkId) : this.currentLink.webLinkUrl;
        if (uRI == null) {
            return;
        }
        ImmoToolUtils.openURL((URI)uRI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLinkRemove() {
        DbLink dbLink;
        int n;
        if (this.currentLink == null) {
            return;
        }
        int n2 = this.linksTable.getSelectedRow();
        if (n2 < 0) {
            return;
        }
        this.linksTable.setEnabled(false);
        this.linksTable.removeRow(n2);
        for (n = 0; n < this.linksTable.getRowCount(); ++n) {
            dbLink = this.linksTable.getLinkAt(n);
            if (dbLink == null) continue;
            dbLink.position = n;
        }
        this.linksTable.getModel().fireTableDataChanged();
        try {
            n = this.linksTable.getRowCount();
            if (n > n2) {
                this.linksTable.getSelectionModel().setSelectionInterval(n2, n2);
            } else if (n > 0) {
                this.linksTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            } else {
                this.linksTable.clearSelection();
            }
        }
        finally {
            this.updateTitle();
            this.isModified = true;
            this.linksTable.setEnabled(true);
            n = this.linksTable.getSelectedRow();
            if (n < 0) {
                this.selectLink(null, true);
            } else {
                dbLink = this.linksTable.getLinkAt(n);
                this.selectLink(dbLink, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        DbAgencyObject dbAgencyObject;
        DbAgencyObject dbAgencyObject2 = dbAgencyObject = this.currentObject != null ? (DbAgencyObject)((Object)this.currentObject.get()) : null;
        if (dbAgencyObject == null || dbAgencyObject.id < 1L) {
            this.isLoaded = true;
            return;
        }
        this.linksTable.setEnabled(false);
        this.linksTable.clearSelection();
        this.linksTable.clearRows();
        this.updateTitle();
        ArrayList<DbLink> arrayList = new ArrayList<DbLink>();
        try {
            DbLinksHandler dbLinksHandler = AgencyPlugin.getDbAgencyExtension().getLinksHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            DbLink[] dbLinkArray = dbLinksHandler.getLinks(connection, dbAgencyObject.id, null, null);
            dbLinksHandler.loadLinkTranslations(connection, dbLinkArray, dbLanguagesHandler);
            arrayList.addAll(Arrays.asList(dbLinkArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$linkList;
                {
                    this.val$linkList = list;
                }

                @Override
                public void run() {
                    try {
                        for (DbLink dbLink : this.val$linkList) {
                            dbLink.position = AgencyEstateViewLinksPanel.this.linksTable.getRowCount();
                            AgencyEstateViewLinksPanel.this.linksTable.addRow(new TableRow(dbLink));
                        }
                    }
                    finally {
                        AgencyEstateViewLinksPanel.this.linksTable.setEnabled(true);
                        AgencyEstateViewLinksPanel.this.linksTable.packAll();
                        AgencyEstateViewLinksPanel.this.isLoaded = true;
                        AgencyEstateViewLinksPanel.this.updateTitle();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("web-links"));
    }

    public boolean isTabEnabled() {
        return this.isLoaded;
    }

    public boolean isTabModified() {
        return this.isModified;
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    @Override
    public void load(DbAgencyObject dbAgencyObject) {
        this.isLoaded = false;
        this.isModified = false;
        this.currentLink = null;
        this.currentObject = new WeakReference<DbAgencyObject>(dbAgencyObject);
        this.selectLink(null, true);
        this.linksTable.clearRows();
        this.updateTitle();
        List list = dbAgencyObject.item.getLanguages();
        for (Locale locale : AgencyPlugin.getLocales()) {
            this.selectLanguage(locale, list.contains(locale.toString()));
        }
    }

    @Override
    public void save(DbAgencyObject dbAgencyObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException, IOException {
        super.saveFinished(connection, immoToolProject, dbAgencyObject);
        this.setTableButtonsEnabled(false);
        this.setFormButtonsEnabled(false);
        DbLinksHandler dbLinksHandler = AgencyPlugin.getDbAgencyExtension().getLinksHandler();
        DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
        try {
            Map map = dbLanguagesHandler.getLanguageMap(connection);
            ArrayList<Long> arrayList = new ArrayList<Long>(Arrays.asList(ArrayUtils.toObject((long[])dbLinksHandler.getLinkIds(connection, dbAgencyObject.id, null, null))));
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (int i = 0; i < this.linksTable.getRowCount(); ++i) {
                DbLink object = this.linksTable.getLinkAt(i);
                if (object == null) continue;
                object.objectId = dbAgencyObject.id;
                dbLinksHandler.saveLink(connection, object, map);
                arrayList2.add(object.id);
            }
            for (Long l : arrayList) {
                if (arrayList2.contains(l)) continue;
                LOGGER.debug("Remove unused link #" + l);
                dbLinksHandler.removeLink(connection, l.longValue());
            }
        }
        finally {
            this.setTableButtonsEnabled(true);
            this.setFormButtonsEnabled(true);
        }
    }

    private void selectLink(DbLink dbLink, boolean bl) {
        this.currentLink = dbLink;
        this.splitPane.getBottomComponent().setVisible(dbLink != null);
        if (dbLink == null) {
            return;
        }
        this.linkTypeField.setEnabled(false);
        this.linkTypeField.setSelectedItem(dbLink.provider);
        this.linkTypeField.setEnabled(true);
        this.linkValueField.setEnabled(false);
        if (dbLink.provider == null) {
            this.linkValueField.setText(dbLink.webLinkUrl != null ? dbLink.webLinkUrl.toString() : "");
        } else {
            this.linkValueField.setText(dbLink.providerLinkId != null ? dbLink.providerLinkId : "");
        }
        this.linkValueField.setEnabled(true);
        this.linkPublishedField.setEnabled(false);
        this.linkPublishedField.setSelected(dbLink.published);
        this.linkPublishedField.setEnabled(true);
        for (Map.Entry<Locale, JTextField> entry : this.linkTextFields.entrySet()) {
            Locale locale = entry.getKey();
            JTextField jTextField = entry.getValue();
            String string = locale.toString();
            String string2 = dbLink.translations != null && dbLink.translations.containsKey(string) ? ((DbLink.Translation)dbLink.translations.get((Object)string)).title : null;
            jTextField.setEnabled(false);
            jTextField.setText(StringUtils.trimToEmpty(string2));
            jTextField.setCaretPosition(0);
            jTextField.setEnabled(true);
        }
        this.updateLocalization();
        this.updateDividerLocation();
        if (bl) {
            this.setFormButtonsEnabled(true);
        }
    }

    private void setFormButtonsEnabled(boolean bl) {
        int n = this.currentLink != null ? this.currentLink.position : -1;
        this.linkMoveUpAction.setEnabled(bl && n > 0);
        this.linkMoveDownAction.setEnabled(bl && n > -1 && n + 1 < this.linksTable.getRowCount());
        this.linkRemoveAction.setEnabled(bl && this.currentLink != null);
    }

    private void setLinkTarget() {
        EstateLinkProvider estateLinkProvider = (EstateLinkProvider)this.linkTypeField.getSelectedItem();
        String string = this.linkValueField.getText().trim();
        if (estateLinkProvider == null) {
            try {
                this.setLinkTarget(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else {
            this.setLinkTarget(estateLinkProvider, string);
        }
    }

    private void setLinkTarget(URI uRI) {
        this.currentLink.provider = null;
        this.currentLink.providerLinkId = null;
        this.currentLink.webLinkUrl = uRI;
        this.linksTable.updateSelectedRow();
    }

    private void setLinkTarget(EstateLinkProvider estateLinkProvider, String string) {
        this.currentLink.provider = estateLinkProvider;
        this.currentLink.providerLinkId = string;
        this.currentLink.webLinkUrl = null;
        this.linksTable.updateSelectedRow();
    }

    private void setLinkTitle(String string, Locale locale) {
        this.currentLink.setTitle(string, locale);
        this.linksTable.updateSelectedRow();
    }

    private void setTableButtonsEnabled(boolean bl) {
        this.linkAddAction.setEnabled(bl);
    }

    private void updateDividerLocation() {
        int n = this.splitPane.getSize().height - this.splitPane.getInsets().top - this.splitPane.getDividerSize() - this.splitPane.getBottomComponent().getPreferredSize().height;
        this.splitPane.setDividerLocation(n);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateTitle();
        this.linkFormTitle.setTitle(StringUtils.capitalize((String)I18N.tr("modify the selected link")));
        this.linkValueField.setToolTipText(I18N.tr("Enter the the web link or the ID of the selected provider."));
        this.linkPublishedField.setText(StringUtils.capitalize((String)I18N.tr("publish link")));
        this.linkPublishedField.setToolTipText(I18N.tr("Enable this option to make the link visible for the public - e.g. in real estate portals."));
        this.linkTypeLabel.setText(StringUtils.capitalize((String)I18N.tr("type")) + ":");
        this.linkTypeField.setToolTipText(I18N.tr("Select the type of web link."));
        EstateLinkProvider estateLinkProvider = (EstateLinkProvider)this.linkTypeField.getSelectedItem();
        if (estateLinkProvider != null && estateLinkProvider.getXmlName().startsWith("video@")) {
            this.linkValueLabel.setText(StringUtils.capitalize((String)I18N.tr("video-ID")) + ":");
        } else {
            this.linkValueLabel.setText(StringUtils.capitalize((String)I18N.tr("link")) + ":");
        }
        for (JLabel jLabel : this.linkTextLabels.values()) {
            jLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        }
    }

    private void updateTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("web-links for the property"));
        int n2 = n = this.linksTable != null ? this.linksTable.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        this.linksTitle.setTitle(string);
    }

    private static final class ProviderRenderer
    extends AbstractRenderer<EstateLinkProvider> {
        private ProviderRenderer() {
        }

        public void render(EstateLinkProvider estateLinkProvider, JLabel jLabel) {
            if (estateLinkProvider == null) {
                jLabel.setText(I18N.tr("web-link"));
            } else {
                String[] stringArray = StringUtils.split((String)estateLinkProvider.getXmlName(), (char)'@');
                if ("video".equalsIgnoreCase(stringArray[0])) {
                    jLabel.setText(I18N.tr("video at {0}", (Object)stringArray[1]));
                } else if ("gallery".equalsIgnoreCase(stringArray[0])) {
                    jLabel.setText(I18N.tr("gallery at {0}", (Object)stringArray[1]));
                } else {
                    jLabel.setText(estateLinkProvider.getXmlName());
                }
            }
        }
    }

    private class LinkRemoveAction
    extends AbstractI18nAction {
        private LinkRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewLinksPanel.this.doLinkRemove();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove link")));
            this.setShortDescription(I18N.tr("Remove the selected link."));
        }
    }

    private class LinkOpenAction
    extends AbstractI18nAction {
        private LinkOpenAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"web.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewLinksPanel.this.doLinkOpen();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("open link")));
            this.setShortDescription(I18N.tr("Open the selected link in the web browser."));
        }
    }

    private class LinkMoveUpAction
    extends AbstractI18nAction {
        private LinkMoveUpAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_up.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewLinksPanel.this.doLinkMoveUp();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Move up the selected link in the hierarchy."));
        }
    }

    private class LinkMoveDownAction
    extends AbstractI18nAction {
        private LinkMoveDownAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_down.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewLinksPanel.this.doLinkMoveDown();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Move down the selected link in the hierarchy."));
        }
    }

    private class LinkAddAction
    extends AbstractI18nAction {
        private LinkAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewLinksPanel.this.doLinkAdd();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("add link")));
            this.setShortDescription(I18N.tr("Add a web link to the property."));
        }
    }

    private static class TableRow
    extends AbstractTable.Row {
        private final DbLink link;

        private TableRow(DbLink dbLink) {
            this.link = dbLink;
        }

        public DbLink getLink() {
            return this.link;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof TableColumn) {
                return this.getValueForLink((TableColumn)column);
            }
            return null;
        }

        private Object getValueForLink(TableColumn tableColumn) {
            if (this.link == null) {
                return null;
            }
            switch (tableColumn) {
                case INDEX: {
                    return this.link.position;
                }
                case PUBLISHED: {
                    return this.link.published;
                }
                case TARGET: {
                    return this.link.webLinkUrl != null ? this.link.webLinkUrl.toString() : (this.link.provider != null ? "#" + this.link.providerLinkId : null);
                }
                case TYPE: {
                    return this.link.provider;
                }
                case TEXT: {
                    return this.link.getTitle(Locale.getDefault().getLanguage());
                }
            }
            return null;
        }

        public boolean isEditable(AbstractTable.Column column) {
            return super.isEditable(column) && this.link != null && TableColumn.PUBLISHED.equals(column);
        }

        public boolean isPublished() {
            return this.link != null && this.link.published;
        }

        public void setPublished(boolean bl) {
            if (this.link != null) {
                this.link.published = bl;
            }
        }

        public void setValueAt(Object object, AbstractTable.Column column) {
            if (TableColumn.PUBLISHED.equals(column) && this.link != null) {
                this.link.published = Boolean.TRUE.equals(object);
            }
        }
    }

    private static enum TableColumn implements AbstractTable.Column
    {
        TYPE,
        TARGET,
        TEXT,
        INDEX,
        PUBLISHED;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case TYPE: {
                    return new DefaultTableCellRenderer((Renderer)new ProviderRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case TYPE: {
                    return EstateLinkProvider.class;
                }
                case TARGET: 
                case TEXT: {
                    return String.class;
                }
                case INDEX: {
                    return Integer.class;
                }
                case PUBLISHED: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case TYPE: {
                    return I18N.tr("type");
                }
                case TARGET: {
                    return I18N.tr("target");
                }
                case TEXT: {
                    return I18N.tr("title");
                }
                case INDEX: {
                    return I18N.tr("position");
                }
                case PUBLISHED: {
                    return I18N.tr("published");
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                case PUBLISHED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private final class Table
    extends AbstractTable<TableRow, AbstractTable.Model<TableRow>> {
        public Table() {
            super(AgencyEstateViewLinksPanel.TABLE_ID);
        }

        protected void doRemove() {
            AgencyEstateViewLinksPanel.this.doLinkRemove();
        }

        protected void doSelect() {
            int n = this.getSelectedRow();
            int n2 = n > -1 ? this.convertRowIndexToModel(n) : -1;
            DbLink dbLink = n2 > -1 ? this.getLinkAt(n2) : null;
            AgencyEstateViewLinksPanel.this.selectLink(dbLink, true);
        }

        protected void doView() {
            AgencyEstateViewLinksPanel.this.doLinkOpen();
        }

        private DbLink getLinkAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getLink() : null;
        }

        protected void init() {
            this.setSingleSelection();
            this.setSortable(false);
            this.setColumnControlVisible(false);
            super.init();
        }

        public boolean isPublishedAt(int n) {
            DbLink dbLink = this.getLinkAt(n);
            return dbLink != null && dbLink.published;
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(TableColumn.values()));
        }

        public void setLinkAt(int n, DbLink dbLink) {
            this.setRowAt(n, new TableRow(dbLink));
        }
    }
}

