/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.FileSizeRenderer;
import com.openindex.openestate.tool.gui.ImageFileChooser;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.ImageUtils;
import eu.medsea.mimeutil.MimeType;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.ContentType;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewMediaPanel
extends AgencyEstateViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewMediaPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewMediaPanel.class);
    private static final String TABLE_ID = "AgencyEstateViewMediaPanel.Table";
    private static final String DETAILED_VIEW = "detailed";
    private static final String ICON_VIEW = "icon";
    private static final int PREVIEW_WIDTH = 300;
    private static final int PREVIEW_HEIGHT = 300;
    private static final int ICON_WIDTH = 100;
    private static final int ICON_HEIGHT = 75;
    private boolean isLoaded = false;
    private boolean isModified = false;
    private boolean isMouseDragging = false;
    private WeakReference<DbAgencyObject> currentObject = null;
    private FileItem currentFile = null;
    private List<Locale> currentLanguages;
    private JXTitledSeparator filesTitle;
    private JToggleButton viewIconsButton;
    private JToggleButton viewDetailsButton;
    private JSplitPane splitPane;
    private JPanel fileTableContainer;
    private FileList filesIconList;
    private FileTable filesDetailedTable;
    private JXTitledSeparator fileFormTitle;
    private Map<Locale, JTextField> fileTextFields;
    private Map<Locale, JLabel> fileTextLabels;
    private JLabel fileTypeLabel;
    private JComboBox<EstateAttachmentType> fileTypeField;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JCheckBox filePublishedField;
    private JLabel fileMimeTypeLabel;
    private JTextField fileMimeTypeField;
    private JCheckBox fileMimeTypeEditField;
    private JLabel fileInfoLabel;
    private JLabel fileImageViewLabel;
    private MouseAdapter dragHandler;
    private DragAndDropHandler dragAndDropHandler;
    private AbstractI18nAction fileImportAction;
    private AbstractI18nAction fileMoveUpAction;
    private AbstractI18nAction fileMoveDownAction;
    private AbstractI18nAction fileRemoveAction;
    private AbstractI18nAction fileSelectNextAction;
    private AbstractI18nAction fileSelectPrevAction;
    private AbstractI18nAction showActionsAction;

    public AgencyEstateViewMediaPanel() {
        this.build();
    }

    private void build() {
        this.currentLanguages = new ArrayList<Locale>(Arrays.asList(AgencyPlugin.getLocales()));
        this.dragAndDropHandler = new DragAndDropHandler();
        this.dragHandler = new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!AgencyEstateViewMediaPanel.this.isMouseDragging) {
                    AgencyEstateViewMediaPanel.this.isMouseDragging = true;
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    jComponent.getTransferHandler().exportAsDrag(jComponent, mouseEvent, 2);
                }
            }
        };
        this.splitPane = new JSplitPane();
        this.splitPane.setBorder(Paddings.EMPTY);
        this.splitPane.setOrientation(0);
        this.splitPane.setTopComponent(this.buildTableComponent());
        this.splitPane.setBottomComponent(this.buildFormComponent());
        this.splitPane.getBottomComponent().setVisible(false);
        this.splitPane.setDividerLocation(0.8);
        this.setBorder(Paddings.EMPTY);
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.splitPane, "Center");
        this.updateLocalization();
        this.doShowView(ICON_VIEW);
    }

    private JComponent buildFormComponent() {
        Serializable serializable2;
        this.filePublishedField = new JCheckBox();
        this.filePublishedField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewMediaPanel.this.filePublishedField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.currentFile == null) {
                    return;
                }
                ((FileItem)((AgencyEstateViewMediaPanel)AgencyEstateViewMediaPanel.this).currentFile).dbFile.published = AgencyEstateViewMediaPanel.this.filePublishedField.isSelected();
                AgencyEstateViewMediaPanel.this.isModified = true;
                AgencyEstateViewMediaPanel.this.updateFileViews();
            }
        });
        this.fileTypeLabel = new JLabel();
        this.fileTypeField = new JComboBox();
        this.fileTypeField.setRenderer((ListCellRenderer<EstateAttachmentType>)new DefaultListCellRenderer((Renderer)new FileTypeRenderer()));
        this.fileTypeField.addItem(null);
        TreeMap<String, EstateAttachmentType> treeMap = new TreeMap<String, EstateAttachmentType>();
        for (EstateAttachmentType object2 : EstateAttachmentType.values()) {
            treeMap.put(object2.getTranslation(), object2);
        }
        for (EstateAttachmentType estateAttachmentType : treeMap.values()) {
            this.fileTypeField.addItem(estateAttachmentType);
        }
        this.fileTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewMediaPanel.this.fileTypeField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.currentFile == null) {
                    return;
                }
                ((FileItem)((AgencyEstateViewMediaPanel)AgencyEstateViewMediaPanel.this).currentFile).dbFile.type = (EstateAttachmentType)AgencyEstateViewMediaPanel.this.fileTypeField.getSelectedItem();
                AgencyEstateViewMediaPanel.this.isModified = true;
                AgencyEstateViewMediaPanel.this.updateFileViews();
            }
        });
        this.fileNameLabel = new JLabel();
        this.fileNameField = new JTextField();
        this.fileNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                if (!AgencyEstateViewMediaPanel.this.fileNameField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.currentFile == null) {
                    return;
                }
                AgencyEstateViewMediaPanel.this.isModified = true;
                AgencyEstateViewMediaPanel.this.setFileName(AgencyEstateViewMediaPanel.this.fileNameField);
                AgencyEstateViewMediaPanel.this.fileFormTitle.setTitle(StringUtils.abbreviate((String)((FileItem)((AgencyEstateViewMediaPanel)AgencyEstateViewMediaPanel.this).currentFile).dbFile.name, (int)75));
            }
        });
        this.fileMimeTypeLabel = new JLabel();
        this.fileMimeTypeField = new JTextField();
        this.fileMimeTypeField.setEnabled(false);
        this.fileMimeTypeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!AgencyEstateViewMediaPanel.this.fileMimeTypeField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.currentFile == null) {
                    return;
                }
                AgencyEstateViewMediaPanel.this.setFileMimeType(AgencyEstateViewMediaPanel.this.fileMimeTypeField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (!AgencyEstateViewMediaPanel.this.fileMimeTypeField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.currentFile == null) {
                    return;
                }
                AgencyEstateViewMediaPanel.this.setFileMimeType(AgencyEstateViewMediaPanel.this.fileMimeTypeField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (!AgencyEstateViewMediaPanel.this.fileMimeTypeField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.currentFile == null) {
                    return;
                }
                AgencyEstateViewMediaPanel.this.setFileMimeType(AgencyEstateViewMediaPanel.this.fileMimeTypeField.getText());
            }
        });
        this.fileMimeTypeEditField = new JCheckBox();
        this.fileMimeTypeEditField.setSelected(false);
        this.fileMimeTypeEditField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewMediaPanel.this.fileMimeTypeEditField.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.currentFile == null) {
                    return;
                }
                AgencyEstateViewMediaPanel.this.fileMimeTypeField.setEnabled(false);
                AgencyEstateViewMediaPanel.this.fileMimeTypeField.setText(AgencyEstateViewMediaPanel.this.fileMimeTypeEditField.isSelected() && AgencyEstateViewMediaPanel.this.currentFile.customMimeType != null ? AgencyEstateViewMediaPanel.this.currentFile.customMimeType : ((FileItem)((AgencyEstateViewMediaPanel)AgencyEstateViewMediaPanel.this).currentFile).dbFile.mimeType);
                AgencyEstateViewMediaPanel.this.fileMimeTypeField.setEnabled(AgencyEstateViewMediaPanel.this.fileMimeTypeEditField.isSelected());
                AgencyEstateViewMediaPanel.this.setFileMimeType(AgencyEstateViewMediaPanel.this.fileMimeTypeEditField.isSelected() && AgencyEstateViewMediaPanel.this.currentFile.customMimeType != null ? AgencyEstateViewMediaPanel.this.currentFile.customMimeType : null);
            }
        });
        this.fileInfoLabel = new JLabel();
        this.fileInfoLabel.setHorizontalAlignment(4);
        this.fileInfoLabel.setFont(UIManager.getDefaults().getFont("Label.font").deriveFont(2));
        this.fileTextFields = new HashMap<Locale, JTextField>();
        this.fileTextLabels = new HashMap<Locale, JLabel>();
        TreeMap treeMap2 = new TreeMap();
        for (Locale locale : this.currentLanguages) {
            treeMap2.put(locale.getDisplayLanguage(), locale);
        }
        for (final Locale locale : treeMap2.values()) {
            final JTextField jTextField = new JTextField();
            this.fileTextFields.put(locale, jTextField);
            jTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.update();
                }

                private void update() {
                    if (!jTextField.isEnabled()) {
                        return;
                    }
                    if (AgencyEstateViewMediaPanel.this.currentFile == null) {
                        return;
                    }
                    AgencyEstateViewMediaPanel.this.isModified = true;
                    AgencyEstateViewMediaPanel.this.setFileText(jTextField, locale);
                }
            });
            serializable2 = new JLabel("");
            serializable2.setHorizontalTextPosition(10);
            serializable2.setIcon(ImmoToolUtils.getCountryFlagIcon((Locale)locale));
            this.fileTextLabels.put(locale, (JLabel)serializable2);
        }
        this.fileFormTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.fileRemoveAction = new FileRemoveAction();
        this.fileMoveUpAction = new FileMoveUpAction();
        this.fileMoveDownAction = new FileMoveDownAction();
        this.fileSelectNextAction = new FileSelectNextAction();
        this.fileSelectPrevAction = new FileSelectPrevAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.fileFormTitle, (Action[])new Action[]{this.fileMoveUpAction, this.fileSelectPrevAction, this.fileSelectNextAction, this.fileMoveDownAction, this.showActionsAction, this.fileRemoveAction});
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.fileImageViewLabel = new JLabel();
        this.fileImageViewLabel.setOpaque(true);
        this.fileImageViewLabel.setBackground(Color.WHITE);
        this.fileImageViewLabel.setSize(new Dimension(300, 300));
        this.fileImageViewLabel.setPreferredSize(new Dimension(300, 300));
        this.fileImageViewLabel.setVerticalAlignment(0);
        this.fileImageViewLabel.setHorizontalAlignment(0);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref, 3dlu");
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 6);
        defaultFormBuilder.add((Component)this.fileTypeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.fileTypeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filePublishedField).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.fileMimeTypeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.fileMimeTypeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.fileMimeTypeEditField).xy(5, defaultFormBuilder.row());
        for (Serializable serializable2 : treeMap2.values()) {
            defaultFormBuilder.add((Component)this.fileTextLabels.get(serializable2)).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.fileTextFields.get(serializable2)).xyw(3, defaultFormBuilder.row(), 3);
        }
        defaultFormBuilder.add((Component)this.fileNameLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.fileNameField).xyw(3, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.fileInfoLabel).xyw(1, defaultFormBuilder.nextRow(), 5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder((Border)Paddings.DIALOG);
        jPanel2.setLayout(new GridBagLayout());
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 18;
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 0;
        ((GridBagConstraints)serializable2).gridwidth = 2;
        ((GridBagConstraints)serializable2).weightx = 1.0;
        jPanel2.add((Component)jPanel, serializable2);
        ((GridBagConstraints)serializable2).anchor = 18;
        ((GridBagConstraints)serializable2).fill = 2;
        ((GridBagConstraints)serializable2).gridx = 0;
        ((GridBagConstraints)serializable2).gridy = 1;
        ((GridBagConstraints)serializable2).gridwidth = 1;
        ((GridBagConstraints)serializable2).weightx = 1.0;
        jPanel2.add((Component)defaultFormBuilder.getPanel(), serializable2);
        ((GridBagConstraints)serializable2).anchor = 12;
        ((GridBagConstraints)serializable2).fill = 0;
        ((GridBagConstraints)serializable2).gridx = 1;
        ((GridBagConstraints)serializable2).gridy = 1;
        ((GridBagConstraints)serializable2).gridwidth = 1;
        ((GridBagConstraints)serializable2).weightx = 0.0;
        jPanel2.add((Component)this.fileImageViewLabel, serializable2);
        return jPanel2;
    }

    private JComponent buildTableComponent() {
        this.filesTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.viewIconsButton = new JToggleButton((Action)((Object)new ShowViewAction(ICON_VIEW)));
        this.viewDetailsButton = new JToggleButton((Action)((Object)new ShowViewAction(DETAILED_VIEW)));
        this.fileImportAction = new FileImportAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.filesTitle, (JComponent[])new JComponent[]{this.viewIconsButton, this.viewDetailsButton, new JButton((Action)this.fileImportAction)});
        this.fileTableContainer = new JPanel();
        this.fileTableContainer.setLayout(new CardLayout());
        this.fileTableContainer.add((Component)this.buildTableIconView(), ICON_VIEW);
        this.fileTableContainer.add((Component)this.buildTableDetailedView(), DETAILED_VIEW);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder((Border)Paddings.DIALOG);
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.fileTableContainer, "Center");
        return jPanel2;
    }

    private JComponent buildTableDetailedView() {
        this.filesDetailedTable = new FileTable();
        this.filesDetailedTable.setTransferHandler(this.dragAndDropHandler);
        this.filesDetailedTable.addMouseMotionListener(this.dragHandler);
        return this.filesDetailedTable.createScrollPane();
    }

    private JComponent buildTableIconView() {
        this.filesIconList = new FileList();
        this.filesIconList.setTransferHandler(this.dragAndDropHandler);
        this.filesIconList.addMouseMotionListener(this.dragHandler);
        this.filesIconList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!AgencyEstateViewMediaPanel.this.filesIconList.isEnabled()) {
                    return;
                }
                if (AgencyEstateViewMediaPanel.this.isMouseDragging) {
                    return;
                }
                FileItem fileItem = (FileItem)((Object)AgencyEstateViewMediaPanel.this.filesIconList.getSelectedValue());
                AgencyEstateViewMediaPanel.this.selectFile(fileItem, true);
                int n2 = n = fileItem != null && fileItem.dbFile != null ? ((FileItem)fileItem).dbFile.position : -1;
                if (n > -1) {
                    try {
                        AgencyEstateViewMediaPanel.this.filesDetailedTable.setEnabled(false);
                        AgencyEstateViewMediaPanel.this.filesDetailedTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    finally {
                        AgencyEstateViewMediaPanel.this.filesDetailedTable.setEnabled(true);
                    }
                }
            }
        });
        this.filesIconList.getActionMap().put("DeleteKeyPressed", (Action)((Object)new FileRemoveAction()));
        this.filesIconList.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "DeleteKeyPressed");
        return new JScrollPane(this.filesIconList);
    }

    private void doFileExport() {
        boolean bl;
        if (this.currentFile == null) {
            return;
        }
        File file = AgencyPlugin.getLastImageLocation();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(I18N.tr("Save file to harddisk."));
        if (file != null) {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + ((FileItem)this.currentFile).dbFile.name));
        } else {
            jFileChooser.setSelectedFile(new File(((FileItem)this.currentFile).dbFile.name));
        }
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile().getAbsoluteFile();
        AgencyPlugin.setLastImageLocation(file2.getParentFile());
        if (file2.isFile() && !(bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you want to overwrite the selected file?"), (Component)((Object)this)))) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new FileExportTask(((FileItem)this.currentFile).dbFile.id, file2));
    }

    private void doFileImport() {
        int n;
        File file = AgencyPlugin.getLastImageLocation();
        ExtendedJImageFileChooser extendedJImageFileChooser = new ExtendedJImageFileChooser();
        extendedJImageFileChooser.setDialogTitle(StringUtils.capitalize((String)I18N.tr("import files")));
        extendedJImageFileChooser.setMultiSelectionEnabled(true);
        if (file != null) {
            extendedJImageFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = extendedJImageFileChooser.showOpenDialog((Component)ImmoToolEnvironment.getFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImageLocation(extendedJImageFileChooser.getSelectedFile().getParentFile());
        this.setFormButtonsEnabled(false);
        this.setTableButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new FileImportTask(extendedJImageFileChooser.getSelectedFiles(), extendedJImageFileChooser.isImportWithNames()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFileMoveDown() {
        if (this.currentFile == null) {
            return;
        }
        int n = ((FileItem)this.currentFile).dbFile.position;
        int n2 = n + 1;
        if (n2 >= ((DefaultListModel)this.filesIconList.getModel()).getSize()) {
            return;
        }
        this.filesDetailedTable.setEnabled(false);
        this.filesIconList.setEnabled(false);
        try {
            this.filesDetailedTable.moveRow(n, n2);
            FileItem fileItem = (FileItem)((Object)((DefaultListModel)this.filesIconList.getModel()).getElementAt(n2));
            ((FileItem)fileItem).dbFile.position = n;
            ((DefaultListModel)this.filesIconList.getModel()).remove(n2);
            ((DefaultListModel)this.filesIconList.getModel()).add(n, fileItem);
            ((FileItem)this.currentFile).dbFile.position = n2;
            this.filesDetailedTable.clearSelection();
            this.filesDetailedTable.getSelectionModel().addSelectionInterval(n2, n2);
            this.filesIconList.clearSelection();
            this.filesIconList.getSelectionModel().addSelectionInterval(n2, n2);
        }
        finally {
            this.isModified = true;
            this.setFormButtonsEnabled(true);
            this.filesDetailedTable.setEnabled(true);
            this.filesDetailedTable.updateRow(n);
            this.filesDetailedTable.updateRow(n2);
            this.filesIconList.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFileMoveUp() {
        if (this.currentFile == null) {
            return;
        }
        int n = ((FileItem)this.currentFile).dbFile.position;
        if (n < 1) {
            return;
        }
        int n2 = n - 1;
        this.filesDetailedTable.setEnabled(false);
        this.filesIconList.setEnabled(false);
        try {
            this.filesDetailedTable.moveRow(n, n2);
            FileItem fileItem = (FileItem)((Object)((DefaultListModel)this.filesIconList.getModel()).getElementAt(n2));
            ((FileItem)fileItem).dbFile.position = n;
            ((DefaultListModel)this.filesIconList.getModel()).remove(n);
            ((DefaultListModel)this.filesIconList.getModel()).add(n2, this.currentFile);
            ((FileItem)this.currentFile).dbFile.position = n2;
            this.filesDetailedTable.clearSelection();
            this.filesDetailedTable.getSelectionModel().addSelectionInterval(n2, n2);
            this.filesIconList.clearSelection();
            this.filesIconList.getSelectionModel().addSelectionInterval(n2, n2);
        }
        finally {
            this.isModified = true;
            this.setFormButtonsEnabled(true);
            this.filesDetailedTable.setEnabled(true);
            this.filesDetailedTable.updateRow(n);
            this.filesDetailedTable.updateRow(n2);
            this.filesIconList.setEnabled(true);
        }
    }

    private void doFileRemove() {
        int n;
        if (this.currentFile == null) {
            return;
        }
        int n2 = ((FileItem)this.currentFile).dbFile.position;
        if (n2 < 0) {
            return;
        }
        FileUtils.deleteQuietly((File)this.currentFile.previewFile);
        this.currentFile.dispose();
        this.filesIconList.setEnabled(false);
        this.filesDetailedTable.setEnabled(false);
        ((DefaultListModel)this.filesIconList.getModel()).remove(n2);
        for (n = 0; n < ((DefaultListModel)this.filesIconList.getModel()).getSize(); ++n) {
            ((FileItem)((FileItem)((Object)((DefaultListModel)this.filesIconList.getModel()).getElementAt((int)n)))).dbFile.position = n;
        }
        this.filesDetailedTable.removeRow(n2);
        try {
            n = ((DefaultListModel)this.filesIconList.getModel()).getSize();
            if (n > n2) {
                this.filesIconList.setSelectedIndex(n2);
            } else if (n > 0) {
                this.filesIconList.setSelectedIndex(n - 1);
            } else {
                this.filesIconList.clearSelection();
            }
            n = this.filesDetailedTable.getRowCount();
            if (n > n2) {
                this.filesDetailedTable.getSelectionModel().setSelectionInterval(n2, n2);
            } else if (n > 0) {
                this.filesDetailedTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            } else {
                this.filesDetailedTable.clearSelection();
            }
        }
        finally {
            this.isModified = true;
            this.filesIconList.setEnabled(true);
            this.filesDetailedTable.setEnabled(true);
            this.selectFile((FileItem)((Object)this.filesIconList.getSelectedValue()), true);
            this.updateLocalization();
        }
    }

    private void doFileReplace() {
        int n;
        if (this.currentFile == null) {
            return;
        }
        File file = AgencyPlugin.getLastImageLocation();
        ImageFileChooser imageFileChooser = new ImageFileChooser();
        imageFileChooser.setDialogTitle(StringUtils.capitalize((String)I18N.tr("replace file")));
        imageFileChooser.setMultiSelectionEnabled(false);
        if (file != null) {
            imageFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + "."));
        }
        if ((n = imageFileChooser.showOpenDialog((Component)ImmoToolEnvironment.getFrame())) != 0) {
            return;
        }
        AgencyPlugin.setLastImageLocation(imageFileChooser.getSelectedFile().getParentFile());
        this.setFormButtonsEnabled(false);
        this.setTableButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new FileReplaceTask(imageFileChooser.getSelectedFile()));
    }

    private synchronized void doFileSelectNext() {
        int n;
        int n2 = n = this.currentFile != null ? ((FileItem)this.currentFile).dbFile.position : -1;
        if (n > -1 && n + 1 < this.filesDetailedTable.getRowCount()) {
            try {
                this.filesIconList.setEnabled(false);
                this.filesIconList.setSelectedIndex(n + 1);
                this.filesDetailedTable.setEnabled(false);
                this.filesDetailedTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                FileItem fileItem = (FileItem)((Object)this.filesIconList.getSelectedValue());
                this.selectFile(fileItem, true);
            }
            finally {
                this.filesIconList.setEnabled(true);
                this.filesDetailedTable.setEnabled(true);
            }
        }
    }

    private synchronized void doFileSelectPrev() {
        int n;
        int n2 = n = this.currentFile != null ? ((FileItem)this.currentFile).dbFile.position : -1;
        if (n > 0) {
            try {
                this.filesIconList.setEnabled(false);
                this.filesIconList.setSelectedIndex(n - 1);
                this.filesDetailedTable.setEnabled(false);
                this.filesDetailedTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
                FileItem fileItem = (FileItem)((Object)this.filesIconList.getSelectedValue());
                this.selectFile(fileItem, true);
            }
            finally {
                this.filesIconList.setEnabled(true);
                this.filesDetailedTable.setEnabled(true);
            }
        }
    }

    private void doImageFlipHorizontal() {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2;
        if (this.currentFile == null) {
            return;
        }
        if (this.currentFile.previewImage != null) {
            bufferedImage2 = (BufferedImage)this.currentFile.previewImage.getImage();
            bufferedImage = ImageUtils.flipHorizontal((BufferedImage)bufferedImage2);
            this.currentFile.previewImage = new ImageIcon(bufferedImage);
            this.fileImageViewLabel.setIcon(this.currentFile.previewImage);
            bufferedImage2.flush();
        }
        if (this.currentFile.smallImage != null) {
            bufferedImage2 = (BufferedImage)this.currentFile.smallImage.getImage();
            bufferedImage = ImageUtils.flipHorizontal((BufferedImage)bufferedImage2);
            this.currentFile.smallImage = new ImageIcon(bufferedImage);
            this.filesIconList.repaint();
            bufferedImage2.flush();
        }
        this.currentFile.flippedH = !this.currentFile.flippedH;
        this.isModified = true;
    }

    private void doImageFlipVertical() {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2;
        if (this.currentFile == null) {
            return;
        }
        if (this.currentFile.previewImage != null) {
            bufferedImage2 = (BufferedImage)this.currentFile.previewImage.getImage();
            bufferedImage = ImageUtils.flipVertical((BufferedImage)bufferedImage2);
            this.currentFile.previewImage = new ImageIcon(bufferedImage);
            this.fileImageViewLabel.setIcon(this.currentFile.previewImage);
            bufferedImage2.flush();
        }
        if (this.currentFile.smallImage != null) {
            bufferedImage2 = (BufferedImage)this.currentFile.smallImage.getImage();
            bufferedImage = ImageUtils.flipVertical((BufferedImage)bufferedImage2);
            this.currentFile.smallImage = new ImageIcon(bufferedImage);
            this.filesIconList.repaint();
            bufferedImage2.flush();
        }
        this.currentFile.flippedV = !this.currentFile.flippedV;
        this.isModified = true;
    }

    private void doImageRotateLeft() {
        BufferedImage bufferedImage;
        Object object;
        if (this.currentFile == null) {
            return;
        }
        if (this.currentFile.previewImage != null) {
            object = (BufferedImage)this.currentFile.previewImage.getImage();
            bufferedImage = ImageUtils.rotateToLeft((BufferedImage)object);
            this.currentFile.previewImage = new ImageIcon(bufferedImage);
            this.fileImageViewLabel.setPreferredSize(new Dimension(300, this.currentFile.previewImage.getIconHeight()));
            this.fileImageViewLabel.setIcon(this.currentFile.previewImage);
            ((Image)object).flush();
        }
        if (this.currentFile.smallImage != null) {
            object = (BufferedImage)this.currentFile.smallImage.getImage();
            bufferedImage = ImageUtils.rotateToLeft((BufferedImage)object);
            this.currentFile.smallImage = new ImageIcon(bufferedImage);
            this.filesIconList.repaint();
            ((Image)object).flush();
        }
        this.updateDividerLocation();
        object = this.currentFile;
        ((FileItem)((Object)object)).rotation = ((FileItem)((Object)object)).rotation - 1;
        this.isModified = true;
    }

    private void doImageRotateRight() {
        BufferedImage bufferedImage;
        Object object;
        if (this.currentFile == null) {
            return;
        }
        if (this.currentFile.previewImage != null) {
            object = (BufferedImage)this.currentFile.previewImage.getImage();
            bufferedImage = ImageUtils.rotateToRight((BufferedImage)object);
            this.currentFile.previewImage = new ImageIcon(bufferedImage);
            this.fileImageViewLabel.setPreferredSize(new Dimension(300, this.currentFile.previewImage.getIconHeight()));
            this.fileImageViewLabel.setIcon(this.currentFile.previewImage);
            ((Image)object).flush();
        }
        if (this.currentFile.smallImage != null) {
            object = (BufferedImage)this.currentFile.smallImage.getImage();
            bufferedImage = ImageUtils.rotateToRight((BufferedImage)object);
            this.currentFile.smallImage = new ImageIcon(bufferedImage);
            this.filesIconList.repaint();
            ((Image)object).flush();
        }
        this.updateDividerLocation();
        object = this.currentFile;
        ((FileItem)((Object)object)).rotation = ((FileItem)((Object)object)).rotation + 1;
        this.isModified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        int n;
        DbAgencyObject dbAgencyObject;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        if (immoToolProject == null) {
            throw new Exception("No project loaded!");
        }
        DbAgencyObject dbAgencyObject2 = dbAgencyObject = this.currentObject != null ? (DbAgencyObject)((Object)this.currentObject.get()) : null;
        if (dbAgencyObject == null || dbAgencyObject.id < 1L) {
            this.isLoaded = true;
            return;
        }
        this.filesIconList.setEnabled(false);
        this.filesIconList.clearSelection();
        this.filesDetailedTable.setEnabled(false);
        this.filesDetailedTable.clearSelection();
        for (n = 0; n < ((DefaultListModel)this.filesIconList.getModel()).getSize(); ++n) {
            ((FileItem)((Object)((DefaultListModel)this.filesIconList.getModel()).getElementAt(n))).dispose();
        }
        for (n = 0; n < this.filesDetailedTable.getModel().getRowCount(); ++n) {
            ((FileItem)this.filesDetailedTable.getRow(n)).dispose();
        }
        this.filesDetailedTable.clearRows();
        ArrayList<FileItem> arrayList = new ArrayList<FileItem>();
        try {
            DbFilesHandler dbFilesHandler = AgencyPlugin.getDbAgencyExtension().getFilesHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            DbFile[] dbFileArray = dbFilesHandler.getFiles(connection, dbAgencyObject.id, null, null);
            dbFilesHandler.loadFileTranslations(connection, dbFileArray, dbLanguagesHandler);
            for (DbFile dbFile : dbFileArray) {
                FileItem fileItem = new FileItem(dbFile);
                arrayList.add(fileItem);
                if (!dbFile.mimeType.toLowerCase().startsWith("image/")) continue;
                File file = new File(immoToolProject.getTempDirectory(), "preview_" + dbFile.id + ".bin");
                if (file.isFile()) {
                    if (file.lastModified() < dbFile.modifiedAt.getTime()) {
                        FileUtils.deleteQuietly((File)file);
                    } else {
                        try {
                            fileItem.previewFile = file;
                            BufferedImage bufferedImage = ImageUtils.readAsRgb((File)file);
                            fileItem.previewImage = bufferedImage != null ? new ImageIcon(bufferedImage) : null;
                            fileItem.smallImage = bufferedImage != null ? new ImageIcon(ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)100, (int)75)) : null;
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't load already downloaded preview for image #" + dbFile.id + " of estate #" + dbAgencyObject.id + "!");
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            FileUtils.deleteQuietly((File)file);
                        }
                    }
                }
                if (!file.isFile()) {
                    boolean bl = false;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        bl = dbFilesHandler.downloadPreview(connection, dbFile.id, (OutputStream)fileOutputStream);
                        if (bl) {
                            fileItem.previewFile = file;
                            BufferedImage bufferedImage = ImageUtils.readAsRgb((File)file);
                            fileItem.previewImage = bufferedImage != null ? new ImageIcon(bufferedImage) : null;
                            fileItem.smallImage = new ImageIcon(ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)100, (int)75));
                            boolean bl2 = file.setLastModified(dbFile.modifiedAt.getTime() + 1000L);
                            if (!bl2) {
                                LOGGER.warn("Can't change modification time for '" + file.getAbsolutePath() + "'!");
                            }
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't load preview for image #" + dbFile.id + " of estate #" + dbAgencyObject.id + "!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    finally {
                        if (!bl) {
                            FileUtils.deleteQuietly((File)file);
                        }
                    }
                }
                if (!file.isFile()) continue;
                file.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$fileItems;
                {
                    this.val$fileItems = list;
                }

                @Override
                public void run() {
                    try {
                        AgencyEstateViewMediaPanel.this.filesIconList.setModel(new DefaultListModel());
                        for (FileItem fileItem : this.val$fileItems) {
                            ((FileItem)fileItem).dbFile.position = AgencyEstateViewMediaPanel.this.filesDetailedTable.getRowCount();
                            AgencyEstateViewMediaPanel.this.filesIconList.addFile(fileItem);
                            AgencyEstateViewMediaPanel.this.filesDetailedTable.addRow(fileItem);
                        }
                    }
                    finally {
                        AgencyEstateViewMediaPanel.this.filesIconList.setEnabled(true);
                        AgencyEstateViewMediaPanel.this.filesDetailedTable.setEnabled(true);
                        AgencyEstateViewMediaPanel.this.filesDetailedTable.packAll();
                        AgencyEstateViewMediaPanel.this.isLoaded = true;
                        AgencyEstateViewMediaPanel.this.updateLocalization();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.currentFile == null) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new FileExportAction()));
        jPopupMenu.add((Action)((Object)new FileReplaceAction()));
        if (this.currentFile.previewFile != null && ((FileItem)this.currentFile).dbFile.imageHeight > 0 && ((FileItem)this.currentFile).dbFile.imageWidth > 0) {
            jPopupMenu.addSeparator();
            jPopupMenu.add((Action)((Object)new ImageRotateLeftAction()));
            jPopupMenu.add((Action)((Object)new ImageRotateRightAction()));
            jPopupMenu.add((Action)((Object)new ImageFlipHorizontalAction()));
            jPopupMenu.add((Action)((Object)new ImageFlipVerticalAction()));
        }
        jPopupMenu.show(component, n, n2);
    }

    private void doShowView(String string) {
        this.viewDetailsButton.setSelected(DETAILED_VIEW.equals(string));
        this.viewIconsButton.setSelected(ICON_VIEW.equals(string));
        CardLayout cardLayout = (CardLayout)this.fileTableContainer.getLayout();
        cardLayout.show(this.fileTableContainer, string);
    }

    /*
     * Loose catch block
     */
    private static File downloadContent(Connection connection, DbFilesHandler dbFilesHandler, long l, File file) throws IOException, SQLException {
        File file2 = new File(file.getAbsolutePath() + File.separator + "attachment_" + System.currentTimeMillis() + ".bin");
        file2.deleteOnExit();
        boolean bl = false;
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                bl = dbFilesHandler.downloadContent(connection, l, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                File file3 = bl ? file2 : null;
                return file3;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!bl) {
                FileUtils.deleteQuietly((File)file2);
            }
        }
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("files"));
    }

    public boolean isTabEnabled() {
        return this.isLoaded;
    }

    public boolean isTabModified() {
        return this.isModified;
    }

    private boolean isImageMimeType(MimeType mimeType) {
        if (mimeType == null) {
            return false;
        }
        return !ImmoToolUtils.UNKNOWN_MIME_TYPE.equals((Object)mimeType) && "image".equalsIgnoreCase(mimeType.getMediaType());
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    @Override
    public void load(DbAgencyObject dbAgencyObject) {
        this.isLoaded = false;
        this.isModified = false;
        this.currentFile = null;
        this.currentObject = new WeakReference<DbAgencyObject>(dbAgencyObject);
        this.selectFile(null, true);
        List list = dbAgencyObject.id > 0L ? dbAgencyObject.item.getLanguages() : null;
        for (Locale locale : AgencyPlugin.getLocales()) {
            this.selectLanguage(locale, list == null || list.contains(locale.toString()));
        }
    }

    @Override
    public void save(DbAgencyObject dbAgencyObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException, IOException {
        Object object;
        int n;
        super.saveFinished(connection, immoToolProject, dbAgencyObject);
        this.setTableButtonsEnabled(false);
        this.setFormButtonsEnabled(false);
        DbFilesHandler dbFilesHandler = AgencyPlugin.getDbAgencyExtension().getFilesHandler();
        DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            int n2 = AgencyPlugin.getImageMaxHeight();
            n = AgencyPlugin.getImageMaxWidth();
            object = dbLanguagesHandler.getLanguageMap(connection);
            ArrayList<Long> arrayList2 = new ArrayList<Long>(Arrays.asList(ArrayUtils.toObject((long[])dbFilesHandler.getFileIds(connection, dbAgencyObject.id, null, null))));
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            for (int i = 0; i < ((DefaultListModel)this.filesIconList.getModel()).getSize(); ++i) {
                Object object2;
                int n3;
                Object object3;
                FileItem object22 = (FileItem)((Object)((DefaultListModel)this.filesIconList.getModel()).getElementAt(i));
                DbFile dbFile = object22.dbFile;
                int n4 = object22.dbFileHash;
                if (dbFile.id > 0L && dbFile.objectId > 0L && dbFile.objectId != dbAgencyObject.id) {
                    object22.contentFile = AgencyEstateViewMediaPanel.downloadContent(connection, dbFilesHandler, dbFile.id, immoToolProject.getTempDirectory());
                    dbFile.id = 0L;
                }
                dbFile.objectId = dbAgencyObject.id;
                if (object22.customMimeType != null) {
                    dbFile.mimeType = object22.customMimeType;
                }
                if (object22.previewImage == null || dbFile.imageWidth < 1 || dbFile.imageHeight < 1) {
                    int n5 = dbFile.calculateHash();
                    if (dbFile.id == 0L || object22.contentFile != null || n4 != n5) {
                        dbFilesHandler.saveFile(connection, dbFile, null, null, (Map)object);
                        if (object22.contentFile != null) {
                            dbFilesHandler.setFileContent(connection, dbFile.id, object22.contentFile, null);
                        }
                    }
                    arrayList3.add(dbFile.id);
                    continue;
                }
                BufferedImage bufferedImage = null;
                if (object22.contentFile != null) {
                    try {
                        if ("image/png".equalsIgnoreCase(dbFile.mimeType)) {
                            bufferedImage = ImageUtils.read((File)object22.contentFile);
                            dbFile.mimeType = "image/png";
                        } else {
                            bufferedImage = ImageUtils.readAsRgb((File)object22.contentFile);
                            dbFile.mimeType = "image/jpeg";
                        }
                        if (bufferedImage == null) {
                            throw new NullPointerException("Can't read image!");
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't read image from \"" + object22.contentFile.getAbsolutePath() + "\"!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        arrayList.add(object22.contentFile);
                        continue;
                    }
                }
                if (object22.flippedH) {
                    if (bufferedImage == null && dbFile.id > 0L) {
                        object3 = AgencyEstateViewMediaPanel.downloadContent(connection, dbFilesHandler, dbFile.id, immoToolProject.getTempDirectory());
                        if ("image/png".equalsIgnoreCase(dbFile.mimeType)) {
                            bufferedImage = object3 != null ? ImageUtils.read((File)object3) : null;
                        } else {
                            BufferedImage bufferedImage2 = bufferedImage = object3 != null ? ImageUtils.readAsRgb((File)object3) : null;
                        }
                    }
                    if (bufferedImage == null) {
                        LOGGER.warn("Can't load image for horizontal flipping!");
                    } else {
                        object3 = ImageUtils.flipHorizontal(bufferedImage);
                        bufferedImage.flush();
                        bufferedImage = object3;
                    }
                }
                if (object22.flippedV) {
                    if (bufferedImage == null && dbFile.id > 0L) {
                        object3 = AgencyEstateViewMediaPanel.downloadContent(connection, dbFilesHandler, dbFile.id, immoToolProject.getTempDirectory());
                        if ("image/png".equalsIgnoreCase(dbFile.mimeType)) {
                            bufferedImage = object3 != null ? ImageUtils.read((File)object3) : null;
                        } else {
                            BufferedImage bufferedImage3 = bufferedImage = object3 != null ? ImageUtils.readAsRgb((File)object3) : null;
                        }
                    }
                    if (bufferedImage == null) {
                        LOGGER.warn("Can't load image for vertical flipping!");
                    } else {
                        object3 = ImageUtils.flipVertical((BufferedImage)bufferedImage);
                        bufferedImage.flush();
                        bufferedImage = object3;
                    }
                }
                if ((n3 = Math.abs(object22.rotation) % 4) != 0) {
                    if (bufferedImage == null && dbFile.id > 0L) {
                        File file = AgencyEstateViewMediaPanel.downloadContent(connection, dbFilesHandler, dbFile.id, immoToolProject.getTempDirectory());
                        if ("image/png".equalsIgnoreCase(dbFile.mimeType)) {
                            bufferedImage = file != null ? ImageUtils.read((File)file) : null;
                        } else {
                            BufferedImage bufferedImage4 = bufferedImage = file != null ? ImageUtils.readAsRgb((File)file) : null;
                        }
                    }
                    if (bufferedImage == null) {
                        LOGGER.warn("Can't load image for rotation!");
                    } else {
                        for (int j = 0; j < n3; ++j) {
                            BufferedImage bufferedImage5 = object22.rotation < 0 ? ImageUtils.rotateToLeft((BufferedImage)bufferedImage) : ImageUtils.rotateToRight((BufferedImage)bufferedImage);
                            bufferedImage.flush();
                            bufferedImage = bufferedImage5;
                        }
                    }
                }
                if (bufferedImage != null && (n2 > 0 || n > 0)) {
                    int n6;
                    int n7 = n2 > 0 ? n2 : bufferedImage.getHeight();
                    int n8 = n6 = n > 0 ? n : bufferedImage.getWidth();
                    if (bufferedImage.getHeight() > n7 || bufferedImage.getWidth() > n6) {
                        object2 = ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)n6, (int)n7);
                        bufferedImage.flush();
                        bufferedImage = object2;
                        dbFile.imageHeight = bufferedImage.getHeight();
                        dbFile.imageWidth = bufferedImage.getWidth();
                    }
                }
                int n9 = dbFile.calculateHash();
                if (dbFile.id == 0L || bufferedImage != null || n4 != n9) {
                    dbFilesHandler.saveFile(connection, dbFile, null, null, (Map)object);
                    if (bufferedImage != null) {
                        File file = null;
                        object2 = null;
                        try {
                            file = new File(immoToolProject.getTempDirectory() + File.separator + "attachment_" + System.currentTimeMillis() + ".bin");
                            file.deleteOnExit();
                            if ("image/png".equalsIgnoreCase(dbFile.mimeType)) {
                                ImageUtils.writePng((BufferedImage)bufferedImage, (File)file);
                            } else {
                                ImageUtils.writeJpg((BufferedImage)bufferedImage, (File)file);
                            }
                            BufferedImage bufferedImage6 = ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)300, (int)300);
                            object2 = new File(file.getAbsolutePath() + ".preview");
                            ((File)object2).deleteOnExit();
                            ImageUtils.writeJpg((BufferedImage)bufferedImage6, (File)object2);
                            dbFilesHandler.setFileContent(connection, dbFile.id, file, (File)object2);
                        }
                        catch (Throwable throwable) {
                            FileUtils.deleteQuietly(file);
                            FileUtils.deleteQuietly((File)object2);
                            throw throwable;
                        }
                        FileUtils.deleteQuietly((File)file);
                        FileUtils.deleteQuietly((File)object2);
                    }
                }
                arrayList3.add(dbFile.id);
            }
            for (Long l : arrayList2) {
                if (arrayList3.contains(l)) continue;
                dbFilesHandler.removeFile(connection, l.longValue());
            }
            for (int i = 0; i < ((DefaultListModel)this.filesIconList.getModel()).getSize(); ++i) {
                FileItem fileItem = (FileItem)((Object)((DefaultListModel)this.filesIconList.getModel()).getElementAt(i));
                if (fileItem.previewFile == null || !fileItem.previewFile.getName().startsWith("preview_temp_")) continue;
                FileUtils.deleteQuietly((File)fileItem.previewFile);
            }
        }
        finally {
            this.setTableButtonsEnabled(true);
            this.setFormButtonsEnabled(true);
        }
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < arrayList.size(); ++n) {
                object = (File)arrayList.get(n);
                if (n >= 4) {
                    int n10 = arrayList.size() - 4;
                    stringBuilder.append("<br><i>").append(I18N.trn("and {0} further image", "and {0} further images", (long)n10, (Object)n10)).append("</i>");
                    break;
                }
                stringBuilder.append("<br>").append(StringEscapeUtils.escapeXml11((String)StringUtils.abbreviateMiddle((String)((File)object).getAbsolutePath(), (String)"...", (int)60)));
            }
            n = arrayList.size();
            this.addSaveWarning("<html><b>" + I18N.trn("Can't save {0} image!", "Can't save {0} images!", (long)n, (Object)n) + "</b>" + stringBuilder + "</html>");
        }
    }

    private void selectFile(FileItem fileItem, boolean bl) {
        this.currentFile = fileItem;
        this.splitPane.getBottomComponent().setVisible(fileItem != null);
        if (fileItem == null) {
            return;
        }
        DbFile dbFile = fileItem.dbFile;
        this.fileFormTitle.setTitle(StringUtils.abbreviate((String)dbFile.name, (int)75));
        this.fileInfoLabel.setText(fileItem.writeInfo());
        this.fileTypeField.setEnabled(false);
        this.fileTypeField.setSelectedItem(dbFile.type);
        this.fileTypeField.setEnabled(true);
        this.filePublishedField.setEnabled(false);
        this.filePublishedField.setSelected(dbFile.published);
        this.filePublishedField.setEnabled(true);
        this.fileMimeTypeEditField.setEnabled(false);
        this.fileMimeTypeEditField.setSelected(fileItem.customMimeType != null);
        this.fileMimeTypeField.setText(fileItem.customMimeType != null ? fileItem.customMimeType : dbFile.mimeType);
        this.fileMimeTypeField.setCaretPosition(0);
        this.fileMimeTypeEditField.setEnabled(true);
        this.fileNameField.setText(dbFile.name);
        if (fileItem.previewImage == null || dbFile.imageWidth <= 0 || dbFile.imageHeight <= 0) {
            this.fileImageViewLabel.setVisible(false);
        } else {
            this.fileImageViewLabel.setVisible(true);
            this.fileImageViewLabel.setPreferredSize(new Dimension(300, fileItem.previewImage.getIconHeight()));
            this.fileImageViewLabel.setIcon(fileItem.previewImage);
        }
        for (Map.Entry<Locale, JTextField> entry : this.fileTextFields.entrySet()) {
            Locale locale = entry.getKey();
            JTextField jTextField = entry.getValue();
            String string = locale.toString();
            String string2 = dbFile.translations != null && dbFile.translations.containsKey(string) ? ((DbFile.Translation)dbFile.translations.get((Object)string)).title : null;
            jTextField.setEnabled(false);
            jTextField.setText(StringUtils.trimToEmpty(string2));
            jTextField.setCaretPosition(0);
            jTextField.setEnabled(true);
        }
        this.updateDividerLocation();
        if (bl) {
            this.setFormButtonsEnabled(true);
        }
    }

    @Override
    public void selectLanguage(Locale locale, boolean bl) {
        if (bl && !this.currentLanguages.contains(locale)) {
            this.currentLanguages.add(locale);
        } else if (!bl) {
            this.currentLanguages.remove(locale);
        }
        this.splitPane.setBottomComponent(this.buildFormComponent());
        this.selectFile(this.currentFile, true);
        this.updateLocalization();
    }

    private void setFileName(JTextField jTextField) {
        ((FileItem)this.currentFile).dbFile.name = (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToNull((String)jTextField.getText()), (CharSequence)((FileItem)this.currentFile).dbFile.name);
        this.updateFileViews();
    }

    private void setFileText(JTextField jTextField, Locale locale) {
        this.currentFile.dbFile.setTitle(jTextField.getText(), locale);
        this.updateFileViews();
    }

    private void setFileMimeType(String string) {
        if (!this.isModified && string != null && !((FileItem)this.currentFile).dbFile.mimeType.equalsIgnoreCase(string)) {
            this.isModified = true;
        }
        this.currentFile.customMimeType = string;
        this.updateFileViews();
    }

    private void setFormButtonsEnabled(boolean bl) {
        this.showActionsAction.setEnabled(bl && this.currentFile != null);
        this.fileRemoveAction.setEnabled(bl && this.currentFile != null);
        int n = this.currentFile != null && this.currentFile.dbFile != null ? ((FileItem)this.currentFile).dbFile.position : -1;
        this.fileMoveUpAction.setEnabled(bl && n > 0);
        this.fileSelectPrevAction.setEnabled(bl && n > 0);
        this.fileMoveDownAction.setEnabled(bl && n > -1 && n + 1 < this.filesDetailedTable.getRowCount());
        this.fileSelectNextAction.setEnabled(bl && n > -1 && n + 1 < this.filesDetailedTable.getRowCount());
    }

    private void setTableButtonsEnabled(boolean bl) {
        this.fileImportAction.setEnabled(bl);
        this.viewDetailsButton.setEnabled(bl);
        this.viewIconsButton.setEnabled(bl);
    }

    private void updateDividerLocation() {
        int n = this.splitPane.getSize().height - this.splitPane.getInsets().top - this.splitPane.getDividerSize() - this.splitPane.getBottomComponent().getPreferredSize().height;
        this.splitPane.setDividerLocation(n);
    }

    private void updateFileViews() {
        this.filesIconList.setEnabled(false);
        this.filesDetailedTable.setEnabled(false);
        try {
            this.filesIconList.repaint();
            this.filesDetailedTable.updateSelectedRow();
        }
        finally {
            this.filesIconList.setEnabled(true);
            this.filesDetailedTable.setEnabled(true);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        String string = StringUtils.capitalize((String)I18N.tr("attached files"));
        long l = 0L;
        for (int i = 0; i < ((DefaultListModel)this.filesIconList.getModel()).getSize(); ++i) {
            FileItem object = (FileItem)((Object)((DefaultListModel)this.filesIconList.getModel()).getElementAt(i));
            l += ((FileItem)object).dbFile.size;
        }
        if (l > 0L) {
            string = string + " / ";
            string = string + ImmoToolUtils.getHumanReadableByteCount((long)l, (NumberFormat)NumberFormat.getNumberInstance());
        }
        this.filesTitle.setTitle(string);
        this.filePublishedField.setText(StringUtils.capitalize((String)I18N.tr("publish file")));
        this.filePublishedField.setToolTipText(I18N.tr("Enable this option to make the file visible for the public - e.g. in real estate portals."));
        this.fileTypeLabel.setText(StringUtils.capitalize((String)I18N.tr("file type")) + ":");
        this.fileTypeField.setToolTipText(I18N.tr("The file type specifies the attached file in detail."));
        this.fileMimeTypeLabel.setText(StringUtils.capitalize((String)I18N.tr("format")) + ":");
        this.fileMimeTypeField.setToolTipText(I18N.tr("Enter the MIME type of the file if required."));
        this.fileMimeTypeEditField.setText(StringUtils.capitalize((String)I18N.tr("edit format")));
        this.fileMimeTypeEditField.setToolTipText(I18N.tr("Enable this option, if you want to change the automatically detected MIME type."));
        this.fileNameLabel.setText(StringUtils.capitalize((String)I18N.tr("name")) + ":");
        this.fileNameField.setToolTipText(I18N.tr("Enter the internal name of the file."));
        for (JLabel jLabel : this.fileTextLabels.values()) {
            jLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        }
    }

    private class ShowViewAction
    extends AbstractI18nAction {
        private final String view;

        private ShowViewAction(String string) {
            this.view = string;
            if (AgencyEstateViewMediaPanel.DETAILED_VIEW.equals(string)) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"view_detailed.png", (int)16));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"view_icon.png", (int)16));
            }
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doShowView(this.view);
        }

        protected final void updateLocalization() {
            if (AgencyEstateViewMediaPanel.DETAILED_VIEW.equals(this.view)) {
                this.setShortDescription(I18N.tr("Show attachments as tabular view."));
            } else {
                this.setShortDescription(I18N.tr("Show attachments as icon view."));
            }
        }
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        public ShowActionsAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_new.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencyEstateViewMediaPanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected file."));
        }
    }

    private class ImageRotateRightAction
    extends AbstractI18nAction {
        private ImageRotateRightAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"object-rotate-right.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doImageRotateRight();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("rotate right")));
            this.setShortDescription(I18N.tr("Rotate the image clockwise by 90\u00b0."));
        }
    }

    private class ImageRotateLeftAction
    extends AbstractI18nAction {
        private ImageRotateLeftAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"object-rotate-left.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doImageRotateLeft();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("rotate left")));
            this.setShortDescription(I18N.tr("Rotate the image counter-clockwise by 90\u00b0."));
        }
    }

    private class ImageFlipVerticalAction
    extends AbstractI18nAction {
        private ImageFlipVerticalAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"object-flip-vertical.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doImageFlipVertical();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("flip vertical")));
            this.setShortDescription(I18N.tr("Flip the selected image vertically."));
        }
    }

    private class ImageFlipHorizontalAction
    extends AbstractI18nAction {
        private ImageFlipHorizontalAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"object-flip-horizontal.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doImageFlipHorizontal();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("flip horizontal")));
            this.setShortDescription(I18N.tr("Flip the selected image horizontally."));
        }
    }

    private class FileSelectPrevAction
    extends AbstractI18nAction {
        private FileSelectPrevAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_2_left.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doFileSelectPrev();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Select the previous file for editing."));
        }
    }

    private class FileSelectNextAction
    extends AbstractI18nAction {
        private FileSelectNextAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_2_right.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doFileSelectNext();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Select the next file for editing."));
        }
    }

    private class FileReplaceTask
    extends ImmoToolTask<Boolean, Void> {
        private final File selectedFile;

        private FileReplaceTask(File file) {
            this.selectedFile = file;
        }

        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            FileItem fileItem = AgencyEstateViewMediaPanel.this.currentFile;
            if (fileItem == null) {
                return false;
            }
            if (!this.selectedFile.isFile()) {
                return false;
            }
            ((FileItem)fileItem).dbFile.name = this.selectedFile.getName();
            ((FileItem)fileItem).dbFile.size = this.selectedFile.length();
            MimeType mimeType = ImmoToolUtils.getMimeType((File)this.selectedFile);
            ((FileItem)fileItem).dbFile.mimeType = mimeType.toString();
            fileItem.customMimeType = null;
            fileItem.contentFile = this.selectedFile;
            if (fileItem.previewFile != null && fileItem.previewFile.isFile()) {
                FileUtils.deleteQuietly((File)fileItem.previewFile);
            }
            fileItem.previewFile = null;
            fileItem.previewImage = null;
            fileItem.smallImage = null;
            if (!AgencyEstateViewMediaPanel.this.isImageMimeType(mimeType)) {
                return true;
            }
            File file = new File(immoToolProject.getTempDirectory() + File.separator + "preview_temp_" + System.currentTimeMillis() + ".bin");
            file.deleteOnExit();
            try {
                Object object;
                BufferedImage bufferedImage = ImageUtils.readAsRgb((File)this.selectedFile);
                if (bufferedImage == null) {
                    LOGGER.warn("Can't read image!");
                    LOGGER.warn("> " + this.selectedFile.getAbsolutePath());
                    return true;
                }
                ((FileItem)fileItem).dbFile.imageWidth = bufferedImage.getWidth();
                ((FileItem)fileItem).dbFile.imageHeight = bufferedImage.getHeight();
                if (bufferedImage.getWidth() > 300 || bufferedImage.getHeight() > 300) {
                    object = ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)300, (int)300);
                    bufferedImage.flush();
                    bufferedImage = object;
                }
                object = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    ImageUtils.writeJpg((BufferedImage)bufferedImage, (OutputStream)object);
                    ((OutputStream)object).flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)object).close();
                        }
                    }
                }
                fileItem.previewFile = file;
                object = ImageUtils.readAsRgb((File)file);
                if (object != null) {
                    fileItem.previewImage = new ImageIcon((Image)object);
                    fileItem.smallImage = new ImageIcon(ImageUtils.scaleToFit((BufferedImage)object, (int)100, (int)75));
                } else {
                    LOGGER.warn("Can't read preview-image!");
                    LOGGER.warn("> from: " + file.getAbsolutePath());
                }
                return true;
            }
            catch (Exception exception) {
                FileUtils.deleteQuietly((File)file);
                LOGGER.warn("Can't read image!");
                LOGGER.warn("> " + this.selectedFile.getAbsolutePath());
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                return false;
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't replace file!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyEstateViewMediaPanel.this.setFormButtonsEnabled(true);
            AgencyEstateViewMediaPanel.this.setTableButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            AgencyEstateViewMediaPanel.this.isModified = true;
            AgencyEstateViewMediaPanel.this.selectFile(AgencyEstateViewMediaPanel.this.currentFile, false);
            AgencyEstateViewMediaPanel.this.updateLocalization();
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The file was successfully replaced."), (Component)((Object)AgencyEstateViewMediaPanel.this));
        }
    }

    private class FileReplaceAction
    extends AbstractI18nAction {
        private FileReplaceAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doFileReplace();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("replace")));
            this.setShortDescription(I18N.tr("Replace the selected file with a file from your harddisk."));
        }
    }

    private class FileRemoveAction
    extends AbstractI18nAction {
        private FileRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doFileRemove();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove the selected file."));
        }
    }

    private class FileMoveUpAction
    extends AbstractI18nAction {
        private FileMoveUpAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_up.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doFileMoveUp();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Move up the currently selected file."));
        }
    }

    private class FileMoveDownAction
    extends AbstractI18nAction {
        private FileMoveDownAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_down.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doFileMoveDown();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Move down the currently selected file."));
        }
    }

    private class FileImportTask
    extends ImmoToolTask<FileItem[], Void> {
        private final File[] selectedFiles;
        private final boolean importFileNames;

        private FileImportTask(File[] fileArray, boolean bl) {
            this.selectedFiles = fileArray;
            this.importFileNames = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FileItem[] doInBackground() throws Exception {
            DbAgencyObject dbAgencyObject;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            if (ArrayUtils.isEmpty((Object[])this.selectedFiles)) {
                return new FileItem[0];
            }
            DbAgencyObject dbAgencyObject2 = dbAgencyObject = AgencyEstateViewMediaPanel.this.currentObject != null ? (DbAgencyObject)((Object)AgencyEstateViewMediaPanel.this.currentObject.get()) : null;
            if (dbAgencyObject == null) {
                dbAgencyObject = new DbAgencyObject();
            }
            String string = Locale.getDefault().getLanguage();
            ArrayList<FileItem> arrayList = new ArrayList<FileItem>();
            long l = System.currentTimeMillis();
            for (File file : this.selectedFiles) {
                MimeType mimeType;
                if (!file.isFile()) continue;
                DbFile dbFile = new DbFile();
                dbFile.name = file.getName();
                dbFile.objectId = dbAgencyObject.id;
                dbFile.position = 0;
                dbFile.published = true;
                dbFile.size = file.length();
                dbFile.translations = new HashMap();
                if (this.importFileNames) {
                    mimeType = new DbFile.Translation();
                    mimeType.title = StringUtils.substringBeforeLast((String)file.getName(), (String)".");
                    mimeType.title = StringUtils.replace((String)mimeType.title, (String)"_", (String)" ");
                    dbFile.translations.put(string, mimeType);
                }
                mimeType = ImmoToolUtils.getMimeType((File)file);
                dbFile.mimeType = mimeType.toString();
                FileItem fileItem = new FileItem(dbFile);
                fileItem.contentFile = file;
                if (!AgencyEstateViewMediaPanel.this.isImageMimeType(mimeType)) {
                    arrayList.add(fileItem);
                    continue;
                }
                File file2 = new File(immoToolProject.getTempDirectory() + File.separator + "preview_temp_" + ++l + ".bin");
                file2.deleteOnExit();
                try {
                    BufferedImage bufferedImage;
                    BufferedImage bufferedImage2 = ImageUtils.readAsRgb((File)file);
                    if (bufferedImage2 == null) {
                        LOGGER.warn("Can't read image!");
                        LOGGER.warn("> " + file.getAbsolutePath());
                        continue;
                    }
                    dbFile.imageWidth = bufferedImage2.getWidth();
                    dbFile.imageHeight = bufferedImage2.getHeight();
                    if (bufferedImage2.getWidth() > 300 || bufferedImage2.getHeight() > 300) {
                        bufferedImage = ImageUtils.scaleToFit((BufferedImage)bufferedImage2, (int)300, (int)300);
                        bufferedImage2.flush();
                        bufferedImage2 = bufferedImage;
                    }
                    ImageUtils.writeJpg((BufferedImage)bufferedImage2, (File)file2);
                    fileItem.previewFile = file2;
                    bufferedImage = ImageUtils.readAsRgb((File)file2);
                    if (bufferedImage == null) continue;
                    fileItem.previewImage = new ImageIcon(bufferedImage);
                    fileItem.smallImage = new ImageIcon(ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)100, (int)75));
                }
                catch (Exception exception) {
                    FileUtils.deleteQuietly((File)file2);
                    LOGGER.warn("Can't read image!");
                    LOGGER.warn("> " + file.getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                finally {
                    arrayList.add(fileItem);
                }
            }
            return arrayList.toArray(new FileItem[0]);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't import file!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyEstateViewMediaPanel.this.setFormButtonsEnabled(true);
            AgencyEstateViewMediaPanel.this.setTableButtonsEnabled(true);
        }

        protected void succeeded(FileItem[] fileItemArray) {
            super.succeeded((Object)fileItemArray);
            if (ArrayUtils.isEmpty((Object[])fileItemArray)) {
                ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("No files have been imported!"), (Component)((Object)AgencyEstateViewMediaPanel.this));
                return;
            }
            for (FileItem fileItem : fileItemArray) {
                ((FileItem)fileItem).dbFile.position = AgencyEstateViewMediaPanel.this.filesDetailedTable.getRowCount();
                AgencyEstateViewMediaPanel.this.filesIconList.addFile(fileItem);
                AgencyEstateViewMediaPanel.this.filesDetailedTable.addRow(fileItem);
            }
            AgencyEstateViewMediaPanel.this.isModified = true;
            AgencyEstateViewMediaPanel.this.filesDetailedTable.packAll();
            AgencyEstateViewMediaPanel.this.updateLocalization();
            ImmoToolUtils.showMessageInfoDialog((String)I18N.trn("{0} file was imported.", "{0} files were imported.", (long)fileItemArray.length, (Object)fileItemArray.length), (Component)((Object)AgencyEstateViewMediaPanel.this));
        }
    }

    private class FileImportAction
    extends AbstractI18nAction {
        private FileImportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doFileImport();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("import")));
            this.setShortDescription(I18N.tr("Select a file from your harddisk, that you want to attach to the property."));
        }
    }

    private class FileExportTask
    extends ImmoToolTask<Boolean, Void> {
        private final long fileId;
        private final File exportFile;

        private FileExportTask(long l, File file) {
            this.fileId = l;
            this.exportFile = file;
        }

        /*
         * Exception decompiling
         */
        protected Boolean doInBackground() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export file!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The file was successfully saved to harddisk."), (Component)((Object)AgencyEstateViewMediaPanel.this));
        }
    }

    private class FileExportAction
    extends AbstractI18nAction {
        private FileExportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewMediaPanel.this.doFileExport();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save as")));
            this.setShortDescription(I18N.tr("Save the selected file back to your harddisk."));
        }
    }

    private static enum FileTableColumn implements AbstractTable.Column
    {
        NAME,
        TEXT,
        TYPE,
        FORMAT,
        INDEX,
        SIZE,
        PUBLISHED;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case TYPE: {
                    return new DefaultTableCellRenderer((Renderer)new FileTypeRenderer());
                }
                case SIZE: {
                    return new DefaultTableCellRenderer((Renderer)new FileSizeRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case TYPE: {
                    return EstateAttachmentType.class;
                }
                case INDEX: {
                    return Integer.class;
                }
                case SIZE: {
                    return Long.class;
                }
                case PUBLISHED: {
                    return Boolean.class;
                }
                case NAME: 
                case FORMAT: 
                case TEXT: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case NAME: {
                    return I18N.tr("file");
                }
                case TEXT: {
                    return I18N.tr("title");
                }
                case TYPE: {
                    return I18N.tr("type");
                }
                case FORMAT: {
                    return I18N.tr("format");
                }
                case INDEX: {
                    return I18N.tr("position");
                }
                case SIZE: {
                    return I18N.tr("size");
                }
                case PUBLISHED: {
                    return I18N.tr("published");
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                case PUBLISHED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private final class FileTable
    extends AbstractTable<FileItem, AbstractTable.Model<FileItem>> {
        private FileTable() {
            super(AgencyEstateViewMediaPanel.TABLE_ID);
        }

        protected void doRemove() {
            AgencyEstateViewMediaPanel.this.doFileRemove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doSelect() {
            int n;
            if (!this.isEnabled()) {
                return;
            }
            int n2 = this.getSelectedRow();
            int n3 = n2 > -1 ? this.convertRowIndexToModel(n2) : -1;
            FileItem fileItem = n3 > -1 ? (FileItem)this.getRow(n3) : null;
            AgencyEstateViewMediaPanel.this.selectFile(fileItem, true);
            int n4 = n = fileItem != null && fileItem.dbFile != null ? ((FileItem)fileItem).dbFile.position : -1;
            if (n > -1) {
                try {
                    AgencyEstateViewMediaPanel.this.filesIconList.setEnabled(false);
                    AgencyEstateViewMediaPanel.this.filesIconList.setSelectedIndex(n);
                }
                finally {
                    AgencyEstateViewMediaPanel.this.filesIconList.setEnabled(true);
                }
            }
        }

        private DbFile getFileAt(int n) {
            FileItem fileItem = (FileItem)this.getRow(n);
            return fileItem != null ? fileItem.getDbFile() : null;
        }

        protected void init() {
            this.setSingleSelection();
            this.setSortable(false);
            this.setColumnControlVisible(false);
            super.init();
        }

        public boolean isPublishedAt(int n) {
            DbFile dbFile = this.getFileAt(n);
            return dbFile != null && dbFile.published;
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(FileTableColumn.values()));
        }
    }

    private static final class FileTypeRenderer
    extends TranslatableRenderer<EstateAttachmentType> {
        private FileTypeRenderer() {
        }

        public String getEmptyText() {
            return "[ " + I18N.tr("no file type selected") + " ]";
        }
    }

    private static final class FileListRenderer
    extends AbstractRenderer<FileItem> {
        private final Icon defaultFileIcon = ImmoToolEnvironment.getResourceIcon((String)"file_new.png", (int)32);
        private final Map<String, Icon> contentTypeIcons = new HashMap<String, Icon>();

        private FileListRenderer() {
        }

        public void render(FileItem fileItem, JLabel jLabel) {
            if (fileItem != null) {
                DbFile dbFile = fileItem.dbFile;
                jLabel.setEnabled(dbFile != null && dbFile.published);
                String string = dbFile != null ? StringUtils.lowerCase((String)StringUtils.trimToNull((String)dbFile.mimeType)) : null;
                Icon icon = null;
                if (fileItem.smallImage != null) {
                    icon = fileItem.smallImage;
                } else if (string != null) {
                    if (this.contentTypeIcons.containsKey(string)) {
                        icon = this.contentTypeIcons.get(string);
                    } else {
                        try {
                            icon = ImmoToolUtils.getFileIcon((ContentType)new ContentType(string), (String)((FileItem)fileItem).dbFile.name, (int)32);
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't load icon!");
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        }
                        this.contentTypeIcons.put(string, icon);
                    }
                }
                jLabel.setText(dbFile != null ? StringUtils.trimToEmpty((String)dbFile.name) : "???");
                jLabel.setIcon(icon != null ? icon : this.defaultFileIcon);
            } else {
                jLabel.setEnabled(true);
                jLabel.setText("");
                jLabel.setIcon(null);
            }
        }
    }

    private static final class FileList
    extends JList<FileItem> {
        private FileList() {
            super(new DefaultListModel());
            DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer((Renderer)new FileListRenderer());
            defaultListCellRenderer.setHorizontalAlignment(0);
            defaultListCellRenderer.setHorizontalTextPosition(0);
            defaultListCellRenderer.setVerticalTextPosition(3);
            this.setCellRenderer(defaultListCellRenderer);
            this.setLayoutOrientation(2);
            this.setFixedCellWidth(120);
            this.setVisibleRowCount(-1);
        }

        private void addFile(FileItem fileItem) {
            ((DefaultListModel)this.getModel()).addElement(fileItem);
        }

        private FileItem getFileAt(int n) {
            return (FileItem)((Object)((DefaultListModel)this.getModel()).getElementAt(n));
        }

        @Override
        public DefaultListModel<FileItem> getModel() {
            return (DefaultListModel)super.getModel();
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n < 0) {
                return super.getToolTipText(mouseEvent);
            }
            FileItem fileItem = this.getFileAt(n);
            return fileItem != null ? fileItem.writeToolTip(false) : super.getToolTipText(mouseEvent);
        }
    }

    private final class FileItem
    extends AbstractTable.Row {
        private DbFile dbFile;
        private int dbFileHash;
        private File contentFile = null;
        private File previewFile = null;
        private ImageIcon previewImage = null;
        private ImageIcon smallImage = null;
        private String customMimeType = null;
        private int rotation = 0;
        private boolean flippedH = false;
        private boolean flippedV = false;

        private FileItem(DbFile dbFile) {
            this.dbFile = dbFile;
            this.dbFileHash = dbFile.calculateHash();
        }

        private void dispose() {
            this.dbFile = null;
            this.contentFile = null;
            this.previewFile = null;
            this.customMimeType = null;
            if (this.previewImage != null) {
                this.previewImage.getImage().flush();
                this.previewImage = null;
            }
            if (this.smallImage != null) {
                this.smallImage.getImage().flush();
                this.smallImage = null;
            }
        }

        private DbFile getDbFile() {
            return this.dbFile;
        }

        private String getDescription() {
            String string = Locale.getDefault().getLanguage();
            return this.dbFile.getTitle(string);
        }

        public String getToolTipText(AbstractTable.Column column) {
            return this.writeToolTip(true);
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof FileTableColumn) {
                return this.getValueForLink((FileTableColumn)column);
            }
            return null;
        }

        private Object getValueForLink(FileTableColumn fileTableColumn) {
            if (this.dbFile == null) {
                return null;
            }
            switch (fileTableColumn) {
                case INDEX: {
                    return this.dbFile.position;
                }
                case NAME: {
                    return this.dbFile.name;
                }
                case FORMAT: {
                    return this.dbFile.mimeType;
                }
                case PUBLISHED: {
                    return this.dbFile.published;
                }
                case SIZE: {
                    return this.dbFile.size;
                }
                case TYPE: {
                    return this.dbFile.type;
                }
                case TEXT: {
                    return this.dbFile.getTitle(Locale.getDefault().getLanguage());
                }
            }
            return null;
        }

        public boolean isEditable(AbstractTable.Column column) {
            return super.isEditable(column) && this.dbFile != null && FileTableColumn.PUBLISHED.equals(column);
        }

        public boolean isPublished() {
            return this.dbFile != null && this.dbFile.published;
        }

        public void setPublished(boolean bl) {
            if (this.dbFile != null) {
                this.dbFile.published = bl;
            }
        }

        public void setValueAt(Object object, AbstractTable.Column column) {
            if (FileTableColumn.PUBLISHED.equals(column) && this.dbFile != null) {
                this.dbFile.published = Boolean.TRUE.equals(object);
            }
        }

        private String writeInfo() {
            String string = ImmoToolUtils.getHumanReadableByteCount((long)this.dbFile.size, (NumberFormat)NumberFormat.getNumberInstance());
            if (this.previewFile != null && this.dbFile.imageWidth > 0 && this.dbFile.imageHeight > 0) {
                string = string + " / " + this.dbFile.imageWidth + " x " + this.dbFile.imageHeight + " px";
            }
            return string;
        }

        private String writeToolTip(boolean bl) {
            long l = this.dbFile.size;
            String string = this.dbFile.name;
            EstateAttachmentType estateAttachmentType = this.dbFile.type;
            String string2 = StringUtils.trimToNull((String)this.getDescription());
            String string3 = "<b>" + StringEscapeUtils.escapeXml11((String)string) + "</b>";
            if (estateAttachmentType != null) {
                string3 = string3 + "<br>" + estateAttachmentType.getTranslation();
            }
            if (string2 != null) {
                string3 = string3 + "<br>" + StringEscapeUtils.escapeXml11((String)string2);
            }
            string3 = string3 + "<br>" + ImmoToolUtils.getHumanReadableByteCount((long)l, (NumberFormat)NumberFormat.getNumberInstance());
            if (this.dbFile.imageWidth > 0 && this.dbFile.imageHeight > 0) {
                string3 = string3 + "<br>" + this.dbFile.imageWidth + " x " + this.dbFile.imageHeight + " px";
            }
            if (bl && this.previewFile != null && this.previewFile.isFile() && this.smallImage != null) {
                try {
                    string3 = "<table><tr valign=\"top\"><td><img src=\"" + this.previewFile.toURI().toURL().toString() + "\" width=\"" + this.smallImage.getIconWidth() + "\" height=\"" + this.smallImage.getIconHeight() + "\"></td><td>" + string3 + "</td></tr></table>";
                }
                catch (Exception exception) {
                    LOGGER.error("Can't read image preview from disk!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            return "<html><div style=\"padding:3px;\">" + string3 + "</div></html>";
        }
    }

    private static final class ExtendedJImageFileChooser
    extends ImageFileChooser {
        private final JCheckBox importWithNamesBox = new JCheckBox();

        private ExtendedJImageFileChooser() {
        }

        protected JDialog createDialog(Component component) throws HeadlessException {
            JDialog jDialog = super.createDialog(component);
            this.importWithNamesBox.setSelected(false);
            this.importWithNamesBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
            this.importWithNamesBox.setText(I18N.tr("Use file name as description for the imported file."));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            jPanel.setLayout(new GridLayout(2, 1));
            jPanel.add((Component)ImmoToolUtils.createHead2Separator((String)StringUtils.capitalize((String)I18N.tr("import options"))));
            jPanel.add(this.importWithNamesBox);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jDialog.getRootPane().getContentPane(), "Center");
            jPanel2.add((Component)jPanel, "South");
            jDialog.getRootPane().setContentPane(jPanel2);
            jDialog.getRootPane().revalidate();
            jDialog.getRootPane().repaint();
            jDialog.setSize(jDialog.getSize().width, jDialog.getSize().height + 50);
            return jDialog;
        }

        private boolean isImportWithNames() {
            return this.importWithNamesBox.isSelected();
        }
    }

    private final class DragAndDropHandler
    extends TransferHandler {
        private DragAndDropHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            try {
                Component component = transferSupport.getComponent();
                Point point = transferSupport.getDropLocation().getDropPoint();
                if (component instanceof FileList) {
                    FileList fileList = (FileList)component;
                    short s = Short.valueOf((String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor));
                    int n = fileList.locationToIndex(point);
                    return s > -1 && n > -1 && s != n;
                }
                if (component instanceof FileTable) {
                    FileTable fileTable = (FileTable)((Object)component);
                    short s = Short.valueOf((String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor));
                    int n = fileTable.rowAtPoint(point);
                    return s > -1 && n > -1 && s != n;
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't check if importable!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            AgencyEstateViewMediaPanel.this.isMouseDragging = false;
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof FileList) {
                FileList fileList = (FileList)jComponent;
                int n = fileList.getSelectedIndex();
                if (n < 0) {
                    return null;
                }
                return new StringSelection(String.valueOf(n));
            }
            if (jComponent instanceof FileTable) {
                FileTable fileTable = (FileTable)((Object)jComponent);
                int n = fileTable.getSelectedRow();
                if (n < 0) {
                    return null;
                }
                return new StringSelection(String.valueOf(n));
            }
            return null;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            AgencyEstateViewMediaPanel.this.isMouseDragging = false;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            try {
                int n;
                Object object;
                Component component = transferSupport.getComponent();
                Point point = transferSupport.getDropLocation().getDropPoint();
                int n2 = -1;
                int n3 = -1;
                if (component instanceof FileList) {
                    object = (FileList)component;
                    n2 = Short.valueOf((String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor)).shortValue();
                    n3 = ((JList)object).locationToIndex(point);
                    AgencyEstateViewMediaPanel.this.selectFile(((FileList)object).getFileAt(n2), false);
                } else if (component instanceof FileTable) {
                    object = (FileTable)((Object)component);
                    n2 = Short.valueOf((String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor)).shortValue();
                    n3 = object.rowAtPoint(point);
                    AgencyEstateViewMediaPanel.this.selectFile((FileItem)object.getRow(n2), false);
                }
                if (n2 < 0 || n3 < 0 || n2 == n3) {
                    boolean bl = false;
                    return bl;
                }
                if (n2 < n3) {
                    for (n = n2; n < n3; n += 1) {
                        AgencyEstateViewMediaPanel.this.doFileMoveDown();
                    }
                } else {
                    for (n = n2; n > n3; n -= 1) {
                        AgencyEstateViewMediaPanel.this.doFileMoveUp();
                    }
                }
                n = 1;
                return n != 0;
            }
            catch (Exception exception) {
                LOGGER.error("Can't import dropped item!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                boolean bl = false;
                return bl;
            }
            finally {
                AgencyEstateViewMediaPanel.this.isMouseDragging = false;
            }
        }
    }
}

