/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolLogTablePanel;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewContactPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewExportsPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewLinksPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewMediaPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewSetupPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewTask;
import com.openindex.openestate.tool.agency.AgencyEstateViewValuesPanel;
import com.openindex.openestate.tool.agency.AgencyExposeDialog;
import com.openindex.openestate.tool.agency.AgencyExposeTask;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLog;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLogsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.extensions.EstateViewExtension;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbLogHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.utils.StatusNotification;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyEstateViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewPanel.class);
    private DbAgencyObject currentObject = null;
    private long nextEstateId = 0L;
    private long prevEstateId = 0L;
    private boolean mayEditEstate = false;
    private boolean mayRemoveEstate = false;
    private List<EstateViewExtension> addons;
    private AgencyEstateViewSetupPanel setupPanel;
    private AgencyEstateViewValuesPanel valuesPanel;
    private MediaPanel mediaPanel;
    private ContactsPanel contactsPanel;
    private AgencyEstateViewExportsPanel exportsPanel;
    private ProtocolPanel protocolPanel;
    private NotesPanel notesPanel;
    private PermissionsTab permissionPanel;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;

    private AgencyEstateViewPanel() {
    }

    protected JComponent buildFooterComponent() {
        return this.createInfoPanel();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(AgencyPlugin.getResourceIcon("agent_estates.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.setupPanel = (AgencyEstateViewSetupPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyEstateViewSetupPanel(), (JTabbedPane)jTabbedPane);
        this.valuesPanel = (AgencyEstateViewValuesPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyEstateViewValuesPanel(), (JTabbedPane)jTabbedPane);
        this.mediaPanel = (MediaPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new MediaPanel(), (JTabbedPane)jTabbedPane);
        this.contactsPanel = (ContactsPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ContactsPanel(this.addons), (JTabbedPane)jTabbedPane);
        this.exportsPanel = AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS) ? (AgencyEstateViewExportsPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyEstateViewExportsPanel(), (JTabbedPane)jTabbedPane) : null;
        try {
            for (EstateViewExtension estateViewExtension : this.addons) {
                AbstractTab[] abstractTabArray = estateViewExtension.createTabs();
                if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                for (AbstractTab abstractTab : abstractTabArray) {
                    ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)jTabbedPane);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addon-panels!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.protocolPanel = (ProtocolPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new ProtocolPanel(this.addons), (JTabbedPane)jTabbedPane);
        this.notesPanel = (NotesPanel)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new NotesPanel(), (JTabbedPane)jTabbedPane);
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionPanel = (PermissionsTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new PermissionsTab(), (JTabbedPane)jTabbedPane);
        }
    }

    public static AgencyEstateViewPanel createTab() {
        return AgencyEstateViewPanel.createTab(null);
    }

    public static AgencyEstateViewPanel createTab(DbAgencyObject dbAgencyObject) {
        AgencyEstateViewPanel agencyEstateViewPanel = new AgencyEstateViewPanel();
        agencyEstateViewPanel.setEstate(dbAgencyObject);
        return agencyEstateViewPanel;
    }

    protected void doCopy() {
        if (this.currentObject == null || this.currentObject.id < 1L) {
            return;
        }
        if (!this.mayEditEstate) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    private void doEstateExpose() {
        if (this.currentObject == null || this.currentObject.id < 1L) {
            return;
        }
        try {
            AgencyExposeTask agencyExposeTask = AgencyExposeDialog.showDialog(ImmoToolProject.getAppInstance(), this.currentObject.id, (Window)ImmoToolEnvironment.getFrame());
            if (agencyExposeTask != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)agencyExposeTask);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't create expos\u00e9!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't create expos\u00e9!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"agency.estates.form", null);
    }

    protected void doLoadInBackground(Connection connection) {
        this.nextEstateId = 0L;
        this.prevEstateId = 0L;
        if (this.currentObject == null || this.currentObject.id < 1L) {
            return;
        }
        try {
            long[] lArray = AgencyPlugin.getDbAgencyExtension().getObjectsHandler().getObjectIds(connection);
            int n = ArrayUtils.indexOf((long[])lArray, (long)this.currentObject.id);
            if (n > 0) {
                this.prevEstateId = lArray[n - 1];
            }
            if (n + 1 < lArray.length) {
                this.nextEstateId = lArray[n + 1];
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load previous & next dataset!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void doRefresh() {
        if (this.currentObject != null && this.currentObject.id > 0L) {
            this.setEstate(this.currentObject);
            this.loadInBackground(ImmoToolProject.getAppDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentObject == null || this.currentObject.id < 1L) {
            return;
        }
        if (!this.mayRemoveEstate) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove property {0}?", (Object)("#" + this.currentObject.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask());
    }

    protected void doShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(this.currentObject != null && this.currentObject.id > 0L && AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.currentObject != null && this.currentObject.id > 0L && this.mayRemoveEstate));
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new ExposeAction()));
        for (EstateViewExtension estateViewExtension : this.addons) {
            Object[] objectArray = estateViewExtension.createActionMenuItems(this.currentObject);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                jPopupMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)this.notesPanel.notesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        if (!this.mayEditEstate) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextEstateId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyEstateViewTask(ImmoToolProject.getAppDbDriver(), this.nextEstateId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevEstateId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyEstateViewTask(ImmoToolProject.getAppDbDriver(), this.prevEstateId, this));
        }
    }

    public long getCurrentEstateId() {
        return this.currentObject != null ? this.currentObject.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return AgencyPlugin.getResourceIcon("agent_estates.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentObject == null || this.currentObject.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("new property"));
        }
        if (this.currentObject.item != null && !StringUtils.isBlank((CharSequence)this.currentObject.item.getPublicId())) {
            return StringUtils.capitalize((String)I18N.tr("property")) + " '" + StringUtils.trimToEmpty((String)this.currentObject.item.getPublicId()) + "'";
        }
        return StringUtils.capitalize((String)I18N.tr("property")) + " #" + this.currentObject.id;
    }

    public String getTabTitle() {
        if (this.currentObject == null || this.currentObject.id < 1L) {
            return StringUtils.capitalize((String)I18N.tr("property")) + " (" + I18N.tr("new") + ")";
        }
        if (this.currentObject.item != null && !StringUtils.isBlank((CharSequence)this.currentObject.item.getPublicId())) {
            return StringUtils.capitalize((String)I18N.tr("property")) + " '" + StringUtils.trimToEmpty((String)this.currentObject.item.getPublicId()) + "'";
        }
        return StringUtils.capitalize((String)I18N.tr("property")) + " #" + this.currentObject.id;
    }

    public String getTabToolTipText() {
        if (this.currentObject == null || this.currentObject.id < 1L) {
            return I18N.tr("Create a new property.");
        }
        String string = this.currentObject.item.getType().getTranslation();
        String string2 = this.currentObject.item.getAction().getTranslation();
        return "<html><i>" + string + " / " + string2 + "</i><br><i>" + this.currentObject.status.getTranslation() + "</i><hr>" + this.currentObject.item.getAddress().writeFullAddress("<br>") + "</html>";
    }

    protected void init() {
        super.init();
        this.addons = new ArrayList<EstateViewExtension>();
        try {
            this.addons.addAll(AgencyPluginUtils.getEstateViewExtensions());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addons!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void initEstate(DbAgencyObject dbAgencyObject) throws ImmoToolException {
        if (dbAgencyObject.item == null) {
            dbAgencyObject.item = new EstateImpl();
        }
        this.setupPanel.save(dbAgencyObject);
        this.valuesPanel.save(dbAgencyObject);
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    public void selectContactsTab(Class clazz) {
        this.getTabbedPane().setSelectedComponent((Component)((Object)this.contactsPanel));
        for (int i = 0; i < this.contactsPanel.contactsTabPanel.getTabCount(); ++i) {
            Component component = this.contactsPanel.contactsTabPanel.getComponentAt(i);
            if (!component.getClass().equals(clazz)) continue;
            this.contactsPanel.contactsTabPanel.setSelectedIndex(i);
            break;
        }
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        boolean bl2 = this.currentObject == null || this.currentObject.id < 1L;
        this.submitAction.setEnabled(bl && this.mayEditEstate);
        this.closeAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && !bl2 && this.nextEstateId > 0L);
        this.viewPrevAction.setEnabled(bl && !bl2 && this.prevEstateId > 0L);
    }

    public void setEstate(DbAgencyObject dbAgencyObject) {
        DbAgencyObject dbAgencyObject2 = this.currentObject = dbAgencyObject != null ? dbAgencyObject : new DbAgencyObject();
        if (this.currentObject.item == null) {
            this.currentObject.item = new EstateImpl();
        }
        this.nextEstateId = 0L;
        this.prevEstateId = 0L;
        this.setInfoMessage(null);
        this.mayEditEstate = AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT);
        this.mayRemoveEstate = AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_REMOVE);
        if (this.currentObject.permission != null) {
            AbstractMainViewTab[] abstractMainViewTabArray = ImmoToolProject.getAppUser();
            this.mayEditEstate = this.mayEditEstate && this.currentObject.permission.canWrite((DbUser)abstractMainViewTabArray, this.currentObject.ownerUserId, this.currentObject.ownerGroupId);
            this.mayRemoveEstate = this.mayRemoveEstate && this.currentObject.permission.canDelete((DbUser)abstractMainViewTabArray, this.currentObject.ownerUserId, this.currentObject.ownerGroupId);
        }
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
            try {
                ((AbstractTab)abstractMainViewTab).load(this.currentObject);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    public void setEstateCountry(String string) {
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            if (!(abstractMainViewTab instanceof AbstractTab)) continue;
            ((AbstractTab)abstractMainViewTab).selectEstateCountry(string);
        }
    }

    public void setLanguageEnabled(Locale locale, boolean bl) {
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            if (!(abstractMainViewTab instanceof AbstractTab)) continue;
            ((AbstractTab)abstractMainViewTab).selectLanguage(locale, bl);
        }
    }

    protected void tabComponentAdded(ContainerEvent containerEvent) {
        super.tabComponentAdded(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(this);
        }
    }

    protected void tabComponentRemoved(ContainerEvent containerEvent) {
        super.tabComponentRemoved(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(null);
        }
    }

    private class SubmitTask
    extends ImmoToolTask<DbAgencyObject, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;
        private final List<String> warnings = new ArrayList<String>();

        private SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbAgencyObject doInBackground() throws Exception {
            DbAgencyObject dbAgencyObject;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler = AgencyPlugin.getDbAgencyExtension().getObjectLogsHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            this.warnings.clear();
            Connection connection = null;
            try {
                DbAgencyObject dbAgencyObject2;
                String string;
                if (this.saveAsCopy) {
                    ((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.id = 0L;
                }
                connection = ImmoToolProject.getAppDbConnection();
                Map map = dbLanguagesHandler.getLanguageMap(connection);
                if (AgencyEstateViewPanel.this.currentObject == null || ((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.id < 1L) {
                    string = "ADD";
                    dbAgencyObject2 = new DbAgencyObject();
                    dbAgencyObject2.item = new EstateImpl();
                } else {
                    string = "EDIT";
                    dbAgencyObject2 = (DbAgencyObject)dbAgencyObjectsHandler.getObject(connection, ((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.id);
                    dbAgencyObjectsHandler.loadObjectAttribs(connection, dbAgencyObject2, map);
                    dbAgencyObjectsHandler.loadObjectExportIds(connection, dbAgencyObject2);
                    dbAgencyObjectsHandler.loadObjectTranslations(connection, dbAgencyObject2, map);
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).saveWarnings.clear();
                    ((AbstractTab)abstractMainViewTab).save(dbAgencyObject2);
                }
                dbAgencyObjectsHandler.saveObject(connection, dbAgencyObject2, dbLanguagesHandler, true, true);
                DbAgencyObjectLog dbAgencyObjectLog = DbAgencyObjectLog.create(dbAgencyObject2.id, string, immoToolProject.getUser());
                if ("EDIT".equals(string)) {
                    dbAgencyObjectLog.initChanges(AgencyEstateViewPanel.this.currentObject, dbAgencyObject2);
                }
                dbAgencyObjectLogsHandler.saveLog(connection, dbAgencyObjectLog);
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                    abstractTab.saveFinished(connection, immoToolProject, dbAgencyObject2);
                    if (abstractTab.saveWarnings.isEmpty()) continue;
                    this.warnings.addAll(abstractTab.saveWarnings);
                }
                AgencyPluginUtils.updateEstateFileHashes(connection, immoToolProject.getDbDriver(), dbAgencyObject2.id, this.createCallback());
                dbAgencyObject = dbAgencyObject2;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return dbAgencyObject;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save property!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyEstateViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(DbAgencyObject dbAgencyObject) {
            super.succeeded((Object)dbAgencyObject);
            if (dbAgencyObject == null) {
                return;
            }
            if (!this.warnings.isEmpty()) {
                for (String string : this.warnings) {
                    ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning(string));
                }
            }
            AgencyEstateViewPanel.this.setEstate(dbAgencyObject);
            AgencyEstateViewPanel.this.loadInBackground(ImmoToolProject.getAppDbDriver());
        }
    }

    private class RemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private RemoveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                dbAgencyObjectsHandler.removeObject(connection, ((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.id);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete property!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyEstateViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)AgencyEstateViewPanel.this), (boolean)true);
        }
    }

    private class ExposeAction
    extends AbstractI18nAction {
        private ExposeAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_type_pdf.png", (int)16));
            this.setEnabled(AgencyEstateViewPanel.this.currentObject != null && ((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.id > 0L && AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewPanel.this.doEstateExpose();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("create expos\u00e9")));
            this.setShortDescription(I18N.tr("Create an expos\u00e9 for the property."));
        }
    }

    private static class ProtocolTablePanel
    extends ImmoToolLogTablePanel {
        private ProtocolTablePanel() {
            super((DbLogHandler)AgencyPlugin.getDbAgencyExtension().getObjectLogsHandler());
            this.setBorder((Border)Paddings.DIALOG);
        }

        protected String getActionTranslation(String string) {
            String string2 = DbAgencyObjectLog.writeAction(string);
            return string2 != null ? string2 : string;
        }
    }

    private final class ProtocolPanel
    extends AbstractTab {
        private JXTitledSeparator title;
        private JTabbedPane protocolTabPanel;
        private List<AbstractTab> addonTabs;
        private ProtocolTablePanel logTablePanel;

        private ProtocolPanel(List<EstateViewExtension> list) {
            this.build(list);
            this.updateLocalization();
        }

        private void build(List<EstateViewExtension> list) {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.addonTabs = new ArrayList<AbstractTab>();
            this.protocolTabPanel = new JTabbedPane();
            this.protocolTabPanel.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    AgencyEstateViewPanel.this.tabComponentAdded(containerEvent);
                }

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    AgencyEstateViewPanel.this.tabComponentRemoved(containerEvent);
                }
            });
            for (EstateViewExtension estateViewExtension : list) {
                try {
                    AbstractTab[] abstractTabArray = estateViewExtension.createActionTabs();
                    if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                    for (AbstractTab abstractTab : abstractTabArray) {
                        ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)this.protocolTabPanel);
                        this.addonTabs.add(abstractTab);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load addon-tabs");
                    LOGGER.warn("> for " + estateViewExtension.getClass().getName());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            this.logTablePanel = new ProtocolTablePanel();
            this.protocolTabPanel.addTab(this.logTablePanel.getTitle(), (Component)((Object)this.logTablePanel));
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.protocolTabPanel, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            this.logTablePanel.doLoadInBackground(connection);
            for (AbstractTab abstractTab : this.addonTabs) {
                if (!abstractTab.isLoadedInBackground()) continue;
                abstractTab.doLoadInBackground(connection);
            }
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("actions"));
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabEnabled() {
            return true;
        }

        public boolean isTabUsable() {
            return this.protocolTabPanel.getTabCount() > 0;
        }

        public boolean isTabValid() {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (abstractTab.isTabValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void load(DbAgencyObject dbAgencyObject) throws Exception {
            this.logTablePanel.setLogEntryId(dbAgencyObject != null ? dbAgencyObject.id : 0L);
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.load(dbAgencyObject);
            }
        }

        @Override
        public void save(DbAgencyObject dbAgencyObject) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.save(dbAgencyObject);
            }
        }

        @Override
        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException, IOException {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.saveFinished(connection, immoToolProject, dbAgencyObject);
            }
        }

        @Override
        public void selectLanguage(Locale locale, boolean bl) {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.selectLanguage(locale, bl);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("actions for the property")));
        }
    }

    private final class PermissionsTab
    extends AbstractTab {
        private ImmoToolPermissionPanel form;
        private boolean loaded = false;

        private PermissionsTab() {
            this.build();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel();
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            this.loaded = false;
            try {
                DbExtension dbExtension = immoToolProject.getDbExtension();
                DbUser dbUser = immoToolProject.getUser();
                if (AgencyEstateViewPanel.this.currentObject != null && ((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.id > 0L) {
                    this.form.setPermission(((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.ownerUserId, ((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.ownerGroupId, ((AgencyEstateViewPanel)AgencyEstateViewPanel.this).currentObject.permission);
                } else {
                    this.form.setPermission(dbUser != null ? dbUser.id : 0L, 0L, null);
                }
                this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
                this.loaded = true;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load permissions!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.loaded = false;
            }
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabEnabled() {
            return this.loaded;
        }

        @Override
        public void load(DbAgencyObject dbAgencyObject) {
            this.loaded = false;
            this.form.setPermission(0L, 0L, null);
        }

        @Override
        public void save(DbAgencyObject dbAgencyObject) {
            DbGroup dbGroup;
            dbAgencyObject.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbAgencyObject.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbAgencyObject.ownerGroupId = dbGroup.id;
            }
        }
    }

    private final class NotesPanel
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JXTitledSeparator title;
        private DefaultTextArea notesField;

        private NotesPanel() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.notesField = new DefaultTextArea();
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.notesField.createScrollPane(), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        @Override
        public void load(DbAgencyObject dbAgencyObject) {
            this.notesField.setText(dbAgencyObject != null ? StringUtils.trimToEmpty((String)dbAgencyObject.notes) : "");
            this.notesField.setCaretPosition(0);
            this.modificationHandler.clear();
            this.modificationHandler.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(DbAgencyObject dbAgencyObject) {
            dbAgencyObject.notes = this.notesField.getText().trim();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the property")));
        }
    }

    private final class MediaPanel
    extends AbstractTab {
        private JXTitledSeparator title;
        private JTabbedPane mediaTabPanel;
        private List<AbstractTab> addonTabs;

        private MediaPanel() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.addonTabs = new ArrayList<AbstractTab>();
            this.mediaTabPanel = new JTabbedPane();
            this.mediaTabPanel.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    AgencyEstateViewPanel.this.tabComponentAdded(containerEvent);
                }

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    AgencyEstateViewPanel.this.tabComponentRemoved(containerEvent);
                }
            });
            this.addonTabs.add((AbstractTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyEstateViewMediaPanel(), (JTabbedPane)this.mediaTabPanel));
            this.addonTabs.add((AbstractTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyEstateViewLinksPanel(), (JTabbedPane)this.mediaTabPanel));
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.mediaTabPanel, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (!abstractTab.isLoadedInBackground()) continue;
                abstractTab.doLoadInBackground(connection);
            }
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("media"));
        }

        public boolean isTabValid() {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (abstractTab.isTabValid()) continue;
                return false;
            }
            return true;
        }

        public boolean isLoadedInBackground() {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (!abstractTab.isLoadedInBackground()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void load(DbAgencyObject dbAgencyObject) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.load(dbAgencyObject);
            }
        }

        @Override
        public void save(DbAgencyObject dbAgencyObject) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.save(dbAgencyObject);
            }
        }

        @Override
        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException, IOException {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.saveFinished(connection, immoToolProject, dbAgencyObject);
            }
        }

        @Override
        public void selectLanguage(Locale locale, boolean bl) {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.selectLanguage(locale, bl);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("media of the property")));
        }
    }

    private final class ContactsPanel
    extends AbstractTab {
        private JXTitledSeparator title;
        private JTabbedPane contactsTabPanel;
        private List<AbstractTab> addonTabs;

        private ContactsPanel(List<EstateViewExtension> list) {
            this.build(list);
            this.updateLocalization();
        }

        private void build(List<EstateViewExtension> list) {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.addonTabs = new ArrayList<AbstractTab>();
            this.contactsTabPanel = new JTabbedPane();
            this.contactsTabPanel.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    AgencyEstateViewPanel.this.tabComponentAdded(containerEvent);
                }

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    AgencyEstateViewPanel.this.tabComponentRemoved(containerEvent);
                }
            });
            this.addonTabs.add((AbstractTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new AgencyEstateViewContactPanel(), (JTabbedPane)this.contactsTabPanel));
            for (EstateViewExtension estateViewExtension : list) {
                try {
                    AbstractTab[] abstractTabArray = estateViewExtension.createContactTabs();
                    if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                    for (AbstractTab abstractTab : abstractTabArray) {
                        ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)abstractTab, (JTabbedPane)this.contactsTabPanel);
                        this.addonTabs.add(abstractTab);
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load addon-tabs");
                    LOGGER.warn("> for " + estateViewExtension.getClass().getName());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.contactsTabPanel, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (!abstractTab.isLoadedInBackground()) continue;
                abstractTab.doLoadInBackground(connection);
            }
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("addresses"));
        }

        public boolean isTabUsable() {
            return this.contactsTabPanel.getTabCount() > 0;
        }

        public boolean isTabValid() {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (abstractTab.isTabValid()) continue;
                return false;
            }
            return true;
        }

        public boolean isLoadedInBackground() {
            for (AbstractTab abstractTab : this.addonTabs) {
                if (!abstractTab.isLoadedInBackground()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void load(DbAgencyObject dbAgencyObject) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.load(dbAgencyObject);
            }
        }

        @Override
        public void save(DbAgencyObject dbAgencyObject) throws Exception {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.save(dbAgencyObject);
            }
        }

        @Override
        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException, IOException {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.saveFinished(connection, immoToolProject, dbAgencyObject);
            }
        }

        @Override
        public void selectLanguage(Locale locale, boolean bl) {
            for (AbstractTab abstractTab : this.addonTabs) {
                abstractTab.selectLanguage(locale, bl);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("addresses for the property")));
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        private WeakReference<AgencyEstateViewPanel> viewPanel = null;
        private final List<String> saveWarnings = new ArrayList<String>();

        protected final void addSaveWarning(String string) {
            this.saveWarnings.add(string);
        }

        public AgencyEstateViewPanel getViewPanel() {
            return this.viewPanel != null ? (AgencyEstateViewPanel)((Object)this.viewPanel.get()) : null;
        }

        public abstract void load(DbAgencyObject var1) throws Exception;

        public abstract void save(DbAgencyObject var1) throws Exception;

        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException, IOException {
        }

        public void selectEstateCountry(String string) {
        }

        public void selectLanguage(Locale locale, boolean bl) {
        }

        public void setViewPanel(AgencyEstateViewPanel agencyEstateViewPanel) {
            this.viewPanel = agencyEstateViewPanel != null ? new WeakReference<AgencyEstateViewPanel>(agencyEstateViewPanel) : null;
        }
    }
}

