/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewTask
extends ImmoToolTask<AgencyEstateViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewTask.class);
    private long estateId;
    private boolean selectCreatedTab;
    private final AgencyEstateViewPanel viewTab;
    private AbstractDbDriver dbDriver;

    public AgencyEstateViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public AgencyEstateViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading property {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.estateId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    public AgencyEstateViewTask(AbstractDbDriver abstractDbDriver, long l, AgencyEstateViewPanel agencyEstateViewPanel) {
        super(I18N.tr("Loading property {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.estateId = l;
        this.selectCreatedTab = true;
        this.viewTab = agencyEstateViewPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AgencyEstateViewPanel doInBackground() throws Exception {
        Connection connection2;
        Object object;
        block8: {
            DbGeoHandler dbGeoHandler = AgencyPlugin.getDbAgencyExtension().getGeoHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            if (this.viewTab == null) {
                object = ImmoToolAppUtils.getTabs(AgencyEstateViewPanel.class);
                for (AbstractMainTab abstractMainTab : object) {
                    AgencyEstateViewPanel agencyEstateViewPanel = (AgencyEstateViewPanel)abstractMainTab;
                    if (this.estateId < 1L && agencyEstateViewPanel.getCurrentEstateId() < 1L) {
                        if (!this.selectCreatedTab) return null;
                        ImmoToolAppUtils.selectTab((Component)((Object)agencyEstateViewPanel));
                        return null;
                    }
                    if (this.estateId <= 0L || agencyEstateViewPanel.getCurrentEstateId() != this.estateId) continue;
                    if (!this.selectCreatedTab) return null;
                    ImmoToolAppUtils.selectTab((Component)((Object)agencyEstateViewPanel));
                    return null;
                }
            }
            if (this.estateId < 1L) {
                return this.viewTab != null ? this.viewTab : AgencyEstateViewPanel.createTab();
            }
            Connection connection = null;
            try {
                connection2 = this.dbDriver.getConnection();
                DbAgencyObject dbAgencyObject = (DbAgencyObject)dbAgencyObjectsHandler.getObject(connection2, this.estateId);
                if (dbAgencyObject == null) {
                    throw new Exception("Can't find estate #" + this.estateId);
                }
                Map map = dbLanguagesHandler.getLanguageMap(connection2, Boolean.valueOf(true));
                dbAgencyObjectsHandler.loadObjectAttribs(connection2, dbAgencyObject, map);
                dbAgencyObjectsHandler.loadObjectTranslations(connection2, dbAgencyObject, map);
                dbAgencyObjectsHandler.loadObjectGeoDbAreas(connection2, dbAgencyObject, dbGeoHandler);
                if (this.viewTab == null) {
                    object = AgencyEstateViewPanel.createTab(dbAgencyObject);
                    break block8;
                }
                object = this.viewTab;
                ((AgencyEstateViewPanel)((Object)object)).setEstate(dbAgencyObject);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Connection)connection2);
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)"Can't load property!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(AgencyEstateViewPanel agencyEstateViewPanel) {
        super.succeeded((Object)agencyEstateViewPanel);
        if (agencyEstateViewPanel != null) {
            if (this.viewTab == null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyEstateViewPanel, (boolean)this.selectCreatedTab);
            }
            agencyEstateViewPanel.loadInBackground(this.dbDriver);
        }
    }
}

