/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogEntry;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogMessage;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.ExportProcess;
import com.openindex.openestate.tool.gui.AbstractFrame;
import com.openindex.openestate.tool.gui.ExceptionLink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportHandler.class);
    private static final int MAX_PARALLEL_PREPARATIONS = 1;
    private static final int MAX_PARALLEL_TRANSPORTS = 1;
    private static final Map<Long, Job> currentJobs = new LinkedHashMap<Long, Job>();
    private static final Map<Long, ImmoToolTask> currentPreparations = new HashMap<Long, ImmoToolTask>(1);
    private static final Map<Long, ImmoToolTask> currentTransports = new HashMap<Long, ImmoToolTask>(1);
    private static final ArrayList<WeakReference<JobListener>> jobListeners = new ArrayList();
    private static boolean started = false;

    private AgencyExportHandler() {
    }

    public static void addJobListener(JobListener jobListener) {
        jobListeners.add(new WeakReference<JobListener>(jobListener));
        AgencyExportHandler.updateJobListeners();
    }

    public static void cancelExportJob(long l, boolean bl) {
        ImmoToolTask immoToolTask;
        Job job = AgencyExportHandler.getExportJob(l);
        if (JobState.PREPARATION_PENDING.equals((Object)job.state)) {
            AgencyExportHandler.setExportJobState(l, JobState.PREPARATION_CANCELLED, null);
        } else if (JobState.TRANSPORT_PENDING.equals((Object)job.state)) {
            AgencyExportHandler.setExportJobState(l, JobState.TRANSPORT_CANCELLED, null);
        }
        ImmoToolTask immoToolTask2 = currentPreparations.get(l);
        if (immoToolTask2 != null) {
            if (!immoToolTask2.isDone()) {
                immoToolTask2.cancel(bl);
            }
            currentPreparations.remove(l);
        }
        if ((immoToolTask = currentTransports.get(l)) != null) {
            if (!immoToolTask.isDone()) {
                immoToolTask.cancel(bl);
            }
            currentTransports.remove(l);
        }
    }

    public static void cancelExportJobs(boolean bl) {
        for (Long l : currentJobs.keySet()) {
            JobState jobState = AgencyExportHandler.getExportJobState(l);
            if (JobState.PREPARATION_PENDING.equals((Object)jobState)) {
                AgencyExportHandler.setExportJobState(l, JobState.PREPARATION_CANCELLED, null);
                continue;
            }
            if (!JobState.TRANSPORT_PENDING.equals((Object)jobState)) continue;
            AgencyExportHandler.setExportJobState(l, JobState.TRANSPORT_CANCELLED, null);
        }
        for (Long l : currentJobs.keySet()) {
            AgencyExportHandler.cancelExportJob(l, bl);
        }
    }

    public static Job getExportJob(long l) {
        return currentJobs.get(l);
    }

    public static JobState getExportJobState(long l) {
        Job job = currentJobs.get(l);
        return job != null ? job.state : null;
    }

    public static boolean hasExportJob(long l) {
        return currentJobs.containsKey(l);
    }

    public static boolean hasRunningJobs() {
        for (Long l : currentJobs.keySet()) {
            if (!AgencyExportHandler.isJobRunning(l)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJobError(long l) {
        JobState jobState = AgencyExportHandler.getExportJobState(l);
        return JobState.FINISHING_ERROR.equals((Object)jobState) || JobState.PREPARATION_ERROR.equals((Object)jobState) || JobState.TRANSPORT_ERROR.equals((Object)jobState);
    }

    public static boolean isJobRunning(long l) {
        JobState jobState = AgencyExportHandler.getExportJobState(l);
        return JobState.FINISHING.equals((Object)jobState) || JobState.PREPARATION_PENDING.equals((Object)jobState) || JobState.PREPARATION_RUNNING.equals((Object)jobState) || JobState.TRANSPORT_PENDING.equals((Object)jobState) || JobState.TRANSPORT_RUNNING.equals((Object)jobState);
    }

    public static boolean isJobTransportFailed(long l) {
        JobState jobState = AgencyExportHandler.getExportJobState(l);
        return JobState.TRANSPORT_CANCELLED.equals((Object)jobState) || JobState.TRANSPORT_ERROR.equals((Object)jobState);
    }

    public static boolean putExportJob(ExportContext exportContext) {
        long l = exportContext.export.id;
        Job job = currentJobs.get(l);
        if (job != null) {
            if (JobState.PREPARATION_PENDING.equals((Object)job.state) || JobState.PREPARATION_RUNNING.equals((Object)job.state) || JobState.TRANSPORT_PENDING.equals((Object)job.state) || JobState.TRANSPORT_RUNNING.equals((Object)job.state)) {
                return false;
            }
            currentJobs.remove(l);
            currentPreparations.remove(l);
            currentTransports.remove(l);
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new JobInitTask(exportContext));
        return true;
    }

    public static void removeExportJob(long l) {
        if (!AgencyExportHandler.hasExportJob(l)) {
            return;
        }
        AgencyExportHandler.cancelExportJob(l, true);
        currentJobs.remove(l);
        for (WeakReference<JobListener> weakReference : jobListeners) {
            try {
                JobListener jobListener = (JobListener)weakReference.get();
                if (jobListener == null) continue;
                jobListener.jobRemoved(l);
            }
            catch (Exception exception) {
                LOGGER.error("Can't change job state!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public static void removeJobListener(JobListener jobListener) {
        for (int i = jobListeners.size() - 1; i > -1; --i) {
            JobListener jobListener2 = (JobListener)jobListeners.get(i).get();
            if (jobListener2 != jobListener) continue;
            jobListeners.remove(i);
            break;
        }
        jobListeners.trimToSize();
    }

    public static boolean restartFailedTransport(long l) {
        Job job = currentJobs.get(l);
        if (job == null) {
            return false;
        }
        if (!JobState.TRANSPORT_ERROR.equals((Object)job.state) && !JobState.TRANSPORT_CANCELLED.equals((Object)job.state)) {
            return false;
        }
        AgencyExportHandler.setExportJobState(l, JobState.TRANSPORT_PENDING, null);
        AgencyExportHandler.startNextTransport();
        return true;
    }

    private static boolean setExportJobState(final long l, JobState jobState, Throwable throwable) {
        Object object;
        Object object2;
        Job job = currentJobs.get(l);
        if (job == null) {
            return false;
        }
        job.state = jobState;
        job.errorException = throwable;
        job.errorMessage = StringUtils.trimToNull((String)(throwable != null ? throwable.getLocalizedMessage() : null));
        AbstractFrame abstractFrame = jobListeners.iterator();
        while (abstractFrame.hasNext()) {
            object2 = abstractFrame.next();
            try {
                object = (JobListener)((Reference)object2).get();
                if (object == null) continue;
                object.jobStateChanged(job);
            }
            catch (Exception exception) {
                LOGGER.error("Can't change job state!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (JobState.FINISHED.equals((Object)jobState)) {
            abstractFrame = ImmoToolEnvironment.getFrame();
            if (abstractFrame != null) {
                DbAgencyExportLogMessage dbAgencyExportLogMessage2;
                object2 = NumberFormat.getIntegerInstance();
                job.countErrors = 0;
                job.countWarnings = 0;
                job.countNotices = 0;
                if (job.context != null && ((Job)job).context.messages != null) {
                    for (DbAgencyExportLogMessage dbAgencyExportLogMessage2 : ((Job)job).context.messages) {
                        if (DbAgencyExportLogMessage.Level.ERROR.equals((Object)dbAgencyExportLogMessage2.level)) {
                            job.countErrors++;
                            continue;
                        }
                        if (DbAgencyExportLogMessage.Level.WARNING.equals((Object)dbAgencyExportLogMessage2.level)) {
                            job.countWarnings++;
                            continue;
                        }
                        if (!DbAgencyExportLogMessage.Level.NOTICE.equals((Object)dbAgencyExportLogMessage2.level)) continue;
                        job.countNotices++;
                    }
                }
                object = "<html><b>" + I18N.tr("export via {0}", (Object)StringUtils.abbreviate((String)job.getExportName(), (int)40)) + "</b><br>" + I18N.tr("finished successfully") + "<br>" + I18N.trn("{0} error", "{0} errors", (long)job.countErrors, (Object)("<b style=\"font-size:1.2em;\">" + ((NumberFormat)object2).format(job.countErrors) + "</b>")) + ", " + I18N.trn("{0} warning", "{0} warnings", (long)job.countWarnings, (Object)("<b style=\"font-size:1.2em;\">" + ((NumberFormat)object2).format(job.countWarnings) + "</b>")) + ", " + I18N.trn("{0} notice", "{0} notices", (long)job.countNotices, (Object)("<b style=\"font-size:1.2em;\">" + ((NumberFormat)object2).format(job.countNotices) + "</b>")) + "</html>";
                dbAgencyExportLogMessage2 = new JXHyperlink();
                dbAgencyExportLogMessage2.setText(I18N.tr("Show export protocol."));
                dbAgencyExportLogMessage2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        new AgencyPlugin.ExportViewLogAction(l).actionPerformed(actionEvent);
                    }
                });
                JPanel jPanel = new JPanel(new BorderLayout(0, 0));
                jPanel.setOpaque(false);
                jPanel.add((Component)new JLabel((String)object), "North");
                jPanel.add((Component)((Object)dbAgencyExportLogMessage2), "South");
                abstractFrame.showStatusNotification((JComponent)jPanel, ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32));
            }
        } else if (JobState.PREPARATION_ERROR.equals((Object)jobState)) {
            abstractFrame = ImmoToolEnvironment.getFrame();
            if (abstractFrame != null) {
                object2 = "<html><div style=\"color:#FF0000;\"><b>" + I18N.tr("export via {0}", (Object)StringUtils.abbreviate((String)job.getExportName(), (int)40)) + "</b><br>" + JobState.PREPARATION_ERROR.getTranslation() + "</div></html>";
                object = new JPanel(new BorderLayout(0, 0));
                ((JComponent)object).setOpaque(false);
                ((Container)object).add((Component)new JLabel((String)object2), "North");
                ((Container)object).add((Component)new ExceptionLink(I18N.tr("Show error details."), I18N.tr("Export failed during preparation."), job.getErrorException()), "South");
                abstractFrame.showStatusNotification((JComponent)object, ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32));
            }
        } else if (JobState.TRANSPORT_ERROR.equals((Object)jobState)) {
            abstractFrame = ImmoToolEnvironment.getFrame();
            if (abstractFrame != null) {
                object2 = "<html><div style=\"color:#FF0000;\"><b>" + I18N.tr("export via {0}", (Object)StringUtils.abbreviate((String)job.getExportName(), (int)40)) + "</b><br>" + JobState.TRANSPORT_ERROR.getTranslation() + "</div></html>";
                object = new JPanel(new BorderLayout(0, 0));
                ((JComponent)object).setOpaque(false);
                ((Container)object).add((Component)new JLabel((String)object2), "North");
                ((Container)object).add((Component)new ExceptionLink(I18N.tr("Show error details."), I18N.tr("Export failed during transport."), job.getErrorException()), "South");
                abstractFrame.showStatusNotification((JComponent)object, ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32));
            }
        } else if (JobState.FINISHING_ERROR.equals((Object)jobState) && (abstractFrame = ImmoToolEnvironment.getFrame()) != null) {
            object2 = "<html><div style=\"color:#FF0000;\"><b>" + I18N.tr("export via {0}", (Object)StringUtils.abbreviate((String)job.getExportName(), (int)40)) + "</b><br>" + JobState.FINISHING_ERROR.getTranslation() + "</div></html>";
            object = new JPanel(new BorderLayout(0, 0));
            ((JComponent)object).setOpaque(false);
            ((Container)object).add((Component)new JLabel((String)object2), "North");
            ((Container)object).add((Component)new ExceptionLink(I18N.tr("Show error details."), I18N.tr("Export failed during finalization."), job.getErrorException()), "South");
            abstractFrame.showStatusNotification((JComponent)object, ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32));
        }
        if (JobState.FINISHING.equals((Object)jobState) || JobState.PREPARATION_CANCELLED.equals((Object)jobState) || JobState.PREPARATION_ERROR.equals((Object)jobState) || JobState.TRANSPORT_CANCELLED.equals((Object)jobState) || JobState.TRANSPORT_ERROR.equals((Object)jobState)) {
            ImmoToolUtils.executeTask((ImmoToolTask)new JobFinishTask(job));
        }
        return true;
    }

    public static void start() {
        started = true;
        AgencyExportHandler.startNextPreparation();
    }

    private static synchronized void startNextPreparation() {
        if (!started || currentPreparations.size() >= 1) {
            return;
        }
        for (Job job : currentJobs.values()) {
            if (!JobState.PREPARATION_PENDING.equals((Object)job.state)) continue;
            ImmoToolTask immoToolTask = job.getPreparationTask();
            immoToolTask.addListener((ImmoToolTask.Listener)new PreparationTaskListener(job.exportId));
            currentPreparations.put(job.exportId, immoToolTask);
            ImmoToolUtils.executeTask((ImmoToolTask)immoToolTask);
            if (currentPreparations.size() < 1) continue;
            return;
        }
    }

    private static synchronized void startNextTransport() {
        if (!started || currentTransports.size() >= 1) {
            return;
        }
        for (Job job : currentJobs.values()) {
            if (!JobState.TRANSPORT_PENDING.equals((Object)job.state)) continue;
            ImmoToolTask immoToolTask = job.getTransportTask();
            immoToolTask.addListener((ImmoToolTask.Listener)new TransportTaskListener(job.exportId));
            currentTransports.put(job.exportId, immoToolTask);
            ImmoToolUtils.executeTask((ImmoToolTask)immoToolTask);
            if (currentTransports.size() < 1) continue;
            return;
        }
    }

    public static void stop(boolean bl) {
        started = false;
        currentJobs.clear();
        for (ImmoToolTask immoToolTask : currentPreparations.values()) {
            immoToolTask.cancel(bl);
        }
        currentPreparations.clear();
        for (ImmoToolTask immoToolTask : currentTransports.values()) {
            immoToolTask.cancel(bl);
        }
        currentTransports.clear();
    }

    private static void updateJobListeners() {
        for (int i = jobListeners.size() - 1; i > -1; --i) {
            JobListener jobListener = (JobListener)jobListeners.get(i).get();
            if (jobListener != null) continue;
            jobListeners.remove(i);
        }
        jobListeners.trimToSize();
    }

    private static class TransportTaskListener
    extends ImmoToolTask.Adapter {
        private final long exportId;

        public TransportTaskListener(long l) {
            this.exportId = l;
        }

        public void messageChanged(String string, String string2, long l) {
            Job job = (Job)currentJobs.get(this.exportId);
            if (job != null) {
                job.message = StringUtils.trimToNull((String)string);
            }
            for (WeakReference weakReference : jobListeners) {
                try {
                    JobListener jobListener = (JobListener)weakReference.get();
                    if (jobListener == null) continue;
                    jobListener.taskMessageChanged(this.exportId, string);
                }
                catch (Exception exception) {
                    LOGGER.error("Can't change job message!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        public void progressChanged(Integer n, Integer n2, long l) {
            Job job = (Job)currentJobs.get(this.exportId);
            if (job != null) {
                job.progress = n != null ? n : 0;
            }
            for (WeakReference weakReference : jobListeners) {
                try {
                    JobListener jobListener = (JobListener)weakReference.get();
                    if (jobListener == null) continue;
                    jobListener.taskProgressChanged(this.exportId, n != null ? n : 0);
                }
                catch (Exception exception) {
                    LOGGER.error("Can't change job progress!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        public void stateChanged(SwingWorker.StateValue stateValue, SwingWorker.StateValue stateValue2, long l) {
            Job job;
            if (SwingWorker.StateValue.STARTED.equals((Object)stateValue) && (job = (Job)currentJobs.get(this.exportId)) != null) {
                job.progress = -1;
                job.message = null;
                AgencyExportHandler.setExportJobState(this.exportId, JobState.TRANSPORT_RUNNING, null);
            }
        }

        public void taskCancelled(long l) {
            AgencyExportHandler.setExportJobState(this.exportId, JobState.TRANSPORT_CANCELLED, null);
        }

        public void taskFailed(Throwable throwable, long l) {
            AgencyExportHandler.setExportJobState(this.exportId, JobState.TRANSPORT_ERROR, throwable);
        }

        public void taskFinished(long l) {
            currentTransports.remove(this.exportId);
            Job job = (Job)currentJobs.get(this.exportId);
            if (job != null) {
                job.progress = -1;
                job.message = null;
            }
            AgencyExportHandler.startNextTransport();
        }

        public void taskSucceeded(Object object, long l) {
            AgencyExportHandler.setExportJobState(this.exportId, JobState.FINISHING, null);
        }
    }

    private static class PreparationTaskListener
    extends ImmoToolTask.Adapter {
        private final long exportId;

        public PreparationTaskListener(long l) {
            this.exportId = l;
        }

        public void messageChanged(String string, String string2, long l) {
            Job job = (Job)currentJobs.get(this.exportId);
            if (job != null) {
                job.message = StringUtils.trimToNull((String)string);
            }
            for (WeakReference weakReference : jobListeners) {
                try {
                    JobListener jobListener = (JobListener)weakReference.get();
                    if (jobListener == null) continue;
                    jobListener.taskMessageChanged(this.exportId, string);
                }
                catch (Exception exception) {
                    LOGGER.error("Can't change job message!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        public void progressChanged(Integer n, Integer n2, long l) {
            Job job = (Job)currentJobs.get(this.exportId);
            if (job != null) {
                job.progress = n != null ? n : 0;
            }
            for (WeakReference weakReference : jobListeners) {
                try {
                    JobListener jobListener = (JobListener)weakReference.get();
                    if (jobListener == null) continue;
                    jobListener.taskProgressChanged(this.exportId, n != null ? n : 0);
                }
                catch (Exception exception) {
                    LOGGER.error("Can't change job progress!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }

        public void stateChanged(SwingWorker.StateValue stateValue, SwingWorker.StateValue stateValue2, long l) {
            Job job;
            if (SwingWorker.StateValue.STARTED.equals((Object)stateValue) && (job = (Job)currentJobs.get(this.exportId)) != null) {
                job.progress = -1;
                job.message = null;
                AgencyExportHandler.setExportJobState(this.exportId, JobState.PREPARATION_RUNNING, null);
            }
        }

        public void taskCancelled(long l) {
            AgencyExportHandler.setExportJobState(this.exportId, JobState.PREPARATION_CANCELLED, null);
        }

        public void taskFailed(Throwable throwable, long l) {
            AgencyExportHandler.setExportJobState(this.exportId, JobState.PREPARATION_ERROR, throwable);
        }

        public void taskFinished(long l) {
            currentPreparations.remove(this.exportId);
            Job job = (Job)currentJobs.get(this.exportId);
            if (job != null) {
                job.progress = -1;
                job.message = null;
            }
            AgencyExportHandler.startNextPreparation();
            AgencyExportHandler.startNextTransport();
        }

        public void taskSucceeded(Object object, long l) {
            AgencyExportHandler.setExportJobState(this.exportId, JobState.TRANSPORT_PENDING, null);
        }
    }

    private static class JobInitTask
    extends ImmoToolTask<Job, Void> {
        private final ExportContext context;

        public JobInitTask(ExportContext exportContext) {
            super(I18N.tr("Init export {0}.", (Object)("'" + exportContext.export.name + "'")));
            this.context = exportContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Job doInBackground() throws Exception {
            DbAgencyExport dbAgencyExport = this.context.export;
            DbAgencyExportsHandler dbAgencyExportsHandler = this.context.dbExtension.getExportsHandler();
            dbAgencyExport.lockTime = this.context.stamp;
            Connection connection = null;
            try {
                connection = this.context.dbDriver.getConnection();
                dbAgencyExportsHandler.saveExport(connection, dbAgencyExport, false, false);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return new Job(this.context);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't init export!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
        }

        protected void succeeded(Job job) {
            super.succeeded((Object)job);
            currentJobs.put(job.exportId, job);
            for (WeakReference weakReference : jobListeners) {
                try {
                    JobListener jobListener = (JobListener)weakReference.get();
                    if (jobListener == null) continue;
                    jobListener.jobAdded(job);
                }
                catch (Exception exception) {
                    LOGGER.error("Can't register export job!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            AgencyExportHandler.startNextPreparation();
        }
    }

    private static class JobFinishTask
    extends ImmoToolTask<Boolean, Void> {
        private final Job job;

        public JobFinishTask(Job job) {
            super(I18N.tr("Finish export {0}.", (Object)("'" + ((Job)job).context.export.name + "'")));
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ExportContext exportContext = this.job.context;
            JobState jobState = this.job.state;
            DbAgencyExport dbAgencyExport = exportContext.export;
            DbAgencyExportsHandler dbAgencyExportsHandler = exportContext.dbExtension.getExportsHandler();
            dbAgencyExport.lockTime = null;
            DbAgencyExportLog dbAgencyExportLog = null;
            if (JobState.FINISHING.equals((Object)jobState)) {
                dbAgencyExport.lastExecution = exportContext.stamp;
                dbAgencyExportLog = new DbAgencyExportLog();
                dbAgencyExportLog.exportId = dbAgencyExport.id;
                dbAgencyExportLog.time = dbAgencyExport.lastExecution;
                dbAgencyExportLog.limit = dbAgencyExport.limit;
                dbAgencyExportLog.format = dbAgencyExport.getFormatName();
                dbAgencyExportLog.transport = dbAgencyExport.getTransportName();
                dbAgencyExportLog.transferMode = exportContext.transferMode;
                if (exportContext.isFullTranfer()) {
                    dbAgencyExport.publishings.clear();
                }
                dbAgencyExportLog.messages = new ArrayList<DbAgencyExportLogMessage>();
                if (exportContext.messages != null) {
                    dbAgencyExportLog.messages.addAll(exportContext.messages);
                }
                for (DbAgencyExportLogMessage dbAgencyExportLogMessage : dbAgencyExportLog.messages) {
                    if (DbAgencyExportLogMessage.Level.ERROR.equals((Object)dbAgencyExportLogMessage.level)) {
                        ++dbAgencyExportLog.countErrors;
                        continue;
                    }
                    if (DbAgencyExportLogMessage.Level.NOTICE.equals((Object)dbAgencyExportLogMessage.level)) {
                        ++dbAgencyExportLog.countNotices;
                        continue;
                    }
                    if (!DbAgencyExportLogMessage.Level.WARNING.equals((Object)dbAgencyExportLogMessage.level)) continue;
                    ++dbAgencyExportLog.countWarnings;
                }
                if (exportContext.isIncrementalTransfer()) {
                    for (Iterator<ExportEntry> iterator : (Iterator<ExportEntry>)exportContext.getIgnoredEntryIds()) {
                        if (!dbAgencyExport.publishings.containsKey(Long.valueOf(iterator))) {
                            LOGGER.warn("Can't ignore unpublished object #" + (long)iterator + "!");
                            continue;
                        }
                        String string = exportContext.getIgnoredEntryHash((long)iterator);
                        if (StringUtils.isBlank((CharSequence)string)) {
                            LOGGER.warn("Invalid hash value for ignored object #" + (long)iterator + "!");
                            continue;
                        }
                        dbAgencyExport.publishings.get((Object)Long.valueOf(iterator)).hash = string;
                    }
                }
                dbAgencyExportLog.entries = new HashMap<Long, DbAgencyExportLogEntry>();
                for (ExportEntry exportEntry : exportContext.entries) {
                    int n = 0;
                    for (DbAgencyExportLogMessage dbAgencyExportLogMessage : dbAgencyExportLog.messages) {
                        if (dbAgencyExportLogMessage.objectId != exportEntry.objectId || !DbAgencyExportLogMessage.Level.ERROR.equals((Object)dbAgencyExportLogMessage.level)) continue;
                        n = 1;
                        break;
                    }
                    if (DbAgencyExportAction.INSERT.equals((Object)exportEntry.action) || DbAgencyExportAction.UPDATE.equals((Object)exportEntry.action)) {
                        exportEntry.exportId = dbAgencyExport.id;
                        exportEntry.time = exportContext.stamp;
                        if (DbAgencyExportAction.INSERT.equals((Object)exportEntry.action)) {
                            ++dbAgencyExportLog.countInserts;
                        }
                        if (DbAgencyExportAction.UPDATE.equals((Object)exportEntry.action)) {
                            ++dbAgencyExportLog.countUpdates;
                        }
                        if (n == 0) {
                            dbAgencyExport.publishings.put(exportEntry.objectId, exportEntry);
                        }
                    } else if (exportContext.isIncrementalTransfer() && DbAgencyExportAction.DELETE.equals((Object)exportEntry.action)) {
                        ++dbAgencyExportLog.countDeletes;
                        if (n == 0) {
                            dbAgencyExport.publishings.remove(exportEntry.objectId);
                        }
                    }
                    DbAgencyExportLogEntry dbAgencyExportLogEntry = new DbAgencyExportLogEntry();
                    dbAgencyExportLogEntry.action = exportEntry.action;
                    dbAgencyExportLogEntry.exported = n == 0;
                    dbAgencyExportLogEntry.objectId = exportEntry.objectId;
                    dbAgencyExportLogEntry.objectNr = exportEntry.objectNr;
                    dbAgencyExportLog.entries.put(dbAgencyExportLogEntry.objectId, dbAgencyExportLogEntry);
                }
            }
            Iterator<ExportEntry> iterator = null;
            try {
                iterator = exportContext.dbDriver.getConnection();
                dbAgencyExportsHandler.saveExport((Connection)((Object)iterator), dbAgencyExport, false, JobState.FINISHING.equals((Object)jobState));
                if (dbAgencyExportLog != null) {
                    dbAgencyExportsHandler.saveExportLog((Connection)((Object)iterator), dbAgencyExportLog);
                }
            }
            finally {
                JdbcUtils.closeQuietly((Connection)((Object)iterator));
            }
            if (JobState.FINISHING.equals((Object)jobState)) {
                exportContext.clear();
            }
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            JobState jobState = this.job.state;
            if (JobState.FINISHING.equals((Object)jobState)) {
                AgencyExportHandler.setExportJobState(this.job.exportId, JobState.FINISHING_ERROR, throwable);
            }
        }

        protected void finished() {
            super.finished();
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            JobState jobState = this.job.state;
            if (JobState.FINISHING.equals((Object)jobState)) {
                AgencyExportHandler.setExportJobState(this.job.exportId, JobState.FINISHED, null);
            }
        }
    }

    public static enum JobState implements Translatable
    {
        PREPARATION_PENDING(I18n.marktr((String)"waiting for preparation")),
        PREPARATION_RUNNING(I18n.marktr((String)"preparation is running")),
        PREPARATION_ERROR(I18n.marktr((String)"error during preparation")),
        PREPARATION_CANCELLED(I18n.marktr((String)"preparation was cancelled")),
        TRANSPORT_PENDING(I18n.marktr((String)"waiting for transport")),
        TRANSPORT_RUNNING(I18n.marktr((String)"transport is running")),
        TRANSPORT_ERROR(I18n.marktr((String)"error during transport")),
        TRANSPORT_CANCELLED(I18n.marktr((String)"transport was cancelled")),
        FINISHING(I18n.marktr((String)"finishing export")),
        FINISHING_ERROR(I18n.marktr((String)"error during finishing")),
        FINISHED(I18n.marktr((String)"export finished")),
        LOCKED(I18n.marktr((String)"locked by another user"));

        private final String i18nKey;

        private JobState(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(JobState.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(JobState.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static interface JobListener {
        public void jobAdded(Job var1);

        public void jobRemoved(long var1);

        public void jobStateChanged(Job var1);

        public void taskMessageChanged(long var1, String var3);

        public void taskProgressChanged(long var1, int var3);
    }

    public static class Job {
        private final long exportId;
        private final ExportProcess export;
        private final ExportContext context;
        private JobState state = JobState.PREPARATION_PENDING;
        private String errorMessage = null;
        private Throwable errorException = null;
        private String message = null;
        private int progress = -1;
        private int countErrors = 0;
        private int countWarnings = 0;
        private int countNotices = 0;

        private Job(ExportContext exportContext) {
            this.context = exportContext;
            this.export = exportContext.createExportProcess();
            this.exportId = exportContext.export.id;
        }

        public int getCountErrors() {
            return this.countErrors;
        }

        public int getCountNotices() {
            return this.countNotices;
        }

        public int getCountWarnings() {
            return this.countWarnings;
        }

        public Throwable getErrorException() {
            return this.errorException;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public long getExportId() {
            return this.exportId;
        }

        public String getExportName() {
            String string = StringUtils.trimToNull((String)this.context.export.name);
            return string != null ? string : "#" + this.getExportId();
        }

        public Date getLastExecutionDate() {
            return this.context.export.lastExecution;
        }

        public String getMessage() {
            return this.message;
        }

        private ImmoToolTask getPreparationTask() {
            return this.export.prepare(this.context);
        }

        public int getProgress() {
            return this.progress;
        }

        public JobState getState() {
            return this.state;
        }

        private ImmoToolTask getTransportTask() {
            return this.export.transport(this.context);
        }
    }
}

