/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.agency.AgencyExportLogsPanel;
import com.openindex.openestate.tool.agency.AgencyExportViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportViewHistoryPanel
extends AgencyExportViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportViewHistoryPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportViewHistoryPanel.class);
    private static final String TABLE_ID = "AgencyExportViewHistoryPanel.Table";
    private DbAgencyExport currentExport = null;
    private AgencyExportLogsPanel logsPanel;

    public AgencyExportViewHistoryPanel() {
        this.build();
    }

    private void build() {
        this.logsPanel = new AgencyExportLogsPanel(TABLE_ID, false);
        this.setBorder(Paddings.EMPTY);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)((Object)this.logsPanel), "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        ArrayList<DbAgencyExportLog> arrayList = new ArrayList<DbAgencyExportLog>();
        try {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            arrayList.addAll(Arrays.asList(dbAgencyExportsHandler.getExportLogs(connection, this.currentExport.id)));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$logs;
                {
                    this.val$logs = list;
                }

                @Override
                public void run() {
                    try {
                        for (DbAgencyExportLog dbAgencyExportLog : this.val$logs) {
                            AgencyExportViewHistoryPanel.this.logsPanel.addExportLog(dbAgencyExportLog, ((AgencyExportViewHistoryPanel)AgencyExportViewHistoryPanel.this).currentExport.name);
                        }
                    }
                    finally {
                        AgencyExportViewHistoryPanel.this.logsPanel.updateLocalization();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("history"));
    }

    public boolean isLoadedInBackground() {
        return this.currentExport != null && this.currentExport.id > 0L;
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport) {
        this.currentExport = dbAgencyExport;
        this.logsPanel.clearExportLogs();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport) {
    }
}

