/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportViewPanel;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyExportViewMediaPanel
extends AgencyExportViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportViewMediaPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportViewMediaPanel.class);
    private static final String ATTACHMENT_TYPE_TABLE_ID = "AgencyExportViewMediaPanel.AttachmentTypeTable";
    private boolean formatWasLoaded = false;
    private ValidationHandler validationHandler;
    private JXTitledSeparator title;
    private JLabel publishFilesLabel;
    private JComboBox<PublishingMode> publishFilesField;
    private JLabel publishLinksLabel;
    private JComboBox<PublishingMode> publishLinksField;
    private JCheckBox countImageBox;
    private JSpinner countImageSpinner;
    private JCheckBox countVideoBox;
    private JSpinner countVideoSpinner;
    private JTabbedPane tabbedPane;
    private AttachmentImageTab attachmentImageTab;
    private AttachmentTypeTab attachmentTypeTab;

    public AgencyExportViewMediaPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.title = ImmoToolUtils.createHead2Separator((String)"");
        this.tabbedPane = new JTabbedPane();
        this.attachmentImageTab = (AttachmentImageTab)ImmoToolUtils.addTab((AbstractTab)new AttachmentImageTab(), (JTabbedPane)this.tabbedPane);
        this.attachmentTypeTab = (AttachmentTypeTab)ImmoToolUtils.addTab((AbstractTab)new AttachmentTypeTab(), (JTabbedPane)this.tabbedPane);
        this.publishFilesLabel = new JLabel();
        this.publishFilesField = new JComboBox();
        this.publishFilesField.setRenderer((ListCellRenderer<PublishingMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        this.publishFilesField.addItem(PublishingMode.DEFAULT);
        this.publishFilesField.addItem(PublishingMode.NEVER);
        this.publishFilesField.addItem(PublishingMode.ALWAYS);
        this.publishFilesField.setPrototypeDisplayValue(PublishingMode.DEFAULT);
        this.publishFilesField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AgencyExportViewMediaPanel.this.publishFilesField.isEnabled()) {
                    AgencyExportViewMediaPanel.this.setEnabled(true);
                }
            }
        });
        this.publishLinksLabel = new JLabel();
        this.publishLinksField = new JComboBox();
        this.publishLinksField.setRenderer((ListCellRenderer<PublishingMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        this.publishLinksField.addItem(PublishingMode.DEFAULT);
        this.publishLinksField.addItem(PublishingMode.NEVER);
        this.publishLinksField.addItem(PublishingMode.ALWAYS);
        this.publishLinksField.setPrototypeDisplayValue(PublishingMode.DEFAULT);
        this.countImageBox = new JCheckBox();
        this.countImageBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AgencyExportViewMediaPanel.this.countImageBox.isSelected();
                AgencyExportViewMediaPanel.this.countImageSpinner.setEnabled(bl);
            }
        });
        this.countImageSpinner = new JSpinner(new SpinnerNumberModel(10, 0, 999, 1));
        this.countVideoBox = new JCheckBox();
        this.countVideoBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AgencyExportViewMediaPanel.this.countVideoBox.isSelected();
                AgencyExportViewMediaPanel.this.countVideoSpinner.setEnabled(bl);
            }
        });
        this.countVideoSpinner = new JSpinner(new SpinnerNumberModel(5, 0, 999, 1));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu:grow, 6dlu, right:pref, 3dlu, 40dlu");
        defaultFormBuilder.add((Component)this.title).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.publishFilesLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.publishFilesField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.countImageBox).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.countImageSpinner).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.publishLinksLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.publishLinksField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.countVideoBox).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.countVideoSpinner).xy(7, defaultFormBuilder.row());
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder((Border)Paddings.DIALOG);
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(this.tabbedPane, "Center");
        this.updateLocalization();
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("media"));
    }

    private boolean isFileAttachmentDisabled() {
        return PublishingMode.NEVER.equals(this.publishFilesField.getSelectedItem());
    }

    public boolean isTabModified() {
        return false;
    }

    public boolean isTabValid() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport) {
        AbstractFormat abstractFormat = dbAgencyExport.getFormat();
        this.publishFilesField.setSelectedItem((Object)(abstractFormat != null ? abstractFormat.getPropertyFilePublication() : PublishingMode.DEFAULT));
        this.publishLinksField.setSelectedItem((Object)(abstractFormat != null ? abstractFormat.getPropertyLinkPublication() : PublishingMode.DEFAULT));
        int n = abstractFormat != null ? abstractFormat.getPropertyImageLimit() : -1;
        this.countImageBox.setSelected(n > -1);
        this.countImageSpinner.setEnabled(this.countImageBox.isSelected());
        this.countImageSpinner.setValue(n > -1 ? n : 0);
        int n2 = abstractFormat != null ? abstractFormat.getPropertyVideoLimit() : -1;
        this.countVideoBox.setSelected(n2 > -1);
        this.countVideoSpinner.setEnabled(this.countVideoBox.isSelected());
        this.countVideoSpinner.setValue(n2 > -1 ? n2 : 0);
        this.attachmentImageTab.load(abstractFormat);
        this.attachmentTypeTab.load(abstractFormat);
        this.updateFormat(abstractFormat);
        if (dbAgencyExport.id < 1L) {
            this.validationHandler.init();
        } else {
            this.validationHandler.validate();
        }
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport) {
        AbstractFormat abstractFormat = dbAgencyExport.getFormat();
        abstractFormat.setPropertyFilePublication((PublishingMode)((Object)this.publishFilesField.getSelectedItem()));
        abstractFormat.setPropertyLinkPublication((PublishingMode)((Object)this.publishLinksField.getSelectedItem()));
        Number number = (Number)this.countImageSpinner.getValue();
        abstractFormat.setPropertyImageLimit(this.countImageBox.isSelected() && number != null ? number.intValue() : -1);
        Number number2 = (Number)this.countVideoSpinner.getValue();
        abstractFormat.setPropertyVideoLimit(this.countVideoBox.isSelected() && number2 != null ? number2.intValue() : -1);
        this.attachmentImageTab.save(abstractFormat);
        this.attachmentTypeTab.save(abstractFormat);
        dbAgencyExport.setFormat(abstractFormat);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        boolean bl2 = this.isFileAttachmentDisabled();
        this.publishFilesLabel.setEnabled(bl);
        this.publishFilesField.setEnabled(bl);
        this.publishLinksLabel.setEnabled(bl);
        this.publishLinksField.setEnabled(bl);
        this.countImageBox.setEnabled(bl && !bl2);
        this.countImageSpinner.setEnabled(bl && !bl2 && this.countImageBox.isSelected());
        this.countVideoBox.setEnabled(bl && !bl2);
        this.countVideoSpinner.setEnabled(bl && !bl2 && this.countVideoBox.isSelected());
        this.attachmentImageTab.setEnabled(bl);
        this.attachmentTypeTab.setEnabled(bl);
    }

    @Override
    protected void updateFormat(AbstractFormat abstractFormat) {
        super.updateFormat(abstractFormat);
        this.formatWasLoaded = abstractFormat != null;
        this.setEnabled(this.formatWasLoaded);
        int n = abstractFormat != null ? abstractFormat.getPropertyImageLimit() : 0;
        this.countImageBox.setSelected(n > 0);
        this.countImageSpinner.setValue(n > 0 ? n : 0);
        this.countImageSpinner.setEnabled(this.countImageBox.isSelected());
        int n2 = abstractFormat != null ? abstractFormat.getPropertyVideoLimit() : 0;
        this.countVideoBox.setSelected(n2 > 0);
        this.countVideoSpinner.setValue(n2 > 0 ? n2 : 0);
        this.countVideoSpinner.setEnabled(this.countVideoBox.isSelected());
        this.attachmentImageTab.update(abstractFormat);
        this.attachmentTypeTab.update(abstractFormat);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.title.setTitle(StringUtils.capitalize((String)I18N.tr("settings for attachments")));
        this.publishFilesLabel.setText(StringUtils.capitalize((String)I18N.tr("attached files")) + ":");
        this.publishFilesField.setToolTipText(I18N.tr("Please select, if property attachments should be sent to the recipient."));
        this.publishLinksLabel.setText(StringUtils.capitalize((String)I18N.tr("attached web-links")) + ":");
        this.publishLinksField.setToolTipText(I18N.tr("Please select, if property links should be sent to the recipient."));
        this.countImageBox.setText(I18N.tr("max. images") + ":");
        this.countImageBox.setToolTipText(I18N.tr("Limit the number of exported images per property."));
        this.countImageSpinner.setToolTipText(I18N.tr("Enter the number of maximal exported images per property."));
        this.countVideoBox.setText(I18N.tr("max. videos") + ":");
        this.countVideoBox.setToolTipText(I18N.tr("Limit the number of exported videos per property."));
        this.countVideoSpinner.setToolTipText(I18N.tr("Enter the number of maximal exported videos per property."));
    }

    private static class SelectAllTypesAction
    extends AbstractI18nAction {
        private final AttachmentTypeTab tab;

        private SelectAllTypesAction(AttachmentTypeTab attachmentTypeTab) {
            this.tab = attachmentTypeTab;
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tab.doSelectAllTypes();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("enable all")));
            this.setShortDescription(I18N.tr("Enable or disable all file types for the interface."));
        }
    }

    private static class AttachmentTypeTableRow
    extends AbstractTable.Row {
        private final String mimeType;
        private boolean enabled;

        private AttachmentTypeTableRow(String string, boolean bl) {
            this.mimeType = string;
            this.enabled = bl;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof AttachmentTypeTableColumn) {
                return this.getValueForType((AttachmentTypeTableColumn)column);
            }
            return null;
        }

        private Object getValueForType(AttachmentTypeTableColumn attachmentTypeTableColumn) {
            switch (attachmentTypeTableColumn) {
                case ENABLED: {
                    return this.enabled;
                }
                case MIME_TYPE: {
                    return StringUtils.trimToEmpty((String)this.mimeType);
                }
            }
            return null;
        }

        public boolean isEditable(AbstractTable.Column column) {
            return super.isEditable(column) && AttachmentTypeTableColumn.ENABLED.equals(column);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setValueAt(Object object, AbstractTable.Column column) {
            if (AttachmentTypeTableColumn.ENABLED.equals(column)) {
                this.enabled = Boolean.TRUE.equals(object);
            }
        }
    }

    private static enum AttachmentTypeTableColumn implements AbstractTable.Column
    {
        ENABLED,
        MIME_TYPE;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                default: 
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ENABLED: {
                    return Boolean.class;
                }
                case MIME_TYPE: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ENABLED: {
                    return I18N.tr("active");
                }
                case MIME_TYPE: {
                    return StringUtils.capitalize((String)I18N.tr("file type"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                case ENABLED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private static class AttachmentTypeTable
    extends AbstractTable<AttachmentTypeTableRow, AbstractTable.Model<AttachmentTypeTableRow>> {
        private AttachmentTypeTable() {
            super(AgencyExportViewMediaPanel.ATTACHMENT_TYPE_TABLE_ID);
        }

        private String getMimeTypeAt(int n) {
            AttachmentTypeTableRow attachmentTypeTableRow = (AttachmentTypeTableRow)this.getRow(n);
            return attachmentTypeTableRow != null ? attachmentTypeTableRow.getMimeType() : null;
        }

        protected void init() {
            this.setSortable(true);
            this.setColumnControlVisible(false);
            super.init();
            this.getColumn(AttachmentTypeTableColumn.ENABLED).setMaxWidth(75);
        }

        private boolean isEnabledAt(int n) {
            AttachmentTypeTableRow attachmentTypeTableRow = (AttachmentTypeTableRow)this.getRow(n);
            return attachmentTypeTableRow != null && attachmentTypeTableRow.isEnabled();
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(AttachmentTypeTableColumn.values()));
        }

        public void setEnabledAt(int n, boolean bl) {
            AttachmentTypeTableRow attachmentTypeTableRow = (AttachmentTypeTableRow)this.getRow(n);
            if (attachmentTypeTableRow != null) {
                attachmentTypeTableRow.setEnabled(bl);
            }
        }
    }

    private class AttachmentTypeTab
    extends AbstractTab {
        private JXTitledSeparator title;
        private AttachmentTypeTable table;
        private JToggleButton selectAllButton;

        private AttachmentTypeTab() {
            this.build();
        }

        private void build() {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.table = new AttachmentTypeTable();
            this.selectAllButton = new JToggleButton((Action)((Object)new SelectAllTypesAction(this)));
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (JComponent[])new JComponent[]{this.selectAllButton});
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.table.createScrollPane(), "Center");
            this.updateLocalization();
        }

        private void doSelectAllTypes() {
            boolean bl = this.selectAllButton.isSelected();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.setEnabledAt(i, bl);
            }
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("file types"));
        }

        public String getTabToolTipText() {
            return I18N.tr("Select the attachment file types, that are allowed to export through this interface.");
        }

        public void load(AbstractFormat abstractFormat) {
            Object[] objectArray;
            this.table.clearRows();
            this.selectAllButton.setSelected(false);
            if (abstractFormat == null) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = abstractFormat.getAttachmentMimeTypes();
            if (stringArray != null) {
                arrayList.addAll(Arrays.asList(stringArray));
            }
            if (!ArrayUtils.isEmpty((Object[])(objectArray = abstractFormat.getSupportedMimeTypes()))) {
                TreeSet<Object> treeSet = new TreeSet<Object>(Arrays.asList(objectArray));
                for (String string : treeSet) {
                    this.table.addRow(new AttachmentTypeTableRow(string, arrayList.contains(string)));
                }
            }
        }

        public void save(AbstractFormat abstractFormat) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!this.table.isEnabledAt(i)) continue;
                arrayList.add(this.table.getMimeTypeAt(i));
            }
            abstractFormat.setAttachmentMimeTypes(!arrayList.isEmpty() ? arrayList.toArray(new String[0]) : null);
        }

        public void setEnabled(boolean bl) {
            bl = bl && !AgencyExportViewMediaPanel.this.isFileAttachmentDisabled();
            super.setEnabled(bl);
            this.title.setEnabled(bl);
            this.table.setEnabled(bl);
            int n = AgencyExportViewMediaPanel.this.tabbedPane.indexOfComponent((Component)((Object)this));
            if (n > -1) {
                AgencyExportViewMediaPanel.this.tabbedPane.setEnabledAt(n, bl);
            }
        }

        public void update(AbstractFormat abstractFormat) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < this.table.getRowCount(); ++n) {
                if (!this.table.isEnabledAt(n)) continue;
                arrayList.add(this.table.getMimeTypeAt(n));
            }
            this.load(abstractFormat);
            for (n = 0; n < this.table.getRowCount(); ++n) {
                String string = this.table.getMimeTypeAt(n);
                boolean bl = arrayList.contains(string) || this.table.isEnabledAt(n);
                this.table.setEnabledAt(n, bl);
            }
            this.setEnabled(abstractFormat != null);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("exportable file types")));
        }
    }

    private class AttachmentImageTab
    extends AbstractTab {
        private JXTitledSeparator title;
        private JLabel exportScaledImagesLabel;
        private JCheckBox exportScaledImagesBox;
        private JLabel exportScaledImageWidthLabel;
        private JTextField exportScaledImageWidthField;
        private JLabel exportScaledImageHeightLabel;
        private JTextField exportScaledImageHeightField;
        private JLabel exportWatermarkImagesLabel;
        private JCheckBox exportWatermarkImagesBox;
        private JLabel exportWatermarkImageWidthLabel;
        private JTextField exportWatermarkImageWidthField;
        private JLabel exportWatermarkImageHeightLabel;
        private JTextField exportWatermarkImageHeightField;
        private JLabel exportWatermarkImageMarginLabel;
        private JTextField exportWatermarkImageMarginField;
        private JLabel exportWatermarkAlphaLabel;
        private JSlider exportWatermarkAlphaSlider;
        private JLabel exportWatermarkPositionLabel;
        private JComboBox<AbstractFormat.ImageWatermarkPosition> exportWatermarkPositionBox;

        private AttachmentImageTab() {
            this.build();
        }

        private void build() {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.exportScaledImagesLabel = new JLabel();
            this.exportScaledImagesBox = new JCheckBox();
            this.exportScaledImagesBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AttachmentImageTab.this.setEnabled(AttachmentImageTab.this.isEnabled());
                }
            });
            this.exportScaledImageWidthLabel = new JLabel();
            this.exportScaledImageWidthField = new JTextField();
            this.exportScaledImageHeightLabel = new JLabel();
            this.exportScaledImageHeightField = new JTextField();
            this.exportWatermarkImagesLabel = new JLabel();
            this.exportWatermarkImagesBox = new JCheckBox();
            this.exportWatermarkImagesBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AttachmentImageTab.this.setEnabled(AttachmentImageTab.this.isEnabled());
                }
            });
            this.exportWatermarkImageWidthLabel = new JLabel();
            this.exportWatermarkImageWidthField = new JTextField();
            this.exportWatermarkImageHeightLabel = new JLabel();
            this.exportWatermarkImageHeightField = new JTextField();
            this.exportWatermarkImageMarginLabel = new JLabel();
            this.exportWatermarkImageMarginField = new JTextField();
            this.exportWatermarkAlphaLabel = new JLabel();
            this.exportWatermarkAlphaSlider = new JSlider(0, 0, 100, 100);
            this.exportWatermarkAlphaSlider.setMajorTickSpacing(20);
            this.exportWatermarkAlphaSlider.setMinorTickSpacing(10);
            this.exportWatermarkAlphaSlider.setPaintTicks(true);
            this.exportWatermarkAlphaSlider.setPaintLabels(true);
            this.exportWatermarkPositionLabel = new JLabel();
            this.exportWatermarkPositionBox = new JComboBox();
            this.exportWatermarkPositionBox.setRenderer((ListCellRenderer<AbstractFormat.ImageWatermarkPosition>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<AbstractFormat.ImageWatermarkPosition>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("select position") + " ]";
                }
            }));
            this.exportWatermarkPositionBox.addItem(null);
            for (AbstractFormat.ImageWatermarkPosition imageWatermarkPosition : AbstractFormat.ImageWatermarkPosition.values()) {
                this.exportWatermarkPositionBox.addItem(imageWatermarkPosition);
            }
            ValidationRule validationRule = new ValidationRule(){

                public boolean isValid(Object object) {
                    String string;
                    String string2 = string = object != null ? object.toString() : "";
                    if (StringUtils.isEmpty((CharSequence)string)) {
                        return false;
                    }
                    try {
                        Integer n = Integer.valueOf(string);
                        return n > 0;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
            ValidationRule validationRule2 = new ValidationRule(){

                public boolean isValid(Object object) {
                    String string;
                    String string2 = string = object != null ? object.toString() : "";
                    if (StringUtils.isEmpty((CharSequence)string)) {
                        return false;
                    }
                    try {
                        Integer n = Integer.valueOf(string);
                        return n >= 0;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
            AgencyExportViewMediaPanel.this.validationHandler.putRule((JComponent)this.exportScaledImageWidthField, validationRule);
            AgencyExportViewMediaPanel.this.validationHandler.putRule((JComponent)this.exportScaledImageHeightField, validationRule);
            AgencyExportViewMediaPanel.this.validationHandler.putRule((JComponent)this.exportWatermarkImageWidthField, validationRule);
            AgencyExportViewMediaPanel.this.validationHandler.putRule((JComponent)this.exportWatermarkImageHeightField, validationRule);
            AgencyExportViewMediaPanel.this.validationHandler.putRule((JComponent)this.exportWatermarkImageMarginField, validationRule2);
            AgencyExportViewMediaPanel.this.validationHandler.putRule(this.exportWatermarkPositionBox, (ValidationRule)new NonEmptyComboBoxRule(this.exportWatermarkPositionBox));
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow");
            defaultFormBuilder.add((Component)this.exportScaledImagesLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.exportScaledImagesBox).xyw(3, defaultFormBuilder.row(), 7);
            defaultFormBuilder.add((Component)this.exportScaledImageWidthLabel).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.exportScaledImageWidthField).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.exportScaledImageHeightLabel).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.exportScaledImageHeightField).xy(9, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.exportWatermarkImagesLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.exportWatermarkImagesBox).xyw(3, defaultFormBuilder.row(), 7);
            defaultFormBuilder.add((Component)this.exportWatermarkImageWidthLabel).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.exportWatermarkImageWidthField).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.exportWatermarkImageHeightLabel).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.exportWatermarkImageHeightField).xy(9, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.exportWatermarkImageMarginLabel).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.exportWatermarkImageMarginField).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.exportWatermarkPositionLabel).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add(this.exportWatermarkPositionBox).xy(9, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.exportWatermarkAlphaLabel).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.exportWatermarkAlphaSlider).xyw(5, defaultFormBuilder.row(), 5);
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)this.title, "North");
            jPanel.add((Component)defaultFormBuilder.getPanel(), "Center");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("images"));
        }

        public String getTabToolTipText() {
            return I18N.tr("Select your preferred settings for exported images.");
        }

        public void load(AbstractFormat abstractFormat) {
            boolean bl = abstractFormat != null && abstractFormat.isAttachmentImageScale();
            this.exportScaledImagesBox.setSelected(bl);
            this.exportScaledImageHeightField.setEnabled(bl);
            this.exportScaledImageHeightField.setText(bl ? String.valueOf(abstractFormat.getAttachmentImageScaleHeight()) : "");
            this.exportScaledImageWidthField.setEnabled(bl);
            this.exportScaledImageWidthField.setText(bl ? String.valueOf(abstractFormat.getAttachmentImageScaleWidth()) : "");
            boolean bl2 = abstractFormat != null && abstractFormat.isPropertyImageWatermark();
            this.exportWatermarkImagesBox.setSelected(bl2);
            this.exportWatermarkImageHeightField.setEnabled(bl2);
            this.exportWatermarkImageHeightField.setText(bl2 ? String.valueOf(abstractFormat.getPropertyImageWatermarkHeight()) : "");
            this.exportWatermarkImageWidthField.setEnabled(bl2);
            this.exportWatermarkImageWidthField.setText(bl2 ? String.valueOf(abstractFormat.getPropertyImageWatermarkWidth()) : "");
            this.exportWatermarkImageMarginField.setEnabled(bl2);
            this.exportWatermarkImageMarginField.setText(bl2 ? String.valueOf(abstractFormat.getPropertyImageWatermarkMargin()) : "");
            if (bl2) {
                this.exportWatermarkAlphaSlider.setEnabled(true);
                this.exportWatermarkAlphaSlider.setValue(abstractFormat.getPropertyImageWatermarkAlpha() > -1 ? abstractFormat.getPropertyImageWatermarkAlpha() : 100);
                this.exportWatermarkPositionBox.setEnabled(true);
                this.exportWatermarkPositionBox.setSelectedItem((Object)abstractFormat.getPropertyImageWatermarkPosition());
            } else {
                this.exportWatermarkAlphaSlider.setEnabled(false);
                this.exportWatermarkAlphaSlider.setValue(100);
                this.exportWatermarkPositionBox.setEnabled(false);
                this.exportWatermarkPositionBox.setSelectedIndex(0);
            }
        }

        public void save(AbstractFormat abstractFormat) {
            boolean bl = this.exportScaledImagesBox.isSelected();
            abstractFormat.setAttachmentImageScale(bl);
            abstractFormat.setAttachmentImageScaleHeight(bl ? Integer.parseInt(this.exportScaledImageHeightField.getText()) : 0);
            abstractFormat.setAttachmentImageScaleWidth(bl ? Integer.parseInt(this.exportScaledImageWidthField.getText()) : 0);
            boolean bl2 = this.exportWatermarkImagesBox.isSelected();
            abstractFormat.setPropertyImageWatermark(bl2);
            abstractFormat.setPropertyImageWatermarkHeight(bl2 ? Integer.parseInt(this.exportWatermarkImageHeightField.getText()) : 0);
            abstractFormat.setPropertyImageWatermarkWidth(bl2 ? Integer.parseInt(this.exportWatermarkImageWidthField.getText()) : 0);
            abstractFormat.setPropertyImageWatermarkMargin(bl2 ? Integer.parseInt(this.exportWatermarkImageMarginField.getText()) : 0);
            abstractFormat.setPropertyImageWatermarkAlpha(bl2 ? this.exportWatermarkAlphaSlider.getValue() : 0);
            abstractFormat.setPropertyImageWatermarkPosition((AbstractFormat.ImageWatermarkPosition)((Object)(bl2 ? this.exportWatermarkPositionBox.getSelectedItem() : null)));
        }

        public void setEnabled(boolean bl) {
            bl = bl && !AgencyExportViewMediaPanel.this.isFileAttachmentDisabled();
            super.setEnabled(bl);
            boolean bl2 = bl && this.exportScaledImagesBox.isSelected();
            boolean bl3 = bl && this.exportWatermarkImagesBox.isSelected();
            this.title.setEnabled(bl);
            this.exportScaledImagesLabel.setEnabled(bl);
            this.exportScaledImagesBox.setEnabled(bl);
            this.exportScaledImageWidthLabel.setEnabled(bl2);
            this.exportScaledImageWidthField.setEnabled(bl2);
            this.exportScaledImageHeightLabel.setEnabled(bl2);
            this.exportScaledImageHeightField.setEnabled(bl2);
            this.exportWatermarkImagesLabel.setEnabled(bl);
            this.exportWatermarkImagesBox.setEnabled(bl);
            this.exportWatermarkImageWidthLabel.setEnabled(bl3);
            this.exportWatermarkImageWidthField.setEnabled(bl3);
            this.exportWatermarkImageHeightLabel.setEnabled(bl3);
            this.exportWatermarkImageHeightField.setEnabled(bl3);
            this.exportWatermarkImageMarginLabel.setEnabled(bl3);
            this.exportWatermarkImageMarginField.setEnabled(bl3);
            this.exportWatermarkAlphaLabel.setEnabled(bl3);
            this.exportWatermarkAlphaSlider.setEnabled(bl3);
            this.exportWatermarkPositionLabel.setEnabled(bl3);
            this.exportWatermarkPositionBox.setEnabled(bl3);
            int n = AgencyExportViewMediaPanel.this.tabbedPane.indexOfComponent((Component)((Object)this));
            if (n > -1) {
                AgencyExportViewMediaPanel.this.tabbedPane.setEnabledAt(n, bl);
            }
        }

        public void update(AbstractFormat abstractFormat) {
            this.setEnabled(abstractFormat != null);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("settings for exported images")));
            this.exportScaledImagesLabel.setText(StringUtils.capitalize((String)I18N.tr("scaling")) + ":");
            this.exportScaledImagesBox.setText(I18N.tr("Scale exported images."));
            this.exportScaledImagesBox.setToolTipText(I18N.tr("Enable this option to scale exported images to a maximal size."));
            this.exportScaledImageHeightLabel.setText(I18N.tr("max. height") + ":");
            this.exportScaledImageHeightField.setToolTipText(I18N.tr("Exported images are scaled to the maximal height (in px)."));
            this.exportScaledImageWidthLabel.setText(I18N.tr("max. width") + ":");
            this.exportScaledImageWidthField.setToolTipText(I18N.tr("Exported images are scaled to the maximal width (in px)."));
            this.exportWatermarkImagesLabel.setText(StringUtils.capitalize((String)I18N.tr("watermark")) + ":");
            this.exportWatermarkImagesBox.setText(I18N.tr("Paint watermark into images."));
            this.exportWatermarkImagesBox.setToolTipText(I18N.tr("Enable this option to paint the company logo as watermark into the exported images."));
            this.exportWatermarkImageWidthLabel.setText(StringUtils.capitalize((String)I18N.tr("width")) + ":");
            this.exportWatermarkImageWidthField.setToolTipText(I18N.tr("Enter the width of the generated watermark (in px)."));
            this.exportWatermarkImageHeightLabel.setText(StringUtils.capitalize((String)I18N.tr("height")) + ":");
            this.exportWatermarkImageHeightField.setToolTipText(I18N.tr("Enter the height of the generated watermark (in px)."));
            this.exportWatermarkImageMarginLabel.setText(StringUtils.capitalize((String)I18N.tr("margin")) + ":");
            this.exportWatermarkImageMarginField.setToolTipText(I18N.tr("Enter the space around the generated watermark (in px)."));
            this.exportWatermarkAlphaLabel.setText(StringUtils.capitalize((String)I18N.tr("visibility")) + ":");
            this.exportWatermarkAlphaSlider.setToolTipText(I18N.tr("Set the visibility of the watermark within the exported images (in %)."));
            this.exportWatermarkPositionLabel.setText(StringUtils.capitalize((String)I18N.tr("position")) + ":");
            this.exportWatermarkPositionBox.setToolTipText(I18N.tr("Set the position of the watermark within the exported images."));
        }
    }
}

