/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportHandler;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.FrameSidebarAdapter;
import com.openindex.openestate.tool.extensions.FrameSidebarAddonExtension;
import com.openindex.openestate.tool.utils.SidebarTree;
import com.openindex.openestate.tool.utils.SidebarTreeCellRenderer;
import com.openindex.openestate.tool.utils.SidebarTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyFrameSidebarExtension
extends FrameSidebarAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyFrameSidebarExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_REFRESH = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_ESTATE = 4;
    public static final int MENU_ADD_SEARCH = 5;
    public static final int MENU_ADD_CONTACT = 6;
    public static final int MENU_ADD_EXPORT = 7;
    public static final int MENU_ADD_END = 8;
    public static final int MENU_SELECTION = 9;
    public static final int MENU_ELSE = 10;
    public static final int MENU_ELSE_BEGIN = 11;
    public static final int MENU_ELSE_PROPERTY_LOAD = 12;
    public static final int MENU_ELSE_PROPERTY_SAVE = 13;
    public static final int MENU_ELSE_EXPORT_CANCEL = 14;
    public static final int MENU_ELSE_EXPORT_LOAD = 15;
    public static final int MENU_ELSE_END = 16;
    public static final int MENU_END = 17;
    private static AbstractButton currentSidebarButton = null;
    private static Tree currentSidebarTree = null;
    private static ExportJobListener jobListener = null;
    private static JXBusyLabel jobBusyLabel = null;

    private static JPopupMenu createActionMenu(TreeNode treeNode) {
        JMenu jMenu;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbAgencySearch dbAgencySearch = treeNode != null ? treeNode.getSearch() : null;
        DbAgencyExport dbAgencyExport = treeNode != null ? treeNode.getExportInterface() : null;
        Collection collection = AgencyFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, AgencyFrameSidebarExtension.class);
        JPopupMenu jPopupMenu = new JPopupMenu();
        AgencyFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)0, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.SidebarRefreshAction())));
        AgencyFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)1, (SidebarTreeNode)treeNode, (Collection)collection);
        JMenu jMenu2 = new JMenu();
        jMenu2.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
        jMenu2.setToolTipText(I18N.tr("Create a new entry in the agency addon."));
        jMenu2.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu2, (int)3, (SidebarTreeNode)treeNode, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT)) {
            jMenu2.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateFormAction())));
        }
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu2, (int)4, (SidebarTreeNode)treeNode, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
            jMenu2.add(new JMenuItem((Action)((Object)new AgencyPlugin.SearchDialogAction())));
        }
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu2, (int)5, (SidebarTreeNode)treeNode, (Collection)collection);
        if (jMenu2.getMenuComponentCount() > 0) {
            jMenu2.addSeparator();
        }
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT)) {
            jMenu2.add(new JMenuItem((Action)((Object)new AgencyPlugin.ContactFormAction())));
        }
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu2, (int)6, (SidebarTreeNode)treeNode, (Collection)collection);
        if (jMenu2.getMenuComponentCount() > 0) {
            jMenu2.addSeparator();
        }
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT)) {
            jMenu2.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportFormAction())));
        }
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu2, (int)7, (SidebarTreeNode)treeNode, (Collection)collection);
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu2, (int)8, (SidebarTreeNode)treeNode, (Collection)collection);
        if (jMenu2.getItemCount() > 0) {
            jPopupMenu.add(jMenu2);
        }
        AgencyFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)2, (SidebarTreeNode)treeNode, (Collection)collection);
        if (treeNode != null) {
            if (treeNode.getType() == 31) {
                jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.capitalize((String)I18N.tr("contact persons"))));
                if (AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS)) {
                    jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ContactTableAction(true))));
                }
            } else if (treeNode.getType() == 10 || treeNode.getType() == 11) {
                jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)AgencyPlugin.getInstance().getTitle()));
                if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
                    jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateTableAction(dbAgencySearch != null ? dbAgencySearch.id : 0L, true))));
                    if (treeNode.getType() == 11 && dbAgencySearch != null) {
                        jMenu = immoToolProject != null ? immoToolProject.getUser() : null;
                        boolean bl = dbAgencySearch.permission.canWrite((DbUser)jMenu, dbAgencySearch.ownerUserId, dbAgencySearch.ownerGroupId);
                        boolean bl2 = dbAgencySearch.permission.canDelete((DbUser)jMenu, dbAgencySearch.ownerUserId, dbAgencySearch.ownerGroupId);
                        if (bl) {
                            jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.SearchDialogAction(dbAgencySearch.id))));
                        }
                        if (bl2) {
                            jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.SearchRemoveAction(dbAgencySearch.id))));
                        }
                    }
                }
            } else if (treeNode.getType() == 20 || treeNode.getType() == 21) {
                jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.capitalize((String)I18N.tr("export interfaces"))));
                if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS)) {
                    jPopupMenu.add((Action)((Object)new AgencyPlugin.ExportTableAction(true)));
                }
                if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE)) {
                    jPopupMenu.add((Action)((Object)new AgencyPlugin.ExportAction()));
                }
                if (dbAgencyExport != null) {
                    jMenu = immoToolProject != null ? immoToolProject.getUser() : null;
                    boolean bl = AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT) && dbAgencyExport.permission.canWrite((DbUser)jMenu, dbAgencyExport.ownerUserId, dbAgencyExport.ownerGroupId);
                    boolean bl3 = AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_REMOVE) && dbAgencyExport.permission.canDelete((DbUser)jMenu, dbAgencyExport.ownerUserId, dbAgencyExport.ownerGroupId);
                    boolean bl4 = AgencyExportHandler.isJobRunning(dbAgencyExport.id);
                    boolean bl5 = AgencyExportHandler.isJobError(dbAgencyExport.id);
                    boolean bl6 = AgencyExportHandler.isJobTransportFailed(dbAgencyExport.id);
                    jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)dbAgencyExport.name), (int)35)));
                    if (bl) {
                        jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportFormAction(dbAgencyExport.id))));
                    }
                    jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportObjectsAction(dbAgencyExport.id))));
                    if (dbAgencyExport.lastExecution != null) {
                        jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportViewLogAction(dbAgencyExport.id))));
                    }
                    if (!bl4) {
                        jPopupMenu.add((Action)((Object)new AgencyPlugin.ExportAction(dbAgencyExport.id)));
                    }
                    if (bl4) {
                        jPopupMenu.add((Action)((Object)new AgencyPlugin.ExportJobCancelAction(dbAgencyExport.id, true)));
                    }
                    if (bl6) {
                        jPopupMenu.add((Action)((Object)new AgencyPlugin.ExportJobRestartAction(dbAgencyExport.id)));
                    }
                    if (bl5) {
                        jPopupMenu.add((Action)((Object)new AgencyPlugin.ExportJobErrorAction(dbAgencyExport.id)));
                    }
                    if (bl) {
                        jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportSaveAction(dbAgencyExport.id))));
                    }
                    if (bl3 && !bl4) {
                        jPopupMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportRemoveAction(dbAgencyExport.id))));
                    }
                }
            }
        }
        AgencyFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)9, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)"", (int)5));
        jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")));
        jMenu.setToolTipText(I18N.tr("Further actions in the agency addon."));
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu, (int)11, (SidebarTreeNode)treeNode, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_IMPORT)) {
            jMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateImportAction())));
        }
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu, (int)12, (SidebarTreeNode)treeNode, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
            jMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.EstateSaveAction())));
        }
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu, (int)13, (SidebarTreeNode)treeNode, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS)) {
            jMenu.addSeparator();
        }
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EXECUTE)) {
            jMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportCancelAction())));
        }
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu, (int)14, (SidebarTreeNode)treeNode, (Collection)collection);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS_EDIT)) {
            jMenu.add(new JMenuItem((Action)((Object)new AgencyPlugin.ExportLoadAction())));
        }
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu, (int)15, (SidebarTreeNode)treeNode, (Collection)collection);
        AgencyFrameSidebarExtension.loadMenu((JMenu)jMenu, (int)16, (SidebarTreeNode)treeNode, (Collection)collection);
        if (jMenu.getItemCount() > 0) {
            jPopupMenu.add(jMenu);
        }
        AgencyFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)10, (SidebarTreeNode)treeNode, (Collection)collection);
        AgencyFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)17, (SidebarTreeNode)treeNode, (Collection)collection);
        return jPopupMenu;
    }

    public JComponent createComponent() {
        Tree tree = new Tree();
        tree.installDefaultListeners(true, true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)new SidebarTreeCellRenderer());
        tree.setModel(new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)new TreeNode(0))));
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeModel createTreeModel() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
        DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
        Connection connection = null;
        try {
            connection = ImmoToolProject.getAppDbConnection();
            TreeModel treeModel = AgencyFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbAgencyExportsHandler, dbAgencySearchesHandler);
            return treeModel;
        }
        catch (Exception exception) {
            LOGGER.error("Can't load agency tree!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            TreeModel treeModel = null;
            return treeModel;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static TreeModel createTreeModel(ImmoToolProject immoToolProject, Connection connection, DbAgencyExportsHandler dbAgencyExportsHandler, DbAgencySearchesHandler dbAgencySearchesHandler) throws SQLException {
        Object object;
        TreeNode treeNode;
        TreeNode treeNode2 = new TreeNode(0);
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
            treeNode = new TreeNode(10);
            treeNode2.add((MutableTreeNode)((Object)treeNode));
            for (DbSearch dbSearch : dbAgencySearchesHandler.getSearches(connection, (Boolean)true, DbAgencySearch.Type.SIDEBAR)) {
                TreeNode object2 = new TreeNode((DbAgencySearch)dbSearch);
                treeNode.add((MutableTreeNode)((Object)object2));
            }
        }
        treeNode = new TreeNode(30);
        treeNode2.add((MutableTreeNode)((Object)treeNode));
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS)) {
            object = new TreeNode(31);
            treeNode.add((MutableTreeNode)object);
        }
        if (AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS)) {
            object = new TreeNode(20);
            treeNode2.add((MutableTreeNode)object);
            for (DbAgencyExport dbAgencyExport : dbAgencyExportsHandler.getExports(connection, true)) {
                TreeNode treeNode3 = new TreeNode(dbAgencyExport);
                object.add((MutableTreeNode)((Object)treeNode3));
            }
        }
        for (FrameSidebarAddonExtension frameSidebarAddonExtension : AgencyFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, AgencyFrameSidebarExtension.class)) {
            frameSidebarAddonExtension.initTree(connection, (SidebarTreeNode)treeNode2);
        }
        return new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)treeNode2));
    }

    public static AbstractButton getCurrentSidebarButton() {
        return currentSidebarButton;
    }

    public static Tree getCurrentSidebarTree() {
        return currentSidebarTree;
    }

    public Icon getIcon() {
        return AgencyPlugin.getResourceIcon("agent_estates.png", 32);
    }

    public JPopupMenu getMenu() {
        return AgencyFrameSidebarExtension.createActionMenu(null);
    }

    public String getTitle() {
        return AgencyPlugin.getInstance().getTitle();
    }

    public String getTooltipText() {
        return StringUtils.capitalize((String)I18N.tr("management of properties"));
    }

    public void loadComponent(final JComponent jComponent) {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<TreeModel, Void>(){

            protected TreeModel doInBackground() {
                return AgencyFrameSidebarExtension.this.createTreeModel();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.error("Can't load sidebar component!");
                LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
            }

            protected void succeeded(TreeModel treeModel) {
                super.succeeded((Object)treeModel);
                ((Tree)((Object)jComponent)).setModel(treeModel);
                ((Tree)((Object)jComponent)).expandAll();
            }
        });
    }

    public void register(JComponent jComponent, AbstractButton abstractButton) {
        if (jComponent instanceof Tree) {
            AgencyFrameSidebarExtension.setCurrentSidebar((Tree)((Object)jComponent), abstractButton);
        } else {
            LOGGER.warn("An invalid agency-tree was registered!");
            AgencyFrameSidebarExtension.setCurrentSidebar(null, null);
        }
        AgencyFrameSidebarExtension.setJobListener(new ExportJobListener());
    }

    private static synchronized void setCurrentSidebar(Tree tree, AbstractButton abstractButton) {
        currentSidebarTree = tree;
        currentSidebarButton = abstractButton;
    }

    private static synchronized void setJobListener(ExportJobListener exportJobListener) {
        if (jobListener != null) {
            AgencyExportHandler.removeJobListener(jobListener);
        }
        if (jobBusyLabel != null) {
            jobBusyLabel.setBusy(false);
        }
        if (exportJobListener == null) {
            jobListener = null;
            jobBusyLabel = null;
        } else {
            jobListener = exportJobListener;
            AgencyExportHandler.addJobListener(jobListener);
            jobBusyLabel = new JXBusyLabel(new Dimension(16, 16)){

                protected void frameChanged() {
                    super.frameChanged();
                    if (!this.isBusy()) {
                        return;
                    }
                    if (currentSidebarTree == null) {
                        return;
                    }
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)currentSidebarTree.getModel();
                    TreeNode treeNode = currentSidebarTree.getExportsNode();
                    for (int i = 0; i < treeNode.getChildCount(); ++i) {
                        TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                        long l = treeNode2.getExportInterface().id;
                        if (!AgencyExportHandler.isJobRunning(l)) continue;
                        defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode2));
                    }
                }
            };
        }
    }

    public void unregister() {
        AgencyFrameSidebarExtension.setCurrentSidebar(null, null);
        AgencyFrameSidebarExtension.setJobListener(null);
    }

    private static synchronized void updateBusyAnimation() {
        boolean bl = false;
        TreeNode treeNode = currentSidebarTree.getExportsNode();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
            long l = treeNode2.getExportInterface().id;
            if (!AgencyExportHandler.isJobRunning(l)) continue;
            bl = true;
            break;
        }
        jobBusyLabel.setBusy(bl);
    }

    private static class ExportJobListener
    implements AgencyExportHandler.JobListener {
        private ExportJobListener() {
        }

        @Override
        public void jobAdded(AgencyExportHandler.Job job) {
            this.updateTreeNode(job.getExportId());
        }

        @Override
        public void jobRemoved(long l) {
            this.updateTreeNode(l);
        }

        @Override
        public void jobStateChanged(AgencyExportHandler.Job job) {
            AgencyFrameSidebarExtension.updateBusyAnimation();
            this.updateTreeNode(job.getExportId());
        }

        @Override
        public void taskMessageChanged(long l, String string) {
        }

        @Override
        public void taskProgressChanged(long l, int n) {
        }

        private void updateTreeNode(long l) {
            if (currentSidebarTree == null) {
                return;
            }
            TreeNode treeNode = currentSidebarTree.getExportNode(l);
            if (treeNode == null) {
                return;
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)currentSidebarTree.getModel();
            defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode));
        }
    }

    public static class TreeNode
    extends SidebarTreeNode {
        private static final int TYPE_ROOT = 0;
        private static final int TYPE_ESTATES = 10;
        private static final int TYPE_ESTATES_SEARCH = 11;
        private static final int TYPE_EXPORTS = 20;
        private static final int TYPE_EXPORTS_INTERFACE = 21;
        private static final int TYPE_CONTACTS = 30;
        private static final int TYPE_CONTACTS_STAFF = 31;
        private int type;
        private DbAgencySearch search;
        private DbAgencyExport exportInterface;

        public TreeNode(int n) {
            this.type = n;
            this.search = null;
            this.exportInterface = null;
        }

        public TreeNode(DbAgencySearch dbAgencySearch) {
            this(11);
            this.search = dbAgencySearch;
        }

        public TreeNode(DbAgencyExport dbAgencyExport) {
            this(21);
            this.exportInterface = dbAgencyExport;
        }

        public void doShow(boolean bl) {
            switch (this.getType()) {
                case 10: {
                    new AgencyPlugin.EstateTableAction(bl).actionPerformed(null);
                    break;
                }
                case 11: {
                    new AgencyPlugin.EstateTableAction(this.search.id, bl).actionPerformed(null);
                    break;
                }
                case 31: {
                    new AgencyPlugin.ContactTableAction(bl).actionPerformed(null);
                    break;
                }
                case 20: {
                    new AgencyPlugin.ExportTableAction(bl).actionPerformed(null);
                    break;
                }
                case 21: {
                    break;
                }
            }
        }

        public DbAgencyExport getExportInterface() {
            return this.exportInterface;
        }

        public JPopupMenu getMenu() {
            return AgencyFrameSidebarExtension.createActionMenu(this);
        }

        public Icon getNodeIcon() {
            AgencyExportHandler.JobState jobState = this.exportInterface != null ? AgencyExportHandler.getExportJobState(this.exportInterface.id) : null;
            switch (this.type) {
                case 10: {
                    return AgencyPlugin.getResourceIcon("agent_estates.png", 16);
                }
                case 11: {
                    return ImmoToolEnvironment.getResourceIcon((String)"search.png", (int)16);
                }
                case 31: {
                    return AgencyPlugin.getResourceIcon("agent_family.png", 16);
                }
                case 20: {
                    return ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16);
                }
                case 21: {
                    if (AgencyExportHandler.JobState.FINISHED.equals((Object)jobState)) {
                        return ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16);
                    }
                    if (AgencyExportHandler.JobState.PREPARATION_CANCELLED.equals((Object)jobState) || AgencyExportHandler.JobState.TRANSPORT_CANCELLED.equals((Object)jobState)) {
                        return ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16);
                    }
                    if (AgencyExportHandler.JobState.FINISHING_ERROR.equals((Object)jobState) || AgencyExportHandler.JobState.PREPARATION_ERROR.equals((Object)jobState) || AgencyExportHandler.JobState.TRANSPORT_ERROR.equals((Object)jobState)) {
                        return ImmoToolEnvironment.getResourceIcon((String)"warning.png", (int)16);
                    }
                    if (AgencyExportHandler.JobState.FINISHING.equals((Object)jobState) || AgencyExportHandler.JobState.PREPARATION_PENDING.equals((Object)jobState) || AgencyExportHandler.JobState.PREPARATION_RUNNING.equals((Object)jobState) || AgencyExportHandler.JobState.TRANSPORT_PENDING.equals((Object)jobState) || AgencyExportHandler.JobState.TRANSPORT_RUNNING.equals((Object)jobState)) {
                        return jobBusyLabel != null ? jobBusyLabel.getIcon() : null;
                    }
                    return null;
                }
            }
            return null;
        }

        public String getNodeText() {
            switch (this.type) {
                case 0: {
                    return "";
                }
                case 10: {
                    return this.title(StringUtils.capitalize((String)I18N.tr("properties")));
                }
                case 11: {
                    return this.search != null && this.search.item != null ? this.search.item.getName() : "???";
                }
                case 20: {
                    return this.title(StringUtils.capitalize((String)I18N.tr("export interfaces")));
                }
                case 21: {
                    return "<span>" + StringEscapeUtils.escapeXml11((String)StringUtils.trimToEmpty((String)this.exportInterface.name)) + "</span>";
                }
                case 30: {
                    return this.title(StringUtils.capitalize((String)I18N.tr("contacts")));
                }
                case 31: {
                    return StringUtils.capitalize((String)I18N.tr("contact persons"));
                }
            }
            return "???";
        }

        public String getNodeTooltip() {
            switch (this.getType()) {
                case 10: {
                    return I18N.tr("Show properties.");
                }
                case 11: {
                    if (this.search == null) {
                        return null;
                    }
                    String string = ImmoToolUtils.stripTags((String)this.search.item.getNotes());
                    string = string == null ? "" : string.trim();
                    string = StringUtils.abbreviate((String)string, (int)200);
                    string = string.replaceAll("\\n", "<br>");
                    return StringUtils.capitalize((String)I18N.tr("show properties")) + " <b>" + this.search.item.getName() + "</b><hr>" + string;
                }
                case 31: {
                    return I18N.tr("Show contact persons for customer request.");
                }
                case 20: {
                    return I18N.tr("Show interfaces.");
                }
                case 21: {
                    String string = this.exportInterface.limit > 0 ? I18N.tr("limited to {0} properties", (Object)this.exportInterface.limit) : I18N.tr("unlimited");
                    String string2 = this.exportInterface.enabled ? I18N.tr("active") : I18N.tr("inactive");
                    return StringUtils.capitalize((String)I18N.tr("export interface")) + " #" + this.exportInterface.id + "<br><b>" + this.exportInterface.name + "</b><hr>" + I18N.tr("transport") + ": <b>" + this.exportInterface.getTransportName() + "</b><br>" + I18N.tr("format") + ": <b>" + this.exportInterface.getFormatName() + "</b><br>" + I18N.tr("limit") + ": <b>" + string + "</b><br>" + I18N.tr("status") + ": <b>" + string2 + "</b>";
                }
            }
            return null;
        }

        public DbAgencySearch getSearch() {
            return this.search;
        }

        public int getType() {
            return this.type;
        }

        public boolean isContactsNode() {
            return this.getType() == 30;
        }

        public boolean isContactsStaffNode() {
            return this.getType() == 31;
        }

        public boolean isEstatesNode() {
            return this.getType() == 10;
        }

        public boolean isEstatesSearchNode() {
            return this.getType() == 11;
        }

        public boolean isExportsNode() {
            return this.getType() == 20;
        }

        public boolean isExportInterfaceNode() {
            return this.getType() == 21;
        }

        public boolean isRootNode() {
            return this.getType() == 0;
        }

        public void setExportInterface(DbAgencyExport dbAgencyExport) {
            this.exportInterface = dbAgencyExport;
        }

        public void setSearch(DbAgencySearch dbAgencySearch) {
            this.search = dbAgencySearch;
        }
    }

    public static class Tree
    extends SidebarTree {
        public TreeNode getEstatesNode() {
            TreeNode treeNode = this.getRootNode();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (10 != treeNode2.getType()) continue;
                return treeNode2;
            }
            return null;
        }

        public TreeNode getExportNode(long l) {
            TreeNode treeNode = this.getExportsNode();
            if (treeNode == null) {
                return null;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbAgencyExport dbAgencyExport;
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (treeNode2.getType() != 21 || (dbAgencyExport = treeNode2.getExportInterface()) == null || dbAgencyExport.id != l) continue;
                return treeNode2;
            }
            return null;
        }

        public TreeNode getExportsNode() {
            TreeNode treeNode = this.getRootNode();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (20 != treeNode2.getType()) continue;
                return treeNode2;
            }
            return null;
        }

        public TreeNode getRootNode() {
            return (TreeNode)((Object)this.getModel().getRoot());
        }

        public void putExport(DbAgencyExport dbAgencyExport) {
            if (dbAgencyExport == null) {
                throw new IllegalArgumentException("No export was provided!");
            }
            if (dbAgencyExport.id < 1L) {
                throw new IllegalArgumentException("An unsaved export was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getExportsNode();
            if (treeNode == null) {
                return;
            }
            TreeNode treeNode2 = this.getExportNode(dbAgencyExport.id);
            if (treeNode2 != null) {
                treeNode2.setExportInterface(dbAgencyExport);
                defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode2));
                return;
            }
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)new TreeNode(dbAgencyExport)), (MutableTreeNode)((Object)treeNode), treeNode.getChildCount());
        }

        public void putSearch(DbAgencySearch dbAgencySearch) {
            if (dbAgencySearch == null) {
                throw new IllegalArgumentException("No search was provided!");
            }
            if (dbAgencySearch.id < 1L) {
                throw new IllegalArgumentException("An unsaved search was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getEstatesNode();
            if (treeNode == null) {
                return;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbAgencySearch dbAgencySearch2;
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (treeNode2.getType() != 11 || (dbAgencySearch2 = treeNode2.getSearch()) == null || dbAgencySearch2.id != dbAgencySearch.id) continue;
                treeNode2.setSearch(dbAgencySearch);
                defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode2));
                return;
            }
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)new TreeNode(dbAgencySearch)), (MutableTreeNode)((Object)treeNode), treeNode.getChildCount());
        }

        public boolean removeExport(long l) {
            if (l < 1L) {
                throw new IllegalArgumentException("An invalid export-id was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getExportsNode();
            if (treeNode == null) {
                return false;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbAgencyExport dbAgencyExport;
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (treeNode2.getType() != 21 || (dbAgencyExport = treeNode2.getExportInterface()) == null || dbAgencyExport.id != l) continue;
                defaultTreeModel.removeNodeFromParent((MutableTreeNode)((Object)treeNode2));
                return true;
            }
            return false;
        }

        public boolean removeSearch(long l) {
            if (l < 1L) {
                throw new IllegalArgumentException("An invalid search-id was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getEstatesNode();
            if (treeNode == null) {
                return false;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbAgencySearch dbAgencySearch;
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (treeNode2.getType() != 11 || (dbAgencySearch = treeNode2.getSearch()) == null || dbAgencySearch.id != l) continue;
                defaultTreeModel.removeNodeFromParent((MutableTreeNode)((Object)treeNode2));
                return true;
            }
            return false;
        }
    }
}

