/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.DbContact;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLog;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbLog;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.utils.ImageUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import eu.medsea.mimeutil.MimeType;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyImportTask
extends ImmoToolTask<Result, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyImportTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyImportTask.class);
    private final File importFile;
    protected final AbstractImport importFormat;
    protected final String importVersion;
    protected final Settings importSettings;
    protected final AbstractDbDriver dbDriver;
    protected final DbAgencyExtension dbExtension;
    protected final DbUser dbUser;
    protected Connection dbConnection = null;
    private Map<Long, String> dbLanguageMap = null;
    private Map<Long, Long> dbAgencyContacts = null;

    public AgencyImportTask(File file, AbstractImport abstractImport, String string, Settings settings, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension, DbUser dbUser) {
        super(I18N.tr("import properties"));
        this.importFile = file;
        this.importFormat = abstractImport;
        this.importVersion = StringUtils.trimToNull((String)string);
        this.importSettings = settings;
        this.dbUser = dbUser;
        this.dbDriver = abstractDbDriver;
        this.dbExtension = dbAgencyExtension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String calculateHash(EstateImpl estateImpl) {
        try (StringWriter stringWriter = new StringWriter();){
            OpenEstateUtils.serializeToXML((SerializableXmlElement)estateImpl, (Writer)stringWriter, (boolean)false, (String)"UTF-8", (String)"<br/>");
            String string2 = stringWriter.toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
            String string = DigestUtils.sha1Hex((String)string2);
            return string;
        }
        catch (Exception exception) {
            LOGGER.error("Can't calculate hash value!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected Result createResult() {
        return new Result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result doInBackground() throws Exception {
        Result result;
        ArrayList<File> arrayList;
        File file;
        block8: {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                throw new Exception("No project loaded!");
            }
            file = null;
            arrayList = new ArrayList<File>();
            file = new File(immoToolProject.getTempDirectory(), "import-" + System.currentTimeMillis());
            if (StringUtils.endsWithIgnoreCase((CharSequence)this.importFile.getName(), (CharSequence)".zip")) {
                if (!file.mkdirs()) {
                    throw new IOException("Can't create temp directory!");
                }
                ImmoToolUtils.unzip((File)this.importFile, (File)file);
                arrayList.addAll(FileUtils.listFiles((File)file, (String[])this.importFormat.getFileExtensions(), (boolean)true));
            } else {
                arrayList.add(this.importFile);
            }
            if (!arrayList.isEmpty()) break block8;
            Result result2 = null;
            JdbcUtils.closeQuietly((Connection)this.dbConnection);
            FileUtils.deleteQuietly((File)file);
            return result2;
        }
        try {
            this.setMessage(I18N.tr("Preparing import."));
            this.init();
            Result result3 = this.createResult();
            for (File file2 : arrayList) {
                this.setMessage(I18N.tr("Process file {0}.", (Object)("'" + file2.getName() + "'")));
                Result result4 = this.process(file2);
                if (result4 == null) continue;
                result3.add(result4);
            }
            result = result3;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly((Connection)this.dbConnection);
            FileUtils.deleteQuietly(file);
            throw throwable;
        }
        JdbcUtils.closeQuietly((Connection)this.dbConnection);
        FileUtils.deleteQuietly((File)file);
        return result;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The import procedure failed!"), (Throwable)throwable, (Window)this.getParentWindow());
    }

    protected EstateImpl getEstateForImport(EstateImpl estateImpl, EstateImpl estateImpl2, Result result) {
        return estateImpl;
    }

    private void init() throws SQLException {
        JdbcUtils.closeQuietly((Connection)this.dbConnection);
        this.dbConnection = this.dbDriver.getConnection();
        this.checkCancelled();
        this.dbLanguageMap = this.dbExtension.getLanguagesHandler().getLanguageMap(this.dbConnection);
        this.checkCancelled();
        this.dbAgencyContacts = new HashMap<Long, Long>();
        for (DbContact dbContact : this.dbExtension.getContactsHandler().getContacts(this.dbConnection)) {
            this.checkCancelled();
            try {
                long l = dbContact.item.calculateHash();
                if (this.dbAgencyContacts.containsKey(l)) continue;
                this.dbAgencyContacts.put(l, dbContact.id);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load agency contacts from database!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    private Result process(File file) throws IOException, SQLException {
        this.checkCancelled();
        TransferImpl transferImpl = this.importFormat.parseFile(file, this.importVersion, this.importSettings);
        if (transferImpl == null) {
            throw new IOException("Can't create a transfer from the import file!");
        }
        return this.process(transferImpl, file.getParentFile());
    }

    private Result process(TransferImpl transferImpl, File file) throws SQLException {
        boolean bl = UpdateMethod.UPDATE_CHANGED_OBJECTS.equals((Object)this.importSettings.getUpdateMethod());
        DeleteMethod deleteMethod = this.importSettings.getDeleteMethod();
        ArrayList<Long> arrayList = DeleteMethod.DELETE_UNMODIFIED.equals((Object)deleteMethod) ? new ArrayList<Long>() : null;
        this.checkCancelled();
        if (transferImpl == null) {
            throw new IllegalArgumentException("Invalid transfer!");
        }
        if (transferImpl.getAgencies().isEmpty()) {
            throw new IllegalArgumentException("Empty transfer!");
        }
        long l = 0L;
        Result result = this.createResult();
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            Object object;
            Long l2;
            Object object2;
            result.setTotalCount(result.getTotalCount() + transferAgencyImpl.getEstateIdsToRemove().size() + transferAgencyImpl.getEstatesToSave().size());
            for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
                this.checkCancelled();
                this.setMessage(I18N.tr("Processing property {0}.", (Object)(++l)));
                try {
                    object2 = this.calculateHash(estateImpl);
                    Object object3 = l2 = bl ? this.dbExtension.getObjectsHandler().getObjectByImportHash(this.dbConnection, (String)object2) : null;
                    if (l2 != null) {
                        LOGGER.info("Ignore already existing property #" + ((DbAgencyObject)((Object)l2)).id);
                        if (arrayList != null) {
                            arrayList.add(((DbAgencyObject)((Object)l2)).id);
                        }
                        result.incIgnoreCount();
                        continue;
                    }
                    object = estateImpl.getContactId();
                    AgentContactImpl agentContactImpl = object != null ? (AgentContactImpl)transferAgencyImpl.getContacts().get(object) : null;
                    long l3 = this.updateEstate(estateImpl, agentContactImpl, (String)object2, result, file);
                    if (l3 <= 0L || arrayList == null || arrayList.contains(l3)) continue;
                    arrayList.add(l3);
                }
                catch (Exception exception) {
                    LOGGER.error("Can't save property!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage(I18N.tr("Can't save property!"));
                    this.setMessage("> " + exception.getLocalizedMessage());
                }
            }
            if (DeleteMethod.DELETE_EXPLICITLY.equals((Object)deleteMethod)) {
                for (String string : transferAgencyImpl.getEstateIdsToRemove()) {
                    object2 = this.dbExtension.getObjectsHandler().getObjectByImportId(this.dbConnection, string);
                    if (object2 == null) {
                        LOGGER.warn("Can't find estate for explicit delete!");
                        LOGGER.warn("> import-id: " + string);
                        continue;
                    }
                    this.setMessage(I18N.tr("Removing property {0}.", (Object)("#" + ((DbAgencyObject)((Object)object2)).id)));
                    if (!this.removeEstate((DbAgencyObject)((Object)object2))) continue;
                    result.incDeleteExplicitCount();
                }
            }
            if (!DeleteMethod.DELETE_UNMODIFIED.equals((Object)deleteMethod) || arrayList == null) continue;
            Object object4 = this.dbExtension.getObjectsHandler().getObjectIds(this.dbConnection);
            int n = ((Object)object4).length;
            for (int i = 0; i < n; ++i) {
                l2 = (long)object4[i];
                if (arrayList.contains(l2)) continue;
                this.setMessage(I18N.tr("Deleting unmodified property {0}.", (Object)("#" + l2)));
                object = (DbAgencyObject)this.dbExtension.getObjectsHandler().getObject(this.dbConnection, l2);
                if (object == null || !this.removeEstate((DbAgencyObject)((Object)object))) continue;
                result.incDeleteUnmodifiedCount();
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE"}, justification="It is intended to return an opened InputStream..")
    private InputStream readAttachment(EstateAttachmentImpl var1_1, int var2_2, File var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean removeEstate(DbAgencyObject dbAgencyObject) {
        try {
            this.dbExtension.getObjectsHandler().removeObject(this.dbConnection, dbAgencyObject.id);
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't delete estate #" + dbAgencyObject.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return false;
        }
    }

    protected void succeeded(Result result) {
        super.succeeded((Object)result);
        if (result == null || result.getTotalCount() < 1) {
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("No properties were imported!"), (Component)this.getParentWindow());
        } else {
            ImmoToolUtils.showMessageInfoDialog((String)result.writeSummary(), (Component)this.getParentWindow());
        }
    }

    private long updateContact(AgentContactImpl agentContactImpl, File file) throws SQLException {
        if (agentContactImpl == null) {
            return 0L;
        }
        long l = agentContactImpl.calculateHash();
        if (this.dbAgencyContacts.containsKey(l)) {
            long l2 = this.dbAgencyContacts.get(l);
            this.setMessage("> " + I18N.tr("Use existing contact person {0}.", (Object)("#" + l2)));
            return l2;
        }
        DbAgencyContact dbAgencyContact = new DbAgencyContact();
        dbAgencyContact.item = agentContactImpl;
        dbAgencyContact.id = 0L;
        this.dbExtension.getContactsHandler().saveContact(this.dbConnection, dbAgencyContact);
        this.dbAgencyContacts.put(l, dbAgencyContact.id);
        this.setMessage("> " + I18N.tr("Use new contact person {0}.", (Object)("#" + dbAgencyContact.id)));
        return dbAgencyContact.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateEstate(EstateImpl estateImpl, AgentContactImpl agentContactImpl, String string, Result result, File file) throws SQLException {
        Object object;
        Serializable serializable;
        int n;
        Object object2;
        String string2;
        Object object3;
        DbAgencyObject.Status status = this.importSettings.getAgencyObjectStatus();
        boolean bl = UpdateMethod.UPDATE_NOTHING.equals((Object)this.importSettings.getUpdateMethod());
        if (estateImpl == null) {
            throw new NullPointerException("Invalid estate!");
        }
        String string3 = StringUtils.trimToNull((String)estateImpl.getId());
        estateImpl.setId(null);
        DbAgencyObject dbAgencyObject = null;
        if (string3 != null) {
            this.setMessage("> " + I18N.tr("Looking up import ID {0}.", (Object)('\"' + string3 + '\"')));
            dbAgencyObject = this.dbExtension.getObjectsHandler().getObjectByImportId(this.dbConnection, string3);
            if (dbAgencyObject != null) {
                this.setMessage("> " + I18N.tr("Found property {0}.", (Object)("#" + dbAgencyObject.id)));
                estateImpl.setId(String.valueOf(dbAgencyObject.id));
                if (!Boolean.TRUE.equals(bl)) {
                    this.dbExtension.getObjectsHandler().loadObjectAttribs(this.dbConnection, dbAgencyObject, this.dbLanguageMap);
                    this.dbExtension.getObjectsHandler().loadObjectExportIds(this.dbConnection, dbAgencyObject);
                    this.dbExtension.getObjectsHandler().loadObjectGeoDbAreas(this.dbConnection, dbAgencyObject, this.dbExtension.getGeoHandler());
                    this.dbExtension.getObjectsHandler().loadObjectTranslations(this.dbConnection, dbAgencyObject, this.dbLanguageMap);
                }
            }
        }
        if (estateImpl.getId() == null && (object3 = StringUtils.trimToNull((String)estateImpl.getPublicId())) != null) {
            this.setMessage("> " + I18N.tr("Looking up import nr {0}.", (Object)('\"' + object3 + '\"')));
            dbAgencyObject = (DbAgencyObject)this.dbExtension.getObjectsHandler().getObject(this.dbConnection, (String)object3);
            if (dbAgencyObject != null) {
                this.setMessage("> " + I18N.tr("Found property {0}.", (Object)("#" + dbAgencyObject.id)));
                estateImpl.setId(String.valueOf(dbAgencyObject.id));
                if (!Boolean.TRUE.equals(bl)) {
                    this.dbExtension.getObjectsHandler().loadObjectAttribs(this.dbConnection, dbAgencyObject, this.dbLanguageMap);
                    this.dbExtension.getObjectsHandler().loadObjectExportIds(this.dbConnection, dbAgencyObject);
                    this.dbExtension.getObjectsHandler().loadObjectGeoDbAreas(this.dbConnection, dbAgencyObject, this.dbExtension.getGeoHandler());
                    this.dbExtension.getObjectsHandler().loadObjectTranslations(this.dbConnection, dbAgencyObject, this.dbLanguageMap);
                }
            }
        }
        if (estateImpl.getId() != null && Boolean.TRUE.equals(bl)) {
            this.setMessage("> " + I18N.tr("Don't update property {0}.", (Object)("#" + estateImpl.getId())));
            result.incIgnoreCount();
            return Long.parseLong(estateImpl.getId());
        }
        object3 = new DbAgencyObject();
        ((DbAgencyObject)((Object)object3)).item = this.getEstateForImport(estateImpl, dbAgencyObject != null ? dbAgencyObject.item : null, result);
        if (((DbAgencyObject)((Object)object3)).item == null) {
            this.setMessage("> " + I18N.tr("Don't update property {0}.", (Object)("#" + estateImpl.getId())));
            result.incIgnoreCount();
            return Long.parseLong(estateImpl.getId());
        }
        if (dbAgencyObject == null) {
            string2 = "ADD";
            ((DbAgencyObject)((Object)object3)).contactId = this.updateContact(agentContactImpl, file);
            ((DbAgencyObject)((Object)object3)).exportMode = DbAgencyObject.ExportMode.ALL;
            ((DbAgencyObject)((Object)object3)).importId = string3;
            ((DbAgencyObject)((Object)object3)).status = status != null ? status : DbAgencyObject.Status.DRAFT;
        } else {
            string2 = "EDIT";
            ((DbAgencyObject)((Object)object3)).exportIds = dbAgencyObject.exportIds;
            ((DbAgencyObject)((Object)object3)).exportMode = dbAgencyObject.exportMode;
            ((DbAgencyObject)((Object)object3)).geoDbAreas = dbAgencyObject.geoDbAreas;
            ((DbAgencyObject)((Object)object3)).id = dbAgencyObject.id;
            ((DbAgencyObject)((Object)object3)).importId = dbAgencyObject.importId;
            ((DbAgencyObject)((Object)object3)).notes = dbAgencyObject.notes;
            ((DbAgencyObject)((Object)object3)).ownerGroupId = dbAgencyObject.ownerGroupId;
            ((DbAgencyObject)((Object)object3)).ownerUserId = dbAgencyObject.ownerUserId;
            ((DbAgencyObject)((Object)object3)).permission = dbAgencyObject.permission;
            ((DbAgencyObject)((Object)object3)).contactId = !this.importSettings.isUpdateContact() ? dbAgencyObject.contactId : this.updateContact(agentContactImpl, file);
            if (!this.importSettings.isUpdateStatus()) {
                ((DbAgencyObject)((Object)object3)).status = dbAgencyObject.status;
            } else {
                DbAgencyObject.Status status2 = ((DbAgencyObject)((Object)object3)).status = status != null ? status : DbAgencyObject.Status.DRAFT;
            }
        }
        if (string != null) {
            ((DbAgencyObject)((Object)object3)).importHash = string;
        }
        if (((DbAgencyObject)((Object)object3)).item.getLanguages().isEmpty()) {
            object2 = ((DbAgencyObject)((Object)object3)).item.getTitleLanguages();
            ((DbAgencyObject)((Object)object3)).item.getLanguages().addAll(Arrays.asList(object2));
        }
        if (((DbAgencyObject)((Object)object3)).item.getCurrency() == null) {
            LOGGER.warn("No currency was assigned to the imported property (" + ((DbAgencyObject)((Object)object3)).importId + " / " + ((DbAgencyObject)((Object)object3)).item.getPublicId() + "). Using EUR as default currency.");
            ((DbAgencyObject)((Object)object3)).item.setCurrency(Currency.getInstance("EUR"));
        }
        this.dbExtension.getObjectsHandler().saveObject(this.dbConnection, (DbObject)object3, this.dbLanguageMap, true, true);
        if (((DbAgencyObject)((Object)object3)).id < 1L) {
            LOGGER.error("Estate was not saved!");
            result.incErrorCount();
            return 0L;
        }
        if (string2 != null) {
            object2 = DbAgencyObjectLog.create(((DbAgencyObject)((Object)object3)).id, string2, this.dbUser);
            if ("EDIT".equals(string2)) {
                object2.initChanges(dbAgencyObject, (DbAgencyObject)((Object)object3));
            }
            this.dbExtension.getObjectLogsHandler().saveLog(this.dbConnection, (DbLog)object2);
        }
        if (dbAgencyObject == null || this.importSettings.isUpdateAttachments()) {
            object2 = null;
            if (dbAgencyObject != null && dbAgencyObject.id > 0L) {
                object2 = this.dbExtension.getFilesHandler().getFileIds(this.dbConnection, dbAgencyObject.id, null, null);
            }
            n = AgencyPlugin.getImageMaxWidth();
            int n2 = AgencyPlugin.getImageMaxHeight();
            int n3 = 0;
            for (Object object4 : estateImpl.getAttachments()) {
                MimeType mimeType;
                File file2;
                Object object5;
                block76: {
                    this.checkCancelled();
                    try {
                        object5 = this.readAttachment((EstateAttachmentImpl)object4, ++n3, file);
                        serializable = null;
                        try {
                            if (object5 == null) continue;
                            file2 = File.createTempFile("import.", ".temp");
                            FileUtils.copyInputStreamToFile((InputStream)object5, (File)file2);
                            mimeType = ImmoToolUtils.getMimeType((File)file2);
                            break block76;
                        }
                        catch (Throwable throwable) {
                            serializable = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object5 == null) continue;
                            if (serializable != null) {
                                try {
                                    ((InputStream)object5).close();
                                }
                                catch (Throwable throwable) {
                                    serializable.addSuppressed(throwable);
                                }
                                continue;
                            }
                            ((InputStream)object5).close();
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.warn("Can't read estate attachment for import!");
                        LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                    }
                    continue;
                }
                if (file2 == null) continue;
                if (mimeType == null) {
                    mimeType = new MimeType("application/octet-stream");
                }
                object5 = null;
                serializable = null;
                try {
                    int n4;
                    Object object6;
                    String string4;
                    object = null;
                    if (mimeType.getMediaType().equalsIgnoreCase("image")) {
                        try {
                            object = mimeType.toString().equalsIgnoreCase("image/png") ? ImageUtils.read((File)file2) : ImageUtils.readAsRgb((File)file2);
                        }
                        catch (IOException iOException) {
                            LOGGER.warn("Can't read attached image!");
                            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
                        }
                    }
                    if (object != null) {
                        BufferedImage bufferedImage;
                        int n5;
                        string4 = mimeType.toString().equalsIgnoreCase("image/png") ? "image/png" : "image/jpeg";
                        object6 = ImageUtils.scaleToFit((BufferedImage)object, (int)300, (int)300);
                        serializable = File.createTempFile("import.", ".temp");
                        ImageUtils.writeJpg((BufferedImage)object6, (File)serializable);
                        ((Image)object6).flush();
                        if (n2 > 0 || n > 0) {
                            n5 = n2 > 0 ? n2 : ((BufferedImage)object).getHeight();
                            int n6 = n4 = n > 0 ? n : ((BufferedImage)object).getWidth();
                            if (((BufferedImage)object).getHeight() > n5 || ((BufferedImage)object).getWidth() > n4) {
                                bufferedImage = ImageUtils.scaleToFit((BufferedImage)object, (int)n4, (int)n5);
                                ((Image)object).flush();
                                object = bufferedImage;
                            }
                        }
                        n5 = ((BufferedImage)object).getWidth();
                        n4 = ((BufferedImage)object).getHeight();
                        object5 = File.createTempFile("import.", ".temp");
                        if (string4.equals("image/png")) {
                            ImageUtils.writePng((BufferedImage)object, (File)object5);
                        } else {
                            ImageUtils.writeJpg((BufferedImage)object, (File)object5);
                        }
                        ((Image)object).flush();
                        bufferedImage = new DbFile();
                        ((DbFile)bufferedImage).name = StringUtils.trimToNull((String)object4.getFileAsName());
                        ((DbFile)bufferedImage).name = ((DbFile)bufferedImage).name != null ? FilenameUtils.getBaseName((String)new File(((DbFile)bufferedImage).name.trim()).getName()) : String.valueOf(System.currentTimeMillis());
                        ((DbFile)bufferedImage).name = ((DbFile)bufferedImage).name + (string4.equals("image/png") ? ".png" : ".jpg");
                        ((DbFile)bufferedImage).mimeType = string4;
                        ((DbFile)bufferedImage).objectId = ((DbAgencyObject)((Object)object3)).id;
                        ((DbFile)bufferedImage).position = n3 - 1;
                        ((DbFile)bufferedImage).imageHeight = n4;
                        ((DbFile)bufferedImage).imageWidth = n5;
                        ((DbFile)bufferedImage).published = object4.isPublished();
                        ((DbFile)bufferedImage).size = ((File)object5).length();
                        ((DbFile)bufferedImage).type = object4.getType();
                        ((DbFile)bufferedImage).translations = new HashMap();
                        for (String string5 : object4.getTitleLanguages()) {
                            DbFile.Translation translation = new DbFile.Translation();
                            translation.title = object4.getTitle(string5);
                            ((DbFile)bufferedImage).translations.put(string5, translation);
                        }
                        this.dbExtension.getFilesHandler().saveFile(this.dbConnection, (DbFile)bufferedImage, (File)object5, (File)serializable, this.dbLanguageMap);
                        continue;
                    }
                    string4 = null;
                    if (object4.isName()) {
                        object6 = object4.getFileAsName();
                        if (((String)object6).contains(".")) {
                            string4 = StringUtils.trimToNull((String)((String)object6).substring(((String)object6).lastIndexOf(".")));
                        }
                    } else if (object4.isUrl() && ((String)(object6 = object4.getFileAsUrl().getPath())).contains(".")) {
                        string4 = StringUtils.trimToNull((String)((String)object6).substring(((String)object6).lastIndexOf(".")));
                    }
                    if (string4 == null) {
                        string4 = ".bin";
                    }
                    object6 = new DbFile();
                    ((DbFile)object6).name = object4.getFileAsName();
                    ((DbFile)object6).name = ((DbFile)object6).name != null && ((DbFile)object6).name.trim().length() > 0 ? new File(((DbFile)object6).name.trim()).getName() : System.currentTimeMillis() + string4.toLowerCase();
                    ((DbFile)object6).mimeType = StringUtils.trimToNull((String)mimeType.toString());
                    if (((DbFile)object6).mimeType == null) {
                        ((DbFile)object6).mimeType = "application/octet-stream";
                    }
                    ((DbFile)object6).objectId = ((DbAgencyObject)((Object)object3)).id;
                    ((DbFile)object6).position = n3 - 1;
                    ((DbFile)object6).imageHeight = 0;
                    ((DbFile)object6).imageWidth = 0;
                    ((DbFile)object6).published = object4.isPublished();
                    ((DbFile)object6).size = file2.length();
                    ((DbFile)object6).type = object4.getType();
                    ((DbFile)object6).translations = new HashMap();
                    String[] stringArray = object4.getTitleLanguages();
                    n4 = stringArray.length;
                    for (int i = 0; i < n4; ++i) {
                        String[] stringArray2 = stringArray[i];
                        DbFile.Translation translation = new DbFile.Translation();
                        translation.title = object4.getTitle((String)stringArray2);
                        ((DbFile)object6).translations.put(stringArray2, translation);
                    }
                    this.dbExtension.getFilesHandler().saveFile(this.dbConnection, (DbFile)object6, file2, null, this.dbLanguageMap);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Can't import estate attachment!");
                    LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                }
                finally {
                    FileUtils.deleteQuietly((File)file2);
                    FileUtils.deleteQuietly((File)object5);
                    FileUtils.deleteQuietly((File)serializable);
                }
            }
            if (object2 != null && ((String[])object2).length > 0) {
                this.dbExtension.getFilesHandler().removeFiles(this.dbConnection, (long[])object2);
            }
        }
        if (dbAgencyObject == null || this.importSettings.isUpdateLinks()) {
            object2 = null;
            if (dbAgencyObject != null && dbAgencyObject.id > 0L) {
                object2 = this.dbExtension.getLinksHandler().getLinkIds(this.dbConnection, dbAgencyObject.id, null, null);
            }
            n = 0;
            for (EstateLinkImpl estateLinkImpl : estateImpl.getLinks()) {
                this.checkCancelled();
                try {
                    Object object4;
                    DbLink dbLink = new DbLink();
                    if (estateLinkImpl.isProviderLink()) {
                        object4 = estateLinkImpl.getProviderLink();
                        dbLink.provider = object4.getProvider();
                        dbLink.providerLinkId = object4.getLinkId();
                    } else if (estateLinkImpl.isWebLink()) {
                        object4 = estateLinkImpl.getUrl();
                        EstateLinkProvider[] estateLinkProviderArray = EstateLinkProvider.values();
                        int n7 = estateLinkProviderArray.length;
                        for (int i = 0; i < n7; ++i) {
                            serializable = estateLinkProviderArray[i];
                            object = StringUtils.trimToNull((String)serializable.getLinkIdFromUrl(((URI)object4).toString()));
                            if (object == null) continue;
                            dbLink.provider = serializable;
                            dbLink.providerLinkId = object;
                            break;
                        }
                        if (dbLink.provider == null) {
                            dbLink.webLinkUrl = object4;
                        }
                    } else {
                        throw new Exception("Unsupported estate link!");
                    }
                    dbLink.objectId = ((DbAgencyObject)((Object)object3)).id;
                    dbLink.position = n;
                    dbLink.published = estateLinkImpl.isPublished();
                    dbLink.translations = new HashMap();
                    for (String string6 : estateLinkImpl.getTitleLanguages()) {
                        serializable = new DbLink.Translation();
                        ((DbLink.Translation)serializable).title = estateLinkImpl.getTitle(string6);
                        dbLink.translations.put(string6, serializable);
                    }
                    this.dbExtension.getLinksHandler().saveLink(this.dbConnection, dbLink, this.dbLanguageMap);
                    ++n;
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Can't import estate links!");
                    LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
                }
            }
            if (object2 != null && ((String[])object2).length > 0) {
                this.dbExtension.getLinksHandler().removeLinks(this.dbConnection, (long[])object2);
            }
        }
        if ("ADD".equals(string2)) {
            result.incInsertCount();
        } else if ("EDIT".equals(string2)) {
            result.incUpdateCount();
        }
        return ((DbAgencyObject)((Object)object3)).id;
    }

    public static enum UpdateMethod implements Translatable
    {
        UPDATE_NOTHING(I18n.marktr((String)"Don't update any properties.")),
        UPDATE_CHANGED_OBJECTS(I18n.marktr((String)"Only update properties, that were modified since last import.")),
        UPDATE_ALWAYS(I18n.marktr((String)"Update all properties."));

        private final String i18nKey;

        private UpdateMethod(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AgencyImportTask.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static enum DeleteMethod implements Translatable
    {
        DELETE_NOTHING(I18n.marktr((String)"Don't delete any properties.")),
        DELETE_EXPLICITLY(I18n.marktr((String)"Execute delete requests from the import file (incremental transfer).")),
        DELETE_UNMODIFIED(I18n.marktr((String)"Delete all properties, that are NOT found in the import file (full transfer)."));

        private final String i18nKey;

        private DeleteMethod(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AgencyImportTask.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static final class Settings
    extends HashMap<String, String> {
        private DeleteMethod deleteMethod = DeleteMethod.DELETE_NOTHING;
        private UpdateMethod updateMethod = UpdateMethod.UPDATE_NOTHING;
        private boolean updateAttachments = true;
        private boolean updateLinks = true;
        private boolean updateContact = true;
        private boolean updateStatus = true;
        private boolean importRemovedObjects = false;
        private DbAgencyObject.Status agencyObjectStatus = DbAgencyObject.Status.TRAY;
        private Locale language = Locale.getDefault();

        public DbAgencyObject.Status getAgencyObjectStatus() {
            return this.agencyObjectStatus;
        }

        public DeleteMethod getDeleteMethod() {
            return this.deleteMethod;
        }

        public Locale getLanguage() {
            return this.language;
        }

        public UpdateMethod getUpdateMethod() {
            return this.updateMethod;
        }

        public boolean isImportRemovedObjects() {
            return this.importRemovedObjects;
        }

        public boolean isUpdateAttachments() {
            return this.updateAttachments;
        }

        public boolean isUpdateContact() {
            return this.updateContact;
        }

        public boolean isUpdateLinks() {
            return this.updateLinks;
        }

        public boolean isUpdateStatus() {
            return this.updateStatus;
        }

        public void setAgencyObjectStatus(DbAgencyObject.Status status) {
            this.agencyObjectStatus = status;
        }

        public void setDeleteMethod(DeleteMethod deleteMethod) {
            this.deleteMethod = deleteMethod;
        }

        public void setImportRemovedObjects(boolean bl) {
            this.importRemovedObjects = bl;
        }

        public void setLanguage(Locale locale) {
            this.language = locale;
        }

        public void setUpdateAttachments(boolean bl) {
            this.updateAttachments = bl;
        }

        public void setUpdateContact(boolean bl) {
            this.updateContact = bl;
        }

        public void setUpdateLinks(boolean bl) {
            this.updateLinks = bl;
        }

        public void setUpdateMethod(UpdateMethod updateMethod) {
            this.updateMethod = updateMethod;
        }

        public void setUpdateStatus(boolean bl) {
            this.updateStatus = bl;
        }
    }

    public static class Result {
        private int totalCount = 0;
        private int insertCount = 0;
        private int updateCount = 0;
        private int ignoreCount = 0;
        private int errorCount = 0;
        private int deleteExplicitCount = 0;
        private int deleteUnmodifiedCount = 0;

        public void add(Result result) {
            this.totalCount += result.getTotalCount();
            this.insertCount += result.getInsertCount();
            this.updateCount += result.getUpdateCount();
            this.ignoreCount += result.getIgnoreCount();
            this.errorCount += result.getErrorCount();
            this.deleteExplicitCount += result.getDeleteExplicitCount();
            this.deleteUnmodifiedCount += result.getDeleteUnmodifiedCount();
        }

        public int getDeleteExplicitCount() {
            return this.deleteExplicitCount;
        }

        public int getDeleteUnmodifiedCount() {
            return this.deleteUnmodifiedCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getIgnoreCount() {
            return this.ignoreCount;
        }

        public int getInsertCount() {
            return this.insertCount;
        }

        protected List<String> getSummary() {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(I18N.trn("{0} property was found in the file.", "{0} properties were found in the file.", (long)this.getTotalCount(), (Object)("<b>" + numberFormat.format(this.getTotalCount()) + "</b>")));
            if (this.getUpdateCount() > 0) {
                arrayList.add(I18N.trn("{0} property was updated.", "{0} properties were updated.", (long)this.getUpdateCount(), (Object)("<b>" + numberFormat.format(this.getUpdateCount()) + "</b>")));
            }
            if (this.getInsertCount() > 0) {
                arrayList.add(I18N.trn("{0} property was inserted.", "{0} properties were inserted.", (long)this.getInsertCount(), (Object)("<b>" + numberFormat.format(this.getInsertCount()) + "</b>")));
            }
            if (this.getIgnoreCount() > 0) {
                arrayList.add(I18N.trn("{0} property was ignored.", "{0} properties were ignored.", (long)this.getIgnoreCount(), (Object)("<b>" + numberFormat.format(this.getIgnoreCount()) + "</b>")));
            }
            if (this.getDeleteExplicitCount() > 0) {
                arrayList.add(I18N.trn("{0} properties was removed.", "{0} properties were removed.", (long)this.getDeleteExplicitCount(), (Object)("<b>" + numberFormat.format(this.getDeleteExplicitCount()) + "</b>")));
            }
            if (this.getDeleteUnmodifiedCount() > 0) {
                arrayList.add(I18N.trn("{0} unmodified property was removed.", "{0} unmodified properties were removed.", (long)this.getDeleteUnmodifiedCount(), (Object)("<b>" + numberFormat.format(this.getDeleteUnmodifiedCount()) + "</b>")));
            }
            if (this.getErrorCount() > 0) {
                arrayList.add(I18N.trn("An error occurred for {0} property.", "An error occurred for {0} properties.", (long)this.getErrorCount(), (Object)("<b>" + numberFormat.format(this.getErrorCount()) + "</b>")));
            }
            return arrayList;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public int getUpdateCount() {
            return this.updateCount;
        }

        public void incDeleteExplicitCount() {
            ++this.deleteExplicitCount;
        }

        public void incDeleteUnmodifiedCount() {
            ++this.deleteUnmodifiedCount;
        }

        public void incErrorCount() {
            ++this.errorCount;
        }

        public void incIgnoreCount() {
            ++this.ignoreCount;
        }

        public void incInsertCount() {
            ++this.insertCount;
        }

        public void incTotalCount() {
            ++this.totalCount;
        }

        public void incUpdateCount() {
            ++this.updateCount;
        }

        public void setDeleteExplicitCount(int n) {
            this.deleteExplicitCount = n;
        }

        public void setDeleteUnmodifiedCount(int n) {
            this.deleteUnmodifiedCount = n;
        }

        public void setErrorCount(int n) {
            this.errorCount = n;
        }

        public void setIgnoreCount(int n) {
            this.ignoreCount = n;
        }

        public void setInsertCount(int n) {
            this.insertCount = n;
        }

        public void setTotalCount(int n) {
            this.totalCount = n;
        }

        public void setUpdateCount(int n) {
            this.updateCount = n;
        }

        public String writeSummary() {
            String string = I18N.tr("The import process finished successfully.");
            string = string + "<ul style=\"margin-left:15px;\">";
            string = string + "<li>" + StringUtils.join(this.getSummary(), (String)"</li><li>") + "</li>";
            string = string + "</ul>";
            return "<html>" + string + "</html>";
        }
    }
}

