/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogEntry;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogMessage;
import com.openindex.openestate.tool.agency.db.DbAgencyExportPublishing;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandlerImpl;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyExportsHandler
extends DbAgencyExportsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyExportsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyExportsHandler.class);
    public static final String PROC_REMOVE_EXPORTS = "remove_immotool_agency_exports";
    public static final String PROC_REMOVE_EXPORTS_LOGS = "remove_immotool_agency_exports_logs";
    public static final String PROC_REMOVE_EXPORTS_LOGS_ENTRIES = "remove_immotool_agency_exports_logs_entries";
    public static final String PROC_REMOVE_EXPORTS_LOGS_MESSAGES = "remove_immotool_agency_exports_logs_messages";
    public static final String PROC_REMOVE_EXPORTS_PUBLISHINGS = "remove_immotool_agency_exports_publishings";
    public static final String PROC_REMOVE_EXPORTS_SETTINGS = "remove_immotool_agency_exports_settings";
    public static final String PROC_SAVE_EXPORTS = "save_immotool_agency_exports";
    public static final String PROC_SAVE_EXPORTS_LOGS = "save_immotool_agency_exports_logs";
    public static final String PROC_SAVE_EXPORTS_LOGS_ENTRIES = "save_immotool_agency_exports_logs_entries";
    public static final String PROC_SAVE_EXPORTS_LOGS_MESSAGES = "save_immotool_agency_exports_logs_messages";
    public static final String PROC_SAVE_EXPORTS_PUBLISHINGS = "save_immotool_agency_exports_publishings";
    public static final String PROC_SAVE_EXPORTS_SETTINGS = "save_immotool_agency_exports_settings";
    public static final String PROC_SET_EXPORTS_ENABLED = "set_immotool_agency_exports_enabled";
    public static final String VIEW_EXPORTS = "view_immotool_agency_exports";
    public static final String VIEW_EXPORTS_LOGS = "view_immotool_agency_exports_logs";
    public static final String VIEW_EXPORTS_LOGS_ENTRIES = "view_immotool_agency_exports_logs_entries";
    public static final String VIEW_EXPORTS_LOGS_MESSAGES = "view_immotool_agency_exports_logs_messages";
    public static final String VIEW_EXPORTS_PUBLISHINGS = "view_immotool_agency_exports_publishings";
    public static final String VIEW_EXPORTS_SETTINGS = "view_immotool_agency_exports_settings";
    public static final String TABLE_EXPORTS = "immotool_agency_exports";
    public static final String FIELD_EXPORT_ID = "export_id";
    public static final String FIELD_EXPORT_NAME = "export_name";
    public static final String FIELD_EXPORT_FORMAT = "export_format";
    public static final String FIELD_EXPORT_TRANSPORT = "export_transport";
    public static final String FIELD_EXPORT_TRANSFER = "export_transfer";
    public static final String FIELD_EXPORT_ENABLED = "export_enabled";
    public static final String FIELD_EXPORT_LIMIT = "export_limit";
    public static final String FIELD_EXPORT_NOTES = "export_notes";
    public static final String FIELD_EXPORT_LAST_EXECUTION = "export_last_execution";
    public static final String FIELD_EXPORT_LOCK_TIME = "export_lock_time";
    public static final String FIELD_EXPORT_SEARCH_ID = "search_id";
    public static final String FIELD_EXPORT_EXPOSE_ID = "expose_id";
    public static final String TABLE_EXPORTS_LOGS = "immotool_agency_exports_logs";
    public static final String FIELD_LOG_ID = "log_id";
    public static final String FIELD_LOG_FORMAT = "log_format";
    public static final String FIELD_LOG_TRANSPORT = "log_transport";
    public static final String FIELD_LOG_TRANSFER = "log_transfer";
    public static final String FIELD_LOG_LIMIT = "log_limit";
    public static final String FIELD_LOG_COUNT_INSERTS = "log_count_inserts";
    public static final String FIELD_LOG_COUNT_UPDATES = "log_count_updates";
    public static final String FIELD_LOG_COUNT_DELETES = "log_count_deletes";
    public static final String FIELD_LOG_COUNT_ERRORS = "log_count_errors";
    public static final String FIELD_LOG_COUNT_WARNINGS = "log_count_warnings";
    public static final String FIELD_LOG_COUNT_NOTICES = "log_count_notices";
    public static final String FIELD_LOG_TIME = "log_time";
    public static final String TABLE_EXPORTS_ENTRIES = "immotool_agency_exports_entries";
    public static final String TABLE_EXPORTS_LOGS_ENTRIES = "immotool_agency_exports_logs_entries";
    public static final String TABLE_EXPORTS_LOGS_MESSAGES = "immotool_agency_exports_logs_messages";
    public static final String FIELD_ENTRY_OBJECT_ID = "entry_object_id";
    public static final String FIELD_ENTRY_OBJECT_NR = "entry_object_nr";
    public static final String FIELD_ENTRY_ACTION = "entry_action";
    public static final String FIELD_ENTRY_EXPORTED = "entry_exported";
    public static final String FIELD_MESSAGE_LEVEL = "message_level";
    public static final String FIELD_MESSAGE_CODE = "message_code";
    public static final String FIELD_MESSAGE_TEXT = "message_text";
    public static final String TABLE_EXPORTS_PUBLISHINGS = "immotool_agency_exports_publishings";
    public static final String FIELD_PUBLISHING_OBJECT_ID = "publishing_object_id";
    public static final String FIELD_PUBLISHING_OBJECT_NR = "publishing_object_nr";
    public static final String FIELD_PUBLISHING_OBJECT_KEY = "publishing_object_key";
    public static final String FIELD_PUBLISHING_HASH = "publishing_hash";
    public static final String FIELD_PUBLISHING_TIME = "publishing_time";
    public static final String TABLE_EXPORTS_SETTINGS = "immotool_agency_exports_settings";
    public static final String FIELD_SETTING_KEY = "setting_key";
    public static final String FIELD_SETTING_VALUE = "setting_value";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    private static DbAgencyExport createExport(ResultSet resultSet) throws SQLException {
        DbAgencyExport dbAgencyExport = new DbAgencyExport();
        dbAgencyExport.id = resultSet.getLong(FIELD_EXPORT_ID);
        dbAgencyExport.exposeId = resultSet.getLong(FIELD_EXPORT_EXPOSE_ID);
        dbAgencyExport.searchId = resultSet.getLong(FIELD_EXPORT_SEARCH_ID);
        dbAgencyExport.name = resultSet.getString(FIELD_EXPORT_NAME);
        dbAgencyExport.notes = resultSet.getString(FIELD_EXPORT_NOTES);
        dbAgencyExport.enabled = resultSet.getBoolean(FIELD_EXPORT_ENABLED);
        dbAgencyExport.limit = resultSet.getInt(FIELD_EXPORT_LIMIT);
        dbAgencyExport.lastExecution = resultSet.getTimestamp(FIELD_EXPORT_LAST_EXECUTION);
        dbAgencyExport.lockTime = resultSet.getTimestamp(FIELD_EXPORT_LOCK_TIME);
        dbAgencyExport.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbAgencyExport.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbAgencyExport.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbAgencyExport.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbAgencyExport.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        dbAgencyExport.setFormat(StringUtils.trimToNull((String)resultSet.getString(FIELD_EXPORT_FORMAT)));
        dbAgencyExport.setTransport(StringUtils.trimToNull((String)resultSet.getString(FIELD_EXPORT_TRANSPORT)));
        String string = resultSet.getString(FIELD_EXPORT_TRANSFER);
        if (StringUtils.isBlank((CharSequence)string)) {
            LOGGER.warn("Transfer mode is empty for export interface #" + dbAgencyExport.id + "!");
            dbAgencyExport.transferMode = AbstractFormat.TransferMode.FULL;
        } else {
            try {
                dbAgencyExport.transferMode = AbstractFormat.TransferMode.valueOf(string);
            }
            catch (Exception exception) {
                LOGGER.warn("Transfer mode '" + string + "' is invalid for export interface #" + dbAgencyExport.id + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                dbAgencyExport.transferMode = AbstractFormat.TransferMode.FULL;
            }
        }
        return dbAgencyExport;
    }

    private static DbAgencyExportLog createExportLog(ResultSet resultSet) throws SQLException {
        DbAgencyExportLog dbAgencyExportLog = new DbAgencyExportLog();
        dbAgencyExportLog.id = resultSet.getLong(FIELD_LOG_ID);
        dbAgencyExportLog.exportId = resultSet.getLong(FIELD_EXPORT_ID);
        dbAgencyExportLog.format = resultSet.getString(FIELD_LOG_FORMAT);
        dbAgencyExportLog.transport = resultSet.getString(FIELD_LOG_TRANSPORT);
        dbAgencyExportLog.limit = resultSet.getInt(FIELD_LOG_LIMIT);
        dbAgencyExportLog.countInserts = resultSet.getInt(FIELD_LOG_COUNT_INSERTS);
        dbAgencyExportLog.countUpdates = resultSet.getInt(FIELD_LOG_COUNT_UPDATES);
        dbAgencyExportLog.countDeletes = resultSet.getInt(FIELD_LOG_COUNT_DELETES);
        dbAgencyExportLog.countErrors = resultSet.getInt(FIELD_LOG_COUNT_ERRORS);
        dbAgencyExportLog.countWarnings = resultSet.getInt(FIELD_LOG_COUNT_WARNINGS);
        dbAgencyExportLog.countNotices = resultSet.getInt(FIELD_LOG_COUNT_NOTICES);
        dbAgencyExportLog.time = resultSet.getTimestamp(FIELD_LOG_TIME);
        String string = resultSet.getString(FIELD_LOG_TRANSFER);
        if (StringUtils.isBlank((CharSequence)string)) {
            LOGGER.warn("Transfer mode is empty for export interface #" + dbAgencyExportLog.id + "!");
            dbAgencyExportLog.transferMode = AbstractFormat.TransferMode.FULL;
        } else {
            try {
                dbAgencyExportLog.transferMode = AbstractFormat.TransferMode.valueOf(string);
            }
            catch (Exception exception) {
                LOGGER.warn("Transfer mode '" + string + "' is invalid for export log #" + dbAgencyExportLog.id + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                dbAgencyExportLog.transferMode = AbstractFormat.TransferMode.FULL;
            }
        }
        return dbAgencyExportLog;
    }

    private static DbAgencyExportLogEntry createExportLogEntry(ResultSet resultSet) throws SQLException {
        DbAgencyExportLogEntry dbAgencyExportLogEntry = new DbAgencyExportLogEntry();
        dbAgencyExportLogEntry.logId = resultSet.getLong(FIELD_LOG_ID);
        dbAgencyExportLogEntry.objectId = resultSet.getLong(FIELD_ENTRY_OBJECT_ID);
        dbAgencyExportLogEntry.objectNr = resultSet.getString(FIELD_ENTRY_OBJECT_NR);
        dbAgencyExportLogEntry.exported = resultSet.getBoolean(FIELD_ENTRY_EXPORTED);
        try {
            dbAgencyExportLogEntry.action = DbAgencyExportAction.valueOf(resultSet.getString(FIELD_ENTRY_ACTION));
        }
        catch (Exception exception) {
            dbAgencyExportLogEntry.action = null;
            LOGGER.warn("Unknown entry-action for export-log #" + dbAgencyExportLogEntry.logId + " / object #" + dbAgencyExportLogEntry.objectId);
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbAgencyExportLogEntry;
    }

    private static DbAgencyExportLogMessage createExportLogMessage(ResultSet resultSet) throws SQLException {
        DbAgencyExportLogMessage dbAgencyExportLogMessage = new DbAgencyExportLogMessage();
        dbAgencyExportLogMessage.logId = resultSet.getLong(FIELD_LOG_ID);
        dbAgencyExportLogMessage.objectId = resultSet.getLong(FIELD_ENTRY_OBJECT_ID);
        dbAgencyExportLogMessage.code = resultSet.getString(FIELD_MESSAGE_CODE);
        dbAgencyExportLogMessage.text = resultSet.getString(FIELD_MESSAGE_TEXT);
        try {
            dbAgencyExportLogMessage.level = DbAgencyExportLogMessage.Level.valueOf(resultSet.getString(FIELD_MESSAGE_LEVEL));
        }
        catch (Exception exception) {
            dbAgencyExportLogMessage.level = null;
            LOGGER.warn("Unknown message-level for export-log #" + dbAgencyExportLogMessage.logId + " / object #" + dbAgencyExportLogMessage.objectId);
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbAgencyExportLogMessage;
    }

    private static DbAgencyExportPublishing createExportPublishing(ResultSet resultSet) throws SQLException {
        DbAgencyExportPublishing dbAgencyExportPublishing = new DbAgencyExportPublishing();
        dbAgencyExportPublishing.exportId = resultSet.getLong(FIELD_EXPORT_ID);
        dbAgencyExportPublishing.objectId = resultSet.getLong(FIELD_PUBLISHING_OBJECT_ID);
        dbAgencyExportPublishing.objectNr = resultSet.getString(FIELD_PUBLISHING_OBJECT_NR);
        dbAgencyExportPublishing.objectKey = resultSet.getString(FIELD_PUBLISHING_OBJECT_KEY);
        dbAgencyExportPublishing.hash = resultSet.getString(FIELD_PUBLISHING_HASH);
        dbAgencyExportPublishing.time = resultSet.getTimestamp(FIELD_PUBLISHING_TIME);
        return dbAgencyExportPublishing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExport[] getExports(Connection connection, long[] lArray) throws SQLException {
        DbAgencyExport[] dbAgencyExportArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbAgencyExport[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports ORDER BY export_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports WHERE export_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_EXPORT_NAME + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExport> arrayList = new ArrayList<DbAgencyExport>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExportsHandler.createExport(resultSet));
            }
            dbAgencyExportArray = arrayList.toArray(new DbAgencyExport[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExportArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExport[] getExports(Connection connection, Boolean bl) throws SQLException {
        DbAgencyExport[] dbAgencyExportArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports ORDER BY export_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports WHERE export_enabled = ? ORDER BY export_name ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExport> arrayList = new ArrayList<DbAgencyExport>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExportsHandler.createExport(resultSet));
            }
            dbAgencyExportArray = arrayList.toArray(new DbAgencyExport[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExportArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExport[] getExportsForObject(Connection connection, long l, DbAgencyObject.ExportMode exportMode) throws SQLException {
        DbAgencyExport[] dbAgencyExportArray;
        if (DbAgencyObject.ExportMode.ALL.equals((Object)exportMode)) {
            return this.getExports(connection, true);
        }
        if (!DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)exportMode) && !DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)exportMode)) {
            return new DbAgencyExport[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT export_id FROM view_immotool_agency_objects_exports WHERE object_id = ?";
            if (DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)exportMode)) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports WHERE export_id IN (" + string + ") AND " + FIELD_EXPORT_ENABLED + " = ? ORDER BY " + FIELD_EXPORT_NAME + " ASC;");
            } else if (DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)exportMode)) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports WHERE export_id NOT IN (" + string + ") AND " + FIELD_EXPORT_ENABLED + " = ? ORDER BY " + FIELD_EXPORT_NAME + " ASC;");
            } else {
                throw new SQLException("Invalid export-mode: " + (Object)((Object)exportMode) + "!");
            }
            int n = 0;
            preparedStatement.setLong(++n, l);
            preparedStatement.setBoolean(++n, true);
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExport> arrayList = new ArrayList<DbAgencyExport>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExportsHandler.createExport(resultSet));
            }
            dbAgencyExportArray = arrayList.toArray(new DbAgencyExport[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExportArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getExportIds(Connection connection) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT export_id FROM view_immotool_agency_exports ORDER BY export_id ASC;");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_EXPORT_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExportLog[] getExportLogs(Connection connection, long l) throws SQLException {
        DbAgencyExportLog[] dbAgencyExportLogArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs ORDER BY log_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs WHERE export_id = ? ORDER BY log_id ASC;");
                preparedStatement.setLong(1, l);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExportLog> arrayList = new ArrayList<DbAgencyExportLog>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExportsHandler.createExportLog(resultSet));
            }
            dbAgencyExportLogArray = arrayList.toArray(new DbAgencyExportLog[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExportLogArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExportLog[] getExportLogs(Connection connection, long[] lArray) throws SQLException {
        DbAgencyExportLog[] dbAgencyExportLogArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbAgencyExportLog[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs ORDER BY log_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs WHERE log_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_LOG_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExportLog> arrayList = new ArrayList<DbAgencyExportLog>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExportsHandler.createExportLog(resultSet));
            }
            dbAgencyExportLogArray = arrayList.toArray(new DbAgencyExportLog[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExportLogArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExportLog[] getExportLogsForObject(Connection connection, long l) throws SQLException {
        DbAgencyExportLog[] dbAgencyExportLogArray;
        if (l < 1L) {
            return new DbAgencyExportLog[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs WHERE log_id IN ( SELECT DISTINCT log_id FROM view_immotool_agency_exports_logs_entries WHERE entry_object_id = ? ) ORDER BY log_id ASC;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyExportLog> arrayList = new ArrayList<DbAgencyExportLog>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbAgencyExportsHandler.createExportLog(resultSet));
            }
            dbAgencyExportLogArray = arrayList.toArray(new DbAgencyExportLog[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExportLogArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getExportLogIds(Connection connection, long l) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT log_id FROM view_immotool_agency_exports_logs ORDER BY log_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT log_id FROM view_immotool_agency_exports_logs WHERE export_id = ? ORDER BY log_id ASC;");
                preparedStatement.setLong(1, l);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_LOG_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyExportLog getLatestExportLog(Connection connection, long l) throws SQLException {
        DbAgencyExportLog dbAgencyExportLog;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs ORDER BY log_id DESC LIMIT 1;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs WHERE export_id = ? ORDER BY log_id DESC LIMIT 1;");
                preparedStatement.setLong(1, l);
            }
            resultSet = preparedStatement.executeQuery();
            dbAgencyExportLog = resultSet.next() ? HSqlDbAgencyExportsHandler.createExportLog(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyExportLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadExportLogEntries(Connection connection, DbAgencyExportLog[] dbAgencyExportLogArray) throws SQLException {
        HashMap<Long, DbAgencyExportLog> hashMap = new HashMap<Long, DbAgencyExportLog>();
        for (DbAgencyExportLog dbAgencyExportLog : dbAgencyExportLogArray) {
            if (dbAgencyExportLog.id <= 0L || hashMap.containsKey(dbAgencyExportLog.id)) continue;
            hashMap.put(dbAgencyExportLog.id, dbAgencyExportLog);
            if (dbAgencyExportLog.entries != null) {
                dbAgencyExportLog.entries.clear();
                continue;
            }
            dbAgencyExportLog.entries = new HashMap<Long, DbAgencyExportLogEntry>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs_entries WHERE log_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_LOG_ID + " ASC, " + FIELD_ENTRY_OBJECT_ID + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DbAgencyExportLogEntry dbAgencyExportLogEntry = HSqlDbAgencyExportsHandler.createExportLogEntry(resultSet);
                ((DbAgencyExportLog)hashMap.get((Object)Long.valueOf((long)dbAgencyExportLogEntry.logId))).entries.put(dbAgencyExportLogEntry.objectId, dbAgencyExportLogEntry);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadExportLogMessages(Connection connection, DbAgencyExportLog[] dbAgencyExportLogArray) throws SQLException {
        HashMap<Long, DbAgencyExportLog> hashMap = new HashMap<Long, DbAgencyExportLog>();
        for (DbAgencyExportLog dbAgencyExportLog : dbAgencyExportLogArray) {
            if (dbAgencyExportLog.id <= 0L || hashMap.containsKey(dbAgencyExportLog.id)) continue;
            hashMap.put(dbAgencyExportLog.id, dbAgencyExportLog);
            if (dbAgencyExportLog.messages != null) {
                dbAgencyExportLog.messages.clear();
                continue;
            }
            dbAgencyExportLog.messages = new ArrayList<DbAgencyExportLogMessage>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_logs_messages WHERE log_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_LOG_ID + " ASC, " + FIELD_ENTRY_OBJECT_ID + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DbAgencyExportLogMessage dbAgencyExportLogMessage = HSqlDbAgencyExportsHandler.createExportLogMessage(resultSet);
                ((DbAgencyExportLog)hashMap.get((Object)Long.valueOf((long)dbAgencyExportLogMessage.logId))).messages.add(dbAgencyExportLogMessage);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadExportPublishings(Connection connection, DbAgencyExport[] dbAgencyExportArray) throws SQLException {
        HashMap<Long, DbAgencyExport> hashMap = new HashMap<Long, DbAgencyExport>();
        for (DbAgencyExport dbAgencyExport : dbAgencyExportArray) {
            if (dbAgencyExport.id <= 0L || hashMap.containsKey(dbAgencyExport.id)) continue;
            hashMap.put(dbAgencyExport.id, dbAgencyExport);
            if (dbAgencyExport.publishings != null) {
                dbAgencyExport.publishings.clear();
                continue;
            }
            dbAgencyExport.publishings = new HashMap<Long, DbAgencyExportPublishing>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_publishings WHERE export_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_EXPORT_ID + " ASC, " + FIELD_PUBLISHING_OBJECT_ID + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DbAgencyExportPublishing dbAgencyExportPublishing = HSqlDbAgencyExportsHandler.createExportPublishing(resultSet);
                ((DbAgencyExport)hashMap.get((Object)Long.valueOf((long)dbAgencyExportPublishing.exportId))).publishings.put(dbAgencyExportPublishing.objectId, dbAgencyExportPublishing);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadExportSettings(Connection connection, DbAgencyExport[] dbAgencyExportArray) throws SQLException {
        HashMap<Long, DbAgencyExport> hashMap = new HashMap<Long, DbAgencyExport>();
        for (DbAgencyExport dbAgencyExport : dbAgencyExportArray) {
            if (dbAgencyExport.id <= 0L || hashMap.containsKey(dbAgencyExport.id)) continue;
            hashMap.put(dbAgencyExport.id, dbAgencyExport);
            if (dbAgencyExport.format != null) {
                dbAgencyExport.format.clear();
            }
            if (dbAgencyExport.transport != null) {
                dbAgencyExport.transport.clear();
            }
            dbAgencyExport.initDefaults();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_exports_settings WHERE export_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_EXPORT_ID + " ASC, " + FIELD_SETTING_KEY + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(FIELD_EXPORT_ID);
                String string = resultSet.getString(FIELD_SETTING_KEY);
                String string2 = StringUtils.trimToNull((String)resultSet.getString(FIELD_SETTING_VALUE));
                if (!hashMap.containsKey(l)) continue;
                DbAgencyExport dbAgencyExport = (DbAgencyExport)hashMap.get(l);
                if (string2 == null) continue;
                dbAgencyExport.putSetting(string, string2);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    @Override
    public void removeExports(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_agency_exports(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeExportLogs(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_agency_exports_logs(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeExportPublishings(Connection connection, long l, long[] lArray) throws SQLException {
        if (l < 1L) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_agency_exports_publishings(:export_id, :publishing_object_id);");
            if (lArray == null) {
                namedCallableStatement.setLong(FIELD_EXPORT_ID, l);
                namedCallableStatement.setNull(FIELD_PUBLISHING_OBJECT_ID, -5);
                namedCallableStatement.execute();
            } else {
                for (long l2 : lArray) {
                    namedCallableStatement.clearParameters();
                    namedCallableStatement.setLong(FIELD_EXPORT_ID, l);
                    namedCallableStatement.setLong(FIELD_PUBLISHING_OBJECT_ID, l2);
                    namedCallableStatement.execute();
                }
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveExport(Connection connection, DbAgencyExport dbAgencyExport, boolean bl, boolean bl2) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl3;
        block26: {
            bl3 = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                Object object;
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_exports(:export_id, :search_id, :expose_id, :export_name, :export_enabled, :export_format, :export_transport, :export_transfer, :export_limit, :export_last_execution, :export_lock_time, :export_notes, :access_owner_id, :access_group_id, :access_permissions);");
                namedCallableStatement.setLong(FIELD_EXPORT_ID, dbAgencyExport.id);
                if (dbAgencyExport.searchId > 0L) {
                    namedCallableStatement.setLong(FIELD_EXPORT_SEARCH_ID, dbAgencyExport.searchId);
                } else {
                    namedCallableStatement.setNull(FIELD_EXPORT_SEARCH_ID, -5);
                }
                if (dbAgencyExport.exposeId > 0L) {
                    namedCallableStatement.setLong(FIELD_EXPORT_EXPOSE_ID, dbAgencyExport.exposeId);
                } else {
                    namedCallableStatement.setNull(FIELD_EXPORT_EXPOSE_ID, -5);
                }
                namedCallableStatement.setBoolean(FIELD_EXPORT_ENABLED, dbAgencyExport.enabled);
                namedCallableStatement.setInt(FIELD_EXPORT_LIMIT, dbAgencyExport.limit);
                namedCallableStatement.setString(FIELD_EXPORT_NAME, StringUtils.abbreviate((String)dbAgencyExport.name, (int)100));
                namedCallableStatement.setString(FIELD_EXPORT_NOTES, StringUtils.trimToNull((String)dbAgencyExport.notes));
                namedCallableStatement.setString(FIELD_EXPORT_FORMAT, StringUtils.abbreviate((String)dbAgencyExport.getFormatName(), (int)255));
                namedCallableStatement.setString(FIELD_EXPORT_TRANSPORT, StringUtils.abbreviate((String)dbAgencyExport.getTransportName(), (int)255));
                if (dbAgencyExport.transferMode != null) {
                    namedCallableStatement.setString(FIELD_EXPORT_TRANSFER, StringUtils.abbreviate((String)dbAgencyExport.transferMode.name(), (int)255));
                } else {
                    namedCallableStatement.setNull(FIELD_EXPORT_TRANSFER, 12);
                }
                if (dbAgencyExport.lastExecution != null) {
                    namedCallableStatement.setTimestamp(FIELD_EXPORT_LAST_EXECUTION, new Timestamp(dbAgencyExport.lastExecution.getTime()));
                } else {
                    namedCallableStatement.setNull(FIELD_EXPORT_LAST_EXECUTION, 93);
                }
                if (dbAgencyExport.lockTime != null) {
                    namedCallableStatement.setTimestamp(FIELD_EXPORT_LOCK_TIME, new Timestamp(dbAgencyExport.lockTime.getTime()));
                } else {
                    namedCallableStatement.setNull(FIELD_EXPORT_LOCK_TIME, 93);
                }
                namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbAgencyExport.ownerUserId);
                namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbAgencyExport.ownerGroupId);
                namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbAgencyExport.permission != null ? dbAgencyExport.permission.getValue() : -1);
                namedCallableStatement.execute();
                long l2 = l = dbAgencyExport.id < 1L ? namedCallableStatement.getLong(FIELD_EXPORT_ID) : dbAgencyExport.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (bl) {
                    if (dbAgencyExport.id > 0L) {
                        object = new NamedCallableStatement(connection, "CALL remove_immotool_agency_exports_settings(:export_id, :setting_key);");
                        object.setLong(FIELD_EXPORT_ID, dbAgencyExport.id);
                        object.setNull(FIELD_SETTING_KEY, 12);
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                    object = new NamedCallableStatement(connection, "CALL save_immotool_agency_exports_settings(:export_id, :setting_key, :setting_value);");
                    for (Map.Entry<String, String> entry : dbAgencyExport.getSettings().entrySet()) {
                        String string = entry.getKey();
                        String string2 = StringUtils.trimToNull((String)entry.getValue());
                        if (string2 == null) continue;
                        object.clearParameters();
                        object.setLong(FIELD_EXPORT_ID, l);
                        object.setString(FIELD_SETTING_KEY, StringUtils.abbreviate((String)string, (int)255));
                        object.setString(FIELD_SETTING_VALUE, string2);
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                }
                if (bl2 && dbAgencyExport.publishings != null) {
                    if (dbAgencyExport.id > 0L) {
                        object = new NamedCallableStatement(connection, "CALL remove_immotool_agency_exports_publishings(:export_id, :publishing_object_id);");
                        object.setLong(FIELD_EXPORT_ID, dbAgencyExport.id);
                        object.setNull(FIELD_PUBLISHING_OBJECT_ID, -5);
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                    object = new NamedCallableStatement(connection, "CALL save_immotool_agency_exports_publishings(:export_id, :publishing_object_id, :publishing_object_nr, :publishing_object_key, :publishing_hash, :publishing_time);");
                    for (DbAgencyExportPublishing dbAgencyExportPublishing : dbAgencyExport.publishings.values()) {
                        object.clearParameters();
                        object.setLong(FIELD_EXPORT_ID, l);
                        object.setLong(FIELD_PUBLISHING_OBJECT_ID, dbAgencyExportPublishing.objectId);
                        object.setString(FIELD_PUBLISHING_OBJECT_NR, StringUtils.abbreviate((String)dbAgencyExportPublishing.objectNr, (int)255));
                        object.setString(FIELD_PUBLISHING_OBJECT_KEY, StringUtils.abbreviate((String)dbAgencyExportPublishing.objectKey, (int)255));
                        object.setString(FIELD_PUBLISHING_HASH, StringUtils.abbreviate((String)dbAgencyExportPublishing.hash, (int)40));
                        if (dbAgencyExportPublishing.time != null) {
                            object.setTimestamp(FIELD_PUBLISHING_TIME, new Timestamp(dbAgencyExportPublishing.time.getTime()));
                        } else {
                            object.setNull(FIELD_PUBLISHING_TIME, 93);
                        }
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                }
                connection.commit();
                if (dbAgencyExport.id >= 1L) break block26;
                dbAgencyExport.id = l;
                if (dbAgencyExport.publishings == null) break block26;
                for (DbAgencyExportPublishing dbAgencyExportPublishing : dbAgencyExport.publishings.values()) {
                    dbAgencyExportPublishing.exportId = dbAgencyExport.id;
                }
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl3);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl3);
    }

    @Override
    public void saveExportLog(Connection connection, DbAgencyExportLog dbAgencyExportLog) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block18: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                Object object;
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_exports_logs(:log_id, :export_id, :log_format, :log_transport, :log_transfer, :log_limit, :log_count_inserts, :log_count_updates, :log_count_deletes, :log_count_errors, :log_count_warnings, :log_count_notices, :log_time);");
                namedCallableStatement.setLong(FIELD_LOG_ID, dbAgencyExportLog.id);
                namedCallableStatement.setLong(FIELD_EXPORT_ID, dbAgencyExportLog.exportId);
                namedCallableStatement.setString(FIELD_LOG_FORMAT, StringUtils.abbreviate((String)dbAgencyExportLog.format, (int)100));
                namedCallableStatement.setString(FIELD_LOG_TRANSPORT, StringUtils.abbreviate((String)dbAgencyExportLog.transport, (int)100));
                namedCallableStatement.setString(FIELD_LOG_TRANSFER, StringUtils.abbreviate((String)(dbAgencyExportLog.transferMode != null ? dbAgencyExportLog.transferMode.name() : AbstractFormat.TransferMode.FULL.name()), (int)100));
                namedCallableStatement.setInt(FIELD_LOG_LIMIT, dbAgencyExportLog.limit);
                namedCallableStatement.setInt(FIELD_LOG_COUNT_INSERTS, dbAgencyExportLog.countInserts);
                namedCallableStatement.setInt(FIELD_LOG_COUNT_UPDATES, dbAgencyExportLog.countUpdates);
                namedCallableStatement.setInt(FIELD_LOG_COUNT_DELETES, dbAgencyExportLog.countDeletes);
                namedCallableStatement.setInt(FIELD_LOG_COUNT_ERRORS, dbAgencyExportLog.countErrors);
                namedCallableStatement.setInt(FIELD_LOG_COUNT_WARNINGS, dbAgencyExportLog.countWarnings);
                namedCallableStatement.setInt(FIELD_LOG_COUNT_NOTICES, dbAgencyExportLog.countNotices);
                if (dbAgencyExportLog.time != null) {
                    namedCallableStatement.setTimestamp(FIELD_LOG_TIME, new Timestamp(dbAgencyExportLog.time.getTime()));
                } else {
                    namedCallableStatement.setNull(FIELD_LOG_TIME, 93);
                }
                namedCallableStatement.execute();
                long l2 = l = dbAgencyExportLog.id < 1L ? namedCallableStatement.getLong(FIELD_LOG_ID) : dbAgencyExportLog.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (dbAgencyExportLog.entries != null) {
                    if (dbAgencyExportLog.id > 0L) {
                        object = new NamedCallableStatement(connection, "CALL remove_immotool_agency_exports_logs_entries(:log_id, :entry_object_id);");
                        object.setLong(FIELD_LOG_ID, dbAgencyExportLog.id);
                        object.setNull(FIELD_ENTRY_OBJECT_ID, -5);
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                    object = new NamedCallableStatement(connection, "CALL save_immotool_agency_exports_logs_entries(:log_id, :entry_object_id, :entry_object_nr, :entry_action, :entry_exported);");
                    for (DbAgencyExportLogEntry dbAgencyExportLogEntry : dbAgencyExportLog.entries.values()) {
                        object.clearParameters();
                        object.setLong(FIELD_LOG_ID, l);
                        object.setLong(FIELD_ENTRY_OBJECT_ID, dbAgencyExportLogEntry.objectId);
                        object.setBoolean(FIELD_ENTRY_EXPORTED, dbAgencyExportLogEntry.exported);
                        object.setString(FIELD_ENTRY_OBJECT_NR, StringUtils.abbreviate((String)dbAgencyExportLogEntry.objectNr, (int)255));
                        object.setString(FIELD_ENTRY_ACTION, dbAgencyExportLogEntry.action != null ? StringUtils.abbreviate((String)dbAgencyExportLogEntry.action.name(), (int)10) : null);
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                }
                if (dbAgencyExportLog.messages != null) {
                    if (dbAgencyExportLog.id > 0L) {
                        object = new NamedCallableStatement(connection, "CALL remove_immotool_agency_exports_logs_messages(:log_id, :entry_object_id);");
                        object.setLong(FIELD_LOG_ID, dbAgencyExportLog.id);
                        object.setNull(FIELD_ENTRY_OBJECT_ID, -5);
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                    object = new NamedCallableStatement(connection, "CALL save_immotool_agency_exports_logs_messages(:log_id, :entry_object_id, :message_level, :message_code, :message_text);");
                    for (DbAgencyExportLogMessage dbAgencyExportLogMessage : dbAgencyExportLog.messages) {
                        object.clearParameters();
                        object.setLong(FIELD_LOG_ID, l);
                        object.setLong(FIELD_ENTRY_OBJECT_ID, dbAgencyExportLogMessage.objectId);
                        object.setString(FIELD_MESSAGE_LEVEL, dbAgencyExportLogMessage.level != null ? dbAgencyExportLogMessage.level.name() : DbAgencyExportLogMessage.Level.NOTICE.name());
                        object.setString(FIELD_MESSAGE_CODE, StringUtils.abbreviate((String)dbAgencyExportLogMessage.code, (int)255));
                        object.setString(FIELD_MESSAGE_TEXT, dbAgencyExportLogMessage.text);
                        object.execute();
                        arrayList.add(object.getStatement());
                    }
                }
                connection.commit();
                if (dbAgencyExportLog.id > 0L) break block18;
                dbAgencyExportLog.id = l;
                if (dbAgencyExportLog.entries != null) {
                    for (DbAgencyExportLogEntry dbAgencyExportLogEntry : dbAgencyExportLog.entries.values()) {
                        dbAgencyExportLogEntry.logId = dbAgencyExportLog.id;
                    }
                }
                if (dbAgencyExportLog.messages == null) break block18;
                for (DbAgencyExportLogMessage dbAgencyExportLogMessage : dbAgencyExportLog.messages) {
                    dbAgencyExportLogMessage.logId = dbAgencyExportLog.id;
                }
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    @Override
    public void setExportsEnabled(Connection connection, long[] lArray, boolean bl) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL set_immotool_agency_exports_enabled(:export_id, :export_enabled);");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_EXPORT_ID, l);
                namedCallableStatement.setBoolean(FIELD_EXPORT_ENABLED, bl);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }
}

