/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.ExportProcess;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.HttpTransport;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.agency.export.SftpTransport;
import com.openindex.openestate.tool.agency.extensions.ExportExtension;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractFormat
extends HashMap<String, String> {
    private static final I18n I18N = I18nFactory.getI18n(AbstractFormat.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFormat.class);
    private static final String LANGUAGE = "language";
    private static final String COMPRESSION = "compression";
    private static final String AGENT_ID = "agent.id";
    private static final String AGENT_MAIL = "agent.mail";
    private static final String ATTACHMENT_MIMETYPE = "attachment.mimetype";
    private static final String ATTACHMENT_MODE = "attachment.mode";
    private static final String ATTACHMENT_IMAGE_SCALE = "attachment.image.scale";
    private static final String ATTACHMENT_IMAGE_SCALE_WIDTH = "attachment.image.scale.width";
    private static final String ATTACHMENT_IMAGE_SCALE_HEIGHT = "attachment.image.scale.height";
    private static final String PROPERTY_PREFIX = "property.prefix";
    private static final String PROPERTY_PUBLIC_ID = "property.publicId";
    private static final String PROPERTY_ADDRESS_PUBLICATION = "property.address.publication";
    private static final String PROPERTY_ADDRESS_HIDE_UNPUBLISHED = "property.address.hideUnpublished";
    private static final String PROPERTY_DESCRIPTION_WITH_ENERGY_CERTIFICATE = "property.description.withEnergyCertificate";
    private static final String PROPERTY_PRICE_PUBLICATION = "property.price.publication";
    private static final String PROPERTY_PRICE_HIDE_UNPUBLISHED = "property.price.hideUnpublished";
    private static final String PROPERTY_LINK_PUBLICATION = "property.link.publication";
    private static final String PROPERTY_LINK_HIDE_UNPUBLISHED = "property.link.hideUnpublished";
    private static final String PROPERTY_FILE_PUBLICATION = "property.file.publication";
    private static final String PROPERTY_FILE_HIDE_UNPUBLISHED = "property.file.hideUnpublished";
    private static final String PROPERTY_VIDEO_LIMIT = "property.video.limit";
    private static final String PROPERTY_IMAGE_LIMIT = "property.image.limit";
    private static final String PROPERTY_IMAGE_WATERMARK = "property.image.watermark";
    private static final String PROPERTY_IMAGE_WATERMARK_ALPHA = "property.image.watermark.alpha";
    private static final String PROPERTY_IMAGE_WATERMARK_POSITION = "property.image.watermark.position";
    private static final String PROPERTY_IMAGE_WATERMARK_WIDTH = "property.image.watermark.width";
    private static final String PROPERTY_IMAGE_WATERMARK_HEIGHT = "property.image.watermark.height";
    private static final String PROPERTY_IMAGE_WATERMARK_MARGIN = "property.image.watermark.margin";

    protected AbstractFormat() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws NotExportableException, HashCalculationException {
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new NotExportableException("Preparation failed!");
        }
        try (StringWriter stringWriter = new StringWriter();){
            OpenEstateUtils.serializeToXML((SerializableXmlElement)estateImpl, (Writer)stringWriter, (boolean)false, (String)"UTF-8", (String)"<br/>");
            String string = stringWriter.toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
            String string2 = DigestUtils.sha1Hex((String)string);
            return string2;
        }
        catch (Exception exception) {
            throw new HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    protected boolean canPublishAttachment(String string, EstateAttachmentImpl estateAttachmentImpl) {
        return true;
    }

    protected boolean canPublishLink(String string, EstateLinkImpl estateLinkImpl) {
        return true;
    }

    public ExportProcess createExportProcess() {
        return new ExportProcess();
    }

    public AbstractTransportRequest[] createExportRequests(AbstractTransport abstractTransport, File file, TransferMode transferMode) {
        if (abstractTransport == null) {
            throw new IllegalArgumentException("No transport was provided!");
        }
        if (abstractTransport instanceof LocalTransport) {
            return new AbstractTransportRequest[]{new LocalTransport.Request((LocalTransport)abstractTransport, file)};
        }
        if (abstractTransport instanceof FtpTransport) {
            return new AbstractTransportRequest[]{new FtpTransport.Request((FtpTransport)abstractTransport, file)};
        }
        if (abstractTransport instanceof SftpTransport) {
            return new AbstractTransportRequest[]{new SftpTransport.Request((SftpTransport)abstractTransport, file)};
        }
        if (abstractTransport instanceof HttpTransport) {
            return new AbstractTransportRequest[]{new HttpTransport.Request((HttpTransport)abstractTransport, file)};
        }
        throw new UnsupportedOperationException("The provided transport is unsupported.");
    }

    public abstract AbstractFormatPanel createSetupPanel();

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    public String getAgentId() {
        return StringUtils.trimToNull((String)((String)this.get(AGENT_ID)));
    }

    public String getAgentMail() {
        return StringUtils.trimToNull((String)((String)this.get(AGENT_MAIL)));
    }

    protected File getAttachmentDirectory(long l, EstateAttachmentImpl estateAttachmentImpl, File file) throws IOException {
        return file;
    }

    public int getAttachmentImageScaleHeight() {
        String string = StringUtils.trimToNull((String)((String)this.get(ATTACHMENT_IMAGE_SCALE_HEIGHT)));
        return string != null ? Integer.parseInt(string) : 0;
    }

    public int getAttachmentImageScaleWidth() {
        String string = StringUtils.trimToNull((String)((String)this.get(ATTACHMENT_IMAGE_SCALE_WIDTH)));
        return string != null ? Integer.parseInt(string) : 0;
    }

    public String[] getAttachmentMimeTypes() {
        String string = "attachment.mimetype.";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry entry : this.entrySet()) {
            String string2;
            String string3 = (String)entry.getKey();
            if (!string3.startsWith(string) || (string2 = StringUtils.trimToNull((String)((String)entry.getValue()))) == null) continue;
            arrayList.add(string2.toLowerCase());
        }
        return arrayList.toArray(new String[0]);
    }

    public AttachmentMode getAttachmentMode() {
        String string = StringUtils.trimToNull((String)((String)this.get(ATTACHMENT_MODE)));
        return string != null ? AttachmentMode.valueOf(string.toUpperCase()) : AttachmentMode.FILE;
    }

    protected String getCompressedFileName(Compression compression, ExportContext exportContext) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
        if (Compression.GZIP.equals((Object)compression)) {
            return "transfer-" + simpleDateFormat.format(exportContext.stamp) + ".gzip";
        }
        if (Compression.ZIP.equals((Object)compression)) {
            return "transfer-" + simpleDateFormat.format(exportContext.stamp) + ".zip";
        }
        return null;
    }

    public Compression getCompression() {
        String string = StringUtils.trimToNull((String)((String)this.get(COMPRESSION)));
        return string != null ? Compression.valueOf(string.toUpperCase()) : Compression.UNCOMPRESSED;
    }

    public static AbstractFormat getFormat(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (ExportExtension exportExtension : AgencyPluginUtils.getExportExtensions()) {
            Object[] objectArray = exportExtension.createFormats();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!((AbstractFormat)object).getName().equalsIgnoreCase(string)) continue;
                return object;
            }
        }
        return null;
    }

    public static Map<String, AbstractFormat> getFormats() {
        HashMap<String, AbstractFormat> hashMap = new HashMap<String, AbstractFormat>();
        for (ExportExtension exportExtension : AgencyPluginUtils.getExportExtensions()) {
            Object[] objectArray = exportExtension.createFormats();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                hashMap.put(((AbstractFormat)object).getName(), (AbstractFormat)object);
            }
        }
        return hashMap;
    }

    public Locale getLanguage() {
        Locale[] localeArray = this.getLanguages();
        return localeArray != null && localeArray.length > 0 ? localeArray[0] : null;
    }

    public Locale[] getLanguages() {
        String string = "language.";
        TreeMap<Integer, Locale> treeMap = new TreeMap<Integer, Locale>();
        for (Map.Entry entry : this.entrySet()) {
            int n;
            String string2;
            String string3 = (String)entry.getKey();
            if (!string3.startsWith(string) || (string2 = StringUtils.trimToNull((String)((String)entry.getValue()))) == null) continue;
            try {
                n = Integer.parseInt(string3.substring(string.length()));
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warn("Can't read index position from '" + string3 + "'!");
                LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                n = 999;
            }
            while (treeMap.containsKey(n)) {
                ++n;
            }
            treeMap.put(n, OpenEstateUtils.buildLocale((String)string2));
        }
        return treeMap.values().toArray(new Locale[0]);
    }

    public final String getMessageCodeTranslation(String string) {
        return this.getMessageCodeTranslation(string, null);
    }

    public String getMessageCodeTranslation(String string, Locale locale) {
        for (DefaultMessageCode defaultMessageCode : DefaultMessageCode.values()) {
            if (!defaultMessageCode.name().equalsIgnoreCase(string)) continue;
            return locale != null ? defaultMessageCode.getTranslation(locale) : defaultMessageCode.getTranslation();
        }
        return null;
    }

    public abstract String getName();

    protected final String getObjectKey(ExportEntry exportEntry) {
        return this.getObjectKey(exportEntry.objectId, exportEntry.objectNr);
    }

    public String getObjectKey(long l, String string) {
        String string2;
        String string3;
        String string4 = string3 = this.isPropertyPublicId() ? StringUtils.trimToNull((String)string) : null;
        if (string3 == null) {
            string3 = String.valueOf(l);
        }
        return (string2 = StringUtils.trimToNull((String)this.getPropertyPrefix())) != null ? string2 + "-" + string3 : string3;
    }

    protected String[] getPreferredMimeTypes() {
        return new String[]{"image/jpeg", "image/png", "image/gif"};
    }

    public PublishingMode getPropertyAddressPublication() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_ADDRESS_PUBLICATION)));
        return string != null ? PublishingMode.valueOf(string.toUpperCase()) : PublishingMode.DEFAULT;
    }

    public PublishingMode getPropertyFilePublication() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_FILE_PUBLICATION)));
        return string != null ? PublishingMode.valueOf(string.toUpperCase()) : PublishingMode.DEFAULT;
    }

    public int getPropertyImageLimit() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_IMAGE_LIMIT)));
        return string != null ? Integer.parseInt(string) : -1;
    }

    public int getPropertyImageWatermarkAlpha() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_IMAGE_WATERMARK_ALPHA)));
        return string != null ? Integer.parseInt(string) : 0;
    }

    public int getPropertyImageWatermarkHeight() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_IMAGE_WATERMARK_HEIGHT)));
        return string != null ? Integer.parseInt(string) : 0;
    }

    public int getPropertyImageWatermarkMargin() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_IMAGE_WATERMARK_MARGIN)));
        return string != null ? Integer.parseInt(string) : 0;
    }

    public ImageWatermarkPosition getPropertyImageWatermarkPosition() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_IMAGE_WATERMARK_POSITION)));
        return string != null ? ImageWatermarkPosition.valueOf(string.toUpperCase()) : null;
    }

    public int getPropertyImageWatermarkWidth() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_IMAGE_WATERMARK_WIDTH)));
        return string != null ? Integer.parseInt(string) : 0;
    }

    public PublishingMode getPropertyLinkPublication() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_LINK_PUBLICATION)));
        return string != null ? PublishingMode.valueOf(string.toUpperCase()) : PublishingMode.DEFAULT;
    }

    public String getPropertyPrefix() {
        return StringUtils.trimToNull((String)((String)this.get(PROPERTY_PREFIX)));
    }

    public PublishingMode getPropertyPricePublication() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_PRICE_PUBLICATION)));
        return string != null ? PublishingMode.valueOf(string.toUpperCase()) : PublishingMode.DEFAULT;
    }

    public int getPropertyVideoLimit() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_VIDEO_LIMIT)));
        return string != null ? Integer.parseInt(string) : -1;
    }

    public String[] getSupportedMimeTypes() {
        return new String[]{"application/octet-stream", "application/pdf", "application/rtf", "application/vnd.ms-excel", "application/vnd.ms-powerpoint", "application/x-gzip", "application/x-tar-gz", "application/x-zip-compressed", "application/zip", "audio/midi", "audio/mpeg", "audio/ogg", "audio/vorbis", "audio/x-ms-wma", "audio/x-ms-wmv", "audio/x-pn-realaudio", "audio/x-realaudio", "audio/x-wav", "image/bmp", "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/tiff", "text/html", "text/plain", "text/rtf", "text/xml", "video/avi", "video/flv", "video/mp4", "video/mpeg", "video/msvideo", "video/ogg", "video/quicktime", "video/vnd.rn-realvideo", "video/x-flv", "video/x-ms-asf", "video/x-ms-wmv", "video/x-msvideo", "video/x-sgi-movie"};
    }

    public abstract TransferMode[] getSupportedTransferModes();

    public abstract AbstractTransport[] getSupportedTransports();

    public abstract String getTitle();

    public String getVersion() {
        return null;
    }

    public boolean hasLanguage(Locale locale) {
        if (locale == null) {
            return false;
        }
        for (Locale locale2 : this.getLanguages()) {
            if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + super.hashCode();
    }

    public void initDefaults() {
        Object[] objectArray = this.getPreferredMimeTypes();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray2 = this.getSupportedMimeTypes();
            for (Object object : objectArray) {
                if (!ArrayUtils.contains((Object[])objectArray2, (Object)object)) continue;
                arrayList.add(object);
            }
            this.setAttachmentMimeTypes(arrayList.toArray(new String[0]));
        }
    }

    public boolean isAttachmentImageScale() {
        String string = StringUtils.trimToNull((String)((String)this.get(ATTACHMENT_IMAGE_SCALE)));
        return Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isFullTransferSupported() {
        return ArrayUtils.contains((Object[])this.getSupportedTransferModes(), (Object)((Object)TransferMode.FULL));
    }

    public boolean isFullTransportWarningShown() {
        return true;
    }

    public boolean isIncrementalTransferSupported() {
        return ArrayUtils.contains((Object[])this.getSupportedTransferModes(), (Object)((Object)TransferMode.INCREMENTAL));
    }

    public boolean isPropertyAddressHiddenIfUnpublished() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_ADDRESS_HIDE_UNPUBLISHED)));
        return Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPropertyDescriptionWithEnergyCertificate() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_DESCRIPTION_WITH_ENERGY_CERTIFICATE)));
        return Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPropertyFileHiddenIfUnpublished() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_FILE_HIDE_UNPUBLISHED)));
        return Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPropertyImageWatermark() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_IMAGE_WATERMARK)));
        return Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPropertyLinkHiddenIfUnpublished() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_LINK_HIDE_UNPUBLISHED)));
        return Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPropertyPriceHiddenIfUnpublished() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_PRICE_HIDE_UNPUBLISHED)));
        return Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPropertyPublicId() {
        String string = StringUtils.trimToNull((String)((String)this.get(PROPERTY_PUBLIC_ID)));
        return Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    @Deprecated
    public static Map<String, AbstractFormat> listAvailableExports() {
        return AbstractFormat.getFormats();
    }

    /*
     * WARNING - void declaration
     */
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        Object object;
        int n;
        Object[] objectArray;
        PublishingMode publishingMode;
        estateImpl.setId(this.getObjectKey(l, estateImpl.getPublicId()));
        String string = StringUtils.trimToNull((String)estateImpl.getPublicId());
        String string2 = StringUtils.trimToNull((String)this.getPropertyPrefix());
        if (string != null && string2 != null) {
            estateImpl.setPublicId(string2 + "-" + string);
        }
        if (PublishingMode.ALWAYS.equals((Object)(publishingMode = this.getPropertyAddressPublication()))) {
            estateImpl.getAddress().setPublished(true);
        } else if (PublishingMode.NEVER.equals((Object)publishingMode)) {
            estateImpl.getAddress().setPublished(false);
        }
        if (this.isPropertyAddressHiddenIfUnpublished() && !estateImpl.getAddress().isPublished()) {
            estateImpl.getAddress().setStreet(null);
            estateImpl.getAddress().setStreet2(null);
            estateImpl.getAddress().setStreetNr(null);
        }
        if (PublishingMode.ALWAYS.equals((Object)(publishingMode = this.getPropertyPricePublication()))) {
            estateImpl.setHiddenPrices(Boolean.valueOf(false));
        } else if (PublishingMode.NEVER.equals((Object)publishingMode)) {
            estateImpl.setHiddenPrices(Boolean.valueOf(true));
        }
        if (this.isPropertyPriceHiddenIfUnpublished() && estateImpl.isHiddenPrices()) {
            objectArray = estateImpl.getAttributes().values().toArray(new AbstractAttribImpl[0]);
            for (String string3 : objectArray) {
                if (string3 instanceof ComplexCurrencyAttrib) {
                    estateImpl.getAttributes().remove(string3.getAttrib());
                }
                estateImpl.getAttributes().remove(OpenEstateAttrib.DESCRIPTIONS_PRICE_DESCRIPTION);
            }
        }
        if (PublishingMode.NEVER.equals((Object)(publishingMode = this.getPropertyFilePublication()))) {
            estateImpl.getAttachments().clear();
        } else {
            objectArray = this.getAttachmentMimeTypes();
            int n2 = this.getPropertyImageLimit();
            int estateLinkImpl = this.getPropertyVideoLimit();
            n = 0;
            boolean string5 = false;
            object = new ArrayList();
            object.addAll(estateImpl.getAttachments());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                void var11_18;
                boolean bl;
                EstateAttachmentImpl estateAttachmentImpl = (EstateAttachmentImpl)iterator.next();
                if (PublishingMode.ALWAYS.equals((Object)publishingMode)) {
                    estateAttachmentImpl.setPublished(Boolean.valueOf(true));
                } else if (!estateAttachmentImpl.isPublished()) {
                    estateImpl.getAttachments().remove(estateAttachmentImpl);
                    continue;
                }
                String string4 = StringUtils.trimToNull((String)StringUtils.lowerCase((String)estateAttachmentImpl.getMimeType()));
                if (string4 == null) {
                    string4 = "application/octet-stream";
                }
                boolean bl2 = bl = string4.startsWith("image/") && ImageUtils.isReadableMimeType((String)string4);
                if (bl) {
                    if (!(ArrayUtils.contains((Object[])objectArray, (Object)string4) || ArrayUtils.contains((Object[])objectArray, (Object)"image/png") || ArrayUtils.contains((Object[])objectArray, (Object)"image/jpeg"))) {
                        estateImpl.getAttachments().remove(estateAttachmentImpl);
                        continue;
                    }
                } else if (!ArrayUtils.contains((Object[])objectArray, (Object)string4)) {
                    estateImpl.getAttachments().remove(estateAttachmentImpl);
                    continue;
                }
                estateAttachmentImpl.setMimeType(string4);
                if (!this.canPublishAttachment(estateImpl.getId(), estateAttachmentImpl)) {
                    estateImpl.getAttachments().remove(estateAttachmentImpl);
                    continue;
                }
                if (string4.startsWith("image/") && n2 > -1) {
                    if (n >= n2) {
                        estateImpl.getAttachments().remove(estateAttachmentImpl);
                        continue;
                    }
                    ++n;
                    continue;
                }
                if (!string4.startsWith("video/") || estateLinkImpl <= -1) continue;
                if (var11_18 >= estateLinkImpl) {
                    estateImpl.getAttachments().remove(estateAttachmentImpl);
                    continue;
                }
                ++var11_18;
            }
        }
        publishingMode = this.getPropertyLinkPublication();
        if (PublishingMode.NEVER.equals((Object)publishingMode)) {
            estateImpl.getLinks().clear();
        } else {
            objectArray = new ArrayList();
            objectArray.addAll(estateImpl.getLinks());
            for (EstateLinkImpl arrayList2 : objectArray) {
                if (PublishingMode.ALWAYS.equals((Object)publishingMode)) {
                    arrayList2.setPublished(Boolean.valueOf(true));
                }
                if (!arrayList2.isPublished()) {
                    estateImpl.getLinks().remove(arrayList2);
                    continue;
                }
                if (this.canPublishLink(estateImpl.getId(), arrayList2)) continue;
                estateImpl.getLinks().remove(arrayList2);
            }
        }
        objectArray = this.getLanguages();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            void estateLinkImpl;
            ArrayList arrayList = new ArrayList();
            Object[] objectArray2 = objectArray;
            n = objectArray2.length;
            boolean estateAttachmentImpl = false;
            while (estateLinkImpl < n) {
                object = objectArray2[estateLinkImpl];
                arrayList.add(((Locale)object).getLanguage().toLowerCase());
                ++estateLinkImpl;
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(estateImpl.getLanguages());
            estateImpl.getLanguages().clear();
            for (String abstractAttribImpl : arrayList2) {
                String string5 = abstractAttribImpl.toLowerCase();
                if (!arrayList.contains(string5)) continue;
                estateImpl.getLanguages().add(string5);
            }
            for (String string6 : estateImpl.getTitleLanguages()) {
                String string7 = string6.toLowerCase();
                if (estateImpl.getLanguages().contains(string7)) continue;
                estateImpl.setTitle(null, string7);
            }
            for (EstateAttachmentImpl estateAttachmentImpl2 : estateImpl.getAttachments()) {
                for (String string4 : estateAttachmentImpl2.getTitleLanguages()) {
                    string4 = string4.toLowerCase();
                    if (estateImpl.getLanguages().contains(string4)) continue;
                    estateAttachmentImpl2.setTitle(null, string4);
                }
            }
            for (EstateLinkImpl estateLinkImpl2 : estateImpl.getLinks()) {
                for (String string4 : estateLinkImpl2.getTitleLanguages()) {
                    string4 = string4.toLowerCase();
                    if (estateImpl.getLanguages().contains(string4)) continue;
                    estateLinkImpl2.setTitle(null, string4);
                }
            }
            for (AbstractAttribImpl abstractAttribImpl : estateImpl.getAttributes().values()) {
                if (!(abstractAttribImpl instanceof ComplexStringAttrib)) continue;
                ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)abstractAttribImpl;
                for (String string8 : complexStringAttrib.getValueLanguages()) {
                    string8 = string8.toLowerCase();
                    if (estateImpl.getLanguages().contains(string8)) continue;
                    complexStringAttrib.getValue().remove(string8);
                }
            }
        }
        return true;
    }

    public void setAgentId(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(AGENT_ID);
        } else {
            this.put(AGENT_ID, string);
        }
    }

    public void setAgentMail(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(AGENT_MAIL);
        } else {
            this.put(AGENT_MAIL, string);
        }
    }

    public void setAttachmentImageScale(boolean bl) {
        this.put(ATTACHMENT_IMAGE_SCALE, String.valueOf(bl));
    }

    public void setAttachmentImageScaleHeight(int n) {
        if (n < 1) {
            this.remove(ATTACHMENT_IMAGE_SCALE_HEIGHT);
        } else {
            this.put(ATTACHMENT_IMAGE_SCALE_HEIGHT, String.valueOf(n));
        }
    }

    public void setAttachmentImageScaleWidth(int n) {
        if (n < 1) {
            this.remove(ATTACHMENT_IMAGE_SCALE_WIDTH);
        } else {
            this.put(ATTACHMENT_IMAGE_SCALE_WIDTH, String.valueOf(n));
        }
    }

    public void setAttachmentMimeTypes(String[] stringArray) {
        String string = "attachment.mimetype.";
        for (String string2 : this.keySet().toArray(new String[0])) {
            if (!string2.startsWith(string)) continue;
            this.remove(string2);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (StringUtils.isBlank((CharSequence)string3)) continue;
                this.put(string + i, string3);
            }
        }
    }

    public void setAttachmentMode(AttachmentMode attachmentMode) {
        if (attachmentMode == null) {
            this.remove(ATTACHMENT_MODE);
        } else {
            this.put(ATTACHMENT_MODE, attachmentMode.name());
        }
    }

    public void setCompression(Compression compression) {
        if (compression == null) {
            this.remove(COMPRESSION);
        } else {
            this.put(COMPRESSION, compression.name());
        }
    }

    public void setLanguage(Locale locale) {
        Locale[] localeArray;
        if (locale != null) {
            Locale[] localeArray2 = new Locale[1];
            localeArray = localeArray2;
            localeArray2[0] = locale;
        } else {
            localeArray = null;
        }
        this.setLanguages(localeArray);
    }

    public void setLanguages(Locale[] localeArray) {
        String string = "language.";
        for (String string2 : this.keySet().toArray(new String[0])) {
            if (!string2.startsWith(string)) continue;
            this.remove(string2);
        }
        if (localeArray != null) {
            for (int i = 0; i < localeArray.length; ++i) {
                this.put(string + i, localeArray[i].toString());
            }
        }
    }

    public void setPropertyAddressHiddenIfUnpublished(boolean bl) {
        this.put(PROPERTY_ADDRESS_HIDE_UNPUBLISHED, String.valueOf(bl));
    }

    public void setPropertyAddressPublication(PublishingMode publishingMode) {
        if (publishingMode == null) {
            this.remove(PROPERTY_ADDRESS_PUBLICATION);
        } else {
            this.put(PROPERTY_ADDRESS_PUBLICATION, publishingMode.name());
        }
    }

    public void setPropertyDescriptionWithEnergyCertificate(boolean bl) {
        this.put(PROPERTY_DESCRIPTION_WITH_ENERGY_CERTIFICATE, String.valueOf(bl));
    }

    public void setPropertyFileHiddenIfUnpublished(boolean bl) {
        this.put(PROPERTY_FILE_HIDE_UNPUBLISHED, String.valueOf(bl));
    }

    public void setPropertyFilePublication(PublishingMode publishingMode) {
        if (publishingMode == null) {
            this.remove(PROPERTY_FILE_PUBLICATION);
        } else {
            this.put(PROPERTY_FILE_PUBLICATION, publishingMode.name());
        }
    }

    public void setPropertyImageLimit(int n) {
        if (n < 0) {
            this.remove(PROPERTY_IMAGE_LIMIT);
        } else {
            this.put(PROPERTY_IMAGE_LIMIT, String.valueOf(n));
        }
    }

    public void setPropertyImageWatermark(boolean bl) {
        this.put(PROPERTY_IMAGE_WATERMARK, String.valueOf(bl));
    }

    public void setPropertyImageWatermarkAlpha(int n) {
        if (n < 1) {
            this.remove(PROPERTY_IMAGE_WATERMARK_ALPHA);
        } else {
            this.put(PROPERTY_IMAGE_WATERMARK_ALPHA, String.valueOf(n));
        }
    }

    public void setPropertyImageWatermarkHeight(int n) {
        if (n < 1) {
            this.remove(PROPERTY_IMAGE_WATERMARK_HEIGHT);
        } else {
            this.put(PROPERTY_IMAGE_WATERMARK_HEIGHT, String.valueOf(n));
        }
    }

    public void setPropertyImageWatermarkMargin(int n) {
        if (n < 1) {
            this.remove(PROPERTY_IMAGE_WATERMARK_MARGIN);
        } else {
            this.put(PROPERTY_IMAGE_WATERMARK_MARGIN, String.valueOf(n));
        }
    }

    public void setPropertyImageWatermarkPosition(ImageWatermarkPosition imageWatermarkPosition) {
        if (imageWatermarkPosition == null) {
            this.remove(PROPERTY_IMAGE_WATERMARK_POSITION);
        } else {
            this.put(PROPERTY_IMAGE_WATERMARK_POSITION, imageWatermarkPosition.name());
        }
    }

    public void setPropertyImageWatermarkWidth(int n) {
        if (n < 1) {
            this.remove(PROPERTY_IMAGE_WATERMARK_WIDTH);
        } else {
            this.put(PROPERTY_IMAGE_WATERMARK_WIDTH, String.valueOf(n));
        }
    }

    public void setPropertyLinkHiddenIfUnpublished(boolean bl) {
        this.put(PROPERTY_LINK_HIDE_UNPUBLISHED, String.valueOf(bl));
    }

    public void setPropertyLinkPublication(PublishingMode publishingMode) {
        if (publishingMode == null) {
            this.remove(PROPERTY_LINK_PUBLICATION);
        } else {
            this.put(PROPERTY_LINK_PUBLICATION, publishingMode.name());
        }
    }

    public void setPropertyPrefix(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(PROPERTY_PREFIX);
        } else {
            this.put(PROPERTY_PREFIX, string);
        }
    }

    public void setPropertyPublicId(boolean bl) {
        this.put(PROPERTY_PUBLIC_ID, String.valueOf(bl));
    }

    public void setPropertyPriceHiddenIfUnpublished(boolean bl) {
        this.put(PROPERTY_PRICE_HIDE_UNPUBLISHED, String.valueOf(bl));
    }

    public void setPropertyPricePublication(PublishingMode publishingMode) {
        if (publishingMode == null) {
            this.remove(PROPERTY_PRICE_PUBLICATION);
        } else {
            this.put(PROPERTY_PRICE_PUBLICATION, publishingMode.name());
        }
    }

    public void setPropertyVideoLimit(int n) {
        if (n < 0) {
            this.remove(PROPERTY_VIDEO_LIMIT);
        } else {
            this.put(PROPERTY_VIDEO_LIMIT, String.valueOf(n));
        }
    }

    public abstract File writeToDisk(File var1, TransferImpl var2, ExportContext var3) throws IOException, SQLException;

    public static enum DefaultMessageCode implements Translatable
    {
        FORMAT_CONVERSION_FAILED(I18n.marktr((String)"conversion to target format failed"));

        private final String i18nKey;

        private DefaultMessageCode(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(DefaultMessageCode.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DefaultMessageCode.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static class HashCalculationException
    extends Exception {
        public HashCalculationException(String string) {
            super(string);
        }

        public HashCalculationException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public static class NotExportableException
    extends Exception {
        public NotExportableException(String string) {
            super(string);
        }

        public NotExportableException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public static enum TransferMode implements Translatable
    {
        INCREMENTAL(I18n.marktr((String)"incremental transfer"), I18n.marktr((String)"Execute an INCREMENTAL export.")),
        FULL(I18n.marktr((String)"full transfer"), I18n.marktr((String)"Execute a FULL export."));

        private final String i18nKey;
        private final String i18nTextKey;

        private TransferMode(String string2, String string3) {
            this.i18nKey = string2;
            this.i18nTextKey = string3;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AbstractFormatPanel.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AbstractFormatPanel.class, (String)this.i18nKey, (Locale)locale);
        }

        public String getTranslationText() {
            return ImmoToolUtils.getI18nString(AbstractFormatPanel.class, (String)this.i18nTextKey);
        }

        public String getTranslationText(Locale locale) {
            return ImmoToolUtils.getI18nString(AbstractFormatPanel.class, (String)this.i18nTextKey, (Locale)locale);
        }
    }

    public static enum ImageWatermarkPosition implements Translatable
    {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        CENTER_LEFT,
        CENTER_CENTER,
        CENTER_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;


        private String getAlignmentHorizontal() {
            switch (this) {
                case TOP_LEFT: 
                case CENTER_LEFT: 
                case BOTTOM_LEFT: {
                    return I18n.marktr((String)"left");
                }
                case TOP_CENTER: 
                case CENTER_CENTER: 
                case BOTTOM_CENTER: {
                    return I18n.marktr((String)"centered");
                }
                case TOP_RIGHT: 
                case CENTER_RIGHT: 
                case BOTTOM_RIGHT: {
                    return I18n.marktr((String)"right");
                }
            }
            return null;
        }

        private String getAlignmentVertical() {
            switch (this) {
                case TOP_LEFT: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    return I18n.marktr((String)"top");
                }
                case CENTER_LEFT: 
                case CENTER_CENTER: 
                case CENTER_RIGHT: {
                    return I18n.marktr((String)"middle");
                }
                case BOTTOM_LEFT: 
                case BOTTOM_CENTER: 
                case BOTTOM_RIGHT: {
                    return I18n.marktr((String)"bottom");
                }
            }
            return null;
        }

        public String getTranslation() {
            String string = this.getAlignmentHorizontal();
            String string2 = this.getAlignmentVertical();
            return ImmoToolUtils.getI18nString(AbstractFormat.class, (String)string) + ", " + ImmoToolUtils.getI18nString(AbstractFormat.class, (String)string2);
        }

        public String getTranslation(Locale locale) {
            String string = this.getAlignmentHorizontal();
            String string2 = this.getAlignmentVertical();
            return ImmoToolUtils.getI18nString(AbstractFormat.class, (String)string, (Locale)locale) + ", " + ImmoToolUtils.getI18nString(AbstractFormat.class, (String)string2, (Locale)locale);
        }
    }

    public static enum Compression {
        UNCOMPRESSED,
        ZIP,
        GZIP;

    }

    public static enum AttachmentMode implements Translatable
    {
        FILE(I18n.marktr((String)"Send attachments as files.")),
        BASE64(I18n.marktr((String)"Send attachments as base64 binary."));

        private final String i18nKey;

        private AttachmentMode(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AbstractFormat.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AbstractFormat.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static enum AttachmentMarker implements Translatable
    {
        INTERN,
        EXTERN,
        REMOTE;


        public String getTranslation() {
            return I18N.tr("Mark attachments as {0}.", (Object)("'" + this.name() + "'"));
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18n(AbstractFormat.class, (Locale)locale).tr("Mark attachments as {0}.", (Object)("'" + this.name() + "'"));
        }
    }
}

