/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.idx.IdxWriter;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.export.AbstractCsvFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.IdxCsvFormatPanel;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.idx.IdxRecord;
import org.openestate.io.idx.types.Media;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class IdxCsvFormat
extends AbstractCsvFormat {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxCsvFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(IdxCsvFormat.class);
    private static final String NAME = "idx";
    private transient String preparedObjectId = null;
    private transient int preparedObjectImgCount = 0;
    private transient int preparedObjectMovCount = 0;
    private transient int preparedObjectDocCount = 0;

    protected IdxWriter buildWriter() {
        Writer writer = new Writer(this.getLanguage());
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        return writer;
    }

    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            IdxWriter idxWriter = this.buildWriter();
            String string = StringUtils.trimToEmpty((String)idxWriter.writeToString(agencyImpl));
            String string2 = idxWriter.getErrorMessages(estateImpl.getId());
            if (string2 != null) {
                throw new AbstractFormat.NotExportableException(string2);
            }
            return DigestUtils.sha1Hex((String)string);
        }
        catch (IOException iOException) {
            throw new AbstractFormat.HashCalculationException(iOException.getLocalizedMessage(), iOException);
        }
    }

    @Override
    protected boolean canPublishAttachment(String string, EstateAttachmentImpl estateAttachmentImpl) {
        String string2;
        if (!super.canPublishAttachment(string, estateAttachmentImpl)) {
            return false;
        }
        if (this.preparedObjectId == null || !this.preparedObjectId.equals(string)) {
            this.preparedObjectId = string;
            this.preparedObjectImgCount = 0;
            this.preparedObjectMovCount = 0;
            this.preparedObjectDocCount = 0;
        }
        if (Media.isImage((String)(string2 = StringUtils.trimToNull((String)estateAttachmentImpl.getFileAsName())))) {
            if (this.preparedObjectImgCount >= 13) {
                return false;
            }
            ++this.preparedObjectImgCount;
            return true;
        }
        if (Media.isMovie((String)string2)) {
            if (this.preparedObjectMovCount >= 1) {
                return false;
            }
            ++this.preparedObjectMovCount;
            return true;
        }
        if (Media.isDocument((String)string2)) {
            if (this.preparedObjectDocCount >= 1) {
                return false;
            }
            ++this.preparedObjectDocCount;
            return true;
        }
        return false;
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new IdxCsvFormatPanel();
    }

    @Override
    protected File getAttachmentDirectory(long l, EstateAttachmentImpl estateAttachmentImpl, File file) {
        String string = StringUtils.trimToNull((String)estateAttachmentImpl.getFileAsName());
        if (Media.isImage((String)string)) {
            return new File(file.getAbsolutePath() + File.separator + "images");
        }
        if (Media.isMovie((String)string)) {
            return new File(file.getAbsolutePath() + File.separator + "movies");
        }
        if (Media.isDocument((String)string)) {
            return new File(file.getAbsolutePath() + File.separator + "doc");
        }
        return null;
    }

    @Override
    protected String getCsvFileName(ExportContext exportContext) {
        return "unload.txt";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected String[] getPreferredMimeTypes() {
        return new String[]{"image/gif", "image/jpeg"};
    }

    @Override
    public String[] getSupportedMimeTypes() {
        return new String[]{"application/msword", "application/pdf", "application/rtf", "image/gif", "image/jpeg", "video/avi", "video/mp4", "video/mpeg", "video/msvideo", "video/quicktime", "video/vnd.rn-realvideo", "video/x-flv", "video/x-msvideo", "video/x-ms-wmv"};
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL};
    }

    @Override
    public String getTitle() {
        return "IDX-CSV";
    }

    @Override
    public String getVersion() {
        return "3.01";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setLanguages(new Locale[]{Locale.GERMAN});
    }

    @Override
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        this.preparedObjectId = null;
        this.preparedObjectImgCount = 0;
        this.preparedObjectMovCount = 0;
        this.preparedObjectDocCount = 0;
        return super.prepareObjectForExport(l, estateImpl);
    }

    @Override
    public File writeToDisk(File file, TransferImpl transferImpl, ExportContext exportContext) throws IOException {
        File file2 = new File(file, "data");
        if (!file2.isDirectory() && !file2.mkdir()) {
            throw new IOException("Can't create 'data' directory!");
        }
        File file3 = new File(file, "images");
        if (!file3.isDirectory() && !file3.mkdir()) {
            throw new IOException("Can't create 'images' directory!");
        }
        File file4 = new File(file, "movies");
        if (!file4.isDirectory() && !file4.mkdir()) {
            throw new IOException("Can't create 'movies' directory!");
        }
        File file5 = new File(file, "doc");
        if (!file5.isDirectory() && !file5.mkdir()) {
            throw new IOException("Can't create 'doc' directory!");
        }
        File file6 = new File(file2, this.getCsvFileName(exportContext));
        IdxWriter idxWriter = this.buildWriter();
        idxWriter.write(transferImpl, file6);
        exportContext.addErrorMessages(idxWriter.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return file;
    }

    public static class Writer
    extends IdxWriter {
        public Writer(Locale locale) {
            super(locale);
        }

        protected IdxRecord createEmptyRecord() {
            IdxRecord idxRecord = super.createEmptyRecord();
            idxRecord.setSenderId(ImmoToolEnvironment.getApplicationTitle() + "_" + ImmoToolEnvironment.getApplicationVersion());
            return idxRecord;
        }
    }
}

