/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.ImmopoolDeFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmopoolDeFormatPanel
extends AbstractFormatPanel<ImmopoolDeFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmopoolDeFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmopoolDeFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel agentIdLabel;
    private JTextField agentIdField;
    private JLabel estateIdPrefixLabel;
    private JTextField estateIdPrefixField;
    private JLabel agentMailLabel;
    private JTextField agentMailField;
    private JLabel technMailLabel;
    private JTextField technMailField;
    private JLabel optionsLabel;
    private JCheckBox zipExportBox;
    private JCheckBox energyCertificateBox;

    public ImmopoolDeFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.zipExportBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.agentIdLabel = new JLabel();
        this.agentIdField = new JTextField();
        this.estateIdPrefixLabel = new JLabel();
        this.estateIdPrefixField = new JTextField();
        this.technMailLabel = new JLabel();
        this.technMailField = new JTextField();
        this.agentMailLabel = new JLabel();
        this.agentMailField = new JTextField();
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        this.validationHandler.putRule((JComponent)this.agentMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 6dlu, right:pref, 3dlu, 50dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.agentIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentIdField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.agentMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentMailField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.technMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.technMailField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.zipExportBox).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.energyCertificateBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (ImmopoolDeFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, ImmopoolDeFormat immopoolDeFormat) {
        if (immopoolDeFormat == null) {
            this.agentIdField.setText("");
            this.agentMailField.setText("");
            this.estateIdPrefixField.setText("");
            this.technMailField.setText("");
            this.zipExportBox.setSelected(true);
            this.energyCertificateBox.setSelected(false);
        } else {
            this.agentIdField.setText(immopoolDeFormat.getAgentId());
            this.agentMailField.setText(immopoolDeFormat.getAgentMail());
            this.estateIdPrefixField.setText(immopoolDeFormat.getPropertyPrefix());
            this.technMailField.setText(immopoolDeFormat.getImmoXmlTechnicsMail());
            this.energyCertificateBox.setSelected(immopoolDeFormat.isPropertyDescriptionWithEnergyCertificate());
            AbstractFormat.Compression compression = immopoolDeFormat.getCompression();
            this.zipExportBox.setSelected(AbstractFormat.Compression.ZIP.equals((Object)compression));
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, ImmopoolDeFormat immopoolDeFormat) {
        if (immopoolDeFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        immopoolDeFormat.setAgentId(this.agentIdField.getText().trim());
        immopoolDeFormat.setAgentMail(this.agentMailField.getText().trim());
        immopoolDeFormat.setImmoXmlTechnicsMail(this.technMailField.getText().trim());
        immopoolDeFormat.setPropertyPrefix(this.estateIdPrefixField.getText().trim());
        immopoolDeFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
        immopoolDeFormat.setCompression(this.zipExportBox.isSelected() ? AbstractFormat.Compression.ZIP : AbstractFormat.Compression.UNCOMPRESSED);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.agentIdLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-nr")) + ":");
        this.agentIdField.setToolTipText(I18N.tr("Enter your agency-nr, that you've received from recipient to identify your account. Not all recipients require this value."));
        this.agentMailLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-mail")) + ":");
        this.technMailLabel.setText(StringUtils.capitalize((String)I18N.tr("support-mail")) + ":");
        this.technMailField.setToolTipText(I18N.tr("Enter your e-mail address for technical feedback. Some recipients are sending their protocols to this address."));
        this.estateIdPrefixLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-prefix")) + ":");
        this.estateIdPrefixField.setToolTipText(I18N.tr("The selected prefix is prepended to the property-ID & property-nr during the export."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.zipExportBox.setText(I18N.tr("Compress exported files into a ZIP-archive."));
        this.zipExportBox.setToolTipText(I18N.tr("Compressing the exported files into a ZIP-archive will reduce the total file size of the export."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

