/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.descriptions.AdditionalInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.descriptions.ShortDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.measures.GrossArea;
import com.openindex.openestate.impl.attribs.prices.Conventioned;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.xml.Anbieter;
import org.openestate.io.openimmo.xml.Immobilie;
import org.openestate.io.openimmo.xml.Openimmo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmowebItFormat
extends OpenImmoXmlFormat {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmowebItFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmowebItFormat.class);
    private static final String NAME = "immoweb.it";

    @Override
    protected Openimmo convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        Openimmo openimmo = super.convertXml(transferImpl, exportContext);
        if (openimmo == null) {
            return null;
        }
        TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
        Anbieter anbieter = (Anbieter)openimmo.getAnbieter().get(0);
        for (Immobilie immobilie : anbieter.getImmobilie()) {
            Object object;
            EfficiencyCategory.Option option;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            String string;
            EstateImpl estateImpl;
            String string2 = immobilie.getVerwaltungTechn().getObjektnrIntern();
            if (string2 == null || (estateImpl = this.getEstate(transferAgencyImpl, string2)) == null) continue;
            if (immobilie.getFlaechen() != null && (immobilie.getFlaechen().getVerkaufsflaeche() == null || immobilie.getFlaechen().getVerkaufsflaeche().longValue() < 1L)) {
                immobilie.getFlaechen().setVerkaufsflaeche(GrossArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
            }
            if (!StringUtils.isBlank((CharSequence)(string = estateImpl.getTitle(Locale.ITALIAN)))) {
                object7 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                object7.setFeldname("objekttitel_it");
                object7.setContent(string.trim());
                immobilie.getUserDefinedSimplefield().add(object7);
            }
            if (!StringUtils.isBlank((CharSequence)(object7 = ShortDescription.get((EstateImpl)estateImpl, (String)Locale.ITALIAN.getLanguage())))) {
                object6 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                object6.setFeldname("dreizeiler_it");
                object6.setContent((String)object7);
                immobilie.getUserDefinedSimplefield().add(object6);
            }
            if (!StringUtils.isBlank((CharSequence)(object6 = FeatureDescription.get((EstateImpl)estateImpl, (String)Locale.ITALIAN.getLanguage())))) {
                object5 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                object5.setFeldname("ausstatt_beschr_it");
                object5.setContent((String)object6);
                immobilie.getUserDefinedSimplefield().add(object5);
            }
            if (!StringUtils.isBlank((CharSequence)(object5 = LocationDescription.get((EstateImpl)estateImpl, (String)Locale.ITALIAN.getLanguage())))) {
                object4 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                object4.setFeldname("lage_it");
                object4.setContent((String)object5);
                immobilie.getUserDefinedSimplefield().add(object4);
            }
            if (!StringUtils.isBlank((CharSequence)(object4 = DetailledDescription.get((EstateImpl)estateImpl, (String)Locale.ITALIAN.getLanguage())))) {
                object3 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                object3.setFeldname("objektbeschreibung_it");
                object3.setContent((String)object4);
                immobilie.getUserDefinedSimplefield().add(object3);
            }
            if (!StringUtils.isBlank((CharSequence)(object3 = AdditionalInformation.get((EstateImpl)estateImpl, (String)Locale.ITALIAN.getLanguage())))) {
                object2 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                object2.setFeldname("sonstige_angaben_it");
                object2.setContent((String)object3);
                immobilie.getUserDefinedSimplefield().add(object2);
            }
            if (Locale.ITALY.getCountry().equalsIgnoreCase(estateImpl.getAddress().getCountry())) {
                object2 = Conventioned.get((EstateImpl)estateImpl);
                if (Conventioned.Option.YES.equals(object2)) {
                    option = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                    option.setFeldname("konventioniert");
                    option.setContent("true");
                    immobilie.getUserDefinedSimplefield().add(option);
                } else {
                    option = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                    option.setFeldname("konventioniert");
                    option.setContent("false");
                    immobilie.getUserDefinedSimplefield().add(option);
                }
            }
            object2 = null;
            option = EfficiencyCategory.get((EstateImpl)estateImpl);
            if (option != null) {
                object2 = option.getTranslation(Locale.ENGLISH);
            }
            if (object2 == null && estateImpl.getAddress() != null) {
                object = ConsumptionTotal.getAsDouble((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                if (object == null) {
                    object = DemandTotal.getAsDouble((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                }
                String string3 = object2 = (option = OpenEstateUtils.getEnergyEfficiencyCategory((Number)object, (String)estateImpl.getAddress().getCountry())) != null ? option.getTranslation(Locale.ENGLISH) : null;
            }
            if (object2 == null) continue;
            object = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
            object.setFeldname("energieklasse");
            object.setContent((String)object2);
            if (immobilie.getZustandAngaben() == null) {
                immobilie.setZustandAngaben(OpenImmoUtils.getFactory().createZustandAngaben());
            }
            immobilie.getZustandAngaben().getUserDefinedSimplefield().add(object);
        }
        return openimmo;
    }

    private EstateImpl getEstate(TransferAgencyImpl transferAgencyImpl, String string) {
        for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
            if (!string.equalsIgnoreCase(estateImpl.getId())) continue;
            return estateImpl;
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "Portal: Immoweb.it";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setCompression(AbstractFormat.Compression.ZIP);
        this.setXmlLineBreak(AbstractXmlFormat.LineBreakMode.XHTML);
        this.setLanguage(Locale.GERMAN);
        this.setPropertyPublicId(true);
    }
}

