/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.is24.Is24RestWriter;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogMessage;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.Is24RestFormatPanel;
import com.openindex.openestate.tool.agency.export.Is24RestTransport;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.utils.ExportPool;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.common.Attachment;
import org.openestate.is24.restapi.xml.common.CountryRegion;
import org.openestate.is24.restapi.xml.common.Picture;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.realestates.HouseType;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24RestFormat
extends AbstractFormat {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24RestFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24RestFormat.class);
    private static final String NAME = "is24_rest";
    public static final String GEODB = "is24";

    private void addMessageToExportContext(ResponseCode responseCode, String string, ExportContext exportContext) {
        this.addMessageToExportContext(responseCode, 0L, string, exportContext);
    }

    private void addMessageToExportContext(ResponseCode responseCode, long l, String string, ExportContext exportContext) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        if (l > 0L) {
            exportContext.addMessage(l, string, responseCode.name(), responseCode.getLevel());
        } else {
            exportContext.addMessage(string, responseCode.name(), responseCode.getLevel());
        }
    }

    protected Is24RestWriter buildWriter() {
        return this.buildWriter(null, null);
    }

    private Writer buildWriter(ExportContext exportContext) {
        return exportContext != null ? this.buildWriter(exportContext.dbDriver, exportContext.dbExtension) : this.buildWriter(null, null);
    }

    private Writer buildWriter(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
        return new Writer(this.getLanguage(), abstractDbDriver, dbAgencyExtension);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        Object object;
        Object object2;
        RealEstate realEstate;
        Object object4;
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        ArrayList arrayList = new ArrayList();
        try {
            object4 = this.buildWriter();
            realEstate = object4.writeEstate(estateImpl, arrayList);
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert property #" + l + "!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            throw new AbstractFormat.NotExportableException("Can't convert property #" + l + "! (" + exception.getLocalizedMessage() + ")", exception);
        }
        if (realEstate == null) throw new AbstractFormat.NotExportableException(StringUtils.join(arrayList, (String)"; "));
        if (!arrayList.isEmpty()) {
            throw new AbstractFormat.NotExportableException(StringUtils.join(arrayList, (String)"; "));
        }
        object4 = new StringBuilder();
        for (Object object3222 : estateImpl.getAttachments()) {
            if (!object3222.isPublished() && this.isPropertyFileHiddenIfUnpublished() || !this.canPublishAttachment(estateImpl.getId(), (EstateAttachmentImpl)object3222)) continue;
            object2 = StringUtils.lowerCase((String)StringUtils.trimToNull((String)object3222.getHash()));
            object = StringUtils.trimToNull((String)object3222.getTitle(this.getLanguage()));
            EstateAttachmentType estateAttachmentType = object3222.getType();
            if (object2 != null) {
                ((StringBuilder)object4).append(";").append((String)object2);
            }
            if (object != null) {
                ((StringBuilder)object4).append(";").append((String)object);
            }
            if (estateAttachmentType == null) continue;
            ((StringBuilder)object4).append(";").append(estateAttachmentType.name());
        }
        for (Object object3222 : estateImpl.getLinks()) {
            if (!object3222.isPublished() && this.isPropertyLinkHiddenIfUnpublished() || !this.canPublishLink(estateImpl.getId(), (EstateLinkImpl)object3222)) continue;
            object2 = object3222.getUrl();
            object = StringUtils.trimToNull((String)object3222.getTitle(this.getLanguage()));
            if (object2 != null) {
                ((StringBuilder)object4).append(";").append(((URI)object2).toString());
            }
            if (object == null) continue;
            ((StringBuilder)object4).append(";").append((String)object);
        }
        try {
            Object object3222;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object3222 = null;
            try {
                XmlUtils.writeXml((RealEstate)realEstate, (String)"UTF-8", (boolean)false, (OutputStream)byteArrayOutputStream);
                object2 = DigestUtils.sha1Hex((byte[])byteArrayOutputStream.toByteArray());
                if (((StringBuilder)object4).length() > 0) {
                    object2 = DigestUtils.sha1Hex((String)((String)object2 + ((StringBuilder)object4).toString()));
                }
                object = object2;
                return object;
            }
            catch (Throwable throwable) {
                object3222 = throwable;
                throw throwable;
            }
            finally {
                if (byteArrayOutputStream != null) {
                    if (object3222 != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3222).addSuppressed(throwable);
                        }
                    } else {
                        byteArrayOutputStream.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AbstractFormat.HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    public AbstractTransportRequest[] createExportRequests(AbstractTransport abstractTransport, File file, AbstractFormat.TransferMode transferMode) {
        if (abstractTransport instanceof Is24RestTransport) {
            return new AbstractTransportRequest[]{new Is24RestTransport.Is24ExportRequest((Is24RestTransport)abstractTransport, file, true, AbstractFormat.TransferMode.FULL.equals((Object)transferMode))};
        }
        return super.createExportRequests(abstractTransport, file, transferMode);
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new Is24RestFormatPanel();
    }

    @Override
    protected File getAttachmentDirectory(long l, EstateAttachmentImpl estateAttachmentImpl, File file) {
        return new File(new File(file, "temp"), String.valueOf(l));
    }

    @Override
    public String getMessageCodeTranslation(String string, Locale locale) {
        for (ResponseCode responseCode : ResponseCode.values()) {
            if (!responseCode.name().equalsIgnoreCase(string)) continue;
            return locale != null ? responseCode.getTranslation(locale) : responseCode.getTranslation();
        }
        return super.getMessageCodeTranslation(string, locale);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getSupportedMimeTypes() {
        return new String[]{"application/pdf", "image/bmp", "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/tiff", "video/avi", "video/flv", "video/mp4", "video/mpeg", "video/msvideo", "video/ogg", "video/quicktime", "video/vnd.rn-realvideo", "video/x-flv", "video/x-ms-asf", "video/x-ms-wmv", "video/x-msvideo", "video/x-sgi-movie"};
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL, AbstractFormat.TransferMode.INCREMENTAL};
    }

    @Override
    public AbstractTransport[] getSupportedTransports() {
        return new AbstractTransport[]{new Is24RestTransport(), new LocalTransport()};
    }

    @Override
    public String getTitle() {
        return "IS24-Webservice";
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setLanguage(Locale.GERMAN);
        this.setPropertyImageLimit(30);
        this.setPropertyVideoLimit(2);
    }

    @Override
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea(GEODB);
        if (!super.prepareObjectForExport(l, estateImpl)) {
            return false;
        }
        estateImpl.removeCustomGeoAreas();
        if (geoAreaImpl != null) {
            estateImpl.putCustomGeoArea(GEODB, geoAreaImpl);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File writeToDisk(File file, TransferImpl transferImpl, ExportContext exportContext) throws IOException {
        File file2 = new File(file, "temp");
        ExportPool exportPool = new ExportPool(file);
        Writer writer = this.buildWriter(exportContext);
        try {
            Object object;
            String string;
            ArrayList arrayList;
            String string2;
            TransferAgencyImpl transferAgencyImpl;
            TransferAgencyImpl transferAgencyImpl2 = transferAgencyImpl = transferImpl != null && !transferImpl.getAgencies().isEmpty() ? (TransferAgencyImpl)transferImpl.getAgencies().get(0) : null;
            if (transferAgencyImpl == null) {
                throw new IllegalArgumentException("Can't find an exportable agency!");
            }
            CompanyAddressImpl companyAddressImpl = transferAgencyImpl.getAgent() != null ? transferAgencyImpl.getAgent().getCompany() : null;
            String string3 = string2 = companyAddressImpl != null ? StringUtils.trimToNull((String)companyAddressImpl.getCompanyName()) : null;
            if (transferAgencyImpl.getContacts() != null && !transferAgencyImpl.getContacts().isEmpty()) {
                for (Object object2 : transferAgencyImpl.getContacts().values()) {
                    String string4 = StringUtils.trimToNull((String)object2.getId());
                    if (string4 == null) {
                        arrayList = "An invalid contact ID is specified!";
                        LOGGER.warn((String)((Object)arrayList));
                        this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_CONTACT_PERSON, StringUtils.trimToNull((String)((Object)arrayList)), exportContext);
                        continue;
                    }
                    arrayList = new ArrayList();
                    string = writer.writeContact((AgentContactImpl)object2, string2, arrayList);
                    if (string == null || !arrayList.isEmpty()) {
                        LOGGER.warn("Can't write XML for contact #" + string4 + "!");
                        for (String string5 : arrayList) {
                            LOGGER.warn("> " + string5);
                        }
                        object = "Can't write XML for contact #" + string4 + "!";
                        object = (String)object + System.lineSeparator();
                        object = (String)object + StringUtils.join((Iterable)arrayList, (String)System.lineSeparator());
                        this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_CONTACT_PERSON, StringUtils.trimToNull((String)object), exportContext);
                        continue;
                    }
                    try {
                        exportPool.putContact((RealtorContactDetails)string, String.valueOf(string4));
                    }
                    catch (Exception exception) {
                        throw new IOException("Can't write XML for contact #" + string4 + "!", exception);
                    }
                }
            }
            int n = 0;
            if (transferAgencyImpl.getEstatesToSave() != null && !transferAgencyImpl.getEstatesToSave().isEmpty()) {
                for (String string4 : transferAgencyImpl.getEstatesToSave()) {
                    Object object2;
                    File file3;
                    Object object4;
                    arrayList = StringUtils.trimToNull((String)string4.getId());
                    string = String.valueOf(++n);
                    if (arrayList == null) {
                        object = "An invalid object key is specified!";
                        LOGGER.warn((String)object);
                        this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_PROPERTY, StringUtils.trimToNull((String)object), exportContext);
                        continue;
                    }
                    object = exportContext.getEntry((String)((Object)arrayList));
                    if (object == null) {
                        String string6 = "Can't find an export entry for object '" + (String)((Object)arrayList) + "'!";
                        LOGGER.warn(string6);
                        this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_PROPERTY, StringUtils.trimToNull((String)string6), exportContext);
                        continue;
                    }
                    long l = ((ExportEntry)object).objectId;
                    if (l < 1L) {
                        object4 = "The object ID of export entry '" + (String)((Object)arrayList) + "' is invalid!";
                        LOGGER.warn((String)object4);
                        this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_PROPERTY, StringUtils.trimToNull((String)object4), exportContext);
                        continue;
                    }
                    object4 = new File(file2, String.valueOf(l));
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    RealEstate realEstate = writer.writeEstate((EstateImpl)string4, arrayList2);
                    if (realEstate == null || !arrayList2.isEmpty()) {
                        LOGGER.warn("Can't write XML for object #" + l + "!");
                        for (String string5 : arrayList2) {
                            LOGGER.warn("> " + string5);
                        }
                        Object object5 = "Can't write XML for object #" + l + "!";
                        object5 = (String)object5 + System.lineSeparator();
                        object5 = (String)object5 + StringUtils.join(arrayList2, (String)System.lineSeparator());
                        this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_PROPERTY, l, StringUtils.trimToNull((String)object5), exportContext);
                        continue;
                    }
                    if (realEstate instanceof HouseType) {
                        this.addMessageToExportContext(ResponseCode.IS24_FORMAT_HOUSE_FOR_PURCHASE_WITHOUT_PLOT_AREA, l, "The object was exported as 'type house' instead of 'house for purchase'.", exportContext);
                    }
                    try {
                        exportPool.putObject(realEstate, string);
                    }
                    catch (Exception exception) {
                        throw new IOException("Can't write XML for object '" + (String)((Object)arrayList) + "' (#" + l + ")!", exception);
                    }
                    boolean bl = true;
                    for (EstateAttachmentImpl estateAttachmentImpl : string4.getAttachments()) {
                        file3 = new File((File)object4, FilenameUtils.getName((String)estateAttachmentImpl.getFileAsName()));
                        if (!file3.isFile()) {
                            LOGGER.warn("Can't find attached file!");
                            LOGGER.warn("> at " + file3.getAbsolutePath());
                            object2 = "Can't find attached file of object #" + l + "!";
                            this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_PROPERTY_ATTACHMENT, l, StringUtils.trimToNull((String)object2), exportContext);
                            continue;
                        }
                        arrayList2.clear();
                        object2 = writer.writeAttachment(estateAttachmentImpl, bl, arrayList2);
                        if (object2 == null || !arrayList2.isEmpty()) {
                            LOGGER.warn("Can't write XML for attachment of object #" + l + "!");
                            for (String string6 : arrayList2) {
                                LOGGER.warn("> " + string6);
                            }
                            String string9 = "Can't write XML for attachment of object #" + l + "!";
                            string9 = string9 + System.lineSeparator();
                            string9 = string9 + StringUtils.join(arrayList2, (String)System.lineSeparator());
                            this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_PROPERTY_ATTACHMENT, l, StringUtils.trimToNull((String)string9), exportContext);
                            continue;
                        }
                        try {
                            exportPool.putObjectAttachedFile(string, (Attachment)object2, file3);
                            if (!(object2 instanceof Picture)) continue;
                            bl = false;
                        }
                        catch (Exception exception) {
                            throw new IOException("Can't write attachment for object '" + (String)((Object)arrayList) + "' (#" + l + ")!", exception);
                        }
                    }
                    for (EstateAttachmentImpl estateAttachmentImpl : string4.getLinks()) {
                        arrayList2.clear();
                        file3 = writer.writeAttachment((EstateLinkImpl)estateAttachmentImpl, arrayList2);
                        if (file3 == null || !arrayList2.isEmpty()) {
                            LOGGER.warn("Can't write XML for link of object #" + l + "!");
                            for (String string10 : arrayList2) {
                                LOGGER.warn("> " + string10);
                            }
                            object2 = "Can't write XML for link of object #" + l + "!";
                            object2 = (String)object2 + System.lineSeparator();
                            object2 = (String)object2 + StringUtils.join(arrayList2, (String)System.lineSeparator());
                            this.addMessageToExportContext(ResponseCode.IS24_FORMAT_CANT_PREPARE_PROPERTY_ATTACHMENT, l, StringUtils.trimToNull((String)object2), exportContext);
                            continue;
                        }
                        try {
                            exportPool.putObjectAttachedLink(string, (Attachment)file3);
                        }
                        catch (Exception exception) {
                            throw new IOException("Can't write link for object '" + (String)((Object)arrayList) + "' (#" + l + ")!", exception);
                        }
                    }
                }
            }
            if (transferAgencyImpl.getEstateIdsToRemove() != null && !transferAgencyImpl.getEstateIdsToRemove().isEmpty()) {
                for (String string4 : transferAgencyImpl.getEstateIdsToRemove()) {
                    exportPool.putObjectForRemoval(string4);
                }
            }
            try {
                exportPool.writeSettings();
            }
            catch (Exception exception) {
                throw new IOException("Can't write export pool settings!", exception);
            }
        }
        finally {
            writer.shutdownDbConnection();
            FileUtils.deleteQuietly((File)file2);
        }
        return exportPool.getBaseDir();
    }

    public static class Writer
    extends Is24RestWriter {
        private final Map<Long, DbGeoArea> areas;
        private final AbstractDbDriver dbDriver;
        private final DbAgencyExtension dbExtension;
        private Connection dbConnection = null;

        public Writer(Locale locale) {
            this(locale, null, null);
        }

        public Writer(Locale locale, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
            super(locale);
            this.dbDriver = abstractDbDriver;
            this.dbExtension = dbAgencyExtension;
            this.areas = new HashMap<Long, DbGeoArea>();
            AgencyPluginUtils.initJAXB(XmlUtils.class);
        }

        private Connection initConnection() throws SQLException {
            if (this.dbConnection == null) {
                this.dbConnection = this.dbDriver.getConnection();
            }
            return this.dbConnection;
        }

        private DbGeoArea lookupArea(Long l) throws SQLException {
            if (this.areas.containsKey(l)) {
                return this.areas.get(l);
            }
            Connection connection = this.initConnection();
            DbGeoArea dbGeoArea = this.dbExtension.getGeoHandler().getGeoArea(connection, l.longValue());
            this.areas.put(dbGeoArea.id, dbGeoArea);
            return dbGeoArea;
        }

        private DbGeoArea lookupArea(GeoAreaImpl geoAreaImpl) throws SQLException {
            Long l = Long.valueOf(geoAreaImpl.getId());
            return this.lookupArea(l);
        }

        public void shutdownDbConnection() {
            JdbcUtils.closeQuietly((Connection)this.dbConnection);
            this.dbConnection = null;
            this.areas.clear();
        }

        public RealEstate writeEstate(EstateImpl estateImpl, List<String> list) {
            CountryRegion countryRegion;
            RealEstate realEstate;
            if (StringUtils.isBlank((CharSequence)estateImpl.getContactId()) || "0".equals(estateImpl.getContactId())) {
                estateImpl.setContactId(null);
            }
            if ((realEstate = super.writeEstate(estateImpl, list)) == null || !list.isEmpty()) {
                return realEstate;
            }
            CountryRegion countryRegion2 = countryRegion = realEstate.getAddress() != null ? realEstate.getAddress().getInternationalCountryRegion() : null;
            if (countryRegion != null && this.dbDriver != null) {
                DbGeoArea dbGeoArea = null;
                try {
                    GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea(Is24RestFormat.GEODB);
                    dbGeoArea = geoAreaImpl != null ? this.lookupArea(geoAreaImpl) : null;
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load areas from geodb 'is24'!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
                if (dbGeoArea != null) {
                    countryRegion.setRegion(dbGeoArea.name);
                }
            }
            return realEstate;
        }
    }

    private static enum ResponseCode implements Translatable
    {
        IS24_FORMAT_CANT_PREPARE_CONTACT_PERSON(I18n.marktr((String)"Can't prepare contact person for export."), DbAgencyExportLogMessage.Level.ERROR),
        IS24_FORMAT_CANT_PREPARE_PROPERTY(I18n.marktr((String)"Can't prepare property for export."), DbAgencyExportLogMessage.Level.ERROR),
        IS24_FORMAT_CANT_PREPARE_PROPERTY_ATTACHMENT(I18n.marktr((String)"Can't prepare attachment for export."), DbAgencyExportLogMessage.Level.WARNING),
        IS24_FORMAT_HOUSE_FOR_PURCHASE_WITHOUT_PLOT_AREA(I18n.marktr((String)"The house for purchase does not have a plot area and is exported as type house."), DbAgencyExportLogMessage.Level.NOTICE);

        private final String i18nKey;
        private final DbAgencyExportLogMessage.Level level;

        private ResponseCode(String string2, DbAgencyExportLogMessage.Level level) {
            this.i18nKey = string2;
            this.level = level;
        }

        public DbAgencyExportLogMessage.Level getLevel() {
            return this.level;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(ResponseCode.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(ResponseCode.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

