/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLogMessage;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.Is24RestTransportPanel;
import com.openindex.openestate.tool.utils.HttpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.ImportExport;
import org.openestate.is24.restapi.hc43.HttpComponents43Client;
import org.openestate.is24.restapi.utils.ExportHandler;
import org.openestate.is24.restapi.utils.ExportMessage;
import org.openestate.is24.restapi.utils.ExportPool;
import org.openestate.is24.restapi.utils.RequestFailedException;
import org.openestate.is24.restapi.xml.common.Message;
import org.openestate.is24.restapi.xml.common.MessageCode;
import org.openestate.is24.restapi.xml.common.PublishChannels;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24RestTransport
extends AbstractTransport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24RestTransport.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24RestTransport.class);
    private static final String NAME = "is24_rest";
    private static final String WEBSERVICE_URL = "webservice.url";
    private static final String WEBSERVICE_ACCESS_TOKEN = "webservice.access.token";
    private static final String WEBSERVICE_ACCESS_SECRET = "webservice.access.secret";
    private static final String WEBSERVICE_CONSUMER_DEFAULT = "webservice.consumer.default";
    private static final String WEBSERVICE_CONSUMER_TOKEN = "webservice.consumer.token";
    private static final String WEBSERVICE_CONSUMER_SECRET = "webservice.consumer.secret";
    public static final String LIVE_API = "https://rest.immobilienscout24.de/restapi";
    private static final String LIVE_API_CONSUMER_TOKEN = "OpenEstate-ImmoToolKey";
    private static final String LIVE_API_CONSUMER_SECRET = "1FwRzSwbUM9Y5Fbj";
    public static final String SANDBOX_API = "https://rest.sandbox-immobilienscout24.de/restapi";
    private static final String SANDBOX_API_CONSUMER_TOKEN = "testzugang-openestateKey";
    private static final String SANDBOX_API_CONSUMER_SECRET = "GUwRuFZq5rnvaTuFzP2m";
    private transient AbstractClient currentIs24Client = null;

    private void addMessageToExportContext(ResponseCode responseCode, String string, ExportContext exportContext) {
        this.addMessageToExportContext(responseCode, 0L, string, exportContext);
    }

    private void addMessageToExportContext(ResponseCode responseCode, String string, String string2, ExportContext exportContext) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        ExportEntry exportEntry = exportContext.getEntry(string);
        if (exportEntry == null) {
            this.addMessageToExportContext(responseCode, string2, exportContext);
        } else {
            this.addMessageToExportContext(responseCode, exportEntry.objectId, string2, exportContext);
        }
    }

    private void addMessageToExportContext(ResponseCode responseCode, long l, String string, ExportContext exportContext) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        if (l > 0L) {
            exportContext.addMessage(l, string, responseCode.name(), responseCode.getLogLevel());
        } else {
            exportContext.addMessage(string, responseCode.name(), responseCode.getLogLevel());
        }
    }

    @Override
    public AbstractTransportPanel createSetupPanel() {
        return new Is24RestTransportPanel();
    }

    @Override
    protected void doFinishTransport(ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException {
        if (this.currentIs24Client != null) {
            try {
                this.currentIs24Client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentIs24Client = null;
        }
    }

    @Override
    protected void doInitTransport(ExportContext exportContext, File file, ImmoToolTask.Callback callback) throws IOException {
        URI uRI = this.getWebserviceUrl();
        if (uRI == null) {
            throw new IOException("Unknown webservice URL!");
        }
        CloseableHttpClient closeableHttpClient = HttpUtils.builder().build();
        this.currentIs24Client = new HttpComponents43Client(uRI.toString(), this.getWebserviceConsumerToken(), this.getWebserviceConsumerSecret(), (HttpClient)closeableHttpClient);
        try {
            this.currentIs24Client.authorize(this.getWebserviceAccessToken(), this.getWebserviceAccessSecret());
        }
        catch (OAuthException oAuthException) {
            throw new IOException("Authorization at the webservice failed!", oAuthException);
        }
        try {
            ImportExport.ContactAddressService.getAll((AbstractClient)this.currentIs24Client);
        }
        catch (RequestFailedException requestFailedException) {
            if (requestFailedException.responseMessages != null) {
                for (Message message : requestFailedException.responseMessages.getMessage()) {
                    MessageCode messageCode = message.getMessageCode();
                    String string = StringUtils.trimToEmpty((String)message.getMessage());
                    if (MessageCode.ERROR_COMMON_ACCESS_DENIED.equals((Object)messageCode)) {
                        throw new IOException("Access to the webservice was denied (" + string + ")!", requestFailedException);
                    }
                    if (MessageCode.ERROR_COMMON_AUTHENTICATION_OAUTH_NONCE_EXPIRED.equals((Object)messageCode)) {
                        throw new IOException("Authentication has expired (" + string + ")!", requestFailedException);
                    }
                    if (MessageCode.ERROR_COMMON_AUTHENTICATION_REQUIRED.equals((Object)messageCode)) {
                        throw new IOException("No authentication was provided (" + string + ")!", requestFailedException);
                    }
                    if (MessageCode.ERROR_COMMON_INTERNAL_SERVER_ERROR.equals((Object)messageCode)) {
                        throw new IOException("An error at the webservice has occurred (" + string + ")!", requestFailedException);
                    }
                    if (!MessageCode.ERROR_COMMON_SERVICE_UNAVAILABLE.equals((Object)messageCode)) continue;
                    throw new IOException("The webservice is currently not available (" + string + ")!", requestFailedException);
                }
            }
            throw new IOException("Access to webservice is not possible!", requestFailedException);
        }
        catch (Exception exception) {
            throw new IOException("Access to webservice is not possible!", exception);
        }
    }

    public AbstractClient getCurrentIs24Client() {
        return this.currentIs24Client;
    }

    @Override
    public String getMessageCodeTranslation(String string, Locale locale) {
        for (ResponseCode responseCode : ResponseCode.values()) {
            if (!responseCode.name().equalsIgnoreCase(string)) continue;
            return locale != null ? responseCode.getTranslation(locale) : responseCode.getTranslation();
        }
        return super.getMessageCodeTranslation(string, locale);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return I18N.tr("Transport to the IS24 webservice.");
    }

    public String getWebserviceAccessSecret() {
        return StringUtils.trimToNull((String)((String)this.get(WEBSERVICE_ACCESS_SECRET)));
    }

    public String getWebserviceAccessToken() {
        return StringUtils.trimToNull((String)((String)this.get(WEBSERVICE_ACCESS_TOKEN)));
    }

    public String getWebserviceConsumerSecret() {
        if (this.isWebserviceConsumerDefault()) {
            URI uRI = this.getWebserviceUrl();
            if (uRI == null) {
                return null;
            }
            String string = uRI.toString();
            if (string.equals(LIVE_API)) {
                return LIVE_API_CONSUMER_SECRET;
            }
            if (string.equals(SANDBOX_API)) {
                return SANDBOX_API_CONSUMER_SECRET;
            }
            return null;
        }
        return StringUtils.trimToNull((String)((String)this.get(WEBSERVICE_CONSUMER_SECRET)));
    }

    public String getWebserviceConsumerToken() {
        if (this.isWebserviceConsumerDefault()) {
            URI uRI = this.getWebserviceUrl();
            if (uRI == null) {
                return null;
            }
            String string = uRI.toString();
            if (string.equals(LIVE_API)) {
                return String.valueOf(LIVE_API_CONSUMER_TOKEN);
            }
            if (string.equals(SANDBOX_API)) {
                return String.valueOf(SANDBOX_API_CONSUMER_TOKEN);
            }
            return null;
        }
        return StringUtils.trimToNull((String)((String)this.get(WEBSERVICE_CONSUMER_TOKEN)));
    }

    public URI getWebserviceUrl() {
        String string = StringUtils.trimToNull((String)((String)this.get(WEBSERVICE_URL)));
        try {
            return string != null ? new URI(string) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read webservice URL: '" + string + "'!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
            return null;
        }
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setWebserviceConsumerDefault(true);
        try {
            this.setWebserviceUrl(LIVE_API);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't set default IS24 webservice URL!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
    }

    @Override
    protected boolean isUpdatingMessage() {
        return true;
    }

    @Override
    protected boolean isUpdatingProgress() {
        return true;
    }

    public boolean isWebserviceConsumerDefault() {
        return !"false".equalsIgnoreCase((String)this.get(WEBSERVICE_CONSUMER_DEFAULT));
    }

    public void setWebserviceAccessSecret(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(WEBSERVICE_ACCESS_SECRET);
        } else {
            this.put(WEBSERVICE_ACCESS_SECRET, string);
        }
    }

    public void setWebserviceAccessToken(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(WEBSERVICE_ACCESS_TOKEN);
        } else {
            this.put(WEBSERVICE_ACCESS_TOKEN, string);
        }
    }

    public void setWebserviceConsumerDefault(boolean bl) {
        this.put(WEBSERVICE_CONSUMER_DEFAULT, Boolean.toString(bl));
    }

    public void setWebserviceConsumerSecret(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(WEBSERVICE_CONSUMER_SECRET);
        } else {
            this.put(WEBSERVICE_CONSUMER_SECRET, string);
        }
    }

    public void setWebserviceConsumerToken(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(WEBSERVICE_CONSUMER_TOKEN);
        } else {
            this.put(WEBSERVICE_CONSUMER_TOKEN, string);
        }
    }

    public void setWebserviceUrl(String string) throws URISyntaxException {
        this.setWebserviceUrl((string = StringUtils.trimToNull((String)string)) != null ? new URI(string) : null);
    }

    public void setWebserviceUrl(URI uRI) {
        if (uRI == null) {
            this.remove(WEBSERVICE_URL);
        } else {
            this.put(WEBSERVICE_URL, uRI.toString());
        }
    }

    private static enum ResponseCode implements Translatable
    {
        IS24_TRANSPORT_GENERAL_ERROR(null, I18n.marktr((String)"general error")),
        IS24_TRANSPORT_GENERAL_WARNING(null, I18n.marktr((String)"general warning")),
        IS24_TRANSPORT_GENERAL_NOTICE(null, I18n.marktr((String)"general notice")),
        IS24_TRANSPORT_CANT_DELETE_PROPERTY(ExportMessage.Code.OBJECT_NOT_REMOVED, I18n.marktr((String)"Can't delete property.")),
        IS24_TRANSPORT_CANT_DISABLE_PROPERTY(ExportMessage.Code.OBJECT_NOT_DISABLED, I18n.marktr((String)"Can't disable property.")),
        IS24_TRANSPORT_CANT_LOOKUP_CONTACT_PERSON(ExportMessage.Code.CONTACT_NOT_FOUND, I18n.marktr((String)"Can't lookup contact person.")),
        IS24_TRANSPORT_CANT_LOOKUP_PROPERTIES(ExportMessage.Code.OBJECTS_NOT_FOUND, I18n.marktr((String)"Can't lookup properties.")),
        IS24_TRANSPORT_CANT_LOOKUP_PROPERTY(ExportMessage.Code.OBJECT_NOT_FOUND, I18n.marktr((String)"Can't lookup property.")),
        IS24_TRANSPORT_CANT_LOOKUP_PROPERTY_FOR_ARCHIVING(ExportMessage.Code.OBJECT_NOT_FOUND_FOR_ARCHIVING, I18n.marktr((String)"Can't find property for archiving.")),
        IS24_TRANSPORT_CANT_LOOKUP_PROPERTY_FOR_DELETE(ExportMessage.Code.OBJECT_NOT_FOUND_FOR_REMOVING, I18n.marktr((String)"Can't find property for deletion.")),
        IS24_TRANSPORT_CANT_LOOKUP_PROPERTY_PUBLISHINGS(ExportMessage.Code.OBJECT_PUBLISHINGS_NOT_FOUND, I18n.marktr((String)"Can't lookup publishings for property.")),
        IS24_TRANSPORT_CANT_LOOKUP_PUBLISHING_CHANNELS(ExportMessage.Code.PUBLISH_CHANNELS_NOT_FOUND, I18n.marktr((String)"Can't lookup channels for publishing.")),
        IS24_TRANSPORT_CANT_REMOVE_OLD_PROPERTY_ATTACHMENT(ExportMessage.Code.OBJECT_OLD_ATTACHMENT_NOT_REMOVED, I18n.marktr((String)"Can't remove old attachments.")),
        IS24_TRANSPORT_CANT_SAVE_CONTACT_PERSON(ExportMessage.Code.CONTACT_NOT_SAVED, I18n.marktr((String)"Can't save contact person.")),
        IS24_TRANSPORT_CANT_SAVE_PROPERTY(ExportMessage.Code.OBJECT_NOT_SAVED, I18n.marktr((String)"Can't save property.")),
        IS24_TRANSPORT_CANT_SAVE_PROPERTY_ATTACHMENT(ExportMessage.Code.OBJECT_ATTACHMENT_NOT_SAVED, I18n.marktr((String)"Can't save property attachment.")),
        IS24_TRANSPORT_CANT_ORDER_PROPERTY_ATTACHMENTS(ExportMessage.Code.OBJECT_UNORDERED_ATTACHMENTS, I18n.marktr((String)"Can't order property attachments.")),
        IS24_TRANSPORT_CANT_UNPUBLISH_PROPERTY(ExportMessage.Code.OBJECT_NOT_UNPUBLISHED, I18n.marktr((String)"Can't unpublish property.")),
        IS24_TRANSPORT_PROPERTY_SENT_WITHOUT_ATTACHMENTS(ExportMessage.Code.OBJECT_WITHOUT_ATTACHMENTS, I18n.marktr((String)"Attachments were not saved for the property.")),
        IS24_TRANSPORT_PROPERTY_SENT_WITHOUT_CONTACT_PERSON(ExportMessage.Code.OBJECT_WITHOUT_CONTACT, I18n.marktr((String)"Contact person was not saved for the property.")),
        IS24_TRANSPORT_PROPERTY_SENT_WITHOUT_PUBLISHING(ExportMessage.Code.OBJECT_NOT_PUBLISHED, I18n.marktr((String)"Publishings were not saved for the property.")),
        IS24_TRANSPORT_XML_ERROR(ExportMessage.Code.XML_NOT_READABLE, I18n.marktr((String)"Can't read prepared XML."));

        private final ExportMessage.Code code;
        private final String i18nKey;

        private ResponseCode(ExportMessage.Code code, String string2) {
            this.code = code;
            this.i18nKey = string2;
        }

        public DbAgencyExportLogMessage.Level getLogLevel() {
            ExportMessage.Level level = this.getMessageLevel();
            switch (level) {
                case ERROR: {
                    return DbAgencyExportLogMessage.Level.ERROR;
                }
                case WARNING: {
                    return DbAgencyExportLogMessage.Level.WARNING;
                }
            }
            return DbAgencyExportLogMessage.Level.NOTICE;
        }

        public ExportMessage.Code getMessageCode() {
            return this.code;
        }

        public ExportMessage.Level getMessageLevel() {
            switch (this) {
                case IS24_TRANSPORT_GENERAL_ERROR: {
                    return ExportMessage.Level.ERROR;
                }
                case IS24_TRANSPORT_GENERAL_WARNING: {
                    return ExportMessage.Level.ERROR;
                }
                case IS24_TRANSPORT_GENERAL_NOTICE: {
                    return ExportMessage.Level.ERROR;
                }
            }
            return this.code != null ? this.code.getLevel() : null;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(ResponseCode.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(ResponseCode.class, (String)this.i18nKey, (Locale)locale);
        }

        public static ResponseCode lookup(ExportMessage.Code code) {
            for (ResponseCode responseCode : ResponseCode.values()) {
                if (responseCode.code == null || !code.equals((Object)responseCode.code)) continue;
                return responseCode;
            }
            if (code.isError()) {
                return IS24_TRANSPORT_GENERAL_ERROR;
            }
            if (code.isWarning()) {
                return IS24_TRANSPORT_GENERAL_WARNING;
            }
            return IS24_TRANSPORT_GENERAL_NOTICE;
        }
    }

    public static class Is24ExportRequest
    extends AbstractTransportRequest<Is24RestTransport> {
        private final File poolFolder;
        private final boolean disableUnpublishedObjects;
        private final boolean unpublishUntouchedObjects;

        public Is24ExportRequest(Is24RestTransport is24RestTransport, File file, boolean bl, boolean bl2) {
            super(is24RestTransport);
            if (file == null) {
                throw new IllegalArgumentException("No pool folder was specified!");
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("The pool folder is not a directory (" + file.getAbsolutePath() + ")!");
            }
            this.poolFolder = file;
            this.disableUnpublishedObjects = bl;
            this.unpublishUntouchedObjects = bl2;
        }

        @Override
        public AbstractTransportRequest[] getChildRequests() {
            return null;
        }

        @Override
        public String getTitle() {
            return StringUtils.capitalize((String)I18N.tr("transfer to IS24-Webservice"));
        }

        @Override
        public void send(ExportContext exportContext, ImmoToolTask.Callback callback) throws AbstractTransportRequest.TransferException {
            ExportPool exportPool;
            Is24RestTransport is24RestTransport = (Is24RestTransport)this.getTransport();
            AbstractClient abstractClient = is24RestTransport.getCurrentIs24Client();
            try {
                exportPool = new ExportPool(this.poolFolder);
                exportPool.readSettings();
            }
            catch (Exception exception) {
                throw new AbstractTransportRequest.TransferException("Can't load export pool!", exception);
            }
            Is24ExportHandler is24ExportHandler = new Is24ExportHandler(callback);
            Object[] objectArray = null;
            try {
                objectArray = is24ExportHandler.export(abstractClient, exportPool, this.disableUnpublishedObjects, this.unpublishUntouchedObjects);
            }
            catch (Exception exception) {
                throw new AbstractTransportRequest.TransferException("Transport failed!", exception);
            }
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                for (Object object : objectArray) {
                    ResponseCode responseCode = ResponseCode.lookup(object.getCode());
                    String string = StringUtils.trimToNull((String)object.getObjectId());
                    String string2 = StringUtils.trimToEmpty((String)object.getMessage());
                    String string3 = StringUtils.trimToNull((String)object.getErrorRequestRefNumber());
                    if (string3 != null) {
                        string2 = "REQUEST-NR " + string3 + " | " + string2;
                    }
                    if (string != null) {
                        is24RestTransport.addMessageToExportContext(responseCode, string, StringUtils.trimToNull((String)string2), exportContext);
                        continue;
                    }
                    is24RestTransport.addMessageToExportContext(responseCode, StringUtils.trimToNull((String)string2), exportContext);
                }
            }
        }
    }

    public static class Is24ExportHandler
    extends ExportHandler {
        private final ImmoToolTask.Callback callback;
        private final List<String> updatedIds = new ArrayList<String>();

        public Is24ExportHandler(ImmoToolTask.Callback callback) {
            this.callback = callback;
        }

        protected void doArchiveObject(RealEstate realEstate) throws IOException {
            this.callback.checkCancelled();
            super.doArchiveObject(realEstate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File doDownloadFile(URI uRI) throws IOException {
            this.callback.checkCancelled();
            if (uRI == null) {
                return null;
            }
            LOGGER.info("downloading " + uRI);
            Throwable throwable = null;
            try (CloseableHttpClient closeableHttpClient = HttpUtils.builder().build();){
                Object object;
                CloseableHttpResponse closeableHttpResponse;
                try {
                    closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)new HttpGet(uRI));
                }
                catch (Exception exception) {
                    throw new IOException("Can't download URL '" + uRI + "'!", exception);
                }
                StatusLine statusLine = closeableHttpResponse.getStatusLine();
                if (statusLine.getStatusCode() > 299) {
                    throw new IOException("Can't download URL '" + uRI + "'! (" + statusLine.getStatusCode() + " / " + statusLine.getReasonPhrase() + ")");
                }
                HttpEntity httpEntity = null;
                try {
                    File file = File.createTempFile("is24-export-attachment-", ".bin");
                    httpEntity = closeableHttpResponse.getEntity();
                    object = httpEntity.getContent();
                    Throwable throwable2 = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        IOUtils.copy((InputStream)object, (OutputStream)fileOutputStream);
                        fileOutputStream.flush();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (object != null) {
                            if (throwable2 != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                            } else {
                                ((InputStream)object).close();
                            }
                        }
                    }
                    object = file;
                }
                catch (Throwable throwable5) {
                    try {
                        EntityUtils.consumeQuietly(httpEntity);
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
                EntityUtils.consumeQuietly((HttpEntity)httpEntity);
                return object;
            }
        }

        protected Map<Long, String> doListUntouchedObjects() throws IOException {
            this.callback.checkCancelled();
            Map map = super.doListUntouchedObjects();
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                if (!this.updatedIds.contains(entry.getValue())) continue;
                LOGGER.warn("Object '" + (String)entry.getValue() + "' was returned as untouched although it was sent during this export. Therefore the object is not removed.");
                arrayList.add(entry.getKey());
            }
            for (Map.Entry entry : arrayList) {
                map.remove(entry);
            }
            return map;
        }

        protected PublishChannels doLoadPublishChannels() throws IOException {
            this.callback.checkCancelled();
            return super.doLoadPublishChannels();
        }

        protected void doPublishObject(long l, String string, PublishChannels publishChannels) throws IOException {
            super.doPublishObject(l, string, publishChannels);
        }

        protected void doRemoveObject(String string) throws IOException {
            this.callback.checkCancelled();
            super.doRemoveObject(string);
        }

        protected void doRemoveObject(long l, String string) throws IOException {
            this.callback.checkCancelled();
            super.doRemoveObject(l, string);
        }

        protected Long doUpdateContact(RealtorContactDetails realtorContactDetails, String string) throws IOException {
            this.callback.checkCancelled();
            return super.doUpdateContact(realtorContactDetails, string);
        }

        protected Long doUpdateObject(RealEstate realEstate, String string) throws IOException {
            this.callback.checkCancelled();
            this.updatedIds.add(realEstate.getExternalId());
            return super.doUpdateObject(realEstate, string);
        }

        protected void progressUpdated(long l, long l2) {
            if (l2 > 0L) {
                this.callback.setProgress(l, 0L, l2);
            }
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(1);
            String string = ImmoToolUtils.getHumanReadableByteCount((long)l2, (NumberFormat)numberFormat);
            String string2 = ImmoToolUtils.getHumanReadableByteCount((long)l, (NumberFormat)numberFormat);
            this.callback.setMessage(I18N.tr("{0} of {1}", (Object)string2, (Object)string));
            super.progressUpdated(l, l2);
        }
    }
}

