/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class LocalTransportPanel
extends AbstractTransportPanel<LocalTransport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalTransportPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(LocalTransportPanel.class);
    private ValidationHandler validationHandler;
    private JLabel directoryLabel;
    private JTextField directoryField;
    private AbstractI18nAction directorySelectAction;

    public LocalTransportPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.directoryLabel = new JLabel();
        this.directoryField = new JTextField();
        this.directoryField.setName("directoryField");
        this.directorySelectAction = new DirectorySelectAction();
        this.validationHandler.putRule((JComponent)this.directoryField, new ValidationRule(){

            public boolean isValid(Object object) {
                return new File((String)object).isDirectory();
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu:grow, 3dlu, pref", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.directoryLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.directoryField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JButton((Action)this.directorySelectAction)).xy(5, defaultFormBuilder.row());
        this.updateLocalization();
        this.load((DbAgencyExport)null, (LocalTransport)null);
    }

    private void doDirectorySelect() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(I18N.tr("Select a destination folder."));
        jFileChooser.setApproveButtonText(StringUtils.capitalize((String)I18N.tr("select directory")));
        jFileChooser.setFileSelectionMode(1);
        String string = StringUtils.trimToNull((String)this.directoryField.getText());
        jFileChooser.setSelectedFile(string != null ? new File(string) : AgencyPlugin.getLastExportLocation());
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        AgencyPlugin.setLastExportLocation(jFileChooser.getSelectedFile());
        this.directoryField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        this.validationHandler.validate((JComponent)this.directoryField);
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, LocalTransport localTransport) {
        if (localTransport == null) {
            this.directoryField.setText(SystemUtils.getUserHome().getAbsolutePath());
        } else {
            File file = localTransport.getLocalDirectory();
            this.directoryField.setText(file != null ? file.getAbsolutePath() : SystemUtils.getUserHome().getAbsolutePath());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, LocalTransport localTransport) {
        if (localTransport == null) {
            throw new NullPointerException("empty transport-class!");
        }
        localTransport.setLocalDirectory(new File(this.directoryField.getText().trim()));
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.directoryLabel.setText(StringUtils.capitalize((String)I18N.tr("destination folder")) + ":");
        this.directoryField.setToolTipText(I18N.tr("The properties are exported into this folder."));
    }

    private class DirectorySelectAction
    extends AbstractI18nAction {
        public DirectorySelectAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LocalTransportPanel.this.doDirectorySelect();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("select")));
            this.setShortDescription(I18N.tr("Select a destination folder from your harddisk, where properties are exported to."));
        }
    }
}

