/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractPdfExpose;
import com.openindex.openestate.tool.agency.gui.ExposeHorizontalAlignRenderer;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.ColorPickButton;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractExposePanel<ExposeType extends AbstractExpose>
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExposePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractExposePanel.class);

    public abstract boolean isTemplateSelected();

    public abstract boolean isValidInput();

    public abstract void load(ExposeType var1);

    public abstract void save(ExposeType var1);

    public static class ResolutionRenderer
    extends TranslatableRenderer<Resolution> {
        public String getEmptyText() {
            return I18N.tr("Don't specify a resolution.");
        }
    }

    public static enum Resolution implements Translatable
    {
        RESOLUTION_72(72, I18n.marktr((String)"for screen-presentations in regular quality")),
        RESOLUTION_144(144, I18n.marktr((String)"for screen-presentations in high quality")),
        RESOLUTION_300(300, I18n.marktr((String)"for print-presentations in high quality")),
        RESOLUTION_600(600, I18n.marktr((String)"for print-presentations in very high quality"));

        private final int value;
        private final String i18nKey;

        private Resolution(int n2, String string2) {
            this.value = n2;
            this.i18nKey = string2;
        }

        public int getValue() {
            return this.value;
        }

        public String getTranslation() {
            return this.value + " dpi | " + ImmoToolUtils.getI18nString(AbstractExposePanel.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return this.value + " dpi | " + ImmoToolUtils.getI18nString(AbstractExposePanel.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static class HeaderAndFooterTab
    extends AbstractTab {
        private JXTitledSeparator headerTitle;
        private JLabel headerColorsLabel;
        private JLabel headerOptionsLabel;
        private JCheckBox headerVisibleBox;
        private JCheckBox headerLogoVisibleBox;
        private JCheckBox headerTextBox;
        private ColorPickButton headerTextFgColorButton;
        private JLabel headerTextLine1Label;
        private JTextField headerTextLine1Field;
        private JLabel headerTextLine2Label;
        private JTextField headerTextLine2Field;
        private JLabel headerTextLine3Label;
        private JTextField headerTextLine3Field;
        private JXTitledSeparator footerTitle;
        private JLabel footerColorsLabel;
        private JLabel footerOptionsLabel;
        private JCheckBox footerVisibleBox;
        private JLabel footerAlignmentLabel;
        private JComboBox<AbstractExpose.HorizontalAlign> footerAlignmentBox;
        private ColorPickButton footerTextFgColorButton;

        public HeaderAndFooterTab() {
            this.build();
        }

        private void build() {
            this.headerTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.headerColorsLabel = new JLabel();
            this.headerOptionsLabel = new JLabel();
            this.footerTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.footerColorsLabel = new JLabel();
            this.footerOptionsLabel = new JLabel();
            this.footerTextFgColorButton = new ColorPickButton();
            this.footerVisibleBox = new JCheckBox();
            this.footerVisibleBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderAndFooterTab.this.setFooterEnabled(HeaderAndFooterTab.this.footerVisibleBox.isSelected());
                }
            });
            this.footerAlignmentLabel = new JLabel();
            this.footerAlignmentBox = new JComboBox();
            this.footerAlignmentBox.setRenderer((ListCellRenderer<AbstractExpose.HorizontalAlign>)new DefaultListCellRenderer((Renderer)new ExposeHorizontalAlignRenderer()));
            this.footerAlignmentBox.addItem(AbstractExpose.HorizontalAlign.LEFT);
            this.footerAlignmentBox.addItem(AbstractExpose.HorizontalAlign.CENTER);
            this.footerAlignmentBox.addItem(AbstractExpose.HorizontalAlign.RIGHT);
            this.headerLogoVisibleBox = new JCheckBox();
            this.headerTextFgColorButton = new ColorPickButton();
            this.headerTextBox = new JCheckBox();
            this.headerTextBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderAndFooterTab.this.setHeaderTextEnabled(HeaderAndFooterTab.this.headerTextBox.isSelected());
                }
            });
            this.headerTextLine1Label = new JLabel();
            this.headerTextLine1Field = new JTextField();
            this.headerTextLine2Label = new JLabel();
            this.headerTextLine2Field = new JTextField();
            this.headerTextLine3Label = new JLabel();
            this.headerTextLine3Field = new JTextField();
            this.headerVisibleBox = new JCheckBox();
            this.headerVisibleBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderAndFooterTab.this.setHeaderEnabled(HeaderAndFooterTab.this.headerVisibleBox.isSelected());
                }
            });
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.headerTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.headerOptionsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.headerVisibleBox).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.headerLogoVisibleBox).xyw(3, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.headerTextBox).xyw(3, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.headerTextLine1Label).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.headerTextLine1Field).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.headerTextLine2Label).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.headerTextLine2Field).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.headerTextLine3Label).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.headerTextLine3Field).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.headerColorsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.headerTextFgColorButton).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.footerTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.footerOptionsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.footerVisibleBox).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.footerAlignmentLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.footerAlignmentBox).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.footerColorsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.footerTextFgColorButton).xyw(3, defaultFormBuilder.row(), 3);
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.setHeaderSelected(true);
            this.setHeaderTextSelected(false);
            this.setFooterSelected(true);
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("header & footer"));
        }

        public void load(AbstractPdfExpose abstractPdfExpose) {
            this.setFooterSelected(abstractPdfExpose.isFooter());
            this.footerAlignmentBox.setSelectedItem((Object)abstractPdfExpose.getFooterTextAlignment());
            this.footerTextFgColorButton.setColor(abstractPdfExpose.getFooterTextFgColor());
            this.setHeaderSelected(abstractPdfExpose.isHeader());
            this.headerLogoVisibleBox.setSelected(abstractPdfExpose.isHeaderLogo());
            this.headerTextFgColorButton.setColor(abstractPdfExpose.getHeaderTextFgColor());
            this.setHeaderTextSelected(abstractPdfExpose.isHeaderTextCustom());
            this.headerTextLine1Field.setText(abstractPdfExpose.getHeaderTextCustomLine1());
            this.headerTextLine2Field.setText(abstractPdfExpose.getHeaderTextCustomLine2());
            this.headerTextLine3Field.setText(abstractPdfExpose.getHeaderTextCustomLine3());
        }

        public void save(AbstractPdfExpose abstractPdfExpose) {
            abstractPdfExpose.setFooter(this.footerVisibleBox.isSelected());
            if (this.footerVisibleBox.isSelected()) {
                abstractPdfExpose.setFooterTextFgColor(this.footerTextFgColorButton.getColor());
                abstractPdfExpose.setFooterTextAlignment((AbstractExpose.HorizontalAlign)((Object)this.footerAlignmentBox.getSelectedItem()));
            } else {
                abstractPdfExpose.setFooterTextFgColor(null);
                abstractPdfExpose.setFooterTextAlignment(null);
            }
            abstractPdfExpose.setHeader(this.headerVisibleBox.isSelected());
            abstractPdfExpose.setHeaderLogo(this.headerLogoVisibleBox.isSelected());
            abstractPdfExpose.setHeaderTextFgColor(this.headerVisibleBox.isSelected() ? this.headerTextFgColorButton.getColor() : null);
            abstractPdfExpose.setHeaderTextCustom(this.headerTextBox.isEnabled() && this.headerTextBox.isSelected());
            if (this.headerTextBox.isEnabled() && this.headerTextBox.isSelected()) {
                abstractPdfExpose.setHeaderTextCustomLine1(this.headerTextLine1Field.getText().trim());
                abstractPdfExpose.setHeaderTextCustomLine2(this.headerTextLine2Field.getText().trim());
                abstractPdfExpose.setHeaderTextCustomLine3(this.headerTextLine3Field.getText().trim());
            } else {
                abstractPdfExpose.setHeaderTextCustomLine1(null);
                abstractPdfExpose.setHeaderTextCustomLine2(null);
                abstractPdfExpose.setHeaderTextCustomLine3(null);
            }
        }

        private void setFooterEnabled(boolean bl) {
            this.footerAlignmentBox.setEnabled(bl);
            this.footerTextFgColorButton.setEnabled(bl);
        }

        private void setFooterSelected(boolean bl) {
            this.footerVisibleBox.setSelected(bl);
            this.setFooterEnabled(bl);
        }

        private void setHeaderEnabled(boolean bl) {
            this.headerLogoVisibleBox.setEnabled(bl);
            this.headerTextFgColorButton.setEnabled(bl);
            this.headerTextBox.setEnabled(bl);
            this.setHeaderTextEnabled(bl);
        }

        private void setHeaderSelected(boolean bl) {
            this.headerVisibleBox.setSelected(bl);
            this.setHeaderEnabled(bl);
            this.setHeaderTextSelected(bl && this.headerTextBox.isSelected());
        }

        private void setHeaderTextEnabled(boolean bl) {
            this.headerTextLine1Field.setEnabled(bl);
            this.headerTextLine1Field.setEditable(bl);
            this.headerTextLine2Field.setEnabled(bl);
            this.headerTextLine2Field.setEditable(bl);
            this.headerTextLine3Field.setEnabled(bl);
            this.headerTextLine3Field.setEditable(bl);
        }

        private void setHeaderTextSelected(boolean bl) {
            this.headerTextBox.setSelected(bl);
            this.setHeaderTextEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.headerTitle.setTitle(StringUtils.capitalize((String)I18N.tr("document header")));
            this.headerTextBox.setText(I18N.tr("Show custom header text."));
            this.headerTextBox.setToolTipText(I18N.tr("Enable this option, to show a custom text within the header."));
            this.headerTextLine1Label.setText(StringUtils.capitalize((String)I18N.tr("line")) + " 1:");
            this.headerTextLine1Field.setText(I18N.tr("This text is shown as first line within the header."));
            this.headerTextLine2Label.setText(StringUtils.capitalize((String)I18N.tr("line")) + " 2:");
            this.headerTextLine2Field.setText(I18N.tr("This text is shown as second line within the header."));
            this.headerTextLine3Label.setText(StringUtils.capitalize((String)I18N.tr("line")) + " 3:");
            this.headerTextLine3Field.setText(I18N.tr("This text is shown as third line within the header."));
            this.headerColorsLabel.setText(StringUtils.capitalize((String)I18N.tr("colors")) + ":");
            this.headerTextFgColorButton.setText(I18N.tr("foreground color of texts"));
            this.headerTextFgColorButton.setToolTipText(I18N.tr("This color is used for texts."));
            this.headerOptionsLabel.setText(StringUtils.capitalize((String)I18N.tr("options")) + ":");
            this.headerVisibleBox.setText(I18N.tr("Show header."));
            this.headerVisibleBox.setToolTipText(I18N.tr("Enable this option, to insert a header automatically into the generated document."));
            this.headerLogoVisibleBox.setText(I18N.tr("Show company logo in the header."));
            this.headerLogoVisibleBox.setToolTipText(I18N.tr("Enable this option, to display the company logo within the header."));
            this.footerTitle.setTitle(StringUtils.capitalize((String)I18N.tr("document footer")));
            this.footerColorsLabel.setText(StringUtils.capitalize((String)I18N.tr("colors")) + ":");
            this.footerTextFgColorButton.setText(I18N.tr("foreground color of texts"));
            this.footerTextFgColorButton.setToolTipText(I18N.tr("This color is used for texts."));
            this.footerAlignmentLabel.setText(StringUtils.capitalize((String)I18N.tr("orientation")) + ":");
            this.footerAlignmentBox.setToolTipText(I18N.tr("Set alignment of texts."));
            this.footerOptionsLabel.setText(StringUtils.capitalize((String)I18N.tr("options")) + ":");
            this.footerVisibleBox.setText(I18N.tr("Show footer."));
            this.footerVisibleBox.setToolTipText(I18N.tr("Enable this option, to insert a footer automatically into the generated document."));
        }
    }

    public static class EncryptionTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JCheckBox encryptionField;
        private JLabel passwordLabel;
        private JTextField passwordField;
        private JLabel permissionLabel;
        private JCheckBox allowAccessibilityField;
        private JCheckBox allowCopyingField;
        private JCheckBox allowPrintingField;

        public EncryptionTab() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.passwordLabel = new JLabel();
            this.permissionLabel = new JLabel();
            this.encryptionField = new JCheckBox();
            this.encryptionField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EncryptionTab.this.allowPrintingField.setEnabled(EncryptionTab.this.encryptionField.isSelected());
                    EncryptionTab.this.allowAccessibilityField.setEnabled(EncryptionTab.this.encryptionField.isSelected());
                    EncryptionTab.this.allowCopyingField.setEnabled(EncryptionTab.this.encryptionField.isSelected());
                    EncryptionTab.this.passwordField.setEnabled(EncryptionTab.this.encryptionField.isSelected());
                }
            });
            this.allowPrintingField = new JCheckBox();
            this.allowPrintingField.setSelected(true);
            this.allowCopyingField = new JCheckBox();
            this.allowCopyingField.setSelected(true);
            this.allowCopyingField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EncryptionTab.this.allowAccessibilityField.setEnabled(!EncryptionTab.this.allowCopyingField.isSelected());
                    if (EncryptionTab.this.allowCopyingField.isSelected()) {
                        EncryptionTab.this.allowAccessibilityField.setSelected(true);
                    }
                }
            });
            this.allowAccessibilityField = new JCheckBox();
            this.allowAccessibilityField.setSelected(true);
            this.passwordField = new JTextField();
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.encryptionField).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.passwordLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.passwordField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.permissionLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.allowPrintingField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.allowCopyingField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.allowAccessibilityField).xy(3, defaultFormBuilder.nextRow());
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("encryption"));
        }

        public void load(AbstractPdfExpose abstractPdfExpose) {
            this.encryptionField.setSelected(abstractPdfExpose.isEncryption());
            this.passwordField.setEnabled(abstractPdfExpose.isEncryption());
            this.passwordField.setText(abstractPdfExpose.getEncryptionPassword());
            this.allowPrintingField.setEnabled(abstractPdfExpose.isEncryption());
            this.allowPrintingField.setSelected(abstractPdfExpose.isEncryptionPrintingAllowed());
            this.allowCopyingField.setEnabled(abstractPdfExpose.isEncryption());
            this.allowCopyingField.setSelected(abstractPdfExpose.isEncryptionCopyingAllowed());
            this.allowAccessibilityField.setEnabled(abstractPdfExpose.isEncryption() && !abstractPdfExpose.isEncryptionCopyingAllowed());
            this.allowAccessibilityField.setSelected(abstractPdfExpose.isEncryptionCopyingAllowed() || abstractPdfExpose.isEncryptionAccessibilityAllowed());
        }

        public void save(AbstractPdfExpose abstractPdfExpose) {
            abstractPdfExpose.setEncryption(this.encryptionField.isSelected());
            abstractPdfExpose.setEncryptionPassword(this.passwordField.getText());
            abstractPdfExpose.setEncryptionPrintingAllowed(this.allowPrintingField.isSelected());
            abstractPdfExpose.setEncryptionCopyingAllowed(this.allowCopyingField.isSelected());
            abstractPdfExpose.setEncryptionAccessibilityAllowed(this.allowAccessibilityField.isSelected());
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("encryption & password protection")));
            this.encryptionField.setText(I18N.tr("Encrypt the document and protect it with a password."));
            this.encryptionField.setToolTipText(I18N.tr("Enable this option to create an encrypted / protected document."));
            this.permissionLabel.setText(StringUtils.capitalize((String)I18N.tr("credentials")) + ":");
            this.allowPrintingField.setText(StringUtils.capitalize((String)I18N.tr("printing the document")));
            this.allowPrintingField.setToolTipText(I18N.tr("Allow printing of the created document."));
            this.allowCopyingField.setText(StringUtils.capitalize((String)I18N.tr("copying contents of the document")));
            this.allowCopyingField.setToolTipText(I18N.tr("Allow copying the content of the created document."));
            this.allowAccessibilityField.setText(StringUtils.capitalize((String)I18N.tr("barrier-free access to the document")));
            this.allowAccessibilityField.setToolTipText(I18N.tr("Allow reading of the created document with accessibility programs - e.g. screen readers."));
            this.passwordLabel.setText(StringUtils.capitalize((String)I18N.tr("password")) + ":");
            this.passwordField.setToolTipText(I18N.tr("Enter a password for protected access to the created document."));
        }
    }
}

