/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.DefaultSplitCharacter;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.attribs.descriptions.Keywords;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.AgentFeeIncludingVat;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolAgent;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractExposePanel;
import com.openindex.openestate.tool.agency.expose.AbstractPdfExpose;
import com.openindex.openestate.tool.agency.expose.PdfDetailedExpose;
import com.openindex.openestate.tool.agency.expose.PdfShortExposePanel;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class PdfShortExpose
extends AbstractPdfExpose {
    private static final long serialVersionUID = 4138552741231L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfShortExpose.class);
    private static final I18n I18N = I18nFactory.getI18n(PdfShortExpose.class);
    public static final String NAME = "shortPdf";
    private static final String GALLERY_MODE = "shortPdf.gallery.mode";
    private static final String CONTACT_PUBLISHING = "shortPdf.contact.publishing";
    private static final float LANDSCAPE_HEIGHT_DESCRIPTION = 275.0f;
    private static final float LANDSCAPE_HEIGHT_ATTRIBS_TOP = 35.0f;
    private static final float LANDSCAPE_HEIGHT_ATTRIBS_BOTTOM = 35.0f;
    private static final float LANDSCAPE_HEIGHT_HEAD = 35.0f;
    private static final float LANDSCAPE_HEIGHT_SUBHEAD = 20.0f;
    private static final float LANDSCAPE_HEIGHT_IMAGE = 330.0f;
    private static final float LANDSCAPE_HEIGHT_TYPE = 35.0f;
    private static final float LANDSCAPE_HEIGHT_PRICES = 35.0f;
    private static final float LANDSCAPE_HEIGHT_CONTACT = 35.0f;
    private static final float PORTRAIT_HEIGHT_DESCRIPTION = 350.0f;
    private static final float PORTRAIT_HEIGHT_ATTRIBS_TOP = 35.0f;
    private static final float PORTRAIT_HEIGHT_ATTRIBS_BOTTOM = 35.0f;
    private static final float PORTRAIT_HEIGHT_HEAD = 35.0f;
    private static final float PORTRAIT_HEIGHT_SUBHEAD = 20.0f;
    private static final float PORTRAIT_HEIGHT_IMAGE = 180.0f;
    private static final float PORTRAIT_HEIGHT_TYPE = 35.0f;
    private static final float PORTRAIT_HEIGHT_PRICES = 35.0f;
    private static final float PORTRAIT_HEIGHT_CONTACT = 35.0f;
    private transient I18n i18n = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void build(OutputStream outputStream) throws IOException, DocumentException {
        block21: {
            DbAgencyObject dbAgencyObject = this.getEstateObject();
            Boolean bl = dbAgencyObject.item.getAddress().isPublished();
            PublishingMode publishingMode = this.getPublishAddress();
            if (PublishingMode.ALWAYS.equals((Object)publishingMode)) {
                dbAgencyObject.item.getAddress().setPublished(true);
            } else if (PublishingMode.NEVER.equals((Object)publishingMode)) {
                dbAgencyObject.item.getAddress().setPublished(false);
            }
            try {
                File file;
                File file2 = file = this.isTemplate() ? this.getTemplateFile() : null;
                if (file != null && file.isFile()) {
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        this.build(fileInputStream, outputStream);
                        break block21;
                    }
                }
                if (AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation)) {
                    this.build(PageSize.A4.rotate(), outputStream);
                } else {
                    this.build(PageSize.A4, outputStream);
                }
            }
            finally {
                dbAgencyObject.item.getAddress().setPublished(Boolean.TRUE.equals(bl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(InputStream inputStream, OutputStream outputStream) throws IOException, DocumentException {
        try (PdfReader pdfReader = null;){
            pdfReader = new PdfReader(inputStream);
            this.build(pdfReader, pdfReader.getPageSize(1), outputStream);
        }
    }

    private void build(Rectangle rectangle, OutputStream outputStream) throws IOException, DocumentException {
        this.build(null, rectangle, outputStream);
    }

    private void build(PdfReader pdfReader, Rectangle rectangle, OutputStream outputStream) throws IOException, DocumentException {
        ImmoToolAgent immoToolAgent = this.getAgent();
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        String string = StringUtils.trimToEmpty((String)dbAgencyObject.item.getTitle(this.locale.getLanguage()));
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        Document document = new Document(new Rectangle(f, f2));
        PdfPTable pdfPTable = this.createTable(rectangle);
        if (pdfPTable.getNumberOfColumns() == 2) {
            pdfPTable.setWidths(new float[]{pdfPTable.getTotalWidth() * 0.65f, pdfPTable.getTotalWidth() * 0.35f});
        }
        this.buildDocument(document, pdfPTable, pdfReader, rectangle, outputStream);
        document.addAuthor(immoToolAgent != null && immoToolAgent.getCompany() != null ? StringUtils.trimToEmpty((String)immoToolAgent.getCompany().getCompanyName()) : "");
        document.addCreationDate();
        document.addCreator(ImmoToolEnvironment.getApplicationTitle() + " v" + ImmoToolEnvironment.getApplicationVersion());
        document.addProducer();
        document.addSubject(StringUtils.capitalize((String)this.i18n.tr("property")) + " #" + dbAgencyObject.id);
        document.addTitle(string);
        String string2 = Keywords.get((EstateImpl)dbAgencyObject.item, (Locale)this.locale);
        if (!StringUtils.isBlank((CharSequence)string2)) {
            document.addKeywords(string2.trim());
        }
        document.close();
    }

    protected PdfPTable createExposeAttribsBottomTable(List<OpenEstateType> list, Color color, float f, float f2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        OpenEstateAttrib openEstateAttrib;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontH3);
        font2.setColor(color);
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
            arrayList.add(OpenEstateAttrib.FEATURES_TYPE_OF_HEATING);
            arrayList.add(OpenEstateAttrib.FEATURES_FLOORING_MATERIAL);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_ROOMS_MODIFIABLE);
            arrayList.add(OpenEstateAttrib.FEATURES_BASEMENT);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_ZONE);
        } else if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_ACCESS_BEGIN_DATE);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_BUILDABLE_IN_SHORT_TERM);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_BUILDABLE_WITH);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_COMMERCIAL_USE);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_DEMOLITION_REQUIRED);
            arrayList.add(OpenEstateAttrib.FEATURES_STOCK_OF_TREES);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_ZONE);
        } else if (list.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_DEMOLITION_REQUIRED);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_NEXT_TOWN);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_DISTANCE_TO_BUS_STATION);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_DISTANCE_TO_NEXT_TRAIN_STATION);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_DISTANCE_TO_MAIN_LINE_STATION);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_DISTANCE_TO_MOTORWAY);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_DISTANCE_TO_AIRPORT);
        } else if (list.contains(OpenEstateType.GENERAL_PARKING)) {
            arrayList.add(OpenEstateAttrib.FEATURES_LIT_UP);
            arrayList.add(OpenEstateAttrib.FEATURES_APPLICABILITY);
            arrayList.add(OpenEstateAttrib.FEATURES_SECURITY_TECHNOLOGY);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_ACCESS_BEGIN_DATE);
        } else if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
            arrayList.add(OpenEstateAttrib.PRICES_COMMON_CHARGE);
            arrayList.add(OpenEstateAttrib.FEATURES_TYPE_OF_HEATING);
            arrayList.add(OpenEstateAttrib.MEASURES_CAR_PARKING_TYPE);
            arrayList.add(OpenEstateAttrib.FEATURES_FURNISHED);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_PETS);
            arrayList.add(OpenEstateAttrib.FEATURES_GARDEN_USE);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_HOLIDAY_PROPERTY);
            arrayList.add(OpenEstateAttrib.FEATURES_BALCONY_TERRACE);
            arrayList.add(OpenEstateAttrib.FEATURES_EQUIPMENT);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (linkedHashMap.size() < 3 && (openEstateAttrib = PdfShortExpose.pickAttribute(dbAgencyObject, arrayList, stringBuilder2 = new StringBuilder(), stringBuilder = new StringBuilder(), this.locale)) != null) {
            arrayList.remove(openEstateAttrib);
            linkedHashMap.put(stringBuilder2.toString().trim(), stringBuilder.toString().trim());
        }
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        stringBuilder2 = new PdfPTable(linkedHashMap.size());
        float f3 = f / (float)linkedHashMap.size() - 4.0f;
        float f4 = f2 - font.getSize() - 5.0f;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = StringUtils.abbreviate((String)((String)entry.getValue()), (int)(linkedHashMap.size() * 150));
            Font font3 = PdfShortExpose.getMatchingFont(string2, f3, f4, font2, 1.0f);
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            pdfPCell.addElement((Element)new Paragraph(font.getSize(), string, font));
            Paragraph paragraph = new Paragraph(string2, font3);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            pdfPCell.addElement((Element)paragraph);
            stringBuilder2.addCell(pdfPCell);
        }
        return stringBuilder2;
    }

    protected PdfPTable createExpsoseAttribsPriceTable(Color color, float f, float f2) {
        Font font;
        String string;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        Font font2 = new Font(this.bodyFontSmall);
        font2.setColor(color);
        Font font3 = new Font(this.bodyFontH3);
        font3.setColor(color);
        Paragraph paragraph = null;
        PdfPCell pdfPCell = null;
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        ArrayList<OpenEstateAttrib> arrayList2 = new ArrayList<OpenEstateAttrib>();
        ArrayList<OpenEstateAttrib> arrayList3 = new ArrayList<OpenEstateAttrib>();
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)dbAgencyObject.item.getAction()) || OpenEstateAction.LEASE.equals((Object)dbAgencyObject.item.getAction())) {
            arrayList.add(OpenEstateAttrib.PRICES_LEASE);
            arrayList2.add(OpenEstateAttrib.PRICES_LEASE_PER_AREA);
        } else if (OpenEstateAction.PURCHASE.equals((Object)dbAgencyObject.item.getAction())) {
            arrayList.add(OpenEstateAttrib.PRICES_PURCHASE_PRICE);
            arrayList2.add(OpenEstateAttrib.PRICES_PURCHASE_PRICE_PER_AREA);
            arrayList2.add(OpenEstateAttrib.PRICES_RENTAL_INCOME_PER_MONTH);
            arrayList3.add(OpenEstateAttrib.PRICES_CAR_PARKING_SPACE_PRICE);
        } else if (OpenEstateAction.RENT.equals((Object)dbAgencyObject.item.getAction())) {
            arrayList.add(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES);
            arrayList.add(OpenEstateAttrib.PRICES_RENT_INCLUDING_SERVICE_CHARGES);
            arrayList2.add(OpenEstateAttrib.PRICES_SERVICE_CHARGES);
            arrayList2.add(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES_PER_AREA);
            arrayList2.add(OpenEstateAttrib.PRICES_RENT_INCLUDING_SERVICE_CHARGES_PER_AREA);
            arrayList3.add(OpenEstateAttrib.PRICES_CAR_PARKING_SPACE_RENT);
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)dbAgencyObject.item.getAction())) {
            arrayList.add(OpenEstateAttrib.PRICES_RENT_FLAT_RATE);
            arrayList.add(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES);
            arrayList.add(OpenEstateAttrib.PRICES_RENT_INCLUDING_SERVICE_CHARGES);
            arrayList2.add(OpenEstateAttrib.PRICES_RENT_FLAT_RATE_PER);
            arrayList2.add(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES_PER_AREA);
            arrayList2.add(OpenEstateAttrib.PRICES_RENT_INCLUDING_SERVICE_CHARGES_PER_AREA);
            arrayList3.add(OpenEstateAttrib.PRICES_CAR_PARKING_SPACE_RENT);
        } else if (OpenEstateAction.AUCTION.equals((Object)dbAgencyObject.item.getAction())) {
            arrayList.add(OpenEstateAttrib.PRICES_MARKET_VALUE);
            arrayList2.add(OpenEstateAttrib.PRICES_LOWEST_BID);
            arrayList3.add(OpenEstateAttrib.ADMINISTRATION_AUCTION_DATE);
        } else {
            LOGGER.warn("Unsupported estate action: '" + dbAgencyObject.item.getAction() + "'!");
            return null;
        }
        arrayList3.add(OpenEstateAttrib.PRICES_DEPOSIT);
        arrayList3.add(OpenEstateAttrib.PRICES_DEPOSIT_AMOUNT);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        OpenEstateAttrib openEstateAttrib = PdfShortExpose.pickAttribute(dbAgencyObject, arrayList, stringBuilder, stringBuilder2, this.locale);
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        OpenEstateAttrib openEstateAttrib2 = PdfShortExpose.pickAttribute(dbAgencyObject, arrayList2, stringBuilder3, stringBuilder4, this.locale);
        StringBuilder stringBuilder5 = new StringBuilder();
        StringBuilder stringBuilder6 = new StringBuilder();
        OpenEstateAttrib openEstateAttrib3 = PdfShortExpose.pickAttribute(dbAgencyObject, arrayList3, stringBuilder5, stringBuilder6, this.locale);
        PdfPTable pdfPTable = new PdfPTable(openEstateAttrib3 != null ? 3 : (openEstateAttrib2 != null ? 2 : 1));
        float f3 = f / (float)pdfPTable.getNumberOfColumns() - 4.0f;
        float f4 = f2 - font2.getSize() - 5.0f;
        if (pdfPTable.getNumberOfColumns() >= 1) {
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            if (openEstateAttrib != null) {
                string = stringBuilder2.toString().trim();
                font = PdfShortExpose.getMatchingFont(string, f3, f4, font3, 1.0f);
                pdfPCell.addElement((Element)new Paragraph(font2.getSize(), stringBuilder.toString(), font2));
                paragraph = new Paragraph(string, font);
                paragraph.setAlignment(0);
                paragraph.setMultipliedLeading(1.0f);
                pdfPCell.addElement((Element)paragraph);
            }
            pdfPTable.addCell(pdfPCell);
        }
        if (pdfPTable.getNumberOfColumns() >= 2) {
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            if (openEstateAttrib2 != null) {
                string = stringBuilder4.toString().trim();
                font = PdfShortExpose.getMatchingFont(string, f3, f4, font3, 1.0f);
                pdfPCell.addElement((Element)new Paragraph(font2.getSize(), stringBuilder3.toString(), font2));
                paragraph = new Paragraph(string, font);
                paragraph.setAlignment(0);
                paragraph.setMultipliedLeading(1.0f);
                pdfPCell.addElement((Element)paragraph);
            }
            pdfPTable.addCell(pdfPCell);
        }
        if (pdfPTable.getNumberOfColumns() >= 3) {
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            if (openEstateAttrib3 != null) {
                string = stringBuilder6.toString().trim();
                font = PdfShortExpose.getMatchingFont(string, f3, f4, font3, 1.0f);
                pdfPCell.addElement((Element)new Paragraph(font2.getSize(), stringBuilder5.toString(), font2));
                paragraph = new Paragraph(string, font);
                paragraph.setAlignment(0);
                paragraph.setMultipliedLeading(1.0f);
                pdfPCell.addElement((Element)paragraph);
            }
            pdfPTable.addCell(pdfPCell);
        }
        return pdfPTable;
    }

    protected PdfPTable createExposeAttribsTopTable(List<OpenEstateType> list, Color color, float f, float f2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        OpenEstateAttrib openEstateAttrib;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontH3);
        font2.setColor(color);
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        if (list.contains(OpenEstateType.MULTI_FAMILY_HOUSE)) {
            arrayList.add(OpenEstateAttrib.MEASURES_COUNT_RESIDENTIAL_UNITS);
            arrayList.add(OpenEstateAttrib.MEASURES_COUNT_COMMERCIAL_UNITS);
            arrayList.add(OpenEstateAttrib.FEATURES_COUNT_FLOORS);
            arrayList.add(OpenEstateAttrib.MEASURES_RESIDENTIAL_AREA);
        } else if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
            arrayList.add(OpenEstateAttrib.MEASURES_COMMERCIAL_AREA);
            arrayList.add(OpenEstateAttrib.CONDITION_BUILD_YEAR);
            arrayList.add(OpenEstateAttrib.CONDITION_CONDITION_TYPE);
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_ZONE);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_USAGE);
        } else if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            arrayList.add(OpenEstateAttrib.MEASURES_PLOT_AREA);
            arrayList.add(OpenEstateAttrib.CONDITION_DEVELOPMENT);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_BUILDING_PERMISSION_AVAILABLE);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_USAGE);
        } else if (list.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
            arrayList.add(OpenEstateAttrib.MEASURES_TOTAL_AREA);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_USAGE);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_ACCESS_BEGIN_DATE);
        } else if (list.contains(OpenEstateType.GENERAL_PARKING)) {
            arrayList.add(OpenEstateAttrib.MEASURES_CAR_PARKING_AREA);
            arrayList.add(OpenEstateAttrib.MEASURES_WIDTH);
            arrayList.add(OpenEstateAttrib.MEASURES_LENGTH);
            arrayList.add(OpenEstateAttrib.MEASURES_HEIGHT);
        } else if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
            if ("it".equalsIgnoreCase(dbAgencyObject.item.getAddress().getCountry()) && dbAgencyObject.item.hasAttribute(OpenEstateAttrib.MEASURES_GROSS_AREA)) {
                arrayList.add(OpenEstateAttrib.MEASURES_GROSS_AREA);
            } else {
                arrayList.add(OpenEstateAttrib.MEASURES_RESIDENTIAL_AREA);
            }
            arrayList.add(OpenEstateAttrib.MEASURES_COUNT_ROOMS);
            arrayList.add(OpenEstateAttrib.FEATURES_FLOOR);
            arrayList.add(OpenEstateAttrib.FEATURES_COUNT_FLOORS);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (linkedHashMap.size() < 3 && (openEstateAttrib = PdfShortExpose.pickAttribute(dbAgencyObject, arrayList, stringBuilder2 = new StringBuilder(), stringBuilder = new StringBuilder(), this.locale)) != null) {
            arrayList.remove(openEstateAttrib);
            linkedHashMap.put(stringBuilder2.toString().trim(), stringBuilder.toString().trim());
        }
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        stringBuilder2 = new PdfPTable(linkedHashMap.size());
        float f3 = f / (float)linkedHashMap.size() - 4.0f;
        float f4 = f2 - font.getSize() - 5.0f;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = StringUtils.abbreviate((String)((String)entry.getValue()), (int)(linkedHashMap.size() * 150));
            Font font3 = PdfShortExpose.getMatchingFont(string2, f3, f4, font2, 1.0f);
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            pdfPCell.addElement((Element)new Paragraph(font.getSize(), string, font));
            Paragraph paragraph = new Paragraph(string2, font3);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            pdfPCell.addElement((Element)paragraph);
            stringBuilder2.addCell(pdfPCell);
        }
        return stringBuilder2;
    }

    protected PdfPTable createExposeContactTable(DbAgencyContact dbAgencyContact, ImmoToolAgent immoToolAgent, Color color, float f, float f2) {
        String string;
        CompanyAddressImpl companyAddressImpl;
        ContactPublishing[] contactPublishingArray = this.getContactPublishings();
        if (contactPublishingArray.length < 1) {
            return null;
        }
        Object object = companyAddressImpl = dbAgencyContact != null && dbAgencyContact.item != null ? dbAgencyContact.item : immoToolAgent.getCompany();
        if (companyAddressImpl == null) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontNormal);
        font2.setColor(color);
        if (dbAgencyContact != null && ArrayUtils.contains((Object[])contactPublishingArray, (Object)((Object)ContactPublishing.NAME)) && !StringUtils.isBlank((CharSequence)(string = dbAgencyContact.item.getPersonLastName()))) {
            String string2 = StringUtils.capitalize((String)this.i18n.tr("the offer is managed by"));
            Gender gender = dbAgencyContact.item.getPersonGender();
            if (Gender.FEMALE.equals((Object)gender)) {
                string2 = string2 + " " + this.i18n.tr("Ms.");
            } else if (Gender.MALE.equals((Object)gender)) {
                string2 = string2 + " " + this.i18n.tr("Mr.");
            }
            linkedHashMap.put(string2.trim(), string.trim());
        }
        if (ArrayUtils.contains((Object[])contactPublishingArray, (Object)((Object)ContactPublishing.PHONE))) {
            string = StringUtils.trimToNull((String)companyAddressImpl.getPersonPhone());
            if (string == null) {
                string = StringUtils.trimToNull((String)companyAddressImpl.getPersonMobilePhone());
            }
            if (string == null) {
                string = StringUtils.trimToNull((String)immoToolAgent.getCompany().getCompanyPhone());
            }
            if (string != null) {
                linkedHashMap.put(StringUtils.capitalize((String)this.i18n.tr("phone")), string);
            }
        }
        if (ArrayUtils.contains((Object[])contactPublishingArray, (Object)((Object)ContactPublishing.FAX))) {
            string = StringUtils.trimToNull((String)companyAddressImpl.getPersonFax());
            if (string == null) {
                string = StringUtils.trimToNull((String)immoToolAgent.getCompany().getCompanyFax());
            }
            if (string != null) {
                linkedHashMap.put(StringUtils.capitalize((String)this.i18n.tr("fax")), string);
            }
        }
        if (ArrayUtils.contains((Object[])contactPublishingArray, (Object)((Object)ContactPublishing.MAIL))) {
            string = StringUtils.trimToNull((String)companyAddressImpl.getPersonMail());
            if (string == null) {
                string = StringUtils.trimToNull((String)immoToolAgent.getCompany().getCompanyMail());
            }
            if (string != null) {
                linkedHashMap.put(StringUtils.capitalize((String)this.i18n.tr("e-mail")), string);
            }
        }
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        string = new PdfPTable(linkedHashMap.size());
        float f3 = f / (float)linkedHashMap.size() - 4.0f;
        float f4 = f2 - font.getSize() - 5.0f;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            char[] cArray;
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            if (string4.contains("@")) {
                char[] cArray2 = new char[2];
                cArray2[0] = 45;
                cArray = cArray2;
                cArray2[1] = 64;
            } else {
                char[] cArray3 = new char[1];
                cArray = cArray3;
                cArray3[0] = 45;
            }
            char[] cArray4 = cArray;
            Font font3 = PdfShortExpose.getMatchingFont(string4, f3, f4, font2, 1.0f, cArray4);
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            pdfPCell.addElement((Element)new Paragraph(font.getSize(), string3, font));
            Paragraph paragraph = new Paragraph(string4, font3);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            if (string4.contains("@")) {
                DefaultSplitCharacter defaultSplitCharacter = new DefaultSplitCharacter(){

                    public boolean isSplitCharacter(int n, int n2, int n3, char[] cArray, PdfChunk[] pdfChunkArray) {
                        char c = this.getCurrentCharacter(n2, cArray, pdfChunkArray);
                        if (c == '@') {
                            return true;
                        }
                        return super.isSplitCharacter(n, n2, n3, cArray, pdfChunkArray);
                    }
                };
                ((Chunk)paragraph.getChunks().get(0)).setSplitCharacter((SplitCharacter)defaultSplitCharacter);
            }
            pdfPCell.addElement((Element)paragraph);
            string.addCell(pdfPCell);
        }
        return string;
    }

    protected PdfPTable createExpsoseDescriptionTable(Color color, float f, float f2) {
        Object object;
        OpenEstateAttrib openEstateAttrib2;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        Font font = new Font(this.bodyFontNormal);
        font.setColor(color);
        Paragraph paragraph = new Paragraph[]{OpenEstateAttrib.DESCRIPTIONS_SHORT_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_DETAILLED_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_FEATURE_DESCRIPTION};
        String string = "";
        for (OpenEstateAttrib openEstateAttrib2 : paragraph) {
            if (!dbAgencyObject.item.hasAttribute(openEstateAttrib2) || StringUtils.isBlank((CharSequence)(object = dbAgencyObject.writeValueForPublic(openEstateAttrib2, this.locale)))) continue;
            string = StringUtils.abbreviate((String)object.trim(), (int)1500);
            break;
        }
        PdfPTable pdfPTable = new PdfPTable(1);
        openEstateAttrib2 = PdfShortExpose.getMatchingFont(string, f, f2 - 10.0f, font, 1.2f);
        Paragraph paragraph2 = new Paragraph(string, (Font)openEstateAttrib2);
        paragraph2.setMultipliedLeading(1.2f);
        object = this.getBodyTextAlignment();
        if (AbstractExpose.HorizontalAlign.CENTER.equals(object)) {
            paragraph2.setAlignment(1);
        } else if (AbstractExpose.HorizontalAlign.JUSTIFY.equals(object)) {
            paragraph2.setAlignment(3);
        } else if (AbstractExpose.HorizontalAlign.LEFT.equals(object)) {
            paragraph2.setAlignment(0);
        } else if (AbstractExpose.HorizontalAlign.RIGHT.equals(object)) {
            paragraph2.setAlignment(2);
        } else {
            paragraph2.setAlignment(3);
        }
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.addElement((Element)paragraph2);
        pdfPTable.addCell(pdfPCell);
        return pdfPTable;
    }

    protected PdfPTable createExpsoseHeadTable(Color color, float f, float f2) throws DocumentException {
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontH2);
        font2.setColor(color);
        Font font3 = new Font(this.bodyFontNormal);
        font3.setColor(color);
        String string = StringUtils.trimToNull((String)dbAgencyObject.item.getTitle(this.locale.getLanguage()));
        if (string == null) {
            string = StringUtils.trimToEmpty((String)dbAgencyObject.item.getFallbackTitle(this.locale));
        }
        string = StringUtils.replace((String)string, (String)"  ", (String)System.lineSeparator());
        String string2 = dbAgencyObject.item.getPublicId() != null && dbAgencyObject.item.getPublicId().trim().length() > 0 ? dbAgencyObject.item.getPublicId() : "#" + dbAgencyObject.id;
        PdfPTable pdfPTable = new PdfPTable(2);
        pdfPTable.setWidths(new int[]{70, 30});
        float f3 = f * 0.7f - 4.0f;
        Font font4 = PdfShortExpose.getMatchingFont(string, f3, f2 - 3.0f, font2, 1.2f);
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.setPaddingLeft(2.0f);
        pdfPCell.setPaddingRight(2.0f);
        pdfPCell.setVerticalAlignment(5);
        Paragraph paragraph = new Paragraph(string, font4);
        paragraph.setAlignment(0);
        paragraph.setMultipliedLeading(1.2f);
        pdfPCell.addElement((Element)paragraph);
        pdfPTable.addCell(pdfPCell);
        pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.setPaddingLeft(2.0f);
        pdfPCell.setPaddingRight(2.0f);
        pdfPCell.setVerticalAlignment(5);
        paragraph = new Paragraph(StringUtils.capitalize((String)this.i18n.tr("property nr")), font);
        paragraph.setAlignment(2);
        pdfPCell.addElement((Element)paragraph);
        paragraph = new Paragraph(string2, font3);
        paragraph.setAlignment(2);
        pdfPCell.addElement((Element)paragraph);
        pdfPTable.addCell(pdfPCell);
        return pdfPTable;
    }

    protected PdfPTable createExpsoseHeadCityTable(Color color) throws DocumentException {
        String string;
        String string2;
        PublishingMode publishingMode;
        String string3;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        String string4 = StringUtils.trimToNull((String)dbAgencyObject.item.getAddress().getCity());
        if (string4 == null) {
            return null;
        }
        String string5 = StringUtils.trimToNull((String)dbAgencyObject.item.getAddress().getPostalCode());
        if (string5 != null) {
            string4 = string5 + " " + string4;
        }
        if ((string3 = StringUtils.trimToNull((String)dbAgencyObject.item.getAddress().getDistrict())) != null) {
            string4 = string4 + " / " + string3;
        }
        if ((PublishingMode.ALWAYS.equals((Object)(publishingMode = this.getPublishAddress())) || PublishingMode.DEFAULT.equals((Object)publishingMode) && dbAgencyObject.item.isAddressPublished()) && (string2 = StringUtils.trimToNull((String)dbAgencyObject.item.getAddress().getStreet())) != null) {
            string = StringUtils.trimToNull((String)dbAgencyObject.item.getAddress().getStreetNr());
            if (string != null) {
                string2 = string2 + " " + string;
            }
            string4 = string2 + " / " + string4;
        }
        PdfPTable pdfPTable = new PdfPTable(1);
        Font font = new Font(this.bodyFontNormal);
        font.setColor(color);
        string = new PdfPCell();
        string.setBorderWidth(0.0f);
        string.setPadding(0.0f);
        string.setVerticalAlignment(5);
        string2 = new Paragraph(string4, font);
        string2.setAlignment(0);
        string.addElement((Element)string2);
        pdfPTable.addCell((PdfPCell)string);
        return pdfPTable;
    }

    protected PdfPTable createExpsoseProvisionTable(Color color, float f, float f2) throws DocumentException {
        Paragraph paragraph;
        PdfPCell pdfPCell;
        Font font;
        String string;
        String string2;
        float f3;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        Font font2 = new Font(this.bodyFontNormal);
        font2.setColor(color);
        Font font3 = new Font(this.bodyFontSmall);
        font3.setColor(color);
        boolean bl = dbAgencyObject.item.hasAttribute(OpenEstateAttrib.PRICES_AGENT_FEE);
        boolean bl2 = dbAgencyObject.item.hasAttribute(OpenEstateAttrib.PRICES_AGENT_FEE_INCLUDING_VAT);
        if (!bl) {
            return null;
        }
        PdfPTable pdfPTable = new PdfPTable(!bl2 ? 1 : 2);
        if (pdfPTable.getNumberOfColumns() == 2) {
            pdfPTable.setWidths(new int[]{67, 33});
        }
        float f4 = f2 - font3.getSize() - 5.0f;
        if (bl) {
            f3 = pdfPTable.getNumberOfColumns() == 2 ? f * 0.67f - 4.0f : f - 4.0f;
            string2 = AgentFee.get((EstateImpl)dbAgencyObject.item, (Locale)this.locale);
            string = OpenEstateAttrib.PRICES_AGENT_FEE.getTranslation(this.locale);
            font = PdfShortExpose.getMatchingFont(string2, f3, f4, font2, 1.0f);
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            paragraph = new Paragraph(font3.getSize(), string, font3);
            paragraph.setAlignment(0);
            pdfPCell.addElement((Element)paragraph);
            paragraph = new Paragraph(string2, font);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            pdfPCell.addElement((Element)paragraph);
            pdfPTable.addCell(pdfPCell);
        }
        if (bl2) {
            f3 = pdfPTable.getNumberOfColumns() == 2 ? f * 0.33f - 4.0f : f - 4.0f;
            string2 = AgentFeeIncludingVat.getAsString((EstateImpl)dbAgencyObject.item, (Locale)this.locale);
            string = OpenEstateAttrib.PRICES_AGENT_FEE_INCLUDING_VAT.getTranslation(this.locale);
            font = PdfShortExpose.getMatchingFont(string2, f3, f4, font2, 1.0f);
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            paragraph = new Paragraph(font3.getSize(), string, font3);
            paragraph.setAlignment(0);
            pdfPCell.addElement((Element)paragraph);
            paragraph = new Paragraph(string2, font);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            pdfPCell.addElement((Element)paragraph);
            pdfPTable.addCell(pdfPCell);
        }
        return pdfPTable;
    }

    protected PdfPTable createExpsoseTypeTable(Color color) throws DocumentException {
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontH2);
        font2.setColor(color);
        OpenEstateType openEstateType = dbAgencyObject.item.getType();
        String string = openEstateType != null ? openEstateType.getTranslation(this.locale) : this.i18n.tr("undefined");
        OpenEstateAction openEstateAction = dbAgencyObject.item.getAction();
        String string2 = openEstateAction != null ? openEstateAction.getTranslation(this.locale) : this.i18n.tr("undefined");
        PdfPTable pdfPTable = new PdfPTable(1);
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setVerticalAlignment(6);
        pdfPCell.addElement((Element)new Paragraph(font.getSize() + 4.0f, StringUtils.capitalize((String)this.i18n.tr("type")) + " / " + StringUtils.capitalize((String)this.i18n.tr("marketing")), font));
        Paragraph paragraph = new Paragraph(string + " / " + string2, font2);
        paragraph.setMultipliedLeading(1.0f);
        pdfPCell.addElement((Element)paragraph);
        pdfPTable.addCell(pdfPCell);
        return pdfPTable;
    }

    @Override
    public AbstractExposePanel createForm() {
        return new PdfShortExposePanel();
    }

    protected PdfPTable createTable(Rectangle rectangle) throws IOException, DocumentException {
        DbFile[] dbFileArray;
        ImmoToolAgent immoToolAgent = this.getAgent();
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        List<OpenEstateType> list = Arrays.asList(dbAgencyObject.item.getType().getParentPath());
        float f = rectangle.getWidth();
        float f2 = f - 60.0f - 60.0f;
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPTable.setTotalWidth(f2);
        int n = this.getResolution();
        GalleryMode galleryMode = this.getGalleryMode();
        if (galleryMode == null) {
            galleryMode = GalleryMode.IMAGES_2x1;
        }
        DbFile[] dbFileArray2 = dbFileArray = !GalleryMode.NO_GALLERY.equals((Object)galleryMode) ? this.getGalleryImages(galleryMode) : new DbFile[]{};
        if (AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation)) {
            PdfPCell pdfPCell;
            int n2;
            Object object;
            PdfPTable pdfPTable2 = new PdfPTable(dbFileArray.length > 0 ? 2 : 1);
            float f3 = f2;
            PdfPTable pdfPTable3 = null;
            if (dbFileArray.length > 0) {
                int n3 = dbFileArray.length == 1 ? 1 : galleryMode.getColumnCount();
                int n4 = dbFileArray.length == 1 ? 1 : galleryMode.getRowCount();
                float f4 = f2 / 3.0f / (float)n4;
                float f5 = 330.0f / (float)n3 - 5.0f;
                pdfPTable3 = new PdfPTable(n4);
                object = null;
                n2 = 0;
                for (DbFile dbFile : dbFileArray) {
                    block41: {
                        try {
                            Image image = this.writeEstateImage(dbFile, f4, f5, n);
                            Float f6 = Float.valueOf(image.getScaledWidth());
                            pdfPCell = this.writeEstateImageToCell(image, 1, 5);
                            pdfPCell.setFixedHeight(f5 + 5.0f);
                            if (object != null && !(f6.floatValue() > ((Float)object).floatValue())) break block41;
                            object = f6;
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Can't handle attached file #" + dbFile.id + " for estate #" + dbAgencyObject.id + "!");
                            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            continue;
                        }
                    }
                    pdfPTable3.addCell(pdfPCell);
                    ++n2;
                }
                while (n2 % n4 != 0) {
                    ++n2;
                    pdfPCell = new PdfPCell();
                    pdfPCell.setBorderWidth(0.0f);
                    pdfPTable3.addCell(pdfPCell);
                }
                if (object != null) {
                    float f7 = ((Float)object).floatValue() * (float)n4 + 10.0f;
                    pdfPTable2.setTotalWidth(new float[]{f2 - f7, f7});
                    f3 = f2 - f7;
                }
            }
            PdfPTable pdfPTable4 = this.createExpsoseHeadCityTable(this.bodyHeadFgColor);
            PdfPTable pdfPTable5 = this.createExpsoseProvisionTable(this.bodyTextFgColor, f3, 35.0f);
            PdfPTable pdfPTable6 = this.createExposeAttribsTopTable(list, this.bodyTextFgColor, f3, 35.0f);
            PdfPTable pdfPTable7 = this.createExposeAttribsBottomTable(list, this.bodyTextFgColor, f3, 35.0f);
            object = this.createExposeContactTable(this.getEstateContact(), immoToolAgent, this.bodyTextFgColor, f3, 35.0f);
            pdfPCell = new PdfPCell(this.createExpsoseHeadTable(this.bodyHeadFgColor, f3, 35.0f));
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(pdfPTable4 == null ? 1.0f : 0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(2.0f);
            pdfPCell.setColspan(pdfPTable2.getNumberOfColumns());
            pdfPTable2.addCell(pdfPCell);
            if (pdfPTable4 != null) {
                pdfPCell = new PdfPCell(pdfPTable4);
                pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(1.0f);
                pdfPCell.setFixedHeight(20.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPCell.setColspan(pdfPTable2.getNumberOfColumns());
                pdfPTable2.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(this.createExpsoseTypeTable(this.bodyTextFgColor));
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPaddingBottom(1.5f);
            pdfPTable2.addCell(pdfPCell);
            if (pdfPTable3 != null) {
                pdfPTable3.setWidthPercentage(100.0f);
                pdfPCell = new PdfPCell();
                pdfPCell.setPadding(0.0f);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setFixedHeight(330.0f);
                pdfPCell.setHorizontalAlignment(2);
                pdfPCell.setVerticalAlignment(5);
                pdfPCell.addElement((Element)pdfPTable3);
                n2 = 3;
                if (pdfPTable5 != null) {
                    ++n2;
                }
                if (pdfPTable6 != null) {
                    ++n2;
                }
                if (pdfPTable7 != null) {
                    ++n2;
                }
                if (object != null) {
                    ++n2;
                }
                pdfPCell.setRowspan(n2);
                pdfPTable2.addCell(pdfPCell);
            }
            if (pdfPTable6 != null) {
                pdfPCell = new PdfPCell(pdfPTable6);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable2.addCell(pdfPCell);
            }
            float f8 = 275.0f;
            if (pdfPTable4 != null) {
                f8 -= 20.0f;
            }
            if (pdfPTable5 != null) {
                f8 -= 35.0f;
            }
            if (pdfPTable6 != null) {
                f8 -= 35.0f;
            }
            if (pdfPTable7 != null) {
                f8 -= 35.0f;
            }
            if (object != null) {
                f8 -= 35.0f;
            }
            pdfPCell = new PdfPCell(this.createExpsoseDescriptionTable(this.bodyTextFgColor, f3, f8));
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingLeft(2.0f);
            pdfPCell.setPaddingRight(2.0f);
            pdfPCell.setFixedHeight(f8);
            pdfPTable2.addCell(pdfPCell);
            if (pdfPTable7 != null) {
                pdfPCell = new PdfPCell(pdfPTable7);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthTop(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable2.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(this.createExpsoseAttribsPriceTable(this.bodyHeadFgColor, f3, 35.0f));
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthTop(0.5f);
            pdfPCell.setBorderWidthBottom(0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPaddingBottom(1.5f);
            pdfPTable2.addCell(pdfPCell);
            if (pdfPTable5 != null) {
                pdfPCell = new PdfPCell(pdfPTable5);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable2.addCell(pdfPCell);
            }
            if (object != null) {
                pdfPCell = new PdfPCell((PdfPTable)object);
                pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable2.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(pdfPTable2);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPTable.addCell(pdfPCell);
        } else {
            PdfPTable pdfPTable8 = this.createExpsoseHeadCityTable(this.bodyHeadFgColor);
            PdfPTable pdfPTable9 = this.createExpsoseProvisionTable(this.bodyTextFgColor, f2, 35.0f);
            PdfPTable pdfPTable10 = this.createExposeAttribsTopTable(list, this.bodyTextFgColor, f2, 35.0f);
            PdfPTable pdfPTable11 = this.createExposeAttribsBottomTable(list, this.bodyTextFgColor, f2, 35.0f);
            PdfPTable pdfPTable12 = this.createExposeContactTable(this.getEstateContact(), immoToolAgent, this.bodyTextFgColor, f2, 35.0f);
            PdfPCell pdfPCell = new PdfPCell(this.createExpsoseHeadTable(this.bodyHeadFgColor, f2, 35.0f));
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(pdfPTable8 == null ? 1.0f : 0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(2.0f);
            pdfPTable.addCell(pdfPCell);
            if (pdfPTable8 != null) {
                pdfPCell = new PdfPCell(pdfPTable8);
                pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(1.0f);
                pdfPCell.setFixedHeight(20.0f);
                pdfPCell.setPadding(0.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
            PdfPTable pdfPTable13 = null;
            float f9 = 0.0f;
            float f10 = 0.0f;
            if (dbFileArray.length > 0) {
                int n5 = dbFileArray.length == 1 ? 1 : galleryMode.getRowCount();
                int n6 = dbFileArray.length == 1 ? 1 : galleryMode.getColumnCount();
                float f11 = f2 / (float)n6 - 10.0f;
                float f12 = 180.0f / (float)n5 - 10.0f;
                pdfPTable13 = new PdfPTable(n6);
                int n7 = 0;
                for (DbFile dbFile : dbFileArray) {
                    try {
                        Image image = this.writeEstateImage(dbFile, f11, f12, n);
                        pdfPCell = this.writeEstateImageToCell(image, 1, 5);
                        pdfPCell.setFixedHeight(f12 + 5.0f);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't handle attached file #" + dbFile.id + " for estate #" + dbAgencyObject.id + "!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        continue;
                    }
                    pdfPTable13.addCell(pdfPCell);
                    ++n7;
                }
                while (n7 % n6 != 0) {
                    ++n7;
                    pdfPCell = new PdfPCell();
                    pdfPCell.setBorderWidth(0.0f);
                    pdfPTable13.addCell(pdfPCell);
                }
            }
            if (pdfPTable13 != null) {
                pdfPTable13.setWidthPercentage(100.0f);
                pdfPCell = new PdfPCell();
                pdfPCell.setPadding(0.0f);
                pdfPCell.setPaddingLeft(f9);
                pdfPCell.setPaddingRight(f10);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setFixedHeight(180.0f);
                pdfPCell.setHorizontalAlignment(1);
                pdfPCell.setVerticalAlignment(5);
                pdfPCell.addElement((Element)pdfPTable13);
                pdfPTable.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(this.createExpsoseTypeTable(this.bodyTextFgColor));
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPaddingBottom(1.5f);
            pdfPTable.addCell(pdfPCell);
            if (pdfPTable10 != null) {
                pdfPCell = new PdfPCell(pdfPTable10);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
            float f13 = 350.0f;
            if (pdfPTable13 == null) {
                f13 += 180.0f;
            }
            if (pdfPTable8 != null) {
                f13 -= 20.0f;
            }
            if (pdfPTable9 != null) {
                f13 -= 35.0f;
            }
            if (pdfPTable10 != null) {
                f13 -= 35.0f;
            }
            if (pdfPTable11 != null) {
                f13 -= 35.0f;
            }
            if (pdfPTable12 != null) {
                f13 -= 35.0f;
            }
            pdfPCell = new PdfPCell(this.createExpsoseDescriptionTable(this.bodyTextFgColor, f2, f13));
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingLeft(2.0f);
            pdfPCell.setPaddingRight(2.0f);
            pdfPCell.setFixedHeight(f13);
            pdfPTable.addCell(pdfPCell);
            if (pdfPTable11 != null) {
                pdfPCell = new PdfPCell(pdfPTable11);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthTop(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(this.createExpsoseAttribsPriceTable(this.bodyHeadFgColor, f2, 35.0f));
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthTop(0.5f);
            pdfPCell.setBorderWidthBottom(0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPaddingBottom(1.5f);
            pdfPTable.addCell(pdfPCell);
            if (pdfPTable9 != null) {
                pdfPCell = new PdfPCell(pdfPTable9);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
            if (pdfPTable12 != null) {
                pdfPCell = new PdfPCell(pdfPTable12);
                pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
        }
        return pdfPTable;
    }

    public ContactPublishing[] getContactPublishings() {
        String string = (String)this.get(CONTACT_PUBLISHING);
        if (string == null) {
            return new ContactPublishing[0];
        }
        ArrayList<ContactPublishing> arrayList = new ArrayList<ContactPublishing>();
        for (String string2 : string.split(",")) {
            if (string2 == null || string2.trim().length() < 1) continue;
            try {
                ContactPublishing contactPublishing = ContactPublishing.valueOf(string2.trim());
                if (contactPublishing == null) continue;
                arrayList.add(contactPublishing);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read contact publishing!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return arrayList.toArray(new ContactPublishing[0]);
    }

    private DbFile[] getGalleryImages(GalleryMode galleryMode) {
        ArrayList arrayList;
        int n;
        block14: {
            int n2;
            ArrayList<DbFile> arrayList2;
            block18: {
                ArrayList<DbFile> arrayList3;
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                arrayList2 = new ArrayList<DbFile>();
                                arrayList3 = new ArrayList<DbFile>();
                                DbFile[] dbFileArray = this.getEstateFiles();
                                int n3 = dbFileArray.length;
                                for (n2 = 0; n2 < n3; ++n2) {
                                    boolean bl;
                                    DbFile dbFile = dbFileArray[n2];
                                    if (!"image/bmp".equalsIgnoreCase(dbFile.mimeType) && !"image/jpeg".equalsIgnoreCase(dbFile.mimeType) && !"image/png".equalsIgnoreCase(dbFile.mimeType)) continue;
                                    boolean bl2 = bl = EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)dbFile.type) || EstateAttachmentType.IMAGE_MAP.equals((Object)dbFile.type);
                                    if (bl) {
                                        arrayList3.add(dbFile);
                                        continue;
                                    }
                                    arrayList2.add(dbFile);
                                }
                                n = 0;
                                arrayList = new ArrayList();
                                if (!GalleryMode.IMAGE_1x1.equals((Object)galleryMode)) break block13;
                                n = 1;
                                if (arrayList2.size() <= 0) break block14;
                                arrayList.add(arrayList2.get(0));
                                break block14;
                            }
                            if (!GalleryMode.PLAN_1x1.equals((Object)galleryMode)) break block15;
                            n = 1;
                            if (arrayList3.size() <= 0) break block14;
                            arrayList.add(arrayList3.get(0));
                            break block14;
                        }
                        if (!GalleryMode.IMAGES_2x1.equals((Object)galleryMode)) break block16;
                        n = 2;
                        for (n2 = 0; n2 < n; ++n2) {
                            if (arrayList2.size() <= n2) continue;
                            arrayList.add(arrayList2.get(n2));
                        }
                        break block14;
                    }
                    if (!GalleryMode.IMAGE_PLAN_2x1.equals((Object)galleryMode)) break block17;
                    n = 2;
                    if (arrayList2.size() > 0) {
                        arrayList.add(arrayList2.get(0));
                    }
                    if (arrayList3.size() <= 0) break block14;
                    arrayList.add(arrayList3.get(0));
                    break block14;
                }
                if (!GalleryMode.PLAN_IMAGE_2x1.equals((Object)galleryMode)) break block18;
                n = 2;
                if (arrayList3.size() > 0) {
                    arrayList.add(arrayList3.get(0));
                }
                if (arrayList2.size() <= 0) break block14;
                arrayList.add(arrayList2.get(0));
                break block14;
            }
            if (GalleryMode.IMAGES_3x1.equals((Object)galleryMode)) {
                n = 3;
                for (n2 = 0; n2 < n; ++n2) {
                    if (arrayList2.size() <= n2) continue;
                    arrayList.add(arrayList2.get(n2));
                }
            } else if (GalleryMode.IMAGES_2x2.equals((Object)galleryMode)) {
                n = 4;
                for (n2 = 0; n2 < n; ++n2) {
                    if (arrayList2.size() <= n2) continue;
                    arrayList.add(arrayList2.get(n2));
                }
            } else if (GalleryMode.IMAGES_3x2.equals((Object)galleryMode)) {
                n = 6;
                for (n2 = 0; n2 < n; ++n2) {
                    if (arrayList2.size() <= n2) continue;
                    arrayList.add(arrayList2.get(n2));
                }
            }
        }
        return n > 0 ? arrayList.toArray(new DbFile[0]) : new DbFile[]{};
    }

    public GalleryMode getGalleryMode() {
        String string = (String)this.get(GALLERY_MODE);
        return string != null ? GalleryMode.valueOf(string) : null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18nFactory.getI18n(PdfShortExpose.class).tr("short expos\u00e9"));
    }

    @Override
    protected void init(ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        super.init(immoToolProject, connection);
        this.i18n = I18nFactory.getI18n(PdfShortExpose.class, (Locale)this.getLocale());
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setGalleryMode(GalleryMode.IMAGES_2x1);
    }

    private static OpenEstateAttrib pickAttribute(DbAgencyObject dbAgencyObject, List<OpenEstateAttrib> list, StringBuilder stringBuilder, StringBuilder stringBuilder2, Locale locale) {
        for (OpenEstateAttrib openEstateAttrib : list) {
            String string;
            if (!dbAgencyObject.item.hasAttribute(openEstateAttrib) || StringUtils.isBlank((CharSequence)(string = dbAgencyObject.writeValueForPublic(openEstateAttrib, locale)))) continue;
            stringBuilder.append(openEstateAttrib.getTranslation(locale));
            stringBuilder2.append(string);
            return openEstateAttrib;
        }
        return null;
    }

    public void setContactPublishings(ContactPublishing[] contactPublishingArray) {
        if (contactPublishingArray == null || contactPublishingArray.length < 1) {
            this.remove(CONTACT_PUBLISHING);
        } else {
            this.put(CONTACT_PUBLISHING, StringUtils.join((Object[])contactPublishingArray, (String)","));
        }
    }

    public void setGalleryMode(GalleryMode galleryMode) {
        if (galleryMode == null) {
            this.remove(GALLERY_MODE);
        } else {
            this.put(GALLERY_MODE, galleryMode.name());
        }
    }

    private Image writeEstateImage(DbFile dbFile, float f, float f2, int n) {
        try {
            File file = this.getEstateFileDownload(dbFile);
            BufferedImage bufferedImage = ImageUtils.readAsRgb((File)file);
            Image image = null;
            if (bufferedImage != null && n >= 72) {
                BufferedImage bufferedImage2 = ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)((int)f), (int)((int)f2), (int)n);
                image = Image.getInstance((java.awt.Image)bufferedImage2, null);
                bufferedImage.flush();
                bufferedImage2.flush();
            } else if (bufferedImage != null) {
                image = Image.getInstance((java.awt.Image)bufferedImage, null);
                bufferedImage.flush();
            }
            if (image == null) {
                return null;
            }
            image.setBorderWidth(0.0f);
            image.setBackgroundColor(this.bodyTextBgColor);
            if (image.getWidth() > f || image.getHeight() > f2) {
                image.scaleToFit(f, f2);
            }
            return image;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load image!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    private PdfPCell writeEstateImageToCell(Image image, int n, int n2) {
        try {
            PdfPCell pdfPCell = new PdfPCell(image, false);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setHorizontalAlignment(n);
            pdfPCell.setVerticalAlignment(n2);
            return pdfPCell;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't create image-cell!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public static enum GalleryMode implements Translatable
    {
        IMAGE_1x1(1, 1, I18n.marktr((String)"image")),
        PLAN_1x1(1, 1, I18n.marktr((String)"floorplan")),
        IMAGE_PLAN_2x1(2, 1, I18n.marktr((String)"image & floorplan")),
        PLAN_IMAGE_2x1(2, 1, I18n.marktr((String)"floorplan & image")),
        IMAGES_2x1(2, 1, I18n.marktr((String)"images")),
        IMAGES_3x1(3, 1, I18n.marktr((String)"images")),
        IMAGES_2x2(2, 2, I18n.marktr((String)"images")),
        IMAGES_3x2(3, 2, I18n.marktr((String)"images")),
        NO_GALLERY(0, 0, I18n.marktr((String)"Don't show any images."));

        private final int colCount;
        private final int rowCount;
        private final String i18nKey;

        private GalleryMode(int n2, int n3, String string2) {
            this.colCount = n2;
            this.rowCount = n3;
            this.i18nKey = string2;
        }

        public int getColumnCount() {
            return this.colCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public String getTranslation() {
            String string = this.colCount + "x" + this.rowCount;
            return string + ", " + ImmoToolUtils.getI18nString(PdfShortExpose.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            String string = this.colCount + "x" + this.rowCount;
            return string + ", " + ImmoToolUtils.getI18nString(PdfShortExpose.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }

    public static enum ContactPublishing implements Translatable
    {
        NAME(I18n.marktr((String)"name")),
        PHONE(I18n.marktr((String)"phone")),
        FAX(I18n.marktr((String)"fax")),
        MAIL(I18n.marktr((String)"e-mail"));

        private final String i18nKey;

        private ContactPublishing(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(PdfDetailedExpose.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(PdfDetailedExpose.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }
}

