/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractExposePanel;
import com.openindex.openestate.tool.agency.expose.PdfShortExpose;
import com.openindex.openestate.tool.agency.gui.ExposeHorizontalAlignRenderer;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.ColorPickButton;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultSelectButton;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class PdfShortExposePanel
extends AbstractExposePanel<PdfShortExpose> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfShortExposePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(PdfShortExposePanel.class);
    private ValidationHandler validationHandler;
    private JTabbedPane tabbedPane;
    private GeneralTab generalTab;
    private AbstractExposePanel.HeaderAndFooterTab headerAndFooterTab;
    private ContentTab contentTab;
    private AbstractExposePanel.EncryptionTab encryptionTab;

    public PdfShortExposePanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.tabbedPane = new JTabbedPane();
        this.generalTab = (GeneralTab)ImmoToolUtils.addTab((AbstractTab)new GeneralTab(), (JTabbedPane)this.tabbedPane);
        this.headerAndFooterTab = (AbstractExposePanel.HeaderAndFooterTab)ImmoToolUtils.addTab((AbstractTab)new AbstractExposePanel.HeaderAndFooterTab(), (JTabbedPane)this.tabbedPane);
        this.contentTab = (ContentTab)ImmoToolUtils.addTab((AbstractTab)new ContentTab(), (JTabbedPane)this.tabbedPane);
        this.encryptionTab = (AbstractExposePanel.EncryptionTab)ImmoToolUtils.addTab((AbstractTab)new AbstractExposePanel.EncryptionTab(), (JTabbedPane)this.tabbedPane);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add(this.tabbedPane, "Center");
    }

    private void doTemplateSelect() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(I18N.tr("Select a PDF file."));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
            }

            @Override
            public String getDescription() {
                return I18N.tr("PDF files") + " (*.pdf)";
            }
        });
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        this.generalTab.templateFileField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
    }

    @Override
    public boolean isTemplateSelected() {
        return this.generalTab.templateField != null && this.generalTab.templateField.isSelected();
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(PdfShortExpose pdfShortExpose) {
        this.generalTab.load(pdfShortExpose);
        this.headerAndFooterTab.load(pdfShortExpose);
        this.contentTab.load(pdfShortExpose);
        this.encryptionTab.load(pdfShortExpose);
        this.validationHandler.init();
    }

    @Override
    public void save(PdfShortExpose pdfShortExpose) {
        this.generalTab.save(pdfShortExpose);
        this.headerAndFooterTab.save(pdfShortExpose);
        this.contentTab.save(pdfShortExpose);
        this.encryptionTab.save(pdfShortExpose);
    }

    private class TemplateSelectAction
    extends AbstractI18nAction {
        private TemplateSelectAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PdfShortExposePanel.this.doTemplateSelect();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("select")));
            this.setShortDescription(I18N.tr("Select a custom PDF template from your harddisk."));
        }
    }

    private class GeneralTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JXTitledSeparator templateTitle;
        private JLabel formatLabel;
        private JComboBox<AbstractExpose.Orientation> formatField;
        private JLabel resolutionLabel;
        private JComboBox<AbstractExposePanel.Resolution> resolutionField;
        private JLabel localeLabel;
        private LocaleComboBox localeField;
        private JLabel templateLabel;
        private JCheckBox templateField;
        private JTextField templateFileField;
        private JButton templateButton;
        private JLabel publishAddressLabel;
        private JComboBox<PublishingMode> publishAddressField;
        private JLabel imageGalleryLabel;
        private JComboBox<PdfShortExpose.GalleryMode> imageGalleryField;
        private JLabel contactLabel;
        private DefaultSelectButton contactField;

        private GeneralTab() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.templateTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.localeLabel = new JLabel();
            this.localeField = new LocaleComboBox(AbstractExpose.getSupportedLocales(), true);
            this.resolutionLabel = new JLabel();
            this.resolutionField = new JComboBox();
            this.resolutionField.setRenderer((ListCellRenderer<AbstractExposePanel.Resolution>)new DefaultListCellRenderer((Renderer)new AbstractExposePanel.ResolutionRenderer()));
            this.resolutionField.addItem(null);
            for (AbstractExposePanel.Resolution enum_ : AbstractExposePanel.Resolution.values()) {
                this.resolutionField.addItem(enum_);
            }
            this.resolutionField.setSelectedItem(null);
            this.formatLabel = new JLabel();
            this.formatField = new JComboBox();
            this.formatField.setRenderer((ListCellRenderer<AbstractExpose.Orientation>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            for (Enum enum_ : AbstractExpose.Orientation.values()) {
                this.formatField.addItem((AbstractExpose.Orientation)enum_);
            }
            this.publishAddressLabel = new JLabel();
            this.publishAddressField = new JComboBox();
            this.publishAddressField.setRenderer((ListCellRenderer<PublishingMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            for (Enum enum_ : PublishingMode.values()) {
                this.publishAddressField.addItem((PublishingMode)enum_);
            }
            this.templateLabel = new JLabel();
            this.templateField = new JCheckBox();
            this.templateField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneralTab.this.setTemplateEnabled(GeneralTab.this.templateField.isSelected());
                }
            });
            this.templateButton = new JButton((Action)((Object)new TemplateSelectAction()));
            this.templateFileField = new JTextField();
            this.templateFileField.setEditable(false);
            this.imageGalleryLabel = new JLabel();
            this.imageGalleryField = new JComboBox();
            this.imageGalleryField.setRenderer((ListCellRenderer<PdfShortExpose.GalleryMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            for (Enum enum_ : PdfShortExpose.GalleryMode.values()) {
                this.imageGalleryField.addItem((PdfShortExpose.GalleryMode)enum_);
            }
            this.contactLabel = new JLabel();
            this.contactField = new DefaultSelectButton(1);
            this.contactField.setEmptyText("");
            this.contactField.addOption(PdfShortExpose.ContactPublishing.NAME.name(), PdfShortExpose.ContactPublishing.NAME.getTranslation());
            this.contactField.addOption(PdfShortExpose.ContactPublishing.PHONE.name(), PdfShortExpose.ContactPublishing.PHONE.getTranslation());
            this.contactField.addOption(PdfShortExpose.ContactPublishing.FAX.name(), PdfShortExpose.ContactPublishing.FAX.getTranslation());
            this.contactField.addOption(PdfShortExpose.ContactPublishing.MAIL.name(), PdfShortExpose.ContactPublishing.MAIL.getTranslation());
            PdfShortExposePanel.this.validationHandler.putRule((JComponent)this.localeField, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.localeField));
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, pref");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.localeLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.localeField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.formatLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.formatField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.resolutionLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.resolutionField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.publishAddressLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.publishAddressField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.imageGalleryLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.imageGalleryField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.contactLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.contactField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.row(), 5);
            defaultFormBuilder.add((Component)this.templateTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.templateLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.templateField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.templateFileField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.templateButton).xy(5, defaultFormBuilder.row());
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.setTemplateSelected(false);
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("general"));
        }

        public void load(PdfShortExpose pdfShortExpose) {
            block6: {
                Locale locale;
                block5: {
                    this.formatField.setSelectedItem((Object)(pdfShortExpose.getOrientation() != null ? pdfShortExpose.getOrientation() : AbstractExpose.Orientation.PORTRAIT));
                    this.publishAddressField.setSelectedItem((Object)pdfShortExpose.getPublishAddress());
                    this.resolutionField.setSelectedItem(null);
                    int n = pdfShortExpose.getResolution();
                    Object object = AbstractExposePanel.Resolution.values();
                    int n2 = ((AbstractExposePanel.Resolution[])object).length;
                    for (int i = 0; i < n2; ++i) {
                        AbstractExposePanel.Resolution resolution = object[i];
                        if (resolution.getValue() != n) continue;
                        this.resolutionField.setSelectedItem((Object)resolution);
                        break;
                    }
                    if ((object = pdfShortExpose.getGalleryMode()) == null) {
                        object = PdfShortExpose.GalleryMode.IMAGES_2x1;
                    }
                    this.imageGalleryField.setSelectedItem(object);
                    PdfShortExpose.ContactPublishing[] contactPublishingArray = pdfShortExpose.getContactPublishings();
                    if (contactPublishingArray == null) {
                        contactPublishingArray = new PdfShortExpose.ContactPublishing[]{};
                    }
                    for (PdfShortExpose.ContactPublishing contactPublishing : PdfShortExpose.ContactPublishing.values()) {
                        this.contactField.setSelected(contactPublishing.name(), ArrayUtils.contains((Object[])contactPublishingArray, (Object)((Object)contactPublishing)));
                    }
                    this.contactField.updateText();
                    this.setTemplateSelected(pdfShortExpose.isTemplate());
                    locale = pdfShortExpose.getLocale();
                    this.localeField.setSelectedIndex(0);
                    if (locale != null) break block5;
                    if (this.localeField.getItemCount() <= 1) break block6;
                    this.localeField.setSelectedIndex(1);
                    break block6;
                }
                for (int i = 1; i < this.localeField.getItemCount(); ++i) {
                    Locale locale2 = this.localeField.getLocaleAt(i);
                    if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
                    this.localeField.setSelectedIndex(i);
                    break;
                }
            }
        }

        public void save(PdfShortExpose pdfShortExpose) {
            File file;
            pdfShortExpose.setOrientation((AbstractExpose.Orientation)((Object)this.formatField.getSelectedItem()));
            pdfShortExpose.setLocale(this.localeField.getSelectedLocale());
            pdfShortExpose.setGalleryMode((PdfShortExpose.GalleryMode)((Object)this.imageGalleryField.getSelectedItem()));
            pdfShortExpose.setPublishAddress((PublishingMode)((Object)this.publishAddressField.getSelectedItem()));
            AbstractExposePanel.Resolution resolution = (AbstractExposePanel.Resolution)((Object)this.resolutionField.getSelectedItem());
            pdfShortExpose.setResolution(resolution != null ? resolution.getValue() : 0);
            ArrayList<PdfShortExpose.ContactPublishing> arrayList = new ArrayList<PdfShortExpose.ContactPublishing>();
            for (String string : this.contactField.getSelectedKeys()) {
                if (string == null || string.length() < 1) continue;
                try {
                    arrayList.add(PdfShortExpose.ContactPublishing.valueOf(string));
                }
                catch (Exception exception) {
                    LOGGER.warn("Unknown contact-publishing: '" + string + "'!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            pdfShortExpose.setContactPublishings(arrayList.toArray(new PdfShortExpose.ContactPublishing[0]));
            String string = this.templateFileField.getText().trim();
            pdfShortExpose.setTemplate(this.templateField.isSelected());
            if (string.length() > 0 && (file = new File(string)).isFile()) {
                pdfShortExpose.setTemporaryTemplate(new File(string));
            }
        }

        private void setTemplateEnabled(boolean bl) {
            this.templateButton.setEnabled(bl);
            this.templateFileField.setEnabled(bl);
        }

        private void setTemplateSelected(boolean bl) {
            this.templateField.setSelected(bl);
            this.setTemplateEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("general options")));
            this.localeLabel.setText(StringUtils.capitalize((String)I18N.tr("language")) + ":");
            this.localeField.setToolTipText(I18N.tr("Select the language for the generated document."));
            this.formatLabel.setText(StringUtils.capitalize((String)I18N.tr("format")) + ":");
            this.formatField.setToolTipText(I18N.tr("Select a page format for the generated document."));
            this.resolutionLabel.setText(StringUtils.capitalize((String)I18N.tr("resolution")) + ":");
            this.resolutionField.setToolTipText(I18N.tr("Select a resolution for the exported images. A higher resolution leads to better quality and bigger file size."));
            this.publishAddressLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
            this.publishAddressField.setToolTipText(I18N.tr("Use this field to specify, how to deal with addresses in the generated document."));
            this.imageGalleryLabel.setText(StringUtils.capitalize((String)I18N.tr("gallery")) + ":");
            this.imageGalleryField.setToolTipText(I18N.tr("Use this field to specify, how to deal with images in the generated document."));
            this.contactLabel.setText(StringUtils.capitalize((String)I18N.tr("contact")) + ":");
            this.contactField.setToolTipText(I18N.tr("You can select, which contact information are written to the generated document."));
            this.contactField.setEmptyText(I18N.tr("Don't show contact information."));
            this.contactField.updateText();
            this.templateTitle.setTitle(StringUtils.capitalize((String)I18N.tr("template for PDF generation")));
            this.templateLabel.setText(I18N.tr("PDF template") + ":");
            this.templateField.setText(I18N.tr("Use a customised PDF template."));
            this.templateField.setToolTipText(I18N.tr("Enable this option, to use a customised PDF template for the generated document."));
            this.templateFileField.setToolTipText(I18N.tr("The selected PDF file will be saved permanently into the database."));
        }
    }

    private static class ContentTab
    extends AbstractTab {
        private JXTitledSeparator formTitle;
        private JLabel alignmentLabel;
        private JLabel colorsLabel;
        private ColorPickButton borderColorField;
        private ColorPickButton bodyHeadBgColorField;
        private ColorPickButton bodyHeadFgColorField;
        private ColorPickButton bodyTextBgColorField;
        private ColorPickButton bodyTextFgColorField;
        private JComboBox<AbstractExpose.HorizontalAlign> bodyTextAlignmentField;

        private ContentTab() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.alignmentLabel = new JLabel();
            this.colorsLabel = new JLabel();
            this.borderColorField = new ColorPickButton();
            this.bodyHeadBgColorField = new ColorPickButton();
            this.bodyHeadFgColorField = new ColorPickButton();
            this.bodyTextBgColorField = new ColorPickButton();
            this.bodyTextFgColorField = new ColorPickButton();
            this.bodyTextAlignmentField = new JComboBox();
            this.bodyTextAlignmentField.setRenderer((ListCellRenderer<AbstractExpose.HorizontalAlign>)new DefaultListCellRenderer((Renderer)new ExposeHorizontalAlignRenderer()));
            for (AbstractExpose.HorizontalAlign horizontalAlign : AbstractExpose.HorizontalAlign.values()) {
                this.bodyTextAlignmentField.addItem(horizontalAlign);
            }
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.alignmentLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.bodyTextAlignmentField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.colorsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.bodyTextFgColorField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.bodyTextBgColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.bodyHeadFgColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.bodyHeadBgColorField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.borderColorField).xy(3, defaultFormBuilder.nextRow());
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("content"));
        }

        public void load(PdfShortExpose pdfShortExpose) {
            this.bodyHeadBgColorField.setColor(pdfShortExpose.getBodyHeadBgColor());
            this.bodyHeadFgColorField.setColor(pdfShortExpose.getBodyHeadFgColor());
            this.bodyTextBgColorField.setColor(pdfShortExpose.getBodyTextBgColor());
            this.bodyTextFgColorField.setColor(pdfShortExpose.getBodyTextFgColor());
            this.borderColorField.setColor(pdfShortExpose.getBorderColor());
            this.bodyTextAlignmentField.setSelectedItem((Object)pdfShortExpose.getBodyTextAlignment());
        }

        public void save(PdfShortExpose pdfShortExpose) {
            pdfShortExpose.setBodyHeadBgColor(this.bodyHeadBgColorField.getColor());
            pdfShortExpose.setBodyHeadFgColor(this.bodyHeadFgColorField.getColor());
            pdfShortExpose.setBodyTextBgColor(this.bodyTextBgColorField.getColor());
            pdfShortExpose.setBodyTextFgColor(this.bodyTextFgColorField.getColor());
            pdfShortExpose.setBorderColor(this.borderColorField.getColor());
            pdfShortExpose.setBodyTextAlignment((AbstractExpose.HorizontalAlign)((Object)this.bodyTextAlignmentField.getSelectedItem()));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("content")));
            this.alignmentLabel.setText(StringUtils.capitalize((String)I18N.tr("orientation")) + ":");
            this.bodyTextAlignmentField.setToolTipText(I18N.tr("Set alignment of texts."));
            this.colorsLabel.setText(StringUtils.capitalize((String)I18N.tr("colors")) + ":");
            this.borderColorField.setText(I18N.tr("color for lines & borders"));
            this.borderColorField.setToolTipText(I18N.tr("This color is used for borders and lines."));
            this.bodyHeadBgColorField.setText(I18N.tr("background color of headlines"));
            this.bodyHeadBgColorField.setToolTipText(I18N.tr("This color is used as headline background."));
            this.bodyHeadFgColorField.setText(I18N.tr("foreground color of headlines"));
            this.bodyHeadFgColorField.setToolTipText(I18N.tr("This color is used for headline texts."));
            this.bodyTextBgColorField.setText(I18N.tr("background color of texts"));
            this.bodyTextBgColorField.setToolTipText(I18N.tr("This color is used as text background."));
            this.bodyTextFgColorField.setText(I18N.tr("foreground color of texts"));
            this.bodyHeadFgColorField.setToolTipText(I18N.tr("This color is used for texts."));
        }
    }
}

