/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.is24.Is24XmlReader;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.openestate.io.is24_xml.Is24XmlDocument;
import org.openestate.io.is24_xml.Is24XmlUtils;
import org.openestate.io.is24_xml.xml.AktionsTyp;
import org.openestate.io.is24_xml.xml.ImmobilieBaseTyp;
import org.openestate.io.is24_xml.xml.ImmobilienTransferTyp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24XmlImport
extends AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlImport.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24XmlImport.class);
    private static final String NAME = "is24_xml";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "IS24-XML";
    }

    @Override
    public String[] getVersions() {
        return new String[]{"rev189438"};
    }

    @Override
    public boolean isIncrementalTransferSupported() {
        return true;
    }

    @Override
    public TransferImpl parseFile(File file, String string, AgencyImportTask.Settings settings) throws IOException {
        try {
            Is24XmlImportReader is24XmlImportReader = new Is24XmlImportReader();
            is24XmlImportReader.setOpenEstateLanguage(settings.getLanguage());
            is24XmlImportReader.setImportRemovedObjects(settings.isImportRemovedObjects());
            return is24XmlImportReader.readTransfer(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't load parser!", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException("Can't parse document!", sAXException);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't process document!", jAXBException);
        }
    }

    @Override
    public String validateFile(File file) throws IOException {
        Is24XmlDocument is24XmlDocument = null;
        try {
            is24XmlDocument = Is24XmlUtils.createDocument((File)file);
        }
        catch (Exception exception) {
            throw new IOException("Can't parse document!", exception);
        }
        if (is24XmlDocument == null) {
            throw new IOException("The file does not contain a supported document.");
        }
        return null;
    }

    public static class Is24XmlImportReader
    extends Is24XmlReader {
        private boolean importRemovedObjects = false;

        public Is24XmlImportReader() {
            Is24XmlImportReader.initJAXB();
        }

        protected EstateImpl convertImmobilie(ImmobilieBaseTyp immobilieBaseTyp, Map<String, AgentContactImpl> map) {
            EstateImpl estateImpl = super.convertImmobilie(immobilieBaseTyp, map);
            if (estateImpl == null) {
                return null;
            }
            String string = immobilieBaseTyp.getAnbieterObjektID();
            if (string != null) {
                estateImpl.setPublicId(string);
            }
            return estateImpl;
        }

        protected TransferImpl convertToTransfer(ImmobilienTransferTyp immobilienTransferTyp) {
            if (this.isImportRemovedObjects()) {
                for (JAXBElement jAXBElement : immobilienTransferTyp.getAnbieter().getImmobilie()) {
                    ImmobilieBaseTyp immobilieBaseTyp = (ImmobilieBaseTyp)jAXBElement.getValue();
                    if (!AktionsTyp.LOESCHEN.equals((Object)immobilieBaseTyp.getImportmodus())) continue;
                    immobilieBaseTyp.setImportmodus(AktionsTyp.IMPORTIEREN);
                }
            }
            return super.convertToTransfer(immobilienTransferTyp);
        }

        public static void initJAXB() {
            AgencyPluginUtils.initJAXB(Is24XmlUtils.class);
        }

        public boolean isImportRemovedObjects() {
            return this.importRemovedObjects;
        }

        public void setImportRemovedObjects(boolean bl) {
            this.importRemovedObjects = bl;
        }
    }
}

