-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 8 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Modify parameters of 'save_openestate_contacts'
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Procedure save_openestate_contacts
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_openestate_contacts;
CREATE PROCEDURE save_openestate_contacts(
    INOUT val_contact_id BIGINT,
    val_person_first_name VARCHAR(150),
    val_person_middle_name VARCHAR(150),
    val_person_last_name VARCHAR(150),
    val_person_title VARCHAR(50),
    val_person_gender CHAR(1),
    val_person_date_of_birth DATE,
    val_person_mail VARCHAR(150),
    val_person_phone VARCHAR(50),
    val_person_mobile_phone VARCHAR(50),
    val_person_fax VARCHAR(50),
    val_address_street VARCHAR(150),
    val_address_street2 VARCHAR(150),
    val_address_street_nr VARCHAR(20),
    val_address_postal_code VARCHAR(10),
    val_address_city VARCHAR(150),
    val_address_district VARCHAR(150),
    val_address_country CHAR(2),
    val_address_region VARCHAR(150),
    val_address_latitude DECIMAL(15,12),
    val_address_longitude DECIMAL(15,12)
  )
  SPECIFIC save_openestate_contacts
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- Neuer Ansprechpartner erzeugen
    IF val_contact_id < 1 THEN

      -- Ansprechpartner speichern
      INSERT INTO openestate_contacts (
        person_first_name,
        person_middle_name,
        person_last_name,
        person_title,
        person_gender,
        person_date_of_birth,
        person_mail,
        person_phone,
        person_mobile_phone,
        person_fax,
        address_street,
        address_street2,
        address_street_nr,
        address_postal_code,
        address_city,
        address_district,
        address_country,
        address_region,
        address_latitude,
        address_longitude )
      VALUES (
        val_person_first_name,
        val_person_middle_name,
        val_person_last_name,
        val_person_title,
        val_person_gender,
        val_person_date_of_birth,
        val_person_mail,
        val_person_phone,
        val_person_mobile_phone,
        val_person_fax,
        val_address_street,
        val_address_street2,
        val_address_street_nr,
        val_address_postal_code,
        val_address_city,
        val_address_district,
        val_address_country,
        val_address_region,
        val_address_latitude,
        val_address_longitude );

      -- ID zurückliefern
      SET val_contact_id = IDENTITY();

    -- Bestehenden Ansprechpartner bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SET allowed = can_write_immotool_agency_contacts(val_contact_id);
      IF NOT allowed = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

      -- Ansprechpartner bearbeiten
      UPDATE openestate_contacts
        SET
          person_first_name = val_person_first_name,
          person_middle_name = val_person_middle_name,
          person_last_name = val_person_last_name,
          person_title = val_person_title,
          person_gender = val_person_gender,
          person_date_of_birth = val_person_date_of_birth,
          person_mail = val_person_mail,
          person_phone = val_person_phone,
          person_mobile_phone = val_person_mobile_phone,
          person_fax = val_person_fax,
          address_street = val_address_street,
          address_street2 = val_address_street2,
          address_street_nr = val_address_street_nr,
          address_postal_code = val_address_postal_code,
          address_city = val_address_city,
          address_district = val_address_district,
          address_country = val_address_country,
          address_region = val_address_region,
          address_latitude = val_address_latitude,
          address_longitude = val_address_longitude,
          modified_at = NOW()
        WHERE
          contact_id = val_contact_id;

    END IF;

  END;
.;