/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.calendar;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.crm.CrmActivityRelationPanel;
import com.openindex.openestate.tool.crm.CrmActivityTable;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.addons.calendar.CrmCalendarUtils;
import com.openindex.openestate.tool.crm.addons.calendar.db.DbCrmActivityCalendarEntry;
import com.openindex.openestate.tool.crm.addons.calendar.db.DbCrmCalendarHandler;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmCalendarEntryActivitiesPanel
extends CalendarEntryViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmCalendarEntryActivitiesPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmCalendarEntryActivitiesPanel.class);
    private static final String RELATION_TABLE_ID = "CrmCalendarEntryActivitiesPanel.RelationTable";
    private DbCalendarEntry currentCalendarEntry = null;
    private JXTitledSeparator activitiesTitle;
    private RelationTable activitiesTable;
    private RelationForm relationForm;
    private AbstractI18nAction relationAddAction;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction showActionsAction;

    public CrmCalendarEntryActivitiesPanel() {
        this.build();
    }

    private void build() {
        this.activitiesTable = new RelationTable();
        this.activitiesTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.relationAddAction = new RelationAddAction();
        this.refreshAction = new RefreshAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.activitiesTitle, (Action[])new Action[]{this.refreshAction, this.relationAddAction, this.showActionsAction});
        this.relationForm = new RelationForm();
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.activitiesTable.createScrollPane(), "Center");
        this.add((Component)((Object)this.relationForm), "South");
        this.updateLocalization();
    }

    private void doActivityView() {
        int n = this.activitiesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.activitiesTable.getActivityIdAt(this.activitiesTable.convertRowIndexToModel(n));
        new CrmPlugin.ActivityFormAction(l).actionPerformed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        this.activitiesTable.setEnabled(false);
        this.activitiesTable.clearRows();
        this.updateTitle();
        final ArrayList<DbCrmActivity> arrayList = new ArrayList<DbCrmActivity>();
        try {
            DbCrmCalendarHandler dbCrmCalendarHandler = CrmCalendarUtils.getCrmCalendarHandler();
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            DbCrmActivityCalendarEntry[] dbCrmActivityCalendarEntryArray = dbCrmCalendarHandler.getActivityCalendarEntries(connection, 0L, this.currentCalendarEntry.id);
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (DbCrmActivityCalendarEntry dbCrmActivityCalendarEntry : dbCrmActivityCalendarEntryArray) {
                arrayList2.add(dbCrmActivityCalendarEntry.crmActivityId);
            }
            long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0]));
            DbCrmActivity[] dbCrmActivityArray = dbCrmActivityHandler.getActivities(connection, lArray);
            arrayList.addAll(Arrays.asList(dbCrmActivityArray));
        }
        finally {
            this.activitiesTable.setEnabled(true);
            this.showActionsAction.setEnabled(false);
        }
        if (!arrayList.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (DbCrmActivity dbCrmActivity : arrayList) {
                            CrmCalendarEntryActivitiesPanel.this.activitiesTable.addRow((AbstractTable.Row)new CrmActivityTable.Row(dbCrmActivity));
                        }
                    }
                    finally {
                        CrmCalendarEntryActivitiesPanel.this.updateTitle();
                    }
                }
            });
        }
    }

    private void doRefresh() {
        try {
            this.load(this.currentCalendarEntry);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload activities for calendar entry!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload activities for calendar entry!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doRelationAdd() {
        this.relationForm.selectEmptyRelation();
    }

    private void doRelationRemove() {
        if (this.activitiesTable.removeSelectedRows()) {
            this.relationForm.unselectRelation();
            this.updateTitle();
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.activitiesTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem((Action)((Object)new ActivityViewAction())));
        jPopupMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("activities"));
    }

    public boolean isLoadedInBackground() {
        return this.currentCalendarEntry != null && this.currentCalendarEntry.id > 0L;
    }

    public void load(DbCalendarEntry dbCalendarEntry) throws ImmoToolException {
        this.currentCalendarEntry = dbCalendarEntry;
        this.relationForm.unselectRelation();
        this.activitiesTable.setEnabled(false);
        this.activitiesTable.clearSelection();
        this.activitiesTable.clearRows();
        this.showActionsAction.setEnabled(false);
        this.updateTitle();
    }

    public void save(DbCalendarEntry dbCalendarEntry) throws ImmoToolException {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCalendarEntry dbCalendarEntry) throws SQLException, IOException {
        Object object2;
        DbCrmCalendarHandler dbCrmCalendarHandler = CrmCalendarUtils.getCrmCalendarHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbCrmCalendarHandler.getActivityCalendarEntries(connection, 0L, dbCalendarEntry.id);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object2 : objectArray) {
                hashMap.put(((DbCrmActivityCalendarEntry)object2).crmActivityId, object2);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.activitiesTable.getRowCount(); ++i) {
            Long l = this.activitiesTable.getActivityIdAt(i);
            if (!hashMap.containsKey(l)) {
                object2 = new DbCrmActivityCalendarEntry();
                ((DbCrmActivityCalendarEntry)object2).crmActivityId = l;
                ((DbCrmActivityCalendarEntry)object2).calendarEntryId = dbCalendarEntry.id;
                dbCrmCalendarHandler.saveActivityCalendarEntries(connection, (DbCrmActivityCalendarEntry)object2);
                hashMap.put(l, object2);
            }
            arrayList.add(l);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Long)entry.getKey();
            if (arrayList.contains(object2)) continue;
            dbCrmCalendarHandler.removeActivityCalendarEntry(connection, (DbCrmActivityCalendarEntry)entry.getValue());
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateTitle();
    }

    private void updateTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("activities for the calendar entry"));
        int n2 = n = this.activitiesTable != null ? this.activitiesTable.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        this.activitiesTitle.setTitle(string);
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        public ShowActionsAction() {
            this.setSmallIcon(CrmPlugin.getResourceIcon((String)"crm.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CrmCalendarEntryActivitiesPanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        public RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmCalendarEntryActivitiesPanel.this.doRelationRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        public RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmCalendarEntryActivitiesPanel.this.doRelationAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CrmCalendarEntryActivitiesPanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        public RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmCalendarEntryActivitiesPanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class ActivityViewAction
    extends AbstractI18nAction {
        public ActivityViewAction() {
            this.setSmallIcon(CrmPlugin.getResourceIcon((String)"crm.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmCalendarEntryActivitiesPanel.this.doActivityView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show activity")));
            this.setShortDescription(I18N.tr("Show details about the activity."));
        }
    }

    private class RelationTable
    extends CrmActivityTable<CrmActivityTable.Row> {
        public RelationTable() {
            super(CrmCalendarEntryActivitiesPanel.RELATION_TABLE_ID);
        }

        protected void doRemove() {
            CrmCalendarEntryActivitiesPanel.this.doRelationRemove();
        }

        protected void doSelect() {
            CrmCalendarEntryActivitiesPanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CrmCalendarEntryActivitiesPanel.this.relationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                CrmCalendarEntryActivitiesPanel.this.relationForm.selectRelation(this.getActivityAt(n), null);
            }
        }

        protected void doShowActions(int n, int n2) {
            CrmCalendarEntryActivitiesPanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmCalendarEntryActivitiesPanel.this.doActivityView();
        }
    }

    private class RelationForm
    extends CrmActivityRelationPanel {
        private RelationForm() {
            super(false);
        }

        protected void close() {
            if (CrmCalendarEntryActivitiesPanel.this.activitiesTable.getSelectedRowCount() > 0) {
                CrmCalendarEntryActivitiesPanel.this.activitiesTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbCrmActivity dbCrmActivity, String string) {
            if (dbCrmActivity == null) {
                return false;
            }
            CrmCalendarEntryActivitiesPanel.this.activitiesTable.setEnabled(false);
            try {
                if (this.getCurrentCrmActivityId() < 1L) {
                    CrmCalendarEntryActivitiesPanel.this.activitiesTable.addRow((AbstractTable.Row)new CrmActivityTable.Row(dbCrmActivity));
                } else {
                    int n = CrmCalendarEntryActivitiesPanel.this.activitiesTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = CrmCalendarEntryActivitiesPanel.this.activitiesTable.convertRowIndexToModel(n);
                        CrmCalendarEntryActivitiesPanel.this.activitiesTable.setRowAt(n2, (AbstractTable.Row)new CrmActivityTable.Row(dbCrmActivity));
                    }
                }
            }
            finally {
                CrmCalendarEntryActivitiesPanel.this.activitiesTable.clearSelection();
                CrmCalendarEntryActivitiesPanel.this.activitiesTable.setEnabled(true);
                CrmCalendarEntryActivitiesPanel.this.updateTitle();
            }
            return true;
        }
    }
}

