/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.calendar;

import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarEntry;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import java.awt.Color;
import java.awt.Image;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import org.jdesktop.swingx.calendar.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmActivityCalendarEntry
extends VirtualCalendarEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityCalendarEntry.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityCalendarEntry.class);
    private final DbCrmActivity activity;

    public CrmActivityCalendarEntry(DbCrmActivity dbCrmActivity, VirtualCalendarExtension virtualCalendarExtension) {
        super(virtualCalendarExtension);
        this.activity = dbCrmActivity;
    }

    public DbCrmActivity getActivity() {
        return this.activity;
    }

    public Date getBegin() {
        return this.activity.begin;
    }

    public Color getColor() {
        return Color.CYAN;
    }

    public Date getEnd() {
        DbCrmActivity.Type type = this.activity.type;
        if (type != null && !type.supportsEndDate()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.activity.begin);
            calendar.add(12, 30);
            return calendar.getTime();
        }
        return this.activity.end != null ? this.activity.end : DateUtils.endOfDay((Date)this.activity.begin);
    }

    public ImageIcon getIcon() {
        DbCrmActivity.Type type = this.activity.type;
        Image image = type != null ? type.getImage(16) : null;
        return new ImageIcon(image != null ? image : CrmPlugin.getResourceImage((String)"crm.png", (int)16));
    }

    public String getInfo() {
        if (this.activity.type == null) {
            return null;
        }
        if (this.activity.begin == null) {
            return null;
        }
        if (!this.activity.type.supportsEndDate() || this.activity.end == null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
            return this.activity.type.getTranslation() + " " + I18N.tr("at {0}", (Object)dateFormat.format(this.activity.begin));
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        return this.activity.type.getTranslation() + " " + I18N.tr("from {0} until {1}", (Object)dateFormat.format(this.activity.begin), (Object)dateFormat.format(this.activity.end));
    }

    public String getSubTitle() {
        return this.activity.type != null ? this.activity.type.getTranslation() : null;
    }

    public String getTitle() {
        return this.activity.subject;
    }
}

